/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.api.java;

import java.util.Comparator;
import java.util.Set;
import java.util.regex.Pattern;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.openide.filesystems.FileObject;

public abstract class SourceClassInfo {
    public static final Comparator<SourceClassInfo> COMPARATOR = new Comparator<SourceClassInfo>(){

        @Override
        public int compare(SourceClassInfo sourceClassInfo, SourceClassInfo sourceClassInfo2) {
            return sourceClassInfo.getVMName().compareTo(sourceClassInfo2.getVMName());
        }
    };
    private static final Pattern anonymousInnerClassPattern = Pattern.compile(".*?\\$[0-9]*$");
    private String simpleName;
    private String qualName;
    private String vmName;

    public SourceClassInfo(String string, String string2, String string3) {
        this.simpleName = string;
        this.qualName = string2;
        this.vmName = string3;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SourceClassInfo sourceClassInfo = (SourceClassInfo)object;
        return !(this.vmName == null ? sourceClassInfo.vmName != null : !this.vmName.equals(sourceClassInfo.vmName));
    }

    public int hashCode() {
        int n = 5;
        n = 53 * n + (this.vmName != null ? this.vmName.hashCode() : 0);
        return n;
    }

    public final String getSimpleName() {
        return this.simpleName;
    }

    public final String getQualifiedName() {
        return this.qualName;
    }

    public final String getVMName() {
        return this.vmName;
    }

    public boolean isAnonymous() {
        return this.isAnonymous(this.qualName);
    }

    public abstract FileObject getFile();

    public abstract Set<SourceMethodInfo> getMethods(boolean var1);

    public abstract Set<SourceClassInfo> getSubclasses();

    public abstract Set<SourceClassInfo> getInnerClases();

    public abstract Set<SourceMethodInfo> getConstructors();

    public abstract SourceClassInfo getSuperType();

    public abstract Set<SourceClassInfo> getInterfaces();

    protected final boolean isAnonymous(String string) {
        return anonymousInnerClassPattern.matcher(string).matches();
    }
}

