/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjLivenessTermCCTNode;
import org.netbeans.lib.profiler.results.memory.SurvGenSet;

public class PresoObjLivenessCCTNode
extends PresoObjAllocCCTNode {
    static int currentEpoch;
    public static final int SORT_BY_LIVE_OBJ_SIZE = 1;
    public static final int SORT_BY_LIVE_OBJ_NUMBER = 2;
    public static final int SORT_BY_ALLOC_OBJ = 3;
    public static final int SORT_BY_AVG_AGE = 4;
    public static final int SORT_BY_SURV_GEN = 5;
    public static final int SORT_BY_NAME = 6;
    public static final int SORT_BY_TOTAL_ALLOC_OBJ = 7;
    private static boolean dontShowZeroLiveObjNodes;
    public float avgObjectAge;
    public int nLiveObjects;
    public int survGen;
    public int nTotalAllocObjects = -1;

    public static PresoObjLivenessCCTNode rootNode(PresoObjLivenessCCTNode[] presoObjLivenessCCTNodeArray) {
        PresoObjLivenessCCTNode presoObjLivenessCCTNode = new PresoObjLivenessCCTNode();
        presoObjLivenessCCTNode.setChildren(presoObjLivenessCCTNodeArray);
        return presoObjLivenessCCTNode;
    }

    public PresoObjLivenessCCTNode(String string, long l, long l2, int n, int n2, float f, int n3) {
        super(string, l, l2);
        this.nLiveObjects = n;
        this.nTotalAllocObjects = n2;
        this.avgObjectAge = f;
        this.survGen = n3;
    }

    PresoObjLivenessCCTNode() {
    }

    protected PresoObjLivenessCCTNode(RuntimeMemoryCCTNode runtimeMemoryCCTNode) {
        super(runtimeMemoryCCTNode);
    }

    @Override
    public PresoObjLivenessCCTNode createFilteredNode() {
        PresoObjLivenessCCTNode presoObjLivenessCCTNode = new PresoObjLivenessCCTNode();
        this.setupFilteredNode(presoObjLivenessCCTNode);
        return presoObjLivenessCCTNode;
    }

    protected void setupFilteredNode(PresoObjLivenessCCTNode presoObjLivenessCCTNode) {
        super.setupFilteredNode(presoObjLivenessCCTNode);
        presoObjLivenessCCTNode.nLiveObjects = this.nLiveObjects;
        presoObjLivenessCCTNode.avgObjectAge = this.avgObjectAge;
        presoObjLivenessCCTNode.survGen = this.survGen;
    }

    @Override
    public void merge(CCTNode cCTNode) {
        if (cCTNode instanceof PresoObjLivenessCCTNode) {
            PresoObjLivenessCCTNode presoObjLivenessCCTNode = (PresoObjLivenessCCTNode)cCTNode;
            this.nLiveObjects += presoObjLivenessCCTNode.nLiveObjects;
            this.avgObjectAge = Math.max(this.avgObjectAge, presoObjLivenessCCTNode.avgObjectAge);
            this.survGen = Math.max(this.survGen, presoObjLivenessCCTNode.survGen);
            super.merge(cCTNode);
        }
    }

    public static PresoObjLivenessCCTNode createPresentationCCTFromSnapshot(LivenessMemoryResultsSnapshot livenessMemoryResultsSnapshot, RuntimeMemoryCCTNode runtimeMemoryCCTNode, String string, int n, boolean bl) {
        currentEpoch = n;
        dontShowZeroLiveObjNodes = bl;
        SurvGenSet survGenSet = new SurvGenSet();
        PresoObjLivenessCCTNode presoObjLivenessCCTNode = PresoObjLivenessCCTNode.generateMirrorNode(runtimeMemoryCCTNode, survGenSet);
        if (presoObjLivenessCCTNode != null) {
            PresoObjLivenessCCTNode.assignNamesToNodesFromSnapshot(livenessMemoryResultsSnapshot.getJMethodIdTable(), presoObjLivenessCCTNode, string);
        }
        return presoObjLivenessCCTNode;
    }

    public static PresoObjAllocCCTNode createPresentationCCTFromVM(ProfilerClient profilerClient, RuntimeMemoryCCTNode runtimeMemoryCCTNode, String string, int n, boolean bl) throws ClientUtils.TargetAppOrVMTerminated {
        currentEpoch = n;
        dontShowZeroLiveObjNodes = bl;
        SurvGenSet survGenSet = new SurvGenSet();
        PresoObjLivenessCCTNode presoObjLivenessCCTNode = PresoObjLivenessCCTNode.generateMirrorNode(runtimeMemoryCCTNode, survGenSet);
        if (presoObjLivenessCCTNode != null) {
            PresoObjLivenessCCTNode.assignNamesToNodesFromVM(profilerClient, presoObjLivenessCCTNode, string);
        }
        return presoObjLivenessCCTNode;
    }

    @Override
    public void sortChildren(int n, boolean bl) {
    }

    protected static PresoObjLivenessCCTNode generateMirrorNode(RuntimeMemoryCCTNode runtimeMemoryCCTNode, SurvGenSet survGenSet) {
        RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray;
        int n;
        Object object;
        PresoObjLivenessCCTNode presoObjLivenessCCTNode = null;
        if (runtimeMemoryCCTNode instanceof RuntimeObjLivenessTermCCTNode) {
            object = (RuntimeObjLivenessTermCCTNode)runtimeMemoryCCTNode;
            int n2 = ((RuntimeObjLivenessTermCCTNode)object).calculateTotalNLiveObjects();
            if (dontShowZeroLiveObjNodes && n2 == 0 && runtimeMemoryCCTNode.children == null) {
                return null;
            }
            presoObjLivenessCCTNode = new PresoObjLivenessCCTNode(runtimeMemoryCCTNode);
            presoObjLivenessCCTNode.nLiveObjects = n2;
            RuntimeObjLivenessTermCCTNode.calculateTotalNumberOfSurvGens((RuntimeMemoryCCTNode)object, survGenSet);
            presoObjLivenessCCTNode.survGen = survGenSet.getTotalNoOfAges();
            presoObjLivenessCCTNode.avgObjectAge = RuntimeObjLivenessTermCCTNode.calculateAvgObjectAgeForAllPaths((RuntimeMemoryCCTNode)object, currentEpoch);
            if (runtimeMemoryCCTNode.children != null) {
                n = runtimeMemoryCCTNode.children instanceof RuntimeMemoryCCTNode ? 1 : ((RuntimeMemoryCCTNode[])runtimeMemoryCCTNode.children).length;
                presoObjLivenessCCTNode.children = new PresoObjAllocCCTNode[n];
            }
        }
        if ((object = runtimeMemoryCCTNode.children) != null && (n = (runtimeMemoryCCTNodeArray = object instanceof RuntimeMemoryCCTNode ? new RuntimeMemoryCCTNode[]{(RuntimeMemoryCCTNode)object} : (RuntimeMemoryCCTNode[])object).length) > 0) {
            double d = 0.0;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                SurvGenSet survGenSet2 = n == 1 ? survGenSet : new SurvGenSet();
                PresoObjLivenessCCTNode presoObjLivenessCCTNode2 = PresoObjLivenessCCTNode.generateMirrorNode(runtimeMemoryCCTNodeArray[i], survGenSet2);
                if (presoObjLivenessCCTNode2 == null) continue;
                if (presoObjLivenessCCTNode == null) {
                    presoObjLivenessCCTNode = new PresoObjLivenessCCTNode(runtimeMemoryCCTNode);
                    presoObjLivenessCCTNode.children = new PresoObjAllocCCTNode[n];
                }
                presoObjLivenessCCTNode.children[n3++] = presoObjLivenessCCTNode2;
                presoObjLivenessCCTNode2.parent = presoObjLivenessCCTNode;
                presoObjLivenessCCTNode.nCalls += presoObjLivenessCCTNode2.nCalls;
                presoObjLivenessCCTNode.totalObjSize += presoObjLivenessCCTNode2.totalObjSize;
                presoObjLivenessCCTNode.nLiveObjects += presoObjLivenessCCTNode2.nLiveObjects;
                d += (double)(presoObjLivenessCCTNode2.avgObjectAge * (float)presoObjLivenessCCTNode2.nLiveObjects);
                if (n <= 1) continue;
                survGenSet.mergeWith(survGenSet2);
            }
            if (dontShowZeroLiveObjNodes && (presoObjLivenessCCTNode == null || presoObjLivenessCCTNode.nLiveObjects == 0)) {
                return null;
            }
            if (n3 < n) {
                PresoObjAllocCCTNode[] presoObjAllocCCTNodeArray = new PresoObjAllocCCTNode[n3];
                System.arraycopy(presoObjLivenessCCTNode.children, 0, presoObjAllocCCTNodeArray, 0, n3);
                presoObjLivenessCCTNode.children = presoObjAllocCCTNodeArray;
            }
            presoObjLivenessCCTNode.avgObjectAge = presoObjLivenessCCTNode.nLiveObjects > 0 ? (float)(d / (double)presoObjLivenessCCTNode.nLiveObjects) : 0.0f;
            presoObjLivenessCCTNode.survGen = survGenSet.getTotalNoOfAges();
        }
        return presoObjLivenessCCTNode;
    }

    @Override
    public void exportXMLData(ExportDataDumper exportDataDumper, String string) {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(string + "<Node>" + string2);
        stringBuffer.append(string).append(" <Name>").append(this.replaceHTMLCharacters(this.getNodeName())).append("</Name>").append(string2);
        stringBuffer.append(string).append(" <Parent>").append(this.replaceHTMLCharacters(this.getParent() == null ? "none" : ((PresoObjAllocCCTNode)this.getParent()).getNodeName())).append("</Parent>").append(string2);
        stringBuffer.append(string).append(" <Live_Bytes>").append(this.totalObjSize).append("</Live_Bytes>").append(string2);
        stringBuffer.append(string).append(" <Live_Objects>").append(this.nLiveObjects).append("</Live_Objects>").append(string2);
        stringBuffer.append(string).append(" <Allocated_Objects>").append(this.nCalls).append("</Allocated_Objects>").append(string2);
        stringBuffer.append(string).append(" <Avg_Age>").append(this.avgObjectAge).append("</Avg_Age>").append(string2);
        stringBuffer.append(string).append(" <Generations>").append(this.survGen).append("</Generations>").append(string2);
        exportDataDumper.dumpData(stringBuffer);
        if (this.children != null) {
            for (int i = 0; i < this.getNChildren(); ++i) {
                this.children[i].exportXMLData(exportDataDumper, string + " ");
            }
        }
        stringBuffer = new StringBuffer(string + "</Node>");
        exportDataDumper.dumpData(stringBuffer);
    }

    @Override
    public void exportHTMLData(ExportDataDumper exportDataDumper, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("<tr><td class=\"method\"><pre class=\"method\">");
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(".");
        }
        stringBuffer.append(this.replaceHTMLCharacters(this.getNodeName())).append("</pre></td><td class=\"right\">").append(this.totalObjSize).append("</td><td class=\"right\">").append(this.nLiveObjects).append("</td><td class=\"right\">").append(this.nCalls).append("</td><td class=\"right\">").append(this.avgObjectAge).append("</td><td class=\"right\">").append(this.survGen).append("</td><td class=\"parent\"><pre class=\"parent\">").append(this.replaceHTMLCharacters(this.getParent() == null ? "none" : ((PresoObjAllocCCTNode)this.getParent()).getNodeName())).append("</pre></td></tr>");
        exportDataDumper.dumpData(stringBuffer);
        if (this.children != null) {
            for (n2 = 0; n2 < this.children.length; ++n2) {
                this.children[n2].exportHTMLData(exportDataDumper, n + 1);
            }
        }
    }

    private String replaceHTMLCharacters(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void exportCSVData(String string, int n, ExportDataDumper exportDataDumper) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "\r\n";
        String string3 = "\"";
        String string4 = " ";
        stringBuffer.append(string3);
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(string4);
        }
        stringBuffer.append(this.getNodeName()).append(string3).append(string);
        stringBuffer.append(string3).append(this.totalObjSize).append(string3).append(string);
        stringBuffer.append(string3).append(this.nLiveObjects).append(string3).append(string);
        stringBuffer.append(string3).append(this.nCalls).append(string3).append(string);
        stringBuffer.append(string3).append(this.survGen).append(string3).append(string);
        stringBuffer.append(string3).append(this.getParent() == null ? "none" : ((PresoObjAllocCCTNode)this.getParent()).getNodeName()).append(string2);
        exportDataDumper.dumpData(stringBuffer);
        if (this.children != null) {
            for (n2 = 0; n2 < this.children.length; ++n2) {
                ((PresoObjLivenessCCTNode)this.children[n2]).exportCSVData(string, n + 1, exportDataDumper);
            }
        }
    }

    public void setDecimalFormat() {
    }
}

