/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.LogBuilder;

public class Occupation {
    public WorkLocation workLocation;
    public ProductionType productionType;
    public GoodsType workType;

    public Occupation(WorkLocation workLocation, ProductionType productionType, GoodsType workType) {
        this.workLocation = workLocation;
        this.productionType = productionType;
        this.workType = workType;
    }

    public boolean install(Unit unit) {
        if (!unit.setLocation(this.workLocation)) {
            return false;
        }
        if (this.productionType != this.workLocation.getProductionType()) {
            this.workLocation.setProductionType(this.productionType);
        }
        if (this.workType != unit.getWorkType()) {
            unit.changeWorkType(this.workType);
        }
        return true;
    }

    private int improve(UnitType unitType, WorkLocation wl, int bestAmount, Collection<GoodsType> workTypes, boolean alone, LogBuilder lb) {
        lb.add(" alone=", alone);
        ArrayList<ProductionType> productionTypes = new ArrayList<ProductionType>();
        if (alone) {
            productionTypes.addAll(wl.getAvailableProductionTypes(false));
        } else {
            productionTypes.add(wl.getProductionType());
        }
        Colony colony = wl.getColony();
        for (ProductionType pt : productionTypes) {
            lb.add("\n      try=", pt);
            if (pt == null) continue;
            for (GoodsType gt : workTypes) {
                if (pt.getOutput(gt) == null) continue;
                int minInput = Integer.MAX_VALUE;
                List<AbstractGoods> inputs = pt.getInputs();
                for (AbstractGoods ag : inputs) {
                    int input = Math.max(colony.getGoodsCount(ag.getType()), colony.getNetProductionOf(ag.getType()));
                    minInput = Math.min(minInput, input);
                }
                int potential = wl.getPotentialProduction(gt, unitType);
                int amount = Math.min(minInput, potential);
                lb.add(" ", gt.getSuffix(), "=", amount, "/", minInput, "/", potential, bestAmount < amount ? "!" : "");
                if (bestAmount >= amount) continue;
                bestAmount = amount;
                this.workLocation = wl;
                this.productionType = pt;
                this.workType = gt;
            }
        }
        return bestAmount;
    }

    public int improve(Unit unit, WorkLocation wl, int bestAmount, Collection<GoodsType> workTypes, LogBuilder lb) {
        boolean present = unit.getLocation() == wl;
        lb.add("\n    ", wl, !present && !wl.canAdd(unit) ? " no-add" : "");
        if (!present && !wl.canAdd(unit)) {
            return bestAmount;
        }
        boolean alone = wl.getProductionType() == null || wl.isEmpty() || present && wl.getUnitCount() == 1;
        return this.improve(unit.getType(), wl, bestAmount, workTypes, alone, lb);
    }

    public int improve(UnitType unitType, WorkLocation wl, int bestAmount, Collection<GoodsType> workTypes, LogBuilder lb) {
        return this.improve(unitType, wl, bestAmount, workTypes, wl.isEmpty(), lb);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("[Occupation ").append(this.workLocation);
        if (this.workType != null) {
            sb.append(" ").append(this.workType.getSuffix());
        }
        sb.append("]");
        return sb.toString();
    }
}

