/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine.memory.shrinking;

import java.util.Set;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.engine.control.event.behavior.ElementEventType;
import org.apache.commons.jcs3.engine.memory.behavior.IMemoryCache;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class ShrinkerThread<K, V>
implements Runnable {
    private static final Log log = LogManager.getLog(ShrinkerThread.class);
    private final CompositeCache<K, V> cache;
    private final long maxMemoryIdleTime;
    private final int maxSpoolPerRun;
    private boolean spoolLimit = false;

    public ShrinkerThread(CompositeCache<K, V> cache) {
        this.cache = cache;
        long maxMemoryIdleTimeSeconds = cache.getCacheAttributes().getMaxMemoryIdleTimeSeconds();
        this.maxMemoryIdleTime = maxMemoryIdleTimeSeconds < 0L ? -1L : maxMemoryIdleTimeSeconds * 1000L;
        this.maxSpoolPerRun = cache.getCacheAttributes().getMaxSpoolPerRun();
        if (this.maxSpoolPerRun != -1) {
            this.spoolLimit = true;
        }
    }

    @Override
    public void run() {
        this.shrink();
    }

    protected void shrink() {
        log.debug("Shrinking memory cache for: {0}", () -> this.cache.getCacheName());
        IMemoryCache<K, V> memCache = this.cache.getMemoryCache();
        try {
            Set<K> keys = memCache.getKeySet();
            int size = keys.size();
            log.debug("Keys size: {0}", size);
            int spoolCount = 0;
            for (K key : keys) {
                ICacheElement<K, V> cacheElement = memCache.getQuiet(key);
                if (cacheElement == null) continue;
                IElementAttributes attributes = cacheElement.getElementAttributes();
                boolean remove = false;
                long now = System.currentTimeMillis();
                if (!attributes.getIsEternal() && (remove = this.cache.isExpired(cacheElement, now, ElementEventType.EXCEEDED_MAXLIFE_BACKGROUND, ElementEventType.EXCEEDED_IDLETIME_BACKGROUND))) {
                    memCache.remove(key);
                }
                if (remove || this.maxMemoryIdleTime == -1L) continue;
                if (!this.spoolLimit || spoolCount < this.maxSpoolPerRun) {
                    long lastAccessTime = attributes.getLastAccessTime();
                    if (lastAccessTime + this.maxMemoryIdleTime >= now) continue;
                    log.debug("Exceeded memory idle time: {0}", key);
                    ++spoolCount;
                    memCache.remove(key);
                    memCache.waterfal(cacheElement);
                    continue;
                }
                log.debug("spoolCount = \"{0}\"; maxSpoolPerRun = \"{1}\"", spoolCount, this.maxSpoolPerRun);
                if (!this.spoolLimit || spoolCount < this.maxSpoolPerRun) continue;
                return;
            }
        }
        catch (Throwable t) {
            log.info("Unexpected trouble in shrink cycle", t);
            return;
        }
    }
}

