/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.Image;
import java.io.File;
import java.util.Collections;
import java.util.Objects;
import org.openstreetmap.josm.data.gpx.GpxImageEntry;
import org.openstreetmap.josm.gui.layer.geoimage.ThumbsLoader;

public final class ImageEntry
extends GpxImageEntry {
    private Image thumbnail;

    public ImageEntry() {
    }

    public ImageEntry(ImageEntry other) {
        super(other);
        this.thumbnail = other.thumbnail;
    }

    public ImageEntry(File file) {
        super(file);
    }

    public boolean hasThumbnail() {
        return this.thumbnail != null;
    }

    public Image getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(Image thumbnail) {
        this.thumbnail = thumbnail;
    }

    public void loadThumbnail() {
        if (this.thumbnail == null) {
            new ThumbsLoader(Collections.singleton(this)).run();
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.thumbnail);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        ImageEntry other = (ImageEntry)obj;
        return Objects.equals(this.thumbnail, other.thumbnail);
    }
}

