Clazz.declarePackage ("J.adapter.readers.cif");
Clazz.load (["J.adapter.readers.cif.CifReader", "JU.Lst"], "J.adapter.readers.cif.TopoCifParser", ["java.lang.Float", "JU.BS", "$.P3", "$.V3", "J.adapter.readers.cif.Cif2DataParser"], function () {
c$ = Clazz.decorateAsClass (function () {
this.reader = null;
this.cifParser = null;
this.types = null;
this.links = null;
if (!Clazz.isClassDefined ("J.adapter.readers.cif.TopoCifParser.TopoLink")) {
J.adapter.readers.cif.TopoCifParser.$TopoCifParser$TopoLink$ ();
}
if (!Clazz.isClassDefined ("J.adapter.readers.cif.TopoCifParser.TopoPrimitive")) {
J.adapter.readers.cif.TopoCifParser.$TopoCifParser$TopoPrimitive$ ();
}
this.bondlist = "";
Clazz.instantialize (this, arguments);
}, J.adapter.readers.cif, "TopoCifParser", null, J.adapter.readers.cif.CifReader.Parser);
Clazz.prepareFields (c$, function () {
this.links =  new JU.Lst ();
});
Clazz.makeConstructor (c$, 
function () {
});
Clazz.overrideMethod (c$, "setReader", 
function (reader) {
if (reader.checkFilterKey ("TOPOS_IGNORE")) {
return this;
}this.reader = reader;
this.cifParser = reader.cifParser;
this.types = reader.getFilter ("TOPOS_TYPES");
if (this.types != null && this.types.length > 1) this.types = "+" + this.types.substring (1).toLowerCase () + "+";
if (reader.doApplySymmetry) reader.asc.setNoAutoBond ();
return this;
}, "J.adapter.readers.cif.CifReader");
Clazz.overrideMethod (c$, "finalizeReader", 
function () {
return false;
});
c$.isEqualD = Clazz.defineMethod (c$, "isEqualD", 
function (p1, p2, d, err) {
return Math.abs (p1.distance (p2) - d) < err;
}, "JU.T3,JU.T3,~N,~N");
Clazz.overrideMethod (c$, "finalizeSymmetry", 
function (haveSymmetry) {
if (this.reader == null || !haveSymmetry || !this.reader.doApplySymmetry) return;
var sym = this.reader.asc.getXSymmetry ().getBaseSymmetry ();
var nLinks = this.links.size ();
var nOps = sym.getSpaceGroupOperationCount ();
var operations =  new Array (nOps);
for (var i = 0; i < nOps; i++) {
operations[i] = sym.getSpaceGroupOperationRaw (i);
}
var carts =  new Array (this.reader.asc.ac);
var atoms = this.reader.asc.atoms;
for (var i = this.reader.asc.ac; --i >= 0; ) {
carts[i] = JU.P3.newP (atoms[i]);
sym.toCartesian (carts[i], true);
}
var n = 0;
var bsConnected =  new JU.BS ();
for (var i = 0; i < nLinks; i++) {
var link = this.links.get (i);
link.setPrimitives (sym, operations);
n += this.setBonds (i, atoms, carts, link, sym, nOps, bsConnected);
}
if (bsConnected.cardinality () > 0) this.reader.asc.bsAtoms = bsConnected;
this.reader.appendLoadNote ("TopoCifParser created " + n + " edges and " + bsConnected.cardinality () + " nodes");
}, "~B");
Clazz.defineMethod (c$, "setBonds", 
 function (index, atoms, carts, link, sym, nOps, bsConnected) {
var nbonds = 0;
var bs1 =  new JU.BS ();
var bs2 =  new JU.BS ();
for (var i = this.reader.asc.ac; --i >= 0; ) {
var a = atoms[i];
if (a.atomSite == link.a1.atomSite) {
bs1.set (i);
}if (a.atomSite == link.a2.atomSite) {
bs2.set (i);
}}
var pa =  new JU.P3 ();
var bsym =  new JU.BS ();
for (var i1 = bs1.nextSetBit (0); i1 >= 0; i1 = bs1.nextSetBit (i1 + 1)) {
var at1 = atoms[i1];
bsym.clearAll ();
for (var i = 0; i < nOps; i++) {
var prim = link.primitives[i];
if (prim == null) continue;
pa.setT (at1);
sym.unitize (pa);
if (J.adapter.readers.cif.TopoCifParser.isEqualD (pa, prim.p1u, 0, 0.001)) bsym.set (i);
}
for (var i2 = bs2.nextSetBit (0); i2 >= 0; i2 = bs2.nextSetBit (i2 + 1)) {
var at2 = atoms[i2];
if (i1 == i2 || !J.adapter.readers.cif.TopoCifParser.isEqualD (carts[i1], carts[i2], link.d, 0.001)) continue;
var va12 = JU.V3.newVsub (at2, at1);
for (var i = bsym.nextSetBit (0); i >= 0; i = bsym.nextSetBit (i + 1)) {
if (!J.adapter.readers.cif.TopoCifParser.isEqualD (va12, link.primitives[i].v12f, 0, 0.001)) continue;
var key = "," + at1.index + "," + at2.index + "," + at1.index + ",";
if (this.bondlist.indexOf (key) >= 0) continue;
this.bondlist += key;
nbonds++;
this.reader.asc.addNewBondWithOrderA (at1, at2, link.order);
bsConnected.set (at1.index);
bsConnected.set (at2.index);
}
}
}
return nbonds;
}, "~N,~A,~A,J.adapter.readers.cif.TopoCifParser.TopoLink,J.api.SymmetryInterface,~N,JU.BS");
Clazz.overrideMethod (c$, "processBlock", 
function (key) {
if (this.reader == null) return;
if (this.reader.ucItems != null) {
this.reader.allow_a_len_1 = true;
for (var i = 0; i < 6; i++) this.reader.setUnitCellItem (i, this.reader.ucItems[i]);

}this.reader.parseLoopParameters (J.adapter.readers.cif.TopoCifParser.topolFields);
while (this.cifParser.getData ()) {
var type = this.reader.getField (11);
if (this.types == null ? "vw".equals (type) : this.types.indexOf ("+" + type + "+") < 0) continue;
var t1 =  Clazz.newDoubleArray (3, 0);
var t2 =  Clazz.newDoubleArray (3, 0);
var a1 = null;
var a2 = null;
var name1 = null;
var name2 = null;
if ((a1 = this.reader.asc.getAtomFromName (name1 = this.reader.getField (0))) == null || (a2 = this.reader.asc.getAtomFromName (name2 = this.reader.getField (1))) == null) {
System.out.println ("TopoCifParser atom " + (a1 == null ? name1 : name2) + " could not be found");
continue;
}var sdist = this.reader.getField (2);
var d = this.reader.parseFloatStr (sdist);
if (!(d > 0)) {
System.out.println ("TopoCifParser invalid distance " + sdist);
continue;
}var op1 = Integer.parseInt (this.reader.getField (3));
var op2 = Integer.parseInt (this.reader.getField (7));
var field;
field = this.reader.getField (14);
if (field.length > 1) {
t1 = J.adapter.readers.cif.Cif2DataParser.getArrayFromStringList (field, 3);
} else {
t1[0] = Float.parseFloat (this.reader.getField (4));
t1[1] = Float.parseFloat (this.reader.getField (5));
t1[2] = Float.parseFloat (this.reader.getField (6));
}field = this.reader.getField (15);
if (field.length > 1) {
t2 = J.adapter.readers.cif.Cif2DataParser.getArrayFromStringList (field, 3);
} else {
t2[0] = Float.parseFloat (this.reader.getField (8));
t2[1] = Float.parseFloat (this.reader.getField (9));
t2[2] = Float.parseFloat (this.reader.getField (10));
}this.links.addLast (Clazz.innerTypeInstance (J.adapter.readers.cif.TopoCifParser.TopoLink, this, null, a1, a2, op1, t1, op2, t2, d, type));
}
}, "~S");
c$.$TopoCifParser$TopoLink$ = function () {
Clazz.pu$h(self.c$);
c$ = Clazz.decorateAsClass (function () {
Clazz.prepareCallback (this, arguments);
this.a1 = null;
this.a2 = null;
this.op1 = 0;
this.op2 = 0;
this.type = null;
this.p1f = null;
this.p2f = null;
this.d = 0;
this.dt = null;
this.order = 0;
this.primitives = null;
Clazz.instantialize (this, arguments);
}, J.adapter.readers.cif.TopoCifParser, "TopoLink");
Clazz.makeConstructor (c$, 
function (a, b, c, d, e, f, g, h) {
this.a1 = a;
this.a2 = b;
this.d = g;
this.op1 = c - 1;
this.op2 = e - 1;
this.type = h;
this.order = ("hb".equals (h) ? 4096 : 1);
this.dt = JU.P3.new3 ((f[0] - d[0]), (f[1] - d[1]), (f[2] - d[2]));
}, "J.adapter.smarter.Atom,J.adapter.smarter.Atom,~N,~A,~N,~A,~N,~S");
Clazz.defineMethod (c$, "setPrimitives", 
function (a, b) {
var c = b.length;
if (this.p1f == null) {
this.p1f = JU.P3.new3 (this.a1.x, this.a1.y, this.a1.z);
this.p2f = JU.P3.new3 (this.a2.x, this.a2.y, this.a2.z);
b[this.op1].rotTrans (this.p1f);
b[this.op2].rotTrans (this.p2f);
this.p2f.add (this.dt);
this.primitives =  new Array (c);
}for (var d = 0; d < c; d++) {
var e = Clazz.innerTypeInstance (J.adapter.readers.cif.TopoCifParser.TopoPrimitive, this, null, this, a, b[d]);
if (!e.isValid) continue;
System.out.println ("TopoCifParser primitive: op=" + d + " " + this.a1.atomName + " " + this.a2.atomName + "\n" + e + "\n" + this);
this.primitives[d] = e;
}
}, "J.api.SymmetryInterface,~A");
Clazz.overrideMethod (c$, "toString", 
function () {
return "[link " + this.a1.atomName + " " + this.a2.atomName + " " + this.d + " " + this.type + "]";
});
c$ = Clazz.p0p ();
};
c$.$TopoCifParser$TopoPrimitive$ = function () {
Clazz.pu$h(self.c$);
c$ = Clazz.decorateAsClass (function () {
Clazz.prepareCallback (this, arguments);
this.op = null;
this.link = null;
this.p1u = null;
this.p2f = null;
this.v12f = null;
this.isValid = false;
Clazz.instantialize (this, arguments);
}, J.adapter.readers.cif.TopoCifParser, "TopoPrimitive");
Clazz.makeConstructor (c$, 
function (a, b, c) {
this.link = a;
this.op = c;
var d;
var e;
d = JU.P3.newP (a.p1f);
e = JU.P3.newP (a.p2f);
b.toCartesian (d, true);
b.toCartesian (e, true);
System.out.println (d.distance (e) + " " + a.p1f + " " + a.p2f);
d.setT (a.p1f);
e.setT (a.p2f);
c.rotTrans (d);
c.rotTrans (e);
this.p1u = JU.P3.newP (d);
b.unitize (this.p1u);
this.p2f = JU.P3.newP (e);
this.p2f.add (JU.V3.newVsub (this.p1u, d));
System.out.println (c + "\n " + d + " " + this.p1u);
this.v12f = JU.V3.newVsub (this.p2f, this.p1u);
d.setT (this.p1u);
e.setT (this.p2f);
b.toCartesian (d, true);
b.toCartesian (e, true);
System.out.println (d.distance (e) + " " + d + " " + e + " " + a.d);
this.isValid = J.adapter.readers.cif.TopoCifParser.isEqualD (d, e, a.d, 0.001);
}, "J.adapter.readers.cif.TopoCifParser.TopoLink,J.api.SymmetryInterface,JU.M4");
Clazz.overrideMethod (c$, "toString", 
function () {
return "" + this.v12f;
});
c$ = Clazz.p0p ();
};
Clazz.defineStatics (c$,
"topolFields",  Clazz.newArray (-1, ["_topol_link_node_label_1", "_topol_link_node_label_2", "_topol_link_distance", "_topol_link_site_symmetry_symop_1", "_topol_link_site_symmetry_translation_1_x", "_topol_link_site_symmetry_translation_1_y", "_topol_link_site_symmetry_translation_1_z", "_topol_link_site_symmetry_symop_2", "_topol_link_site_symmetry_translation_2_x", "_topol_link_site_symmetry_translation_2_y", "_topol_link_site_symmetry_translation_2_z", "_topol_link_type", "_topol_link_multiplicity", "_topol_link_voronoi_solidangle"]),
"topol_link_node_label_1", 0,
"topol_link_node_label_2", 1,
"topol_link_distance", 2,
"topol_link_site_symmetry_symop_1", 3,
"topol_link_site_symmetry_translation_1_x", 4,
"topol_link_site_symmetry_translation_1_y", 5,
"topol_link_site_symmetry_translation_1_z", 6,
"topol_link_site_symmetry_symop_2", 7,
"topol_link_site_symmetry_translation_2_x", 8,
"topol_link_site_symmetry_translation_2_y", 9,
"topol_link_site_symmetry_translation_2_z", 10,
"topol_link_type", 11,
"topol_link_multiplicity", 12,
"topol_link_voronoi_solidangle", 13,
"topol_link_site_symmetry_translation_1", 14,
"topol_link_site_symmetry_translation_2", 15);
});
