/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class LaneDivider
extends AbstractTextBlock {
    private final ISkinParam skinParam;
    private final double x1;
    private final double x2;
    private final double height;
    private Style style;

    public LaneDivider(ISkinParam skinParam, double x1, double x2, double height) {
        this.skinParam = skinParam;
        this.x1 = x1;
        this.x2 = x2;
        this.height = height;
    }

    public StyleSignature getDefaultStyleDefinition() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.swimlane);
    }

    private Style getStyle() {
        if (this.style == null) {
            this.style = this.getDefaultStyleDefinition().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        }
        return this.style;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(this.x1 + this.x2, this.height);
    }

    @Override
    public void drawU(UGraphic ug) {
        UEmpty back = new UEmpty(this.x1 + this.x2, 1.0);
        ug.draw(back);
        HColor color = this.skinParam.getHtmlColor(ColorParam.swimlaneBorder, null, false);
        if (color == null) {
            color = ColorParam.swimlaneBorder.getDefaultValue();
        }
        UStroke thickness = Rose.getStroke(this.skinParam, LineParam.swimlaneBorder, 2.0);
        if (SkinParam.USE_STYLES()) {
            color = this.getStyle().value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
            thickness = this.getStyle().getStroke();
        }
        ug.apply(UTranslate.dx(this.x1)).apply(thickness).apply(color).draw(ULine.vline(this.height));
    }

    public double getWidth() {
        return this.x1 + this.x2;
    }

    public final double getX1() {
        return this.x1;
    }

    public final double getX2() {
        return this.x2;
    }
}

