/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.core;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.utils.StartUtils;
import net.sourceforge.plantuml.version.IteratorCounter2;
import net.sourceforge.plantuml.version.IteratorCounter2Impl;

public final class UmlSource {
    private final List<StringLocated> source;
    private final List<StringLocated> rawSource;

    public UmlSource removeInitialSkinparam() {
        if (!UmlSource.hasInitialSkinparam(this.source)) {
            return this;
        }
        ArrayList<StringLocated> copy = new ArrayList<StringLocated>(this.source);
        while (UmlSource.hasInitialSkinparam(copy)) {
            copy.remove(1);
        }
        return new UmlSource(copy, this.rawSource);
    }

    public boolean containsIgnoreCase(String searched) {
        for (StringLocated s : this.source) {
            if (!StringUtils.goLowerCase(s.getString()).contains(searched)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasInitialSkinparam(List<StringLocated> copy) {
        return copy.size() > 1 && (copy.get(1).getString().startsWith("skinparam ") || copy.get(1).getString().startsWith("skinparamlocked "));
    }

    private UmlSource(List<StringLocated> source, List<StringLocated> rawSource) {
        this.source = source;
        this.rawSource = rawSource;
    }

    public UmlSource(List<StringLocated> data, boolean checkEndingBackslash) {
        this(data, checkEndingBackslash, new ArrayList<StringLocated>());
    }

    public UmlSource(List<StringLocated> data, boolean checkEndingBackslash, List<StringLocated> rawSource) {
        this(new ArrayList<StringLocated>(), rawSource);
        if (checkEndingBackslash) {
            StringBuilder pending = new StringBuilder();
            for (StringLocated cs : data) {
                String s = cs.getString();
                if (StringUtils.endsWithBackslash(s)) {
                    pending.append(s.substring(0, s.length() - 1));
                    continue;
                }
                pending.append(s);
                this.source.add(new StringLocated(pending.toString(), cs.getLocation()));
                pending.setLength(0);
            }
        } else {
            this.source.addAll(data);
        }
    }

    public DiagramType getDiagramType() {
        return DiagramType.getTypeFromArobaseStart(this.source.get(0).getString());
    }

    public IteratorCounter2 iterator2() {
        return new IteratorCounter2Impl(this.source);
    }

    public String getPlainString() {
        StringBuilder sb = new StringBuilder();
        for (StringLocated s : this.source) {
            sb.append(s.getString());
            sb.append('\r');
            sb.append('\n');
        }
        return sb.toString();
    }

    public String getRawString() {
        StringBuilder sb = new StringBuilder();
        for (StringLocated s : this.rawSource) {
            sb.append(s.getString());
            sb.append('\r');
            sb.append('\n');
        }
        return sb.toString();
    }

    public long seed() {
        long h = 1125899906842597L;
        String string = this.getPlainString();
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            h = 31L * h + (long)string.charAt(i);
        }
        return h;
    }

    public String getLine(LineLocation n) {
        for (StringLocated s : this.source) {
            if (s.getLocation().compareTo(n) != 0) continue;
            return s.getString();
        }
        return null;
    }

    public int getTotalLineCount() {
        return this.source.size();
    }

    public boolean getTotalLineCountLessThan5() {
        return this.getTotalLineCount() < 5;
    }

    public boolean isEmpty() {
        for (StringLocated s : this.source) {
            if (StartUtils.isArobaseStartDiagram(s.getString()) || StartUtils.isArobaseEndDiagram(s.getString()) || s.getString().matches("\\s*'.*") || StringUtils.trin(s.getString()).length() == 0) continue;
            return false;
        }
        return true;
    }

    public Display getTitle() {
        Pattern2 p = MyPattern.cmpile("(?i)^[%s]*title[%s]+(.+)$");
        for (StringLocated s : this.source) {
            Matcher2 m = p.matcher(s.getString());
            boolean ok = m.matches();
            if (!ok) continue;
            return Display.create(m.group(1));
        }
        return Display.empty();
    }

    public boolean isStartDef() {
        return this.source.get(0).getString().startsWith("@startdef");
    }

    public String getId() {
        Pattern p = Pattern.compile("id=([\\w]+)\\b");
        Matcher m = p.matcher(this.source.get(0).getString());
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }
}

