/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector2.continuity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;

public class Skeleton {
    private final Set<IEntity> entities = new HashSet<IEntity>();
    private final List<Link> links = new ArrayList<Link>();

    private Set<IEntity> getDirectChildren(IEntity parent) {
        HashSet<IEntity> result = new HashSet<IEntity>();
        for (Link link : this.links) {
            if (link.isAutolink() || link.getEntity1() != parent) continue;
            result.add(link.getEntity2());
        }
        return Collections.unmodifiableSet(result);
    }

    public String toString() {
        return "skeleton " + this.links;
    }

    private Set<IEntity> getIndirectChildren(IEntity parent) {
        HashSet<IEntity> result = new HashSet<IEntity>(this.getDirectChildren(parent));
        int currentSize = result.size();
        while (true) {
            for (IEntity ent : new HashSet<IEntity>(result)) {
                result.addAll(this.getDirectChildren(ent));
            }
            if (result.contains(parent) || result.size() == currentSize) {
                return Collections.unmodifiableSet(result);
            }
            currentSize = result.size();
        }
    }

    private boolean hasCycle() {
        for (IEntity ent : this.entities) {
            if (!this.getIndirectChildren(ent).contains(ent)) continue;
            return true;
        }
        return false;
    }

    public Skeleton removeCycle() {
        Skeleton result = new Skeleton();
        for (Link link : this.links) {
            result.add(link);
            if (!result.hasCycle()) continue;
            result.links.remove(link);
        }
        return result;
    }

    public void add(Link link) {
        if (this.links.contains(link)) {
            throw new IllegalArgumentException();
        }
        if (link.getEntity1().isGroup()) {
            throw new IllegalArgumentException();
        }
        if (link.getEntity2().isGroup()) {
            throw new IllegalArgumentException();
        }
        this.links.add(link);
        this.entities.add(link.getEntity1());
        this.entities.add(link.getEntity2());
    }

    public void addAll(Skeleton other) {
        for (Link otherLink : other.links) {
            this.add(otherLink);
        }
    }

    public boolean doesTouch(Link other) {
        for (Link link : this.links) {
            if (!link.doesTouch(other)) continue;
            return true;
        }
        return false;
    }

    public boolean doesTouch(Skeleton other) {
        for (Link link : this.links) {
            if (!other.doesTouch(link)) continue;
            return true;
        }
        return false;
    }

    public void computeLayers() {
        boolean changed;
        if (this.hasCycle()) {
            throw new UnsupportedOperationException();
        }
        for (IEntity ent : this.entities) {
            ent.setHectorLayer(0);
        }
        do {
            changed = false;
            for (Link link : this.links) {
                if (!this.ensureLayer(link)) continue;
                changed = true;
            }
        } while (changed);
    }

    private boolean ensureLayer(Link link) {
        int lenght = link.getLength();
        int l1 = link.getEntity1().getHectorLayer();
        int l2 = link.getEntity2().getHectorLayer();
        if (lenght == 1) {
            if (l1 < l2) {
                link.getEntity1().setHectorLayer(l2);
                return true;
            }
            if (l2 < l1) {
                link.getEntity2().setHectorLayer(l1);
                return true;
            }
        } else {
            int l2theoric = l1 + lenght - 1;
            if (l2 < l2theoric) {
                link.getEntity2().setHectorLayer(l2theoric);
                return true;
            }
        }
        return false;
    }

    public Collection<IEntity> entities() {
        return Collections.unmodifiableCollection(this.entities);
    }
}

