/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.picoweb;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.code.NoPlantumlCompressionException;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderUtil;

public class PicoWebServer
implements Runnable {
    private final Socket connect;

    public PicoWebServer(Socket c) {
        this.connect = c;
    }

    public static void main(String[] args) throws IOException {
        PicoWebServer.startServer(8080);
    }

    public static void startServer(int port) throws IOException {
        ServerSocket serverConnect = new ServerSocket(port);
        while (true) {
            PicoWebServer myServer = new PicoWebServer(serverConnect.accept());
            Thread thread = new Thread(myServer);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedReader in = null;
        FilterOutputStream out = null;
        try {
            in = new BufferedReader(new InputStreamReader(this.connect.getInputStream(), "UTF-8"));
            out = new BufferedOutputStream(this.connect.getOutputStream());
            String first = in.readLine();
            if (first == null) {
                return;
            }
            StringTokenizer parse = new StringTokenizer(first);
            String method = parse.nextToken().toUpperCase();
            if (method.equals("GET")) {
                String path = parse.nextToken();
                if (path.startsWith("/plantuml/png/")) {
                    this.sendDiagram((BufferedOutputStream)out, path, "image/png", FileFormat.PNG);
                    return;
                }
                if (path.startsWith("/plantuml/svg/")) {
                    this.sendDiagram((BufferedOutputStream)out, path, "image/svg+xml", FileFormat.SVG);
                    return;
                }
            }
            this.write(out, "HTTP/1.1 302 Found");
            this.write(out, "Location: /plantuml/png/oqbDJyrBuGh8ISmh2VNrKGZ8JCuFJqqAJYqgIotY0aefG5G00000");
            this.write(out, "");
            ((BufferedOutputStream)out).flush();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
                out.close();
                this.connect.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private void sendDiagram(BufferedOutputStream out, String path, String mime, FileFormat format) throws NoPlantumlCompressionException, IOException {
        int x = path.lastIndexOf(47);
        String compressed = path.substring(x + 1);
        Transcoder transcoder = TranscoderUtil.getDefaultTranscoderProtected();
        String source = transcoder.decode(compressed);
        byte[] fileData = this.getData(source, format);
        this.write(out, "HTTP/1.1 200 OK");
        this.write(out, "Cache-Control: no-cache");
        this.write(out, "Server: PlantUML PicoWebServer");
        this.write(out, "Date: " + new Date());
        this.write(out, "Content-type: " + mime);
        this.write(out, "Content-length: " + fileData.length);
        this.write(out, "");
        out.flush();
        out.write(fileData);
        out.flush();
    }

    private byte[] getData(String source, FileFormat format) throws IOException {
        SourceStringReader ssr = new SourceStringReader(source);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ssr.outputImage((OutputStream)os, new FileFormatOption(format));
        os.close();
        return os.toByteArray();
    }

    private void write(OutputStream os, String s) throws IOException {
        s = s + "\r\n";
        os.write(s.getBytes("UTF-8"));
    }
}

