/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.core;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.plantuml.project.LoadPlanable;
import net.sourceforge.plantuml.project.draw.ResourceDraw;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.DayOfWeek;

public class Resource {
    private final String name;
    private ResourceDraw draw;
    private final Set<Day> closed = new TreeSet<Day>();
    private final Set<Day> forcedOn = new TreeSet<Day>();
    private final Collection<DayOfWeek> closedDayOfWeek = EnumSet.noneOf(DayOfWeek.class);

    public Resource(String name, LoadPlanable loadPlanable) {
        this.name = name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        Resource other = (Resource)obj;
        return this.name.equals(other.name);
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public ResourceDraw getResourceDraw() {
        return this.draw;
    }

    public void setTaskDraw(ResourceDraw draw) {
        this.draw = draw;
    }

    public boolean isClosedAt(Day instant) {
        if (this.forcedOn.contains(instant)) {
            return false;
        }
        if (this.closedDayOfWeek.size() > 0 && this.closedDayOfWeek.contains((Object)instant.getDayOfWeek())) {
            return true;
        }
        return this.closed.contains(instant);
    }

    public void addCloseDay(Day instant) {
        this.closed.add(instant);
    }

    public void addForceOnDay(Day instant) {
        this.forcedOn.add(instant);
    }

    public void addCloseDay(DayOfWeek dayOfWeek) {
        this.closedDayOfWeek.add(dayOfWeek);
    }
}

