/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.core2;

import net.sourceforge.plantuml.project.time.DayOfWeek;

public class Hole
implements Comparable<Hole> {
    private final long start;
    private final long end;

    public Hole(long start, long end) {
        if (end <= start) {
            throw new IllegalArgumentException();
        }
        this.start = start;
        this.end = end;
    }

    public String toString() {
        return DayOfWeek.timeToString(this.start) + " --> " + DayOfWeek.timeToString(this.end);
    }

    public final long getStart() {
        return this.start;
    }

    public final long getEnd() {
        return this.end;
    }

    @Override
    public int compareTo(Hole other) {
        return Long.compare(this.start, other.start);
    }
}

