/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sprite;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.WithSprite;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandFactorySprite;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.preproc.Stdlib;
import net.sourceforge.plantuml.sprite.Sprite;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class StdlibDiagram
extends UmlDiagram {
    private static final int WIDTH = 1800;
    private String name;

    public StdlibDiagram(ISkinSimple skinParam) {
        super(skinParam);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Sprites)");
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.HELP;
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        int margin2;
        int margin1;
        TextBlock result = this.getTable();
        double dpiFactor = 1.0;
        if (SkinParam.USE_STYLES()) {
            margin1 = SkinParam.zeroMargin(10);
            margin2 = SkinParam.zeroMargin(10);
        } else {
            margin1 = 10;
            margin2 = 10;
        }
        ImageBuilder imageBuilder = ImageBuilder.buildD(this.getSkinParam(), ClockwiseTopRightBottomLeft.margin1margin2(margin1, margin2), this.getAnimation(), fileFormatOption.isWithMetadata() ? this.getMetadata() : null, this.getWarningOrError(), 1.0);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, this.seed(), os);
    }

    private TextBlock getTable() {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                try {
                    StdlibDiagram.this.drawInternal(ug);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(1800.0, 4096.0);
            }
        };
    }

    public void setStdlibName(String name) {
        this.name = name;
    }

    private void drawInternal(UGraphic ug) throws IOException {
        double x = 0.0;
        double y = 0.0;
        double rawHeight = 0.0;
        Stdlib folder = Stdlib.retrieve(this.name);
        CommandFactorySprite factorySpriteCommand = new CommandFactorySprite();
        Command<WithSprite> cmd = factorySpriteCommand.createMultiLine(false);
        List<String> all = folder.extractAllSprites();
        int nb = 0;
        for (String s : all) {
            BlocLines bloc = BlocLines.fromArray(s.split("\n"));
            cmd.execute(this, bloc);
            ++nb;
        }
        for (String n : this.getSkinParam().getAllSpriteNames()) {
            Sprite sprite = this.getSkinParam().getSprite(n);
            TextBlock blockName = Display.create(n).create(FontConfiguration.blackBlueTrue(UFont.sansSerif(14)), HorizontalAlignment.LEFT, this.getSkinParam());
            TextBlock tb = sprite.asTextBlock(HColorUtils.BLACK, 1.0);
            tb = TextBlockUtils.mergeTB(tb, blockName, HorizontalAlignment.CENTER);
            tb.drawU(ug.apply(new UTranslate(x, y)));
            Dimension2D dim = tb.calculateDimension(ug.getStringBounder());
            rawHeight = Math.max(rawHeight, dim.getHeight());
            x += dim.getWidth();
            if (!((x += 30.0) > 1800.0)) continue;
            x = 0.0;
            y += rawHeight + 50.0;
            rawHeight = 0.0;
            if (!(y > 1024.0)) continue;
        }
    }
}

