/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.search;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import org.protege.editor.owl.model.search.SearchCategory;
import org.protege.editor.owl.model.search.SearchMetadata;
import org.protege.editor.owl.model.search.SearchResultMatch;
import org.protege.editor.owl.ui.renderer.styledstring.StyledString;
import org.semanticweb.owlapi.model.OWLObject;

public class SearchResult
implements Comparable<SearchResult> {
    private SearchMetadata searchMetadata;
    private final ImmutableList<SearchResultMatch> matches;

    public SearchResult(SearchMetadata searchMetadata, ImmutableList<SearchResultMatch> matches) {
        this.searchMetadata = searchMetadata;
        this.matches = matches;
    }

    public SearchCategory getCategory() {
        return this.searchMetadata.getCategory();
    }

    public String getGroupDescription() {
        return this.searchMetadata.getGroupDescription();
    }

    public String getSearchString() {
        return this.searchMetadata.getSearchString();
    }

    public StyledString getStyledSearchSearchString() {
        return this.searchMetadata.getStyledSearchSearchString();
    }

    public OWLObject getSubject() {
        return this.searchMetadata.getSubject();
    }

    public String getSubjectRendering() {
        return this.searchMetadata.getSubjectRendering();
    }

    public ImmutableList<SearchResultMatch> getMatches() {
        return this.matches;
    }

    @Override
    public int compareTo(SearchResult o) {
        int matchesDiff = Ordering.natural().lexicographical().compare(this.matches, o.matches);
        if (matchesDiff != 0) {
            return matchesDiff;
        }
        return this.searchMetadata.compareTo(o.searchMetadata);
    }

    public int hashCode() {
        return SearchResult.class.getSimpleName().hashCode() + this.searchMetadata.hashCode() + this.matches.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchResult)) {
            return false;
        }
        SearchResult other = (SearchResult)obj;
        return this.searchMetadata.equals(other.searchMetadata) && this.matches.equals(other.matches);
    }
}

