// Generated by gmmproc 2.64.2 -- DO NOT MODIFY!
#ifndef _ATKMM_RELATION_H
#define _ATKMM_RELATION_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* $Id: relation.hg,v 1.3 2005/01/05 18:21:30 murrayc Exp $ */

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glibmm/object.h>
#include <glibmm/arrayhandle.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
using AtkRelation = struct _AtkRelation;
using AtkRelationClass = struct _AtkRelationClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Atk
{ class  Relation_Class; } // namespace Atk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Atk
{


/** @addtogroup atkmmEnums atkmm Enums and Flags */

/** 
 *  @var RelationType RELATION_NULL
 * Not used, represens "no relationship" or an error condition.
 * 
 *  @var RelationType RELATION_CONTROLLED_BY
 * Indicates an object controlled by one or more target objects.
 * 
 *  @var RelationType RELATION_CONTROLLER_FOR
 * Indicates an object is an controller for one or more target objects.
 * 
 *  @var RelationType RELATION_LABEL_FOR
 * Indicates an object is a label for one or more target objects.
 * 
 *  @var RelationType RELATION_LABELLED_BY
 * Indicates an object is labelled by one or more target objects.
 * 
 *  @var RelationType RELATION_MEMBER_OF
 * Indicates an object is a member of a group of one or more target objects.
 * 
 *  @var RelationType RELATION_NODE_CHILD_OF
 * Indicates an object is a cell in a treetable which is displayed because a cell in the same column is expanded and identifies that cell.
 * 
 *  @var RelationType RELATION_FLOWS_TO
 * Indicates that the object has content that flows logically to another
 * AtkObject in a sequential way, (for instance text-flow).
 * 
 *  @var RelationType RELATION_FLOWS_FROM
 * Indicates that the object has content that flows logically from
 * another AtkObject in a sequential way, (for instance text-flow).
 * 
 *  @var RelationType RELATION_SUBWINDOW_OF
 * Indicates a subwindow attached to a component but otherwise has no connection in  the UI heirarchy to that component.
 * 
 *  @var RelationType RELATION_EMBEDS
 * Indicates that the object visually embeds 
 * another object's content, i.e. this object's content flows around 
 * another's content.
 * 
 *  @var RelationType RELATION_EMBEDDED_BY
 * Inverse of Atk::RELATION_EMBEDS, indicates that
 * this object's content is visualy embedded in another object.
 * 
 *  @var RelationType RELATION_POPUP_FOR
 * Indicates that an object is a popup for another object.
 * 
 *  @var RelationType RELATION_PARENT_WINDOW_OF
 * Indicates that an object is a parent window of another object.
 * 
 *  @var RelationType RELATION_DESCRIBED_BY
 * Indicates that another object provides descriptive information about this object; more verbose than ATK_RELATION_LABELLED_BY.
 * 
 *  @var RelationType RELATION_DESCRIPTION_FOR
 * Indicates that an object provides descriptive information about another object; more verbose than ATK_RELATION_LABEL_FOR.
 * 
 *  @var RelationType RELATION_NODE_PARENT_OF
 * Indicates an object is a cell in a treetable and is expanded to display other cells in the same column.
 * 
 *  @var RelationType RELATION_LAST_DEFINED
 * Not used, this value indicates the end of the enumeration.
 * 
 *  @enum RelationType
 * 
 * Describes the type of the relation
 *
 * @ingroup atkmmEnums
 */
enum RelationType
{
  RELATION_NULL,
  RELATION_CONTROLLED_BY,
  RELATION_CONTROLLER_FOR,
  RELATION_LABEL_FOR,
  RELATION_LABELLED_BY,
  RELATION_MEMBER_OF,
  RELATION_NODE_CHILD_OF,
  RELATION_FLOWS_TO,
  RELATION_FLOWS_FROM,
  RELATION_SUBWINDOW_OF,
  RELATION_EMBEDS,
  RELATION_EMBEDDED_BY,
  RELATION_POPUP_FOR,
  RELATION_PARENT_WINDOW_OF,
  RELATION_DESCRIBED_BY,
  RELATION_DESCRIPTION_FOR,
  RELATION_NODE_PARENT_OF,
  RELATION_LAST_DEFINED
};

} // namespace Atk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Atk::RelationType> : public Glib::Value_Enum<Atk::RelationType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Atk
{


class Object;

/** An Atk::Relation describes a relation between an object and one or more other objects.
 * The actual relations that an object has with other objects are defined as an Atk::RelationSet,
 * which is a set of Atk::Relations.
 */

class Relation : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Relation;
  using CppClassType = Relation_Class;
  using BaseObjectType = AtkRelation;
  using BaseClassType = AtkRelationClass;

  // noncopyable
  Relation(const Relation&) = delete;
  Relation& operator=(const Relation&) = delete;

private:  friend class Relation_Class;
  static CppClassType relation_class_;

protected:
  explicit Relation(const Glib::ConstructParams& construct_params);
  explicit Relation(AtkRelation* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Relation(Relation&& src) noexcept;
  Relation& operator=(Relation&& src) noexcept;

  ~Relation() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  AtkRelation*       gobj()       { return reinterpret_cast<AtkRelation*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const AtkRelation* gobj() const { return reinterpret_cast<AtkRelation*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  AtkRelation* gobj_copy();

private:


protected:
  explicit Relation(const Glib::ArrayHandle< Glib::RefPtr<Atk::Object> >& targets,
                    RelationType relationship);

public:
  
  static Glib::RefPtr<Relation> create(const Glib::ArrayHandle< Glib::RefPtr<Atk::Object> >& targets, RelationType relationship =  RELATION_NULL);


  /** Gets the type of @a relation
   * 
   * @return The type of @a relation.
   */
  RelationType get_relation_type() const;

  Glib::ArrayHandle< Glib::RefPtr<Atk::Object> > get_target();
  Glib::ArrayHandle< Glib::RefPtr<const Atk::Object> > get_target() const;
  
  
  /** Adds the specified AtkObject to the target for the relation, if it is
   * not already present.  See also Atk::Object::add_relationship().
   * 
   * 
   * @newin{1,9}
   * 
   * @param target An Atk::Object.
   */
  void add_target(const Glib::RefPtr<Atk::Object>& target);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Atk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Atk::Relation
   */
  
  Glib::RefPtr<Atk::Relation> wrap(AtkRelation* object, bool take_copy = false);
}


#endif /* _ATKMM_RELATION_H */

