/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.util.Iterator;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.apache.catalina.Group;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.Registry;

public class GlobalResourcesLifecycleListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(GlobalResourcesLifecycleListener.class);
    protected Lifecycle component = null;
    protected static final Registry registry = MBeanUtils.createRegistry();

    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        if ("start".equals(lifecycleEvent.getType())) {
            this.component = lifecycleEvent.getLifecycle();
            this.createMBeans();
        } else if ("stop".equals(lifecycleEvent.getType())) {
            this.destroyMBeans();
            this.component = null;
        }
    }

    protected void createMBeans() {
        Context context = null;
        try {
            context = (Context)new InitialContext().lookup("java:/");
        }
        catch (NamingException namingException) {
            log.error((Object)"No global naming context defined for server");
            return;
        }
        try {
            this.createMBeans("", context);
        }
        catch (NamingException namingException) {
            log.error((Object)"Exception processing Global JNDI Resources", (Throwable)namingException);
        }
    }

    protected void createMBeans(String string, Context context) throws NamingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating MBeans for Global JNDI Resources in Context '" + string + "'"));
        }
        try {
            NamingEnumeration<Binding> namingEnumeration = context.listBindings("");
            while (namingEnumeration.hasMore()) {
                Binding binding = namingEnumeration.next();
                String string2 = string + binding.getName();
                Object object = context.lookup(binding.getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Checking resource " + string2));
                }
                if (object instanceof Context) {
                    this.createMBeans(string2 + "/", (Context)object);
                    continue;
                }
                if (!(object instanceof UserDatabase)) continue;
                try {
                    this.createMBeans(string2, (UserDatabase)object);
                }
                catch (Exception exception) {
                    log.error((Object)("Exception creating UserDatabase MBeans for " + string2), (Throwable)exception);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)("RuntimeException " + runtimeException));
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            log.error((Object)("Operation not supported " + operationNotSupportedException));
        }
    }

    protected void createMBeans(String string, UserDatabase userDatabase) throws Exception {
        Object object;
        Object object2;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating UserDatabase MBeans for resource " + string));
            log.debug((Object)("Database=" + userDatabase));
        }
        try {
            MBeanUtils.createMBean(userDatabase);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot create UserDatabase MBean for resource " + string, exception);
        }
        Iterator<Role> iterator = userDatabase.getRoles();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Creating Role MBean for role " + object2));
            }
            try {
                MBeanUtils.createMBean((Role)object2);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Cannot create Role MBean for role " + object2, exception);
            }
        }
        object2 = userDatabase.getGroups();
        while (object2.hasNext()) {
            object = (Group)object2.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Creating Group MBean for group " + object));
            }
            try {
                MBeanUtils.createMBean((Group)object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Cannot create Group MBean for group " + object, exception);
            }
        }
        object = userDatabase.getUsers();
        while (object.hasNext()) {
            User user = (User)object.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Creating User MBean for user " + user));
            }
            try {
                MBeanUtils.createMBean(user);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Cannot create User MBean for user " + user, exception);
            }
        }
    }

    protected void destroyMBeans() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Destroying MBeans for Global JNDI Resources");
        }
    }
}

