/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.DialogShell;
import com.lightdev.app.shtm.SHTMLEditorPane;
import com.lightdev.app.shtm.SHTMLPrefsChangeListener;
import com.lightdev.app.shtm.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class PrefsDialog
extends DialogShell
implements ActionListener {
    private UIManager.LookAndFeelInfo[] lfinfo;
    protected Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    public static final String PREFSID_LOOK_AND_FEEL = "Laf";
    public static final String PREFS_USE_STD_STYLE_SHEET = "use_std_styles";
    public static final String PREFS_DEFAULT_PASTE_MODE = "default_paste_mode";
    private final String lafName = UIManager.getLookAndFeel().getName();
    private final JComboBox lafCombo;
    private final JCheckBox useStdStyleSheet;
    private final JComboBox pasteModeCombo;
    private static final String helpTopicId = "item167";
    private final List<SHTMLPrefsChangeListener> prefChangeListeners = new LinkedList<SHTMLPrefsChangeListener>();

    public PrefsDialog(Frame parent, String title) {
        super(parent, title, helpTopicId);
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel layoutPanel = new JPanel(g);
        JPanel appPrefsPanel = new JPanel(g);
        Util.addGridBagComponent(appPrefsPanel, new JLabel(Util.getResourceString("prfLafLabel")), g, c, 0, 0, 13);
        this.lafCombo = new JComboBox();
        this.initLfComboBox();
        Util.addGridBagComponent(appPrefsPanel, this.lafCombo, g, c, 1, 0, 13);
        this.pasteModeCombo = new JComboBox();
        this.initPasteModeComboBox();
        Util.addGridBagComponent(appPrefsPanel, new JLabel(Util.getResourceString("prefsPasteModeLabel")), g, c, 0, 1, 13);
        Util.addGridBagComponent(appPrefsPanel, this.pasteModeCombo, g, c, 1, 1, 13);
        Util.addGridBagComponent(layoutPanel, appPrefsPanel, g, c, 0, 0, 17);
        this.useStdStyleSheet = new JCheckBox(Util.getResourceString("linkDefaultStyleSheetLabel"));
        boolean useStyle = this.prefs.getBoolean(PREFS_USE_STD_STYLE_SHEET, false);
        this.useStdStyleSheet.setSelected(useStyle);
        Util.addGridBagComponent(layoutPanel, this.useStdStyleSheet, g, c, 0, 2, 17);
        Container contentPane = super.getContentPane();
        contentPane.add((Component)layoutPanel, "Center");
        this.pack();
    }

    public void addPrefChangeListener(SHTMLPrefsChangeListener listener) {
        this.prefChangeListeners.add(listener);
    }

    public void removePrefChangeListener(SHTMLPrefsChangeListener listener) {
        this.prefChangeListeners.remove(listener);
    }

    private void initLfComboBox() {
        this.lfinfo = UIManager.getInstalledLookAndFeels();
        int count = this.lfinfo.length;
        String[] lfNames = new String[count];
        for (int i = 0; i < count; ++i) {
            lfNames[i] = this.lfinfo[i].getName();
        }
        this.lafCombo.setModel(new DefaultComboBoxModel<String>(lfNames));
        this.lafCombo.setSelectedItem(this.lafName);
    }

    private void initPasteModeComboBox() {
        this.pasteModeCombo.setModel(new DefaultComboBoxModel<SHTMLEditorPane.PasteMode>(SHTMLEditorPane.PasteMode.values()));
        this.pasteModeCombo.setSelectedItem((Object)SHTMLEditorPane.PasteMode.valueOf(SHTMLEditorPane.PasteMode.class, this.prefs.get(PREFS_DEFAULT_PASTE_MODE, SHTMLEditorPane.PasteMode.PASTE_HTML.name())));
        this.pasteModeCombo.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                switch ((SHTMLEditorPane.PasteMode)((Object)value)) {
                    case PASTE_HTML: {
                        return new JLabel(Util.getResourceString("pasteModeHTML"));
                    }
                    case PASTE_PLAIN_TEXT: {
                        return new JLabel(Util.getResourceString("pasteModePlainText"));
                    }
                }
                throw new AssertionError();
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        Component src = (Component)e.getSource();
        if (src == this.okButton) {
            this.savePrefs(src);
        }
        super.actionPerformed(e);
    }

    private void savePrefs(Component src) {
        try {
            String newLaf = this.lfinfo[this.lafCombo.getSelectedIndex()].getClassName();
            if (!this.lafName.equalsIgnoreCase(newLaf)) {
                this.prefs.put(PREFSID_LOOK_AND_FEEL, newLaf);
                UIManager.setLookAndFeel(newLaf);
                SwingUtilities.updateComponentTreeUI(JOptionPane.getFrameForComponent(src));
            }
            boolean oldStyleSheetPref = this.prefs.getBoolean(PREFS_USE_STD_STYLE_SHEET, false);
            this.prefs.putBoolean(PREFS_USE_STD_STYLE_SHEET, this.useStdStyleSheet.isSelected());
            String oldDefaultPasteMode = this.prefs.get(PREFS_DEFAULT_PASTE_MODE, SHTMLEditorPane.PasteMode.PASTE_HTML.name());
            this.prefs.put(PREFS_DEFAULT_PASTE_MODE, ((SHTMLEditorPane.PasteMode)((Object)this.pasteModeCombo.getSelectedItem())).name());
            for (SHTMLPrefsChangeListener listener : this.prefChangeListeners) {
                listener.shtmlPrefChanged(PREFS_USE_STD_STYLE_SHEET, new Boolean(this.useStdStyleSheet.isSelected()).toString(), new Boolean(oldStyleSheetPref).toString());
                listener.shtmlPrefChanged(PREFS_DEFAULT_PASTE_MODE, this.prefs.get(PREFS_DEFAULT_PASTE_MODE, null), oldDefaultPasteMode);
            }
        }
        catch (Exception ex) {
            Util.errMsg(this, ex.getMessage(), ex);
        }
    }
}

