/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import com.google.common.base.Stopwatch;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenFilm;
import mediathek.daten.ListeFilme;
import mediathek.gui.dialog.DialogEditAbo;
import mediathek.gui.messages.AboListChangedEvent;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.Datum;
import mediathek.tool.FilenameUtils;
import mediathek.tool.Filter;
import mediathek.tool.GermanStringSorter;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.models.TModelAbo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ListeAbo
extends LinkedList<DatenAbo> {
    private static final String[] LEER = new String[]{""};
    private static final Logger logger = LogManager.getLogger(ListeAbo.class);
    private final Daten daten;
    private int nr;

    public ListeAbo(Daten ddaten) {
        this.daten = ddaten;
    }

    public void addAbo(String aboName) {
        this.addAbo(aboName, "", "", "");
    }

    public void addAbo(String aboname, String filmSender, String filmThema, String filmTitel) {
        int min2;
        try {
            min2 = Integer.parseInt(MVConfig.get(MVConfig.Configs.SYSTEM_ABO_MIN_SIZE));
        }
        catch (Exception ex) {
            min2 = 0;
            MVConfig.add(MVConfig.Configs.SYSTEM_ABO_MIN_SIZE, "0");
        }
        this.addAbo(filmSender, filmThema, filmTitel, "", "", min2, true, aboname);
    }

    public void addAbo(String filmSender, String filmThema, String filmTitel, String filmThemaTitel, String irgendwo, int mindestdauer, boolean min2, String namePfad) {
        namePfad = FilenameUtils.replaceLeerDateiname(namePfad, false, Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_USE_REPLACETABLE)), Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_ONLY_ASCII)));
        DatenAbo datenAbo = new DatenAbo(namePfad, filmSender, filmThema, filmTitel, filmThemaTitel, irgendwo, mindestdauer, min2, namePfad, "");
        DialogEditAbo dialogEditAbo = new DialogEditAbo(MediathekGui.ui(), true, this.daten, datenAbo, false);
        dialogEditAbo.setTitle("Neues Abo anlegen");
        dialogEditAbo.setVisible(true);
        if (dialogEditAbo.ok) {
            if (!this.aboExistiertBereits(datenAbo)) {
                MVConfig.add(MVConfig.Configs.SYSTEM_ABO_MIN_SIZE, datenAbo.arr[8]);
                this.addAbo(datenAbo);
                this.aenderungMelden();
                this.sort();
            } else {
                MVMessageDialog.showMessageDialog(null, "Abo existiert bereits", "Abo anlegen", 1);
            }
        }
    }

    public void addAbo(DatenAbo datenAbo) {
        ++this.nr;
        datenAbo.nr = this.nr;
        if (datenAbo.arr[2].isEmpty()) {
            datenAbo.arr[2] = "Abo_" + this.nr;
        }
        datenAbo.setMindestDauerMinuten();
        if (datenAbo.arr[9].isEmpty()) {
            datenAbo.arr[9] = Boolean.TRUE.toString();
        }
        datenAbo.min = Boolean.parseBoolean(datenAbo.arr[9]);
        this.add(datenAbo);
    }

    public void aboLoeschen(@NotNull DatenAbo abo) {
        this.remove(abo);
        this.aenderungMelden();
    }

    public long activeAbos() {
        return this.stream().filter(DatenAbo::aboIstEingeschaltet).count();
    }

    public long inactiveAbos() {
        return this.stream().filter(abo -> !abo.aboIstEingeschaltet()).count();
    }

    public void aenderungMelden() {
        this.setAboFuerFilm(this.daten.getListeFilme(), true);
        this.daten.getMessageBus().publishAsync(new AboListChangedEvent());
    }

    public DatenAbo getAboNr(int i) {
        return (DatenAbo)this.get(i);
    }

    public void sort() {
        Collections.sort(this);
    }

    public void addObjectData(TModelAbo model, String sender) {
        model.setRowCount(0);
        Object[] object = new Object[13];
        for (DatenAbo datenAbo : this) {
            if (!sender.isEmpty() && !sender.equals(datenAbo.arr[3])) continue;
            for (int m3 = 0; m3 < 13; ++m3) {
                object[m3] = m3 == 0 ? Integer.valueOf(datenAbo.nr) : (m3 == 8 ? Integer.valueOf(datenAbo.mindestdauerMinuten) : (m3 == 11 ? this.getDatumForObject(datenAbo.arr[11]) : (m3 == 1 ? "" : (m3 == 9 ? (datenAbo.min ? "min" : "max") : (m3 != 2 && !DatenAbo.anzeigen(m3) ? "" : datenAbo.arr[m3])))));
            }
            model.addRow(object);
        }
    }

    public Datum getDatumForObject(String datum) {
        Datum tmp = new Datum(0L);
        if (!datum.isEmpty()) {
            try {
                tmp.setTime(new SimpleDateFormat("dd.MM.yyyy").parse(datum).getTime());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return tmp;
    }

    public ArrayList<String> getPfade() {
        ArrayList<String> pfade = new ArrayList<String>();
        for (DatenAbo abo : this) {
            String s2 = abo.arr[10];
            if (pfade.contains(s2)) continue;
            pfade.add(abo.arr[10]);
        }
        GermanStringSorter sorter = GermanStringSorter.getInstance();
        pfade.sort(sorter);
        return pfade;
    }

    private boolean aboExistiertBereits(DatenAbo abo) {
        for (DatenAbo datenAbo : this) {
            if (!Filter.aboExistiertBereits(datenAbo, abo)) continue;
            return true;
        }
        return false;
    }

    public DatenAbo getAboFuerFilm_schnell(DatenFilm film, boolean laengePruefen) {
        DatenAbo abo = film.getAbo();
        if (abo == null) {
            return null;
        }
        if (laengePruefen && !Filter.laengePruefen(abo.mindestdauerMinuten, film.getFilmLength(), abo.min)) {
            return null;
        }
        return abo;
    }

    private void deleteAboInFilm(DatenFilm film) {
        film.setAboName("");
        film.setAbo(null);
    }

    private void createAbo(DatenAbo abo) {
        if (abo.arr[5].isEmpty()) {
            abo.titel = LEER;
        } else if (Filter.isPattern(abo.arr[5])) {
            String[] stringArray = new String[1];
            v1 = stringArray;
            stringArray[0] = abo.arr[5];
        } else {
            v1 = abo.titel = abo.arr[5].toLowerCase().split(",");
        }
        if (abo.arr[6].isEmpty()) {
            abo.thema = LEER;
        } else if (Filter.isPattern(abo.arr[6])) {
            String[] stringArray = new String[1];
            v3 = stringArray;
            stringArray[0] = abo.arr[6];
        } else {
            v3 = abo.thema = abo.arr[6].toLowerCase().split(",");
        }
        if (abo.arr[7].isEmpty()) {
            abo.irgendwo = LEER;
        } else {
            String[] stringArray;
            if (Filter.isPattern(abo.arr[7])) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = abo.arr[7];
            } else {
                stringArray = abo.arr[7].toLowerCase().split(",");
            }
            abo.irgendwo = stringArray;
        }
    }

    private void assignAboToFilm(@NotNull DatenFilm film) {
        this.stream().filter(abo -> Filter.filterAufFilmPruefen(abo.arr[3], abo.arr[4], abo.titel, abo.thema, abo.irgendwo, abo.mindestdauerMinuten, abo.min, film, false)).findFirst().ifPresentOrElse(foundAbo -> this.assignAboToFilm((DatenAbo)foundAbo, film), () -> this.deleteAboInFilm(film));
    }

    private void assignAboToFilm(DatenAbo foundAbo, DatenFilm film) {
        if (!Filter.laengePruefen(foundAbo.mindestdauerMinuten, film.getFilmLength(), foundAbo.min)) {
            film.setAboName(foundAbo.arr[2] + (foundAbo.min ? " [zu kurz]" : " [zu lang]"));
        } else {
            film.setAboName(foundAbo.arr[2]);
        }
        film.setAbo(foundAbo);
    }

    public void setAboFuerFilm(ListeFilme listeFilme, boolean aboLoeschen) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (this.isEmpty() && aboLoeschen) {
            listeFilme.parallelStream().forEach(this::deleteAboInFilm);
            return;
        }
        this.stream().filter(DatenAbo::isEmpty).forEach(this::remove);
        this.forEach(this::createAbo);
        listeFilme.parallelStream().forEach(this::assignAboToFilm);
        this.forEach(datenAbo -> {
            datenAbo.titel = LEER;
            datenAbo.thema = LEER;
            datenAbo.irgendwo = LEER;
        });
        stopwatch.stop();
        logger.debug("setAboFuerFilm: {}", (Object)stopwatch);
    }
}

