// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from ATSAMD21E15BU.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

// +build sam,atsamd21e15bu

// Microchip ATSAMD21E15BU device: Cortex-M0+ Microcontroller with 32KB Flash, 4KB SRAM, 35-pin package
//
//     Copyright (c) 2018 Microchip Technology Inc.
//
//     SPDX-License-Identifier: Apache-2.0
//
//     Licensed under the Apache License, Version 2.0 (the "License");
//     you may not use this file except in compliance with the License.
//     You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
//     Unless required by applicable law or agreed to in writing, software
//     distributed under the License is distributed on an "AS IS" BASIS,
//     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//     See the License for the specific language governing permissions and
//     limitations under the License.
package sam

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "ATSAMD21E15BU"
)

// Interrupt numbers.
const (
	IRQ_PM      = 0  // Power Manager
	IRQ_SYSCTRL = 1  // System Control
	IRQ_WDT     = 2  // Watchdog Timer
	IRQ_RTC     = 3  // Real-Time Counter
	IRQ_EIC     = 4  // External Interrupt Controller
	IRQ_NVMCTRL = 5  // Non-Volatile Memory Controller
	IRQ_DMAC    = 6  // Direct Memory Access Controller
	IRQ_USB     = 7  // Universal Serial Bus
	IRQ_EVSYS   = 8  // Event System Interface
	IRQ_SERCOM0 = 9  // Serial Communication Interface 0
	IRQ_SERCOM1 = 10 // Serial Communication Interface 1
	IRQ_SERCOM2 = 11 // Serial Communication Interface 2
	IRQ_SERCOM3 = 12 // Serial Communication Interface 3
	IRQ_TCC0    = 15 // Timer Counter Control 0
	IRQ_TCC1    = 16 // Timer Counter Control 1
	IRQ_TCC2    = 17 // Timer Counter Control 2
	IRQ_TC3     = 18 // Basic Timer Counter 3
	IRQ_TC4     = 19 // Basic Timer Counter 4
	IRQ_TC5     = 20 // Basic Timer Counter 5
	IRQ_ADC     = 23 // Analog Digital Converter
	IRQ_AC      = 24 // Analog Comparators
	IRQ_DAC     = 25 // Digital Analog Converter
	IRQ_I2S     = 27 // Inter-IC Sound Interface
	IRQ_max     = 27 // Highest interrupt number on this device.
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_PM, "PM_IRQHandler")
	_ = interrupt.Register(IRQ_SYSCTRL, "SYSCTRL_IRQHandler")
	_ = interrupt.Register(IRQ_WDT, "WDT_IRQHandler")
	_ = interrupt.Register(IRQ_RTC, "RTC_IRQHandler")
	_ = interrupt.Register(IRQ_EIC, "EIC_IRQHandler")
	_ = interrupt.Register(IRQ_NVMCTRL, "NVMCTRL_IRQHandler")
	_ = interrupt.Register(IRQ_DMAC, "DMAC_IRQHandler")
	_ = interrupt.Register(IRQ_USB, "USB_IRQHandler")
	_ = interrupt.Register(IRQ_EVSYS, "EVSYS_IRQHandler")
	_ = interrupt.Register(IRQ_SERCOM0, "SERCOM0_IRQHandler")
	_ = interrupt.Register(IRQ_SERCOM1, "SERCOM1_IRQHandler")
	_ = interrupt.Register(IRQ_SERCOM2, "SERCOM2_IRQHandler")
	_ = interrupt.Register(IRQ_SERCOM3, "SERCOM3_IRQHandler")
	_ = interrupt.Register(IRQ_TCC0, "TCC0_IRQHandler")
	_ = interrupt.Register(IRQ_TCC1, "TCC1_IRQHandler")
	_ = interrupt.Register(IRQ_TCC2, "TCC2_IRQHandler")
	_ = interrupt.Register(IRQ_TC3, "TC3_IRQHandler")
	_ = interrupt.Register(IRQ_TC4, "TC4_IRQHandler")
	_ = interrupt.Register(IRQ_TC5, "TC5_IRQHandler")
	_ = interrupt.Register(IRQ_ADC, "ADC_IRQHandler")
	_ = interrupt.Register(IRQ_AC, "AC_IRQHandler")
	_ = interrupt.Register(IRQ_DAC, "DAC_IRQHandler")
	_ = interrupt.Register(IRQ_I2S, "I2S_IRQHandler")
)

// Peripherals.
var (
	AC            = (*AC_Type)(unsafe.Pointer(uintptr(0x42004400)))           // Analog Comparators
	ADC           = (*ADC_Type)(unsafe.Pointer(uintptr(0x42004000)))          // Analog Digital Converter
	DAC           = (*DAC_Type)(unsafe.Pointer(uintptr(0x42004800)))          // Digital Analog Converter
	DMAC          = (*DMAC_Type)(unsafe.Pointer(uintptr(0x41004800)))         // Direct Memory Access Controller
	DSU           = (*DSU_Type)(unsafe.Pointer(uintptr(0x41002000)))          // Device Service Unit
	EIC           = (*EIC_Type)(unsafe.Pointer(uintptr(0x40001800)))          // External Interrupt Controller
	EVSYS         = (*EVSYS_Type)(unsafe.Pointer(uintptr(0x42000400)))        // Event System Interface
	GCLK          = (*GCLK_Type)(unsafe.Pointer(uintptr(0x40000c00)))         // Generic Clock Generator
	HMATRIX       = (*HMATRIXB_Type)(unsafe.Pointer(uintptr(0x41007000)))     // HSB Matrix
	I2S           = (*I2S_Type)(unsafe.Pointer(uintptr(0x42005000)))          // Inter-IC Sound Interface
	MTB           = (*MTB_Type)(unsafe.Pointer(uintptr(0x41006000)))          // Cortex-M0+ Micro-Trace Buffer
	NVMCTRL       = (*NVMCTRL_Type)(unsafe.Pointer(uintptr(0x41004000)))      // Non-Volatile Memory Controller
	PAC0          = (*PAC_Type)(unsafe.Pointer(uintptr(0x40000000)))          // Peripheral Access Controller 0
	PM            = (*PM_Type)(unsafe.Pointer(uintptr(0x40000400)))           // Power Manager
	PORT          = (*PORT_Type)(unsafe.Pointer(uintptr(0x41004400)))         // Port Module
	PORT_IOBUS    = (*PORT_Type)(unsafe.Pointer(uintptr(0x60000000)))         // Port Module (IOBUS)
	RTC           = (*RTC_Type)(unsafe.Pointer(uintptr(0x40001400)))          // Real-Time Counter
	RTC_MODE0     = (*RTC_MODE0_Type)(unsafe.Pointer(uintptr(0x40001400)))    // Real-Time Counter - MODE0
	RTC_MODE1     = (*RTC_MODE1_Type)(unsafe.Pointer(uintptr(0x40001400)))    // Real-Time Counter - MODE1
	RTC_MODE2     = (*RTC_MODE2_Type)(unsafe.Pointer(uintptr(0x40001400)))    // Real-Time Counter - MODE2
	SERCOM0       = (*SERCOM_Type)(unsafe.Pointer(uintptr(0x42000800)))       // Serial Communication Interface 0
	SERCOM0_I2CM  = (*SERCOM_I2CM_Type)(unsafe.Pointer(uintptr(0x42000800)))  // Serial Communication Interface 0 - I2CM
	SERCOM0_I2CS  = (*SERCOM_I2CS_Type)(unsafe.Pointer(uintptr(0x42000800)))  // Serial Communication Interface 0 - I2CS
	SERCOM0_SPI   = (*SERCOM_SPI_Type)(unsafe.Pointer(uintptr(0x42000800)))   // Serial Communication Interface 0 - SPI
	SERCOM0_USART = (*SERCOM_USART_Type)(unsafe.Pointer(uintptr(0x42000800))) // Serial Communication Interface 0 - USART
	SYSCTRL       = (*SYSCTRL_Type)(unsafe.Pointer(uintptr(0x40000800)))      // System Control
	TC3           = (*TC_Type)(unsafe.Pointer(uintptr(0x42002c00)))           // Basic Timer Counter 3
	TC3_COUNT8    = (*TC_COUNT8_Type)(unsafe.Pointer(uintptr(0x42002c00)))    // Basic Timer Counter 3 - COUNT8
	TC3_COUNT16   = (*TC_COUNT16_Type)(unsafe.Pointer(uintptr(0x42002c00)))   // Basic Timer Counter 3 - COUNT16
	TC3_COUNT32   = (*TC_COUNT32_Type)(unsafe.Pointer(uintptr(0x42002c00)))   // Basic Timer Counter 3 - COUNT32
	TCC0          = (*TCC_Type)(unsafe.Pointer(uintptr(0x42002000)))          // Timer Counter Control 0
	USB           = (*USB_Type)(unsafe.Pointer(uintptr(0x41005000)))          // Universal Serial Bus
	USB_DEVICE    = (*USB_DEVICE_Type)(unsafe.Pointer(uintptr(0x41005000)))   // Universal Serial Bus - DEVICE
	USB_HOST      = (*USB_HOST_Type)(unsafe.Pointer(uintptr(0x41005000)))     // Universal Serial Bus - HOST
	WDT           = (*WDT_Type)(unsafe.Pointer(uintptr(0x40001000)))          // Watchdog Timer
	PAC1          = (*PAC_Type)(unsafe.Pointer(uintptr(0x41000000)))          // Peripheral Access Controller 1
	PAC2          = (*PAC_Type)(unsafe.Pointer(uintptr(0x42000000)))          // Peripheral Access Controller 2
	SERCOM1       = (*SERCOM_Type)(unsafe.Pointer(uintptr(0x42000c00)))       // Serial Communication Interface 1
	SERCOM1_I2CM  = (*SERCOM_I2CM_Type)(unsafe.Pointer(uintptr(0x42000c00)))  // Serial Communication Interface 0 - I2CM
	SERCOM1_I2CS  = (*SERCOM_I2CS_Type)(unsafe.Pointer(uintptr(0x42000c00)))  // Serial Communication Interface 0 - I2CS
	SERCOM1_SPI   = (*SERCOM_SPI_Type)(unsafe.Pointer(uintptr(0x42000c00)))   // Serial Communication Interface 0 - SPI
	SERCOM1_USART = (*SERCOM_USART_Type)(unsafe.Pointer(uintptr(0x42000c00))) // Serial Communication Interface 0 - USART
	SERCOM2       = (*SERCOM_Type)(unsafe.Pointer(uintptr(0x42001000)))       // Serial Communication Interface 2
	SERCOM2_I2CM  = (*SERCOM_I2CM_Type)(unsafe.Pointer(uintptr(0x42001000)))  // Serial Communication Interface 0 - I2CM
	SERCOM2_I2CS  = (*SERCOM_I2CS_Type)(unsafe.Pointer(uintptr(0x42001000)))  // Serial Communication Interface 0 - I2CS
	SERCOM2_SPI   = (*SERCOM_SPI_Type)(unsafe.Pointer(uintptr(0x42001000)))   // Serial Communication Interface 0 - SPI
	SERCOM2_USART = (*SERCOM_USART_Type)(unsafe.Pointer(uintptr(0x42001000))) // Serial Communication Interface 0 - USART
	SERCOM3       = (*SERCOM_Type)(unsafe.Pointer(uintptr(0x42001400)))       // Serial Communication Interface 3
	SERCOM3_I2CM  = (*SERCOM_I2CM_Type)(unsafe.Pointer(uintptr(0x42001400)))  // Serial Communication Interface 0 - I2CM
	SERCOM3_I2CS  = (*SERCOM_I2CS_Type)(unsafe.Pointer(uintptr(0x42001400)))  // Serial Communication Interface 0 - I2CS
	SERCOM3_SPI   = (*SERCOM_SPI_Type)(unsafe.Pointer(uintptr(0x42001400)))   // Serial Communication Interface 0 - SPI
	SERCOM3_USART = (*SERCOM_USART_Type)(unsafe.Pointer(uintptr(0x42001400))) // Serial Communication Interface 0 - USART
	TC4           = (*TC_Type)(unsafe.Pointer(uintptr(0x42003000)))           // Basic Timer Counter 4
	TC4_COUNT8    = (*TC_COUNT8_Type)(unsafe.Pointer(uintptr(0x42003000)))    // Basic Timer Counter 3 - COUNT8
	TC4_COUNT16   = (*TC_COUNT16_Type)(unsafe.Pointer(uintptr(0x42003000)))   // Basic Timer Counter 3 - COUNT16
	TC4_COUNT32   = (*TC_COUNT32_Type)(unsafe.Pointer(uintptr(0x42003000)))   // Basic Timer Counter 3 - COUNT32
	TC5           = (*TC_Type)(unsafe.Pointer(uintptr(0x42003400)))           // Basic Timer Counter 5
	TC5_COUNT8    = (*TC_COUNT8_Type)(unsafe.Pointer(uintptr(0x42003400)))    // Basic Timer Counter 3 - COUNT8
	TC5_COUNT16   = (*TC_COUNT16_Type)(unsafe.Pointer(uintptr(0x42003400)))   // Basic Timer Counter 3 - COUNT16
	TC5_COUNT32   = (*TC_COUNT32_Type)(unsafe.Pointer(uintptr(0x42003400)))   // Basic Timer Counter 3 - COUNT32
	TCC1          = (*TCC_Type)(unsafe.Pointer(uintptr(0x42002400)))          // Timer Counter Control 1
	TCC2          = (*TCC_Type)(unsafe.Pointer(uintptr(0x42002800)))          // Timer Counter Control 2
)

// Analog Comparators
type AC_Type struct {
	CTRLA     volatile.Register8  // 0x0
	CTRLB     volatile.Register8  // 0x1
	EVCTRL    volatile.Register16 // 0x2
	INTENCLR  volatile.Register8  // 0x4
	INTENSET  volatile.Register8  // 0x5
	INTFLAG   volatile.Register8  // 0x6
	_         byte
	STATUSA   volatile.Register8 // 0x8
	STATUSB   volatile.Register8 // 0x9
	STATUSC   volatile.Register8 // 0xA
	_         byte
	WINCTRL   volatile.Register8 // 0xC
	_         [3]byte
	COMPCTRL0 volatile.Register32 // 0x10
	COMPCTRL1 volatile.Register32 // 0x14
	_         [8]byte
	SCALER0   volatile.Register8 // 0x20
	SCALER1   volatile.Register8 // 0x21
}

// Analog Digital Converter
type ADC_Type struct {
	CTRLA      volatile.Register8  // 0x0
	REFCTRL    volatile.Register8  // 0x1
	AVGCTRL    volatile.Register8  // 0x2
	SAMPCTRL   volatile.Register8  // 0x3
	CTRLB      volatile.Register16 // 0x4
	_          [2]byte
	WINCTRL    volatile.Register8 // 0x8
	_          [3]byte
	SWTRIG     volatile.Register8 // 0xC
	_          [3]byte
	INPUTCTRL  volatile.Register32 // 0x10
	EVCTRL     volatile.Register8  // 0x14
	_          byte
	INTENCLR   volatile.Register8  // 0x16
	INTENSET   volatile.Register8  // 0x17
	INTFLAG    volatile.Register8  // 0x18
	STATUS     volatile.Register8  // 0x19
	RESULT     volatile.Register16 // 0x1A
	WINLT      volatile.Register16 // 0x1C
	_          [2]byte
	WINUT      volatile.Register16 // 0x20
	_          [2]byte
	GAINCORR   volatile.Register16 // 0x24
	OFFSETCORR volatile.Register16 // 0x26
	CALIB      volatile.Register16 // 0x28
	DBGCTRL    volatile.Register8  // 0x2A
}

// Digital Analog Converter
type DAC_Type struct {
	CTRLA    volatile.Register8 // 0x0
	CTRLB    volatile.Register8 // 0x1
	EVCTRL   volatile.Register8 // 0x2
	_        byte
	INTENCLR volatile.Register8  // 0x4
	INTENSET volatile.Register8  // 0x5
	INTFLAG  volatile.Register8  // 0x6
	STATUS   volatile.Register8  // 0x7
	DATA     volatile.Register16 // 0x8
	_        [2]byte
	DATABUF  volatile.Register16 // 0xC
}

// Direct Memory Access Controller
type DMAC_Type struct {
	CTRL       volatile.Register16 // 0x0
	CRCCTRL    volatile.Register16 // 0x2
	CRCDATAIN  volatile.Register32 // 0x4
	CRCCHKSUM  volatile.Register32 // 0x8
	CRCSTATUS  volatile.Register8  // 0xC
	DBGCTRL    volatile.Register8  // 0xD
	QOSCTRL    volatile.Register8  // 0xE
	_          byte
	SWTRIGCTRL volatile.Register32 // 0x10
	PRICTRL0   volatile.Register32 // 0x14
	_          [8]byte
	INTPEND    volatile.Register16 // 0x20
	_          [2]byte
	INTSTATUS  volatile.Register32 // 0x24
	BUSYCH     volatile.Register32 // 0x28
	PENDCH     volatile.Register32 // 0x2C
	ACTIVE     volatile.Register32 // 0x30
	BASEADDR   volatile.Register32 // 0x34
	WRBADDR    volatile.Register32 // 0x38
	_          [3]byte
	CHID       volatile.Register8 // 0x3F
	CHCTRLA    volatile.Register8 // 0x40
	_          [3]byte
	CHCTRLB    volatile.Register32 // 0x44
	_          [4]byte
	CHINTENCLR volatile.Register8 // 0x4C
	CHINTENSET volatile.Register8 // 0x4D
	CHINTFLAG  volatile.Register8 // 0x4E
	CHSTATUS   volatile.Register8 // 0x4F
}

// Device Service Unit
type DSU_Type struct {
	CTRL    volatile.Register8 // 0x0
	STATUSA volatile.Register8 // 0x1
	STATUSB volatile.Register8 // 0x2
	_       byte
	ADDR    volatile.Register32 // 0x4
	LENGTH  volatile.Register32 // 0x8
	DATA    volatile.Register32 // 0xC
	DCC0    volatile.Register32 // 0x10
	DCC1    volatile.Register32 // 0x14
	DID     volatile.Register32 // 0x18
	_       [4068]byte
	ENTRY0  volatile.Register32 // 0x1000
	ENTRY1  volatile.Register32 // 0x1004
	END     volatile.Register32 // 0x1008
	_       [4032]byte
	MEMTYPE volatile.Register32 // 0x1FCC
	PID4    volatile.Register32 // 0x1FD0
	_       [12]byte
	PID0    volatile.Register32 // 0x1FE0
	PID1    volatile.Register32 // 0x1FE4
	PID2    volatile.Register32 // 0x1FE8
	PID3    volatile.Register32 // 0x1FEC
	CID0    volatile.Register32 // 0x1FF0
	CID1    volatile.Register32 // 0x1FF4
	CID2    volatile.Register32 // 0x1FF8
	CID3    volatile.Register32 // 0x1FFC
}

// External Interrupt Controller
type EIC_Type struct {
	CTRL     volatile.Register8  // 0x0
	STATUS   volatile.Register8  // 0x1
	NMICTRL  volatile.Register8  // 0x2
	NMIFLAG  volatile.Register8  // 0x3
	EVCTRL   volatile.Register32 // 0x4
	INTENCLR volatile.Register32 // 0x8
	INTENSET volatile.Register32 // 0xC
	INTFLAG  volatile.Register32 // 0x10
	WAKEUP   volatile.Register32 // 0x14
	CONFIG0  volatile.Register32 // 0x18
	CONFIG1  volatile.Register32 // 0x1C
}

// Event System Interface
type EVSYS_Type struct {
	CTRL     volatile.Register8 // 0x0
	_        [3]byte
	CHANNEL  volatile.Register32 // 0x4
	USER     volatile.Register16 // 0x8
	_        [2]byte
	CHSTATUS volatile.Register32 // 0xC
	INTENCLR volatile.Register32 // 0x10
	INTENSET volatile.Register32 // 0x14
	INTFLAG  volatile.Register32 // 0x18
}

// Generic Clock Generator
type GCLK_Type struct {
	CTRL    volatile.Register8  // 0x0
	STATUS  volatile.Register8  // 0x1
	CLKCTRL volatile.Register16 // 0x2
	GENCTRL volatile.Register32 // 0x4
	GENDIV  volatile.Register32 // 0x8
}

// HSB Matrix
type HMATRIXB_Type struct {
	_      [128]byte
	PRAS0  volatile.Register32 // 0x80
	PRBS0  volatile.Register32 // 0x84
	PRAS1  volatile.Register32 // 0x88
	PRBS1  volatile.Register32 // 0x8C
	PRAS2  volatile.Register32 // 0x90
	PRBS2  volatile.Register32 // 0x94
	PRAS3  volatile.Register32 // 0x98
	PRBS3  volatile.Register32 // 0x9C
	PRAS4  volatile.Register32 // 0xA0
	PRBS4  volatile.Register32 // 0xA4
	PRAS5  volatile.Register32 // 0xA8
	PRBS5  volatile.Register32 // 0xAC
	PRAS6  volatile.Register32 // 0xB0
	PRBS6  volatile.Register32 // 0xB4
	PRAS7  volatile.Register32 // 0xB8
	PRBS7  volatile.Register32 // 0xBC
	PRAS8  volatile.Register32 // 0xC0
	PRBS8  volatile.Register32 // 0xC4
	PRAS9  volatile.Register32 // 0xC8
	PRBS9  volatile.Register32 // 0xCC
	PRAS10 volatile.Register32 // 0xD0
	PRBS10 volatile.Register32 // 0xD4
	PRAS11 volatile.Register32 // 0xD8
	PRBS11 volatile.Register32 // 0xDC
	PRAS12 volatile.Register32 // 0xE0
	PRBS12 volatile.Register32 // 0xE4
	PRAS13 volatile.Register32 // 0xE8
	PRBS13 volatile.Register32 // 0xEC
	PRAS14 volatile.Register32 // 0xF0
	PRBS14 volatile.Register32 // 0xF4
	PRAS15 volatile.Register32 // 0xF8
	PRBS15 volatile.Register32 // 0xFC
	_      [16]byte
	SFR0   volatile.Register32 // 0x110
	SFR1   volatile.Register32 // 0x114
	SFR2   volatile.Register32 // 0x118
	SFR3   volatile.Register32 // 0x11C
	SFR4   volatile.Register32 // 0x120
	SFR5   volatile.Register32 // 0x124
	SFR6   volatile.Register32 // 0x128
	SFR7   volatile.Register32 // 0x12C
	SFR8   volatile.Register32 // 0x130
	SFR9   volatile.Register32 // 0x134
	SFR10  volatile.Register32 // 0x138
	SFR11  volatile.Register32 // 0x13C
	SFR12  volatile.Register32 // 0x140
	SFR13  volatile.Register32 // 0x144
	SFR14  volatile.Register32 // 0x148
	SFR15  volatile.Register32 // 0x14C
}

// Inter-IC Sound Interface
type I2S_Type struct {
	CTRLA    volatile.Register8 // 0x0
	_        [3]byte
	CLKCTRL0 volatile.Register32 // 0x4
	CLKCTRL1 volatile.Register32 // 0x8
	INTENCLR volatile.Register16 // 0xC
	_        [2]byte
	INTENSET volatile.Register16 // 0x10
	_        [2]byte
	INTFLAG  volatile.Register16 // 0x14
	_        [2]byte
	SYNCBUSY volatile.Register16 // 0x18
	_        [6]byte
	SERCTRL0 volatile.Register32 // 0x20
	SERCTRL1 volatile.Register32 // 0x24
	_        [8]byte
	DATA0    volatile.Register32 // 0x30
	DATA1    volatile.Register32 // 0x34
}

// Cortex-M0+ Micro-Trace Buffer
type MTB_Type struct {
	POSITION   volatile.Register32 // 0x0
	MASTER     volatile.Register32 // 0x4
	FLOW       volatile.Register32 // 0x8
	BASE       volatile.Register32 // 0xC
	_          [3824]byte
	ITCTRL     volatile.Register32 // 0xF00
	_          [156]byte
	CLAIMSET   volatile.Register32 // 0xFA0
	CLAIMCLR   volatile.Register32 // 0xFA4
	_          [8]byte
	LOCKACCESS volatile.Register32 // 0xFB0
	LOCKSTATUS volatile.Register32 // 0xFB4
	AUTHSTATUS volatile.Register32 // 0xFB8
	DEVARCH    volatile.Register32 // 0xFBC
	_          [8]byte
	DEVID      volatile.Register32 // 0xFC8
	DEVTYPE    volatile.Register32 // 0xFCC
	PID4       volatile.Register32 // 0xFD0
	PID5       volatile.Register32 // 0xFD4
	PID6       volatile.Register32 // 0xFD8
	PID7       volatile.Register32 // 0xFDC
	PID0       volatile.Register32 // 0xFE0
	PID1       volatile.Register32 // 0xFE4
	PID2       volatile.Register32 // 0xFE8
	PID3       volatile.Register32 // 0xFEC
	CID0       volatile.Register32 // 0xFF0
	CID1       volatile.Register32 // 0xFF4
	CID2       volatile.Register32 // 0xFF8
	CID3       volatile.Register32 // 0xFFC
}

// Non-Volatile Memory Controller
type NVMCTRL_Type struct {
	CTRLA    volatile.Register16 // 0x0
	_        [2]byte
	CTRLB    volatile.Register32 // 0x4
	PARAM    volatile.Register32 // 0x8
	INTENCLR volatile.Register8  // 0xC
	_        [3]byte
	INTENSET volatile.Register8 // 0x10
	_        [3]byte
	INTFLAG  volatile.Register8 // 0x14
	_        [3]byte
	STATUS   volatile.Register16 // 0x18
	_        [2]byte
	ADDR     volatile.Register32 // 0x1C
	LOCK     volatile.Register16 // 0x20
}

// Peripheral Access Controller 0
type PAC_Type struct {
	WPCLR volatile.Register32 // 0x0
	WPSET volatile.Register32 // 0x4
}

// Power Manager
type PM_Type struct {
	CTRL     volatile.Register8 // 0x0
	SLEEP    volatile.Register8 // 0x1
	EXTCTRL  volatile.Register8 // 0x2
	_        [5]byte
	CPUSEL   volatile.Register8 // 0x8
	APBASEL  volatile.Register8 // 0x9
	APBBSEL  volatile.Register8 // 0xA
	APBCSEL  volatile.Register8 // 0xB
	_        [8]byte
	AHBMASK  volatile.Register32 // 0x14
	APBAMASK volatile.Register32 // 0x18
	APBBMASK volatile.Register32 // 0x1C
	APBCMASK volatile.Register32 // 0x20
	_        [16]byte
	INTENCLR volatile.Register8 // 0x34
	INTENSET volatile.Register8 // 0x35
	INTFLAG  volatile.Register8 // 0x36
	_        byte
	RCAUSE   volatile.Register8 // 0x38
}

// Port Module
type PORT_Type struct {
	DIR0       volatile.Register32 // 0x0
	DIRCLR0    volatile.Register32 // 0x4
	DIRSET0    volatile.Register32 // 0x8
	DIRTGL0    volatile.Register32 // 0xC
	OUT0       volatile.Register32 // 0x10
	OUTCLR0    volatile.Register32 // 0x14
	OUTSET0    volatile.Register32 // 0x18
	OUTTGL0    volatile.Register32 // 0x1C
	IN0        volatile.Register32 // 0x20
	CTRL0      volatile.Register32 // 0x24
	WRCONFIG0  volatile.Register32 // 0x28
	_          [4]byte
	PMUX0_0    volatile.Register8 // 0x30
	PMUX0_1    volatile.Register8 // 0x31
	PMUX0_2    volatile.Register8 // 0x32
	PMUX0_3    volatile.Register8 // 0x33
	PMUX0_4    volatile.Register8 // 0x34
	PMUX0_5    volatile.Register8 // 0x35
	PMUX0_6    volatile.Register8 // 0x36
	PMUX0_7    volatile.Register8 // 0x37
	PMUX0_8    volatile.Register8 // 0x38
	PMUX0_9    volatile.Register8 // 0x39
	PMUX0_10   volatile.Register8 // 0x3A
	PMUX0_11   volatile.Register8 // 0x3B
	PMUX0_12   volatile.Register8 // 0x3C
	PMUX0_13   volatile.Register8 // 0x3D
	PMUX0_14   volatile.Register8 // 0x3E
	PMUX0_15   volatile.Register8 // 0x3F
	PINCFG0_0  volatile.Register8 // 0x40
	PINCFG0_1  volatile.Register8 // 0x41
	PINCFG0_2  volatile.Register8 // 0x42
	PINCFG0_3  volatile.Register8 // 0x43
	PINCFG0_4  volatile.Register8 // 0x44
	PINCFG0_5  volatile.Register8 // 0x45
	PINCFG0_6  volatile.Register8 // 0x46
	PINCFG0_7  volatile.Register8 // 0x47
	PINCFG0_8  volatile.Register8 // 0x48
	PINCFG0_9  volatile.Register8 // 0x49
	PINCFG0_10 volatile.Register8 // 0x4A
	PINCFG0_11 volatile.Register8 // 0x4B
	PINCFG0_12 volatile.Register8 // 0x4C
	PINCFG0_13 volatile.Register8 // 0x4D
	PINCFG0_14 volatile.Register8 // 0x4E
	PINCFG0_15 volatile.Register8 // 0x4F
	PINCFG0_16 volatile.Register8 // 0x50
	PINCFG0_17 volatile.Register8 // 0x51
	PINCFG0_18 volatile.Register8 // 0x52
	PINCFG0_19 volatile.Register8 // 0x53
	PINCFG0_20 volatile.Register8 // 0x54
	PINCFG0_21 volatile.Register8 // 0x55
	PINCFG0_22 volatile.Register8 // 0x56
	PINCFG0_23 volatile.Register8 // 0x57
	PINCFG0_24 volatile.Register8 // 0x58
	PINCFG0_25 volatile.Register8 // 0x59
	PINCFG0_26 volatile.Register8 // 0x5A
	PINCFG0_27 volatile.Register8 // 0x5B
	PINCFG0_28 volatile.Register8 // 0x5C
	PINCFG0_29 volatile.Register8 // 0x5D
	PINCFG0_30 volatile.Register8 // 0x5E
	PINCFG0_31 volatile.Register8 // 0x5F
}

// Real-Time Counter
type RTC_Type struct {
}

// Real-Time Counter - MODE0
type RTC_MODE0_Type struct {
	CTRL     volatile.Register16 // 0x0
	READREQ  volatile.Register16 // 0x2
	EVCTRL   volatile.Register16 // 0x4
	INTENCLR volatile.Register8  // 0x6
	INTENSET volatile.Register8  // 0x7
	INTFLAG  volatile.Register8  // 0x8
	_        byte
	STATUS   volatile.Register8 // 0xA
	DBGCTRL  volatile.Register8 // 0xB
	FREQCORR volatile.Register8 // 0xC
	_        [3]byte
	COUNT    volatile.Register32 // 0x10
	_        [4]byte
	COMP0    volatile.Register32 // 0x18
}

// Real-Time Counter - MODE1
type RTC_MODE1_Type struct {
	CTRL     volatile.Register16 // 0x0
	READREQ  volatile.Register16 // 0x2
	EVCTRL   volatile.Register16 // 0x4
	INTENCLR volatile.Register8  // 0x6
	INTENSET volatile.Register8  // 0x7
	INTFLAG  volatile.Register8  // 0x8
	_        byte
	STATUS   volatile.Register8 // 0xA
	DBGCTRL  volatile.Register8 // 0xB
	FREQCORR volatile.Register8 // 0xC
	_        [3]byte
	COUNT    volatile.Register16 // 0x10
	_        [2]byte
	PER      volatile.Register16 // 0x14
	_        [2]byte
	COMP0    volatile.Register16 // 0x18
	COMP1    volatile.Register16 // 0x1A
}

// Real-Time Counter - MODE2
type RTC_MODE2_Type struct {
	CTRL     volatile.Register16 // 0x0
	READREQ  volatile.Register16 // 0x2
	EVCTRL   volatile.Register16 // 0x4
	INTENCLR volatile.Register8  // 0x6
	INTENSET volatile.Register8  // 0x7
	INTFLAG  volatile.Register8  // 0x8
	_        byte
	STATUS   volatile.Register8 // 0xA
	DBGCTRL  volatile.Register8 // 0xB
	FREQCORR volatile.Register8 // 0xC
	_        [3]byte
	CLOCK    volatile.Register32 // 0x10
	_        [4]byte
	ALARM0   volatile.Register32 // 0x18
	MASK0    volatile.Register8  // 0x1C
}

// Serial Communication Interface 0
type SERCOM_Type struct {
}

// Serial Communication Interface 0 - I2CM
type SERCOM_I2CM_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLB    volatile.Register32 // 0x4
	_        [4]byte
	BAUD     volatile.Register32 // 0xC
	_        [4]byte
	INTENCLR volatile.Register8 // 0x14
	_        byte
	INTENSET volatile.Register8 // 0x16
	_        byte
	INTFLAG  volatile.Register8 // 0x18
	_        byte
	STATUS   volatile.Register16 // 0x1A
	SYNCBUSY volatile.Register32 // 0x1C
	_        [4]byte
	ADDR     volatile.Register32 // 0x24
	DATA     volatile.Register8  // 0x28
	_        [7]byte
	DBGCTRL  volatile.Register8 // 0x30
}

// Serial Communication Interface 0 - I2CS
type SERCOM_I2CS_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLB    volatile.Register32 // 0x4
	_        [12]byte
	INTENCLR volatile.Register8 // 0x14
	_        byte
	INTENSET volatile.Register8 // 0x16
	_        byte
	INTFLAG  volatile.Register8 // 0x18
	_        byte
	STATUS   volatile.Register16 // 0x1A
	SYNCBUSY volatile.Register32 // 0x1C
	_        [4]byte
	ADDR     volatile.Register32 // 0x24
	DATA     volatile.Register8  // 0x28
}

// Serial Communication Interface 0 - SPI
type SERCOM_SPI_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLB    volatile.Register32 // 0x4
	_        [4]byte
	BAUD     volatile.Register8 // 0xC
	_        [7]byte
	INTENCLR volatile.Register8 // 0x14
	_        byte
	INTENSET volatile.Register8 // 0x16
	_        byte
	INTFLAG  volatile.Register8 // 0x18
	_        byte
	STATUS   volatile.Register16 // 0x1A
	SYNCBUSY volatile.Register32 // 0x1C
	_        [4]byte
	ADDR     volatile.Register32 // 0x24
	DATA     volatile.Register32 // 0x28
	_        [4]byte
	DBGCTRL  volatile.Register8 // 0x30
}

// Serial Communication Interface 0 - USART
type SERCOM_USART_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLB    volatile.Register32 // 0x4
	_        [4]byte
	BAUD     volatile.Register16 // 0xC
	RXPL     volatile.Register8  // 0xE
	_        [5]byte
	INTENCLR volatile.Register8 // 0x14
	_        byte
	INTENSET volatile.Register8 // 0x16
	_        byte
	INTFLAG  volatile.Register8 // 0x18
	_        byte
	STATUS   volatile.Register16 // 0x1A
	SYNCBUSY volatile.Register32 // 0x1C
	_        [8]byte
	DATA     volatile.Register16 // 0x28
	_        [6]byte
	DBGCTRL  volatile.Register8 // 0x30
}

// System Control
type SYSCTRL_Type struct {
	INTENCLR   volatile.Register32 // 0x0
	INTENSET   volatile.Register32 // 0x4
	INTFLAG    volatile.Register32 // 0x8
	PCLKSR     volatile.Register32 // 0xC
	XOSC       volatile.Register16 // 0x10
	_          [2]byte
	XOSC32K    volatile.Register16 // 0x14
	_          [2]byte
	OSC32K     volatile.Register32 // 0x18
	OSCULP32K  volatile.Register8  // 0x1C
	_          [3]byte
	OSC8M      volatile.Register32 // 0x20
	DFLLCTRL   volatile.Register16 // 0x24
	_          [2]byte
	DFLLVAL    volatile.Register32 // 0x28
	DFLLMUL    volatile.Register32 // 0x2C
	DFLLSYNC   volatile.Register8  // 0x30
	_          [3]byte
	BOD33      volatile.Register32 // 0x34
	_          [4]byte
	VREG       volatile.Register16 // 0x3C
	_          [2]byte
	VREF       volatile.Register32 // 0x40
	DPLLCTRLA  volatile.Register8  // 0x44
	_          [3]byte
	DPLLRATIO  volatile.Register32 // 0x48
	DPLLCTRLB  volatile.Register32 // 0x4C
	DPLLSTATUS volatile.Register8  // 0x50
}

// Basic Timer Counter 3
type TC_Type struct {
}

// Basic Timer Counter 3 - COUNT8
type TC_COUNT8_Type struct {
	CTRLA    volatile.Register16 // 0x0
	READREQ  volatile.Register16 // 0x2
	CTRLBCLR volatile.Register8  // 0x4
	CTRLBSET volatile.Register8  // 0x5
	CTRLC    volatile.Register8  // 0x6
	_        byte
	DBGCTRL  volatile.Register8 // 0x8
	_        byte
	EVCTRL   volatile.Register16 // 0xA
	INTENCLR volatile.Register8  // 0xC
	INTENSET volatile.Register8  // 0xD
	INTFLAG  volatile.Register8  // 0xE
	STATUS   volatile.Register8  // 0xF
	COUNT    volatile.Register8  // 0x10
	_        [3]byte
	PER      volatile.Register8 // 0x14
	_        [3]byte
	CC0      volatile.Register8 // 0x18
	CC1      volatile.Register8 // 0x19
}

// Basic Timer Counter 3 - COUNT16
type TC_COUNT16_Type struct {
	CTRLA    volatile.Register16 // 0x0
	READREQ  volatile.Register16 // 0x2
	CTRLBCLR volatile.Register8  // 0x4
	CTRLBSET volatile.Register8  // 0x5
	CTRLC    volatile.Register8  // 0x6
	_        byte
	DBGCTRL  volatile.Register8 // 0x8
	_        byte
	EVCTRL   volatile.Register16 // 0xA
	INTENCLR volatile.Register8  // 0xC
	INTENSET volatile.Register8  // 0xD
	INTFLAG  volatile.Register8  // 0xE
	STATUS   volatile.Register8  // 0xF
	COUNT    volatile.Register16 // 0x10
	_        [6]byte
	CC0      volatile.Register16 // 0x18
	CC1      volatile.Register16 // 0x1A
}

// Basic Timer Counter 3 - COUNT32
type TC_COUNT32_Type struct {
	CTRLA    volatile.Register16 // 0x0
	READREQ  volatile.Register16 // 0x2
	CTRLBCLR volatile.Register8  // 0x4
	CTRLBSET volatile.Register8  // 0x5
	CTRLC    volatile.Register8  // 0x6
	_        byte
	DBGCTRL  volatile.Register8 // 0x8
	_        byte
	EVCTRL   volatile.Register16 // 0xA
	INTENCLR volatile.Register8  // 0xC
	INTENSET volatile.Register8  // 0xD
	INTFLAG  volatile.Register8  // 0xE
	STATUS   volatile.Register8  // 0xF
	COUNT    volatile.Register32 // 0x10
	_        [4]byte
	CC0      volatile.Register32 // 0x18
	CC1      volatile.Register32 // 0x1C
}

// Timer Counter Control 0
type TCC_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLBCLR volatile.Register8  // 0x4
	CTRLBSET volatile.Register8  // 0x5
	_        [2]byte
	SYNCBUSY volatile.Register32 // 0x8
	FCTRLA   volatile.Register32 // 0xC
	FCTRLB   volatile.Register32 // 0x10
	WEXCTRL  volatile.Register32 // 0x14
	DRVCTRL  volatile.Register32 // 0x18
	_        [2]byte
	DBGCTRL  volatile.Register8 // 0x1E
	_        byte
	EVCTRL   volatile.Register32 // 0x20
	INTENCLR volatile.Register32 // 0x24
	INTENSET volatile.Register32 // 0x28
	INTFLAG  volatile.Register32 // 0x2C
	STATUS   volatile.Register32 // 0x30
	COUNT    volatile.Register32 // 0x34
	PATT     volatile.Register16 // 0x38
	_        [2]byte
	WAVE     volatile.Register32 // 0x3C
	PER      volatile.Register32 // 0x40
	CC0      volatile.Register32 // 0x44
	CC1      volatile.Register32 // 0x48
	CC2      volatile.Register32 // 0x4C
	CC3      volatile.Register32 // 0x50
	_        [16]byte
	PATTB    volatile.Register16 // 0x64
	_        [2]byte
	WAVEB    volatile.Register32 // 0x68
	PERB     volatile.Register32 // 0x6C
	CCB0     volatile.Register32 // 0x70
	CCB1     volatile.Register32 // 0x74
	CCB2     volatile.Register32 // 0x78
	CCB3     volatile.Register32 // 0x7C
}

// Universal Serial Bus
type USB_Type struct {
}

// Universal Serial Bus - DEVICE
type USB_DEVICE_Type struct {
	CTRLA        volatile.Register8 // 0x0
	_            byte
	SYNCBUSY     volatile.Register8 // 0x2
	QOSCTRL      volatile.Register8 // 0x3
	_            [4]byte
	CTRLB        volatile.Register16 // 0x8
	DADD         volatile.Register8  // 0xA
	_            byte
	STATUS       volatile.Register8 // 0xC
	FSMSTATUS    volatile.Register8 // 0xD
	_            [2]byte
	FNUM         volatile.Register16 // 0x10
	_            [2]byte
	INTENCLR     volatile.Register16 // 0x14
	_            [2]byte
	INTENSET     volatile.Register16 // 0x18
	_            [2]byte
	INTFLAG      volatile.Register16 // 0x1C
	_            [2]byte
	EPINTSMRY    volatile.Register16 // 0x20
	_            [2]byte
	DESCADD      volatile.Register32 // 0x24
	PADCAL       volatile.Register16 // 0x28
	_            [214]byte
	EPCFG0       volatile.Register8 // 0x100
	_            [3]byte
	EPSTATUSCLR0 volatile.Register8 // 0x104
	EPSTATUSSET0 volatile.Register8 // 0x105
	EPSTATUS0    volatile.Register8 // 0x106
	EPINTFLAG0   volatile.Register8 // 0x107
	EPINTENCLR0  volatile.Register8 // 0x108
	EPINTENSET0  volatile.Register8 // 0x109
	_            [22]byte
	EPCFG1       volatile.Register8 // 0x120
	_            [3]byte
	EPSTATUSCLR1 volatile.Register8 // 0x124
	EPSTATUSSET1 volatile.Register8 // 0x125
	EPSTATUS1    volatile.Register8 // 0x126
	EPINTFLAG1   volatile.Register8 // 0x127
	EPINTENCLR1  volatile.Register8 // 0x128
	EPINTENSET1  volatile.Register8 // 0x129
	_            [22]byte
	EPCFG2       volatile.Register8 // 0x140
	_            [3]byte
	EPSTATUSCLR2 volatile.Register8 // 0x144
	EPSTATUSSET2 volatile.Register8 // 0x145
	EPSTATUS2    volatile.Register8 // 0x146
	EPINTFLAG2   volatile.Register8 // 0x147
	EPINTENCLR2  volatile.Register8 // 0x148
	EPINTENSET2  volatile.Register8 // 0x149
	_            [22]byte
	EPCFG3       volatile.Register8 // 0x160
	_            [3]byte
	EPSTATUSCLR3 volatile.Register8 // 0x164
	EPSTATUSSET3 volatile.Register8 // 0x165
	EPSTATUS3    volatile.Register8 // 0x166
	EPINTFLAG3   volatile.Register8 // 0x167
	EPINTENCLR3  volatile.Register8 // 0x168
	EPINTENSET3  volatile.Register8 // 0x169
	_            [22]byte
	EPCFG4       volatile.Register8 // 0x180
	_            [3]byte
	EPSTATUSCLR4 volatile.Register8 // 0x184
	EPSTATUSSET4 volatile.Register8 // 0x185
	EPSTATUS4    volatile.Register8 // 0x186
	EPINTFLAG4   volatile.Register8 // 0x187
	EPINTENCLR4  volatile.Register8 // 0x188
	EPINTENSET4  volatile.Register8 // 0x189
	_            [22]byte
	EPCFG5       volatile.Register8 // 0x1A0
	_            [3]byte
	EPSTATUSCLR5 volatile.Register8 // 0x1A4
	EPSTATUSSET5 volatile.Register8 // 0x1A5
	EPSTATUS5    volatile.Register8 // 0x1A6
	EPINTFLAG5   volatile.Register8 // 0x1A7
	EPINTENCLR5  volatile.Register8 // 0x1A8
	EPINTENSET5  volatile.Register8 // 0x1A9
	_            [22]byte
	EPCFG6       volatile.Register8 // 0x1C0
	_            [3]byte
	EPSTATUSCLR6 volatile.Register8 // 0x1C4
	EPSTATUSSET6 volatile.Register8 // 0x1C5
	EPSTATUS6    volatile.Register8 // 0x1C6
	EPINTFLAG6   volatile.Register8 // 0x1C7
	EPINTENCLR6  volatile.Register8 // 0x1C8
	EPINTENSET6  volatile.Register8 // 0x1C9
	_            [22]byte
	EPCFG7       volatile.Register8 // 0x1E0
	_            [3]byte
	EPSTATUSCLR7 volatile.Register8 // 0x1E4
	EPSTATUSSET7 volatile.Register8 // 0x1E5
	EPSTATUS7    volatile.Register8 // 0x1E6
	EPINTFLAG7   volatile.Register8 // 0x1E7
	EPINTENCLR7  volatile.Register8 // 0x1E8
	EPINTENSET7  volatile.Register8 // 0x1E9
}

// Universal Serial Bus - HOST
type USB_HOST_Type struct {
	CTRLA       volatile.Register8 // 0x0
	_           byte
	SYNCBUSY    volatile.Register8 // 0x2
	QOSCTRL     volatile.Register8 // 0x3
	_           [4]byte
	CTRLB       volatile.Register16 // 0x8
	HSOFC       volatile.Register8  // 0xA
	_           byte
	STATUS      volatile.Register8 // 0xC
	FSMSTATUS   volatile.Register8 // 0xD
	_           [2]byte
	FNUM        volatile.Register16 // 0x10
	FLENHIGH    volatile.Register8  // 0x12
	_           byte
	INTENCLR    volatile.Register16 // 0x14
	_           [2]byte
	INTENSET    volatile.Register16 // 0x18
	_           [2]byte
	INTFLAG     volatile.Register16 // 0x1C
	_           [2]byte
	PINTSMRY    volatile.Register16 // 0x20
	_           [2]byte
	DESCADD     volatile.Register32 // 0x24
	PADCAL      volatile.Register16 // 0x28
	_           [214]byte
	PCFG0       volatile.Register8 // 0x100
	_           [2]byte
	BINTERVAL0  volatile.Register8 // 0x103
	PSTATUSCLR0 volatile.Register8 // 0x104
	PSTATUSSET0 volatile.Register8 // 0x105
	PSTATUS0    volatile.Register8 // 0x106
	PINTFLAG0   volatile.Register8 // 0x107
	PINTENCLR0  volatile.Register8 // 0x108
	PINTENSET0  volatile.Register8 // 0x109
	_           [22]byte
	PCFG1       volatile.Register8 // 0x120
	_           [2]byte
	BINTERVAL1  volatile.Register8 // 0x123
	PSTATUSCLR1 volatile.Register8 // 0x124
	PSTATUSSET1 volatile.Register8 // 0x125
	PSTATUS1    volatile.Register8 // 0x126
	PINTFLAG1   volatile.Register8 // 0x127
	PINTENCLR1  volatile.Register8 // 0x128
	PINTENSET1  volatile.Register8 // 0x129
	_           [22]byte
	PCFG2       volatile.Register8 // 0x140
	_           [2]byte
	BINTERVAL2  volatile.Register8 // 0x143
	PSTATUSCLR2 volatile.Register8 // 0x144
	PSTATUSSET2 volatile.Register8 // 0x145
	PSTATUS2    volatile.Register8 // 0x146
	PINTFLAG2   volatile.Register8 // 0x147
	PINTENCLR2  volatile.Register8 // 0x148
	PINTENSET2  volatile.Register8 // 0x149
	_           [22]byte
	PCFG3       volatile.Register8 // 0x160
	_           [2]byte
	BINTERVAL3  volatile.Register8 // 0x163
	PSTATUSCLR3 volatile.Register8 // 0x164
	PSTATUSSET3 volatile.Register8 // 0x165
	PSTATUS3    volatile.Register8 // 0x166
	PINTFLAG3   volatile.Register8 // 0x167
	PINTENCLR3  volatile.Register8 // 0x168
	PINTENSET3  volatile.Register8 // 0x169
	_           [22]byte
	PCFG4       volatile.Register8 // 0x180
	_           [2]byte
	BINTERVAL4  volatile.Register8 // 0x183
	PSTATUSCLR4 volatile.Register8 // 0x184
	PSTATUSSET4 volatile.Register8 // 0x185
	PSTATUS4    volatile.Register8 // 0x186
	PINTFLAG4   volatile.Register8 // 0x187
	PINTENCLR4  volatile.Register8 // 0x188
	PINTENSET4  volatile.Register8 // 0x189
	_           [22]byte
	PCFG5       volatile.Register8 // 0x1A0
	_           [2]byte
	BINTERVAL5  volatile.Register8 // 0x1A3
	PSTATUSCLR5 volatile.Register8 // 0x1A4
	PSTATUSSET5 volatile.Register8 // 0x1A5
	PSTATUS5    volatile.Register8 // 0x1A6
	PINTFLAG5   volatile.Register8 // 0x1A7
	PINTENCLR5  volatile.Register8 // 0x1A8
	PINTENSET5  volatile.Register8 // 0x1A9
	_           [22]byte
	PCFG6       volatile.Register8 // 0x1C0
	_           [2]byte
	BINTERVAL6  volatile.Register8 // 0x1C3
	PSTATUSCLR6 volatile.Register8 // 0x1C4
	PSTATUSSET6 volatile.Register8 // 0x1C5
	PSTATUS6    volatile.Register8 // 0x1C6
	PINTFLAG6   volatile.Register8 // 0x1C7
	PINTENCLR6  volatile.Register8 // 0x1C8
	PINTENSET6  volatile.Register8 // 0x1C9
	_           [22]byte
	PCFG7       volatile.Register8 // 0x1E0
	_           [2]byte
	BINTERVAL7  volatile.Register8 // 0x1E3
	PSTATUSCLR7 volatile.Register8 // 0x1E4
	PSTATUSSET7 volatile.Register8 // 0x1E5
	PSTATUS7    volatile.Register8 // 0x1E6
	PINTFLAG7   volatile.Register8 // 0x1E7
	PINTENCLR7  volatile.Register8 // 0x1E8
	PINTENSET7  volatile.Register8 // 0x1E9
}

// Watchdog Timer
type WDT_Type struct {
	CTRL     volatile.Register8 // 0x0
	CONFIG   volatile.Register8 // 0x1
	EWCTRL   volatile.Register8 // 0x2
	_        byte
	INTENCLR volatile.Register8 // 0x4
	INTENSET volatile.Register8 // 0x5
	INTFLAG  volatile.Register8 // 0x6
	STATUS   volatile.Register8 // 0x7
	CLEAR    volatile.Register8 // 0x8
}

// Bitfields for AC: Analog Comparators
const (
	// CTRLA: Control A
	AC_CTRLA_SWRST_Pos    = 0x0  // Position of SWRST field.
	AC_CTRLA_SWRST_Msk    = 0x1  // Bit mask of SWRST field.
	AC_CTRLA_SWRST        = 0x1  // Bit SWRST.
	AC_CTRLA_ENABLE_Pos   = 0x1  // Position of ENABLE field.
	AC_CTRLA_ENABLE_Msk   = 0x2  // Bit mask of ENABLE field.
	AC_CTRLA_ENABLE       = 0x2  // Bit ENABLE.
	AC_CTRLA_RUNSTDBY_Pos = 0x2  // Position of RUNSTDBY field.
	AC_CTRLA_RUNSTDBY_Msk = 0x4  // Bit mask of RUNSTDBY field.
	AC_CTRLA_RUNSTDBY     = 0x4  // Bit RUNSTDBY.
	AC_CTRLA_LPMUX_Pos    = 0x7  // Position of LPMUX field.
	AC_CTRLA_LPMUX_Msk    = 0x80 // Bit mask of LPMUX field.
	AC_CTRLA_LPMUX        = 0x80 // Bit LPMUX.

	// CTRLB: Control B
	AC_CTRLB_START0_Pos = 0x0 // Position of START0 field.
	AC_CTRLB_START0_Msk = 0x1 // Bit mask of START0 field.
	AC_CTRLB_START0     = 0x1 // Bit START0.
	AC_CTRLB_START1_Pos = 0x1 // Position of START1 field.
	AC_CTRLB_START1_Msk = 0x2 // Bit mask of START1 field.
	AC_CTRLB_START1     = 0x2 // Bit START1.

	// EVCTRL: Event Control
	AC_EVCTRL_COMPEO0_Pos = 0x0   // Position of COMPEO0 field.
	AC_EVCTRL_COMPEO0_Msk = 0x1   // Bit mask of COMPEO0 field.
	AC_EVCTRL_COMPEO0     = 0x1   // Bit COMPEO0.
	AC_EVCTRL_COMPEO1_Pos = 0x1   // Position of COMPEO1 field.
	AC_EVCTRL_COMPEO1_Msk = 0x2   // Bit mask of COMPEO1 field.
	AC_EVCTRL_COMPEO1     = 0x2   // Bit COMPEO1.
	AC_EVCTRL_WINEO0_Pos  = 0x4   // Position of WINEO0 field.
	AC_EVCTRL_WINEO0_Msk  = 0x10  // Bit mask of WINEO0 field.
	AC_EVCTRL_WINEO0      = 0x10  // Bit WINEO0.
	AC_EVCTRL_COMPEI0_Pos = 0x8   // Position of COMPEI0 field.
	AC_EVCTRL_COMPEI0_Msk = 0x100 // Bit mask of COMPEI0 field.
	AC_EVCTRL_COMPEI0     = 0x100 // Bit COMPEI0.
	AC_EVCTRL_COMPEI1_Pos = 0x9   // Position of COMPEI1 field.
	AC_EVCTRL_COMPEI1_Msk = 0x200 // Bit mask of COMPEI1 field.
	AC_EVCTRL_COMPEI1     = 0x200 // Bit COMPEI1.

	// INTENCLR: Interrupt Enable Clear
	AC_INTENCLR_COMP0_Pos = 0x0  // Position of COMP0 field.
	AC_INTENCLR_COMP0_Msk = 0x1  // Bit mask of COMP0 field.
	AC_INTENCLR_COMP0     = 0x1  // Bit COMP0.
	AC_INTENCLR_COMP1_Pos = 0x1  // Position of COMP1 field.
	AC_INTENCLR_COMP1_Msk = 0x2  // Bit mask of COMP1 field.
	AC_INTENCLR_COMP1     = 0x2  // Bit COMP1.
	AC_INTENCLR_WIN0_Pos  = 0x4  // Position of WIN0 field.
	AC_INTENCLR_WIN0_Msk  = 0x10 // Bit mask of WIN0 field.
	AC_INTENCLR_WIN0      = 0x10 // Bit WIN0.

	// INTENSET: Interrupt Enable Set
	AC_INTENSET_COMP0_Pos = 0x0  // Position of COMP0 field.
	AC_INTENSET_COMP0_Msk = 0x1  // Bit mask of COMP0 field.
	AC_INTENSET_COMP0     = 0x1  // Bit COMP0.
	AC_INTENSET_COMP1_Pos = 0x1  // Position of COMP1 field.
	AC_INTENSET_COMP1_Msk = 0x2  // Bit mask of COMP1 field.
	AC_INTENSET_COMP1     = 0x2  // Bit COMP1.
	AC_INTENSET_WIN0_Pos  = 0x4  // Position of WIN0 field.
	AC_INTENSET_WIN0_Msk  = 0x10 // Bit mask of WIN0 field.
	AC_INTENSET_WIN0      = 0x10 // Bit WIN0.

	// INTFLAG: Interrupt Flag Status and Clear
	AC_INTFLAG_COMP0_Pos = 0x0  // Position of COMP0 field.
	AC_INTFLAG_COMP0_Msk = 0x1  // Bit mask of COMP0 field.
	AC_INTFLAG_COMP0     = 0x1  // Bit COMP0.
	AC_INTFLAG_COMP1_Pos = 0x1  // Position of COMP1 field.
	AC_INTFLAG_COMP1_Msk = 0x2  // Bit mask of COMP1 field.
	AC_INTFLAG_COMP1     = 0x2  // Bit COMP1.
	AC_INTFLAG_WIN0_Pos  = 0x4  // Position of WIN0 field.
	AC_INTFLAG_WIN0_Msk  = 0x10 // Bit mask of WIN0 field.
	AC_INTFLAG_WIN0      = 0x10 // Bit WIN0.

	// STATUSA: Status A
	AC_STATUSA_STATE0_Pos     = 0x0  // Position of STATE0 field.
	AC_STATUSA_STATE0_Msk     = 0x1  // Bit mask of STATE0 field.
	AC_STATUSA_STATE0         = 0x1  // Bit STATE0.
	AC_STATUSA_STATE1_Pos     = 0x1  // Position of STATE1 field.
	AC_STATUSA_STATE1_Msk     = 0x2  // Bit mask of STATE1 field.
	AC_STATUSA_STATE1         = 0x2  // Bit STATE1.
	AC_STATUSA_WSTATE0_Pos    = 0x4  // Position of WSTATE0 field.
	AC_STATUSA_WSTATE0_Msk    = 0x30 // Bit mask of WSTATE0 field.
	AC_STATUSA_WSTATE0_ABOVE  = 0x0  // Signal is above window
	AC_STATUSA_WSTATE0_INSIDE = 0x1  // Signal is inside window
	AC_STATUSA_WSTATE0_BELOW  = 0x2  // Signal is below window

	// STATUSB: Status B
	AC_STATUSB_READY0_Pos   = 0x0  // Position of READY0 field.
	AC_STATUSB_READY0_Msk   = 0x1  // Bit mask of READY0 field.
	AC_STATUSB_READY0       = 0x1  // Bit READY0.
	AC_STATUSB_READY1_Pos   = 0x1  // Position of READY1 field.
	AC_STATUSB_READY1_Msk   = 0x2  // Bit mask of READY1 field.
	AC_STATUSB_READY1       = 0x2  // Bit READY1.
	AC_STATUSB_SYNCBUSY_Pos = 0x7  // Position of SYNCBUSY field.
	AC_STATUSB_SYNCBUSY_Msk = 0x80 // Bit mask of SYNCBUSY field.
	AC_STATUSB_SYNCBUSY     = 0x80 // Bit SYNCBUSY.

	// STATUSC: Status C
	AC_STATUSC_STATE0_Pos     = 0x0  // Position of STATE0 field.
	AC_STATUSC_STATE0_Msk     = 0x1  // Bit mask of STATE0 field.
	AC_STATUSC_STATE0         = 0x1  // Bit STATE0.
	AC_STATUSC_STATE1_Pos     = 0x1  // Position of STATE1 field.
	AC_STATUSC_STATE1_Msk     = 0x2  // Bit mask of STATE1 field.
	AC_STATUSC_STATE1         = 0x2  // Bit STATE1.
	AC_STATUSC_WSTATE0_Pos    = 0x4  // Position of WSTATE0 field.
	AC_STATUSC_WSTATE0_Msk    = 0x30 // Bit mask of WSTATE0 field.
	AC_STATUSC_WSTATE0_ABOVE  = 0x0  // Signal is above window
	AC_STATUSC_WSTATE0_INSIDE = 0x1  // Signal is inside window
	AC_STATUSC_WSTATE0_BELOW  = 0x2  // Signal is below window

	// WINCTRL: Window Control
	AC_WINCTRL_WEN0_Pos         = 0x0 // Position of WEN0 field.
	AC_WINCTRL_WEN0_Msk         = 0x1 // Bit mask of WEN0 field.
	AC_WINCTRL_WEN0             = 0x1 // Bit WEN0.
	AC_WINCTRL_WINTSEL0_Pos     = 0x1 // Position of WINTSEL0 field.
	AC_WINCTRL_WINTSEL0_Msk     = 0x6 // Bit mask of WINTSEL0 field.
	AC_WINCTRL_WINTSEL0_ABOVE   = 0x0 // Interrupt on signal above window
	AC_WINCTRL_WINTSEL0_INSIDE  = 0x1 // Interrupt on signal inside window
	AC_WINCTRL_WINTSEL0_BELOW   = 0x2 // Interrupt on signal below window
	AC_WINCTRL_WINTSEL0_OUTSIDE = 0x3 // Interrupt on signal outside window

	// COMPCTRL0: Comparator Control n
	AC_COMPCTRL_ENABLE_Pos     = 0x0       // Position of ENABLE field.
	AC_COMPCTRL_ENABLE_Msk     = 0x1       // Bit mask of ENABLE field.
	AC_COMPCTRL_ENABLE         = 0x1       // Bit ENABLE.
	AC_COMPCTRL_SINGLE_Pos     = 0x1       // Position of SINGLE field.
	AC_COMPCTRL_SINGLE_Msk     = 0x2       // Bit mask of SINGLE field.
	AC_COMPCTRL_SINGLE         = 0x2       // Bit SINGLE.
	AC_COMPCTRL_SPEED_Pos      = 0x2       // Position of SPEED field.
	AC_COMPCTRL_SPEED_Msk      = 0xc       // Bit mask of SPEED field.
	AC_COMPCTRL_SPEED_LOW      = 0x0       // Low speed
	AC_COMPCTRL_SPEED_HIGH     = 0x1       // High speed
	AC_COMPCTRL_INTSEL_Pos     = 0x5       // Position of INTSEL field.
	AC_COMPCTRL_INTSEL_Msk     = 0x60      // Bit mask of INTSEL field.
	AC_COMPCTRL_INTSEL_TOGGLE  = 0x0       // Interrupt on comparator output toggle
	AC_COMPCTRL_INTSEL_RISING  = 0x1       // Interrupt on comparator output rising
	AC_COMPCTRL_INTSEL_FALLING = 0x2       // Interrupt on comparator output falling
	AC_COMPCTRL_INTSEL_EOC     = 0x3       // Interrupt on end of comparison (single-shot mode only)
	AC_COMPCTRL_MUXNEG_Pos     = 0x8       // Position of MUXNEG field.
	AC_COMPCTRL_MUXNEG_Msk     = 0x700     // Bit mask of MUXNEG field.
	AC_COMPCTRL_MUXNEG_PIN0    = 0x0       // I/O pin 0
	AC_COMPCTRL_MUXNEG_PIN1    = 0x1       // I/O pin 1
	AC_COMPCTRL_MUXNEG_PIN2    = 0x2       // I/O pin 2
	AC_COMPCTRL_MUXNEG_PIN3    = 0x3       // I/O pin 3
	AC_COMPCTRL_MUXNEG_GND     = 0x4       // Ground
	AC_COMPCTRL_MUXNEG_VSCALE  = 0x5       // VDD scaler
	AC_COMPCTRL_MUXNEG_BANDGAP = 0x6       // Internal bandgap voltage
	AC_COMPCTRL_MUXNEG_DAC     = 0x7       // DAC output
	AC_COMPCTRL_MUXPOS_Pos     = 0xc       // Position of MUXPOS field.
	AC_COMPCTRL_MUXPOS_Msk     = 0x3000    // Bit mask of MUXPOS field.
	AC_COMPCTRL_MUXPOS_PIN0    = 0x0       // I/O pin 0
	AC_COMPCTRL_MUXPOS_PIN1    = 0x1       // I/O pin 1
	AC_COMPCTRL_MUXPOS_PIN2    = 0x2       // I/O pin 2
	AC_COMPCTRL_MUXPOS_PIN3    = 0x3       // I/O pin 3
	AC_COMPCTRL_SWAP_Pos       = 0xf       // Position of SWAP field.
	AC_COMPCTRL_SWAP_Msk       = 0x8000    // Bit mask of SWAP field.
	AC_COMPCTRL_SWAP           = 0x8000    // Bit SWAP.
	AC_COMPCTRL_OUT_Pos        = 0x10      // Position of OUT field.
	AC_COMPCTRL_OUT_Msk        = 0x30000   // Bit mask of OUT field.
	AC_COMPCTRL_OUT_OFF        = 0x0       // The output of COMPn is not routed to the COMPn I/O port
	AC_COMPCTRL_OUT_ASYNC      = 0x1       // The asynchronous output of COMPn is routed to the COMPn I/O port
	AC_COMPCTRL_OUT_SYNC       = 0x2       // The synchronous output (including filtering) of COMPn is routed to the COMPn I/O port
	AC_COMPCTRL_HYST_Pos       = 0x13      // Position of HYST field.
	AC_COMPCTRL_HYST_Msk       = 0x80000   // Bit mask of HYST field.
	AC_COMPCTRL_HYST           = 0x80000   // Bit HYST.
	AC_COMPCTRL_FLEN_Pos       = 0x18      // Position of FLEN field.
	AC_COMPCTRL_FLEN_Msk       = 0x7000000 // Bit mask of FLEN field.
	AC_COMPCTRL_FLEN_OFF       = 0x0       // No filtering
	AC_COMPCTRL_FLEN_MAJ3      = 0x1       // 3-bit majority function (2 of 3)
	AC_COMPCTRL_FLEN_MAJ5      = 0x2       // 5-bit majority function (3 of 5)

	// SCALER0: Scaler n
	AC_SCALER_VALUE_Pos = 0x0  // Position of VALUE field.
	AC_SCALER_VALUE_Msk = 0x3f // Bit mask of VALUE field.
)

// Bitfields for ADC: Analog Digital Converter
const (
	// CTRLA: Control A
	ADC_CTRLA_SWRST_Pos    = 0x0 // Position of SWRST field.
	ADC_CTRLA_SWRST_Msk    = 0x1 // Bit mask of SWRST field.
	ADC_CTRLA_SWRST        = 0x1 // Bit SWRST.
	ADC_CTRLA_ENABLE_Pos   = 0x1 // Position of ENABLE field.
	ADC_CTRLA_ENABLE_Msk   = 0x2 // Bit mask of ENABLE field.
	ADC_CTRLA_ENABLE       = 0x2 // Bit ENABLE.
	ADC_CTRLA_RUNSTDBY_Pos = 0x2 // Position of RUNSTDBY field.
	ADC_CTRLA_RUNSTDBY_Msk = 0x4 // Bit mask of RUNSTDBY field.
	ADC_CTRLA_RUNSTDBY     = 0x4 // Bit RUNSTDBY.

	// REFCTRL: Reference Control
	ADC_REFCTRL_REFSEL_Pos     = 0x0  // Position of REFSEL field.
	ADC_REFCTRL_REFSEL_Msk     = 0xf  // Bit mask of REFSEL field.
	ADC_REFCTRL_REFSEL_INT1V   = 0x0  // 1.0V voltage reference
	ADC_REFCTRL_REFSEL_INTVCC0 = 0x1  // 1/1.48 VDDANA
	ADC_REFCTRL_REFSEL_INTVCC1 = 0x2  // 1/2 VDDANA (only for VDDANA > 2.0V)
	ADC_REFCTRL_REFSEL_AREFA   = 0x3  // External reference
	ADC_REFCTRL_REFSEL_AREFB   = 0x4  // External reference
	ADC_REFCTRL_REFCOMP_Pos    = 0x7  // Position of REFCOMP field.
	ADC_REFCTRL_REFCOMP_Msk    = 0x80 // Bit mask of REFCOMP field.
	ADC_REFCTRL_REFCOMP        = 0x80 // Bit REFCOMP.

	// AVGCTRL: Average Control
	ADC_AVGCTRL_SAMPLENUM_Pos  = 0x0  // Position of SAMPLENUM field.
	ADC_AVGCTRL_SAMPLENUM_Msk  = 0xf  // Bit mask of SAMPLENUM field.
	ADC_AVGCTRL_SAMPLENUM_1    = 0x0  // 1 sample
	ADC_AVGCTRL_SAMPLENUM_2    = 0x1  // 2 samples
	ADC_AVGCTRL_SAMPLENUM_4    = 0x2  // 4 samples
	ADC_AVGCTRL_SAMPLENUM_8    = 0x3  // 8 samples
	ADC_AVGCTRL_SAMPLENUM_16   = 0x4  // 16 samples
	ADC_AVGCTRL_SAMPLENUM_32   = 0x5  // 32 samples
	ADC_AVGCTRL_SAMPLENUM_64   = 0x6  // 64 samples
	ADC_AVGCTRL_SAMPLENUM_128  = 0x7  // 128 samples
	ADC_AVGCTRL_SAMPLENUM_256  = 0x8  // 256 samples
	ADC_AVGCTRL_SAMPLENUM_512  = 0x9  // 512 samples
	ADC_AVGCTRL_SAMPLENUM_1024 = 0xa  // 1024 samples
	ADC_AVGCTRL_ADJRES_Pos     = 0x4  // Position of ADJRES field.
	ADC_AVGCTRL_ADJRES_Msk     = 0x70 // Bit mask of ADJRES field.

	// SAMPCTRL: Sampling Time Control
	ADC_SAMPCTRL_SAMPLEN_Pos = 0x0  // Position of SAMPLEN field.
	ADC_SAMPCTRL_SAMPLEN_Msk = 0x3f // Bit mask of SAMPLEN field.

	// CTRLB: Control B
	ADC_CTRLB_DIFFMODE_Pos     = 0x0   // Position of DIFFMODE field.
	ADC_CTRLB_DIFFMODE_Msk     = 0x1   // Bit mask of DIFFMODE field.
	ADC_CTRLB_DIFFMODE         = 0x1   // Bit DIFFMODE.
	ADC_CTRLB_LEFTADJ_Pos      = 0x1   // Position of LEFTADJ field.
	ADC_CTRLB_LEFTADJ_Msk      = 0x2   // Bit mask of LEFTADJ field.
	ADC_CTRLB_LEFTADJ          = 0x2   // Bit LEFTADJ.
	ADC_CTRLB_FREERUN_Pos      = 0x2   // Position of FREERUN field.
	ADC_CTRLB_FREERUN_Msk      = 0x4   // Bit mask of FREERUN field.
	ADC_CTRLB_FREERUN          = 0x4   // Bit FREERUN.
	ADC_CTRLB_CORREN_Pos       = 0x3   // Position of CORREN field.
	ADC_CTRLB_CORREN_Msk       = 0x8   // Bit mask of CORREN field.
	ADC_CTRLB_CORREN           = 0x8   // Bit CORREN.
	ADC_CTRLB_RESSEL_Pos       = 0x4   // Position of RESSEL field.
	ADC_CTRLB_RESSEL_Msk       = 0x30  // Bit mask of RESSEL field.
	ADC_CTRLB_RESSEL_12BIT     = 0x0   // 12-bit result
	ADC_CTRLB_RESSEL_16BIT     = 0x1   // For averaging mode output
	ADC_CTRLB_RESSEL_10BIT     = 0x2   // 10-bit result
	ADC_CTRLB_RESSEL_8BIT      = 0x3   // 8-bit result
	ADC_CTRLB_PRESCALER_Pos    = 0x8   // Position of PRESCALER field.
	ADC_CTRLB_PRESCALER_Msk    = 0x700 // Bit mask of PRESCALER field.
	ADC_CTRLB_PRESCALER_DIV4   = 0x0   // Peripheral clock divided by 4
	ADC_CTRLB_PRESCALER_DIV8   = 0x1   // Peripheral clock divided by 8
	ADC_CTRLB_PRESCALER_DIV16  = 0x2   // Peripheral clock divided by 16
	ADC_CTRLB_PRESCALER_DIV32  = 0x3   // Peripheral clock divided by 32
	ADC_CTRLB_PRESCALER_DIV64  = 0x4   // Peripheral clock divided by 64
	ADC_CTRLB_PRESCALER_DIV128 = 0x5   // Peripheral clock divided by 128
	ADC_CTRLB_PRESCALER_DIV256 = 0x6   // Peripheral clock divided by 256
	ADC_CTRLB_PRESCALER_DIV512 = 0x7   // Peripheral clock divided by 512

	// WINCTRL: Window Monitor Control
	ADC_WINCTRL_WINMODE_Pos     = 0x0 // Position of WINMODE field.
	ADC_WINCTRL_WINMODE_Msk     = 0x7 // Bit mask of WINMODE field.
	ADC_WINCTRL_WINMODE_DISABLE = 0x0 // No window mode (default)
	ADC_WINCTRL_WINMODE_MODE1   = 0x1 // Mode 1: RESULT > WINLT
	ADC_WINCTRL_WINMODE_MODE2   = 0x2 // Mode 2: RESULT < WINUT
	ADC_WINCTRL_WINMODE_MODE3   = 0x3 // Mode 3: WINLT < RESULT < WINUT
	ADC_WINCTRL_WINMODE_MODE4   = 0x4 // Mode 4: !(WINLT < RESULT < WINUT)

	// SWTRIG: Software Trigger
	ADC_SWTRIG_FLUSH_Pos = 0x0 // Position of FLUSH field.
	ADC_SWTRIG_FLUSH_Msk = 0x1 // Bit mask of FLUSH field.
	ADC_SWTRIG_FLUSH     = 0x1 // Bit FLUSH.
	ADC_SWTRIG_START_Pos = 0x1 // Position of START field.
	ADC_SWTRIG_START_Msk = 0x2 // Bit mask of START field.
	ADC_SWTRIG_START     = 0x2 // Bit START.

	// INPUTCTRL: Input Control
	ADC_INPUTCTRL_MUXPOS_Pos           = 0x0       // Position of MUXPOS field.
	ADC_INPUTCTRL_MUXPOS_Msk           = 0x1f      // Bit mask of MUXPOS field.
	ADC_INPUTCTRL_MUXPOS_PIN0          = 0x0       // ADC AIN0 Pin
	ADC_INPUTCTRL_MUXPOS_PIN1          = 0x1       // ADC AIN1 Pin
	ADC_INPUTCTRL_MUXPOS_PIN2          = 0x2       // ADC AIN2 Pin
	ADC_INPUTCTRL_MUXPOS_PIN3          = 0x3       // ADC AIN3 Pin
	ADC_INPUTCTRL_MUXPOS_PIN4          = 0x4       // ADC AIN4 Pin
	ADC_INPUTCTRL_MUXPOS_PIN5          = 0x5       // ADC AIN5 Pin
	ADC_INPUTCTRL_MUXPOS_PIN6          = 0x6       // ADC AIN6 Pin
	ADC_INPUTCTRL_MUXPOS_PIN7          = 0x7       // ADC AIN7 Pin
	ADC_INPUTCTRL_MUXPOS_PIN8          = 0x8       // ADC AIN8 Pin
	ADC_INPUTCTRL_MUXPOS_PIN9          = 0x9       // ADC AIN9 Pin
	ADC_INPUTCTRL_MUXPOS_PIN10         = 0xa       // ADC AIN10 Pin
	ADC_INPUTCTRL_MUXPOS_PIN11         = 0xb       // ADC AIN11 Pin
	ADC_INPUTCTRL_MUXPOS_PIN12         = 0xc       // ADC AIN12 Pin
	ADC_INPUTCTRL_MUXPOS_PIN13         = 0xd       // ADC AIN13 Pin
	ADC_INPUTCTRL_MUXPOS_PIN14         = 0xe       // ADC AIN14 Pin
	ADC_INPUTCTRL_MUXPOS_PIN15         = 0xf       // ADC AIN15 Pin
	ADC_INPUTCTRL_MUXPOS_PIN16         = 0x10      // ADC AIN16 Pin
	ADC_INPUTCTRL_MUXPOS_PIN17         = 0x11      // ADC AIN17 Pin
	ADC_INPUTCTRL_MUXPOS_PIN18         = 0x12      // ADC AIN18 Pin
	ADC_INPUTCTRL_MUXPOS_PIN19         = 0x13      // ADC AIN19 Pin
	ADC_INPUTCTRL_MUXPOS_TEMP          = 0x18      // Temperature Reference
	ADC_INPUTCTRL_MUXPOS_BANDGAP       = 0x19      // Bandgap Voltage
	ADC_INPUTCTRL_MUXPOS_SCALEDCOREVCC = 0x1a      // 1/4  Scaled Core Supply
	ADC_INPUTCTRL_MUXPOS_SCALEDIOVCC   = 0x1b      // 1/4  Scaled I/O Supply
	ADC_INPUTCTRL_MUXPOS_DAC           = 0x1c      // DAC Output
	ADC_INPUTCTRL_MUXNEG_Pos           = 0x8       // Position of MUXNEG field.
	ADC_INPUTCTRL_MUXNEG_Msk           = 0x1f00    // Bit mask of MUXNEG field.
	ADC_INPUTCTRL_MUXNEG_PIN0          = 0x0       // ADC AIN0 Pin
	ADC_INPUTCTRL_MUXNEG_PIN1          = 0x1       // ADC AIN1 Pin
	ADC_INPUTCTRL_MUXNEG_PIN2          = 0x2       // ADC AIN2 Pin
	ADC_INPUTCTRL_MUXNEG_PIN3          = 0x3       // ADC AIN3 Pin
	ADC_INPUTCTRL_MUXNEG_PIN4          = 0x4       // ADC AIN4 Pin
	ADC_INPUTCTRL_MUXNEG_PIN5          = 0x5       // ADC AIN5 Pin
	ADC_INPUTCTRL_MUXNEG_PIN6          = 0x6       // ADC AIN6 Pin
	ADC_INPUTCTRL_MUXNEG_PIN7          = 0x7       // ADC AIN7 Pin
	ADC_INPUTCTRL_MUXNEG_GND           = 0x18      // Internal Ground
	ADC_INPUTCTRL_MUXNEG_IOGND         = 0x19      // I/O Ground
	ADC_INPUTCTRL_INPUTSCAN_Pos        = 0x10      // Position of INPUTSCAN field.
	ADC_INPUTCTRL_INPUTSCAN_Msk        = 0xf0000   // Bit mask of INPUTSCAN field.
	ADC_INPUTCTRL_INPUTOFFSET_Pos      = 0x14      // Position of INPUTOFFSET field.
	ADC_INPUTCTRL_INPUTOFFSET_Msk      = 0xf00000  // Bit mask of INPUTOFFSET field.
	ADC_INPUTCTRL_GAIN_Pos             = 0x18      // Position of GAIN field.
	ADC_INPUTCTRL_GAIN_Msk             = 0xf000000 // Bit mask of GAIN field.
	ADC_INPUTCTRL_GAIN_1X              = 0x0       // 1x
	ADC_INPUTCTRL_GAIN_2X              = 0x1       // 2x
	ADC_INPUTCTRL_GAIN_4X              = 0x2       // 4x
	ADC_INPUTCTRL_GAIN_8X              = 0x3       // 8x
	ADC_INPUTCTRL_GAIN_16X             = 0x4       // 16x
	ADC_INPUTCTRL_GAIN_DIV2            = 0xf       // 1/2x

	// EVCTRL: Event Control
	ADC_EVCTRL_STARTEI_Pos  = 0x0  // Position of STARTEI field.
	ADC_EVCTRL_STARTEI_Msk  = 0x1  // Bit mask of STARTEI field.
	ADC_EVCTRL_STARTEI      = 0x1  // Bit STARTEI.
	ADC_EVCTRL_SYNCEI_Pos   = 0x1  // Position of SYNCEI field.
	ADC_EVCTRL_SYNCEI_Msk   = 0x2  // Bit mask of SYNCEI field.
	ADC_EVCTRL_SYNCEI       = 0x2  // Bit SYNCEI.
	ADC_EVCTRL_RESRDYEO_Pos = 0x4  // Position of RESRDYEO field.
	ADC_EVCTRL_RESRDYEO_Msk = 0x10 // Bit mask of RESRDYEO field.
	ADC_EVCTRL_RESRDYEO     = 0x10 // Bit RESRDYEO.
	ADC_EVCTRL_WINMONEO_Pos = 0x5  // Position of WINMONEO field.
	ADC_EVCTRL_WINMONEO_Msk = 0x20 // Bit mask of WINMONEO field.
	ADC_EVCTRL_WINMONEO     = 0x20 // Bit WINMONEO.

	// INTENCLR: Interrupt Enable Clear
	ADC_INTENCLR_RESRDY_Pos  = 0x0 // Position of RESRDY field.
	ADC_INTENCLR_RESRDY_Msk  = 0x1 // Bit mask of RESRDY field.
	ADC_INTENCLR_RESRDY      = 0x1 // Bit RESRDY.
	ADC_INTENCLR_OVERRUN_Pos = 0x1 // Position of OVERRUN field.
	ADC_INTENCLR_OVERRUN_Msk = 0x2 // Bit mask of OVERRUN field.
	ADC_INTENCLR_OVERRUN     = 0x2 // Bit OVERRUN.
	ADC_INTENCLR_WINMON_Pos  = 0x2 // Position of WINMON field.
	ADC_INTENCLR_WINMON_Msk  = 0x4 // Bit mask of WINMON field.
	ADC_INTENCLR_WINMON      = 0x4 // Bit WINMON.
	ADC_INTENCLR_SYNCRDY_Pos = 0x3 // Position of SYNCRDY field.
	ADC_INTENCLR_SYNCRDY_Msk = 0x8 // Bit mask of SYNCRDY field.
	ADC_INTENCLR_SYNCRDY     = 0x8 // Bit SYNCRDY.

	// INTENSET: Interrupt Enable Set
	ADC_INTENSET_RESRDY_Pos  = 0x0 // Position of RESRDY field.
	ADC_INTENSET_RESRDY_Msk  = 0x1 // Bit mask of RESRDY field.
	ADC_INTENSET_RESRDY      = 0x1 // Bit RESRDY.
	ADC_INTENSET_OVERRUN_Pos = 0x1 // Position of OVERRUN field.
	ADC_INTENSET_OVERRUN_Msk = 0x2 // Bit mask of OVERRUN field.
	ADC_INTENSET_OVERRUN     = 0x2 // Bit OVERRUN.
	ADC_INTENSET_WINMON_Pos  = 0x2 // Position of WINMON field.
	ADC_INTENSET_WINMON_Msk  = 0x4 // Bit mask of WINMON field.
	ADC_INTENSET_WINMON      = 0x4 // Bit WINMON.
	ADC_INTENSET_SYNCRDY_Pos = 0x3 // Position of SYNCRDY field.
	ADC_INTENSET_SYNCRDY_Msk = 0x8 // Bit mask of SYNCRDY field.
	ADC_INTENSET_SYNCRDY     = 0x8 // Bit SYNCRDY.

	// INTFLAG: Interrupt Flag Status and Clear
	ADC_INTFLAG_RESRDY_Pos  = 0x0 // Position of RESRDY field.
	ADC_INTFLAG_RESRDY_Msk  = 0x1 // Bit mask of RESRDY field.
	ADC_INTFLAG_RESRDY      = 0x1 // Bit RESRDY.
	ADC_INTFLAG_OVERRUN_Pos = 0x1 // Position of OVERRUN field.
	ADC_INTFLAG_OVERRUN_Msk = 0x2 // Bit mask of OVERRUN field.
	ADC_INTFLAG_OVERRUN     = 0x2 // Bit OVERRUN.
	ADC_INTFLAG_WINMON_Pos  = 0x2 // Position of WINMON field.
	ADC_INTFLAG_WINMON_Msk  = 0x4 // Bit mask of WINMON field.
	ADC_INTFLAG_WINMON      = 0x4 // Bit WINMON.
	ADC_INTFLAG_SYNCRDY_Pos = 0x3 // Position of SYNCRDY field.
	ADC_INTFLAG_SYNCRDY_Msk = 0x8 // Bit mask of SYNCRDY field.
	ADC_INTFLAG_SYNCRDY     = 0x8 // Bit SYNCRDY.

	// STATUS: Status
	ADC_STATUS_SYNCBUSY_Pos = 0x7  // Position of SYNCBUSY field.
	ADC_STATUS_SYNCBUSY_Msk = 0x80 // Bit mask of SYNCBUSY field.
	ADC_STATUS_SYNCBUSY     = 0x80 // Bit SYNCBUSY.

	// RESULT: Result
	ADC_RESULT_RESULT_Pos = 0x0    // Position of RESULT field.
	ADC_RESULT_RESULT_Msk = 0xffff // Bit mask of RESULT field.

	// WINLT: Window Monitor Lower Threshold
	ADC_WINLT_WINLT_Pos = 0x0    // Position of WINLT field.
	ADC_WINLT_WINLT_Msk = 0xffff // Bit mask of WINLT field.

	// WINUT: Window Monitor Upper Threshold
	ADC_WINUT_WINUT_Pos = 0x0    // Position of WINUT field.
	ADC_WINUT_WINUT_Msk = 0xffff // Bit mask of WINUT field.

	// GAINCORR: Gain Correction
	ADC_GAINCORR_GAINCORR_Pos = 0x0   // Position of GAINCORR field.
	ADC_GAINCORR_GAINCORR_Msk = 0xfff // Bit mask of GAINCORR field.

	// OFFSETCORR: Offset Correction
	ADC_OFFSETCORR_OFFSETCORR_Pos = 0x0   // Position of OFFSETCORR field.
	ADC_OFFSETCORR_OFFSETCORR_Msk = 0xfff // Bit mask of OFFSETCORR field.

	// CALIB: Calibration
	ADC_CALIB_LINEARITY_CAL_Pos = 0x0   // Position of LINEARITY_CAL field.
	ADC_CALIB_LINEARITY_CAL_Msk = 0xff  // Bit mask of LINEARITY_CAL field.
	ADC_CALIB_BIAS_CAL_Pos      = 0x8   // Position of BIAS_CAL field.
	ADC_CALIB_BIAS_CAL_Msk      = 0x700 // Bit mask of BIAS_CAL field.

	// DBGCTRL: Debug Control
	ADC_DBGCTRL_DBGRUN_Pos = 0x0 // Position of DBGRUN field.
	ADC_DBGCTRL_DBGRUN_Msk = 0x1 // Bit mask of DBGRUN field.
	ADC_DBGCTRL_DBGRUN     = 0x1 // Bit DBGRUN.
)

// Bitfields for DAC: Digital Analog Converter
const (
	// CTRLA: Control A
	DAC_CTRLA_SWRST_Pos    = 0x0 // Position of SWRST field.
	DAC_CTRLA_SWRST_Msk    = 0x1 // Bit mask of SWRST field.
	DAC_CTRLA_SWRST        = 0x1 // Bit SWRST.
	DAC_CTRLA_ENABLE_Pos   = 0x1 // Position of ENABLE field.
	DAC_CTRLA_ENABLE_Msk   = 0x2 // Bit mask of ENABLE field.
	DAC_CTRLA_ENABLE       = 0x2 // Bit ENABLE.
	DAC_CTRLA_RUNSTDBY_Pos = 0x2 // Position of RUNSTDBY field.
	DAC_CTRLA_RUNSTDBY_Msk = 0x4 // Bit mask of RUNSTDBY field.
	DAC_CTRLA_RUNSTDBY     = 0x4 // Bit RUNSTDBY.

	// CTRLB: Control B
	DAC_CTRLB_EOEN_Pos     = 0x0  // Position of EOEN field.
	DAC_CTRLB_EOEN_Msk     = 0x1  // Bit mask of EOEN field.
	DAC_CTRLB_EOEN         = 0x1  // Bit EOEN.
	DAC_CTRLB_IOEN_Pos     = 0x1  // Position of IOEN field.
	DAC_CTRLB_IOEN_Msk     = 0x2  // Bit mask of IOEN field.
	DAC_CTRLB_IOEN         = 0x2  // Bit IOEN.
	DAC_CTRLB_LEFTADJ_Pos  = 0x2  // Position of LEFTADJ field.
	DAC_CTRLB_LEFTADJ_Msk  = 0x4  // Bit mask of LEFTADJ field.
	DAC_CTRLB_LEFTADJ      = 0x4  // Bit LEFTADJ.
	DAC_CTRLB_VPD_Pos      = 0x3  // Position of VPD field.
	DAC_CTRLB_VPD_Msk      = 0x8  // Bit mask of VPD field.
	DAC_CTRLB_VPD          = 0x8  // Bit VPD.
	DAC_CTRLB_BDWP_Pos     = 0x4  // Position of BDWP field.
	DAC_CTRLB_BDWP_Msk     = 0x10 // Bit mask of BDWP field.
	DAC_CTRLB_BDWP         = 0x10 // Bit BDWP.
	DAC_CTRLB_REFSEL_Pos   = 0x6  // Position of REFSEL field.
	DAC_CTRLB_REFSEL_Msk   = 0xc0 // Bit mask of REFSEL field.
	DAC_CTRLB_REFSEL_INT1V = 0x0  // Internal 1.0V reference
	DAC_CTRLB_REFSEL_AVCC  = 0x1  // AVCC
	DAC_CTRLB_REFSEL_VREFP = 0x2  // External reference

	// EVCTRL: Event Control
	DAC_EVCTRL_STARTEI_Pos = 0x0 // Position of STARTEI field.
	DAC_EVCTRL_STARTEI_Msk = 0x1 // Bit mask of STARTEI field.
	DAC_EVCTRL_STARTEI     = 0x1 // Bit STARTEI.
	DAC_EVCTRL_EMPTYEO_Pos = 0x1 // Position of EMPTYEO field.
	DAC_EVCTRL_EMPTYEO_Msk = 0x2 // Bit mask of EMPTYEO field.
	DAC_EVCTRL_EMPTYEO     = 0x2 // Bit EMPTYEO.

	// INTENCLR: Interrupt Enable Clear
	DAC_INTENCLR_UNDERRUN_Pos = 0x0 // Position of UNDERRUN field.
	DAC_INTENCLR_UNDERRUN_Msk = 0x1 // Bit mask of UNDERRUN field.
	DAC_INTENCLR_UNDERRUN     = 0x1 // Bit UNDERRUN.
	DAC_INTENCLR_EMPTY_Pos    = 0x1 // Position of EMPTY field.
	DAC_INTENCLR_EMPTY_Msk    = 0x2 // Bit mask of EMPTY field.
	DAC_INTENCLR_EMPTY        = 0x2 // Bit EMPTY.
	DAC_INTENCLR_SYNCRDY_Pos  = 0x2 // Position of SYNCRDY field.
	DAC_INTENCLR_SYNCRDY_Msk  = 0x4 // Bit mask of SYNCRDY field.
	DAC_INTENCLR_SYNCRDY      = 0x4 // Bit SYNCRDY.

	// INTENSET: Interrupt Enable Set
	DAC_INTENSET_UNDERRUN_Pos = 0x0 // Position of UNDERRUN field.
	DAC_INTENSET_UNDERRUN_Msk = 0x1 // Bit mask of UNDERRUN field.
	DAC_INTENSET_UNDERRUN     = 0x1 // Bit UNDERRUN.
	DAC_INTENSET_EMPTY_Pos    = 0x1 // Position of EMPTY field.
	DAC_INTENSET_EMPTY_Msk    = 0x2 // Bit mask of EMPTY field.
	DAC_INTENSET_EMPTY        = 0x2 // Bit EMPTY.
	DAC_INTENSET_SYNCRDY_Pos  = 0x2 // Position of SYNCRDY field.
	DAC_INTENSET_SYNCRDY_Msk  = 0x4 // Bit mask of SYNCRDY field.
	DAC_INTENSET_SYNCRDY      = 0x4 // Bit SYNCRDY.

	// INTFLAG: Interrupt Flag Status and Clear
	DAC_INTFLAG_UNDERRUN_Pos = 0x0 // Position of UNDERRUN field.
	DAC_INTFLAG_UNDERRUN_Msk = 0x1 // Bit mask of UNDERRUN field.
	DAC_INTFLAG_UNDERRUN     = 0x1 // Bit UNDERRUN.
	DAC_INTFLAG_EMPTY_Pos    = 0x1 // Position of EMPTY field.
	DAC_INTFLAG_EMPTY_Msk    = 0x2 // Bit mask of EMPTY field.
	DAC_INTFLAG_EMPTY        = 0x2 // Bit EMPTY.
	DAC_INTFLAG_SYNCRDY_Pos  = 0x2 // Position of SYNCRDY field.
	DAC_INTFLAG_SYNCRDY_Msk  = 0x4 // Bit mask of SYNCRDY field.
	DAC_INTFLAG_SYNCRDY      = 0x4 // Bit SYNCRDY.

	// STATUS: Status
	DAC_STATUS_SYNCBUSY_Pos = 0x7  // Position of SYNCBUSY field.
	DAC_STATUS_SYNCBUSY_Msk = 0x80 // Bit mask of SYNCBUSY field.
	DAC_STATUS_SYNCBUSY     = 0x80 // Bit SYNCBUSY.

	// DATA: Data
	DAC_DATA_DATA_Pos = 0x0    // Position of DATA field.
	DAC_DATA_DATA_Msk = 0xffff // Bit mask of DATA field.

	// DATABUF: Data Buffer
	DAC_DATABUF_DATABUF_Pos = 0x0    // Position of DATABUF field.
	DAC_DATABUF_DATABUF_Msk = 0xffff // Bit mask of DATABUF field.
)

// Bitfields for DMAC: Direct Memory Access Controller
const (
	// CTRL: Control
	DMAC_CTRL_SWRST_Pos     = 0x0   // Position of SWRST field.
	DMAC_CTRL_SWRST_Msk     = 0x1   // Bit mask of SWRST field.
	DMAC_CTRL_SWRST         = 0x1   // Bit SWRST.
	DMAC_CTRL_DMAENABLE_Pos = 0x1   // Position of DMAENABLE field.
	DMAC_CTRL_DMAENABLE_Msk = 0x2   // Bit mask of DMAENABLE field.
	DMAC_CTRL_DMAENABLE     = 0x2   // Bit DMAENABLE.
	DMAC_CTRL_CRCENABLE_Pos = 0x2   // Position of CRCENABLE field.
	DMAC_CTRL_CRCENABLE_Msk = 0x4   // Bit mask of CRCENABLE field.
	DMAC_CTRL_CRCENABLE     = 0x4   // Bit CRCENABLE.
	DMAC_CTRL_LVLEN0_Pos    = 0x8   // Position of LVLEN0 field.
	DMAC_CTRL_LVLEN0_Msk    = 0x100 // Bit mask of LVLEN0 field.
	DMAC_CTRL_LVLEN0        = 0x100 // Bit LVLEN0.
	DMAC_CTRL_LVLEN1_Pos    = 0x9   // Position of LVLEN1 field.
	DMAC_CTRL_LVLEN1_Msk    = 0x200 // Bit mask of LVLEN1 field.
	DMAC_CTRL_LVLEN1        = 0x200 // Bit LVLEN1.
	DMAC_CTRL_LVLEN2_Pos    = 0xa   // Position of LVLEN2 field.
	DMAC_CTRL_LVLEN2_Msk    = 0x400 // Bit mask of LVLEN2 field.
	DMAC_CTRL_LVLEN2        = 0x400 // Bit LVLEN2.
	DMAC_CTRL_LVLEN3_Pos    = 0xb   // Position of LVLEN3 field.
	DMAC_CTRL_LVLEN3_Msk    = 0x800 // Bit mask of LVLEN3 field.
	DMAC_CTRL_LVLEN3        = 0x800 // Bit LVLEN3.

	// CRCCTRL: CRC Control
	DMAC_CRCCTRL_CRCBEATSIZE_Pos   = 0x0    // Position of CRCBEATSIZE field.
	DMAC_CRCCTRL_CRCBEATSIZE_Msk   = 0x3    // Bit mask of CRCBEATSIZE field.
	DMAC_CRCCTRL_CRCBEATSIZE_BYTE  = 0x0    // Byte bus access
	DMAC_CRCCTRL_CRCBEATSIZE_HWORD = 0x1    // Half-word bus access
	DMAC_CRCCTRL_CRCBEATSIZE_WORD  = 0x2    // Word bus access
	DMAC_CRCCTRL_CRCPOLY_Pos       = 0x2    // Position of CRCPOLY field.
	DMAC_CRCCTRL_CRCPOLY_Msk       = 0xc    // Bit mask of CRCPOLY field.
	DMAC_CRCCTRL_CRCPOLY_CRC16     = 0x0    // CRC-16 (CRC-CCITT)
	DMAC_CRCCTRL_CRCPOLY_CRC32     = 0x1    // CRC32 (IEEE 802.3)
	DMAC_CRCCTRL_CRCSRC_Pos        = 0x8    // Position of CRCSRC field.
	DMAC_CRCCTRL_CRCSRC_Msk        = 0x3f00 // Bit mask of CRCSRC field.
	DMAC_CRCCTRL_CRCSRC_NOACT      = 0x0    // No action
	DMAC_CRCCTRL_CRCSRC_IO         = 0x1    // I/O interface

	// CRCDATAIN: CRC Data Input
	DMAC_CRCDATAIN_CRCDATAIN_Pos = 0x0        // Position of CRCDATAIN field.
	DMAC_CRCDATAIN_CRCDATAIN_Msk = 0xffffffff // Bit mask of CRCDATAIN field.

	// CRCCHKSUM: CRC Checksum
	DMAC_CRCCHKSUM_CRCCHKSUM_Pos = 0x0        // Position of CRCCHKSUM field.
	DMAC_CRCCHKSUM_CRCCHKSUM_Msk = 0xffffffff // Bit mask of CRCCHKSUM field.

	// CRCSTATUS: CRC Status
	DMAC_CRCSTATUS_CRCBUSY_Pos = 0x0 // Position of CRCBUSY field.
	DMAC_CRCSTATUS_CRCBUSY_Msk = 0x1 // Bit mask of CRCBUSY field.
	DMAC_CRCSTATUS_CRCBUSY     = 0x1 // Bit CRCBUSY.
	DMAC_CRCSTATUS_CRCZERO_Pos = 0x1 // Position of CRCZERO field.
	DMAC_CRCSTATUS_CRCZERO_Msk = 0x2 // Bit mask of CRCZERO field.
	DMAC_CRCSTATUS_CRCZERO     = 0x2 // Bit CRCZERO.

	// DBGCTRL: Debug Control
	DMAC_DBGCTRL_DBGRUN_Pos = 0x0 // Position of DBGRUN field.
	DMAC_DBGCTRL_DBGRUN_Msk = 0x1 // Bit mask of DBGRUN field.
	DMAC_DBGCTRL_DBGRUN     = 0x1 // Bit DBGRUN.

	// QOSCTRL: QOS Control
	DMAC_QOSCTRL_WRBQOS_Pos     = 0x0  // Position of WRBQOS field.
	DMAC_QOSCTRL_WRBQOS_Msk     = 0x3  // Bit mask of WRBQOS field.
	DMAC_QOSCTRL_WRBQOS_DISABLE = 0x0  // Background (no sensitive operation)
	DMAC_QOSCTRL_WRBQOS_LOW     = 0x1  // Sensitive Bandwidth
	DMAC_QOSCTRL_WRBQOS_MEDIUM  = 0x2  // Sensitive Latency
	DMAC_QOSCTRL_WRBQOS_HIGH    = 0x3  // Critical Latency
	DMAC_QOSCTRL_FQOS_Pos       = 0x2  // Position of FQOS field.
	DMAC_QOSCTRL_FQOS_Msk       = 0xc  // Bit mask of FQOS field.
	DMAC_QOSCTRL_FQOS_DISABLE   = 0x0  // Background (no sensitive operation)
	DMAC_QOSCTRL_FQOS_LOW       = 0x1  // Sensitive Bandwidth
	DMAC_QOSCTRL_FQOS_MEDIUM    = 0x2  // Sensitive Latency
	DMAC_QOSCTRL_FQOS_HIGH      = 0x3  // Critical Latency
	DMAC_QOSCTRL_DQOS_Pos       = 0x4  // Position of DQOS field.
	DMAC_QOSCTRL_DQOS_Msk       = 0x30 // Bit mask of DQOS field.
	DMAC_QOSCTRL_DQOS_DISABLE   = 0x0  // Background (no sensitive operation)
	DMAC_QOSCTRL_DQOS_LOW       = 0x1  // Sensitive Bandwidth
	DMAC_QOSCTRL_DQOS_MEDIUM    = 0x2  // Sensitive Latency
	DMAC_QOSCTRL_DQOS_HIGH      = 0x3  // Critical Latency

	// SWTRIGCTRL: Software Trigger Control
	DMAC_SWTRIGCTRL_SWTRIG0_Pos  = 0x0   // Position of SWTRIG0 field.
	DMAC_SWTRIGCTRL_SWTRIG0_Msk  = 0x1   // Bit mask of SWTRIG0 field.
	DMAC_SWTRIGCTRL_SWTRIG0      = 0x1   // Bit SWTRIG0.
	DMAC_SWTRIGCTRL_SWTRIG1_Pos  = 0x1   // Position of SWTRIG1 field.
	DMAC_SWTRIGCTRL_SWTRIG1_Msk  = 0x2   // Bit mask of SWTRIG1 field.
	DMAC_SWTRIGCTRL_SWTRIG1      = 0x2   // Bit SWTRIG1.
	DMAC_SWTRIGCTRL_SWTRIG2_Pos  = 0x2   // Position of SWTRIG2 field.
	DMAC_SWTRIGCTRL_SWTRIG2_Msk  = 0x4   // Bit mask of SWTRIG2 field.
	DMAC_SWTRIGCTRL_SWTRIG2      = 0x4   // Bit SWTRIG2.
	DMAC_SWTRIGCTRL_SWTRIG3_Pos  = 0x3   // Position of SWTRIG3 field.
	DMAC_SWTRIGCTRL_SWTRIG3_Msk  = 0x8   // Bit mask of SWTRIG3 field.
	DMAC_SWTRIGCTRL_SWTRIG3      = 0x8   // Bit SWTRIG3.
	DMAC_SWTRIGCTRL_SWTRIG4_Pos  = 0x4   // Position of SWTRIG4 field.
	DMAC_SWTRIGCTRL_SWTRIG4_Msk  = 0x10  // Bit mask of SWTRIG4 field.
	DMAC_SWTRIGCTRL_SWTRIG4      = 0x10  // Bit SWTRIG4.
	DMAC_SWTRIGCTRL_SWTRIG5_Pos  = 0x5   // Position of SWTRIG5 field.
	DMAC_SWTRIGCTRL_SWTRIG5_Msk  = 0x20  // Bit mask of SWTRIG5 field.
	DMAC_SWTRIGCTRL_SWTRIG5      = 0x20  // Bit SWTRIG5.
	DMAC_SWTRIGCTRL_SWTRIG6_Pos  = 0x6   // Position of SWTRIG6 field.
	DMAC_SWTRIGCTRL_SWTRIG6_Msk  = 0x40  // Bit mask of SWTRIG6 field.
	DMAC_SWTRIGCTRL_SWTRIG6      = 0x40  // Bit SWTRIG6.
	DMAC_SWTRIGCTRL_SWTRIG7_Pos  = 0x7   // Position of SWTRIG7 field.
	DMAC_SWTRIGCTRL_SWTRIG7_Msk  = 0x80  // Bit mask of SWTRIG7 field.
	DMAC_SWTRIGCTRL_SWTRIG7      = 0x80  // Bit SWTRIG7.
	DMAC_SWTRIGCTRL_SWTRIG8_Pos  = 0x8   // Position of SWTRIG8 field.
	DMAC_SWTRIGCTRL_SWTRIG8_Msk  = 0x100 // Bit mask of SWTRIG8 field.
	DMAC_SWTRIGCTRL_SWTRIG8      = 0x100 // Bit SWTRIG8.
	DMAC_SWTRIGCTRL_SWTRIG9_Pos  = 0x9   // Position of SWTRIG9 field.
	DMAC_SWTRIGCTRL_SWTRIG9_Msk  = 0x200 // Bit mask of SWTRIG9 field.
	DMAC_SWTRIGCTRL_SWTRIG9      = 0x200 // Bit SWTRIG9.
	DMAC_SWTRIGCTRL_SWTRIG10_Pos = 0xa   // Position of SWTRIG10 field.
	DMAC_SWTRIGCTRL_SWTRIG10_Msk = 0x400 // Bit mask of SWTRIG10 field.
	DMAC_SWTRIGCTRL_SWTRIG10     = 0x400 // Bit SWTRIG10.
	DMAC_SWTRIGCTRL_SWTRIG11_Pos = 0xb   // Position of SWTRIG11 field.
	DMAC_SWTRIGCTRL_SWTRIG11_Msk = 0x800 // Bit mask of SWTRIG11 field.
	DMAC_SWTRIGCTRL_SWTRIG11     = 0x800 // Bit SWTRIG11.

	// PRICTRL0: Priority Control 0
	DMAC_PRICTRL0_LVLPRI0_Pos  = 0x0        // Position of LVLPRI0 field.
	DMAC_PRICTRL0_LVLPRI0_Msk  = 0xf        // Bit mask of LVLPRI0 field.
	DMAC_PRICTRL0_RRLVLEN0_Pos = 0x7        // Position of RRLVLEN0 field.
	DMAC_PRICTRL0_RRLVLEN0_Msk = 0x80       // Bit mask of RRLVLEN0 field.
	DMAC_PRICTRL0_RRLVLEN0     = 0x80       // Bit RRLVLEN0.
	DMAC_PRICTRL0_LVLPRI1_Pos  = 0x8        // Position of LVLPRI1 field.
	DMAC_PRICTRL0_LVLPRI1_Msk  = 0xf00      // Bit mask of LVLPRI1 field.
	DMAC_PRICTRL0_RRLVLEN1_Pos = 0xf        // Position of RRLVLEN1 field.
	DMAC_PRICTRL0_RRLVLEN1_Msk = 0x8000     // Bit mask of RRLVLEN1 field.
	DMAC_PRICTRL0_RRLVLEN1     = 0x8000     // Bit RRLVLEN1.
	DMAC_PRICTRL0_LVLPRI2_Pos  = 0x10       // Position of LVLPRI2 field.
	DMAC_PRICTRL0_LVLPRI2_Msk  = 0xf0000    // Bit mask of LVLPRI2 field.
	DMAC_PRICTRL0_RRLVLEN2_Pos = 0x17       // Position of RRLVLEN2 field.
	DMAC_PRICTRL0_RRLVLEN2_Msk = 0x800000   // Bit mask of RRLVLEN2 field.
	DMAC_PRICTRL0_RRLVLEN2     = 0x800000   // Bit RRLVLEN2.
	DMAC_PRICTRL0_LVLPRI3_Pos  = 0x18       // Position of LVLPRI3 field.
	DMAC_PRICTRL0_LVLPRI3_Msk  = 0xf000000  // Bit mask of LVLPRI3 field.
	DMAC_PRICTRL0_RRLVLEN3_Pos = 0x1f       // Position of RRLVLEN3 field.
	DMAC_PRICTRL0_RRLVLEN3_Msk = 0x80000000 // Bit mask of RRLVLEN3 field.
	DMAC_PRICTRL0_RRLVLEN3     = 0x80000000 // Bit RRLVLEN3.

	// INTPEND: Interrupt Pending
	DMAC_INTPEND_ID_Pos    = 0x0    // Position of ID field.
	DMAC_INTPEND_ID_Msk    = 0xf    // Bit mask of ID field.
	DMAC_INTPEND_TERR_Pos  = 0x8    // Position of TERR field.
	DMAC_INTPEND_TERR_Msk  = 0x100  // Bit mask of TERR field.
	DMAC_INTPEND_TERR      = 0x100  // Bit TERR.
	DMAC_INTPEND_TCMPL_Pos = 0x9    // Position of TCMPL field.
	DMAC_INTPEND_TCMPL_Msk = 0x200  // Bit mask of TCMPL field.
	DMAC_INTPEND_TCMPL     = 0x200  // Bit TCMPL.
	DMAC_INTPEND_SUSP_Pos  = 0xa    // Position of SUSP field.
	DMAC_INTPEND_SUSP_Msk  = 0x400  // Bit mask of SUSP field.
	DMAC_INTPEND_SUSP      = 0x400  // Bit SUSP.
	DMAC_INTPEND_FERR_Pos  = 0xd    // Position of FERR field.
	DMAC_INTPEND_FERR_Msk  = 0x2000 // Bit mask of FERR field.
	DMAC_INTPEND_FERR      = 0x2000 // Bit FERR.
	DMAC_INTPEND_BUSY_Pos  = 0xe    // Position of BUSY field.
	DMAC_INTPEND_BUSY_Msk  = 0x4000 // Bit mask of BUSY field.
	DMAC_INTPEND_BUSY      = 0x4000 // Bit BUSY.
	DMAC_INTPEND_PEND_Pos  = 0xf    // Position of PEND field.
	DMAC_INTPEND_PEND_Msk  = 0x8000 // Bit mask of PEND field.
	DMAC_INTPEND_PEND      = 0x8000 // Bit PEND.

	// INTSTATUS: Interrupt Status
	DMAC_INTSTATUS_CHINT0_Pos  = 0x0   // Position of CHINT0 field.
	DMAC_INTSTATUS_CHINT0_Msk  = 0x1   // Bit mask of CHINT0 field.
	DMAC_INTSTATUS_CHINT0      = 0x1   // Bit CHINT0.
	DMAC_INTSTATUS_CHINT1_Pos  = 0x1   // Position of CHINT1 field.
	DMAC_INTSTATUS_CHINT1_Msk  = 0x2   // Bit mask of CHINT1 field.
	DMAC_INTSTATUS_CHINT1      = 0x2   // Bit CHINT1.
	DMAC_INTSTATUS_CHINT2_Pos  = 0x2   // Position of CHINT2 field.
	DMAC_INTSTATUS_CHINT2_Msk  = 0x4   // Bit mask of CHINT2 field.
	DMAC_INTSTATUS_CHINT2      = 0x4   // Bit CHINT2.
	DMAC_INTSTATUS_CHINT3_Pos  = 0x3   // Position of CHINT3 field.
	DMAC_INTSTATUS_CHINT3_Msk  = 0x8   // Bit mask of CHINT3 field.
	DMAC_INTSTATUS_CHINT3      = 0x8   // Bit CHINT3.
	DMAC_INTSTATUS_CHINT4_Pos  = 0x4   // Position of CHINT4 field.
	DMAC_INTSTATUS_CHINT4_Msk  = 0x10  // Bit mask of CHINT4 field.
	DMAC_INTSTATUS_CHINT4      = 0x10  // Bit CHINT4.
	DMAC_INTSTATUS_CHINT5_Pos  = 0x5   // Position of CHINT5 field.
	DMAC_INTSTATUS_CHINT5_Msk  = 0x20  // Bit mask of CHINT5 field.
	DMAC_INTSTATUS_CHINT5      = 0x20  // Bit CHINT5.
	DMAC_INTSTATUS_CHINT6_Pos  = 0x6   // Position of CHINT6 field.
	DMAC_INTSTATUS_CHINT6_Msk  = 0x40  // Bit mask of CHINT6 field.
	DMAC_INTSTATUS_CHINT6      = 0x40  // Bit CHINT6.
	DMAC_INTSTATUS_CHINT7_Pos  = 0x7   // Position of CHINT7 field.
	DMAC_INTSTATUS_CHINT7_Msk  = 0x80  // Bit mask of CHINT7 field.
	DMAC_INTSTATUS_CHINT7      = 0x80  // Bit CHINT7.
	DMAC_INTSTATUS_CHINT8_Pos  = 0x8   // Position of CHINT8 field.
	DMAC_INTSTATUS_CHINT8_Msk  = 0x100 // Bit mask of CHINT8 field.
	DMAC_INTSTATUS_CHINT8      = 0x100 // Bit CHINT8.
	DMAC_INTSTATUS_CHINT9_Pos  = 0x9   // Position of CHINT9 field.
	DMAC_INTSTATUS_CHINT9_Msk  = 0x200 // Bit mask of CHINT9 field.
	DMAC_INTSTATUS_CHINT9      = 0x200 // Bit CHINT9.
	DMAC_INTSTATUS_CHINT10_Pos = 0xa   // Position of CHINT10 field.
	DMAC_INTSTATUS_CHINT10_Msk = 0x400 // Bit mask of CHINT10 field.
	DMAC_INTSTATUS_CHINT10     = 0x400 // Bit CHINT10.
	DMAC_INTSTATUS_CHINT11_Pos = 0xb   // Position of CHINT11 field.
	DMAC_INTSTATUS_CHINT11_Msk = 0x800 // Bit mask of CHINT11 field.
	DMAC_INTSTATUS_CHINT11     = 0x800 // Bit CHINT11.

	// BUSYCH: Busy Channels
	DMAC_BUSYCH_BUSYCH0_Pos  = 0x0   // Position of BUSYCH0 field.
	DMAC_BUSYCH_BUSYCH0_Msk  = 0x1   // Bit mask of BUSYCH0 field.
	DMAC_BUSYCH_BUSYCH0      = 0x1   // Bit BUSYCH0.
	DMAC_BUSYCH_BUSYCH1_Pos  = 0x1   // Position of BUSYCH1 field.
	DMAC_BUSYCH_BUSYCH1_Msk  = 0x2   // Bit mask of BUSYCH1 field.
	DMAC_BUSYCH_BUSYCH1      = 0x2   // Bit BUSYCH1.
	DMAC_BUSYCH_BUSYCH2_Pos  = 0x2   // Position of BUSYCH2 field.
	DMAC_BUSYCH_BUSYCH2_Msk  = 0x4   // Bit mask of BUSYCH2 field.
	DMAC_BUSYCH_BUSYCH2      = 0x4   // Bit BUSYCH2.
	DMAC_BUSYCH_BUSYCH3_Pos  = 0x3   // Position of BUSYCH3 field.
	DMAC_BUSYCH_BUSYCH3_Msk  = 0x8   // Bit mask of BUSYCH3 field.
	DMAC_BUSYCH_BUSYCH3      = 0x8   // Bit BUSYCH3.
	DMAC_BUSYCH_BUSYCH4_Pos  = 0x4   // Position of BUSYCH4 field.
	DMAC_BUSYCH_BUSYCH4_Msk  = 0x10  // Bit mask of BUSYCH4 field.
	DMAC_BUSYCH_BUSYCH4      = 0x10  // Bit BUSYCH4.
	DMAC_BUSYCH_BUSYCH5_Pos  = 0x5   // Position of BUSYCH5 field.
	DMAC_BUSYCH_BUSYCH5_Msk  = 0x20  // Bit mask of BUSYCH5 field.
	DMAC_BUSYCH_BUSYCH5      = 0x20  // Bit BUSYCH5.
	DMAC_BUSYCH_BUSYCH6_Pos  = 0x6   // Position of BUSYCH6 field.
	DMAC_BUSYCH_BUSYCH6_Msk  = 0x40  // Bit mask of BUSYCH6 field.
	DMAC_BUSYCH_BUSYCH6      = 0x40  // Bit BUSYCH6.
	DMAC_BUSYCH_BUSYCH7_Pos  = 0x7   // Position of BUSYCH7 field.
	DMAC_BUSYCH_BUSYCH7_Msk  = 0x80  // Bit mask of BUSYCH7 field.
	DMAC_BUSYCH_BUSYCH7      = 0x80  // Bit BUSYCH7.
	DMAC_BUSYCH_BUSYCH8_Pos  = 0x8   // Position of BUSYCH8 field.
	DMAC_BUSYCH_BUSYCH8_Msk  = 0x100 // Bit mask of BUSYCH8 field.
	DMAC_BUSYCH_BUSYCH8      = 0x100 // Bit BUSYCH8.
	DMAC_BUSYCH_BUSYCH9_Pos  = 0x9   // Position of BUSYCH9 field.
	DMAC_BUSYCH_BUSYCH9_Msk  = 0x200 // Bit mask of BUSYCH9 field.
	DMAC_BUSYCH_BUSYCH9      = 0x200 // Bit BUSYCH9.
	DMAC_BUSYCH_BUSYCH10_Pos = 0xa   // Position of BUSYCH10 field.
	DMAC_BUSYCH_BUSYCH10_Msk = 0x400 // Bit mask of BUSYCH10 field.
	DMAC_BUSYCH_BUSYCH10     = 0x400 // Bit BUSYCH10.
	DMAC_BUSYCH_BUSYCH11_Pos = 0xb   // Position of BUSYCH11 field.
	DMAC_BUSYCH_BUSYCH11_Msk = 0x800 // Bit mask of BUSYCH11 field.
	DMAC_BUSYCH_BUSYCH11     = 0x800 // Bit BUSYCH11.

	// PENDCH: Pending Channels
	DMAC_PENDCH_PENDCH0_Pos  = 0x0   // Position of PENDCH0 field.
	DMAC_PENDCH_PENDCH0_Msk  = 0x1   // Bit mask of PENDCH0 field.
	DMAC_PENDCH_PENDCH0      = 0x1   // Bit PENDCH0.
	DMAC_PENDCH_PENDCH1_Pos  = 0x1   // Position of PENDCH1 field.
	DMAC_PENDCH_PENDCH1_Msk  = 0x2   // Bit mask of PENDCH1 field.
	DMAC_PENDCH_PENDCH1      = 0x2   // Bit PENDCH1.
	DMAC_PENDCH_PENDCH2_Pos  = 0x2   // Position of PENDCH2 field.
	DMAC_PENDCH_PENDCH2_Msk  = 0x4   // Bit mask of PENDCH2 field.
	DMAC_PENDCH_PENDCH2      = 0x4   // Bit PENDCH2.
	DMAC_PENDCH_PENDCH3_Pos  = 0x3   // Position of PENDCH3 field.
	DMAC_PENDCH_PENDCH3_Msk  = 0x8   // Bit mask of PENDCH3 field.
	DMAC_PENDCH_PENDCH3      = 0x8   // Bit PENDCH3.
	DMAC_PENDCH_PENDCH4_Pos  = 0x4   // Position of PENDCH4 field.
	DMAC_PENDCH_PENDCH4_Msk  = 0x10  // Bit mask of PENDCH4 field.
	DMAC_PENDCH_PENDCH4      = 0x10  // Bit PENDCH4.
	DMAC_PENDCH_PENDCH5_Pos  = 0x5   // Position of PENDCH5 field.
	DMAC_PENDCH_PENDCH5_Msk  = 0x20  // Bit mask of PENDCH5 field.
	DMAC_PENDCH_PENDCH5      = 0x20  // Bit PENDCH5.
	DMAC_PENDCH_PENDCH6_Pos  = 0x6   // Position of PENDCH6 field.
	DMAC_PENDCH_PENDCH6_Msk  = 0x40  // Bit mask of PENDCH6 field.
	DMAC_PENDCH_PENDCH6      = 0x40  // Bit PENDCH6.
	DMAC_PENDCH_PENDCH7_Pos  = 0x7   // Position of PENDCH7 field.
	DMAC_PENDCH_PENDCH7_Msk  = 0x80  // Bit mask of PENDCH7 field.
	DMAC_PENDCH_PENDCH7      = 0x80  // Bit PENDCH7.
	DMAC_PENDCH_PENDCH8_Pos  = 0x8   // Position of PENDCH8 field.
	DMAC_PENDCH_PENDCH8_Msk  = 0x100 // Bit mask of PENDCH8 field.
	DMAC_PENDCH_PENDCH8      = 0x100 // Bit PENDCH8.
	DMAC_PENDCH_PENDCH9_Pos  = 0x9   // Position of PENDCH9 field.
	DMAC_PENDCH_PENDCH9_Msk  = 0x200 // Bit mask of PENDCH9 field.
	DMAC_PENDCH_PENDCH9      = 0x200 // Bit PENDCH9.
	DMAC_PENDCH_PENDCH10_Pos = 0xa   // Position of PENDCH10 field.
	DMAC_PENDCH_PENDCH10_Msk = 0x400 // Bit mask of PENDCH10 field.
	DMAC_PENDCH_PENDCH10     = 0x400 // Bit PENDCH10.
	DMAC_PENDCH_PENDCH11_Pos = 0xb   // Position of PENDCH11 field.
	DMAC_PENDCH_PENDCH11_Msk = 0x800 // Bit mask of PENDCH11 field.
	DMAC_PENDCH_PENDCH11     = 0x800 // Bit PENDCH11.

	// ACTIVE: Active Channel and Levels
	DMAC_ACTIVE_LVLEX0_Pos = 0x0        // Position of LVLEX0 field.
	DMAC_ACTIVE_LVLEX0_Msk = 0x1        // Bit mask of LVLEX0 field.
	DMAC_ACTIVE_LVLEX0     = 0x1        // Bit LVLEX0.
	DMAC_ACTIVE_LVLEX1_Pos = 0x1        // Position of LVLEX1 field.
	DMAC_ACTIVE_LVLEX1_Msk = 0x2        // Bit mask of LVLEX1 field.
	DMAC_ACTIVE_LVLEX1     = 0x2        // Bit LVLEX1.
	DMAC_ACTIVE_LVLEX2_Pos = 0x2        // Position of LVLEX2 field.
	DMAC_ACTIVE_LVLEX2_Msk = 0x4        // Bit mask of LVLEX2 field.
	DMAC_ACTIVE_LVLEX2     = 0x4        // Bit LVLEX2.
	DMAC_ACTIVE_LVLEX3_Pos = 0x3        // Position of LVLEX3 field.
	DMAC_ACTIVE_LVLEX3_Msk = 0x8        // Bit mask of LVLEX3 field.
	DMAC_ACTIVE_LVLEX3     = 0x8        // Bit LVLEX3.
	DMAC_ACTIVE_ID_Pos     = 0x8        // Position of ID field.
	DMAC_ACTIVE_ID_Msk     = 0x1f00     // Bit mask of ID field.
	DMAC_ACTIVE_ABUSY_Pos  = 0xf        // Position of ABUSY field.
	DMAC_ACTIVE_ABUSY_Msk  = 0x8000     // Bit mask of ABUSY field.
	DMAC_ACTIVE_ABUSY      = 0x8000     // Bit ABUSY.
	DMAC_ACTIVE_BTCNT_Pos  = 0x10       // Position of BTCNT field.
	DMAC_ACTIVE_BTCNT_Msk  = 0xffff0000 // Bit mask of BTCNT field.

	// BASEADDR: Descriptor Memory Section Base Address
	DMAC_BASEADDR_BASEADDR_Pos = 0x0        // Position of BASEADDR field.
	DMAC_BASEADDR_BASEADDR_Msk = 0xffffffff // Bit mask of BASEADDR field.

	// WRBADDR: Write-Back Memory Section Base Address
	DMAC_WRBADDR_WRBADDR_Pos = 0x0        // Position of WRBADDR field.
	DMAC_WRBADDR_WRBADDR_Msk = 0xffffffff // Bit mask of WRBADDR field.

	// CHID: Channel ID
	DMAC_CHID_ID_Pos = 0x0 // Position of ID field.
	DMAC_CHID_ID_Msk = 0xf // Bit mask of ID field.

	// CHCTRLA: Channel Control A
	DMAC_CHCTRLA_SWRST_Pos  = 0x0 // Position of SWRST field.
	DMAC_CHCTRLA_SWRST_Msk  = 0x1 // Bit mask of SWRST field.
	DMAC_CHCTRLA_SWRST      = 0x1 // Bit SWRST.
	DMAC_CHCTRLA_ENABLE_Pos = 0x1 // Position of ENABLE field.
	DMAC_CHCTRLA_ENABLE_Msk = 0x2 // Bit mask of ENABLE field.
	DMAC_CHCTRLA_ENABLE     = 0x2 // Bit ENABLE.

	// CHCTRLB: Channel Control B
	DMAC_CHCTRLB_EVACT_Pos           = 0x0       // Position of EVACT field.
	DMAC_CHCTRLB_EVACT_Msk           = 0x7       // Bit mask of EVACT field.
	DMAC_CHCTRLB_EVACT_NOACT         = 0x0       // No action
	DMAC_CHCTRLB_EVACT_TRIG          = 0x1       // Transfer and periodic transfer trigger
	DMAC_CHCTRLB_EVACT_CTRIG         = 0x2       // Conditional transfer trigger
	DMAC_CHCTRLB_EVACT_CBLOCK        = 0x3       // Conditional block transfer
	DMAC_CHCTRLB_EVACT_SUSPEND       = 0x4       // Channel suspend operation
	DMAC_CHCTRLB_EVACT_RESUME        = 0x5       // Channel resume operation
	DMAC_CHCTRLB_EVACT_SSKIP         = 0x6       // Skip next block suspend action
	DMAC_CHCTRLB_EVIE_Pos            = 0x3       // Position of EVIE field.
	DMAC_CHCTRLB_EVIE_Msk            = 0x8       // Bit mask of EVIE field.
	DMAC_CHCTRLB_EVIE                = 0x8       // Bit EVIE.
	DMAC_CHCTRLB_EVOE_Pos            = 0x4       // Position of EVOE field.
	DMAC_CHCTRLB_EVOE_Msk            = 0x10      // Bit mask of EVOE field.
	DMAC_CHCTRLB_EVOE                = 0x10      // Bit EVOE.
	DMAC_CHCTRLB_LVL_Pos             = 0x5       // Position of LVL field.
	DMAC_CHCTRLB_LVL_Msk             = 0x60      // Bit mask of LVL field.
	DMAC_CHCTRLB_LVL_LVL0            = 0x0       // Channel Priority Level 0
	DMAC_CHCTRLB_LVL_LVL1            = 0x1       // Channel Priority Level 1
	DMAC_CHCTRLB_LVL_LVL2            = 0x2       // Channel Priority Level 2
	DMAC_CHCTRLB_LVL_LVL3            = 0x3       // Channel Priority Level 3
	DMAC_CHCTRLB_TRIGSRC_Pos         = 0x8       // Position of TRIGSRC field.
	DMAC_CHCTRLB_TRIGSRC_Msk         = 0x3f00    // Bit mask of TRIGSRC field.
	DMAC_CHCTRLB_TRIGSRC_DISABLE     = 0x0       // Only software/event triggers
	DMAC_CHCTRLB_TRIGACT_Pos         = 0x16      // Position of TRIGACT field.
	DMAC_CHCTRLB_TRIGACT_Msk         = 0xc00000  // Bit mask of TRIGACT field.
	DMAC_CHCTRLB_TRIGACT_BLOCK       = 0x0       // One trigger required for each block transfer
	DMAC_CHCTRLB_TRIGACT_BEAT        = 0x2       // One trigger required for each beat transfer
	DMAC_CHCTRLB_TRIGACT_TRANSACTION = 0x3       // One trigger required for each transaction
	DMAC_CHCTRLB_CMD_Pos             = 0x18      // Position of CMD field.
	DMAC_CHCTRLB_CMD_Msk             = 0x3000000 // Bit mask of CMD field.
	DMAC_CHCTRLB_CMD_NOACT           = 0x0       // No action
	DMAC_CHCTRLB_CMD_SUSPEND         = 0x1       // Channel suspend operation
	DMAC_CHCTRLB_CMD_RESUME          = 0x2       // Channel resume operation

	// CHINTENCLR: Channel Interrupt Enable Clear
	DMAC_CHINTENCLR_TERR_Pos  = 0x0 // Position of TERR field.
	DMAC_CHINTENCLR_TERR_Msk  = 0x1 // Bit mask of TERR field.
	DMAC_CHINTENCLR_TERR      = 0x1 // Bit TERR.
	DMAC_CHINTENCLR_TCMPL_Pos = 0x1 // Position of TCMPL field.
	DMAC_CHINTENCLR_TCMPL_Msk = 0x2 // Bit mask of TCMPL field.
	DMAC_CHINTENCLR_TCMPL     = 0x2 // Bit TCMPL.
	DMAC_CHINTENCLR_SUSP_Pos  = 0x2 // Position of SUSP field.
	DMAC_CHINTENCLR_SUSP_Msk  = 0x4 // Bit mask of SUSP field.
	DMAC_CHINTENCLR_SUSP      = 0x4 // Bit SUSP.

	// CHINTENSET: Channel Interrupt Enable Set
	DMAC_CHINTENSET_TERR_Pos  = 0x0 // Position of TERR field.
	DMAC_CHINTENSET_TERR_Msk  = 0x1 // Bit mask of TERR field.
	DMAC_CHINTENSET_TERR      = 0x1 // Bit TERR.
	DMAC_CHINTENSET_TCMPL_Pos = 0x1 // Position of TCMPL field.
	DMAC_CHINTENSET_TCMPL_Msk = 0x2 // Bit mask of TCMPL field.
	DMAC_CHINTENSET_TCMPL     = 0x2 // Bit TCMPL.
	DMAC_CHINTENSET_SUSP_Pos  = 0x2 // Position of SUSP field.
	DMAC_CHINTENSET_SUSP_Msk  = 0x4 // Bit mask of SUSP field.
	DMAC_CHINTENSET_SUSP      = 0x4 // Bit SUSP.

	// CHINTFLAG: Channel Interrupt Flag Status and Clear
	DMAC_CHINTFLAG_TERR_Pos  = 0x0 // Position of TERR field.
	DMAC_CHINTFLAG_TERR_Msk  = 0x1 // Bit mask of TERR field.
	DMAC_CHINTFLAG_TERR      = 0x1 // Bit TERR.
	DMAC_CHINTFLAG_TCMPL_Pos = 0x1 // Position of TCMPL field.
	DMAC_CHINTFLAG_TCMPL_Msk = 0x2 // Bit mask of TCMPL field.
	DMAC_CHINTFLAG_TCMPL     = 0x2 // Bit TCMPL.
	DMAC_CHINTFLAG_SUSP_Pos  = 0x2 // Position of SUSP field.
	DMAC_CHINTFLAG_SUSP_Msk  = 0x4 // Bit mask of SUSP field.
	DMAC_CHINTFLAG_SUSP      = 0x4 // Bit SUSP.

	// CHSTATUS: Channel Status
	DMAC_CHSTATUS_PEND_Pos = 0x0 // Position of PEND field.
	DMAC_CHSTATUS_PEND_Msk = 0x1 // Bit mask of PEND field.
	DMAC_CHSTATUS_PEND     = 0x1 // Bit PEND.
	DMAC_CHSTATUS_BUSY_Pos = 0x1 // Position of BUSY field.
	DMAC_CHSTATUS_BUSY_Msk = 0x2 // Bit mask of BUSY field.
	DMAC_CHSTATUS_BUSY     = 0x2 // Bit BUSY.
	DMAC_CHSTATUS_FERR_Pos = 0x2 // Position of FERR field.
	DMAC_CHSTATUS_FERR_Msk = 0x4 // Bit mask of FERR field.
	DMAC_CHSTATUS_FERR     = 0x4 // Bit FERR.
)

// Bitfields for DSU: Device Service Unit
const (
	// CTRL: Control
	DSU_CTRL_SWRST_Pos = 0x0  // Position of SWRST field.
	DSU_CTRL_SWRST_Msk = 0x1  // Bit mask of SWRST field.
	DSU_CTRL_SWRST     = 0x1  // Bit SWRST.
	DSU_CTRL_CRC_Pos   = 0x2  // Position of CRC field.
	DSU_CTRL_CRC_Msk   = 0x4  // Bit mask of CRC field.
	DSU_CTRL_CRC       = 0x4  // Bit CRC.
	DSU_CTRL_MBIST_Pos = 0x3  // Position of MBIST field.
	DSU_CTRL_MBIST_Msk = 0x8  // Bit mask of MBIST field.
	DSU_CTRL_MBIST     = 0x8  // Bit MBIST.
	DSU_CTRL_CE_Pos    = 0x4  // Position of CE field.
	DSU_CTRL_CE_Msk    = 0x10 // Bit mask of CE field.
	DSU_CTRL_CE        = 0x10 // Bit CE.

	// STATUSA: Status A
	DSU_STATUSA_DONE_Pos    = 0x0  // Position of DONE field.
	DSU_STATUSA_DONE_Msk    = 0x1  // Bit mask of DONE field.
	DSU_STATUSA_DONE        = 0x1  // Bit DONE.
	DSU_STATUSA_CRSTEXT_Pos = 0x1  // Position of CRSTEXT field.
	DSU_STATUSA_CRSTEXT_Msk = 0x2  // Bit mask of CRSTEXT field.
	DSU_STATUSA_CRSTEXT     = 0x2  // Bit CRSTEXT.
	DSU_STATUSA_BERR_Pos    = 0x2  // Position of BERR field.
	DSU_STATUSA_BERR_Msk    = 0x4  // Bit mask of BERR field.
	DSU_STATUSA_BERR        = 0x4  // Bit BERR.
	DSU_STATUSA_FAIL_Pos    = 0x3  // Position of FAIL field.
	DSU_STATUSA_FAIL_Msk    = 0x8  // Bit mask of FAIL field.
	DSU_STATUSA_FAIL        = 0x8  // Bit FAIL.
	DSU_STATUSA_PERR_Pos    = 0x4  // Position of PERR field.
	DSU_STATUSA_PERR_Msk    = 0x10 // Bit mask of PERR field.
	DSU_STATUSA_PERR        = 0x10 // Bit PERR.

	// STATUSB: Status B
	DSU_STATUSB_PROT_Pos    = 0x0  // Position of PROT field.
	DSU_STATUSB_PROT_Msk    = 0x1  // Bit mask of PROT field.
	DSU_STATUSB_PROT        = 0x1  // Bit PROT.
	DSU_STATUSB_DBGPRES_Pos = 0x1  // Position of DBGPRES field.
	DSU_STATUSB_DBGPRES_Msk = 0x2  // Bit mask of DBGPRES field.
	DSU_STATUSB_DBGPRES     = 0x2  // Bit DBGPRES.
	DSU_STATUSB_DCCD0_Pos   = 0x2  // Position of DCCD0 field.
	DSU_STATUSB_DCCD0_Msk   = 0x4  // Bit mask of DCCD0 field.
	DSU_STATUSB_DCCD0       = 0x4  // Bit DCCD0.
	DSU_STATUSB_DCCD1_Pos   = 0x3  // Position of DCCD1 field.
	DSU_STATUSB_DCCD1_Msk   = 0x8  // Bit mask of DCCD1 field.
	DSU_STATUSB_DCCD1       = 0x8  // Bit DCCD1.
	DSU_STATUSB_HPE_Pos     = 0x4  // Position of HPE field.
	DSU_STATUSB_HPE_Msk     = 0x10 // Bit mask of HPE field.
	DSU_STATUSB_HPE         = 0x10 // Bit HPE.

	// ADDR: Address
	DSU_ADDR_ADDR_Pos = 0x2        // Position of ADDR field.
	DSU_ADDR_ADDR_Msk = 0xfffffffc // Bit mask of ADDR field.

	// LENGTH: Length
	DSU_LENGTH_LENGTH_Pos = 0x2        // Position of LENGTH field.
	DSU_LENGTH_LENGTH_Msk = 0xfffffffc // Bit mask of LENGTH field.

	// DATA: Data
	DSU_DATA_DATA_Pos = 0x0        // Position of DATA field.
	DSU_DATA_DATA_Msk = 0xffffffff // Bit mask of DATA field.

	// DCC0: Debug Communication Channel n
	DSU_DCC_DATA_Pos = 0x0        // Position of DATA field.
	DSU_DCC_DATA_Msk = 0xffffffff // Bit mask of DATA field.

	// DID: Device Identification
	DSU_DID_DEVSEL_Pos    = 0x0        // Position of DEVSEL field.
	DSU_DID_DEVSEL_Msk    = 0xff       // Bit mask of DEVSEL field.
	DSU_DID_REVISION_Pos  = 0x8        // Position of REVISION field.
	DSU_DID_REVISION_Msk  = 0xf00      // Bit mask of REVISION field.
	DSU_DID_DIE_Pos       = 0xc        // Position of DIE field.
	DSU_DID_DIE_Msk       = 0xf000     // Bit mask of DIE field.
	DSU_DID_SERIES_Pos    = 0x10       // Position of SERIES field.
	DSU_DID_SERIES_Msk    = 0x3f0000   // Bit mask of SERIES field.
	DSU_DID_FAMILY_Pos    = 0x17       // Position of FAMILY field.
	DSU_DID_FAMILY_Msk    = 0xf800000  // Bit mask of FAMILY field.
	DSU_DID_PROCESSOR_Pos = 0x1c       // Position of PROCESSOR field.
	DSU_DID_PROCESSOR_Msk = 0xf0000000 // Bit mask of PROCESSOR field.

	// ENTRY0: CoreSight ROM Table Entry 0
	DSU_ENTRY0_EPRES_Pos  = 0x0        // Position of EPRES field.
	DSU_ENTRY0_EPRES_Msk  = 0x1        // Bit mask of EPRES field.
	DSU_ENTRY0_EPRES      = 0x1        // Bit EPRES.
	DSU_ENTRY0_FMT_Pos    = 0x1        // Position of FMT field.
	DSU_ENTRY0_FMT_Msk    = 0x2        // Bit mask of FMT field.
	DSU_ENTRY0_FMT        = 0x2        // Bit FMT.
	DSU_ENTRY0_ADDOFF_Pos = 0xc        // Position of ADDOFF field.
	DSU_ENTRY0_ADDOFF_Msk = 0xfffff000 // Bit mask of ADDOFF field.

	// END: CoreSight ROM Table End
	DSU_END_END_Pos = 0x0        // Position of END field.
	DSU_END_END_Msk = 0xffffffff // Bit mask of END field.

	// MEMTYPE: CoreSight ROM Table Memory Type
	DSU_MEMTYPE_SMEMP_Pos = 0x0 // Position of SMEMP field.
	DSU_MEMTYPE_SMEMP_Msk = 0x1 // Bit mask of SMEMP field.
	DSU_MEMTYPE_SMEMP     = 0x1 // Bit SMEMP.

	// PID4: Peripheral Identification 4
	DSU_PID4_JEPCC_Pos = 0x0  // Position of JEPCC field.
	DSU_PID4_JEPCC_Msk = 0xf  // Bit mask of JEPCC field.
	DSU_PID4_FKBC_Pos  = 0x4  // Position of FKBC field.
	DSU_PID4_FKBC_Msk  = 0xf0 // Bit mask of FKBC field.

	// PID0: Peripheral Identification 0
	DSU_PID0_PARTNBL_Pos = 0x0  // Position of PARTNBL field.
	DSU_PID0_PARTNBL_Msk = 0xff // Bit mask of PARTNBL field.

	// PID1: Peripheral Identification 1
	DSU_PID1_PARTNBH_Pos = 0x0  // Position of PARTNBH field.
	DSU_PID1_PARTNBH_Msk = 0xf  // Bit mask of PARTNBH field.
	DSU_PID1_JEPIDCL_Pos = 0x4  // Position of JEPIDCL field.
	DSU_PID1_JEPIDCL_Msk = 0xf0 // Bit mask of JEPIDCL field.

	// PID2: Peripheral Identification 2
	DSU_PID2_JEPIDCH_Pos  = 0x0  // Position of JEPIDCH field.
	DSU_PID2_JEPIDCH_Msk  = 0x7  // Bit mask of JEPIDCH field.
	DSU_PID2_JEPU_Pos     = 0x3  // Position of JEPU field.
	DSU_PID2_JEPU_Msk     = 0x8  // Bit mask of JEPU field.
	DSU_PID2_JEPU         = 0x8  // Bit JEPU.
	DSU_PID2_REVISION_Pos = 0x4  // Position of REVISION field.
	DSU_PID2_REVISION_Msk = 0xf0 // Bit mask of REVISION field.

	// PID3: Peripheral Identification 3
	DSU_PID3_CUSMOD_Pos = 0x0  // Position of CUSMOD field.
	DSU_PID3_CUSMOD_Msk = 0xf  // Bit mask of CUSMOD field.
	DSU_PID3_REVAND_Pos = 0x4  // Position of REVAND field.
	DSU_PID3_REVAND_Msk = 0xf0 // Bit mask of REVAND field.

	// CID0: Component Identification 0
	DSU_CID0_PREAMBLEB0_Pos = 0x0  // Position of PREAMBLEB0 field.
	DSU_CID0_PREAMBLEB0_Msk = 0xff // Bit mask of PREAMBLEB0 field.

	// CID1: Component Identification 1
	DSU_CID1_PREAMBLE_Pos = 0x0  // Position of PREAMBLE field.
	DSU_CID1_PREAMBLE_Msk = 0xf  // Bit mask of PREAMBLE field.
	DSU_CID1_CCLASS_Pos   = 0x4  // Position of CCLASS field.
	DSU_CID1_CCLASS_Msk   = 0xf0 // Bit mask of CCLASS field.

	// CID2: Component Identification 2
	DSU_CID2_PREAMBLEB2_Pos = 0x0  // Position of PREAMBLEB2 field.
	DSU_CID2_PREAMBLEB2_Msk = 0xff // Bit mask of PREAMBLEB2 field.

	// CID3: Component Identification 3
	DSU_CID3_PREAMBLEB3_Pos = 0x0  // Position of PREAMBLEB3 field.
	DSU_CID3_PREAMBLEB3_Msk = 0xff // Bit mask of PREAMBLEB3 field.
)

// Bitfields for EIC: External Interrupt Controller
const (
	// CTRL: Control
	EIC_CTRL_SWRST_Pos  = 0x0 // Position of SWRST field.
	EIC_CTRL_SWRST_Msk  = 0x1 // Bit mask of SWRST field.
	EIC_CTRL_SWRST      = 0x1 // Bit SWRST.
	EIC_CTRL_ENABLE_Pos = 0x1 // Position of ENABLE field.
	EIC_CTRL_ENABLE_Msk = 0x2 // Bit mask of ENABLE field.
	EIC_CTRL_ENABLE     = 0x2 // Bit ENABLE.

	// STATUS: Status
	EIC_STATUS_SYNCBUSY_Pos = 0x7  // Position of SYNCBUSY field.
	EIC_STATUS_SYNCBUSY_Msk = 0x80 // Bit mask of SYNCBUSY field.
	EIC_STATUS_SYNCBUSY     = 0x80 // Bit SYNCBUSY.

	// NMICTRL: Non-Maskable Interrupt Control
	EIC_NMICTRL_NMISENSE_Pos  = 0x0 // Position of NMISENSE field.
	EIC_NMICTRL_NMISENSE_Msk  = 0x7 // Bit mask of NMISENSE field.
	EIC_NMICTRL_NMISENSE_NONE = 0x0 // No detection
	EIC_NMICTRL_NMISENSE_RISE = 0x1 // Rising-edge detection
	EIC_NMICTRL_NMISENSE_FALL = 0x2 // Falling-edge detection
	EIC_NMICTRL_NMISENSE_BOTH = 0x3 // Both-edges detection
	EIC_NMICTRL_NMISENSE_HIGH = 0x4 // High-level detection
	EIC_NMICTRL_NMISENSE_LOW  = 0x5 // Low-level detection
	EIC_NMICTRL_NMIFILTEN_Pos = 0x3 // Position of NMIFILTEN field.
	EIC_NMICTRL_NMIFILTEN_Msk = 0x8 // Bit mask of NMIFILTEN field.
	EIC_NMICTRL_NMIFILTEN     = 0x8 // Bit NMIFILTEN.

	// NMIFLAG: Non-Maskable Interrupt Flag Status and Clear
	EIC_NMIFLAG_NMI_Pos = 0x0 // Position of NMI field.
	EIC_NMIFLAG_NMI_Msk = 0x1 // Bit mask of NMI field.
	EIC_NMIFLAG_NMI     = 0x1 // Bit NMI.

	// EVCTRL: Event Control
	EIC_EVCTRL_EXTINTEO0_Pos  = 0x0    // Position of EXTINTEO0 field.
	EIC_EVCTRL_EXTINTEO0_Msk  = 0x1    // Bit mask of EXTINTEO0 field.
	EIC_EVCTRL_EXTINTEO0      = 0x1    // Bit EXTINTEO0.
	EIC_EVCTRL_EXTINTEO1_Pos  = 0x1    // Position of EXTINTEO1 field.
	EIC_EVCTRL_EXTINTEO1_Msk  = 0x2    // Bit mask of EXTINTEO1 field.
	EIC_EVCTRL_EXTINTEO1      = 0x2    // Bit EXTINTEO1.
	EIC_EVCTRL_EXTINTEO2_Pos  = 0x2    // Position of EXTINTEO2 field.
	EIC_EVCTRL_EXTINTEO2_Msk  = 0x4    // Bit mask of EXTINTEO2 field.
	EIC_EVCTRL_EXTINTEO2      = 0x4    // Bit EXTINTEO2.
	EIC_EVCTRL_EXTINTEO3_Pos  = 0x3    // Position of EXTINTEO3 field.
	EIC_EVCTRL_EXTINTEO3_Msk  = 0x8    // Bit mask of EXTINTEO3 field.
	EIC_EVCTRL_EXTINTEO3      = 0x8    // Bit EXTINTEO3.
	EIC_EVCTRL_EXTINTEO4_Pos  = 0x4    // Position of EXTINTEO4 field.
	EIC_EVCTRL_EXTINTEO4_Msk  = 0x10   // Bit mask of EXTINTEO4 field.
	EIC_EVCTRL_EXTINTEO4      = 0x10   // Bit EXTINTEO4.
	EIC_EVCTRL_EXTINTEO5_Pos  = 0x5    // Position of EXTINTEO5 field.
	EIC_EVCTRL_EXTINTEO5_Msk  = 0x20   // Bit mask of EXTINTEO5 field.
	EIC_EVCTRL_EXTINTEO5      = 0x20   // Bit EXTINTEO5.
	EIC_EVCTRL_EXTINTEO6_Pos  = 0x6    // Position of EXTINTEO6 field.
	EIC_EVCTRL_EXTINTEO6_Msk  = 0x40   // Bit mask of EXTINTEO6 field.
	EIC_EVCTRL_EXTINTEO6      = 0x40   // Bit EXTINTEO6.
	EIC_EVCTRL_EXTINTEO7_Pos  = 0x7    // Position of EXTINTEO7 field.
	EIC_EVCTRL_EXTINTEO7_Msk  = 0x80   // Bit mask of EXTINTEO7 field.
	EIC_EVCTRL_EXTINTEO7      = 0x80   // Bit EXTINTEO7.
	EIC_EVCTRL_EXTINTEO8_Pos  = 0x8    // Position of EXTINTEO8 field.
	EIC_EVCTRL_EXTINTEO8_Msk  = 0x100  // Bit mask of EXTINTEO8 field.
	EIC_EVCTRL_EXTINTEO8      = 0x100  // Bit EXTINTEO8.
	EIC_EVCTRL_EXTINTEO9_Pos  = 0x9    // Position of EXTINTEO9 field.
	EIC_EVCTRL_EXTINTEO9_Msk  = 0x200  // Bit mask of EXTINTEO9 field.
	EIC_EVCTRL_EXTINTEO9      = 0x200  // Bit EXTINTEO9.
	EIC_EVCTRL_EXTINTEO10_Pos = 0xa    // Position of EXTINTEO10 field.
	EIC_EVCTRL_EXTINTEO10_Msk = 0x400  // Bit mask of EXTINTEO10 field.
	EIC_EVCTRL_EXTINTEO10     = 0x400  // Bit EXTINTEO10.
	EIC_EVCTRL_EXTINTEO11_Pos = 0xb    // Position of EXTINTEO11 field.
	EIC_EVCTRL_EXTINTEO11_Msk = 0x800  // Bit mask of EXTINTEO11 field.
	EIC_EVCTRL_EXTINTEO11     = 0x800  // Bit EXTINTEO11.
	EIC_EVCTRL_EXTINTEO12_Pos = 0xc    // Position of EXTINTEO12 field.
	EIC_EVCTRL_EXTINTEO12_Msk = 0x1000 // Bit mask of EXTINTEO12 field.
	EIC_EVCTRL_EXTINTEO12     = 0x1000 // Bit EXTINTEO12.
	EIC_EVCTRL_EXTINTEO13_Pos = 0xd    // Position of EXTINTEO13 field.
	EIC_EVCTRL_EXTINTEO13_Msk = 0x2000 // Bit mask of EXTINTEO13 field.
	EIC_EVCTRL_EXTINTEO13     = 0x2000 // Bit EXTINTEO13.
	EIC_EVCTRL_EXTINTEO14_Pos = 0xe    // Position of EXTINTEO14 field.
	EIC_EVCTRL_EXTINTEO14_Msk = 0x4000 // Bit mask of EXTINTEO14 field.
	EIC_EVCTRL_EXTINTEO14     = 0x4000 // Bit EXTINTEO14.
	EIC_EVCTRL_EXTINTEO15_Pos = 0xf    // Position of EXTINTEO15 field.
	EIC_EVCTRL_EXTINTEO15_Msk = 0x8000 // Bit mask of EXTINTEO15 field.
	EIC_EVCTRL_EXTINTEO15     = 0x8000 // Bit EXTINTEO15.

	// INTENCLR: Interrupt Enable Clear
	EIC_INTENCLR_EXTINT0_Pos  = 0x0    // Position of EXTINT0 field.
	EIC_INTENCLR_EXTINT0_Msk  = 0x1    // Bit mask of EXTINT0 field.
	EIC_INTENCLR_EXTINT0      = 0x1    // Bit EXTINT0.
	EIC_INTENCLR_EXTINT1_Pos  = 0x1    // Position of EXTINT1 field.
	EIC_INTENCLR_EXTINT1_Msk  = 0x2    // Bit mask of EXTINT1 field.
	EIC_INTENCLR_EXTINT1      = 0x2    // Bit EXTINT1.
	EIC_INTENCLR_EXTINT2_Pos  = 0x2    // Position of EXTINT2 field.
	EIC_INTENCLR_EXTINT2_Msk  = 0x4    // Bit mask of EXTINT2 field.
	EIC_INTENCLR_EXTINT2      = 0x4    // Bit EXTINT2.
	EIC_INTENCLR_EXTINT3_Pos  = 0x3    // Position of EXTINT3 field.
	EIC_INTENCLR_EXTINT3_Msk  = 0x8    // Bit mask of EXTINT3 field.
	EIC_INTENCLR_EXTINT3      = 0x8    // Bit EXTINT3.
	EIC_INTENCLR_EXTINT4_Pos  = 0x4    // Position of EXTINT4 field.
	EIC_INTENCLR_EXTINT4_Msk  = 0x10   // Bit mask of EXTINT4 field.
	EIC_INTENCLR_EXTINT4      = 0x10   // Bit EXTINT4.
	EIC_INTENCLR_EXTINT5_Pos  = 0x5    // Position of EXTINT5 field.
	EIC_INTENCLR_EXTINT5_Msk  = 0x20   // Bit mask of EXTINT5 field.
	EIC_INTENCLR_EXTINT5      = 0x20   // Bit EXTINT5.
	EIC_INTENCLR_EXTINT6_Pos  = 0x6    // Position of EXTINT6 field.
	EIC_INTENCLR_EXTINT6_Msk  = 0x40   // Bit mask of EXTINT6 field.
	EIC_INTENCLR_EXTINT6      = 0x40   // Bit EXTINT6.
	EIC_INTENCLR_EXTINT7_Pos  = 0x7    // Position of EXTINT7 field.
	EIC_INTENCLR_EXTINT7_Msk  = 0x80   // Bit mask of EXTINT7 field.
	EIC_INTENCLR_EXTINT7      = 0x80   // Bit EXTINT7.
	EIC_INTENCLR_EXTINT8_Pos  = 0x8    // Position of EXTINT8 field.
	EIC_INTENCLR_EXTINT8_Msk  = 0x100  // Bit mask of EXTINT8 field.
	EIC_INTENCLR_EXTINT8      = 0x100  // Bit EXTINT8.
	EIC_INTENCLR_EXTINT9_Pos  = 0x9    // Position of EXTINT9 field.
	EIC_INTENCLR_EXTINT9_Msk  = 0x200  // Bit mask of EXTINT9 field.
	EIC_INTENCLR_EXTINT9      = 0x200  // Bit EXTINT9.
	EIC_INTENCLR_EXTINT10_Pos = 0xa    // Position of EXTINT10 field.
	EIC_INTENCLR_EXTINT10_Msk = 0x400  // Bit mask of EXTINT10 field.
	EIC_INTENCLR_EXTINT10     = 0x400  // Bit EXTINT10.
	EIC_INTENCLR_EXTINT11_Pos = 0xb    // Position of EXTINT11 field.
	EIC_INTENCLR_EXTINT11_Msk = 0x800  // Bit mask of EXTINT11 field.
	EIC_INTENCLR_EXTINT11     = 0x800  // Bit EXTINT11.
	EIC_INTENCLR_EXTINT12_Pos = 0xc    // Position of EXTINT12 field.
	EIC_INTENCLR_EXTINT12_Msk = 0x1000 // Bit mask of EXTINT12 field.
	EIC_INTENCLR_EXTINT12     = 0x1000 // Bit EXTINT12.
	EIC_INTENCLR_EXTINT13_Pos = 0xd    // Position of EXTINT13 field.
	EIC_INTENCLR_EXTINT13_Msk = 0x2000 // Bit mask of EXTINT13 field.
	EIC_INTENCLR_EXTINT13     = 0x2000 // Bit EXTINT13.
	EIC_INTENCLR_EXTINT14_Pos = 0xe    // Position of EXTINT14 field.
	EIC_INTENCLR_EXTINT14_Msk = 0x4000 // Bit mask of EXTINT14 field.
	EIC_INTENCLR_EXTINT14     = 0x4000 // Bit EXTINT14.
	EIC_INTENCLR_EXTINT15_Pos = 0xf    // Position of EXTINT15 field.
	EIC_INTENCLR_EXTINT15_Msk = 0x8000 // Bit mask of EXTINT15 field.
	EIC_INTENCLR_EXTINT15     = 0x8000 // Bit EXTINT15.

	// INTENSET: Interrupt Enable Set
	EIC_INTENSET_EXTINT0_Pos  = 0x0    // Position of EXTINT0 field.
	EIC_INTENSET_EXTINT0_Msk  = 0x1    // Bit mask of EXTINT0 field.
	EIC_INTENSET_EXTINT0      = 0x1    // Bit EXTINT0.
	EIC_INTENSET_EXTINT1_Pos  = 0x1    // Position of EXTINT1 field.
	EIC_INTENSET_EXTINT1_Msk  = 0x2    // Bit mask of EXTINT1 field.
	EIC_INTENSET_EXTINT1      = 0x2    // Bit EXTINT1.
	EIC_INTENSET_EXTINT2_Pos  = 0x2    // Position of EXTINT2 field.
	EIC_INTENSET_EXTINT2_Msk  = 0x4    // Bit mask of EXTINT2 field.
	EIC_INTENSET_EXTINT2      = 0x4    // Bit EXTINT2.
	EIC_INTENSET_EXTINT3_Pos  = 0x3    // Position of EXTINT3 field.
	EIC_INTENSET_EXTINT3_Msk  = 0x8    // Bit mask of EXTINT3 field.
	EIC_INTENSET_EXTINT3      = 0x8    // Bit EXTINT3.
	EIC_INTENSET_EXTINT4_Pos  = 0x4    // Position of EXTINT4 field.
	EIC_INTENSET_EXTINT4_Msk  = 0x10   // Bit mask of EXTINT4 field.
	EIC_INTENSET_EXTINT4      = 0x10   // Bit EXTINT4.
	EIC_INTENSET_EXTINT5_Pos  = 0x5    // Position of EXTINT5 field.
	EIC_INTENSET_EXTINT5_Msk  = 0x20   // Bit mask of EXTINT5 field.
	EIC_INTENSET_EXTINT5      = 0x20   // Bit EXTINT5.
	EIC_INTENSET_EXTINT6_Pos  = 0x6    // Position of EXTINT6 field.
	EIC_INTENSET_EXTINT6_Msk  = 0x40   // Bit mask of EXTINT6 field.
	EIC_INTENSET_EXTINT6      = 0x40   // Bit EXTINT6.
	EIC_INTENSET_EXTINT7_Pos  = 0x7    // Position of EXTINT7 field.
	EIC_INTENSET_EXTINT7_Msk  = 0x80   // Bit mask of EXTINT7 field.
	EIC_INTENSET_EXTINT7      = 0x80   // Bit EXTINT7.
	EIC_INTENSET_EXTINT8_Pos  = 0x8    // Position of EXTINT8 field.
	EIC_INTENSET_EXTINT8_Msk  = 0x100  // Bit mask of EXTINT8 field.
	EIC_INTENSET_EXTINT8      = 0x100  // Bit EXTINT8.
	EIC_INTENSET_EXTINT9_Pos  = 0x9    // Position of EXTINT9 field.
	EIC_INTENSET_EXTINT9_Msk  = 0x200  // Bit mask of EXTINT9 field.
	EIC_INTENSET_EXTINT9      = 0x200  // Bit EXTINT9.
	EIC_INTENSET_EXTINT10_Pos = 0xa    // Position of EXTINT10 field.
	EIC_INTENSET_EXTINT10_Msk = 0x400  // Bit mask of EXTINT10 field.
	EIC_INTENSET_EXTINT10     = 0x400  // Bit EXTINT10.
	EIC_INTENSET_EXTINT11_Pos = 0xb    // Position of EXTINT11 field.
	EIC_INTENSET_EXTINT11_Msk = 0x800  // Bit mask of EXTINT11 field.
	EIC_INTENSET_EXTINT11     = 0x800  // Bit EXTINT11.
	EIC_INTENSET_EXTINT12_Pos = 0xc    // Position of EXTINT12 field.
	EIC_INTENSET_EXTINT12_Msk = 0x1000 // Bit mask of EXTINT12 field.
	EIC_INTENSET_EXTINT12     = 0x1000 // Bit EXTINT12.
	EIC_INTENSET_EXTINT13_Pos = 0xd    // Position of EXTINT13 field.
	EIC_INTENSET_EXTINT13_Msk = 0x2000 // Bit mask of EXTINT13 field.
	EIC_INTENSET_EXTINT13     = 0x2000 // Bit EXTINT13.
	EIC_INTENSET_EXTINT14_Pos = 0xe    // Position of EXTINT14 field.
	EIC_INTENSET_EXTINT14_Msk = 0x4000 // Bit mask of EXTINT14 field.
	EIC_INTENSET_EXTINT14     = 0x4000 // Bit EXTINT14.
	EIC_INTENSET_EXTINT15_Pos = 0xf    // Position of EXTINT15 field.
	EIC_INTENSET_EXTINT15_Msk = 0x8000 // Bit mask of EXTINT15 field.
	EIC_INTENSET_EXTINT15     = 0x8000 // Bit EXTINT15.

	// INTFLAG: Interrupt Flag Status and Clear
	EIC_INTFLAG_EXTINT0_Pos  = 0x0    // Position of EXTINT0 field.
	EIC_INTFLAG_EXTINT0_Msk  = 0x1    // Bit mask of EXTINT0 field.
	EIC_INTFLAG_EXTINT0      = 0x1    // Bit EXTINT0.
	EIC_INTFLAG_EXTINT1_Pos  = 0x1    // Position of EXTINT1 field.
	EIC_INTFLAG_EXTINT1_Msk  = 0x2    // Bit mask of EXTINT1 field.
	EIC_INTFLAG_EXTINT1      = 0x2    // Bit EXTINT1.
	EIC_INTFLAG_EXTINT2_Pos  = 0x2    // Position of EXTINT2 field.
	EIC_INTFLAG_EXTINT2_Msk  = 0x4    // Bit mask of EXTINT2 field.
	EIC_INTFLAG_EXTINT2      = 0x4    // Bit EXTINT2.
	EIC_INTFLAG_EXTINT3_Pos  = 0x3    // Position of EXTINT3 field.
	EIC_INTFLAG_EXTINT3_Msk  = 0x8    // Bit mask of EXTINT3 field.
	EIC_INTFLAG_EXTINT3      = 0x8    // Bit EXTINT3.
	EIC_INTFLAG_EXTINT4_Pos  = 0x4    // Position of EXTINT4 field.
	EIC_INTFLAG_EXTINT4_Msk  = 0x10   // Bit mask of EXTINT4 field.
	EIC_INTFLAG_EXTINT4      = 0x10   // Bit EXTINT4.
	EIC_INTFLAG_EXTINT5_Pos  = 0x5    // Position of EXTINT5 field.
	EIC_INTFLAG_EXTINT5_Msk  = 0x20   // Bit mask of EXTINT5 field.
	EIC_INTFLAG_EXTINT5      = 0x20   // Bit EXTINT5.
	EIC_INTFLAG_EXTINT6_Pos  = 0x6    // Position of EXTINT6 field.
	EIC_INTFLAG_EXTINT6_Msk  = 0x40   // Bit mask of EXTINT6 field.
	EIC_INTFLAG_EXTINT6      = 0x40   // Bit EXTINT6.
	EIC_INTFLAG_EXTINT7_Pos  = 0x7    // Position of EXTINT7 field.
	EIC_INTFLAG_EXTINT7_Msk  = 0x80   // Bit mask of EXTINT7 field.
	EIC_INTFLAG_EXTINT7      = 0x80   // Bit EXTINT7.
	EIC_INTFLAG_EXTINT8_Pos  = 0x8    // Position of EXTINT8 field.
	EIC_INTFLAG_EXTINT8_Msk  = 0x100  // Bit mask of EXTINT8 field.
	EIC_INTFLAG_EXTINT8      = 0x100  // Bit EXTINT8.
	EIC_INTFLAG_EXTINT9_Pos  = 0x9    // Position of EXTINT9 field.
	EIC_INTFLAG_EXTINT9_Msk  = 0x200  // Bit mask of EXTINT9 field.
	EIC_INTFLAG_EXTINT9      = 0x200  // Bit EXTINT9.
	EIC_INTFLAG_EXTINT10_Pos = 0xa    // Position of EXTINT10 field.
	EIC_INTFLAG_EXTINT10_Msk = 0x400  // Bit mask of EXTINT10 field.
	EIC_INTFLAG_EXTINT10     = 0x400  // Bit EXTINT10.
	EIC_INTFLAG_EXTINT11_Pos = 0xb    // Position of EXTINT11 field.
	EIC_INTFLAG_EXTINT11_Msk = 0x800  // Bit mask of EXTINT11 field.
	EIC_INTFLAG_EXTINT11     = 0x800  // Bit EXTINT11.
	EIC_INTFLAG_EXTINT12_Pos = 0xc    // Position of EXTINT12 field.
	EIC_INTFLAG_EXTINT12_Msk = 0x1000 // Bit mask of EXTINT12 field.
	EIC_INTFLAG_EXTINT12     = 0x1000 // Bit EXTINT12.
	EIC_INTFLAG_EXTINT13_Pos = 0xd    // Position of EXTINT13 field.
	EIC_INTFLAG_EXTINT13_Msk = 0x2000 // Bit mask of EXTINT13 field.
	EIC_INTFLAG_EXTINT13     = 0x2000 // Bit EXTINT13.
	EIC_INTFLAG_EXTINT14_Pos = 0xe    // Position of EXTINT14 field.
	EIC_INTFLAG_EXTINT14_Msk = 0x4000 // Bit mask of EXTINT14 field.
	EIC_INTFLAG_EXTINT14     = 0x4000 // Bit EXTINT14.
	EIC_INTFLAG_EXTINT15_Pos = 0xf    // Position of EXTINT15 field.
	EIC_INTFLAG_EXTINT15_Msk = 0x8000 // Bit mask of EXTINT15 field.
	EIC_INTFLAG_EXTINT15     = 0x8000 // Bit EXTINT15.

	// WAKEUP: Wake-Up Enable
	EIC_WAKEUP_WAKEUPEN0_Pos  = 0x0    // Position of WAKEUPEN0 field.
	EIC_WAKEUP_WAKEUPEN0_Msk  = 0x1    // Bit mask of WAKEUPEN0 field.
	EIC_WAKEUP_WAKEUPEN0      = 0x1    // Bit WAKEUPEN0.
	EIC_WAKEUP_WAKEUPEN1_Pos  = 0x1    // Position of WAKEUPEN1 field.
	EIC_WAKEUP_WAKEUPEN1_Msk  = 0x2    // Bit mask of WAKEUPEN1 field.
	EIC_WAKEUP_WAKEUPEN1      = 0x2    // Bit WAKEUPEN1.
	EIC_WAKEUP_WAKEUPEN2_Pos  = 0x2    // Position of WAKEUPEN2 field.
	EIC_WAKEUP_WAKEUPEN2_Msk  = 0x4    // Bit mask of WAKEUPEN2 field.
	EIC_WAKEUP_WAKEUPEN2      = 0x4    // Bit WAKEUPEN2.
	EIC_WAKEUP_WAKEUPEN3_Pos  = 0x3    // Position of WAKEUPEN3 field.
	EIC_WAKEUP_WAKEUPEN3_Msk  = 0x8    // Bit mask of WAKEUPEN3 field.
	EIC_WAKEUP_WAKEUPEN3      = 0x8    // Bit WAKEUPEN3.
	EIC_WAKEUP_WAKEUPEN4_Pos  = 0x4    // Position of WAKEUPEN4 field.
	EIC_WAKEUP_WAKEUPEN4_Msk  = 0x10   // Bit mask of WAKEUPEN4 field.
	EIC_WAKEUP_WAKEUPEN4      = 0x10   // Bit WAKEUPEN4.
	EIC_WAKEUP_WAKEUPEN5_Pos  = 0x5    // Position of WAKEUPEN5 field.
	EIC_WAKEUP_WAKEUPEN5_Msk  = 0x20   // Bit mask of WAKEUPEN5 field.
	EIC_WAKEUP_WAKEUPEN5      = 0x20   // Bit WAKEUPEN5.
	EIC_WAKEUP_WAKEUPEN6_Pos  = 0x6    // Position of WAKEUPEN6 field.
	EIC_WAKEUP_WAKEUPEN6_Msk  = 0x40   // Bit mask of WAKEUPEN6 field.
	EIC_WAKEUP_WAKEUPEN6      = 0x40   // Bit WAKEUPEN6.
	EIC_WAKEUP_WAKEUPEN7_Pos  = 0x7    // Position of WAKEUPEN7 field.
	EIC_WAKEUP_WAKEUPEN7_Msk  = 0x80   // Bit mask of WAKEUPEN7 field.
	EIC_WAKEUP_WAKEUPEN7      = 0x80   // Bit WAKEUPEN7.
	EIC_WAKEUP_WAKEUPEN8_Pos  = 0x8    // Position of WAKEUPEN8 field.
	EIC_WAKEUP_WAKEUPEN8_Msk  = 0x100  // Bit mask of WAKEUPEN8 field.
	EIC_WAKEUP_WAKEUPEN8      = 0x100  // Bit WAKEUPEN8.
	EIC_WAKEUP_WAKEUPEN9_Pos  = 0x9    // Position of WAKEUPEN9 field.
	EIC_WAKEUP_WAKEUPEN9_Msk  = 0x200  // Bit mask of WAKEUPEN9 field.
	EIC_WAKEUP_WAKEUPEN9      = 0x200  // Bit WAKEUPEN9.
	EIC_WAKEUP_WAKEUPEN10_Pos = 0xa    // Position of WAKEUPEN10 field.
	EIC_WAKEUP_WAKEUPEN10_Msk = 0x400  // Bit mask of WAKEUPEN10 field.
	EIC_WAKEUP_WAKEUPEN10     = 0x400  // Bit WAKEUPEN10.
	EIC_WAKEUP_WAKEUPEN11_Pos = 0xb    // Position of WAKEUPEN11 field.
	EIC_WAKEUP_WAKEUPEN11_Msk = 0x800  // Bit mask of WAKEUPEN11 field.
	EIC_WAKEUP_WAKEUPEN11     = 0x800  // Bit WAKEUPEN11.
	EIC_WAKEUP_WAKEUPEN12_Pos = 0xc    // Position of WAKEUPEN12 field.
	EIC_WAKEUP_WAKEUPEN12_Msk = 0x1000 // Bit mask of WAKEUPEN12 field.
	EIC_WAKEUP_WAKEUPEN12     = 0x1000 // Bit WAKEUPEN12.
	EIC_WAKEUP_WAKEUPEN13_Pos = 0xd    // Position of WAKEUPEN13 field.
	EIC_WAKEUP_WAKEUPEN13_Msk = 0x2000 // Bit mask of WAKEUPEN13 field.
	EIC_WAKEUP_WAKEUPEN13     = 0x2000 // Bit WAKEUPEN13.
	EIC_WAKEUP_WAKEUPEN14_Pos = 0xe    // Position of WAKEUPEN14 field.
	EIC_WAKEUP_WAKEUPEN14_Msk = 0x4000 // Bit mask of WAKEUPEN14 field.
	EIC_WAKEUP_WAKEUPEN14     = 0x4000 // Bit WAKEUPEN14.
	EIC_WAKEUP_WAKEUPEN15_Pos = 0xf    // Position of WAKEUPEN15 field.
	EIC_WAKEUP_WAKEUPEN15_Msk = 0x8000 // Bit mask of WAKEUPEN15 field.
	EIC_WAKEUP_WAKEUPEN15     = 0x8000 // Bit WAKEUPEN15.

	// CONFIG0: Configuration n
	EIC_CONFIG_SENSE0_Pos  = 0x0        // Position of SENSE0 field.
	EIC_CONFIG_SENSE0_Msk  = 0x7        // Bit mask of SENSE0 field.
	EIC_CONFIG_SENSE0_NONE = 0x0        // No detection
	EIC_CONFIG_SENSE0_RISE = 0x1        // Rising-edge detection
	EIC_CONFIG_SENSE0_FALL = 0x2        // Falling-edge detection
	EIC_CONFIG_SENSE0_BOTH = 0x3        // Both-edges detection
	EIC_CONFIG_SENSE0_HIGH = 0x4        // High-level detection
	EIC_CONFIG_SENSE0_LOW  = 0x5        // Low-level detection
	EIC_CONFIG_FILTEN0_Pos = 0x3        // Position of FILTEN0 field.
	EIC_CONFIG_FILTEN0_Msk = 0x8        // Bit mask of FILTEN0 field.
	EIC_CONFIG_FILTEN0     = 0x8        // Bit FILTEN0.
	EIC_CONFIG_SENSE1_Pos  = 0x4        // Position of SENSE1 field.
	EIC_CONFIG_SENSE1_Msk  = 0x70       // Bit mask of SENSE1 field.
	EIC_CONFIG_SENSE1_NONE = 0x0        // No detection
	EIC_CONFIG_SENSE1_RISE = 0x1        // Rising edge detection
	EIC_CONFIG_SENSE1_FALL = 0x2        // Falling edge detection
	EIC_CONFIG_SENSE1_BOTH = 0x3        // Both edges detection
	EIC_CONFIG_SENSE1_HIGH = 0x4        // High level detection
	EIC_CONFIG_SENSE1_LOW  = 0x5        // Low level detection
	EIC_CONFIG_FILTEN1_Pos = 0x7        // Position of FILTEN1 field.
	EIC_CONFIG_FILTEN1_Msk = 0x80       // Bit mask of FILTEN1 field.
	EIC_CONFIG_FILTEN1     = 0x80       // Bit FILTEN1.
	EIC_CONFIG_SENSE2_Pos  = 0x8        // Position of SENSE2 field.
	EIC_CONFIG_SENSE2_Msk  = 0x700      // Bit mask of SENSE2 field.
	EIC_CONFIG_SENSE2_NONE = 0x0        // No detection
	EIC_CONFIG_SENSE2_RISE = 0x1        // Rising edge detection
	EIC_CONFIG_SENSE2_FALL = 0x2        // Falling edge detection
	EIC_CONFIG_SENSE2_BOTH = 0x3        // Both edges detection
	EIC_CONFIG_SENSE2_HIGH = 0x4        // High level detection
	EIC_CONFIG_SENSE2_LOW  = 0x5        // Low level detection
	EIC_CONFIG_FILTEN2_Pos = 0xb        // Position of FILTEN2 field.
	EIC_CONFIG_FILTEN2_Msk = 0x800      // Bit mask of FILTEN2 field.
	EIC_CONFIG_FILTEN2     = 0x800      // Bit FILTEN2.
	EIC_CONFIG_SENSE3_Pos  = 0xc        // Position of SENSE3 field.
	EIC_CONFIG_SENSE3_Msk  = 0x7000     // Bit mask of SENSE3 field.
	EIC_CONFIG_SENSE3_NONE = 0x0        // No detection
	EIC_CONFIG_SENSE3_RISE = 0x1        // Rising edge detection
	EIC_CONFIG_SENSE3_FALL = 0x2        // Falling edge detection
	EIC_CONFIG_SENSE3_BOTH = 0x3        // Both edges detection
	EIC_CONFIG_SENSE3_HIGH = 0x4        // High level detection
	EIC_CONFIG_SENSE3_LOW  = 0x5        // Low level detection
	EIC_CONFIG_FILTEN3_Pos = 0xf        // Position of FILTEN3 field.
	EIC_CONFIG_FILTEN3_Msk = 0x8000     // Bit mask of FILTEN3 field.
	EIC_CONFIG_FILTEN3     = 0x8000     // Bit FILTEN3.
	EIC_CONFIG_SENSE4_Pos  = 0x10       // Position of SENSE4 field.
	EIC_CONFIG_SENSE4_Msk  = 0x70000    // Bit mask of SENSE4 field.
	EIC_CONFIG_SENSE4_NONE = 0x0        // No detection
	EIC_CONFIG_SENSE4_RISE = 0x1        // Rising edge detection
	EIC_CONFIG_SENSE4_FALL = 0x2        // Falling edge detection
	EIC_CONFIG_SENSE4_BOTH = 0x3        // Both edges detection
	EIC_CONFIG_SENSE4_HIGH = 0x4        // High level detection
	EIC_CONFIG_SENSE4_LOW  = 0x5        // Low level detection
	EIC_CONFIG_FILTEN4_Pos = 0x13       // Position of FILTEN4 field.
	EIC_CONFIG_FILTEN4_Msk = 0x80000    // Bit mask of FILTEN4 field.
	EIC_CONFIG_FILTEN4     = 0x80000    // Bit FILTEN4.
	EIC_CONFIG_SENSE5_Pos  = 0x14       // Position of SENSE5 field.
	EIC_CONFIG_SENSE5_Msk  = 0x700000   // Bit mask of SENSE5 field.
	EIC_CONFIG_SENSE5_NONE = 0x0        // No detection
	EIC_CONFIG_SENSE5_RISE = 0x1        // Rising edge detection
	EIC_CONFIG_SENSE5_FALL = 0x2        // Falling edge detection
	EIC_CONFIG_SENSE5_BOTH = 0x3        // Both edges detection
	EIC_CONFIG_SENSE5_HIGH = 0x4        // High level detection
	EIC_CONFIG_SENSE5_LOW  = 0x5        // Low level detection
	EIC_CONFIG_FILTEN5_Pos = 0x17       // Position of FILTEN5 field.
	EIC_CONFIG_FILTEN5_Msk = 0x800000   // Bit mask of FILTEN5 field.
	EIC_CONFIG_FILTEN5     = 0x800000   // Bit FILTEN5.
	EIC_CONFIG_SENSE6_Pos  = 0x18       // Position of SENSE6 field.
	EIC_CONFIG_SENSE6_Msk  = 0x7000000  // Bit mask of SENSE6 field.
	EIC_CONFIG_SENSE6_NONE = 0x0        // No detection
	EIC_CONFIG_SENSE6_RISE = 0x1        // Rising edge detection
	EIC_CONFIG_SENSE6_FALL = 0x2        // Falling edge detection
	EIC_CONFIG_SENSE6_BOTH = 0x3        // Both edges detection
	EIC_CONFIG_SENSE6_HIGH = 0x4        // High level detection
	EIC_CONFIG_SENSE6_LOW  = 0x5        // Low level detection
	EIC_CONFIG_FILTEN6_Pos = 0x1b       // Position of FILTEN6 field.
	EIC_CONFIG_FILTEN6_Msk = 0x8000000  // Bit mask of FILTEN6 field.
	EIC_CONFIG_FILTEN6     = 0x8000000  // Bit FILTEN6.
	EIC_CONFIG_SENSE7_Pos  = 0x1c       // Position of SENSE7 field.
	EIC_CONFIG_SENSE7_Msk  = 0x70000000 // Bit mask of SENSE7 field.
	EIC_CONFIG_SENSE7_NONE = 0x0        // No detection
	EIC_CONFIG_SENSE7_RISE = 0x1        // Rising edge detection
	EIC_CONFIG_SENSE7_FALL = 0x2        // Falling edge detection
	EIC_CONFIG_SENSE7_BOTH = 0x3        // Both edges detection
	EIC_CONFIG_SENSE7_HIGH = 0x4        // High level detection
	EIC_CONFIG_SENSE7_LOW  = 0x5        // Low level detection
	EIC_CONFIG_FILTEN7_Pos = 0x1f       // Position of FILTEN7 field.
	EIC_CONFIG_FILTEN7_Msk = 0x80000000 // Bit mask of FILTEN7 field.
	EIC_CONFIG_FILTEN7     = 0x80000000 // Bit FILTEN7.
)

// Bitfields for EVSYS: Event System Interface
const (
	// CTRL: Control
	EVSYS_CTRL_SWRST_Pos   = 0x0  // Position of SWRST field.
	EVSYS_CTRL_SWRST_Msk   = 0x1  // Bit mask of SWRST field.
	EVSYS_CTRL_SWRST       = 0x1  // Bit SWRST.
	EVSYS_CTRL_GCLKREQ_Pos = 0x4  // Position of GCLKREQ field.
	EVSYS_CTRL_GCLKREQ_Msk = 0x10 // Bit mask of GCLKREQ field.
	EVSYS_CTRL_GCLKREQ     = 0x10 // Bit GCLKREQ.

	// CHANNEL: Channel
	EVSYS_CHANNEL_CHANNEL_Pos          = 0x0       // Position of CHANNEL field.
	EVSYS_CHANNEL_CHANNEL_Msk          = 0xf       // Bit mask of CHANNEL field.
	EVSYS_CHANNEL_SWEVT_Pos            = 0x8       // Position of SWEVT field.
	EVSYS_CHANNEL_SWEVT_Msk            = 0x100     // Bit mask of SWEVT field.
	EVSYS_CHANNEL_SWEVT                = 0x100     // Bit SWEVT.
	EVSYS_CHANNEL_EVGEN_Pos            = 0x10      // Position of EVGEN field.
	EVSYS_CHANNEL_EVGEN_Msk            = 0x7f0000  // Bit mask of EVGEN field.
	EVSYS_CHANNEL_PATH_Pos             = 0x18      // Position of PATH field.
	EVSYS_CHANNEL_PATH_Msk             = 0x3000000 // Bit mask of PATH field.
	EVSYS_CHANNEL_PATH_SYNCHRONOUS     = 0x0       // Synchronous path
	EVSYS_CHANNEL_PATH_RESYNCHRONIZED  = 0x1       // Resynchronized path
	EVSYS_CHANNEL_PATH_ASYNCHRONOUS    = 0x2       // Asynchronous path
	EVSYS_CHANNEL_EDGSEL_Pos           = 0x1a      // Position of EDGSEL field.
	EVSYS_CHANNEL_EDGSEL_Msk           = 0xc000000 // Bit mask of EDGSEL field.
	EVSYS_CHANNEL_EDGSEL_NO_EVT_OUTPUT = 0x0       // No event output when using the resynchronized or synchronous path
	EVSYS_CHANNEL_EDGSEL_RISING_EDGE   = 0x1       // Event detection only on the rising edge of the signal from the event generator when using the resynchronized or synchronous path
	EVSYS_CHANNEL_EDGSEL_FALLING_EDGE  = 0x2       // Event detection only on the falling edge of the signal from the event generator when using the resynchronized or synchronous path
	EVSYS_CHANNEL_EDGSEL_BOTH_EDGES    = 0x3       // Event detection on rising and falling edges of the signal from the event generator when using the resynchronized or synchronous path

	// USER: User Multiplexer
	EVSYS_USER_USER_Pos    = 0x0    // Position of USER field.
	EVSYS_USER_USER_Msk    = 0x1f   // Bit mask of USER field.
	EVSYS_USER_CHANNEL_Pos = 0x8    // Position of CHANNEL field.
	EVSYS_USER_CHANNEL_Msk = 0x1f00 // Bit mask of CHANNEL field.
	EVSYS_USER_CHANNEL_0   = 0x0    // No Channel Output Selected

	// CHSTATUS: Channel Status
	EVSYS_CHSTATUS_USRRDY0_Pos  = 0x0       // Position of USRRDY0 field.
	EVSYS_CHSTATUS_USRRDY0_Msk  = 0x1       // Bit mask of USRRDY0 field.
	EVSYS_CHSTATUS_USRRDY0      = 0x1       // Bit USRRDY0.
	EVSYS_CHSTATUS_USRRDY1_Pos  = 0x1       // Position of USRRDY1 field.
	EVSYS_CHSTATUS_USRRDY1_Msk  = 0x2       // Bit mask of USRRDY1 field.
	EVSYS_CHSTATUS_USRRDY1      = 0x2       // Bit USRRDY1.
	EVSYS_CHSTATUS_USRRDY2_Pos  = 0x2       // Position of USRRDY2 field.
	EVSYS_CHSTATUS_USRRDY2_Msk  = 0x4       // Bit mask of USRRDY2 field.
	EVSYS_CHSTATUS_USRRDY2      = 0x4       // Bit USRRDY2.
	EVSYS_CHSTATUS_USRRDY3_Pos  = 0x3       // Position of USRRDY3 field.
	EVSYS_CHSTATUS_USRRDY3_Msk  = 0x8       // Bit mask of USRRDY3 field.
	EVSYS_CHSTATUS_USRRDY3      = 0x8       // Bit USRRDY3.
	EVSYS_CHSTATUS_USRRDY4_Pos  = 0x4       // Position of USRRDY4 field.
	EVSYS_CHSTATUS_USRRDY4_Msk  = 0x10      // Bit mask of USRRDY4 field.
	EVSYS_CHSTATUS_USRRDY4      = 0x10      // Bit USRRDY4.
	EVSYS_CHSTATUS_USRRDY5_Pos  = 0x5       // Position of USRRDY5 field.
	EVSYS_CHSTATUS_USRRDY5_Msk  = 0x20      // Bit mask of USRRDY5 field.
	EVSYS_CHSTATUS_USRRDY5      = 0x20      // Bit USRRDY5.
	EVSYS_CHSTATUS_USRRDY6_Pos  = 0x6       // Position of USRRDY6 field.
	EVSYS_CHSTATUS_USRRDY6_Msk  = 0x40      // Bit mask of USRRDY6 field.
	EVSYS_CHSTATUS_USRRDY6      = 0x40      // Bit USRRDY6.
	EVSYS_CHSTATUS_USRRDY7_Pos  = 0x7       // Position of USRRDY7 field.
	EVSYS_CHSTATUS_USRRDY7_Msk  = 0x80      // Bit mask of USRRDY7 field.
	EVSYS_CHSTATUS_USRRDY7      = 0x80      // Bit USRRDY7.
	EVSYS_CHSTATUS_CHBUSY0_Pos  = 0x8       // Position of CHBUSY0 field.
	EVSYS_CHSTATUS_CHBUSY0_Msk  = 0x100     // Bit mask of CHBUSY0 field.
	EVSYS_CHSTATUS_CHBUSY0      = 0x100     // Bit CHBUSY0.
	EVSYS_CHSTATUS_CHBUSY1_Pos  = 0x9       // Position of CHBUSY1 field.
	EVSYS_CHSTATUS_CHBUSY1_Msk  = 0x200     // Bit mask of CHBUSY1 field.
	EVSYS_CHSTATUS_CHBUSY1      = 0x200     // Bit CHBUSY1.
	EVSYS_CHSTATUS_CHBUSY2_Pos  = 0xa       // Position of CHBUSY2 field.
	EVSYS_CHSTATUS_CHBUSY2_Msk  = 0x400     // Bit mask of CHBUSY2 field.
	EVSYS_CHSTATUS_CHBUSY2      = 0x400     // Bit CHBUSY2.
	EVSYS_CHSTATUS_CHBUSY3_Pos  = 0xb       // Position of CHBUSY3 field.
	EVSYS_CHSTATUS_CHBUSY3_Msk  = 0x800     // Bit mask of CHBUSY3 field.
	EVSYS_CHSTATUS_CHBUSY3      = 0x800     // Bit CHBUSY3.
	EVSYS_CHSTATUS_CHBUSY4_Pos  = 0xc       // Position of CHBUSY4 field.
	EVSYS_CHSTATUS_CHBUSY4_Msk  = 0x1000    // Bit mask of CHBUSY4 field.
	EVSYS_CHSTATUS_CHBUSY4      = 0x1000    // Bit CHBUSY4.
	EVSYS_CHSTATUS_CHBUSY5_Pos  = 0xd       // Position of CHBUSY5 field.
	EVSYS_CHSTATUS_CHBUSY5_Msk  = 0x2000    // Bit mask of CHBUSY5 field.
	EVSYS_CHSTATUS_CHBUSY5      = 0x2000    // Bit CHBUSY5.
	EVSYS_CHSTATUS_CHBUSY6_Pos  = 0xe       // Position of CHBUSY6 field.
	EVSYS_CHSTATUS_CHBUSY6_Msk  = 0x4000    // Bit mask of CHBUSY6 field.
	EVSYS_CHSTATUS_CHBUSY6      = 0x4000    // Bit CHBUSY6.
	EVSYS_CHSTATUS_CHBUSY7_Pos  = 0xf       // Position of CHBUSY7 field.
	EVSYS_CHSTATUS_CHBUSY7_Msk  = 0x8000    // Bit mask of CHBUSY7 field.
	EVSYS_CHSTATUS_CHBUSY7      = 0x8000    // Bit CHBUSY7.
	EVSYS_CHSTATUS_USRRDY8_Pos  = 0x10      // Position of USRRDY8 field.
	EVSYS_CHSTATUS_USRRDY8_Msk  = 0x10000   // Bit mask of USRRDY8 field.
	EVSYS_CHSTATUS_USRRDY8      = 0x10000   // Bit USRRDY8.
	EVSYS_CHSTATUS_USRRDY9_Pos  = 0x11      // Position of USRRDY9 field.
	EVSYS_CHSTATUS_USRRDY9_Msk  = 0x20000   // Bit mask of USRRDY9 field.
	EVSYS_CHSTATUS_USRRDY9      = 0x20000   // Bit USRRDY9.
	EVSYS_CHSTATUS_USRRDY10_Pos = 0x12      // Position of USRRDY10 field.
	EVSYS_CHSTATUS_USRRDY10_Msk = 0x40000   // Bit mask of USRRDY10 field.
	EVSYS_CHSTATUS_USRRDY10     = 0x40000   // Bit USRRDY10.
	EVSYS_CHSTATUS_USRRDY11_Pos = 0x13      // Position of USRRDY11 field.
	EVSYS_CHSTATUS_USRRDY11_Msk = 0x80000   // Bit mask of USRRDY11 field.
	EVSYS_CHSTATUS_USRRDY11     = 0x80000   // Bit USRRDY11.
	EVSYS_CHSTATUS_CHBUSY8_Pos  = 0x18      // Position of CHBUSY8 field.
	EVSYS_CHSTATUS_CHBUSY8_Msk  = 0x1000000 // Bit mask of CHBUSY8 field.
	EVSYS_CHSTATUS_CHBUSY8      = 0x1000000 // Bit CHBUSY8.
	EVSYS_CHSTATUS_CHBUSY9_Pos  = 0x19      // Position of CHBUSY9 field.
	EVSYS_CHSTATUS_CHBUSY9_Msk  = 0x2000000 // Bit mask of CHBUSY9 field.
	EVSYS_CHSTATUS_CHBUSY9      = 0x2000000 // Bit CHBUSY9.
	EVSYS_CHSTATUS_CHBUSY10_Pos = 0x1a      // Position of CHBUSY10 field.
	EVSYS_CHSTATUS_CHBUSY10_Msk = 0x4000000 // Bit mask of CHBUSY10 field.
	EVSYS_CHSTATUS_CHBUSY10     = 0x4000000 // Bit CHBUSY10.
	EVSYS_CHSTATUS_CHBUSY11_Pos = 0x1b      // Position of CHBUSY11 field.
	EVSYS_CHSTATUS_CHBUSY11_Msk = 0x8000000 // Bit mask of CHBUSY11 field.
	EVSYS_CHSTATUS_CHBUSY11     = 0x8000000 // Bit CHBUSY11.

	// INTENCLR: Interrupt Enable Clear
	EVSYS_INTENCLR_OVR0_Pos  = 0x0       // Position of OVR0 field.
	EVSYS_INTENCLR_OVR0_Msk  = 0x1       // Bit mask of OVR0 field.
	EVSYS_INTENCLR_OVR0      = 0x1       // Bit OVR0.
	EVSYS_INTENCLR_OVR1_Pos  = 0x1       // Position of OVR1 field.
	EVSYS_INTENCLR_OVR1_Msk  = 0x2       // Bit mask of OVR1 field.
	EVSYS_INTENCLR_OVR1      = 0x2       // Bit OVR1.
	EVSYS_INTENCLR_OVR2_Pos  = 0x2       // Position of OVR2 field.
	EVSYS_INTENCLR_OVR2_Msk  = 0x4       // Bit mask of OVR2 field.
	EVSYS_INTENCLR_OVR2      = 0x4       // Bit OVR2.
	EVSYS_INTENCLR_OVR3_Pos  = 0x3       // Position of OVR3 field.
	EVSYS_INTENCLR_OVR3_Msk  = 0x8       // Bit mask of OVR3 field.
	EVSYS_INTENCLR_OVR3      = 0x8       // Bit OVR3.
	EVSYS_INTENCLR_OVR4_Pos  = 0x4       // Position of OVR4 field.
	EVSYS_INTENCLR_OVR4_Msk  = 0x10      // Bit mask of OVR4 field.
	EVSYS_INTENCLR_OVR4      = 0x10      // Bit OVR4.
	EVSYS_INTENCLR_OVR5_Pos  = 0x5       // Position of OVR5 field.
	EVSYS_INTENCLR_OVR5_Msk  = 0x20      // Bit mask of OVR5 field.
	EVSYS_INTENCLR_OVR5      = 0x20      // Bit OVR5.
	EVSYS_INTENCLR_OVR6_Pos  = 0x6       // Position of OVR6 field.
	EVSYS_INTENCLR_OVR6_Msk  = 0x40      // Bit mask of OVR6 field.
	EVSYS_INTENCLR_OVR6      = 0x40      // Bit OVR6.
	EVSYS_INTENCLR_OVR7_Pos  = 0x7       // Position of OVR7 field.
	EVSYS_INTENCLR_OVR7_Msk  = 0x80      // Bit mask of OVR7 field.
	EVSYS_INTENCLR_OVR7      = 0x80      // Bit OVR7.
	EVSYS_INTENCLR_EVD0_Pos  = 0x8       // Position of EVD0 field.
	EVSYS_INTENCLR_EVD0_Msk  = 0x100     // Bit mask of EVD0 field.
	EVSYS_INTENCLR_EVD0      = 0x100     // Bit EVD0.
	EVSYS_INTENCLR_EVD1_Pos  = 0x9       // Position of EVD1 field.
	EVSYS_INTENCLR_EVD1_Msk  = 0x200     // Bit mask of EVD1 field.
	EVSYS_INTENCLR_EVD1      = 0x200     // Bit EVD1.
	EVSYS_INTENCLR_EVD2_Pos  = 0xa       // Position of EVD2 field.
	EVSYS_INTENCLR_EVD2_Msk  = 0x400     // Bit mask of EVD2 field.
	EVSYS_INTENCLR_EVD2      = 0x400     // Bit EVD2.
	EVSYS_INTENCLR_EVD3_Pos  = 0xb       // Position of EVD3 field.
	EVSYS_INTENCLR_EVD3_Msk  = 0x800     // Bit mask of EVD3 field.
	EVSYS_INTENCLR_EVD3      = 0x800     // Bit EVD3.
	EVSYS_INTENCLR_EVD4_Pos  = 0xc       // Position of EVD4 field.
	EVSYS_INTENCLR_EVD4_Msk  = 0x1000    // Bit mask of EVD4 field.
	EVSYS_INTENCLR_EVD4      = 0x1000    // Bit EVD4.
	EVSYS_INTENCLR_EVD5_Pos  = 0xd       // Position of EVD5 field.
	EVSYS_INTENCLR_EVD5_Msk  = 0x2000    // Bit mask of EVD5 field.
	EVSYS_INTENCLR_EVD5      = 0x2000    // Bit EVD5.
	EVSYS_INTENCLR_EVD6_Pos  = 0xe       // Position of EVD6 field.
	EVSYS_INTENCLR_EVD6_Msk  = 0x4000    // Bit mask of EVD6 field.
	EVSYS_INTENCLR_EVD6      = 0x4000    // Bit EVD6.
	EVSYS_INTENCLR_EVD7_Pos  = 0xf       // Position of EVD7 field.
	EVSYS_INTENCLR_EVD7_Msk  = 0x8000    // Bit mask of EVD7 field.
	EVSYS_INTENCLR_EVD7      = 0x8000    // Bit EVD7.
	EVSYS_INTENCLR_OVR8_Pos  = 0x10      // Position of OVR8 field.
	EVSYS_INTENCLR_OVR8_Msk  = 0x10000   // Bit mask of OVR8 field.
	EVSYS_INTENCLR_OVR8      = 0x10000   // Bit OVR8.
	EVSYS_INTENCLR_OVR9_Pos  = 0x11      // Position of OVR9 field.
	EVSYS_INTENCLR_OVR9_Msk  = 0x20000   // Bit mask of OVR9 field.
	EVSYS_INTENCLR_OVR9      = 0x20000   // Bit OVR9.
	EVSYS_INTENCLR_OVR10_Pos = 0x12      // Position of OVR10 field.
	EVSYS_INTENCLR_OVR10_Msk = 0x40000   // Bit mask of OVR10 field.
	EVSYS_INTENCLR_OVR10     = 0x40000   // Bit OVR10.
	EVSYS_INTENCLR_OVR11_Pos = 0x13      // Position of OVR11 field.
	EVSYS_INTENCLR_OVR11_Msk = 0x80000   // Bit mask of OVR11 field.
	EVSYS_INTENCLR_OVR11     = 0x80000   // Bit OVR11.
	EVSYS_INTENCLR_EVD8_Pos  = 0x18      // Position of EVD8 field.
	EVSYS_INTENCLR_EVD8_Msk  = 0x1000000 // Bit mask of EVD8 field.
	EVSYS_INTENCLR_EVD8      = 0x1000000 // Bit EVD8.
	EVSYS_INTENCLR_EVD9_Pos  = 0x19      // Position of EVD9 field.
	EVSYS_INTENCLR_EVD9_Msk  = 0x2000000 // Bit mask of EVD9 field.
	EVSYS_INTENCLR_EVD9      = 0x2000000 // Bit EVD9.
	EVSYS_INTENCLR_EVD10_Pos = 0x1a      // Position of EVD10 field.
	EVSYS_INTENCLR_EVD10_Msk = 0x4000000 // Bit mask of EVD10 field.
	EVSYS_INTENCLR_EVD10     = 0x4000000 // Bit EVD10.
	EVSYS_INTENCLR_EVD11_Pos = 0x1b      // Position of EVD11 field.
	EVSYS_INTENCLR_EVD11_Msk = 0x8000000 // Bit mask of EVD11 field.
	EVSYS_INTENCLR_EVD11     = 0x8000000 // Bit EVD11.

	// INTENSET: Interrupt Enable Set
	EVSYS_INTENSET_OVR0_Pos  = 0x0       // Position of OVR0 field.
	EVSYS_INTENSET_OVR0_Msk  = 0x1       // Bit mask of OVR0 field.
	EVSYS_INTENSET_OVR0      = 0x1       // Bit OVR0.
	EVSYS_INTENSET_OVR1_Pos  = 0x1       // Position of OVR1 field.
	EVSYS_INTENSET_OVR1_Msk  = 0x2       // Bit mask of OVR1 field.
	EVSYS_INTENSET_OVR1      = 0x2       // Bit OVR1.
	EVSYS_INTENSET_OVR2_Pos  = 0x2       // Position of OVR2 field.
	EVSYS_INTENSET_OVR2_Msk  = 0x4       // Bit mask of OVR2 field.
	EVSYS_INTENSET_OVR2      = 0x4       // Bit OVR2.
	EVSYS_INTENSET_OVR3_Pos  = 0x3       // Position of OVR3 field.
	EVSYS_INTENSET_OVR3_Msk  = 0x8       // Bit mask of OVR3 field.
	EVSYS_INTENSET_OVR3      = 0x8       // Bit OVR3.
	EVSYS_INTENSET_OVR4_Pos  = 0x4       // Position of OVR4 field.
	EVSYS_INTENSET_OVR4_Msk  = 0x10      // Bit mask of OVR4 field.
	EVSYS_INTENSET_OVR4      = 0x10      // Bit OVR4.
	EVSYS_INTENSET_OVR5_Pos  = 0x5       // Position of OVR5 field.
	EVSYS_INTENSET_OVR5_Msk  = 0x20      // Bit mask of OVR5 field.
	EVSYS_INTENSET_OVR5      = 0x20      // Bit OVR5.
	EVSYS_INTENSET_OVR6_Pos  = 0x6       // Position of OVR6 field.
	EVSYS_INTENSET_OVR6_Msk  = 0x40      // Bit mask of OVR6 field.
	EVSYS_INTENSET_OVR6      = 0x40      // Bit OVR6.
	EVSYS_INTENSET_OVR7_Pos  = 0x7       // Position of OVR7 field.
	EVSYS_INTENSET_OVR7_Msk  = 0x80      // Bit mask of OVR7 field.
	EVSYS_INTENSET_OVR7      = 0x80      // Bit OVR7.
	EVSYS_INTENSET_EVD0_Pos  = 0x8       // Position of EVD0 field.
	EVSYS_INTENSET_EVD0_Msk  = 0x100     // Bit mask of EVD0 field.
	EVSYS_INTENSET_EVD0      = 0x100     // Bit EVD0.
	EVSYS_INTENSET_EVD1_Pos  = 0x9       // Position of EVD1 field.
	EVSYS_INTENSET_EVD1_Msk  = 0x200     // Bit mask of EVD1 field.
	EVSYS_INTENSET_EVD1      = 0x200     // Bit EVD1.
	EVSYS_INTENSET_EVD2_Pos  = 0xa       // Position of EVD2 field.
	EVSYS_INTENSET_EVD2_Msk  = 0x400     // Bit mask of EVD2 field.
	EVSYS_INTENSET_EVD2      = 0x400     // Bit EVD2.
	EVSYS_INTENSET_EVD3_Pos  = 0xb       // Position of EVD3 field.
	EVSYS_INTENSET_EVD3_Msk  = 0x800     // Bit mask of EVD3 field.
	EVSYS_INTENSET_EVD3      = 0x800     // Bit EVD3.
	EVSYS_INTENSET_EVD4_Pos  = 0xc       // Position of EVD4 field.
	EVSYS_INTENSET_EVD4_Msk  = 0x1000    // Bit mask of EVD4 field.
	EVSYS_INTENSET_EVD4      = 0x1000    // Bit EVD4.
	EVSYS_INTENSET_EVD5_Pos  = 0xd       // Position of EVD5 field.
	EVSYS_INTENSET_EVD5_Msk  = 0x2000    // Bit mask of EVD5 field.
	EVSYS_INTENSET_EVD5      = 0x2000    // Bit EVD5.
	EVSYS_INTENSET_EVD6_Pos  = 0xe       // Position of EVD6 field.
	EVSYS_INTENSET_EVD6_Msk  = 0x4000    // Bit mask of EVD6 field.
	EVSYS_INTENSET_EVD6      = 0x4000    // Bit EVD6.
	EVSYS_INTENSET_EVD7_Pos  = 0xf       // Position of EVD7 field.
	EVSYS_INTENSET_EVD7_Msk  = 0x8000    // Bit mask of EVD7 field.
	EVSYS_INTENSET_EVD7      = 0x8000    // Bit EVD7.
	EVSYS_INTENSET_OVR8_Pos  = 0x10      // Position of OVR8 field.
	EVSYS_INTENSET_OVR8_Msk  = 0x10000   // Bit mask of OVR8 field.
	EVSYS_INTENSET_OVR8      = 0x10000   // Bit OVR8.
	EVSYS_INTENSET_OVR9_Pos  = 0x11      // Position of OVR9 field.
	EVSYS_INTENSET_OVR9_Msk  = 0x20000   // Bit mask of OVR9 field.
	EVSYS_INTENSET_OVR9      = 0x20000   // Bit OVR9.
	EVSYS_INTENSET_OVR10_Pos = 0x12      // Position of OVR10 field.
	EVSYS_INTENSET_OVR10_Msk = 0x40000   // Bit mask of OVR10 field.
	EVSYS_INTENSET_OVR10     = 0x40000   // Bit OVR10.
	EVSYS_INTENSET_OVR11_Pos = 0x13      // Position of OVR11 field.
	EVSYS_INTENSET_OVR11_Msk = 0x80000   // Bit mask of OVR11 field.
	EVSYS_INTENSET_OVR11     = 0x80000   // Bit OVR11.
	EVSYS_INTENSET_EVD8_Pos  = 0x18      // Position of EVD8 field.
	EVSYS_INTENSET_EVD8_Msk  = 0x1000000 // Bit mask of EVD8 field.
	EVSYS_INTENSET_EVD8      = 0x1000000 // Bit EVD8.
	EVSYS_INTENSET_EVD9_Pos  = 0x19      // Position of EVD9 field.
	EVSYS_INTENSET_EVD9_Msk  = 0x2000000 // Bit mask of EVD9 field.
	EVSYS_INTENSET_EVD9      = 0x2000000 // Bit EVD9.
	EVSYS_INTENSET_EVD10_Pos = 0x1a      // Position of EVD10 field.
	EVSYS_INTENSET_EVD10_Msk = 0x4000000 // Bit mask of EVD10 field.
	EVSYS_INTENSET_EVD10     = 0x4000000 // Bit EVD10.
	EVSYS_INTENSET_EVD11_Pos = 0x1b      // Position of EVD11 field.
	EVSYS_INTENSET_EVD11_Msk = 0x8000000 // Bit mask of EVD11 field.
	EVSYS_INTENSET_EVD11     = 0x8000000 // Bit EVD11.

	// INTFLAG: Interrupt Flag Status and Clear
	EVSYS_INTFLAG_OVR0_Pos  = 0x0       // Position of OVR0 field.
	EVSYS_INTFLAG_OVR0_Msk  = 0x1       // Bit mask of OVR0 field.
	EVSYS_INTFLAG_OVR0      = 0x1       // Bit OVR0.
	EVSYS_INTFLAG_OVR1_Pos  = 0x1       // Position of OVR1 field.
	EVSYS_INTFLAG_OVR1_Msk  = 0x2       // Bit mask of OVR1 field.
	EVSYS_INTFLAG_OVR1      = 0x2       // Bit OVR1.
	EVSYS_INTFLAG_OVR2_Pos  = 0x2       // Position of OVR2 field.
	EVSYS_INTFLAG_OVR2_Msk  = 0x4       // Bit mask of OVR2 field.
	EVSYS_INTFLAG_OVR2      = 0x4       // Bit OVR2.
	EVSYS_INTFLAG_OVR3_Pos  = 0x3       // Position of OVR3 field.
	EVSYS_INTFLAG_OVR3_Msk  = 0x8       // Bit mask of OVR3 field.
	EVSYS_INTFLAG_OVR3      = 0x8       // Bit OVR3.
	EVSYS_INTFLAG_OVR4_Pos  = 0x4       // Position of OVR4 field.
	EVSYS_INTFLAG_OVR4_Msk  = 0x10      // Bit mask of OVR4 field.
	EVSYS_INTFLAG_OVR4      = 0x10      // Bit OVR4.
	EVSYS_INTFLAG_OVR5_Pos  = 0x5       // Position of OVR5 field.
	EVSYS_INTFLAG_OVR5_Msk  = 0x20      // Bit mask of OVR5 field.
	EVSYS_INTFLAG_OVR5      = 0x20      // Bit OVR5.
	EVSYS_INTFLAG_OVR6_Pos  = 0x6       // Position of OVR6 field.
	EVSYS_INTFLAG_OVR6_Msk  = 0x40      // Bit mask of OVR6 field.
	EVSYS_INTFLAG_OVR6      = 0x40      // Bit OVR6.
	EVSYS_INTFLAG_OVR7_Pos  = 0x7       // Position of OVR7 field.
	EVSYS_INTFLAG_OVR7_Msk  = 0x80      // Bit mask of OVR7 field.
	EVSYS_INTFLAG_OVR7      = 0x80      // Bit OVR7.
	EVSYS_INTFLAG_EVD0_Pos  = 0x8       // Position of EVD0 field.
	EVSYS_INTFLAG_EVD0_Msk  = 0x100     // Bit mask of EVD0 field.
	EVSYS_INTFLAG_EVD0      = 0x100     // Bit EVD0.
	EVSYS_INTFLAG_EVD1_Pos  = 0x9       // Position of EVD1 field.
	EVSYS_INTFLAG_EVD1_Msk  = 0x200     // Bit mask of EVD1 field.
	EVSYS_INTFLAG_EVD1      = 0x200     // Bit EVD1.
	EVSYS_INTFLAG_EVD2_Pos  = 0xa       // Position of EVD2 field.
	EVSYS_INTFLAG_EVD2_Msk  = 0x400     // Bit mask of EVD2 field.
	EVSYS_INTFLAG_EVD2      = 0x400     // Bit EVD2.
	EVSYS_INTFLAG_EVD3_Pos  = 0xb       // Position of EVD3 field.
	EVSYS_INTFLAG_EVD3_Msk  = 0x800     // Bit mask of EVD3 field.
	EVSYS_INTFLAG_EVD3      = 0x800     // Bit EVD3.
	EVSYS_INTFLAG_EVD4_Pos  = 0xc       // Position of EVD4 field.
	EVSYS_INTFLAG_EVD4_Msk  = 0x1000    // Bit mask of EVD4 field.
	EVSYS_INTFLAG_EVD4      = 0x1000    // Bit EVD4.
	EVSYS_INTFLAG_EVD5_Pos  = 0xd       // Position of EVD5 field.
	EVSYS_INTFLAG_EVD5_Msk  = 0x2000    // Bit mask of EVD5 field.
	EVSYS_INTFLAG_EVD5      = 0x2000    // Bit EVD5.
	EVSYS_INTFLAG_EVD6_Pos  = 0xe       // Position of EVD6 field.
	EVSYS_INTFLAG_EVD6_Msk  = 0x4000    // Bit mask of EVD6 field.
	EVSYS_INTFLAG_EVD6      = 0x4000    // Bit EVD6.
	EVSYS_INTFLAG_EVD7_Pos  = 0xf       // Position of EVD7 field.
	EVSYS_INTFLAG_EVD7_Msk  = 0x8000    // Bit mask of EVD7 field.
	EVSYS_INTFLAG_EVD7      = 0x8000    // Bit EVD7.
	EVSYS_INTFLAG_OVR8_Pos  = 0x10      // Position of OVR8 field.
	EVSYS_INTFLAG_OVR8_Msk  = 0x10000   // Bit mask of OVR8 field.
	EVSYS_INTFLAG_OVR8      = 0x10000   // Bit OVR8.
	EVSYS_INTFLAG_OVR9_Pos  = 0x11      // Position of OVR9 field.
	EVSYS_INTFLAG_OVR9_Msk  = 0x20000   // Bit mask of OVR9 field.
	EVSYS_INTFLAG_OVR9      = 0x20000   // Bit OVR9.
	EVSYS_INTFLAG_OVR10_Pos = 0x12      // Position of OVR10 field.
	EVSYS_INTFLAG_OVR10_Msk = 0x40000   // Bit mask of OVR10 field.
	EVSYS_INTFLAG_OVR10     = 0x40000   // Bit OVR10.
	EVSYS_INTFLAG_OVR11_Pos = 0x13      // Position of OVR11 field.
	EVSYS_INTFLAG_OVR11_Msk = 0x80000   // Bit mask of OVR11 field.
	EVSYS_INTFLAG_OVR11     = 0x80000   // Bit OVR11.
	EVSYS_INTFLAG_EVD8_Pos  = 0x18      // Position of EVD8 field.
	EVSYS_INTFLAG_EVD8_Msk  = 0x1000000 // Bit mask of EVD8 field.
	EVSYS_INTFLAG_EVD8      = 0x1000000 // Bit EVD8.
	EVSYS_INTFLAG_EVD9_Pos  = 0x19      // Position of EVD9 field.
	EVSYS_INTFLAG_EVD9_Msk  = 0x2000000 // Bit mask of EVD9 field.
	EVSYS_INTFLAG_EVD9      = 0x2000000 // Bit EVD9.
	EVSYS_INTFLAG_EVD10_Pos = 0x1a      // Position of EVD10 field.
	EVSYS_INTFLAG_EVD10_Msk = 0x4000000 // Bit mask of EVD10 field.
	EVSYS_INTFLAG_EVD10     = 0x4000000 // Bit EVD10.
	EVSYS_INTFLAG_EVD11_Pos = 0x1b      // Position of EVD11 field.
	EVSYS_INTFLAG_EVD11_Msk = 0x8000000 // Bit mask of EVD11 field.
	EVSYS_INTFLAG_EVD11     = 0x8000000 // Bit EVD11.
)

// Bitfields for GCLK: Generic Clock Generator
const (
	// CTRL: Control
	GCLK_CTRL_SWRST_Pos = 0x0 // Position of SWRST field.
	GCLK_CTRL_SWRST_Msk = 0x1 // Bit mask of SWRST field.
	GCLK_CTRL_SWRST     = 0x1 // Bit SWRST.

	// STATUS: Status
	GCLK_STATUS_SYNCBUSY_Pos = 0x7  // Position of SYNCBUSY field.
	GCLK_STATUS_SYNCBUSY_Msk = 0x80 // Bit mask of SYNCBUSY field.
	GCLK_STATUS_SYNCBUSY     = 0x80 // Bit SYNCBUSY.

	// CLKCTRL: Generic Clock Control
	GCLK_CLKCTRL_ID_Pos          = 0x0    // Position of ID field.
	GCLK_CLKCTRL_ID_Msk          = 0x3f   // Bit mask of ID field.
	GCLK_CLKCTRL_ID_DFLL48       = 0x0    // DFLL48
	GCLK_CLKCTRL_ID_FDPLL        = 0x1    // FDPLL
	GCLK_CLKCTRL_ID_FDPLL32K     = 0x2    // FDPLL32K
	GCLK_CLKCTRL_ID_WDT          = 0x3    // WDT
	GCLK_CLKCTRL_ID_RTC          = 0x4    // RTC
	GCLK_CLKCTRL_ID_EIC          = 0x5    // EIC
	GCLK_CLKCTRL_ID_USB          = 0x6    // USB
	GCLK_CLKCTRL_ID_EVSYS_0      = 0x7    // EVSYS_0
	GCLK_CLKCTRL_ID_EVSYS_1      = 0x8    // EVSYS_1
	GCLK_CLKCTRL_ID_EVSYS_2      = 0x9    // EVSYS_2
	GCLK_CLKCTRL_ID_EVSYS_3      = 0xa    // EVSYS_3
	GCLK_CLKCTRL_ID_EVSYS_4      = 0xb    // EVSYS_4
	GCLK_CLKCTRL_ID_EVSYS_5      = 0xc    // EVSYS_5
	GCLK_CLKCTRL_ID_EVSYS_6      = 0xd    // EVSYS_6
	GCLK_CLKCTRL_ID_EVSYS_7      = 0xe    // EVSYS_7
	GCLK_CLKCTRL_ID_EVSYS_8      = 0xf    // EVSYS_8
	GCLK_CLKCTRL_ID_EVSYS_9      = 0x10   // EVSYS_9
	GCLK_CLKCTRL_ID_EVSYS_10     = 0x11   // EVSYS_10
	GCLK_CLKCTRL_ID_EVSYS_11     = 0x12   // EVSYS_11
	GCLK_CLKCTRL_ID_SERCOMX_SLOW = 0x13   // SERCOMX_SLOW
	GCLK_CLKCTRL_ID_SERCOM0_CORE = 0x14   // SERCOM0_CORE
	GCLK_CLKCTRL_ID_SERCOM1_CORE = 0x15   // SERCOM1_CORE
	GCLK_CLKCTRL_ID_SERCOM2_CORE = 0x16   // SERCOM2_CORE
	GCLK_CLKCTRL_ID_SERCOM3_CORE = 0x17   // SERCOM3_CORE
	GCLK_CLKCTRL_ID_SERCOM4_CORE = 0x18   // SERCOM4_CORE
	GCLK_CLKCTRL_ID_SERCOM5_CORE = 0x19   // SERCOM5_CORE
	GCLK_CLKCTRL_ID_TCC0_TCC1    = 0x1a   // TCC0_TCC1
	GCLK_CLKCTRL_ID_TCC2_TC3     = 0x1b   // TCC2_TC3
	GCLK_CLKCTRL_ID_TC4_TC5      = 0x1c   // TC4_TC5
	GCLK_CLKCTRL_ID_TC6_TC7      = 0x1d   // TC6_TC7
	GCLK_CLKCTRL_ID_ADC          = 0x1e   // ADC
	GCLK_CLKCTRL_ID_AC_DIG       = 0x1f   // AC_DIG
	GCLK_CLKCTRL_ID_AC_ANA       = 0x20   // AC_ANA
	GCLK_CLKCTRL_ID_DAC          = 0x21   // DAC
	GCLK_CLKCTRL_ID_I2S_0        = 0x23   // I2S_0
	GCLK_CLKCTRL_ID_I2S_1        = 0x24   // I2S_1
	GCLK_CLKCTRL_GEN_Pos         = 0x8    // Position of GEN field.
	GCLK_CLKCTRL_GEN_Msk         = 0xf00  // Bit mask of GEN field.
	GCLK_CLKCTRL_GEN_GCLK0       = 0x0    // Generic clock generator 0
	GCLK_CLKCTRL_GEN_GCLK1       = 0x1    // Generic clock generator 1
	GCLK_CLKCTRL_GEN_GCLK2       = 0x2    // Generic clock generator 2
	GCLK_CLKCTRL_GEN_GCLK3       = 0x3    // Generic clock generator 3
	GCLK_CLKCTRL_GEN_GCLK4       = 0x4    // Generic clock generator 4
	GCLK_CLKCTRL_GEN_GCLK5       = 0x5    // Generic clock generator 5
	GCLK_CLKCTRL_GEN_GCLK6       = 0x6    // Generic clock generator 6
	GCLK_CLKCTRL_GEN_GCLK7       = 0x7    // Generic clock generator 7
	GCLK_CLKCTRL_GEN_GCLK8       = 0x8    // Generic clock generator 8
	GCLK_CLKCTRL_CLKEN_Pos       = 0xe    // Position of CLKEN field.
	GCLK_CLKCTRL_CLKEN_Msk       = 0x4000 // Bit mask of CLKEN field.
	GCLK_CLKCTRL_CLKEN           = 0x4000 // Bit CLKEN.
	GCLK_CLKCTRL_WRTLOCK_Pos     = 0xf    // Position of WRTLOCK field.
	GCLK_CLKCTRL_WRTLOCK_Msk     = 0x8000 // Bit mask of WRTLOCK field.
	GCLK_CLKCTRL_WRTLOCK         = 0x8000 // Bit WRTLOCK.

	// GENCTRL: Generic Clock Generator Control
	GCLK_GENCTRL_ID_Pos        = 0x0      // Position of ID field.
	GCLK_GENCTRL_ID_Msk        = 0xf      // Bit mask of ID field.
	GCLK_GENCTRL_SRC_Pos       = 0x8      // Position of SRC field.
	GCLK_GENCTRL_SRC_Msk       = 0x1f00   // Bit mask of SRC field.
	GCLK_GENCTRL_SRC_XOSC      = 0x0      // XOSC oscillator output
	GCLK_GENCTRL_SRC_GCLKIN    = 0x1      // Generator input pad
	GCLK_GENCTRL_SRC_GCLKGEN1  = 0x2      // Generic clock generator 1 output
	GCLK_GENCTRL_SRC_OSCULP32K = 0x3      // OSCULP32K oscillator output
	GCLK_GENCTRL_SRC_OSC32K    = 0x4      // OSC32K oscillator output
	GCLK_GENCTRL_SRC_XOSC32K   = 0x5      // XOSC32K oscillator output
	GCLK_GENCTRL_SRC_OSC8M     = 0x6      // OSC8M oscillator output
	GCLK_GENCTRL_SRC_DFLL48M   = 0x7      // DFLL48M output
	GCLK_GENCTRL_SRC_DPLL96M   = 0x8      // DPLL96M output
	GCLK_GENCTRL_GENEN_Pos     = 0x10     // Position of GENEN field.
	GCLK_GENCTRL_GENEN_Msk     = 0x10000  // Bit mask of GENEN field.
	GCLK_GENCTRL_GENEN         = 0x10000  // Bit GENEN.
	GCLK_GENCTRL_IDC_Pos       = 0x11     // Position of IDC field.
	GCLK_GENCTRL_IDC_Msk       = 0x20000  // Bit mask of IDC field.
	GCLK_GENCTRL_IDC           = 0x20000  // Bit IDC.
	GCLK_GENCTRL_OOV_Pos       = 0x12     // Position of OOV field.
	GCLK_GENCTRL_OOV_Msk       = 0x40000  // Bit mask of OOV field.
	GCLK_GENCTRL_OOV           = 0x40000  // Bit OOV.
	GCLK_GENCTRL_OE_Pos        = 0x13     // Position of OE field.
	GCLK_GENCTRL_OE_Msk        = 0x80000  // Bit mask of OE field.
	GCLK_GENCTRL_OE            = 0x80000  // Bit OE.
	GCLK_GENCTRL_DIVSEL_Pos    = 0x14     // Position of DIVSEL field.
	GCLK_GENCTRL_DIVSEL_Msk    = 0x100000 // Bit mask of DIVSEL field.
	GCLK_GENCTRL_DIVSEL        = 0x100000 // Bit DIVSEL.
	GCLK_GENCTRL_RUNSTDBY_Pos  = 0x15     // Position of RUNSTDBY field.
	GCLK_GENCTRL_RUNSTDBY_Msk  = 0x200000 // Bit mask of RUNSTDBY field.
	GCLK_GENCTRL_RUNSTDBY      = 0x200000 // Bit RUNSTDBY.

	// GENDIV: Generic Clock Generator Division
	GCLK_GENDIV_ID_Pos  = 0x0      // Position of ID field.
	GCLK_GENDIV_ID_Msk  = 0xf      // Bit mask of ID field.
	GCLK_GENDIV_DIV_Pos = 0x8      // Position of DIV field.
	GCLK_GENDIV_DIV_Msk = 0xffff00 // Bit mask of DIV field.
)

// Bitfields for HMATRIX: HSB Matrix
const (
	// SFR0: Special Function
	HMATRIXB_SFR_SFR_Pos = 0x0        // Position of SFR field.
	HMATRIXB_SFR_SFR_Msk = 0xffffffff // Bit mask of SFR field.
)

// Bitfields for I2S: Inter-IC Sound Interface
const (
	// CTRLA: Control A
	I2S_CTRLA_SWRST_Pos  = 0x0  // Position of SWRST field.
	I2S_CTRLA_SWRST_Msk  = 0x1  // Bit mask of SWRST field.
	I2S_CTRLA_SWRST      = 0x1  // Bit SWRST.
	I2S_CTRLA_ENABLE_Pos = 0x1  // Position of ENABLE field.
	I2S_CTRLA_ENABLE_Msk = 0x2  // Bit mask of ENABLE field.
	I2S_CTRLA_ENABLE     = 0x2  // Bit ENABLE.
	I2S_CTRLA_CKEN0_Pos  = 0x2  // Position of CKEN0 field.
	I2S_CTRLA_CKEN0_Msk  = 0x4  // Bit mask of CKEN0 field.
	I2S_CTRLA_CKEN0      = 0x4  // Bit CKEN0.
	I2S_CTRLA_CKEN1_Pos  = 0x3  // Position of CKEN1 field.
	I2S_CTRLA_CKEN1_Msk  = 0x8  // Bit mask of CKEN1 field.
	I2S_CTRLA_CKEN1      = 0x8  // Bit CKEN1.
	I2S_CTRLA_SEREN0_Pos = 0x4  // Position of SEREN0 field.
	I2S_CTRLA_SEREN0_Msk = 0x10 // Bit mask of SEREN0 field.
	I2S_CTRLA_SEREN0     = 0x10 // Bit SEREN0.
	I2S_CTRLA_SEREN1_Pos = 0x5  // Position of SEREN1 field.
	I2S_CTRLA_SEREN1_Msk = 0x20 // Bit mask of SEREN1 field.
	I2S_CTRLA_SEREN1     = 0x20 // Bit SEREN1.

	// CLKCTRL0: Clock Unit n Control
	I2S_CLKCTRL_SLOTSIZE_Pos  = 0x0        // Position of SLOTSIZE field.
	I2S_CLKCTRL_SLOTSIZE_Msk  = 0x3        // Bit mask of SLOTSIZE field.
	I2S_CLKCTRL_SLOTSIZE_8    = 0x0        // 8-bit Slot for Clock Unit n
	I2S_CLKCTRL_SLOTSIZE_16   = 0x1        // 16-bit Slot for Clock Unit n
	I2S_CLKCTRL_SLOTSIZE_24   = 0x2        // 24-bit Slot for Clock Unit n
	I2S_CLKCTRL_SLOTSIZE_32   = 0x3        // 32-bit Slot for Clock Unit n
	I2S_CLKCTRL_NBSLOTS_Pos   = 0x2        // Position of NBSLOTS field.
	I2S_CLKCTRL_NBSLOTS_Msk   = 0x1c       // Bit mask of NBSLOTS field.
	I2S_CLKCTRL_FSWIDTH_Pos   = 0x5        // Position of FSWIDTH field.
	I2S_CLKCTRL_FSWIDTH_Msk   = 0x60       // Bit mask of FSWIDTH field.
	I2S_CLKCTRL_FSWIDTH_SLOT  = 0x0        // Frame Sync Pulse is 1 Slot wide (default for I2S protocol)
	I2S_CLKCTRL_FSWIDTH_HALF  = 0x1        // Frame Sync Pulse is half a Frame wide
	I2S_CLKCTRL_FSWIDTH_BIT   = 0x2        // Frame Sync Pulse is 1 Bit wide
	I2S_CLKCTRL_FSWIDTH_BURST = 0x3        // Clock Unit n operates in Burst mode, with a 1-bit wide Frame Sync pulse per Data sample, only when Data transfer is requested
	I2S_CLKCTRL_BITDELAY_Pos  = 0x7        // Position of BITDELAY field.
	I2S_CLKCTRL_BITDELAY_Msk  = 0x80       // Bit mask of BITDELAY field.
	I2S_CLKCTRL_BITDELAY      = 0x80       // Bit BITDELAY.
	I2S_CLKCTRL_BITDELAY_LJ   = 0x0        // Left Justified (0 Bit Delay)
	I2S_CLKCTRL_BITDELAY_I2S  = 0x1        // I2S (1 Bit Delay)
	I2S_CLKCTRL_FSSEL_Pos     = 0x8        // Position of FSSEL field.
	I2S_CLKCTRL_FSSEL_Msk     = 0x100      // Bit mask of FSSEL field.
	I2S_CLKCTRL_FSSEL         = 0x100      // Bit FSSEL.
	I2S_CLKCTRL_FSSEL_SCKDIV  = 0x0        // Divided Serial Clock n is used as Frame Sync n source
	I2S_CLKCTRL_FSSEL_FSPIN   = 0x1        // FSn input pin is used as Frame Sync n source
	I2S_CLKCTRL_FSINV_Pos     = 0xb        // Position of FSINV field.
	I2S_CLKCTRL_FSINV_Msk     = 0x800      // Bit mask of FSINV field.
	I2S_CLKCTRL_FSINV         = 0x800      // Bit FSINV.
	I2S_CLKCTRL_SCKSEL_Pos    = 0xc        // Position of SCKSEL field.
	I2S_CLKCTRL_SCKSEL_Msk    = 0x1000     // Bit mask of SCKSEL field.
	I2S_CLKCTRL_SCKSEL        = 0x1000     // Bit SCKSEL.
	I2S_CLKCTRL_SCKSEL_MCKDIV = 0x0        // Divided Master Clock n is used as Serial Clock n source
	I2S_CLKCTRL_SCKSEL_SCKPIN = 0x1        // SCKn input pin is used as Serial Clock n source
	I2S_CLKCTRL_MCKSEL_Pos    = 0x10       // Position of MCKSEL field.
	I2S_CLKCTRL_MCKSEL_Msk    = 0x10000    // Bit mask of MCKSEL field.
	I2S_CLKCTRL_MCKSEL        = 0x10000    // Bit MCKSEL.
	I2S_CLKCTRL_MCKSEL_GCLK   = 0x0        // GCLK_I2S_n is used as Master Clock n source
	I2S_CLKCTRL_MCKSEL_MCKPIN = 0x1        // MCKn input pin is used as Master Clock n source
	I2S_CLKCTRL_MCKEN_Pos     = 0x12       // Position of MCKEN field.
	I2S_CLKCTRL_MCKEN_Msk     = 0x40000    // Bit mask of MCKEN field.
	I2S_CLKCTRL_MCKEN         = 0x40000    // Bit MCKEN.
	I2S_CLKCTRL_MCKDIV_Pos    = 0x13       // Position of MCKDIV field.
	I2S_CLKCTRL_MCKDIV_Msk    = 0xf80000   // Bit mask of MCKDIV field.
	I2S_CLKCTRL_MCKOUTDIV_Pos = 0x18       // Position of MCKOUTDIV field.
	I2S_CLKCTRL_MCKOUTDIV_Msk = 0x1f000000 // Bit mask of MCKOUTDIV field.
	I2S_CLKCTRL_FSOUTINV_Pos  = 0x1d       // Position of FSOUTINV field.
	I2S_CLKCTRL_FSOUTINV_Msk  = 0x20000000 // Bit mask of FSOUTINV field.
	I2S_CLKCTRL_FSOUTINV      = 0x20000000 // Bit FSOUTINV.
	I2S_CLKCTRL_SCKOUTINV_Pos = 0x1e       // Position of SCKOUTINV field.
	I2S_CLKCTRL_SCKOUTINV_Msk = 0x40000000 // Bit mask of SCKOUTINV field.
	I2S_CLKCTRL_SCKOUTINV     = 0x40000000 // Bit SCKOUTINV.
	I2S_CLKCTRL_MCKOUTINV_Pos = 0x1f       // Position of MCKOUTINV field.
	I2S_CLKCTRL_MCKOUTINV_Msk = 0x80000000 // Bit mask of MCKOUTINV field.
	I2S_CLKCTRL_MCKOUTINV     = 0x80000000 // Bit MCKOUTINV.

	// INTENCLR: Interrupt Enable Clear
	I2S_INTENCLR_RXRDY0_Pos = 0x0    // Position of RXRDY0 field.
	I2S_INTENCLR_RXRDY0_Msk = 0x1    // Bit mask of RXRDY0 field.
	I2S_INTENCLR_RXRDY0     = 0x1    // Bit RXRDY0.
	I2S_INTENCLR_RXRDY1_Pos = 0x1    // Position of RXRDY1 field.
	I2S_INTENCLR_RXRDY1_Msk = 0x2    // Bit mask of RXRDY1 field.
	I2S_INTENCLR_RXRDY1     = 0x2    // Bit RXRDY1.
	I2S_INTENCLR_RXOR0_Pos  = 0x4    // Position of RXOR0 field.
	I2S_INTENCLR_RXOR0_Msk  = 0x10   // Bit mask of RXOR0 field.
	I2S_INTENCLR_RXOR0      = 0x10   // Bit RXOR0.
	I2S_INTENCLR_RXOR1_Pos  = 0x5    // Position of RXOR1 field.
	I2S_INTENCLR_RXOR1_Msk  = 0x20   // Bit mask of RXOR1 field.
	I2S_INTENCLR_RXOR1      = 0x20   // Bit RXOR1.
	I2S_INTENCLR_TXRDY0_Pos = 0x8    // Position of TXRDY0 field.
	I2S_INTENCLR_TXRDY0_Msk = 0x100  // Bit mask of TXRDY0 field.
	I2S_INTENCLR_TXRDY0     = 0x100  // Bit TXRDY0.
	I2S_INTENCLR_TXRDY1_Pos = 0x9    // Position of TXRDY1 field.
	I2S_INTENCLR_TXRDY1_Msk = 0x200  // Bit mask of TXRDY1 field.
	I2S_INTENCLR_TXRDY1     = 0x200  // Bit TXRDY1.
	I2S_INTENCLR_TXUR0_Pos  = 0xc    // Position of TXUR0 field.
	I2S_INTENCLR_TXUR0_Msk  = 0x1000 // Bit mask of TXUR0 field.
	I2S_INTENCLR_TXUR0      = 0x1000 // Bit TXUR0.
	I2S_INTENCLR_TXUR1_Pos  = 0xd    // Position of TXUR1 field.
	I2S_INTENCLR_TXUR1_Msk  = 0x2000 // Bit mask of TXUR1 field.
	I2S_INTENCLR_TXUR1      = 0x2000 // Bit TXUR1.

	// INTENSET: Interrupt Enable Set
	I2S_INTENSET_RXRDY0_Pos = 0x0    // Position of RXRDY0 field.
	I2S_INTENSET_RXRDY0_Msk = 0x1    // Bit mask of RXRDY0 field.
	I2S_INTENSET_RXRDY0     = 0x1    // Bit RXRDY0.
	I2S_INTENSET_RXRDY1_Pos = 0x1    // Position of RXRDY1 field.
	I2S_INTENSET_RXRDY1_Msk = 0x2    // Bit mask of RXRDY1 field.
	I2S_INTENSET_RXRDY1     = 0x2    // Bit RXRDY1.
	I2S_INTENSET_RXOR0_Pos  = 0x4    // Position of RXOR0 field.
	I2S_INTENSET_RXOR0_Msk  = 0x10   // Bit mask of RXOR0 field.
	I2S_INTENSET_RXOR0      = 0x10   // Bit RXOR0.
	I2S_INTENSET_RXOR1_Pos  = 0x5    // Position of RXOR1 field.
	I2S_INTENSET_RXOR1_Msk  = 0x20   // Bit mask of RXOR1 field.
	I2S_INTENSET_RXOR1      = 0x20   // Bit RXOR1.
	I2S_INTENSET_TXRDY0_Pos = 0x8    // Position of TXRDY0 field.
	I2S_INTENSET_TXRDY0_Msk = 0x100  // Bit mask of TXRDY0 field.
	I2S_INTENSET_TXRDY0     = 0x100  // Bit TXRDY0.
	I2S_INTENSET_TXRDY1_Pos = 0x9    // Position of TXRDY1 field.
	I2S_INTENSET_TXRDY1_Msk = 0x200  // Bit mask of TXRDY1 field.
	I2S_INTENSET_TXRDY1     = 0x200  // Bit TXRDY1.
	I2S_INTENSET_TXUR0_Pos  = 0xc    // Position of TXUR0 field.
	I2S_INTENSET_TXUR0_Msk  = 0x1000 // Bit mask of TXUR0 field.
	I2S_INTENSET_TXUR0      = 0x1000 // Bit TXUR0.
	I2S_INTENSET_TXUR1_Pos  = 0xd    // Position of TXUR1 field.
	I2S_INTENSET_TXUR1_Msk  = 0x2000 // Bit mask of TXUR1 field.
	I2S_INTENSET_TXUR1      = 0x2000 // Bit TXUR1.

	// INTFLAG: Interrupt Flag Status and Clear
	I2S_INTFLAG_RXRDY0_Pos = 0x0    // Position of RXRDY0 field.
	I2S_INTFLAG_RXRDY0_Msk = 0x1    // Bit mask of RXRDY0 field.
	I2S_INTFLAG_RXRDY0     = 0x1    // Bit RXRDY0.
	I2S_INTFLAG_RXRDY1_Pos = 0x1    // Position of RXRDY1 field.
	I2S_INTFLAG_RXRDY1_Msk = 0x2    // Bit mask of RXRDY1 field.
	I2S_INTFLAG_RXRDY1     = 0x2    // Bit RXRDY1.
	I2S_INTFLAG_RXOR0_Pos  = 0x4    // Position of RXOR0 field.
	I2S_INTFLAG_RXOR0_Msk  = 0x10   // Bit mask of RXOR0 field.
	I2S_INTFLAG_RXOR0      = 0x10   // Bit RXOR0.
	I2S_INTFLAG_RXOR1_Pos  = 0x5    // Position of RXOR1 field.
	I2S_INTFLAG_RXOR1_Msk  = 0x20   // Bit mask of RXOR1 field.
	I2S_INTFLAG_RXOR1      = 0x20   // Bit RXOR1.
	I2S_INTFLAG_TXRDY0_Pos = 0x8    // Position of TXRDY0 field.
	I2S_INTFLAG_TXRDY0_Msk = 0x100  // Bit mask of TXRDY0 field.
	I2S_INTFLAG_TXRDY0     = 0x100  // Bit TXRDY0.
	I2S_INTFLAG_TXRDY1_Pos = 0x9    // Position of TXRDY1 field.
	I2S_INTFLAG_TXRDY1_Msk = 0x200  // Bit mask of TXRDY1 field.
	I2S_INTFLAG_TXRDY1     = 0x200  // Bit TXRDY1.
	I2S_INTFLAG_TXUR0_Pos  = 0xc    // Position of TXUR0 field.
	I2S_INTFLAG_TXUR0_Msk  = 0x1000 // Bit mask of TXUR0 field.
	I2S_INTFLAG_TXUR0      = 0x1000 // Bit TXUR0.
	I2S_INTFLAG_TXUR1_Pos  = 0xd    // Position of TXUR1 field.
	I2S_INTFLAG_TXUR1_Msk  = 0x2000 // Bit mask of TXUR1 field.
	I2S_INTFLAG_TXUR1      = 0x2000 // Bit TXUR1.

	// SYNCBUSY: Synchronization Status
	I2S_SYNCBUSY_SWRST_Pos  = 0x0   // Position of SWRST field.
	I2S_SYNCBUSY_SWRST_Msk  = 0x1   // Bit mask of SWRST field.
	I2S_SYNCBUSY_SWRST      = 0x1   // Bit SWRST.
	I2S_SYNCBUSY_ENABLE_Pos = 0x1   // Position of ENABLE field.
	I2S_SYNCBUSY_ENABLE_Msk = 0x2   // Bit mask of ENABLE field.
	I2S_SYNCBUSY_ENABLE     = 0x2   // Bit ENABLE.
	I2S_SYNCBUSY_CKEN0_Pos  = 0x2   // Position of CKEN0 field.
	I2S_SYNCBUSY_CKEN0_Msk  = 0x4   // Bit mask of CKEN0 field.
	I2S_SYNCBUSY_CKEN0      = 0x4   // Bit CKEN0.
	I2S_SYNCBUSY_CKEN1_Pos  = 0x3   // Position of CKEN1 field.
	I2S_SYNCBUSY_CKEN1_Msk  = 0x8   // Bit mask of CKEN1 field.
	I2S_SYNCBUSY_CKEN1      = 0x8   // Bit CKEN1.
	I2S_SYNCBUSY_SEREN0_Pos = 0x4   // Position of SEREN0 field.
	I2S_SYNCBUSY_SEREN0_Msk = 0x10  // Bit mask of SEREN0 field.
	I2S_SYNCBUSY_SEREN0     = 0x10  // Bit SEREN0.
	I2S_SYNCBUSY_SEREN1_Pos = 0x5   // Position of SEREN1 field.
	I2S_SYNCBUSY_SEREN1_Msk = 0x20  // Bit mask of SEREN1 field.
	I2S_SYNCBUSY_SEREN1     = 0x20  // Bit SEREN1.
	I2S_SYNCBUSY_DATA0_Pos  = 0x8   // Position of DATA0 field.
	I2S_SYNCBUSY_DATA0_Msk  = 0x100 // Bit mask of DATA0 field.
	I2S_SYNCBUSY_DATA0      = 0x100 // Bit DATA0.
	I2S_SYNCBUSY_DATA1_Pos  = 0x9   // Position of DATA1 field.
	I2S_SYNCBUSY_DATA1_Msk  = 0x200 // Bit mask of DATA1 field.
	I2S_SYNCBUSY_DATA1      = 0x200 // Bit DATA1.

	// SERCTRL0: Serializer n Control
	I2S_SERCTRL_SERMODE_Pos    = 0x0       // Position of SERMODE field.
	I2S_SERCTRL_SERMODE_Msk    = 0x3       // Bit mask of SERMODE field.
	I2S_SERCTRL_SERMODE_RX     = 0x0       // Receive
	I2S_SERCTRL_SERMODE_TX     = 0x1       // Transmit
	I2S_SERCTRL_SERMODE_PDM2   = 0x2       // Receive one PDM data on each serial clock edge
	I2S_SERCTRL_TXDEFAULT_Pos  = 0x2       // Position of TXDEFAULT field.
	I2S_SERCTRL_TXDEFAULT_Msk  = 0xc       // Bit mask of TXDEFAULT field.
	I2S_SERCTRL_TXDEFAULT_ZERO = 0x0       // Output Default Value is 0
	I2S_SERCTRL_TXDEFAULT_ONE  = 0x1       // Output Default Value is 1
	I2S_SERCTRL_TXDEFAULT_HIZ  = 0x3       // Output Default Value is high impedance
	I2S_SERCTRL_TXSAME_Pos     = 0x4       // Position of TXSAME field.
	I2S_SERCTRL_TXSAME_Msk     = 0x10      // Bit mask of TXSAME field.
	I2S_SERCTRL_TXSAME         = 0x10      // Bit TXSAME.
	I2S_SERCTRL_TXSAME_ZERO    = 0x0       // Zero data transmitted in case of underrun
	I2S_SERCTRL_TXSAME_SAME    = 0x1       // Last data transmitted in case of underrun
	I2S_SERCTRL_CLKSEL_Pos     = 0x5       // Position of CLKSEL field.
	I2S_SERCTRL_CLKSEL_Msk     = 0x20      // Bit mask of CLKSEL field.
	I2S_SERCTRL_CLKSEL         = 0x20      // Bit CLKSEL.
	I2S_SERCTRL_CLKSEL_CLK0    = 0x0       // Use Clock Unit 0
	I2S_SERCTRL_CLKSEL_CLK1    = 0x1       // Use Clock Unit 1
	I2S_SERCTRL_SLOTADJ_Pos    = 0x7       // Position of SLOTADJ field.
	I2S_SERCTRL_SLOTADJ_Msk    = 0x80      // Bit mask of SLOTADJ field.
	I2S_SERCTRL_SLOTADJ        = 0x80      // Bit SLOTADJ.
	I2S_SERCTRL_SLOTADJ_RIGHT  = 0x0       // Data is right adjusted in slot
	I2S_SERCTRL_SLOTADJ_LEFT   = 0x1       // Data is left adjusted in slot
	I2S_SERCTRL_DATASIZE_Pos   = 0x8       // Position of DATASIZE field.
	I2S_SERCTRL_DATASIZE_Msk   = 0x700     // Bit mask of DATASIZE field.
	I2S_SERCTRL_DATASIZE_32    = 0x0       // 32 bits
	I2S_SERCTRL_DATASIZE_24    = 0x1       // 24 bits
	I2S_SERCTRL_DATASIZE_20    = 0x2       // 20 bits
	I2S_SERCTRL_DATASIZE_18    = 0x3       // 18 bits
	I2S_SERCTRL_DATASIZE_16    = 0x4       // 16 bits
	I2S_SERCTRL_DATASIZE_16C   = 0x5       // 16 bits compact stereo
	I2S_SERCTRL_DATASIZE_8     = 0x6       // 8 bits
	I2S_SERCTRL_DATASIZE_8C    = 0x7       // 8 bits compact stereo
	I2S_SERCTRL_WORDADJ_Pos    = 0xc       // Position of WORDADJ field.
	I2S_SERCTRL_WORDADJ_Msk    = 0x1000    // Bit mask of WORDADJ field.
	I2S_SERCTRL_WORDADJ        = 0x1000    // Bit WORDADJ.
	I2S_SERCTRL_WORDADJ_RIGHT  = 0x0       // Data is right adjusted in word
	I2S_SERCTRL_WORDADJ_LEFT   = 0x1       // Data is left adjusted in word
	I2S_SERCTRL_EXTEND_Pos     = 0xd       // Position of EXTEND field.
	I2S_SERCTRL_EXTEND_Msk     = 0x6000    // Bit mask of EXTEND field.
	I2S_SERCTRL_EXTEND_ZERO    = 0x0       // Extend with zeroes
	I2S_SERCTRL_EXTEND_ONE     = 0x1       // Extend with ones
	I2S_SERCTRL_EXTEND_MSBIT   = 0x2       // Extend with Most Significant Bit
	I2S_SERCTRL_EXTEND_LSBIT   = 0x3       // Extend with Least Significant Bit
	I2S_SERCTRL_BITREV_Pos     = 0xf       // Position of BITREV field.
	I2S_SERCTRL_BITREV_Msk     = 0x8000    // Bit mask of BITREV field.
	I2S_SERCTRL_BITREV         = 0x8000    // Bit BITREV.
	I2S_SERCTRL_BITREV_MSBIT   = 0x0       // Transfer Data Most Significant Bit (MSB) first (default for I2S protocol)
	I2S_SERCTRL_BITREV_LSBIT   = 0x1       // Transfer Data Least Significant Bit (LSB) first
	I2S_SERCTRL_SLOTDIS0_Pos   = 0x10      // Position of SLOTDIS0 field.
	I2S_SERCTRL_SLOTDIS0_Msk   = 0x10000   // Bit mask of SLOTDIS0 field.
	I2S_SERCTRL_SLOTDIS0       = 0x10000   // Bit SLOTDIS0.
	I2S_SERCTRL_SLOTDIS1_Pos   = 0x11      // Position of SLOTDIS1 field.
	I2S_SERCTRL_SLOTDIS1_Msk   = 0x20000   // Bit mask of SLOTDIS1 field.
	I2S_SERCTRL_SLOTDIS1       = 0x20000   // Bit SLOTDIS1.
	I2S_SERCTRL_SLOTDIS2_Pos   = 0x12      // Position of SLOTDIS2 field.
	I2S_SERCTRL_SLOTDIS2_Msk   = 0x40000   // Bit mask of SLOTDIS2 field.
	I2S_SERCTRL_SLOTDIS2       = 0x40000   // Bit SLOTDIS2.
	I2S_SERCTRL_SLOTDIS3_Pos   = 0x13      // Position of SLOTDIS3 field.
	I2S_SERCTRL_SLOTDIS3_Msk   = 0x80000   // Bit mask of SLOTDIS3 field.
	I2S_SERCTRL_SLOTDIS3       = 0x80000   // Bit SLOTDIS3.
	I2S_SERCTRL_SLOTDIS4_Pos   = 0x14      // Position of SLOTDIS4 field.
	I2S_SERCTRL_SLOTDIS4_Msk   = 0x100000  // Bit mask of SLOTDIS4 field.
	I2S_SERCTRL_SLOTDIS4       = 0x100000  // Bit SLOTDIS4.
	I2S_SERCTRL_SLOTDIS5_Pos   = 0x15      // Position of SLOTDIS5 field.
	I2S_SERCTRL_SLOTDIS5_Msk   = 0x200000  // Bit mask of SLOTDIS5 field.
	I2S_SERCTRL_SLOTDIS5       = 0x200000  // Bit SLOTDIS5.
	I2S_SERCTRL_SLOTDIS6_Pos   = 0x16      // Position of SLOTDIS6 field.
	I2S_SERCTRL_SLOTDIS6_Msk   = 0x400000  // Bit mask of SLOTDIS6 field.
	I2S_SERCTRL_SLOTDIS6       = 0x400000  // Bit SLOTDIS6.
	I2S_SERCTRL_SLOTDIS7_Pos   = 0x17      // Position of SLOTDIS7 field.
	I2S_SERCTRL_SLOTDIS7_Msk   = 0x800000  // Bit mask of SLOTDIS7 field.
	I2S_SERCTRL_SLOTDIS7       = 0x800000  // Bit SLOTDIS7.
	I2S_SERCTRL_MONO_Pos       = 0x18      // Position of MONO field.
	I2S_SERCTRL_MONO_Msk       = 0x1000000 // Bit mask of MONO field.
	I2S_SERCTRL_MONO           = 0x1000000 // Bit MONO.
	I2S_SERCTRL_MONO_STEREO    = 0x0       // Normal mode
	I2S_SERCTRL_MONO_MONO      = 0x1       // Left channel data is duplicated to right channel
	I2S_SERCTRL_DMA_Pos        = 0x19      // Position of DMA field.
	I2S_SERCTRL_DMA_Msk        = 0x2000000 // Bit mask of DMA field.
	I2S_SERCTRL_DMA            = 0x2000000 // Bit DMA.
	I2S_SERCTRL_DMA_SINGLE     = 0x0       // Single DMA channel
	I2S_SERCTRL_DMA_MULTIPLE   = 0x1       // One DMA channel per data channel
	I2S_SERCTRL_RXLOOP_Pos     = 0x1a      // Position of RXLOOP field.
	I2S_SERCTRL_RXLOOP_Msk     = 0x4000000 // Bit mask of RXLOOP field.
	I2S_SERCTRL_RXLOOP         = 0x4000000 // Bit RXLOOP.

	// DATA0: Data n
	I2S_DATA_DATA_Pos = 0x0        // Position of DATA field.
	I2S_DATA_DATA_Msk = 0xffffffff // Bit mask of DATA field.
)

// Bitfields for MTB: Cortex-M0+ Micro-Trace Buffer
const (
	// POSITION: MTB Position
	MTB_POSITION_WRAP_Pos    = 0x2        // Position of WRAP field.
	MTB_POSITION_WRAP_Msk    = 0x4        // Bit mask of WRAP field.
	MTB_POSITION_WRAP        = 0x4        // Bit WRAP.
	MTB_POSITION_POINTER_Pos = 0x3        // Position of POINTER field.
	MTB_POSITION_POINTER_Msk = 0xfffffff8 // Bit mask of POINTER field.

	// MASTER: MTB Master
	MTB_MASTER_MASK_Pos     = 0x0        // Position of MASK field.
	MTB_MASTER_MASK_Msk     = 0x1f       // Bit mask of MASK field.
	MTB_MASTER_TSTARTEN_Pos = 0x5        // Position of TSTARTEN field.
	MTB_MASTER_TSTARTEN_Msk = 0x20       // Bit mask of TSTARTEN field.
	MTB_MASTER_TSTARTEN     = 0x20       // Bit TSTARTEN.
	MTB_MASTER_TSTOPEN_Pos  = 0x6        // Position of TSTOPEN field.
	MTB_MASTER_TSTOPEN_Msk  = 0x40       // Bit mask of TSTOPEN field.
	MTB_MASTER_TSTOPEN      = 0x40       // Bit TSTOPEN.
	MTB_MASTER_SFRWPRIV_Pos = 0x7        // Position of SFRWPRIV field.
	MTB_MASTER_SFRWPRIV_Msk = 0x80       // Bit mask of SFRWPRIV field.
	MTB_MASTER_SFRWPRIV     = 0x80       // Bit SFRWPRIV.
	MTB_MASTER_RAMPRIV_Pos  = 0x8        // Position of RAMPRIV field.
	MTB_MASTER_RAMPRIV_Msk  = 0x100      // Bit mask of RAMPRIV field.
	MTB_MASTER_RAMPRIV      = 0x100      // Bit RAMPRIV.
	MTB_MASTER_HALTREQ_Pos  = 0x9        // Position of HALTREQ field.
	MTB_MASTER_HALTREQ_Msk  = 0x200      // Bit mask of HALTREQ field.
	MTB_MASTER_HALTREQ      = 0x200      // Bit HALTREQ.
	MTB_MASTER_EN_Pos       = 0x1f       // Position of EN field.
	MTB_MASTER_EN_Msk       = 0x80000000 // Bit mask of EN field.
	MTB_MASTER_EN           = 0x80000000 // Bit EN.

	// FLOW: MTB Flow
	MTB_FLOW_AUTOSTOP_Pos  = 0x0        // Position of AUTOSTOP field.
	MTB_FLOW_AUTOSTOP_Msk  = 0x1        // Bit mask of AUTOSTOP field.
	MTB_FLOW_AUTOSTOP      = 0x1        // Bit AUTOSTOP.
	MTB_FLOW_AUTOHALT_Pos  = 0x1        // Position of AUTOHALT field.
	MTB_FLOW_AUTOHALT_Msk  = 0x2        // Bit mask of AUTOHALT field.
	MTB_FLOW_AUTOHALT      = 0x2        // Bit AUTOHALT.
	MTB_FLOW_WATERMARK_Pos = 0x3        // Position of WATERMARK field.
	MTB_FLOW_WATERMARK_Msk = 0xfffffff8 // Bit mask of WATERMARK field.
)

// Bitfields for NVMCTRL: Non-Volatile Memory Controller
const (
	// CTRLA: Control A
	NVMCTRL_CTRLA_CMD_Pos     = 0x0    // Position of CMD field.
	NVMCTRL_CTRLA_CMD_Msk     = 0x7f   // Bit mask of CMD field.
	NVMCTRL_CTRLA_CMD_ER      = 0x2    // Erase Row - Erases the row addressed by the ADDR register.
	NVMCTRL_CTRLA_CMD_WP      = 0x4    // Write Page - Writes the contents of the page buffer to the page addressed by the ADDR register.
	NVMCTRL_CTRLA_CMD_EAR     = 0x5    // Erase Auxiliary Row - Erases the auxiliary row addressed by the ADDR register. This command can be given only when the security bit is not set and only to the user configuration row.
	NVMCTRL_CTRLA_CMD_WAP     = 0x6    // Write Auxiliary Page - Writes the contents of the page buffer to the page addressed by the ADDR register. This command can be given only when the security bit is not set and only to the user configuration row.
	NVMCTRL_CTRLA_CMD_SF      = 0xa    // Security Flow Command
	NVMCTRL_CTRLA_CMD_WL      = 0xf    // Write lockbits
	NVMCTRL_CTRLA_CMD_RWWEEER = 0x1a   // RWW EEPROM area Erase Row - Erases the row addressed by the ADDR register.
	NVMCTRL_CTRLA_CMD_RWWEEWP = 0x1c   // RWW EEPROM Write Page - Writes the contents of the page buffer to the page addressed by the ADDR register.
	NVMCTRL_CTRLA_CMD_LR      = 0x40   // Lock Region - Locks the region containing the address location in the ADDR register.
	NVMCTRL_CTRLA_CMD_UR      = 0x41   // Unlock Region - Unlocks the region containing the address location in the ADDR register.
	NVMCTRL_CTRLA_CMD_SPRM    = 0x42   // Sets the power reduction mode.
	NVMCTRL_CTRLA_CMD_CPRM    = 0x43   // Clears the power reduction mode.
	NVMCTRL_CTRLA_CMD_PBC     = 0x44   // Page Buffer Clear - Clears the page buffer.
	NVMCTRL_CTRLA_CMD_SSB     = 0x45   // Set Security Bit - Sets the security bit by writing 0x00 to the first byte in the lockbit row.
	NVMCTRL_CTRLA_CMD_INVALL  = 0x46   // Invalidate all cache lines.
	NVMCTRL_CTRLA_CMDEX_Pos   = 0x8    // Position of CMDEX field.
	NVMCTRL_CTRLA_CMDEX_Msk   = 0xff00 // Bit mask of CMDEX field.
	NVMCTRL_CTRLA_CMDEX_KEY   = 0xa5   // Execution Key

	// CTRLB: Control B
	NVMCTRL_CTRLB_RWS_Pos                  = 0x1     // Position of RWS field.
	NVMCTRL_CTRLB_RWS_Msk                  = 0x1e    // Bit mask of RWS field.
	NVMCTRL_CTRLB_RWS_SINGLE               = 0x0     // Single Auto Wait State
	NVMCTRL_CTRLB_RWS_HALF                 = 0x1     // Half Auto Wait State
	NVMCTRL_CTRLB_RWS_DUAL                 = 0x2     // Dual Auto Wait State
	NVMCTRL_CTRLB_MANW_Pos                 = 0x7     // Position of MANW field.
	NVMCTRL_CTRLB_MANW_Msk                 = 0x80    // Bit mask of MANW field.
	NVMCTRL_CTRLB_MANW                     = 0x80    // Bit MANW.
	NVMCTRL_CTRLB_SLEEPPRM_Pos             = 0x8     // Position of SLEEPPRM field.
	NVMCTRL_CTRLB_SLEEPPRM_Msk             = 0x300   // Bit mask of SLEEPPRM field.
	NVMCTRL_CTRLB_SLEEPPRM_WAKEONACCESS    = 0x0     // NVM block enters low-power mode when entering sleep.NVM block exits low-power mode upon first access.
	NVMCTRL_CTRLB_SLEEPPRM_WAKEUPINSTANT   = 0x1     // NVM block enters low-power mode when entering sleep.NVM block exits low-power mode when exiting sleep.
	NVMCTRL_CTRLB_SLEEPPRM_DISABLED        = 0x3     // Auto power reduction disabled.
	NVMCTRL_CTRLB_READMODE_Pos             = 0x10    // Position of READMODE field.
	NVMCTRL_CTRLB_READMODE_Msk             = 0x30000 // Bit mask of READMODE field.
	NVMCTRL_CTRLB_READMODE_NO_MISS_PENALTY = 0x0     // The NVM Controller (cache system) does not insert wait states on a cache miss. Gives the best system performance.
	NVMCTRL_CTRLB_READMODE_LOW_POWER       = 0x1     // Reduces power consumption of the cache system, but inserts a wait state each time there is a cache miss. This mode may not be relevant if CPU performance is required, as the application will be stalled and may lead to increase run time.
	NVMCTRL_CTRLB_READMODE_DETERMINISTIC   = 0x2     // The cache system ensures that a cache hit or miss takes the same amount of time, determined by the number of programmed flash wait states. This mode can be used for real-time applications that require deterministic execution timings.
	NVMCTRL_CTRLB_CACHEDIS_Pos             = 0x12    // Position of CACHEDIS field.
	NVMCTRL_CTRLB_CACHEDIS_Msk             = 0x40000 // Bit mask of CACHEDIS field.
	NVMCTRL_CTRLB_CACHEDIS                 = 0x40000 // Bit CACHEDIS.

	// PARAM: NVM Parameter
	NVMCTRL_PARAM_NVMP_Pos   = 0x0        // Position of NVMP field.
	NVMCTRL_PARAM_NVMP_Msk   = 0xffff     // Bit mask of NVMP field.
	NVMCTRL_PARAM_PSZ_Pos    = 0x10       // Position of PSZ field.
	NVMCTRL_PARAM_PSZ_Msk    = 0x70000    // Bit mask of PSZ field.
	NVMCTRL_PARAM_PSZ_8      = 0x0        // 8 bytes
	NVMCTRL_PARAM_PSZ_16     = 0x1        // 16 bytes
	NVMCTRL_PARAM_PSZ_32     = 0x2        // 32 bytes
	NVMCTRL_PARAM_PSZ_64     = 0x3        // 64 bytes
	NVMCTRL_PARAM_PSZ_128    = 0x4        // 128 bytes
	NVMCTRL_PARAM_PSZ_256    = 0x5        // 256 bytes
	NVMCTRL_PARAM_PSZ_512    = 0x6        // 512 bytes
	NVMCTRL_PARAM_PSZ_1024   = 0x7        // 1024 bytes
	NVMCTRL_PARAM_RWWEEP_Pos = 0x14       // Position of RWWEEP field.
	NVMCTRL_PARAM_RWWEEP_Msk = 0xfff00000 // Bit mask of RWWEEP field.

	// INTENCLR: Interrupt Enable Clear
	NVMCTRL_INTENCLR_READY_Pos = 0x0 // Position of READY field.
	NVMCTRL_INTENCLR_READY_Msk = 0x1 // Bit mask of READY field.
	NVMCTRL_INTENCLR_READY     = 0x1 // Bit READY.
	NVMCTRL_INTENCLR_ERROR_Pos = 0x1 // Position of ERROR field.
	NVMCTRL_INTENCLR_ERROR_Msk = 0x2 // Bit mask of ERROR field.
	NVMCTRL_INTENCLR_ERROR     = 0x2 // Bit ERROR.

	// INTENSET: Interrupt Enable Set
	NVMCTRL_INTENSET_READY_Pos = 0x0 // Position of READY field.
	NVMCTRL_INTENSET_READY_Msk = 0x1 // Bit mask of READY field.
	NVMCTRL_INTENSET_READY     = 0x1 // Bit READY.
	NVMCTRL_INTENSET_ERROR_Pos = 0x1 // Position of ERROR field.
	NVMCTRL_INTENSET_ERROR_Msk = 0x2 // Bit mask of ERROR field.
	NVMCTRL_INTENSET_ERROR     = 0x2 // Bit ERROR.

	// INTFLAG: Interrupt Flag Status and Clear
	NVMCTRL_INTFLAG_READY_Pos = 0x0 // Position of READY field.
	NVMCTRL_INTFLAG_READY_Msk = 0x1 // Bit mask of READY field.
	NVMCTRL_INTFLAG_READY     = 0x1 // Bit READY.
	NVMCTRL_INTFLAG_ERROR_Pos = 0x1 // Position of ERROR field.
	NVMCTRL_INTFLAG_ERROR_Msk = 0x2 // Bit mask of ERROR field.
	NVMCTRL_INTFLAG_ERROR     = 0x2 // Bit ERROR.

	// STATUS: Status
	NVMCTRL_STATUS_PRM_Pos   = 0x0   // Position of PRM field.
	NVMCTRL_STATUS_PRM_Msk   = 0x1   // Bit mask of PRM field.
	NVMCTRL_STATUS_PRM       = 0x1   // Bit PRM.
	NVMCTRL_STATUS_LOAD_Pos  = 0x1   // Position of LOAD field.
	NVMCTRL_STATUS_LOAD_Msk  = 0x2   // Bit mask of LOAD field.
	NVMCTRL_STATUS_LOAD      = 0x2   // Bit LOAD.
	NVMCTRL_STATUS_PROGE_Pos = 0x2   // Position of PROGE field.
	NVMCTRL_STATUS_PROGE_Msk = 0x4   // Bit mask of PROGE field.
	NVMCTRL_STATUS_PROGE     = 0x4   // Bit PROGE.
	NVMCTRL_STATUS_LOCKE_Pos = 0x3   // Position of LOCKE field.
	NVMCTRL_STATUS_LOCKE_Msk = 0x8   // Bit mask of LOCKE field.
	NVMCTRL_STATUS_LOCKE     = 0x8   // Bit LOCKE.
	NVMCTRL_STATUS_NVME_Pos  = 0x4   // Position of NVME field.
	NVMCTRL_STATUS_NVME_Msk  = 0x10  // Bit mask of NVME field.
	NVMCTRL_STATUS_NVME      = 0x10  // Bit NVME.
	NVMCTRL_STATUS_SB_Pos    = 0x8   // Position of SB field.
	NVMCTRL_STATUS_SB_Msk    = 0x100 // Bit mask of SB field.
	NVMCTRL_STATUS_SB        = 0x100 // Bit SB.

	// ADDR: Address
	NVMCTRL_ADDR_ADDR_Pos = 0x0      // Position of ADDR field.
	NVMCTRL_ADDR_ADDR_Msk = 0x3fffff // Bit mask of ADDR field.

	// LOCK: Lock Section
	NVMCTRL_LOCK_LOCK_Pos = 0x0    // Position of LOCK field.
	NVMCTRL_LOCK_LOCK_Msk = 0xffff // Bit mask of LOCK field.
)

// Bitfields for PAC0: Peripheral Access Controller 0
const (
	// WPCLR: Write Protection Clear
	PAC_WPCLR_WP_Pos = 0x1        // Position of WP field.
	PAC_WPCLR_WP_Msk = 0xfffffffe // Bit mask of WP field.

	// WPSET: Write Protection Set
	PAC_WPSET_WP_Pos = 0x1        // Position of WP field.
	PAC_WPSET_WP_Msk = 0xfffffffe // Bit mask of WP field.
)

// Bitfields for PM: Power Manager
const (
	// SLEEP: Sleep Mode
	PM_SLEEP_IDLE_Pos = 0x0 // Position of IDLE field.
	PM_SLEEP_IDLE_Msk = 0x3 // Bit mask of IDLE field.
	PM_SLEEP_IDLE_CPU = 0x0 // The CPU clock domain is stopped
	PM_SLEEP_IDLE_AHB = 0x1 // The CPU and AHB clock domains are stopped
	PM_SLEEP_IDLE_APB = 0x2 // The CPU, AHB and APB clock domains are stopped

	// EXTCTRL: External Reset Controller
	PM_EXTCTRL_SETDIS_Pos = 0x0 // Position of SETDIS field.
	PM_EXTCTRL_SETDIS_Msk = 0x1 // Bit mask of SETDIS field.
	PM_EXTCTRL_SETDIS     = 0x1 // Bit SETDIS.

	// CPUSEL: CPU Clock Select
	PM_CPUSEL_CPUDIV_Pos    = 0x0 // Position of CPUDIV field.
	PM_CPUSEL_CPUDIV_Msk    = 0x7 // Bit mask of CPUDIV field.
	PM_CPUSEL_CPUDIV_DIV1   = 0x0 // Divide by 1
	PM_CPUSEL_CPUDIV_DIV2   = 0x1 // Divide by 2
	PM_CPUSEL_CPUDIV_DIV4   = 0x2 // Divide by 4
	PM_CPUSEL_CPUDIV_DIV8   = 0x3 // Divide by 8
	PM_CPUSEL_CPUDIV_DIV16  = 0x4 // Divide by 16
	PM_CPUSEL_CPUDIV_DIV32  = 0x5 // Divide by 32
	PM_CPUSEL_CPUDIV_DIV64  = 0x6 // Divide by 64
	PM_CPUSEL_CPUDIV_DIV128 = 0x7 // Divide by 128

	// APBASEL: APBA Clock Select
	PM_APBASEL_APBADIV_Pos    = 0x0 // Position of APBADIV field.
	PM_APBASEL_APBADIV_Msk    = 0x7 // Bit mask of APBADIV field.
	PM_APBASEL_APBADIV_DIV1   = 0x0 // Divide by 1
	PM_APBASEL_APBADIV_DIV2   = 0x1 // Divide by 2
	PM_APBASEL_APBADIV_DIV4   = 0x2 // Divide by 4
	PM_APBASEL_APBADIV_DIV8   = 0x3 // Divide by 8
	PM_APBASEL_APBADIV_DIV16  = 0x4 // Divide by 16
	PM_APBASEL_APBADIV_DIV32  = 0x5 // Divide by 32
	PM_APBASEL_APBADIV_DIV64  = 0x6 // Divide by 64
	PM_APBASEL_APBADIV_DIV128 = 0x7 // Divide by 128

	// APBBSEL: APBB Clock Select
	PM_APBBSEL_APBBDIV_Pos    = 0x0 // Position of APBBDIV field.
	PM_APBBSEL_APBBDIV_Msk    = 0x7 // Bit mask of APBBDIV field.
	PM_APBBSEL_APBBDIV_DIV1   = 0x0 // Divide by 1
	PM_APBBSEL_APBBDIV_DIV2   = 0x1 // Divide by 2
	PM_APBBSEL_APBBDIV_DIV4   = 0x2 // Divide by 4
	PM_APBBSEL_APBBDIV_DIV8   = 0x3 // Divide by 8
	PM_APBBSEL_APBBDIV_DIV16  = 0x4 // Divide by 16
	PM_APBBSEL_APBBDIV_DIV32  = 0x5 // Divide by 32
	PM_APBBSEL_APBBDIV_DIV64  = 0x6 // Divide by 64
	PM_APBBSEL_APBBDIV_DIV128 = 0x7 // Divide by 128

	// APBCSEL: APBC Clock Select
	PM_APBCSEL_APBCDIV_Pos    = 0x0 // Position of APBCDIV field.
	PM_APBCSEL_APBCDIV_Msk    = 0x7 // Bit mask of APBCDIV field.
	PM_APBCSEL_APBCDIV_DIV1   = 0x0 // Divide by 1
	PM_APBCSEL_APBCDIV_DIV2   = 0x1 // Divide by 2
	PM_APBCSEL_APBCDIV_DIV4   = 0x2 // Divide by 4
	PM_APBCSEL_APBCDIV_DIV8   = 0x3 // Divide by 8
	PM_APBCSEL_APBCDIV_DIV16  = 0x4 // Divide by 16
	PM_APBCSEL_APBCDIV_DIV32  = 0x5 // Divide by 32
	PM_APBCSEL_APBCDIV_DIV64  = 0x6 // Divide by 64
	PM_APBCSEL_APBCDIV_DIV128 = 0x7 // Divide by 128

	// AHBMASK: AHB Mask
	PM_AHBMASK_HPB0__Pos    = 0x0  // Position of HPB0_ field.
	PM_AHBMASK_HPB0__Msk    = 0x1  // Bit mask of HPB0_ field.
	PM_AHBMASK_HPB0_        = 0x1  // Bit HPB0_.
	PM_AHBMASK_HPB1__Pos    = 0x1  // Position of HPB1_ field.
	PM_AHBMASK_HPB1__Msk    = 0x2  // Bit mask of HPB1_ field.
	PM_AHBMASK_HPB1_        = 0x2  // Bit HPB1_.
	PM_AHBMASK_HPB2__Pos    = 0x2  // Position of HPB2_ field.
	PM_AHBMASK_HPB2__Msk    = 0x4  // Bit mask of HPB2_ field.
	PM_AHBMASK_HPB2_        = 0x4  // Bit HPB2_.
	PM_AHBMASK_DSU__Pos     = 0x3  // Position of DSU_ field.
	PM_AHBMASK_DSU__Msk     = 0x8  // Bit mask of DSU_ field.
	PM_AHBMASK_DSU_         = 0x8  // Bit DSU_.
	PM_AHBMASK_NVMCTRL__Pos = 0x4  // Position of NVMCTRL_ field.
	PM_AHBMASK_NVMCTRL__Msk = 0x10 // Bit mask of NVMCTRL_ field.
	PM_AHBMASK_NVMCTRL_     = 0x10 // Bit NVMCTRL_.
	PM_AHBMASK_DMAC__Pos    = 0x5  // Position of DMAC_ field.
	PM_AHBMASK_DMAC__Msk    = 0x20 // Bit mask of DMAC_ field.
	PM_AHBMASK_DMAC_        = 0x20 // Bit DMAC_.
	PM_AHBMASK_USB__Pos     = 0x6  // Position of USB_ field.
	PM_AHBMASK_USB__Msk     = 0x40 // Bit mask of USB_ field.
	PM_AHBMASK_USB_         = 0x40 // Bit USB_.

	// APBAMASK: APBA Mask
	PM_APBAMASK_PAC0__Pos    = 0x0  // Position of PAC0_ field.
	PM_APBAMASK_PAC0__Msk    = 0x1  // Bit mask of PAC0_ field.
	PM_APBAMASK_PAC0_        = 0x1  // Bit PAC0_.
	PM_APBAMASK_PM__Pos      = 0x1  // Position of PM_ field.
	PM_APBAMASK_PM__Msk      = 0x2  // Bit mask of PM_ field.
	PM_APBAMASK_PM_          = 0x2  // Bit PM_.
	PM_APBAMASK_SYSCTRL__Pos = 0x2  // Position of SYSCTRL_ field.
	PM_APBAMASK_SYSCTRL__Msk = 0x4  // Bit mask of SYSCTRL_ field.
	PM_APBAMASK_SYSCTRL_     = 0x4  // Bit SYSCTRL_.
	PM_APBAMASK_GCLK__Pos    = 0x3  // Position of GCLK_ field.
	PM_APBAMASK_GCLK__Msk    = 0x8  // Bit mask of GCLK_ field.
	PM_APBAMASK_GCLK_        = 0x8  // Bit GCLK_.
	PM_APBAMASK_WDT__Pos     = 0x4  // Position of WDT_ field.
	PM_APBAMASK_WDT__Msk     = 0x10 // Bit mask of WDT_ field.
	PM_APBAMASK_WDT_         = 0x10 // Bit WDT_.
	PM_APBAMASK_RTC__Pos     = 0x5  // Position of RTC_ field.
	PM_APBAMASK_RTC__Msk     = 0x20 // Bit mask of RTC_ field.
	PM_APBAMASK_RTC_         = 0x20 // Bit RTC_.
	PM_APBAMASK_EIC__Pos     = 0x6  // Position of EIC_ field.
	PM_APBAMASK_EIC__Msk     = 0x40 // Bit mask of EIC_ field.
	PM_APBAMASK_EIC_         = 0x40 // Bit EIC_.

	// APBBMASK: APBB Mask
	PM_APBBMASK_PAC1__Pos    = 0x0  // Position of PAC1_ field.
	PM_APBBMASK_PAC1__Msk    = 0x1  // Bit mask of PAC1_ field.
	PM_APBBMASK_PAC1_        = 0x1  // Bit PAC1_.
	PM_APBBMASK_DSU__Pos     = 0x1  // Position of DSU_ field.
	PM_APBBMASK_DSU__Msk     = 0x2  // Bit mask of DSU_ field.
	PM_APBBMASK_DSU_         = 0x2  // Bit DSU_.
	PM_APBBMASK_NVMCTRL__Pos = 0x2  // Position of NVMCTRL_ field.
	PM_APBBMASK_NVMCTRL__Msk = 0x4  // Bit mask of NVMCTRL_ field.
	PM_APBBMASK_NVMCTRL_     = 0x4  // Bit NVMCTRL_.
	PM_APBBMASK_PORT__Pos    = 0x3  // Position of PORT_ field.
	PM_APBBMASK_PORT__Msk    = 0x8  // Bit mask of PORT_ field.
	PM_APBBMASK_PORT_        = 0x8  // Bit PORT_.
	PM_APBBMASK_DMAC__Pos    = 0x4  // Position of DMAC_ field.
	PM_APBBMASK_DMAC__Msk    = 0x10 // Bit mask of DMAC_ field.
	PM_APBBMASK_DMAC_        = 0x10 // Bit DMAC_.
	PM_APBBMASK_USB__Pos     = 0x5  // Position of USB_ field.
	PM_APBBMASK_USB__Msk     = 0x20 // Bit mask of USB_ field.
	PM_APBBMASK_USB_         = 0x20 // Bit USB_.
	PM_APBBMASK_HMATRIX__Pos = 0x6  // Position of HMATRIX_ field.
	PM_APBBMASK_HMATRIX__Msk = 0x40 // Bit mask of HMATRIX_ field.
	PM_APBBMASK_HMATRIX_     = 0x40 // Bit HMATRIX_.

	// APBCMASK: APBC Mask
	PM_APBCMASK_PAC2__Pos    = 0x0      // Position of PAC2_ field.
	PM_APBCMASK_PAC2__Msk    = 0x1      // Bit mask of PAC2_ field.
	PM_APBCMASK_PAC2_        = 0x1      // Bit PAC2_.
	PM_APBCMASK_EVSYS__Pos   = 0x1      // Position of EVSYS_ field.
	PM_APBCMASK_EVSYS__Msk   = 0x2      // Bit mask of EVSYS_ field.
	PM_APBCMASK_EVSYS_       = 0x2      // Bit EVSYS_.
	PM_APBCMASK_SERCOM0__Pos = 0x2      // Position of SERCOM0_ field.
	PM_APBCMASK_SERCOM0__Msk = 0x4      // Bit mask of SERCOM0_ field.
	PM_APBCMASK_SERCOM0_     = 0x4      // Bit SERCOM0_.
	PM_APBCMASK_SERCOM1__Pos = 0x3      // Position of SERCOM1_ field.
	PM_APBCMASK_SERCOM1__Msk = 0x8      // Bit mask of SERCOM1_ field.
	PM_APBCMASK_SERCOM1_     = 0x8      // Bit SERCOM1_.
	PM_APBCMASK_SERCOM2__Pos = 0x4      // Position of SERCOM2_ field.
	PM_APBCMASK_SERCOM2__Msk = 0x10     // Bit mask of SERCOM2_ field.
	PM_APBCMASK_SERCOM2_     = 0x10     // Bit SERCOM2_.
	PM_APBCMASK_SERCOM3__Pos = 0x5      // Position of SERCOM3_ field.
	PM_APBCMASK_SERCOM3__Msk = 0x20     // Bit mask of SERCOM3_ field.
	PM_APBCMASK_SERCOM3_     = 0x20     // Bit SERCOM3_.
	PM_APBCMASK_TCC0__Pos    = 0x8      // Position of TCC0_ field.
	PM_APBCMASK_TCC0__Msk    = 0x100    // Bit mask of TCC0_ field.
	PM_APBCMASK_TCC0_        = 0x100    // Bit TCC0_.
	PM_APBCMASK_TCC1__Pos    = 0x9      // Position of TCC1_ field.
	PM_APBCMASK_TCC1__Msk    = 0x200    // Bit mask of TCC1_ field.
	PM_APBCMASK_TCC1_        = 0x200    // Bit TCC1_.
	PM_APBCMASK_TCC2__Pos    = 0xa      // Position of TCC2_ field.
	PM_APBCMASK_TCC2__Msk    = 0x400    // Bit mask of TCC2_ field.
	PM_APBCMASK_TCC2_        = 0x400    // Bit TCC2_.
	PM_APBCMASK_TC3__Pos     = 0xb      // Position of TC3_ field.
	PM_APBCMASK_TC3__Msk     = 0x800    // Bit mask of TC3_ field.
	PM_APBCMASK_TC3_         = 0x800    // Bit TC3_.
	PM_APBCMASK_TC4__Pos     = 0xc      // Position of TC4_ field.
	PM_APBCMASK_TC4__Msk     = 0x1000   // Bit mask of TC4_ field.
	PM_APBCMASK_TC4_         = 0x1000   // Bit TC4_.
	PM_APBCMASK_TC5__Pos     = 0xd      // Position of TC5_ field.
	PM_APBCMASK_TC5__Msk     = 0x2000   // Bit mask of TC5_ field.
	PM_APBCMASK_TC5_         = 0x2000   // Bit TC5_.
	PM_APBCMASK_ADC__Pos     = 0x10     // Position of ADC_ field.
	PM_APBCMASK_ADC__Msk     = 0x10000  // Bit mask of ADC_ field.
	PM_APBCMASK_ADC_         = 0x10000  // Bit ADC_.
	PM_APBCMASK_AC__Pos      = 0x11     // Position of AC_ field.
	PM_APBCMASK_AC__Msk      = 0x20000  // Bit mask of AC_ field.
	PM_APBCMASK_AC_          = 0x20000  // Bit AC_.
	PM_APBCMASK_DAC__Pos     = 0x12     // Position of DAC_ field.
	PM_APBCMASK_DAC__Msk     = 0x40000  // Bit mask of DAC_ field.
	PM_APBCMASK_DAC_         = 0x40000  // Bit DAC_.
	PM_APBCMASK_PTC__Pos     = 0x13     // Position of PTC_ field.
	PM_APBCMASK_PTC__Msk     = 0x80000  // Bit mask of PTC_ field.
	PM_APBCMASK_PTC_         = 0x80000  // Bit PTC_.
	PM_APBCMASK_I2S__Pos     = 0x14     // Position of I2S_ field.
	PM_APBCMASK_I2S__Msk     = 0x100000 // Bit mask of I2S_ field.
	PM_APBCMASK_I2S_         = 0x100000 // Bit I2S_.

	// INTENCLR: Interrupt Enable Clear
	PM_INTENCLR_CKRDY_Pos = 0x0 // Position of CKRDY field.
	PM_INTENCLR_CKRDY_Msk = 0x1 // Bit mask of CKRDY field.
	PM_INTENCLR_CKRDY     = 0x1 // Bit CKRDY.

	// INTENSET: Interrupt Enable Set
	PM_INTENSET_CKRDY_Pos = 0x0 // Position of CKRDY field.
	PM_INTENSET_CKRDY_Msk = 0x1 // Bit mask of CKRDY field.
	PM_INTENSET_CKRDY     = 0x1 // Bit CKRDY.

	// INTFLAG: Interrupt Flag Status and Clear
	PM_INTFLAG_CKRDY_Pos = 0x0 // Position of CKRDY field.
	PM_INTFLAG_CKRDY_Msk = 0x1 // Bit mask of CKRDY field.
	PM_INTFLAG_CKRDY     = 0x1 // Bit CKRDY.

	// RCAUSE: Reset Cause
	PM_RCAUSE_POR_Pos   = 0x0  // Position of POR field.
	PM_RCAUSE_POR_Msk   = 0x1  // Bit mask of POR field.
	PM_RCAUSE_POR       = 0x1  // Bit POR.
	PM_RCAUSE_BOD12_Pos = 0x1  // Position of BOD12 field.
	PM_RCAUSE_BOD12_Msk = 0x2  // Bit mask of BOD12 field.
	PM_RCAUSE_BOD12     = 0x2  // Bit BOD12.
	PM_RCAUSE_BOD33_Pos = 0x2  // Position of BOD33 field.
	PM_RCAUSE_BOD33_Msk = 0x4  // Bit mask of BOD33 field.
	PM_RCAUSE_BOD33     = 0x4  // Bit BOD33.
	PM_RCAUSE_EXT_Pos   = 0x4  // Position of EXT field.
	PM_RCAUSE_EXT_Msk   = 0x10 // Bit mask of EXT field.
	PM_RCAUSE_EXT       = 0x10 // Bit EXT.
	PM_RCAUSE_WDT_Pos   = 0x5  // Position of WDT field.
	PM_RCAUSE_WDT_Msk   = 0x20 // Bit mask of WDT field.
	PM_RCAUSE_WDT       = 0x20 // Bit WDT.
	PM_RCAUSE_SYST_Pos  = 0x6  // Position of SYST field.
	PM_RCAUSE_SYST_Msk  = 0x40 // Bit mask of SYST field.
	PM_RCAUSE_SYST      = 0x40 // Bit SYST.
)

// Bitfields for PORT: Port Module
const (
	// DIR0: Data Direction
	PORT_DIR_DIR_Pos = 0x0        // Position of DIR field.
	PORT_DIR_DIR_Msk = 0xffffffff // Bit mask of DIR field.

	// DIRCLR0: Data Direction Clear
	PORT_DIRCLR_DIRCLR_Pos = 0x0        // Position of DIRCLR field.
	PORT_DIRCLR_DIRCLR_Msk = 0xffffffff // Bit mask of DIRCLR field.

	// DIRSET0: Data Direction Set
	PORT_DIRSET_DIRSET_Pos = 0x0        // Position of DIRSET field.
	PORT_DIRSET_DIRSET_Msk = 0xffffffff // Bit mask of DIRSET field.

	// DIRTGL0: Data Direction Toggle
	PORT_DIRTGL_DIRTGL_Pos = 0x0        // Position of DIRTGL field.
	PORT_DIRTGL_DIRTGL_Msk = 0xffffffff // Bit mask of DIRTGL field.

	// OUT0: Data Output Value
	PORT_OUT_OUT_Pos = 0x0        // Position of OUT field.
	PORT_OUT_OUT_Msk = 0xffffffff // Bit mask of OUT field.

	// OUTCLR0: Data Output Value Clear
	PORT_OUTCLR_OUTCLR_Pos = 0x0        // Position of OUTCLR field.
	PORT_OUTCLR_OUTCLR_Msk = 0xffffffff // Bit mask of OUTCLR field.

	// OUTSET0: Data Output Value Set
	PORT_OUTSET_OUTSET_Pos = 0x0        // Position of OUTSET field.
	PORT_OUTSET_OUTSET_Msk = 0xffffffff // Bit mask of OUTSET field.

	// OUTTGL0: Data Output Value Toggle
	PORT_OUTTGL_OUTTGL_Pos = 0x0        // Position of OUTTGL field.
	PORT_OUTTGL_OUTTGL_Msk = 0xffffffff // Bit mask of OUTTGL field.

	// IN0: Data Input Value
	PORT_IN_IN_Pos = 0x0        // Position of IN field.
	PORT_IN_IN_Msk = 0xffffffff // Bit mask of IN field.

	// CTRL0: Control
	PORT_CTRL_SAMPLING_Pos = 0x0        // Position of SAMPLING field.
	PORT_CTRL_SAMPLING_Msk = 0xffffffff // Bit mask of SAMPLING field.

	// WRCONFIG0: Write Configuration
	PORT_WRCONFIG_PINMASK_Pos  = 0x0        // Position of PINMASK field.
	PORT_WRCONFIG_PINMASK_Msk  = 0xffff     // Bit mask of PINMASK field.
	PORT_WRCONFIG_PMUXEN_Pos   = 0x10       // Position of PMUXEN field.
	PORT_WRCONFIG_PMUXEN_Msk   = 0x10000    // Bit mask of PMUXEN field.
	PORT_WRCONFIG_PMUXEN       = 0x10000    // Bit PMUXEN.
	PORT_WRCONFIG_INEN_Pos     = 0x11       // Position of INEN field.
	PORT_WRCONFIG_INEN_Msk     = 0x20000    // Bit mask of INEN field.
	PORT_WRCONFIG_INEN         = 0x20000    // Bit INEN.
	PORT_WRCONFIG_PULLEN_Pos   = 0x12       // Position of PULLEN field.
	PORT_WRCONFIG_PULLEN_Msk   = 0x40000    // Bit mask of PULLEN field.
	PORT_WRCONFIG_PULLEN       = 0x40000    // Bit PULLEN.
	PORT_WRCONFIG_DRVSTR_Pos   = 0x16       // Position of DRVSTR field.
	PORT_WRCONFIG_DRVSTR_Msk   = 0x400000   // Bit mask of DRVSTR field.
	PORT_WRCONFIG_DRVSTR       = 0x400000   // Bit DRVSTR.
	PORT_WRCONFIG_PMUX_Pos     = 0x18       // Position of PMUX field.
	PORT_WRCONFIG_PMUX_Msk     = 0xf000000  // Bit mask of PMUX field.
	PORT_WRCONFIG_WRPMUX_Pos   = 0x1c       // Position of WRPMUX field.
	PORT_WRCONFIG_WRPMUX_Msk   = 0x10000000 // Bit mask of WRPMUX field.
	PORT_WRCONFIG_WRPMUX       = 0x10000000 // Bit WRPMUX.
	PORT_WRCONFIG_WRPINCFG_Pos = 0x1e       // Position of WRPINCFG field.
	PORT_WRCONFIG_WRPINCFG_Msk = 0x40000000 // Bit mask of WRPINCFG field.
	PORT_WRCONFIG_WRPINCFG     = 0x40000000 // Bit WRPINCFG.
	PORT_WRCONFIG_HWSEL_Pos    = 0x1f       // Position of HWSEL field.
	PORT_WRCONFIG_HWSEL_Msk    = 0x80000000 // Bit mask of HWSEL field.
	PORT_WRCONFIG_HWSEL        = 0x80000000 // Bit HWSEL.

	// PMUX0_0: Peripheral Multiplexing n - Group 0
	PORT_PMUX0_PMUXE_Pos = 0x0  // Position of PMUXE field.
	PORT_PMUX0_PMUXE_Msk = 0xf  // Bit mask of PMUXE field.
	PORT_PMUX0_PMUXE_A   = 0x0  // Peripheral function A selected
	PORT_PMUX0_PMUXE_B   = 0x1  // Peripheral function B selected
	PORT_PMUX0_PMUXE_C   = 0x2  // Peripheral function C selected
	PORT_PMUX0_PMUXE_D   = 0x3  // Peripheral function D selected
	PORT_PMUX0_PMUXE_E   = 0x4  // Peripheral function E selected
	PORT_PMUX0_PMUXE_F   = 0x5  // Peripheral function F selected
	PORT_PMUX0_PMUXE_G   = 0x6  // Peripheral function G selected
	PORT_PMUX0_PMUXE_H   = 0x7  // Peripheral function H selected
	PORT_PMUX0_PMUXO_Pos = 0x4  // Position of PMUXO field.
	PORT_PMUX0_PMUXO_Msk = 0xf0 // Bit mask of PMUXO field.
	PORT_PMUX0_PMUXO_A   = 0x0  // Peripheral function A selected
	PORT_PMUX0_PMUXO_B   = 0x1  // Peripheral function B selected
	PORT_PMUX0_PMUXO_C   = 0x2  // Peripheral function C selected
	PORT_PMUX0_PMUXO_D   = 0x3  // Peripheral function D selected
	PORT_PMUX0_PMUXO_E   = 0x4  // Peripheral function E selected
	PORT_PMUX0_PMUXO_F   = 0x5  // Peripheral function F selected
	PORT_PMUX0_PMUXO_G   = 0x6  // Peripheral function G selected
	PORT_PMUX0_PMUXO_H   = 0x7  // Peripheral function H selected

	// PINCFG0_0: Pin Configuration n - Group 0
	PORT_PINCFG0_PMUXEN_Pos = 0x0  // Position of PMUXEN field.
	PORT_PINCFG0_PMUXEN_Msk = 0x1  // Bit mask of PMUXEN field.
	PORT_PINCFG0_PMUXEN     = 0x1  // Bit PMUXEN.
	PORT_PINCFG0_INEN_Pos   = 0x1  // Position of INEN field.
	PORT_PINCFG0_INEN_Msk   = 0x2  // Bit mask of INEN field.
	PORT_PINCFG0_INEN       = 0x2  // Bit INEN.
	PORT_PINCFG0_PULLEN_Pos = 0x2  // Position of PULLEN field.
	PORT_PINCFG0_PULLEN_Msk = 0x4  // Bit mask of PULLEN field.
	PORT_PINCFG0_PULLEN     = 0x4  // Bit PULLEN.
	PORT_PINCFG0_DRVSTR_Pos = 0x6  // Position of DRVSTR field.
	PORT_PINCFG0_DRVSTR_Msk = 0x40 // Bit mask of DRVSTR field.
	PORT_PINCFG0_DRVSTR     = 0x40 // Bit DRVSTR.
)

// Bitfields for RTC: Real-Time Counter
const ()

// Bitfields for RTC_MODE0: Real-Time Counter - MODE0
const (
	// CTRL: MODE0 Control
	RTC_MODE0_CTRL_SWRST_Pos         = 0x0   // Position of SWRST field.
	RTC_MODE0_CTRL_SWRST_Msk         = 0x1   // Bit mask of SWRST field.
	RTC_MODE0_CTRL_SWRST             = 0x1   // Bit SWRST.
	RTC_MODE0_CTRL_ENABLE_Pos        = 0x1   // Position of ENABLE field.
	RTC_MODE0_CTRL_ENABLE_Msk        = 0x2   // Bit mask of ENABLE field.
	RTC_MODE0_CTRL_ENABLE            = 0x2   // Bit ENABLE.
	RTC_MODE0_CTRL_MODE_Pos          = 0x2   // Position of MODE field.
	RTC_MODE0_CTRL_MODE_Msk          = 0xc   // Bit mask of MODE field.
	RTC_MODE0_CTRL_MODE_COUNT32      = 0x0   // Mode 0: 32-bit Counter
	RTC_MODE0_CTRL_MODE_COUNT16      = 0x1   // Mode 1: 16-bit Counter
	RTC_MODE0_CTRL_MODE_CLOCK        = 0x2   // Mode 2: Clock/Calendar
	RTC_MODE0_CTRL_MATCHCLR_Pos      = 0x7   // Position of MATCHCLR field.
	RTC_MODE0_CTRL_MATCHCLR_Msk      = 0x80  // Bit mask of MATCHCLR field.
	RTC_MODE0_CTRL_MATCHCLR          = 0x80  // Bit MATCHCLR.
	RTC_MODE0_CTRL_PRESCALER_Pos     = 0x8   // Position of PRESCALER field.
	RTC_MODE0_CTRL_PRESCALER_Msk     = 0xf00 // Bit mask of PRESCALER field.
	RTC_MODE0_CTRL_PRESCALER_DIV1    = 0x0   // CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE0_CTRL_PRESCALER_DIV2    = 0x1   // CLK_RTC_CNT = GCLK_RTC/2
	RTC_MODE0_CTRL_PRESCALER_DIV4    = 0x2   // CLK_RTC_CNT = GCLK_RTC/4
	RTC_MODE0_CTRL_PRESCALER_DIV8    = 0x3   // CLK_RTC_CNT = GCLK_RTC/8
	RTC_MODE0_CTRL_PRESCALER_DIV16   = 0x4   // CLK_RTC_CNT = GCLK_RTC/16
	RTC_MODE0_CTRL_PRESCALER_DIV32   = 0x5   // CLK_RTC_CNT = GCLK_RTC/32
	RTC_MODE0_CTRL_PRESCALER_DIV64   = 0x6   // CLK_RTC_CNT = GCLK_RTC/64
	RTC_MODE0_CTRL_PRESCALER_DIV128  = 0x7   // CLK_RTC_CNT = GCLK_RTC/128
	RTC_MODE0_CTRL_PRESCALER_DIV256  = 0x8   // CLK_RTC_CNT = GCLK_RTC/256
	RTC_MODE0_CTRL_PRESCALER_DIV512  = 0x9   // CLK_RTC_CNT = GCLK_RTC/512
	RTC_MODE0_CTRL_PRESCALER_DIV1024 = 0xa   // CLK_RTC_CNT = GCLK_RTC/1024

	// READREQ: Read Request
	RTC_MODE0_READREQ_ADDR_Pos  = 0x0    // Position of ADDR field.
	RTC_MODE0_READREQ_ADDR_Msk  = 0x3f   // Bit mask of ADDR field.
	RTC_MODE0_READREQ_RCONT_Pos = 0xe    // Position of RCONT field.
	RTC_MODE0_READREQ_RCONT_Msk = 0x4000 // Bit mask of RCONT field.
	RTC_MODE0_READREQ_RCONT     = 0x4000 // Bit RCONT.
	RTC_MODE0_READREQ_RREQ_Pos  = 0xf    // Position of RREQ field.
	RTC_MODE0_READREQ_RREQ_Msk  = 0x8000 // Bit mask of RREQ field.
	RTC_MODE0_READREQ_RREQ      = 0x8000 // Bit RREQ.

	// EVCTRL: MODE0 Event Control
	RTC_MODE0_EVCTRL_PEREO0_Pos = 0x0    // Position of PEREO0 field.
	RTC_MODE0_EVCTRL_PEREO0_Msk = 0x1    // Bit mask of PEREO0 field.
	RTC_MODE0_EVCTRL_PEREO0     = 0x1    // Bit PEREO0.
	RTC_MODE0_EVCTRL_PEREO1_Pos = 0x1    // Position of PEREO1 field.
	RTC_MODE0_EVCTRL_PEREO1_Msk = 0x2    // Bit mask of PEREO1 field.
	RTC_MODE0_EVCTRL_PEREO1     = 0x2    // Bit PEREO1.
	RTC_MODE0_EVCTRL_PEREO2_Pos = 0x2    // Position of PEREO2 field.
	RTC_MODE0_EVCTRL_PEREO2_Msk = 0x4    // Bit mask of PEREO2 field.
	RTC_MODE0_EVCTRL_PEREO2     = 0x4    // Bit PEREO2.
	RTC_MODE0_EVCTRL_PEREO3_Pos = 0x3    // Position of PEREO3 field.
	RTC_MODE0_EVCTRL_PEREO3_Msk = 0x8    // Bit mask of PEREO3 field.
	RTC_MODE0_EVCTRL_PEREO3     = 0x8    // Bit PEREO3.
	RTC_MODE0_EVCTRL_PEREO4_Pos = 0x4    // Position of PEREO4 field.
	RTC_MODE0_EVCTRL_PEREO4_Msk = 0x10   // Bit mask of PEREO4 field.
	RTC_MODE0_EVCTRL_PEREO4     = 0x10   // Bit PEREO4.
	RTC_MODE0_EVCTRL_PEREO5_Pos = 0x5    // Position of PEREO5 field.
	RTC_MODE0_EVCTRL_PEREO5_Msk = 0x20   // Bit mask of PEREO5 field.
	RTC_MODE0_EVCTRL_PEREO5     = 0x20   // Bit PEREO5.
	RTC_MODE0_EVCTRL_PEREO6_Pos = 0x6    // Position of PEREO6 field.
	RTC_MODE0_EVCTRL_PEREO6_Msk = 0x40   // Bit mask of PEREO6 field.
	RTC_MODE0_EVCTRL_PEREO6     = 0x40   // Bit PEREO6.
	RTC_MODE0_EVCTRL_PEREO7_Pos = 0x7    // Position of PEREO7 field.
	RTC_MODE0_EVCTRL_PEREO7_Msk = 0x80   // Bit mask of PEREO7 field.
	RTC_MODE0_EVCTRL_PEREO7     = 0x80   // Bit PEREO7.
	RTC_MODE0_EVCTRL_CMPEO0_Pos = 0x8    // Position of CMPEO0 field.
	RTC_MODE0_EVCTRL_CMPEO0_Msk = 0x100  // Bit mask of CMPEO0 field.
	RTC_MODE0_EVCTRL_CMPEO0     = 0x100  // Bit CMPEO0.
	RTC_MODE0_EVCTRL_OVFEO_Pos  = 0xf    // Position of OVFEO field.
	RTC_MODE0_EVCTRL_OVFEO_Msk  = 0x8000 // Bit mask of OVFEO field.
	RTC_MODE0_EVCTRL_OVFEO      = 0x8000 // Bit OVFEO.

	// INTENCLR: MODE0 Interrupt Enable Clear
	RTC_MODE0_INTENCLR_CMP0_Pos    = 0x0  // Position of CMP0 field.
	RTC_MODE0_INTENCLR_CMP0_Msk    = 0x1  // Bit mask of CMP0 field.
	RTC_MODE0_INTENCLR_CMP0        = 0x1  // Bit CMP0.
	RTC_MODE0_INTENCLR_SYNCRDY_Pos = 0x6  // Position of SYNCRDY field.
	RTC_MODE0_INTENCLR_SYNCRDY_Msk = 0x40 // Bit mask of SYNCRDY field.
	RTC_MODE0_INTENCLR_SYNCRDY     = 0x40 // Bit SYNCRDY.
	RTC_MODE0_INTENCLR_OVF_Pos     = 0x7  // Position of OVF field.
	RTC_MODE0_INTENCLR_OVF_Msk     = 0x80 // Bit mask of OVF field.
	RTC_MODE0_INTENCLR_OVF         = 0x80 // Bit OVF.

	// INTENSET: MODE0 Interrupt Enable Set
	RTC_MODE0_INTENSET_CMP0_Pos    = 0x0  // Position of CMP0 field.
	RTC_MODE0_INTENSET_CMP0_Msk    = 0x1  // Bit mask of CMP0 field.
	RTC_MODE0_INTENSET_CMP0        = 0x1  // Bit CMP0.
	RTC_MODE0_INTENSET_SYNCRDY_Pos = 0x6  // Position of SYNCRDY field.
	RTC_MODE0_INTENSET_SYNCRDY_Msk = 0x40 // Bit mask of SYNCRDY field.
	RTC_MODE0_INTENSET_SYNCRDY     = 0x40 // Bit SYNCRDY.
	RTC_MODE0_INTENSET_OVF_Pos     = 0x7  // Position of OVF field.
	RTC_MODE0_INTENSET_OVF_Msk     = 0x80 // Bit mask of OVF field.
	RTC_MODE0_INTENSET_OVF         = 0x80 // Bit OVF.

	// INTFLAG: MODE0 Interrupt Flag Status and Clear
	RTC_MODE0_INTFLAG_CMP0_Pos    = 0x0  // Position of CMP0 field.
	RTC_MODE0_INTFLAG_CMP0_Msk    = 0x1  // Bit mask of CMP0 field.
	RTC_MODE0_INTFLAG_CMP0        = 0x1  // Bit CMP0.
	RTC_MODE0_INTFLAG_SYNCRDY_Pos = 0x6  // Position of SYNCRDY field.
	RTC_MODE0_INTFLAG_SYNCRDY_Msk = 0x40 // Bit mask of SYNCRDY field.
	RTC_MODE0_INTFLAG_SYNCRDY     = 0x40 // Bit SYNCRDY.
	RTC_MODE0_INTFLAG_OVF_Pos     = 0x7  // Position of OVF field.
	RTC_MODE0_INTFLAG_OVF_Msk     = 0x80 // Bit mask of OVF field.
	RTC_MODE0_INTFLAG_OVF         = 0x80 // Bit OVF.

	// STATUS: Status
	RTC_MODE0_STATUS_SYNCBUSY_Pos = 0x7  // Position of SYNCBUSY field.
	RTC_MODE0_STATUS_SYNCBUSY_Msk = 0x80 // Bit mask of SYNCBUSY field.
	RTC_MODE0_STATUS_SYNCBUSY     = 0x80 // Bit SYNCBUSY.

	// DBGCTRL: Debug Control
	RTC_MODE0_DBGCTRL_DBGRUN_Pos = 0x0 // Position of DBGRUN field.
	RTC_MODE0_DBGCTRL_DBGRUN_Msk = 0x1 // Bit mask of DBGRUN field.
	RTC_MODE0_DBGCTRL_DBGRUN     = 0x1 // Bit DBGRUN.

	// FREQCORR: Frequency Correction
	RTC_MODE0_FREQCORR_VALUE_Pos = 0x0  // Position of VALUE field.
	RTC_MODE0_FREQCORR_VALUE_Msk = 0x7f // Bit mask of VALUE field.
	RTC_MODE0_FREQCORR_SIGN_Pos  = 0x7  // Position of SIGN field.
	RTC_MODE0_FREQCORR_SIGN_Msk  = 0x80 // Bit mask of SIGN field.
	RTC_MODE0_FREQCORR_SIGN      = 0x80 // Bit SIGN.

	// COUNT: MODE0 Counter Value
	RTC_MODE0_COUNT_COUNT_Pos = 0x0        // Position of COUNT field.
	RTC_MODE0_COUNT_COUNT_Msk = 0xffffffff // Bit mask of COUNT field.

	// COMP0: MODE0 Compare n Value
	RTC_MODE0_COMP_COMP_Pos = 0x0        // Position of COMP field.
	RTC_MODE0_COMP_COMP_Msk = 0xffffffff // Bit mask of COMP field.
)

// Bitfields for RTC_MODE1: Real-Time Counter - MODE1
const (
	// CTRL: MODE1 Control
	RTC_MODE1_CTRL_SWRST_Pos         = 0x0   // Position of SWRST field.
	RTC_MODE1_CTRL_SWRST_Msk         = 0x1   // Bit mask of SWRST field.
	RTC_MODE1_CTRL_SWRST             = 0x1   // Bit SWRST.
	RTC_MODE1_CTRL_ENABLE_Pos        = 0x1   // Position of ENABLE field.
	RTC_MODE1_CTRL_ENABLE_Msk        = 0x2   // Bit mask of ENABLE field.
	RTC_MODE1_CTRL_ENABLE            = 0x2   // Bit ENABLE.
	RTC_MODE1_CTRL_MODE_Pos          = 0x2   // Position of MODE field.
	RTC_MODE1_CTRL_MODE_Msk          = 0xc   // Bit mask of MODE field.
	RTC_MODE1_CTRL_MODE_COUNT32      = 0x0   // Mode 0: 32-bit Counter
	RTC_MODE1_CTRL_MODE_COUNT16      = 0x1   // Mode 1: 16-bit Counter
	RTC_MODE1_CTRL_MODE_CLOCK        = 0x2   // Mode 2: Clock/Calendar
	RTC_MODE1_CTRL_PRESCALER_Pos     = 0x8   // Position of PRESCALER field.
	RTC_MODE1_CTRL_PRESCALER_Msk     = 0xf00 // Bit mask of PRESCALER field.
	RTC_MODE1_CTRL_PRESCALER_DIV1    = 0x0   // CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE1_CTRL_PRESCALER_DIV2    = 0x1   // CLK_RTC_CNT = GCLK_RTC/2
	RTC_MODE1_CTRL_PRESCALER_DIV4    = 0x2   // CLK_RTC_CNT = GCLK_RTC/4
	RTC_MODE1_CTRL_PRESCALER_DIV8    = 0x3   // CLK_RTC_CNT = GCLK_RTC/8
	RTC_MODE1_CTRL_PRESCALER_DIV16   = 0x4   // CLK_RTC_CNT = GCLK_RTC/16
	RTC_MODE1_CTRL_PRESCALER_DIV32   = 0x5   // CLK_RTC_CNT = GCLK_RTC/32
	RTC_MODE1_CTRL_PRESCALER_DIV64   = 0x6   // CLK_RTC_CNT = GCLK_RTC/64
	RTC_MODE1_CTRL_PRESCALER_DIV128  = 0x7   // CLK_RTC_CNT = GCLK_RTC/128
	RTC_MODE1_CTRL_PRESCALER_DIV256  = 0x8   // CLK_RTC_CNT = GCLK_RTC/256
	RTC_MODE1_CTRL_PRESCALER_DIV512  = 0x9   // CLK_RTC_CNT = GCLK_RTC/512
	RTC_MODE1_CTRL_PRESCALER_DIV1024 = 0xa   // CLK_RTC_CNT = GCLK_RTC/1024

	// READREQ: Read Request
	RTC_MODE1_READREQ_ADDR_Pos  = 0x0    // Position of ADDR field.
	RTC_MODE1_READREQ_ADDR_Msk  = 0x3f   // Bit mask of ADDR field.
	RTC_MODE1_READREQ_RCONT_Pos = 0xe    // Position of RCONT field.
	RTC_MODE1_READREQ_RCONT_Msk = 0x4000 // Bit mask of RCONT field.
	RTC_MODE1_READREQ_RCONT     = 0x4000 // Bit RCONT.
	RTC_MODE1_READREQ_RREQ_Pos  = 0xf    // Position of RREQ field.
	RTC_MODE1_READREQ_RREQ_Msk  = 0x8000 // Bit mask of RREQ field.
	RTC_MODE1_READREQ_RREQ      = 0x8000 // Bit RREQ.

	// EVCTRL: MODE1 Event Control
	RTC_MODE1_EVCTRL_PEREO0_Pos = 0x0    // Position of PEREO0 field.
	RTC_MODE1_EVCTRL_PEREO0_Msk = 0x1    // Bit mask of PEREO0 field.
	RTC_MODE1_EVCTRL_PEREO0     = 0x1    // Bit PEREO0.
	RTC_MODE1_EVCTRL_PEREO1_Pos = 0x1    // Position of PEREO1 field.
	RTC_MODE1_EVCTRL_PEREO1_Msk = 0x2    // Bit mask of PEREO1 field.
	RTC_MODE1_EVCTRL_PEREO1     = 0x2    // Bit PEREO1.
	RTC_MODE1_EVCTRL_PEREO2_Pos = 0x2    // Position of PEREO2 field.
	RTC_MODE1_EVCTRL_PEREO2_Msk = 0x4    // Bit mask of PEREO2 field.
	RTC_MODE1_EVCTRL_PEREO2     = 0x4    // Bit PEREO2.
	RTC_MODE1_EVCTRL_PEREO3_Pos = 0x3    // Position of PEREO3 field.
	RTC_MODE1_EVCTRL_PEREO3_Msk = 0x8    // Bit mask of PEREO3 field.
	RTC_MODE1_EVCTRL_PEREO3     = 0x8    // Bit PEREO3.
	RTC_MODE1_EVCTRL_PEREO4_Pos = 0x4    // Position of PEREO4 field.
	RTC_MODE1_EVCTRL_PEREO4_Msk = 0x10   // Bit mask of PEREO4 field.
	RTC_MODE1_EVCTRL_PEREO4     = 0x10   // Bit PEREO4.
	RTC_MODE1_EVCTRL_PEREO5_Pos = 0x5    // Position of PEREO5 field.
	RTC_MODE1_EVCTRL_PEREO5_Msk = 0x20   // Bit mask of PEREO5 field.
	RTC_MODE1_EVCTRL_PEREO5     = 0x20   // Bit PEREO5.
	RTC_MODE1_EVCTRL_PEREO6_Pos = 0x6    // Position of PEREO6 field.
	RTC_MODE1_EVCTRL_PEREO6_Msk = 0x40   // Bit mask of PEREO6 field.
	RTC_MODE1_EVCTRL_PEREO6     = 0x40   // Bit PEREO6.
	RTC_MODE1_EVCTRL_PEREO7_Pos = 0x7    // Position of PEREO7 field.
	RTC_MODE1_EVCTRL_PEREO7_Msk = 0x80   // Bit mask of PEREO7 field.
	RTC_MODE1_EVCTRL_PEREO7     = 0x80   // Bit PEREO7.
	RTC_MODE1_EVCTRL_CMPEO0_Pos = 0x8    // Position of CMPEO0 field.
	RTC_MODE1_EVCTRL_CMPEO0_Msk = 0x100  // Bit mask of CMPEO0 field.
	RTC_MODE1_EVCTRL_CMPEO0     = 0x100  // Bit CMPEO0.
	RTC_MODE1_EVCTRL_CMPEO1_Pos = 0x9    // Position of CMPEO1 field.
	RTC_MODE1_EVCTRL_CMPEO1_Msk = 0x200  // Bit mask of CMPEO1 field.
	RTC_MODE1_EVCTRL_CMPEO1     = 0x200  // Bit CMPEO1.
	RTC_MODE1_EVCTRL_OVFEO_Pos  = 0xf    // Position of OVFEO field.
	RTC_MODE1_EVCTRL_OVFEO_Msk  = 0x8000 // Bit mask of OVFEO field.
	RTC_MODE1_EVCTRL_OVFEO      = 0x8000 // Bit OVFEO.

	// INTENCLR: MODE1 Interrupt Enable Clear
	RTC_MODE1_INTENCLR_CMP0_Pos    = 0x0  // Position of CMP0 field.
	RTC_MODE1_INTENCLR_CMP0_Msk    = 0x1  // Bit mask of CMP0 field.
	RTC_MODE1_INTENCLR_CMP0        = 0x1  // Bit CMP0.
	RTC_MODE1_INTENCLR_CMP1_Pos    = 0x1  // Position of CMP1 field.
	RTC_MODE1_INTENCLR_CMP1_Msk    = 0x2  // Bit mask of CMP1 field.
	RTC_MODE1_INTENCLR_CMP1        = 0x2  // Bit CMP1.
	RTC_MODE1_INTENCLR_SYNCRDY_Pos = 0x6  // Position of SYNCRDY field.
	RTC_MODE1_INTENCLR_SYNCRDY_Msk = 0x40 // Bit mask of SYNCRDY field.
	RTC_MODE1_INTENCLR_SYNCRDY     = 0x40 // Bit SYNCRDY.
	RTC_MODE1_INTENCLR_OVF_Pos     = 0x7  // Position of OVF field.
	RTC_MODE1_INTENCLR_OVF_Msk     = 0x80 // Bit mask of OVF field.
	RTC_MODE1_INTENCLR_OVF         = 0x80 // Bit OVF.

	// INTENSET: MODE1 Interrupt Enable Set
	RTC_MODE1_INTENSET_CMP0_Pos    = 0x0  // Position of CMP0 field.
	RTC_MODE1_INTENSET_CMP0_Msk    = 0x1  // Bit mask of CMP0 field.
	RTC_MODE1_INTENSET_CMP0        = 0x1  // Bit CMP0.
	RTC_MODE1_INTENSET_CMP1_Pos    = 0x1  // Position of CMP1 field.
	RTC_MODE1_INTENSET_CMP1_Msk    = 0x2  // Bit mask of CMP1 field.
	RTC_MODE1_INTENSET_CMP1        = 0x2  // Bit CMP1.
	RTC_MODE1_INTENSET_SYNCRDY_Pos = 0x6  // Position of SYNCRDY field.
	RTC_MODE1_INTENSET_SYNCRDY_Msk = 0x40 // Bit mask of SYNCRDY field.
	RTC_MODE1_INTENSET_SYNCRDY     = 0x40 // Bit SYNCRDY.
	RTC_MODE1_INTENSET_OVF_Pos     = 0x7  // Position of OVF field.
	RTC_MODE1_INTENSET_OVF_Msk     = 0x80 // Bit mask of OVF field.
	RTC_MODE1_INTENSET_OVF         = 0x80 // Bit OVF.

	// INTFLAG: MODE1 Interrupt Flag Status and Clear
	RTC_MODE1_INTFLAG_CMP0_Pos    = 0x0  // Position of CMP0 field.
	RTC_MODE1_INTFLAG_CMP0_Msk    = 0x1  // Bit mask of CMP0 field.
	RTC_MODE1_INTFLAG_CMP0        = 0x1  // Bit CMP0.
	RTC_MODE1_INTFLAG_CMP1_Pos    = 0x1  // Position of CMP1 field.
	RTC_MODE1_INTFLAG_CMP1_Msk    = 0x2  // Bit mask of CMP1 field.
	RTC_MODE1_INTFLAG_CMP1        = 0x2  // Bit CMP1.
	RTC_MODE1_INTFLAG_SYNCRDY_Pos = 0x6  // Position of SYNCRDY field.
	RTC_MODE1_INTFLAG_SYNCRDY_Msk = 0x40 // Bit mask of SYNCRDY field.
	RTC_MODE1_INTFLAG_SYNCRDY     = 0x40 // Bit SYNCRDY.
	RTC_MODE1_INTFLAG_OVF_Pos     = 0x7  // Position of OVF field.
	RTC_MODE1_INTFLAG_OVF_Msk     = 0x80 // Bit mask of OVF field.
	RTC_MODE1_INTFLAG_OVF         = 0x80 // Bit OVF.

	// STATUS: Status
	RTC_MODE1_STATUS_SYNCBUSY_Pos = 0x7  // Position of SYNCBUSY field.
	RTC_MODE1_STATUS_SYNCBUSY_Msk = 0x80 // Bit mask of SYNCBUSY field.
	RTC_MODE1_STATUS_SYNCBUSY     = 0x80 // Bit SYNCBUSY.

	// DBGCTRL: Debug Control
	RTC_MODE1_DBGCTRL_DBGRUN_Pos = 0x0 // Position of DBGRUN field.
	RTC_MODE1_DBGCTRL_DBGRUN_Msk = 0x1 // Bit mask of DBGRUN field.
	RTC_MODE1_DBGCTRL_DBGRUN     = 0x1 // Bit DBGRUN.

	// FREQCORR: Frequency Correction
	RTC_MODE1_FREQCORR_VALUE_Pos = 0x0  // Position of VALUE field.
	RTC_MODE1_FREQCORR_VALUE_Msk = 0x7f // Bit mask of VALUE field.
	RTC_MODE1_FREQCORR_SIGN_Pos  = 0x7  // Position of SIGN field.
	RTC_MODE1_FREQCORR_SIGN_Msk  = 0x80 // Bit mask of SIGN field.
	RTC_MODE1_FREQCORR_SIGN      = 0x80 // Bit SIGN.

	// COUNT: MODE1 Counter Value
	RTC_MODE1_COUNT_COUNT_Pos = 0x0    // Position of COUNT field.
	RTC_MODE1_COUNT_COUNT_Msk = 0xffff // Bit mask of COUNT field.

	// PER: MODE1 Counter Period
	RTC_MODE1_PER_PER_Pos = 0x0    // Position of PER field.
	RTC_MODE1_PER_PER_Msk = 0xffff // Bit mask of PER field.

	// COMP0: MODE1 Compare n Value
	RTC_MODE1_COMP_COMP_Pos = 0x0    // Position of COMP field.
	RTC_MODE1_COMP_COMP_Msk = 0xffff // Bit mask of COMP field.
)

// Bitfields for RTC_MODE2: Real-Time Counter - MODE2
const (
	// CTRL: MODE2 Control
	RTC_MODE2_CTRL_SWRST_Pos         = 0x0   // Position of SWRST field.
	RTC_MODE2_CTRL_SWRST_Msk         = 0x1   // Bit mask of SWRST field.
	RTC_MODE2_CTRL_SWRST             = 0x1   // Bit SWRST.
	RTC_MODE2_CTRL_ENABLE_Pos        = 0x1   // Position of ENABLE field.
	RTC_MODE2_CTRL_ENABLE_Msk        = 0x2   // Bit mask of ENABLE field.
	RTC_MODE2_CTRL_ENABLE            = 0x2   // Bit ENABLE.
	RTC_MODE2_CTRL_MODE_Pos          = 0x2   // Position of MODE field.
	RTC_MODE2_CTRL_MODE_Msk          = 0xc   // Bit mask of MODE field.
	RTC_MODE2_CTRL_MODE_COUNT32      = 0x0   // Mode 0: 32-bit Counter
	RTC_MODE2_CTRL_MODE_COUNT16      = 0x1   // Mode 1: 16-bit Counter
	RTC_MODE2_CTRL_MODE_CLOCK        = 0x2   // Mode 2: Clock/Calendar
	RTC_MODE2_CTRL_CLKREP_Pos        = 0x6   // Position of CLKREP field.
	RTC_MODE2_CTRL_CLKREP_Msk        = 0x40  // Bit mask of CLKREP field.
	RTC_MODE2_CTRL_CLKREP            = 0x40  // Bit CLKREP.
	RTC_MODE2_CTRL_MATCHCLR_Pos      = 0x7   // Position of MATCHCLR field.
	RTC_MODE2_CTRL_MATCHCLR_Msk      = 0x80  // Bit mask of MATCHCLR field.
	RTC_MODE2_CTRL_MATCHCLR          = 0x80  // Bit MATCHCLR.
	RTC_MODE2_CTRL_PRESCALER_Pos     = 0x8   // Position of PRESCALER field.
	RTC_MODE2_CTRL_PRESCALER_Msk     = 0xf00 // Bit mask of PRESCALER field.
	RTC_MODE2_CTRL_PRESCALER_DIV1    = 0x0   // CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE2_CTRL_PRESCALER_DIV2    = 0x1   // CLK_RTC_CNT = GCLK_RTC/2
	RTC_MODE2_CTRL_PRESCALER_DIV4    = 0x2   // CLK_RTC_CNT = GCLK_RTC/4
	RTC_MODE2_CTRL_PRESCALER_DIV8    = 0x3   // CLK_RTC_CNT = GCLK_RTC/8
	RTC_MODE2_CTRL_PRESCALER_DIV16   = 0x4   // CLK_RTC_CNT = GCLK_RTC/16
	RTC_MODE2_CTRL_PRESCALER_DIV32   = 0x5   // CLK_RTC_CNT = GCLK_RTC/32
	RTC_MODE2_CTRL_PRESCALER_DIV64   = 0x6   // CLK_RTC_CNT = GCLK_RTC/64
	RTC_MODE2_CTRL_PRESCALER_DIV128  = 0x7   // CLK_RTC_CNT = GCLK_RTC/128
	RTC_MODE2_CTRL_PRESCALER_DIV256  = 0x8   // CLK_RTC_CNT = GCLK_RTC/256
	RTC_MODE2_CTRL_PRESCALER_DIV512  = 0x9   // CLK_RTC_CNT = GCLK_RTC/512
	RTC_MODE2_CTRL_PRESCALER_DIV1024 = 0xa   // CLK_RTC_CNT = GCLK_RTC/1024

	// READREQ: Read Request
	RTC_MODE2_READREQ_ADDR_Pos  = 0x0    // Position of ADDR field.
	RTC_MODE2_READREQ_ADDR_Msk  = 0x3f   // Bit mask of ADDR field.
	RTC_MODE2_READREQ_RCONT_Pos = 0xe    // Position of RCONT field.
	RTC_MODE2_READREQ_RCONT_Msk = 0x4000 // Bit mask of RCONT field.
	RTC_MODE2_READREQ_RCONT     = 0x4000 // Bit RCONT.
	RTC_MODE2_READREQ_RREQ_Pos  = 0xf    // Position of RREQ field.
	RTC_MODE2_READREQ_RREQ_Msk  = 0x8000 // Bit mask of RREQ field.
	RTC_MODE2_READREQ_RREQ      = 0x8000 // Bit RREQ.

	// EVCTRL: MODE2 Event Control
	RTC_MODE2_EVCTRL_PEREO0_Pos   = 0x0    // Position of PEREO0 field.
	RTC_MODE2_EVCTRL_PEREO0_Msk   = 0x1    // Bit mask of PEREO0 field.
	RTC_MODE2_EVCTRL_PEREO0       = 0x1    // Bit PEREO0.
	RTC_MODE2_EVCTRL_PEREO1_Pos   = 0x1    // Position of PEREO1 field.
	RTC_MODE2_EVCTRL_PEREO1_Msk   = 0x2    // Bit mask of PEREO1 field.
	RTC_MODE2_EVCTRL_PEREO1       = 0x2    // Bit PEREO1.
	RTC_MODE2_EVCTRL_PEREO2_Pos   = 0x2    // Position of PEREO2 field.
	RTC_MODE2_EVCTRL_PEREO2_Msk   = 0x4    // Bit mask of PEREO2 field.
	RTC_MODE2_EVCTRL_PEREO2       = 0x4    // Bit PEREO2.
	RTC_MODE2_EVCTRL_PEREO3_Pos   = 0x3    // Position of PEREO3 field.
	RTC_MODE2_EVCTRL_PEREO3_Msk   = 0x8    // Bit mask of PEREO3 field.
	RTC_MODE2_EVCTRL_PEREO3       = 0x8    // Bit PEREO3.
	RTC_MODE2_EVCTRL_PEREO4_Pos   = 0x4    // Position of PEREO4 field.
	RTC_MODE2_EVCTRL_PEREO4_Msk   = 0x10   // Bit mask of PEREO4 field.
	RTC_MODE2_EVCTRL_PEREO4       = 0x10   // Bit PEREO4.
	RTC_MODE2_EVCTRL_PEREO5_Pos   = 0x5    // Position of PEREO5 field.
	RTC_MODE2_EVCTRL_PEREO5_Msk   = 0x20   // Bit mask of PEREO5 field.
	RTC_MODE2_EVCTRL_PEREO5       = 0x20   // Bit PEREO5.
	RTC_MODE2_EVCTRL_PEREO6_Pos   = 0x6    // Position of PEREO6 field.
	RTC_MODE2_EVCTRL_PEREO6_Msk   = 0x40   // Bit mask of PEREO6 field.
	RTC_MODE2_EVCTRL_PEREO6       = 0x40   // Bit PEREO6.
	RTC_MODE2_EVCTRL_PEREO7_Pos   = 0x7    // Position of PEREO7 field.
	RTC_MODE2_EVCTRL_PEREO7_Msk   = 0x80   // Bit mask of PEREO7 field.
	RTC_MODE2_EVCTRL_PEREO7       = 0x80   // Bit PEREO7.
	RTC_MODE2_EVCTRL_ALARMEO0_Pos = 0x8    // Position of ALARMEO0 field.
	RTC_MODE2_EVCTRL_ALARMEO0_Msk = 0x100  // Bit mask of ALARMEO0 field.
	RTC_MODE2_EVCTRL_ALARMEO0     = 0x100  // Bit ALARMEO0.
	RTC_MODE2_EVCTRL_OVFEO_Pos    = 0xf    // Position of OVFEO field.
	RTC_MODE2_EVCTRL_OVFEO_Msk    = 0x8000 // Bit mask of OVFEO field.
	RTC_MODE2_EVCTRL_OVFEO        = 0x8000 // Bit OVFEO.

	// INTENCLR: MODE2 Interrupt Enable Clear
	RTC_MODE2_INTENCLR_ALARM0_Pos  = 0x0  // Position of ALARM0 field.
	RTC_MODE2_INTENCLR_ALARM0_Msk  = 0x1  // Bit mask of ALARM0 field.
	RTC_MODE2_INTENCLR_ALARM0      = 0x1  // Bit ALARM0.
	RTC_MODE2_INTENCLR_SYNCRDY_Pos = 0x6  // Position of SYNCRDY field.
	RTC_MODE2_INTENCLR_SYNCRDY_Msk = 0x40 // Bit mask of SYNCRDY field.
	RTC_MODE2_INTENCLR_SYNCRDY     = 0x40 // Bit SYNCRDY.
	RTC_MODE2_INTENCLR_OVF_Pos     = 0x7  // Position of OVF field.
	RTC_MODE2_INTENCLR_OVF_Msk     = 0x80 // Bit mask of OVF field.
	RTC_MODE2_INTENCLR_OVF         = 0x80 // Bit OVF.

	// INTENSET: MODE2 Interrupt Enable Set
	RTC_MODE2_INTENSET_ALARM0_Pos  = 0x0  // Position of ALARM0 field.
	RTC_MODE2_INTENSET_ALARM0_Msk  = 0x1  // Bit mask of ALARM0 field.
	RTC_MODE2_INTENSET_ALARM0      = 0x1  // Bit ALARM0.
	RTC_MODE2_INTENSET_SYNCRDY_Pos = 0x6  // Position of SYNCRDY field.
	RTC_MODE2_INTENSET_SYNCRDY_Msk = 0x40 // Bit mask of SYNCRDY field.
	RTC_MODE2_INTENSET_SYNCRDY     = 0x40 // Bit SYNCRDY.
	RTC_MODE2_INTENSET_OVF_Pos     = 0x7  // Position of OVF field.
	RTC_MODE2_INTENSET_OVF_Msk     = 0x80 // Bit mask of OVF field.
	RTC_MODE2_INTENSET_OVF         = 0x80 // Bit OVF.

	// INTFLAG: MODE2 Interrupt Flag Status and Clear
	RTC_MODE2_INTFLAG_ALARM0_Pos  = 0x0  // Position of ALARM0 field.
	RTC_MODE2_INTFLAG_ALARM0_Msk  = 0x1  // Bit mask of ALARM0 field.
	RTC_MODE2_INTFLAG_ALARM0      = 0x1  // Bit ALARM0.
	RTC_MODE2_INTFLAG_SYNCRDY_Pos = 0x6  // Position of SYNCRDY field.
	RTC_MODE2_INTFLAG_SYNCRDY_Msk = 0x40 // Bit mask of SYNCRDY field.
	RTC_MODE2_INTFLAG_SYNCRDY     = 0x40 // Bit SYNCRDY.
	RTC_MODE2_INTFLAG_OVF_Pos     = 0x7  // Position of OVF field.
	RTC_MODE2_INTFLAG_OVF_Msk     = 0x80 // Bit mask of OVF field.
	RTC_MODE2_INTFLAG_OVF         = 0x80 // Bit OVF.

	// STATUS: Status
	RTC_MODE2_STATUS_SYNCBUSY_Pos = 0x7  // Position of SYNCBUSY field.
	RTC_MODE2_STATUS_SYNCBUSY_Msk = 0x80 // Bit mask of SYNCBUSY field.
	RTC_MODE2_STATUS_SYNCBUSY     = 0x80 // Bit SYNCBUSY.

	// DBGCTRL: Debug Control
	RTC_MODE2_DBGCTRL_DBGRUN_Pos = 0x0 // Position of DBGRUN field.
	RTC_MODE2_DBGCTRL_DBGRUN_Msk = 0x1 // Bit mask of DBGRUN field.
	RTC_MODE2_DBGCTRL_DBGRUN     = 0x1 // Bit DBGRUN.

	// FREQCORR: Frequency Correction
	RTC_MODE2_FREQCORR_VALUE_Pos = 0x0  // Position of VALUE field.
	RTC_MODE2_FREQCORR_VALUE_Msk = 0x7f // Bit mask of VALUE field.
	RTC_MODE2_FREQCORR_SIGN_Pos  = 0x7  // Position of SIGN field.
	RTC_MODE2_FREQCORR_SIGN_Msk  = 0x80 // Bit mask of SIGN field.
	RTC_MODE2_FREQCORR_SIGN      = 0x80 // Bit SIGN.

	// CLOCK: MODE2 Clock Value
	RTC_MODE2_CLOCK_SECOND_Pos = 0x0        // Position of SECOND field.
	RTC_MODE2_CLOCK_SECOND_Msk = 0x3f       // Bit mask of SECOND field.
	RTC_MODE2_CLOCK_MINUTE_Pos = 0x6        // Position of MINUTE field.
	RTC_MODE2_CLOCK_MINUTE_Msk = 0xfc0      // Bit mask of MINUTE field.
	RTC_MODE2_CLOCK_HOUR_Pos   = 0xc        // Position of HOUR field.
	RTC_MODE2_CLOCK_HOUR_Msk   = 0x1f000    // Bit mask of HOUR field.
	RTC_MODE2_CLOCK_HOUR_AM    = 0x0        // AM when CLKREP in 12-hour
	RTC_MODE2_CLOCK_HOUR_PM    = 0x10       // PM when CLKREP in 12-hour
	RTC_MODE2_CLOCK_DAY_Pos    = 0x11       // Position of DAY field.
	RTC_MODE2_CLOCK_DAY_Msk    = 0x3e0000   // Bit mask of DAY field.
	RTC_MODE2_CLOCK_MONTH_Pos  = 0x16       // Position of MONTH field.
	RTC_MODE2_CLOCK_MONTH_Msk  = 0x3c00000  // Bit mask of MONTH field.
	RTC_MODE2_CLOCK_YEAR_Pos   = 0x1a       // Position of YEAR field.
	RTC_MODE2_CLOCK_YEAR_Msk   = 0xfc000000 // Bit mask of YEAR field.

	// ALARM0: MODE2 Alarm n Value
	RTC_MODE2_ALARM_SECOND_Pos = 0x0        // Position of SECOND field.
	RTC_MODE2_ALARM_SECOND_Msk = 0x3f       // Bit mask of SECOND field.
	RTC_MODE2_ALARM_MINUTE_Pos = 0x6        // Position of MINUTE field.
	RTC_MODE2_ALARM_MINUTE_Msk = 0xfc0      // Bit mask of MINUTE field.
	RTC_MODE2_ALARM_HOUR_Pos   = 0xc        // Position of HOUR field.
	RTC_MODE2_ALARM_HOUR_Msk   = 0x1f000    // Bit mask of HOUR field.
	RTC_MODE2_ALARM_HOUR_AM    = 0x0        // Morning hour
	RTC_MODE2_ALARM_HOUR_PM    = 0x10       // Afternoon hour
	RTC_MODE2_ALARM_DAY_Pos    = 0x11       // Position of DAY field.
	RTC_MODE2_ALARM_DAY_Msk    = 0x3e0000   // Bit mask of DAY field.
	RTC_MODE2_ALARM_MONTH_Pos  = 0x16       // Position of MONTH field.
	RTC_MODE2_ALARM_MONTH_Msk  = 0x3c00000  // Bit mask of MONTH field.
	RTC_MODE2_ALARM_YEAR_Pos   = 0x1a       // Position of YEAR field.
	RTC_MODE2_ALARM_YEAR_Msk   = 0xfc000000 // Bit mask of YEAR field.

	// MASK0: MODE2 Alarm n Mask
	RTC_MODE2_MASK_SEL_Pos          = 0x0 // Position of SEL field.
	RTC_MODE2_MASK_SEL_Msk          = 0x7 // Bit mask of SEL field.
	RTC_MODE2_MASK_SEL_OFF          = 0x0 // Alarm Disabled
	RTC_MODE2_MASK_SEL_SS           = 0x1 // Match seconds only
	RTC_MODE2_MASK_SEL_MMSS         = 0x2 // Match seconds and minutes only
	RTC_MODE2_MASK_SEL_HHMMSS       = 0x3 // Match seconds, minutes, and hours only
	RTC_MODE2_MASK_SEL_DDHHMMSS     = 0x4 // Match seconds, minutes, hours, and days only
	RTC_MODE2_MASK_SEL_MMDDHHMMSS   = 0x5 // Match seconds, minutes, hours, days, and months only
	RTC_MODE2_MASK_SEL_YYMMDDHHMMSS = 0x6 // Match seconds, minutes, hours, days, months, and years
)

// Bitfields for SERCOM0: Serial Communication Interface 0
const ()

// Bitfields for SERCOM0_I2CM: Serial Communication Interface 0 - I2CM
const (
	// CTRLA: I2CM Control A
	SERCOM_I2CM_CTRLA_SWRST_Pos          = 0x0        // Position of SWRST field.
	SERCOM_I2CM_CTRLA_SWRST_Msk          = 0x1        // Bit mask of SWRST field.
	SERCOM_I2CM_CTRLA_SWRST              = 0x1        // Bit SWRST.
	SERCOM_I2CM_CTRLA_ENABLE_Pos         = 0x1        // Position of ENABLE field.
	SERCOM_I2CM_CTRLA_ENABLE_Msk         = 0x2        // Bit mask of ENABLE field.
	SERCOM_I2CM_CTRLA_ENABLE             = 0x2        // Bit ENABLE.
	SERCOM_I2CM_CTRLA_MODE_Pos           = 0x2        // Position of MODE field.
	SERCOM_I2CM_CTRLA_MODE_Msk           = 0x1c       // Bit mask of MODE field.
	SERCOM_I2CM_CTRLA_MODE_USART_EXT_CLK = 0x0        // USART mode with external clock
	SERCOM_I2CM_CTRLA_MODE_USART_INT_CLK = 0x1        // USART mode with internal clock
	SERCOM_I2CM_CTRLA_MODE_SPI_SLAVE     = 0x2        // SPI mode with external clock
	SERCOM_I2CM_CTRLA_MODE_SPI_MASTER    = 0x3        // SPI mode with internal clock
	SERCOM_I2CM_CTRLA_MODE_I2C_SLAVE     = 0x4        // I2C mode with external clock
	SERCOM_I2CM_CTRLA_MODE_I2C_MASTER    = 0x5        // I2C mode with internal clock
	SERCOM_I2CM_CTRLA_RUNSTDBY_Pos       = 0x7        // Position of RUNSTDBY field.
	SERCOM_I2CM_CTRLA_RUNSTDBY_Msk       = 0x80       // Bit mask of RUNSTDBY field.
	SERCOM_I2CM_CTRLA_RUNSTDBY           = 0x80       // Bit RUNSTDBY.
	SERCOM_I2CM_CTRLA_PINOUT_Pos         = 0x10       // Position of PINOUT field.
	SERCOM_I2CM_CTRLA_PINOUT_Msk         = 0x10000    // Bit mask of PINOUT field.
	SERCOM_I2CM_CTRLA_PINOUT             = 0x10000    // Bit PINOUT.
	SERCOM_I2CM_CTRLA_SDAHOLD_Pos        = 0x14       // Position of SDAHOLD field.
	SERCOM_I2CM_CTRLA_SDAHOLD_Msk        = 0x300000   // Bit mask of SDAHOLD field.
	SERCOM_I2CM_CTRLA_MEXTTOEN_Pos       = 0x16       // Position of MEXTTOEN field.
	SERCOM_I2CM_CTRLA_MEXTTOEN_Msk       = 0x400000   // Bit mask of MEXTTOEN field.
	SERCOM_I2CM_CTRLA_MEXTTOEN           = 0x400000   // Bit MEXTTOEN.
	SERCOM_I2CM_CTRLA_SEXTTOEN_Pos       = 0x17       // Position of SEXTTOEN field.
	SERCOM_I2CM_CTRLA_SEXTTOEN_Msk       = 0x800000   // Bit mask of SEXTTOEN field.
	SERCOM_I2CM_CTRLA_SEXTTOEN           = 0x800000   // Bit SEXTTOEN.
	SERCOM_I2CM_CTRLA_SPEED_Pos          = 0x18       // Position of SPEED field.
	SERCOM_I2CM_CTRLA_SPEED_Msk          = 0x3000000  // Bit mask of SPEED field.
	SERCOM_I2CM_CTRLA_SCLSM_Pos          = 0x1b       // Position of SCLSM field.
	SERCOM_I2CM_CTRLA_SCLSM_Msk          = 0x8000000  // Bit mask of SCLSM field.
	SERCOM_I2CM_CTRLA_SCLSM              = 0x8000000  // Bit SCLSM.
	SERCOM_I2CM_CTRLA_INACTOUT_Pos       = 0x1c       // Position of INACTOUT field.
	SERCOM_I2CM_CTRLA_INACTOUT_Msk       = 0x30000000 // Bit mask of INACTOUT field.
	SERCOM_I2CM_CTRLA_LOWTOUTEN_Pos      = 0x1e       // Position of LOWTOUTEN field.
	SERCOM_I2CM_CTRLA_LOWTOUTEN_Msk      = 0x40000000 // Bit mask of LOWTOUTEN field.
	SERCOM_I2CM_CTRLA_LOWTOUTEN          = 0x40000000 // Bit LOWTOUTEN.

	// CTRLB: I2CM Control B
	SERCOM_I2CM_CTRLB_SMEN_Pos   = 0x8     // Position of SMEN field.
	SERCOM_I2CM_CTRLB_SMEN_Msk   = 0x100   // Bit mask of SMEN field.
	SERCOM_I2CM_CTRLB_SMEN       = 0x100   // Bit SMEN.
	SERCOM_I2CM_CTRLB_QCEN_Pos   = 0x9     // Position of QCEN field.
	SERCOM_I2CM_CTRLB_QCEN_Msk   = 0x200   // Bit mask of QCEN field.
	SERCOM_I2CM_CTRLB_QCEN       = 0x200   // Bit QCEN.
	SERCOM_I2CM_CTRLB_CMD_Pos    = 0x10    // Position of CMD field.
	SERCOM_I2CM_CTRLB_CMD_Msk    = 0x30000 // Bit mask of CMD field.
	SERCOM_I2CM_CTRLB_ACKACT_Pos = 0x12    // Position of ACKACT field.
	SERCOM_I2CM_CTRLB_ACKACT_Msk = 0x40000 // Bit mask of ACKACT field.
	SERCOM_I2CM_CTRLB_ACKACT     = 0x40000 // Bit ACKACT.

	// BAUD: I2CM Baud Rate
	SERCOM_I2CM_BAUD_BAUD_Pos      = 0x0        // Position of BAUD field.
	SERCOM_I2CM_BAUD_BAUD_Msk      = 0xff       // Bit mask of BAUD field.
	SERCOM_I2CM_BAUD_BAUDLOW_Pos   = 0x8        // Position of BAUDLOW field.
	SERCOM_I2CM_BAUD_BAUDLOW_Msk   = 0xff00     // Bit mask of BAUDLOW field.
	SERCOM_I2CM_BAUD_HSBAUD_Pos    = 0x10       // Position of HSBAUD field.
	SERCOM_I2CM_BAUD_HSBAUD_Msk    = 0xff0000   // Bit mask of HSBAUD field.
	SERCOM_I2CM_BAUD_HSBAUDLOW_Pos = 0x18       // Position of HSBAUDLOW field.
	SERCOM_I2CM_BAUD_HSBAUDLOW_Msk = 0xff000000 // Bit mask of HSBAUDLOW field.

	// INTENCLR: I2CM Interrupt Enable Clear
	SERCOM_I2CM_INTENCLR_MB_Pos    = 0x0  // Position of MB field.
	SERCOM_I2CM_INTENCLR_MB_Msk    = 0x1  // Bit mask of MB field.
	SERCOM_I2CM_INTENCLR_MB        = 0x1  // Bit MB.
	SERCOM_I2CM_INTENCLR_SB_Pos    = 0x1  // Position of SB field.
	SERCOM_I2CM_INTENCLR_SB_Msk    = 0x2  // Bit mask of SB field.
	SERCOM_I2CM_INTENCLR_SB        = 0x2  // Bit SB.
	SERCOM_I2CM_INTENCLR_ERROR_Pos = 0x7  // Position of ERROR field.
	SERCOM_I2CM_INTENCLR_ERROR_Msk = 0x80 // Bit mask of ERROR field.
	SERCOM_I2CM_INTENCLR_ERROR     = 0x80 // Bit ERROR.

	// INTENSET: I2CM Interrupt Enable Set
	SERCOM_I2CM_INTENSET_MB_Pos    = 0x0  // Position of MB field.
	SERCOM_I2CM_INTENSET_MB_Msk    = 0x1  // Bit mask of MB field.
	SERCOM_I2CM_INTENSET_MB        = 0x1  // Bit MB.
	SERCOM_I2CM_INTENSET_SB_Pos    = 0x1  // Position of SB field.
	SERCOM_I2CM_INTENSET_SB_Msk    = 0x2  // Bit mask of SB field.
	SERCOM_I2CM_INTENSET_SB        = 0x2  // Bit SB.
	SERCOM_I2CM_INTENSET_ERROR_Pos = 0x7  // Position of ERROR field.
	SERCOM_I2CM_INTENSET_ERROR_Msk = 0x80 // Bit mask of ERROR field.
	SERCOM_I2CM_INTENSET_ERROR     = 0x80 // Bit ERROR.

	// INTFLAG: I2CM Interrupt Flag Status and Clear
	SERCOM_I2CM_INTFLAG_MB_Pos    = 0x0  // Position of MB field.
	SERCOM_I2CM_INTFLAG_MB_Msk    = 0x1  // Bit mask of MB field.
	SERCOM_I2CM_INTFLAG_MB        = 0x1  // Bit MB.
	SERCOM_I2CM_INTFLAG_SB_Pos    = 0x1  // Position of SB field.
	SERCOM_I2CM_INTFLAG_SB_Msk    = 0x2  // Bit mask of SB field.
	SERCOM_I2CM_INTFLAG_SB        = 0x2  // Bit SB.
	SERCOM_I2CM_INTFLAG_ERROR_Pos = 0x7  // Position of ERROR field.
	SERCOM_I2CM_INTFLAG_ERROR_Msk = 0x80 // Bit mask of ERROR field.
	SERCOM_I2CM_INTFLAG_ERROR     = 0x80 // Bit ERROR.

	// STATUS: I2CM Status
	SERCOM_I2CM_STATUS_BUSERR_Pos   = 0x0   // Position of BUSERR field.
	SERCOM_I2CM_STATUS_BUSERR_Msk   = 0x1   // Bit mask of BUSERR field.
	SERCOM_I2CM_STATUS_BUSERR       = 0x1   // Bit BUSERR.
	SERCOM_I2CM_STATUS_ARBLOST_Pos  = 0x1   // Position of ARBLOST field.
	SERCOM_I2CM_STATUS_ARBLOST_Msk  = 0x2   // Bit mask of ARBLOST field.
	SERCOM_I2CM_STATUS_ARBLOST      = 0x2   // Bit ARBLOST.
	SERCOM_I2CM_STATUS_RXNACK_Pos   = 0x2   // Position of RXNACK field.
	SERCOM_I2CM_STATUS_RXNACK_Msk   = 0x4   // Bit mask of RXNACK field.
	SERCOM_I2CM_STATUS_RXNACK       = 0x4   // Bit RXNACK.
	SERCOM_I2CM_STATUS_BUSSTATE_Pos = 0x4   // Position of BUSSTATE field.
	SERCOM_I2CM_STATUS_BUSSTATE_Msk = 0x30  // Bit mask of BUSSTATE field.
	SERCOM_I2CM_STATUS_LOWTOUT_Pos  = 0x6   // Position of LOWTOUT field.
	SERCOM_I2CM_STATUS_LOWTOUT_Msk  = 0x40  // Bit mask of LOWTOUT field.
	SERCOM_I2CM_STATUS_LOWTOUT      = 0x40  // Bit LOWTOUT.
	SERCOM_I2CM_STATUS_CLKHOLD_Pos  = 0x7   // Position of CLKHOLD field.
	SERCOM_I2CM_STATUS_CLKHOLD_Msk  = 0x80  // Bit mask of CLKHOLD field.
	SERCOM_I2CM_STATUS_CLKHOLD      = 0x80  // Bit CLKHOLD.
	SERCOM_I2CM_STATUS_MEXTTOUT_Pos = 0x8   // Position of MEXTTOUT field.
	SERCOM_I2CM_STATUS_MEXTTOUT_Msk = 0x100 // Bit mask of MEXTTOUT field.
	SERCOM_I2CM_STATUS_MEXTTOUT     = 0x100 // Bit MEXTTOUT.
	SERCOM_I2CM_STATUS_SEXTTOUT_Pos = 0x9   // Position of SEXTTOUT field.
	SERCOM_I2CM_STATUS_SEXTTOUT_Msk = 0x200 // Bit mask of SEXTTOUT field.
	SERCOM_I2CM_STATUS_SEXTTOUT     = 0x200 // Bit SEXTTOUT.
	SERCOM_I2CM_STATUS_LENERR_Pos   = 0xa   // Position of LENERR field.
	SERCOM_I2CM_STATUS_LENERR_Msk   = 0x400 // Bit mask of LENERR field.
	SERCOM_I2CM_STATUS_LENERR       = 0x400 // Bit LENERR.

	// SYNCBUSY: I2CM Synchronization Busy
	SERCOM_I2CM_SYNCBUSY_SWRST_Pos  = 0x0 // Position of SWRST field.
	SERCOM_I2CM_SYNCBUSY_SWRST_Msk  = 0x1 // Bit mask of SWRST field.
	SERCOM_I2CM_SYNCBUSY_SWRST      = 0x1 // Bit SWRST.
	SERCOM_I2CM_SYNCBUSY_ENABLE_Pos = 0x1 // Position of ENABLE field.
	SERCOM_I2CM_SYNCBUSY_ENABLE_Msk = 0x2 // Bit mask of ENABLE field.
	SERCOM_I2CM_SYNCBUSY_ENABLE     = 0x2 // Bit ENABLE.
	SERCOM_I2CM_SYNCBUSY_SYSOP_Pos  = 0x2 // Position of SYSOP field.
	SERCOM_I2CM_SYNCBUSY_SYSOP_Msk  = 0x4 // Bit mask of SYSOP field.
	SERCOM_I2CM_SYNCBUSY_SYSOP      = 0x4 // Bit SYSOP.

	// ADDR: I2CM Address
	SERCOM_I2CM_ADDR_ADDR_Pos     = 0x0      // Position of ADDR field.
	SERCOM_I2CM_ADDR_ADDR_Msk     = 0x7ff    // Bit mask of ADDR field.
	SERCOM_I2CM_ADDR_LENEN_Pos    = 0xd      // Position of LENEN field.
	SERCOM_I2CM_ADDR_LENEN_Msk    = 0x2000   // Bit mask of LENEN field.
	SERCOM_I2CM_ADDR_LENEN        = 0x2000   // Bit LENEN.
	SERCOM_I2CM_ADDR_HS_Pos       = 0xe      // Position of HS field.
	SERCOM_I2CM_ADDR_HS_Msk       = 0x4000   // Bit mask of HS field.
	SERCOM_I2CM_ADDR_HS           = 0x4000   // Bit HS.
	SERCOM_I2CM_ADDR_TENBITEN_Pos = 0xf      // Position of TENBITEN field.
	SERCOM_I2CM_ADDR_TENBITEN_Msk = 0x8000   // Bit mask of TENBITEN field.
	SERCOM_I2CM_ADDR_TENBITEN     = 0x8000   // Bit TENBITEN.
	SERCOM_I2CM_ADDR_LEN_Pos      = 0x10     // Position of LEN field.
	SERCOM_I2CM_ADDR_LEN_Msk      = 0xff0000 // Bit mask of LEN field.

	// DATA: I2CM Data
	SERCOM_I2CM_DATA_DATA_Pos = 0x0  // Position of DATA field.
	SERCOM_I2CM_DATA_DATA_Msk = 0xff // Bit mask of DATA field.

	// DBGCTRL: I2CM Debug Control
	SERCOM_I2CM_DBGCTRL_DBGSTOP_Pos = 0x0 // Position of DBGSTOP field.
	SERCOM_I2CM_DBGCTRL_DBGSTOP_Msk = 0x1 // Bit mask of DBGSTOP field.
	SERCOM_I2CM_DBGCTRL_DBGSTOP     = 0x1 // Bit DBGSTOP.
)

// Bitfields for SERCOM0_I2CS: Serial Communication Interface 0 - I2CS
const (
	// CTRLA: I2CS Control A
	SERCOM_I2CS_CTRLA_SWRST_Pos          = 0x0        // Position of SWRST field.
	SERCOM_I2CS_CTRLA_SWRST_Msk          = 0x1        // Bit mask of SWRST field.
	SERCOM_I2CS_CTRLA_SWRST              = 0x1        // Bit SWRST.
	SERCOM_I2CS_CTRLA_ENABLE_Pos         = 0x1        // Position of ENABLE field.
	SERCOM_I2CS_CTRLA_ENABLE_Msk         = 0x2        // Bit mask of ENABLE field.
	SERCOM_I2CS_CTRLA_ENABLE             = 0x2        // Bit ENABLE.
	SERCOM_I2CS_CTRLA_MODE_Pos           = 0x2        // Position of MODE field.
	SERCOM_I2CS_CTRLA_MODE_Msk           = 0x1c       // Bit mask of MODE field.
	SERCOM_I2CS_CTRLA_MODE_USART_EXT_CLK = 0x0        // USART mode with external clock
	SERCOM_I2CS_CTRLA_MODE_USART_INT_CLK = 0x1        // USART mode with internal clock
	SERCOM_I2CS_CTRLA_MODE_SPI_SLAVE     = 0x2        // SPI mode with external clock
	SERCOM_I2CS_CTRLA_MODE_SPI_MASTER    = 0x3        // SPI mode with internal clock
	SERCOM_I2CS_CTRLA_MODE_I2C_SLAVE     = 0x4        // I2C mode with external clock
	SERCOM_I2CS_CTRLA_MODE_I2C_MASTER    = 0x5        // I2C mode with internal clock
	SERCOM_I2CS_CTRLA_RUNSTDBY_Pos       = 0x7        // Position of RUNSTDBY field.
	SERCOM_I2CS_CTRLA_RUNSTDBY_Msk       = 0x80       // Bit mask of RUNSTDBY field.
	SERCOM_I2CS_CTRLA_RUNSTDBY           = 0x80       // Bit RUNSTDBY.
	SERCOM_I2CS_CTRLA_PINOUT_Pos         = 0x10       // Position of PINOUT field.
	SERCOM_I2CS_CTRLA_PINOUT_Msk         = 0x10000    // Bit mask of PINOUT field.
	SERCOM_I2CS_CTRLA_PINOUT             = 0x10000    // Bit PINOUT.
	SERCOM_I2CS_CTRLA_SDAHOLD_Pos        = 0x14       // Position of SDAHOLD field.
	SERCOM_I2CS_CTRLA_SDAHOLD_Msk        = 0x300000   // Bit mask of SDAHOLD field.
	SERCOM_I2CS_CTRLA_SEXTTOEN_Pos       = 0x17       // Position of SEXTTOEN field.
	SERCOM_I2CS_CTRLA_SEXTTOEN_Msk       = 0x800000   // Bit mask of SEXTTOEN field.
	SERCOM_I2CS_CTRLA_SEXTTOEN           = 0x800000   // Bit SEXTTOEN.
	SERCOM_I2CS_CTRLA_SPEED_Pos          = 0x18       // Position of SPEED field.
	SERCOM_I2CS_CTRLA_SPEED_Msk          = 0x3000000  // Bit mask of SPEED field.
	SERCOM_I2CS_CTRLA_SCLSM_Pos          = 0x1b       // Position of SCLSM field.
	SERCOM_I2CS_CTRLA_SCLSM_Msk          = 0x8000000  // Bit mask of SCLSM field.
	SERCOM_I2CS_CTRLA_SCLSM              = 0x8000000  // Bit SCLSM.
	SERCOM_I2CS_CTRLA_LOWTOUTEN_Pos      = 0x1e       // Position of LOWTOUTEN field.
	SERCOM_I2CS_CTRLA_LOWTOUTEN_Msk      = 0x40000000 // Bit mask of LOWTOUTEN field.
	SERCOM_I2CS_CTRLA_LOWTOUTEN          = 0x40000000 // Bit LOWTOUTEN.

	// CTRLB: I2CS Control B
	SERCOM_I2CS_CTRLB_SMEN_Pos   = 0x8     // Position of SMEN field.
	SERCOM_I2CS_CTRLB_SMEN_Msk   = 0x100   // Bit mask of SMEN field.
	SERCOM_I2CS_CTRLB_SMEN       = 0x100   // Bit SMEN.
	SERCOM_I2CS_CTRLB_GCMD_Pos   = 0x9     // Position of GCMD field.
	SERCOM_I2CS_CTRLB_GCMD_Msk   = 0x200   // Bit mask of GCMD field.
	SERCOM_I2CS_CTRLB_GCMD       = 0x200   // Bit GCMD.
	SERCOM_I2CS_CTRLB_AACKEN_Pos = 0xa     // Position of AACKEN field.
	SERCOM_I2CS_CTRLB_AACKEN_Msk = 0x400   // Bit mask of AACKEN field.
	SERCOM_I2CS_CTRLB_AACKEN     = 0x400   // Bit AACKEN.
	SERCOM_I2CS_CTRLB_AMODE_Pos  = 0xe     // Position of AMODE field.
	SERCOM_I2CS_CTRLB_AMODE_Msk  = 0xc000  // Bit mask of AMODE field.
	SERCOM_I2CS_CTRLB_CMD_Pos    = 0x10    // Position of CMD field.
	SERCOM_I2CS_CTRLB_CMD_Msk    = 0x30000 // Bit mask of CMD field.
	SERCOM_I2CS_CTRLB_ACKACT_Pos = 0x12    // Position of ACKACT field.
	SERCOM_I2CS_CTRLB_ACKACT_Msk = 0x40000 // Bit mask of ACKACT field.
	SERCOM_I2CS_CTRLB_ACKACT     = 0x40000 // Bit ACKACT.

	// INTENCLR: I2CS Interrupt Enable Clear
	SERCOM_I2CS_INTENCLR_PREC_Pos   = 0x0  // Position of PREC field.
	SERCOM_I2CS_INTENCLR_PREC_Msk   = 0x1  // Bit mask of PREC field.
	SERCOM_I2CS_INTENCLR_PREC       = 0x1  // Bit PREC.
	SERCOM_I2CS_INTENCLR_AMATCH_Pos = 0x1  // Position of AMATCH field.
	SERCOM_I2CS_INTENCLR_AMATCH_Msk = 0x2  // Bit mask of AMATCH field.
	SERCOM_I2CS_INTENCLR_AMATCH     = 0x2  // Bit AMATCH.
	SERCOM_I2CS_INTENCLR_DRDY_Pos   = 0x2  // Position of DRDY field.
	SERCOM_I2CS_INTENCLR_DRDY_Msk   = 0x4  // Bit mask of DRDY field.
	SERCOM_I2CS_INTENCLR_DRDY       = 0x4  // Bit DRDY.
	SERCOM_I2CS_INTENCLR_ERROR_Pos  = 0x7  // Position of ERROR field.
	SERCOM_I2CS_INTENCLR_ERROR_Msk  = 0x80 // Bit mask of ERROR field.
	SERCOM_I2CS_INTENCLR_ERROR      = 0x80 // Bit ERROR.

	// INTENSET: I2CS Interrupt Enable Set
	SERCOM_I2CS_INTENSET_PREC_Pos   = 0x0  // Position of PREC field.
	SERCOM_I2CS_INTENSET_PREC_Msk   = 0x1  // Bit mask of PREC field.
	SERCOM_I2CS_INTENSET_PREC       = 0x1  // Bit PREC.
	SERCOM_I2CS_INTENSET_AMATCH_Pos = 0x1  // Position of AMATCH field.
	SERCOM_I2CS_INTENSET_AMATCH_Msk = 0x2  // Bit mask of AMATCH field.
	SERCOM_I2CS_INTENSET_AMATCH     = 0x2  // Bit AMATCH.
	SERCOM_I2CS_INTENSET_DRDY_Pos   = 0x2  // Position of DRDY field.
	SERCOM_I2CS_INTENSET_DRDY_Msk   = 0x4  // Bit mask of DRDY field.
	SERCOM_I2CS_INTENSET_DRDY       = 0x4  // Bit DRDY.
	SERCOM_I2CS_INTENSET_ERROR_Pos  = 0x7  // Position of ERROR field.
	SERCOM_I2CS_INTENSET_ERROR_Msk  = 0x80 // Bit mask of ERROR field.
	SERCOM_I2CS_INTENSET_ERROR      = 0x80 // Bit ERROR.

	// INTFLAG: I2CS Interrupt Flag Status and Clear
	SERCOM_I2CS_INTFLAG_PREC_Pos   = 0x0  // Position of PREC field.
	SERCOM_I2CS_INTFLAG_PREC_Msk   = 0x1  // Bit mask of PREC field.
	SERCOM_I2CS_INTFLAG_PREC       = 0x1  // Bit PREC.
	SERCOM_I2CS_INTFLAG_AMATCH_Pos = 0x1  // Position of AMATCH field.
	SERCOM_I2CS_INTFLAG_AMATCH_Msk = 0x2  // Bit mask of AMATCH field.
	SERCOM_I2CS_INTFLAG_AMATCH     = 0x2  // Bit AMATCH.
	SERCOM_I2CS_INTFLAG_DRDY_Pos   = 0x2  // Position of DRDY field.
	SERCOM_I2CS_INTFLAG_DRDY_Msk   = 0x4  // Bit mask of DRDY field.
	SERCOM_I2CS_INTFLAG_DRDY       = 0x4  // Bit DRDY.
	SERCOM_I2CS_INTFLAG_ERROR_Pos  = 0x7  // Position of ERROR field.
	SERCOM_I2CS_INTFLAG_ERROR_Msk  = 0x80 // Bit mask of ERROR field.
	SERCOM_I2CS_INTFLAG_ERROR      = 0x80 // Bit ERROR.

	// STATUS: I2CS Status
	SERCOM_I2CS_STATUS_BUSERR_Pos   = 0x0   // Position of BUSERR field.
	SERCOM_I2CS_STATUS_BUSERR_Msk   = 0x1   // Bit mask of BUSERR field.
	SERCOM_I2CS_STATUS_BUSERR       = 0x1   // Bit BUSERR.
	SERCOM_I2CS_STATUS_COLL_Pos     = 0x1   // Position of COLL field.
	SERCOM_I2CS_STATUS_COLL_Msk     = 0x2   // Bit mask of COLL field.
	SERCOM_I2CS_STATUS_COLL         = 0x2   // Bit COLL.
	SERCOM_I2CS_STATUS_RXNACK_Pos   = 0x2   // Position of RXNACK field.
	SERCOM_I2CS_STATUS_RXNACK_Msk   = 0x4   // Bit mask of RXNACK field.
	SERCOM_I2CS_STATUS_RXNACK       = 0x4   // Bit RXNACK.
	SERCOM_I2CS_STATUS_DIR_Pos      = 0x3   // Position of DIR field.
	SERCOM_I2CS_STATUS_DIR_Msk      = 0x8   // Bit mask of DIR field.
	SERCOM_I2CS_STATUS_DIR          = 0x8   // Bit DIR.
	SERCOM_I2CS_STATUS_SR_Pos       = 0x4   // Position of SR field.
	SERCOM_I2CS_STATUS_SR_Msk       = 0x10  // Bit mask of SR field.
	SERCOM_I2CS_STATUS_SR           = 0x10  // Bit SR.
	SERCOM_I2CS_STATUS_LOWTOUT_Pos  = 0x6   // Position of LOWTOUT field.
	SERCOM_I2CS_STATUS_LOWTOUT_Msk  = 0x40  // Bit mask of LOWTOUT field.
	SERCOM_I2CS_STATUS_LOWTOUT      = 0x40  // Bit LOWTOUT.
	SERCOM_I2CS_STATUS_CLKHOLD_Pos  = 0x7   // Position of CLKHOLD field.
	SERCOM_I2CS_STATUS_CLKHOLD_Msk  = 0x80  // Bit mask of CLKHOLD field.
	SERCOM_I2CS_STATUS_CLKHOLD      = 0x80  // Bit CLKHOLD.
	SERCOM_I2CS_STATUS_SEXTTOUT_Pos = 0x9   // Position of SEXTTOUT field.
	SERCOM_I2CS_STATUS_SEXTTOUT_Msk = 0x200 // Bit mask of SEXTTOUT field.
	SERCOM_I2CS_STATUS_SEXTTOUT     = 0x200 // Bit SEXTTOUT.
	SERCOM_I2CS_STATUS_HS_Pos       = 0xa   // Position of HS field.
	SERCOM_I2CS_STATUS_HS_Msk       = 0x400 // Bit mask of HS field.
	SERCOM_I2CS_STATUS_HS           = 0x400 // Bit HS.

	// SYNCBUSY: I2CS Synchronization Busy
	SERCOM_I2CS_SYNCBUSY_SWRST_Pos  = 0x0 // Position of SWRST field.
	SERCOM_I2CS_SYNCBUSY_SWRST_Msk  = 0x1 // Bit mask of SWRST field.
	SERCOM_I2CS_SYNCBUSY_SWRST      = 0x1 // Bit SWRST.
	SERCOM_I2CS_SYNCBUSY_ENABLE_Pos = 0x1 // Position of ENABLE field.
	SERCOM_I2CS_SYNCBUSY_ENABLE_Msk = 0x2 // Bit mask of ENABLE field.
	SERCOM_I2CS_SYNCBUSY_ENABLE     = 0x2 // Bit ENABLE.

	// ADDR: I2CS Address
	SERCOM_I2CS_ADDR_GENCEN_Pos   = 0x0       // Position of GENCEN field.
	SERCOM_I2CS_ADDR_GENCEN_Msk   = 0x1       // Bit mask of GENCEN field.
	SERCOM_I2CS_ADDR_GENCEN       = 0x1       // Bit GENCEN.
	SERCOM_I2CS_ADDR_ADDR_Pos     = 0x1       // Position of ADDR field.
	SERCOM_I2CS_ADDR_ADDR_Msk     = 0x7fe     // Bit mask of ADDR field.
	SERCOM_I2CS_ADDR_TENBITEN_Pos = 0xf       // Position of TENBITEN field.
	SERCOM_I2CS_ADDR_TENBITEN_Msk = 0x8000    // Bit mask of TENBITEN field.
	SERCOM_I2CS_ADDR_TENBITEN     = 0x8000    // Bit TENBITEN.
	SERCOM_I2CS_ADDR_ADDRMASK_Pos = 0x11      // Position of ADDRMASK field.
	SERCOM_I2CS_ADDR_ADDRMASK_Msk = 0x7fe0000 // Bit mask of ADDRMASK field.

	// DATA: I2CS Data
	SERCOM_I2CS_DATA_DATA_Pos = 0x0  // Position of DATA field.
	SERCOM_I2CS_DATA_DATA_Msk = 0xff // Bit mask of DATA field.
)

// Bitfields for SERCOM0_SPI: Serial Communication Interface 0 - SPI
const (
	// CTRLA: SPI Control A
	SERCOM_SPI_CTRLA_SWRST_Pos          = 0x0        // Position of SWRST field.
	SERCOM_SPI_CTRLA_SWRST_Msk          = 0x1        // Bit mask of SWRST field.
	SERCOM_SPI_CTRLA_SWRST              = 0x1        // Bit SWRST.
	SERCOM_SPI_CTRLA_ENABLE_Pos         = 0x1        // Position of ENABLE field.
	SERCOM_SPI_CTRLA_ENABLE_Msk         = 0x2        // Bit mask of ENABLE field.
	SERCOM_SPI_CTRLA_ENABLE             = 0x2        // Bit ENABLE.
	SERCOM_SPI_CTRLA_MODE_Pos           = 0x2        // Position of MODE field.
	SERCOM_SPI_CTRLA_MODE_Msk           = 0x1c       // Bit mask of MODE field.
	SERCOM_SPI_CTRLA_MODE_USART_EXT_CLK = 0x0        // USART mode with external clock
	SERCOM_SPI_CTRLA_MODE_USART_INT_CLK = 0x1        // USART mode with internal clock
	SERCOM_SPI_CTRLA_MODE_SPI_SLAVE     = 0x2        // SPI mode with external clock
	SERCOM_SPI_CTRLA_MODE_SPI_MASTER    = 0x3        // SPI mode with internal clock
	SERCOM_SPI_CTRLA_MODE_I2C_SLAVE     = 0x4        // I2C mode with external clock
	SERCOM_SPI_CTRLA_MODE_I2C_MASTER    = 0x5        // I2C mode with internal clock
	SERCOM_SPI_CTRLA_RUNSTDBY_Pos       = 0x7        // Position of RUNSTDBY field.
	SERCOM_SPI_CTRLA_RUNSTDBY_Msk       = 0x80       // Bit mask of RUNSTDBY field.
	SERCOM_SPI_CTRLA_RUNSTDBY           = 0x80       // Bit RUNSTDBY.
	SERCOM_SPI_CTRLA_IBON_Pos           = 0x8        // Position of IBON field.
	SERCOM_SPI_CTRLA_IBON_Msk           = 0x100      // Bit mask of IBON field.
	SERCOM_SPI_CTRLA_IBON               = 0x100      // Bit IBON.
	SERCOM_SPI_CTRLA_DOPO_Pos           = 0x10       // Position of DOPO field.
	SERCOM_SPI_CTRLA_DOPO_Msk           = 0x30000    // Bit mask of DOPO field.
	SERCOM_SPI_CTRLA_DIPO_Pos           = 0x14       // Position of DIPO field.
	SERCOM_SPI_CTRLA_DIPO_Msk           = 0x300000   // Bit mask of DIPO field.
	SERCOM_SPI_CTRLA_FORM_Pos           = 0x18       // Position of FORM field.
	SERCOM_SPI_CTRLA_FORM_Msk           = 0xf000000  // Bit mask of FORM field.
	SERCOM_SPI_CTRLA_CPHA_Pos           = 0x1c       // Position of CPHA field.
	SERCOM_SPI_CTRLA_CPHA_Msk           = 0x10000000 // Bit mask of CPHA field.
	SERCOM_SPI_CTRLA_CPHA               = 0x10000000 // Bit CPHA.
	SERCOM_SPI_CTRLA_CPOL_Pos           = 0x1d       // Position of CPOL field.
	SERCOM_SPI_CTRLA_CPOL_Msk           = 0x20000000 // Bit mask of CPOL field.
	SERCOM_SPI_CTRLA_CPOL               = 0x20000000 // Bit CPOL.
	SERCOM_SPI_CTRLA_DORD_Pos           = 0x1e       // Position of DORD field.
	SERCOM_SPI_CTRLA_DORD_Msk           = 0x40000000 // Bit mask of DORD field.
	SERCOM_SPI_CTRLA_DORD               = 0x40000000 // Bit DORD.

	// CTRLB: SPI Control B
	SERCOM_SPI_CTRLB_CHSIZE_Pos  = 0x0     // Position of CHSIZE field.
	SERCOM_SPI_CTRLB_CHSIZE_Msk  = 0x7     // Bit mask of CHSIZE field.
	SERCOM_SPI_CTRLB_PLOADEN_Pos = 0x6     // Position of PLOADEN field.
	SERCOM_SPI_CTRLB_PLOADEN_Msk = 0x40    // Bit mask of PLOADEN field.
	SERCOM_SPI_CTRLB_PLOADEN     = 0x40    // Bit PLOADEN.
	SERCOM_SPI_CTRLB_SSDE_Pos    = 0x9     // Position of SSDE field.
	SERCOM_SPI_CTRLB_SSDE_Msk    = 0x200   // Bit mask of SSDE field.
	SERCOM_SPI_CTRLB_SSDE        = 0x200   // Bit SSDE.
	SERCOM_SPI_CTRLB_MSSEN_Pos   = 0xd     // Position of MSSEN field.
	SERCOM_SPI_CTRLB_MSSEN_Msk   = 0x2000  // Bit mask of MSSEN field.
	SERCOM_SPI_CTRLB_MSSEN       = 0x2000  // Bit MSSEN.
	SERCOM_SPI_CTRLB_AMODE_Pos   = 0xe     // Position of AMODE field.
	SERCOM_SPI_CTRLB_AMODE_Msk   = 0xc000  // Bit mask of AMODE field.
	SERCOM_SPI_CTRLB_RXEN_Pos    = 0x11    // Position of RXEN field.
	SERCOM_SPI_CTRLB_RXEN_Msk    = 0x20000 // Bit mask of RXEN field.
	SERCOM_SPI_CTRLB_RXEN        = 0x20000 // Bit RXEN.

	// BAUD: SPI Baud Rate
	SERCOM_SPI_BAUD_BAUD_Pos = 0x0  // Position of BAUD field.
	SERCOM_SPI_BAUD_BAUD_Msk = 0xff // Bit mask of BAUD field.

	// INTENCLR: SPI Interrupt Enable Clear
	SERCOM_SPI_INTENCLR_DRE_Pos   = 0x0  // Position of DRE field.
	SERCOM_SPI_INTENCLR_DRE_Msk   = 0x1  // Bit mask of DRE field.
	SERCOM_SPI_INTENCLR_DRE       = 0x1  // Bit DRE.
	SERCOM_SPI_INTENCLR_TXC_Pos   = 0x1  // Position of TXC field.
	SERCOM_SPI_INTENCLR_TXC_Msk   = 0x2  // Bit mask of TXC field.
	SERCOM_SPI_INTENCLR_TXC       = 0x2  // Bit TXC.
	SERCOM_SPI_INTENCLR_RXC_Pos   = 0x2  // Position of RXC field.
	SERCOM_SPI_INTENCLR_RXC_Msk   = 0x4  // Bit mask of RXC field.
	SERCOM_SPI_INTENCLR_RXC       = 0x4  // Bit RXC.
	SERCOM_SPI_INTENCLR_SSL_Pos   = 0x3  // Position of SSL field.
	SERCOM_SPI_INTENCLR_SSL_Msk   = 0x8  // Bit mask of SSL field.
	SERCOM_SPI_INTENCLR_SSL       = 0x8  // Bit SSL.
	SERCOM_SPI_INTENCLR_ERROR_Pos = 0x7  // Position of ERROR field.
	SERCOM_SPI_INTENCLR_ERROR_Msk = 0x80 // Bit mask of ERROR field.
	SERCOM_SPI_INTENCLR_ERROR     = 0x80 // Bit ERROR.

	// INTENSET: SPI Interrupt Enable Set
	SERCOM_SPI_INTENSET_DRE_Pos   = 0x0  // Position of DRE field.
	SERCOM_SPI_INTENSET_DRE_Msk   = 0x1  // Bit mask of DRE field.
	SERCOM_SPI_INTENSET_DRE       = 0x1  // Bit DRE.
	SERCOM_SPI_INTENSET_TXC_Pos   = 0x1  // Position of TXC field.
	SERCOM_SPI_INTENSET_TXC_Msk   = 0x2  // Bit mask of TXC field.
	SERCOM_SPI_INTENSET_TXC       = 0x2  // Bit TXC.
	SERCOM_SPI_INTENSET_RXC_Pos   = 0x2  // Position of RXC field.
	SERCOM_SPI_INTENSET_RXC_Msk   = 0x4  // Bit mask of RXC field.
	SERCOM_SPI_INTENSET_RXC       = 0x4  // Bit RXC.
	SERCOM_SPI_INTENSET_SSL_Pos   = 0x3  // Position of SSL field.
	SERCOM_SPI_INTENSET_SSL_Msk   = 0x8  // Bit mask of SSL field.
	SERCOM_SPI_INTENSET_SSL       = 0x8  // Bit SSL.
	SERCOM_SPI_INTENSET_ERROR_Pos = 0x7  // Position of ERROR field.
	SERCOM_SPI_INTENSET_ERROR_Msk = 0x80 // Bit mask of ERROR field.
	SERCOM_SPI_INTENSET_ERROR     = 0x80 // Bit ERROR.

	// INTFLAG: SPI Interrupt Flag Status and Clear
	SERCOM_SPI_INTFLAG_DRE_Pos   = 0x0  // Position of DRE field.
	SERCOM_SPI_INTFLAG_DRE_Msk   = 0x1  // Bit mask of DRE field.
	SERCOM_SPI_INTFLAG_DRE       = 0x1  // Bit DRE.
	SERCOM_SPI_INTFLAG_TXC_Pos   = 0x1  // Position of TXC field.
	SERCOM_SPI_INTFLAG_TXC_Msk   = 0x2  // Bit mask of TXC field.
	SERCOM_SPI_INTFLAG_TXC       = 0x2  // Bit TXC.
	SERCOM_SPI_INTFLAG_RXC_Pos   = 0x2  // Position of RXC field.
	SERCOM_SPI_INTFLAG_RXC_Msk   = 0x4  // Bit mask of RXC field.
	SERCOM_SPI_INTFLAG_RXC       = 0x4  // Bit RXC.
	SERCOM_SPI_INTFLAG_SSL_Pos   = 0x3  // Position of SSL field.
	SERCOM_SPI_INTFLAG_SSL_Msk   = 0x8  // Bit mask of SSL field.
	SERCOM_SPI_INTFLAG_SSL       = 0x8  // Bit SSL.
	SERCOM_SPI_INTFLAG_ERROR_Pos = 0x7  // Position of ERROR field.
	SERCOM_SPI_INTFLAG_ERROR_Msk = 0x80 // Bit mask of ERROR field.
	SERCOM_SPI_INTFLAG_ERROR     = 0x80 // Bit ERROR.

	// STATUS: SPI Status
	SERCOM_SPI_STATUS_BUFOVF_Pos = 0x2 // Position of BUFOVF field.
	SERCOM_SPI_STATUS_BUFOVF_Msk = 0x4 // Bit mask of BUFOVF field.
	SERCOM_SPI_STATUS_BUFOVF     = 0x4 // Bit BUFOVF.

	// SYNCBUSY: SPI Synchronization Busy
	SERCOM_SPI_SYNCBUSY_SWRST_Pos  = 0x0 // Position of SWRST field.
	SERCOM_SPI_SYNCBUSY_SWRST_Msk  = 0x1 // Bit mask of SWRST field.
	SERCOM_SPI_SYNCBUSY_SWRST      = 0x1 // Bit SWRST.
	SERCOM_SPI_SYNCBUSY_ENABLE_Pos = 0x1 // Position of ENABLE field.
	SERCOM_SPI_SYNCBUSY_ENABLE_Msk = 0x2 // Bit mask of ENABLE field.
	SERCOM_SPI_SYNCBUSY_ENABLE     = 0x2 // Bit ENABLE.
	SERCOM_SPI_SYNCBUSY_CTRLB_Pos  = 0x2 // Position of CTRLB field.
	SERCOM_SPI_SYNCBUSY_CTRLB_Msk  = 0x4 // Bit mask of CTRLB field.
	SERCOM_SPI_SYNCBUSY_CTRLB      = 0x4 // Bit CTRLB.

	// ADDR: SPI Address
	SERCOM_SPI_ADDR_ADDR_Pos     = 0x0      // Position of ADDR field.
	SERCOM_SPI_ADDR_ADDR_Msk     = 0xff     // Bit mask of ADDR field.
	SERCOM_SPI_ADDR_ADDRMASK_Pos = 0x10     // Position of ADDRMASK field.
	SERCOM_SPI_ADDR_ADDRMASK_Msk = 0xff0000 // Bit mask of ADDRMASK field.

	// DATA: SPI Data
	SERCOM_SPI_DATA_DATA_Pos = 0x0   // Position of DATA field.
	SERCOM_SPI_DATA_DATA_Msk = 0x1ff // Bit mask of DATA field.

	// DBGCTRL: SPI Debug Control
	SERCOM_SPI_DBGCTRL_DBGSTOP_Pos = 0x0 // Position of DBGSTOP field.
	SERCOM_SPI_DBGCTRL_DBGSTOP_Msk = 0x1 // Bit mask of DBGSTOP field.
	SERCOM_SPI_DBGCTRL_DBGSTOP     = 0x1 // Bit DBGSTOP.
)

// Bitfields for SERCOM0_USART: Serial Communication Interface 0 - USART
const (
	// CTRLA: USART Control A
	SERCOM_USART_CTRLA_SWRST_Pos          = 0x0        // Position of SWRST field.
	SERCOM_USART_CTRLA_SWRST_Msk          = 0x1        // Bit mask of SWRST field.
	SERCOM_USART_CTRLA_SWRST              = 0x1        // Bit SWRST.
	SERCOM_USART_CTRLA_ENABLE_Pos         = 0x1        // Position of ENABLE field.
	SERCOM_USART_CTRLA_ENABLE_Msk         = 0x2        // Bit mask of ENABLE field.
	SERCOM_USART_CTRLA_ENABLE             = 0x2        // Bit ENABLE.
	SERCOM_USART_CTRLA_MODE_Pos           = 0x2        // Position of MODE field.
	SERCOM_USART_CTRLA_MODE_Msk           = 0x1c       // Bit mask of MODE field.
	SERCOM_USART_CTRLA_MODE_USART_EXT_CLK = 0x0        // USART mode with external clock
	SERCOM_USART_CTRLA_MODE_USART_INT_CLK = 0x1        // USART mode with internal clock
	SERCOM_USART_CTRLA_MODE_SPI_SLAVE     = 0x2        // SPI mode with external clock
	SERCOM_USART_CTRLA_MODE_SPI_MASTER    = 0x3        // SPI mode with internal clock
	SERCOM_USART_CTRLA_MODE_I2C_SLAVE     = 0x4        // I2C mode with external clock
	SERCOM_USART_CTRLA_MODE_I2C_MASTER    = 0x5        // I2C mode with internal clock
	SERCOM_USART_CTRLA_RUNSTDBY_Pos       = 0x7        // Position of RUNSTDBY field.
	SERCOM_USART_CTRLA_RUNSTDBY_Msk       = 0x80       // Bit mask of RUNSTDBY field.
	SERCOM_USART_CTRLA_RUNSTDBY           = 0x80       // Bit RUNSTDBY.
	SERCOM_USART_CTRLA_IBON_Pos           = 0x8        // Position of IBON field.
	SERCOM_USART_CTRLA_IBON_Msk           = 0x100      // Bit mask of IBON field.
	SERCOM_USART_CTRLA_IBON               = 0x100      // Bit IBON.
	SERCOM_USART_CTRLA_SAMPR_Pos          = 0xd        // Position of SAMPR field.
	SERCOM_USART_CTRLA_SAMPR_Msk          = 0xe000     // Bit mask of SAMPR field.
	SERCOM_USART_CTRLA_TXPO_Pos           = 0x10       // Position of TXPO field.
	SERCOM_USART_CTRLA_TXPO_Msk           = 0x30000    // Bit mask of TXPO field.
	SERCOM_USART_CTRLA_RXPO_Pos           = 0x14       // Position of RXPO field.
	SERCOM_USART_CTRLA_RXPO_Msk           = 0x300000   // Bit mask of RXPO field.
	SERCOM_USART_CTRLA_SAMPA_Pos          = 0x16       // Position of SAMPA field.
	SERCOM_USART_CTRLA_SAMPA_Msk          = 0xc00000   // Bit mask of SAMPA field.
	SERCOM_USART_CTRLA_FORM_Pos           = 0x18       // Position of FORM field.
	SERCOM_USART_CTRLA_FORM_Msk           = 0xf000000  // Bit mask of FORM field.
	SERCOM_USART_CTRLA_CMODE_Pos          = 0x1c       // Position of CMODE field.
	SERCOM_USART_CTRLA_CMODE_Msk          = 0x10000000 // Bit mask of CMODE field.
	SERCOM_USART_CTRLA_CMODE              = 0x10000000 // Bit CMODE.
	SERCOM_USART_CTRLA_CPOL_Pos           = 0x1d       // Position of CPOL field.
	SERCOM_USART_CTRLA_CPOL_Msk           = 0x20000000 // Bit mask of CPOL field.
	SERCOM_USART_CTRLA_CPOL               = 0x20000000 // Bit CPOL.
	SERCOM_USART_CTRLA_DORD_Pos           = 0x1e       // Position of DORD field.
	SERCOM_USART_CTRLA_DORD_Msk           = 0x40000000 // Bit mask of DORD field.
	SERCOM_USART_CTRLA_DORD               = 0x40000000 // Bit DORD.

	// CTRLB: USART Control B
	SERCOM_USART_CTRLB_CHSIZE_Pos = 0x0     // Position of CHSIZE field.
	SERCOM_USART_CTRLB_CHSIZE_Msk = 0x7     // Bit mask of CHSIZE field.
	SERCOM_USART_CTRLB_SBMODE_Pos = 0x6     // Position of SBMODE field.
	SERCOM_USART_CTRLB_SBMODE_Msk = 0x40    // Bit mask of SBMODE field.
	SERCOM_USART_CTRLB_SBMODE     = 0x40    // Bit SBMODE.
	SERCOM_USART_CTRLB_COLDEN_Pos = 0x8     // Position of COLDEN field.
	SERCOM_USART_CTRLB_COLDEN_Msk = 0x100   // Bit mask of COLDEN field.
	SERCOM_USART_CTRLB_COLDEN     = 0x100   // Bit COLDEN.
	SERCOM_USART_CTRLB_SFDE_Pos   = 0x9     // Position of SFDE field.
	SERCOM_USART_CTRLB_SFDE_Msk   = 0x200   // Bit mask of SFDE field.
	SERCOM_USART_CTRLB_SFDE       = 0x200   // Bit SFDE.
	SERCOM_USART_CTRLB_ENC_Pos    = 0xa     // Position of ENC field.
	SERCOM_USART_CTRLB_ENC_Msk    = 0x400   // Bit mask of ENC field.
	SERCOM_USART_CTRLB_ENC        = 0x400   // Bit ENC.
	SERCOM_USART_CTRLB_PMODE_Pos  = 0xd     // Position of PMODE field.
	SERCOM_USART_CTRLB_PMODE_Msk  = 0x2000  // Bit mask of PMODE field.
	SERCOM_USART_CTRLB_PMODE      = 0x2000  // Bit PMODE.
	SERCOM_USART_CTRLB_TXEN_Pos   = 0x10    // Position of TXEN field.
	SERCOM_USART_CTRLB_TXEN_Msk   = 0x10000 // Bit mask of TXEN field.
	SERCOM_USART_CTRLB_TXEN       = 0x10000 // Bit TXEN.
	SERCOM_USART_CTRLB_RXEN_Pos   = 0x11    // Position of RXEN field.
	SERCOM_USART_CTRLB_RXEN_Msk   = 0x20000 // Bit mask of RXEN field.
	SERCOM_USART_CTRLB_RXEN       = 0x20000 // Bit RXEN.

	// BAUD: USART Baud Rate
	SERCOM_USART_BAUD_BAUD_Pos = 0x0    // Position of BAUD field.
	SERCOM_USART_BAUD_BAUD_Msk = 0xffff // Bit mask of BAUD field.

	// BAUD_FRAC_MODE: USART Baud Rate
	SERCOM_USART_BAUD_FRAC_MODE_BAUD_Pos = 0x0    // Position of BAUD field.
	SERCOM_USART_BAUD_FRAC_MODE_BAUD_Msk = 0x1fff // Bit mask of BAUD field.
	SERCOM_USART_BAUD_FRAC_MODE_FP_Pos   = 0xd    // Position of FP field.
	SERCOM_USART_BAUD_FRAC_MODE_FP_Msk   = 0xe000 // Bit mask of FP field.

	// BAUD_FRACFP_MODE: USART Baud Rate
	SERCOM_USART_BAUD_FRACFP_MODE_BAUD_Pos = 0x0    // Position of BAUD field.
	SERCOM_USART_BAUD_FRACFP_MODE_BAUD_Msk = 0x1fff // Bit mask of BAUD field.
	SERCOM_USART_BAUD_FRACFP_MODE_FP_Pos   = 0xd    // Position of FP field.
	SERCOM_USART_BAUD_FRACFP_MODE_FP_Msk   = 0xe000 // Bit mask of FP field.

	// BAUD_USARTFP_MODE: USART Baud Rate
	SERCOM_USART_BAUD_USARTFP_MODE_BAUD_Pos = 0x0    // Position of BAUD field.
	SERCOM_USART_BAUD_USARTFP_MODE_BAUD_Msk = 0xffff // Bit mask of BAUD field.

	// RXPL: USART Receive Pulse Length
	SERCOM_USART_RXPL_RXPL_Pos = 0x0  // Position of RXPL field.
	SERCOM_USART_RXPL_RXPL_Msk = 0xff // Bit mask of RXPL field.

	// INTENCLR: USART Interrupt Enable Clear
	SERCOM_USART_INTENCLR_DRE_Pos   = 0x0  // Position of DRE field.
	SERCOM_USART_INTENCLR_DRE_Msk   = 0x1  // Bit mask of DRE field.
	SERCOM_USART_INTENCLR_DRE       = 0x1  // Bit DRE.
	SERCOM_USART_INTENCLR_TXC_Pos   = 0x1  // Position of TXC field.
	SERCOM_USART_INTENCLR_TXC_Msk   = 0x2  // Bit mask of TXC field.
	SERCOM_USART_INTENCLR_TXC       = 0x2  // Bit TXC.
	SERCOM_USART_INTENCLR_RXC_Pos   = 0x2  // Position of RXC field.
	SERCOM_USART_INTENCLR_RXC_Msk   = 0x4  // Bit mask of RXC field.
	SERCOM_USART_INTENCLR_RXC       = 0x4  // Bit RXC.
	SERCOM_USART_INTENCLR_RXS_Pos   = 0x3  // Position of RXS field.
	SERCOM_USART_INTENCLR_RXS_Msk   = 0x8  // Bit mask of RXS field.
	SERCOM_USART_INTENCLR_RXS       = 0x8  // Bit RXS.
	SERCOM_USART_INTENCLR_CTSIC_Pos = 0x4  // Position of CTSIC field.
	SERCOM_USART_INTENCLR_CTSIC_Msk = 0x10 // Bit mask of CTSIC field.
	SERCOM_USART_INTENCLR_CTSIC     = 0x10 // Bit CTSIC.
	SERCOM_USART_INTENCLR_RXBRK_Pos = 0x5  // Position of RXBRK field.
	SERCOM_USART_INTENCLR_RXBRK_Msk = 0x20 // Bit mask of RXBRK field.
	SERCOM_USART_INTENCLR_RXBRK     = 0x20 // Bit RXBRK.
	SERCOM_USART_INTENCLR_ERROR_Pos = 0x7  // Position of ERROR field.
	SERCOM_USART_INTENCLR_ERROR_Msk = 0x80 // Bit mask of ERROR field.
	SERCOM_USART_INTENCLR_ERROR     = 0x80 // Bit ERROR.

	// INTENSET: USART Interrupt Enable Set
	SERCOM_USART_INTENSET_DRE_Pos   = 0x0  // Position of DRE field.
	SERCOM_USART_INTENSET_DRE_Msk   = 0x1  // Bit mask of DRE field.
	SERCOM_USART_INTENSET_DRE       = 0x1  // Bit DRE.
	SERCOM_USART_INTENSET_TXC_Pos   = 0x1  // Position of TXC field.
	SERCOM_USART_INTENSET_TXC_Msk   = 0x2  // Bit mask of TXC field.
	SERCOM_USART_INTENSET_TXC       = 0x2  // Bit TXC.
	SERCOM_USART_INTENSET_RXC_Pos   = 0x2  // Position of RXC field.
	SERCOM_USART_INTENSET_RXC_Msk   = 0x4  // Bit mask of RXC field.
	SERCOM_USART_INTENSET_RXC       = 0x4  // Bit RXC.
	SERCOM_USART_INTENSET_RXS_Pos   = 0x3  // Position of RXS field.
	SERCOM_USART_INTENSET_RXS_Msk   = 0x8  // Bit mask of RXS field.
	SERCOM_USART_INTENSET_RXS       = 0x8  // Bit RXS.
	SERCOM_USART_INTENSET_CTSIC_Pos = 0x4  // Position of CTSIC field.
	SERCOM_USART_INTENSET_CTSIC_Msk = 0x10 // Bit mask of CTSIC field.
	SERCOM_USART_INTENSET_CTSIC     = 0x10 // Bit CTSIC.
	SERCOM_USART_INTENSET_RXBRK_Pos = 0x5  // Position of RXBRK field.
	SERCOM_USART_INTENSET_RXBRK_Msk = 0x20 // Bit mask of RXBRK field.
	SERCOM_USART_INTENSET_RXBRK     = 0x20 // Bit RXBRK.
	SERCOM_USART_INTENSET_ERROR_Pos = 0x7  // Position of ERROR field.
	SERCOM_USART_INTENSET_ERROR_Msk = 0x80 // Bit mask of ERROR field.
	SERCOM_USART_INTENSET_ERROR     = 0x80 // Bit ERROR.

	// INTFLAG: USART Interrupt Flag Status and Clear
	SERCOM_USART_INTFLAG_DRE_Pos   = 0x0  // Position of DRE field.
	SERCOM_USART_INTFLAG_DRE_Msk   = 0x1  // Bit mask of DRE field.
	SERCOM_USART_INTFLAG_DRE       = 0x1  // Bit DRE.
	SERCOM_USART_INTFLAG_TXC_Pos   = 0x1  // Position of TXC field.
	SERCOM_USART_INTFLAG_TXC_Msk   = 0x2  // Bit mask of TXC field.
	SERCOM_USART_INTFLAG_TXC       = 0x2  // Bit TXC.
	SERCOM_USART_INTFLAG_RXC_Pos   = 0x2  // Position of RXC field.
	SERCOM_USART_INTFLAG_RXC_Msk   = 0x4  // Bit mask of RXC field.
	SERCOM_USART_INTFLAG_RXC       = 0x4  // Bit RXC.
	SERCOM_USART_INTFLAG_RXS_Pos   = 0x3  // Position of RXS field.
	SERCOM_USART_INTFLAG_RXS_Msk   = 0x8  // Bit mask of RXS field.
	SERCOM_USART_INTFLAG_RXS       = 0x8  // Bit RXS.
	SERCOM_USART_INTFLAG_CTSIC_Pos = 0x4  // Position of CTSIC field.
	SERCOM_USART_INTFLAG_CTSIC_Msk = 0x10 // Bit mask of CTSIC field.
	SERCOM_USART_INTFLAG_CTSIC     = 0x10 // Bit CTSIC.
	SERCOM_USART_INTFLAG_RXBRK_Pos = 0x5  // Position of RXBRK field.
	SERCOM_USART_INTFLAG_RXBRK_Msk = 0x20 // Bit mask of RXBRK field.
	SERCOM_USART_INTFLAG_RXBRK     = 0x20 // Bit RXBRK.
	SERCOM_USART_INTFLAG_ERROR_Pos = 0x7  // Position of ERROR field.
	SERCOM_USART_INTFLAG_ERROR_Msk = 0x80 // Bit mask of ERROR field.
	SERCOM_USART_INTFLAG_ERROR     = 0x80 // Bit ERROR.

	// STATUS: USART Status
	SERCOM_USART_STATUS_PERR_Pos   = 0x0  // Position of PERR field.
	SERCOM_USART_STATUS_PERR_Msk   = 0x1  // Bit mask of PERR field.
	SERCOM_USART_STATUS_PERR       = 0x1  // Bit PERR.
	SERCOM_USART_STATUS_FERR_Pos   = 0x1  // Position of FERR field.
	SERCOM_USART_STATUS_FERR_Msk   = 0x2  // Bit mask of FERR field.
	SERCOM_USART_STATUS_FERR       = 0x2  // Bit FERR.
	SERCOM_USART_STATUS_BUFOVF_Pos = 0x2  // Position of BUFOVF field.
	SERCOM_USART_STATUS_BUFOVF_Msk = 0x4  // Bit mask of BUFOVF field.
	SERCOM_USART_STATUS_BUFOVF     = 0x4  // Bit BUFOVF.
	SERCOM_USART_STATUS_CTS_Pos    = 0x3  // Position of CTS field.
	SERCOM_USART_STATUS_CTS_Msk    = 0x8  // Bit mask of CTS field.
	SERCOM_USART_STATUS_CTS        = 0x8  // Bit CTS.
	SERCOM_USART_STATUS_ISF_Pos    = 0x4  // Position of ISF field.
	SERCOM_USART_STATUS_ISF_Msk    = 0x10 // Bit mask of ISF field.
	SERCOM_USART_STATUS_ISF        = 0x10 // Bit ISF.
	SERCOM_USART_STATUS_COLL_Pos   = 0x5  // Position of COLL field.
	SERCOM_USART_STATUS_COLL_Msk   = 0x20 // Bit mask of COLL field.
	SERCOM_USART_STATUS_COLL       = 0x20 // Bit COLL.

	// SYNCBUSY: USART Synchronization Busy
	SERCOM_USART_SYNCBUSY_SWRST_Pos  = 0x0 // Position of SWRST field.
	SERCOM_USART_SYNCBUSY_SWRST_Msk  = 0x1 // Bit mask of SWRST field.
	SERCOM_USART_SYNCBUSY_SWRST      = 0x1 // Bit SWRST.
	SERCOM_USART_SYNCBUSY_ENABLE_Pos = 0x1 // Position of ENABLE field.
	SERCOM_USART_SYNCBUSY_ENABLE_Msk = 0x2 // Bit mask of ENABLE field.
	SERCOM_USART_SYNCBUSY_ENABLE     = 0x2 // Bit ENABLE.
	SERCOM_USART_SYNCBUSY_CTRLB_Pos  = 0x2 // Position of CTRLB field.
	SERCOM_USART_SYNCBUSY_CTRLB_Msk  = 0x4 // Bit mask of CTRLB field.
	SERCOM_USART_SYNCBUSY_CTRLB      = 0x4 // Bit CTRLB.

	// DATA: USART Data
	SERCOM_USART_DATA_DATA_Pos = 0x0   // Position of DATA field.
	SERCOM_USART_DATA_DATA_Msk = 0x1ff // Bit mask of DATA field.

	// DBGCTRL: USART Debug Control
	SERCOM_USART_DBGCTRL_DBGSTOP_Pos = 0x0 // Position of DBGSTOP field.
	SERCOM_USART_DBGCTRL_DBGSTOP_Msk = 0x1 // Bit mask of DBGSTOP field.
	SERCOM_USART_DBGCTRL_DBGSTOP     = 0x1 // Bit DBGSTOP.
)

// Bitfields for SYSCTRL: System Control
const (
	// INTENCLR: Interrupt Enable Clear
	SYSCTRL_INTENCLR_XOSCRDY_Pos    = 0x0     // Position of XOSCRDY field.
	SYSCTRL_INTENCLR_XOSCRDY_Msk    = 0x1     // Bit mask of XOSCRDY field.
	SYSCTRL_INTENCLR_XOSCRDY        = 0x1     // Bit XOSCRDY.
	SYSCTRL_INTENCLR_XOSC32KRDY_Pos = 0x1     // Position of XOSC32KRDY field.
	SYSCTRL_INTENCLR_XOSC32KRDY_Msk = 0x2     // Bit mask of XOSC32KRDY field.
	SYSCTRL_INTENCLR_XOSC32KRDY     = 0x2     // Bit XOSC32KRDY.
	SYSCTRL_INTENCLR_OSC32KRDY_Pos  = 0x2     // Position of OSC32KRDY field.
	SYSCTRL_INTENCLR_OSC32KRDY_Msk  = 0x4     // Bit mask of OSC32KRDY field.
	SYSCTRL_INTENCLR_OSC32KRDY      = 0x4     // Bit OSC32KRDY.
	SYSCTRL_INTENCLR_OSC8MRDY_Pos   = 0x3     // Position of OSC8MRDY field.
	SYSCTRL_INTENCLR_OSC8MRDY_Msk   = 0x8     // Bit mask of OSC8MRDY field.
	SYSCTRL_INTENCLR_OSC8MRDY       = 0x8     // Bit OSC8MRDY.
	SYSCTRL_INTENCLR_DFLLRDY_Pos    = 0x4     // Position of DFLLRDY field.
	SYSCTRL_INTENCLR_DFLLRDY_Msk    = 0x10    // Bit mask of DFLLRDY field.
	SYSCTRL_INTENCLR_DFLLRDY        = 0x10    // Bit DFLLRDY.
	SYSCTRL_INTENCLR_DFLLOOB_Pos    = 0x5     // Position of DFLLOOB field.
	SYSCTRL_INTENCLR_DFLLOOB_Msk    = 0x20    // Bit mask of DFLLOOB field.
	SYSCTRL_INTENCLR_DFLLOOB        = 0x20    // Bit DFLLOOB.
	SYSCTRL_INTENCLR_DFLLLCKF_Pos   = 0x6     // Position of DFLLLCKF field.
	SYSCTRL_INTENCLR_DFLLLCKF_Msk   = 0x40    // Bit mask of DFLLLCKF field.
	SYSCTRL_INTENCLR_DFLLLCKF       = 0x40    // Bit DFLLLCKF.
	SYSCTRL_INTENCLR_DFLLLCKC_Pos   = 0x7     // Position of DFLLLCKC field.
	SYSCTRL_INTENCLR_DFLLLCKC_Msk   = 0x80    // Bit mask of DFLLLCKC field.
	SYSCTRL_INTENCLR_DFLLLCKC       = 0x80    // Bit DFLLLCKC.
	SYSCTRL_INTENCLR_DFLLRCS_Pos    = 0x8     // Position of DFLLRCS field.
	SYSCTRL_INTENCLR_DFLLRCS_Msk    = 0x100   // Bit mask of DFLLRCS field.
	SYSCTRL_INTENCLR_DFLLRCS        = 0x100   // Bit DFLLRCS.
	SYSCTRL_INTENCLR_BOD33RDY_Pos   = 0x9     // Position of BOD33RDY field.
	SYSCTRL_INTENCLR_BOD33RDY_Msk   = 0x200   // Bit mask of BOD33RDY field.
	SYSCTRL_INTENCLR_BOD33RDY       = 0x200   // Bit BOD33RDY.
	SYSCTRL_INTENCLR_BOD33DET_Pos   = 0xa     // Position of BOD33DET field.
	SYSCTRL_INTENCLR_BOD33DET_Msk   = 0x400   // Bit mask of BOD33DET field.
	SYSCTRL_INTENCLR_BOD33DET       = 0x400   // Bit BOD33DET.
	SYSCTRL_INTENCLR_B33SRDY_Pos    = 0xb     // Position of B33SRDY field.
	SYSCTRL_INTENCLR_B33SRDY_Msk    = 0x800   // Bit mask of B33SRDY field.
	SYSCTRL_INTENCLR_B33SRDY        = 0x800   // Bit B33SRDY.
	SYSCTRL_INTENCLR_DPLLLCKR_Pos   = 0xf     // Position of DPLLLCKR field.
	SYSCTRL_INTENCLR_DPLLLCKR_Msk   = 0x8000  // Bit mask of DPLLLCKR field.
	SYSCTRL_INTENCLR_DPLLLCKR       = 0x8000  // Bit DPLLLCKR.
	SYSCTRL_INTENCLR_DPLLLCKF_Pos   = 0x10    // Position of DPLLLCKF field.
	SYSCTRL_INTENCLR_DPLLLCKF_Msk   = 0x10000 // Bit mask of DPLLLCKF field.
	SYSCTRL_INTENCLR_DPLLLCKF       = 0x10000 // Bit DPLLLCKF.
	SYSCTRL_INTENCLR_DPLLLTO_Pos    = 0x11    // Position of DPLLLTO field.
	SYSCTRL_INTENCLR_DPLLLTO_Msk    = 0x20000 // Bit mask of DPLLLTO field.
	SYSCTRL_INTENCLR_DPLLLTO        = 0x20000 // Bit DPLLLTO.

	// INTENSET: Interrupt Enable Set
	SYSCTRL_INTENSET_XOSCRDY_Pos    = 0x0     // Position of XOSCRDY field.
	SYSCTRL_INTENSET_XOSCRDY_Msk    = 0x1     // Bit mask of XOSCRDY field.
	SYSCTRL_INTENSET_XOSCRDY        = 0x1     // Bit XOSCRDY.
	SYSCTRL_INTENSET_XOSC32KRDY_Pos = 0x1     // Position of XOSC32KRDY field.
	SYSCTRL_INTENSET_XOSC32KRDY_Msk = 0x2     // Bit mask of XOSC32KRDY field.
	SYSCTRL_INTENSET_XOSC32KRDY     = 0x2     // Bit XOSC32KRDY.
	SYSCTRL_INTENSET_OSC32KRDY_Pos  = 0x2     // Position of OSC32KRDY field.
	SYSCTRL_INTENSET_OSC32KRDY_Msk  = 0x4     // Bit mask of OSC32KRDY field.
	SYSCTRL_INTENSET_OSC32KRDY      = 0x4     // Bit OSC32KRDY.
	SYSCTRL_INTENSET_OSC8MRDY_Pos   = 0x3     // Position of OSC8MRDY field.
	SYSCTRL_INTENSET_OSC8MRDY_Msk   = 0x8     // Bit mask of OSC8MRDY field.
	SYSCTRL_INTENSET_OSC8MRDY       = 0x8     // Bit OSC8MRDY.
	SYSCTRL_INTENSET_DFLLRDY_Pos    = 0x4     // Position of DFLLRDY field.
	SYSCTRL_INTENSET_DFLLRDY_Msk    = 0x10    // Bit mask of DFLLRDY field.
	SYSCTRL_INTENSET_DFLLRDY        = 0x10    // Bit DFLLRDY.
	SYSCTRL_INTENSET_DFLLOOB_Pos    = 0x5     // Position of DFLLOOB field.
	SYSCTRL_INTENSET_DFLLOOB_Msk    = 0x20    // Bit mask of DFLLOOB field.
	SYSCTRL_INTENSET_DFLLOOB        = 0x20    // Bit DFLLOOB.
	SYSCTRL_INTENSET_DFLLLCKF_Pos   = 0x6     // Position of DFLLLCKF field.
	SYSCTRL_INTENSET_DFLLLCKF_Msk   = 0x40    // Bit mask of DFLLLCKF field.
	SYSCTRL_INTENSET_DFLLLCKF       = 0x40    // Bit DFLLLCKF.
	SYSCTRL_INTENSET_DFLLLCKC_Pos   = 0x7     // Position of DFLLLCKC field.
	SYSCTRL_INTENSET_DFLLLCKC_Msk   = 0x80    // Bit mask of DFLLLCKC field.
	SYSCTRL_INTENSET_DFLLLCKC       = 0x80    // Bit DFLLLCKC.
	SYSCTRL_INTENSET_DFLLRCS_Pos    = 0x8     // Position of DFLLRCS field.
	SYSCTRL_INTENSET_DFLLRCS_Msk    = 0x100   // Bit mask of DFLLRCS field.
	SYSCTRL_INTENSET_DFLLRCS        = 0x100   // Bit DFLLRCS.
	SYSCTRL_INTENSET_BOD33RDY_Pos   = 0x9     // Position of BOD33RDY field.
	SYSCTRL_INTENSET_BOD33RDY_Msk   = 0x200   // Bit mask of BOD33RDY field.
	SYSCTRL_INTENSET_BOD33RDY       = 0x200   // Bit BOD33RDY.
	SYSCTRL_INTENSET_BOD33DET_Pos   = 0xa     // Position of BOD33DET field.
	SYSCTRL_INTENSET_BOD33DET_Msk   = 0x400   // Bit mask of BOD33DET field.
	SYSCTRL_INTENSET_BOD33DET       = 0x400   // Bit BOD33DET.
	SYSCTRL_INTENSET_B33SRDY_Pos    = 0xb     // Position of B33SRDY field.
	SYSCTRL_INTENSET_B33SRDY_Msk    = 0x800   // Bit mask of B33SRDY field.
	SYSCTRL_INTENSET_B33SRDY        = 0x800   // Bit B33SRDY.
	SYSCTRL_INTENSET_DPLLLCKR_Pos   = 0xf     // Position of DPLLLCKR field.
	SYSCTRL_INTENSET_DPLLLCKR_Msk   = 0x8000  // Bit mask of DPLLLCKR field.
	SYSCTRL_INTENSET_DPLLLCKR       = 0x8000  // Bit DPLLLCKR.
	SYSCTRL_INTENSET_DPLLLCKF_Pos   = 0x10    // Position of DPLLLCKF field.
	SYSCTRL_INTENSET_DPLLLCKF_Msk   = 0x10000 // Bit mask of DPLLLCKF field.
	SYSCTRL_INTENSET_DPLLLCKF       = 0x10000 // Bit DPLLLCKF.
	SYSCTRL_INTENSET_DPLLLTO_Pos    = 0x11    // Position of DPLLLTO field.
	SYSCTRL_INTENSET_DPLLLTO_Msk    = 0x20000 // Bit mask of DPLLLTO field.
	SYSCTRL_INTENSET_DPLLLTO        = 0x20000 // Bit DPLLLTO.

	// INTFLAG: Interrupt Flag Status and Clear
	SYSCTRL_INTFLAG_XOSCRDY_Pos    = 0x0     // Position of XOSCRDY field.
	SYSCTRL_INTFLAG_XOSCRDY_Msk    = 0x1     // Bit mask of XOSCRDY field.
	SYSCTRL_INTFLAG_XOSCRDY        = 0x1     // Bit XOSCRDY.
	SYSCTRL_INTFLAG_XOSC32KRDY_Pos = 0x1     // Position of XOSC32KRDY field.
	SYSCTRL_INTFLAG_XOSC32KRDY_Msk = 0x2     // Bit mask of XOSC32KRDY field.
	SYSCTRL_INTFLAG_XOSC32KRDY     = 0x2     // Bit XOSC32KRDY.
	SYSCTRL_INTFLAG_OSC32KRDY_Pos  = 0x2     // Position of OSC32KRDY field.
	SYSCTRL_INTFLAG_OSC32KRDY_Msk  = 0x4     // Bit mask of OSC32KRDY field.
	SYSCTRL_INTFLAG_OSC32KRDY      = 0x4     // Bit OSC32KRDY.
	SYSCTRL_INTFLAG_OSC8MRDY_Pos   = 0x3     // Position of OSC8MRDY field.
	SYSCTRL_INTFLAG_OSC8MRDY_Msk   = 0x8     // Bit mask of OSC8MRDY field.
	SYSCTRL_INTFLAG_OSC8MRDY       = 0x8     // Bit OSC8MRDY.
	SYSCTRL_INTFLAG_DFLLRDY_Pos    = 0x4     // Position of DFLLRDY field.
	SYSCTRL_INTFLAG_DFLLRDY_Msk    = 0x10    // Bit mask of DFLLRDY field.
	SYSCTRL_INTFLAG_DFLLRDY        = 0x10    // Bit DFLLRDY.
	SYSCTRL_INTFLAG_DFLLOOB_Pos    = 0x5     // Position of DFLLOOB field.
	SYSCTRL_INTFLAG_DFLLOOB_Msk    = 0x20    // Bit mask of DFLLOOB field.
	SYSCTRL_INTFLAG_DFLLOOB        = 0x20    // Bit DFLLOOB.
	SYSCTRL_INTFLAG_DFLLLCKF_Pos   = 0x6     // Position of DFLLLCKF field.
	SYSCTRL_INTFLAG_DFLLLCKF_Msk   = 0x40    // Bit mask of DFLLLCKF field.
	SYSCTRL_INTFLAG_DFLLLCKF       = 0x40    // Bit DFLLLCKF.
	SYSCTRL_INTFLAG_DFLLLCKC_Pos   = 0x7     // Position of DFLLLCKC field.
	SYSCTRL_INTFLAG_DFLLLCKC_Msk   = 0x80    // Bit mask of DFLLLCKC field.
	SYSCTRL_INTFLAG_DFLLLCKC       = 0x80    // Bit DFLLLCKC.
	SYSCTRL_INTFLAG_DFLLRCS_Pos    = 0x8     // Position of DFLLRCS field.
	SYSCTRL_INTFLAG_DFLLRCS_Msk    = 0x100   // Bit mask of DFLLRCS field.
	SYSCTRL_INTFLAG_DFLLRCS        = 0x100   // Bit DFLLRCS.
	SYSCTRL_INTFLAG_BOD33RDY_Pos   = 0x9     // Position of BOD33RDY field.
	SYSCTRL_INTFLAG_BOD33RDY_Msk   = 0x200   // Bit mask of BOD33RDY field.
	SYSCTRL_INTFLAG_BOD33RDY       = 0x200   // Bit BOD33RDY.
	SYSCTRL_INTFLAG_BOD33DET_Pos   = 0xa     // Position of BOD33DET field.
	SYSCTRL_INTFLAG_BOD33DET_Msk   = 0x400   // Bit mask of BOD33DET field.
	SYSCTRL_INTFLAG_BOD33DET       = 0x400   // Bit BOD33DET.
	SYSCTRL_INTFLAG_B33SRDY_Pos    = 0xb     // Position of B33SRDY field.
	SYSCTRL_INTFLAG_B33SRDY_Msk    = 0x800   // Bit mask of B33SRDY field.
	SYSCTRL_INTFLAG_B33SRDY        = 0x800   // Bit B33SRDY.
	SYSCTRL_INTFLAG_DPLLLCKR_Pos   = 0xf     // Position of DPLLLCKR field.
	SYSCTRL_INTFLAG_DPLLLCKR_Msk   = 0x8000  // Bit mask of DPLLLCKR field.
	SYSCTRL_INTFLAG_DPLLLCKR       = 0x8000  // Bit DPLLLCKR.
	SYSCTRL_INTFLAG_DPLLLCKF_Pos   = 0x10    // Position of DPLLLCKF field.
	SYSCTRL_INTFLAG_DPLLLCKF_Msk   = 0x10000 // Bit mask of DPLLLCKF field.
	SYSCTRL_INTFLAG_DPLLLCKF       = 0x10000 // Bit DPLLLCKF.
	SYSCTRL_INTFLAG_DPLLLTO_Pos    = 0x11    // Position of DPLLLTO field.
	SYSCTRL_INTFLAG_DPLLLTO_Msk    = 0x20000 // Bit mask of DPLLLTO field.
	SYSCTRL_INTFLAG_DPLLLTO        = 0x20000 // Bit DPLLLTO.

	// PCLKSR: Power and Clocks Status
	SYSCTRL_PCLKSR_XOSCRDY_Pos    = 0x0     // Position of XOSCRDY field.
	SYSCTRL_PCLKSR_XOSCRDY_Msk    = 0x1     // Bit mask of XOSCRDY field.
	SYSCTRL_PCLKSR_XOSCRDY        = 0x1     // Bit XOSCRDY.
	SYSCTRL_PCLKSR_XOSC32KRDY_Pos = 0x1     // Position of XOSC32KRDY field.
	SYSCTRL_PCLKSR_XOSC32KRDY_Msk = 0x2     // Bit mask of XOSC32KRDY field.
	SYSCTRL_PCLKSR_XOSC32KRDY     = 0x2     // Bit XOSC32KRDY.
	SYSCTRL_PCLKSR_OSC32KRDY_Pos  = 0x2     // Position of OSC32KRDY field.
	SYSCTRL_PCLKSR_OSC32KRDY_Msk  = 0x4     // Bit mask of OSC32KRDY field.
	SYSCTRL_PCLKSR_OSC32KRDY      = 0x4     // Bit OSC32KRDY.
	SYSCTRL_PCLKSR_OSC8MRDY_Pos   = 0x3     // Position of OSC8MRDY field.
	SYSCTRL_PCLKSR_OSC8MRDY_Msk   = 0x8     // Bit mask of OSC8MRDY field.
	SYSCTRL_PCLKSR_OSC8MRDY       = 0x8     // Bit OSC8MRDY.
	SYSCTRL_PCLKSR_DFLLRDY_Pos    = 0x4     // Position of DFLLRDY field.
	SYSCTRL_PCLKSR_DFLLRDY_Msk    = 0x10    // Bit mask of DFLLRDY field.
	SYSCTRL_PCLKSR_DFLLRDY        = 0x10    // Bit DFLLRDY.
	SYSCTRL_PCLKSR_DFLLOOB_Pos    = 0x5     // Position of DFLLOOB field.
	SYSCTRL_PCLKSR_DFLLOOB_Msk    = 0x20    // Bit mask of DFLLOOB field.
	SYSCTRL_PCLKSR_DFLLOOB        = 0x20    // Bit DFLLOOB.
	SYSCTRL_PCLKSR_DFLLLCKF_Pos   = 0x6     // Position of DFLLLCKF field.
	SYSCTRL_PCLKSR_DFLLLCKF_Msk   = 0x40    // Bit mask of DFLLLCKF field.
	SYSCTRL_PCLKSR_DFLLLCKF       = 0x40    // Bit DFLLLCKF.
	SYSCTRL_PCLKSR_DFLLLCKC_Pos   = 0x7     // Position of DFLLLCKC field.
	SYSCTRL_PCLKSR_DFLLLCKC_Msk   = 0x80    // Bit mask of DFLLLCKC field.
	SYSCTRL_PCLKSR_DFLLLCKC       = 0x80    // Bit DFLLLCKC.
	SYSCTRL_PCLKSR_DFLLRCS_Pos    = 0x8     // Position of DFLLRCS field.
	SYSCTRL_PCLKSR_DFLLRCS_Msk    = 0x100   // Bit mask of DFLLRCS field.
	SYSCTRL_PCLKSR_DFLLRCS        = 0x100   // Bit DFLLRCS.
	SYSCTRL_PCLKSR_BOD33RDY_Pos   = 0x9     // Position of BOD33RDY field.
	SYSCTRL_PCLKSR_BOD33RDY_Msk   = 0x200   // Bit mask of BOD33RDY field.
	SYSCTRL_PCLKSR_BOD33RDY       = 0x200   // Bit BOD33RDY.
	SYSCTRL_PCLKSR_BOD33DET_Pos   = 0xa     // Position of BOD33DET field.
	SYSCTRL_PCLKSR_BOD33DET_Msk   = 0x400   // Bit mask of BOD33DET field.
	SYSCTRL_PCLKSR_BOD33DET       = 0x400   // Bit BOD33DET.
	SYSCTRL_PCLKSR_B33SRDY_Pos    = 0xb     // Position of B33SRDY field.
	SYSCTRL_PCLKSR_B33SRDY_Msk    = 0x800   // Bit mask of B33SRDY field.
	SYSCTRL_PCLKSR_B33SRDY        = 0x800   // Bit B33SRDY.
	SYSCTRL_PCLKSR_DPLLLCKR_Pos   = 0xf     // Position of DPLLLCKR field.
	SYSCTRL_PCLKSR_DPLLLCKR_Msk   = 0x8000  // Bit mask of DPLLLCKR field.
	SYSCTRL_PCLKSR_DPLLLCKR       = 0x8000  // Bit DPLLLCKR.
	SYSCTRL_PCLKSR_DPLLLCKF_Pos   = 0x10    // Position of DPLLLCKF field.
	SYSCTRL_PCLKSR_DPLLLCKF_Msk   = 0x10000 // Bit mask of DPLLLCKF field.
	SYSCTRL_PCLKSR_DPLLLCKF       = 0x10000 // Bit DPLLLCKF.
	SYSCTRL_PCLKSR_DPLLLTO_Pos    = 0x11    // Position of DPLLLTO field.
	SYSCTRL_PCLKSR_DPLLLTO_Msk    = 0x20000 // Bit mask of DPLLLTO field.
	SYSCTRL_PCLKSR_DPLLLTO        = 0x20000 // Bit DPLLLTO.

	// XOSC: External Multipurpose Crystal Oscillator (XOSC) Control
	SYSCTRL_XOSC_ENABLE_Pos   = 0x1    // Position of ENABLE field.
	SYSCTRL_XOSC_ENABLE_Msk   = 0x2    // Bit mask of ENABLE field.
	SYSCTRL_XOSC_ENABLE       = 0x2    // Bit ENABLE.
	SYSCTRL_XOSC_XTALEN_Pos   = 0x2    // Position of XTALEN field.
	SYSCTRL_XOSC_XTALEN_Msk   = 0x4    // Bit mask of XTALEN field.
	SYSCTRL_XOSC_XTALEN       = 0x4    // Bit XTALEN.
	SYSCTRL_XOSC_RUNSTDBY_Pos = 0x6    // Position of RUNSTDBY field.
	SYSCTRL_XOSC_RUNSTDBY_Msk = 0x40   // Bit mask of RUNSTDBY field.
	SYSCTRL_XOSC_RUNSTDBY     = 0x40   // Bit RUNSTDBY.
	SYSCTRL_XOSC_ONDEMAND_Pos = 0x7    // Position of ONDEMAND field.
	SYSCTRL_XOSC_ONDEMAND_Msk = 0x80   // Bit mask of ONDEMAND field.
	SYSCTRL_XOSC_ONDEMAND     = 0x80   // Bit ONDEMAND.
	SYSCTRL_XOSC_GAIN_Pos     = 0x8    // Position of GAIN field.
	SYSCTRL_XOSC_GAIN_Msk     = 0x700  // Bit mask of GAIN field.
	SYSCTRL_XOSC_GAIN_0       = 0x0    // 2MHz
	SYSCTRL_XOSC_GAIN_1       = 0x1    // 4MHz
	SYSCTRL_XOSC_GAIN_2       = 0x2    // 8MHz
	SYSCTRL_XOSC_GAIN_3       = 0x3    // 16MHz
	SYSCTRL_XOSC_GAIN_4       = 0x4    // 30MHz
	SYSCTRL_XOSC_AMPGC_Pos    = 0xb    // Position of AMPGC field.
	SYSCTRL_XOSC_AMPGC_Msk    = 0x800  // Bit mask of AMPGC field.
	SYSCTRL_XOSC_AMPGC        = 0x800  // Bit AMPGC.
	SYSCTRL_XOSC_STARTUP_Pos  = 0xc    // Position of STARTUP field.
	SYSCTRL_XOSC_STARTUP_Msk  = 0xf000 // Bit mask of STARTUP field.

	// XOSC32K: 32kHz External Crystal Oscillator (XOSC32K) Control
	SYSCTRL_XOSC32K_ENABLE_Pos   = 0x1    // Position of ENABLE field.
	SYSCTRL_XOSC32K_ENABLE_Msk   = 0x2    // Bit mask of ENABLE field.
	SYSCTRL_XOSC32K_ENABLE       = 0x2    // Bit ENABLE.
	SYSCTRL_XOSC32K_XTALEN_Pos   = 0x2    // Position of XTALEN field.
	SYSCTRL_XOSC32K_XTALEN_Msk   = 0x4    // Bit mask of XTALEN field.
	SYSCTRL_XOSC32K_XTALEN       = 0x4    // Bit XTALEN.
	SYSCTRL_XOSC32K_EN32K_Pos    = 0x3    // Position of EN32K field.
	SYSCTRL_XOSC32K_EN32K_Msk    = 0x8    // Bit mask of EN32K field.
	SYSCTRL_XOSC32K_EN32K        = 0x8    // Bit EN32K.
	SYSCTRL_XOSC32K_EN1K_Pos     = 0x4    // Position of EN1K field.
	SYSCTRL_XOSC32K_EN1K_Msk     = 0x10   // Bit mask of EN1K field.
	SYSCTRL_XOSC32K_EN1K         = 0x10   // Bit EN1K.
	SYSCTRL_XOSC32K_AAMPEN_Pos   = 0x5    // Position of AAMPEN field.
	SYSCTRL_XOSC32K_AAMPEN_Msk   = 0x20   // Bit mask of AAMPEN field.
	SYSCTRL_XOSC32K_AAMPEN       = 0x20   // Bit AAMPEN.
	SYSCTRL_XOSC32K_RUNSTDBY_Pos = 0x6    // Position of RUNSTDBY field.
	SYSCTRL_XOSC32K_RUNSTDBY_Msk = 0x40   // Bit mask of RUNSTDBY field.
	SYSCTRL_XOSC32K_RUNSTDBY     = 0x40   // Bit RUNSTDBY.
	SYSCTRL_XOSC32K_ONDEMAND_Pos = 0x7    // Position of ONDEMAND field.
	SYSCTRL_XOSC32K_ONDEMAND_Msk = 0x80   // Bit mask of ONDEMAND field.
	SYSCTRL_XOSC32K_ONDEMAND     = 0x80   // Bit ONDEMAND.
	SYSCTRL_XOSC32K_STARTUP_Pos  = 0x8    // Position of STARTUP field.
	SYSCTRL_XOSC32K_STARTUP_Msk  = 0x700  // Bit mask of STARTUP field.
	SYSCTRL_XOSC32K_WRTLOCK_Pos  = 0xc    // Position of WRTLOCK field.
	SYSCTRL_XOSC32K_WRTLOCK_Msk  = 0x1000 // Bit mask of WRTLOCK field.
	SYSCTRL_XOSC32K_WRTLOCK      = 0x1000 // Bit WRTLOCK.

	// OSC32K: 32kHz Internal Oscillator (OSC32K) Control
	SYSCTRL_OSC32K_ENABLE_Pos   = 0x1      // Position of ENABLE field.
	SYSCTRL_OSC32K_ENABLE_Msk   = 0x2      // Bit mask of ENABLE field.
	SYSCTRL_OSC32K_ENABLE       = 0x2      // Bit ENABLE.
	SYSCTRL_OSC32K_EN32K_Pos    = 0x2      // Position of EN32K field.
	SYSCTRL_OSC32K_EN32K_Msk    = 0x4      // Bit mask of EN32K field.
	SYSCTRL_OSC32K_EN32K        = 0x4      // Bit EN32K.
	SYSCTRL_OSC32K_EN1K_Pos     = 0x3      // Position of EN1K field.
	SYSCTRL_OSC32K_EN1K_Msk     = 0x8      // Bit mask of EN1K field.
	SYSCTRL_OSC32K_EN1K         = 0x8      // Bit EN1K.
	SYSCTRL_OSC32K_RUNSTDBY_Pos = 0x6      // Position of RUNSTDBY field.
	SYSCTRL_OSC32K_RUNSTDBY_Msk = 0x40     // Bit mask of RUNSTDBY field.
	SYSCTRL_OSC32K_RUNSTDBY     = 0x40     // Bit RUNSTDBY.
	SYSCTRL_OSC32K_ONDEMAND_Pos = 0x7      // Position of ONDEMAND field.
	SYSCTRL_OSC32K_ONDEMAND_Msk = 0x80     // Bit mask of ONDEMAND field.
	SYSCTRL_OSC32K_ONDEMAND     = 0x80     // Bit ONDEMAND.
	SYSCTRL_OSC32K_STARTUP_Pos  = 0x8      // Position of STARTUP field.
	SYSCTRL_OSC32K_STARTUP_Msk  = 0x700    // Bit mask of STARTUP field.
	SYSCTRL_OSC32K_WRTLOCK_Pos  = 0xc      // Position of WRTLOCK field.
	SYSCTRL_OSC32K_WRTLOCK_Msk  = 0x1000   // Bit mask of WRTLOCK field.
	SYSCTRL_OSC32K_WRTLOCK      = 0x1000   // Bit WRTLOCK.
	SYSCTRL_OSC32K_CALIB_Pos    = 0x10     // Position of CALIB field.
	SYSCTRL_OSC32K_CALIB_Msk    = 0x7f0000 // Bit mask of CALIB field.

	// OSCULP32K: 32kHz Ultra Low Power Internal Oscillator (OSCULP32K) Control
	SYSCTRL_OSCULP32K_CALIB_Pos   = 0x0  // Position of CALIB field.
	SYSCTRL_OSCULP32K_CALIB_Msk   = 0x1f // Bit mask of CALIB field.
	SYSCTRL_OSCULP32K_WRTLOCK_Pos = 0x7  // Position of WRTLOCK field.
	SYSCTRL_OSCULP32K_WRTLOCK_Msk = 0x80 // Bit mask of WRTLOCK field.
	SYSCTRL_OSCULP32K_WRTLOCK     = 0x80 // Bit WRTLOCK.

	// OSC8M: 8MHz Internal Oscillator (OSC8M) Control
	SYSCTRL_OSC8M_ENABLE_Pos   = 0x1        // Position of ENABLE field.
	SYSCTRL_OSC8M_ENABLE_Msk   = 0x2        // Bit mask of ENABLE field.
	SYSCTRL_OSC8M_ENABLE       = 0x2        // Bit ENABLE.
	SYSCTRL_OSC8M_RUNSTDBY_Pos = 0x6        // Position of RUNSTDBY field.
	SYSCTRL_OSC8M_RUNSTDBY_Msk = 0x40       // Bit mask of RUNSTDBY field.
	SYSCTRL_OSC8M_RUNSTDBY     = 0x40       // Bit RUNSTDBY.
	SYSCTRL_OSC8M_ONDEMAND_Pos = 0x7        // Position of ONDEMAND field.
	SYSCTRL_OSC8M_ONDEMAND_Msk = 0x80       // Bit mask of ONDEMAND field.
	SYSCTRL_OSC8M_ONDEMAND     = 0x80       // Bit ONDEMAND.
	SYSCTRL_OSC8M_PRESC_Pos    = 0x8        // Position of PRESC field.
	SYSCTRL_OSC8M_PRESC_Msk    = 0x300      // Bit mask of PRESC field.
	SYSCTRL_OSC8M_PRESC_0      = 0x0        // 1
	SYSCTRL_OSC8M_PRESC_1      = 0x1        // 2
	SYSCTRL_OSC8M_PRESC_2      = 0x2        // 4
	SYSCTRL_OSC8M_PRESC_3      = 0x3        // 8
	SYSCTRL_OSC8M_CALIB_Pos    = 0x10       // Position of CALIB field.
	SYSCTRL_OSC8M_CALIB_Msk    = 0xfff0000  // Bit mask of CALIB field.
	SYSCTRL_OSC8M_FRANGE_Pos   = 0x1e       // Position of FRANGE field.
	SYSCTRL_OSC8M_FRANGE_Msk   = 0xc0000000 // Bit mask of FRANGE field.
	SYSCTRL_OSC8M_FRANGE_0     = 0x0        // 4 to 6MHz
	SYSCTRL_OSC8M_FRANGE_1     = 0x1        // 6 to 8MHz
	SYSCTRL_OSC8M_FRANGE_2     = 0x2        // 8 to 11MHz
	SYSCTRL_OSC8M_FRANGE_3     = 0x3        // 11 to 15MHz

	// DFLLCTRL: DFLL48M Control
	SYSCTRL_DFLLCTRL_ENABLE_Pos   = 0x1   // Position of ENABLE field.
	SYSCTRL_DFLLCTRL_ENABLE_Msk   = 0x2   // Bit mask of ENABLE field.
	SYSCTRL_DFLLCTRL_ENABLE       = 0x2   // Bit ENABLE.
	SYSCTRL_DFLLCTRL_MODE_Pos     = 0x2   // Position of MODE field.
	SYSCTRL_DFLLCTRL_MODE_Msk     = 0x4   // Bit mask of MODE field.
	SYSCTRL_DFLLCTRL_MODE         = 0x4   // Bit MODE.
	SYSCTRL_DFLLCTRL_STABLE_Pos   = 0x3   // Position of STABLE field.
	SYSCTRL_DFLLCTRL_STABLE_Msk   = 0x8   // Bit mask of STABLE field.
	SYSCTRL_DFLLCTRL_STABLE       = 0x8   // Bit STABLE.
	SYSCTRL_DFLLCTRL_LLAW_Pos     = 0x4   // Position of LLAW field.
	SYSCTRL_DFLLCTRL_LLAW_Msk     = 0x10  // Bit mask of LLAW field.
	SYSCTRL_DFLLCTRL_LLAW         = 0x10  // Bit LLAW.
	SYSCTRL_DFLLCTRL_USBCRM_Pos   = 0x5   // Position of USBCRM field.
	SYSCTRL_DFLLCTRL_USBCRM_Msk   = 0x20  // Bit mask of USBCRM field.
	SYSCTRL_DFLLCTRL_USBCRM       = 0x20  // Bit USBCRM.
	SYSCTRL_DFLLCTRL_RUNSTDBY_Pos = 0x6   // Position of RUNSTDBY field.
	SYSCTRL_DFLLCTRL_RUNSTDBY_Msk = 0x40  // Bit mask of RUNSTDBY field.
	SYSCTRL_DFLLCTRL_RUNSTDBY     = 0x40  // Bit RUNSTDBY.
	SYSCTRL_DFLLCTRL_ONDEMAND_Pos = 0x7   // Position of ONDEMAND field.
	SYSCTRL_DFLLCTRL_ONDEMAND_Msk = 0x80  // Bit mask of ONDEMAND field.
	SYSCTRL_DFLLCTRL_ONDEMAND     = 0x80  // Bit ONDEMAND.
	SYSCTRL_DFLLCTRL_CCDIS_Pos    = 0x8   // Position of CCDIS field.
	SYSCTRL_DFLLCTRL_CCDIS_Msk    = 0x100 // Bit mask of CCDIS field.
	SYSCTRL_DFLLCTRL_CCDIS        = 0x100 // Bit CCDIS.
	SYSCTRL_DFLLCTRL_QLDIS_Pos    = 0x9   // Position of QLDIS field.
	SYSCTRL_DFLLCTRL_QLDIS_Msk    = 0x200 // Bit mask of QLDIS field.
	SYSCTRL_DFLLCTRL_QLDIS        = 0x200 // Bit QLDIS.
	SYSCTRL_DFLLCTRL_BPLCKC_Pos   = 0xa   // Position of BPLCKC field.
	SYSCTRL_DFLLCTRL_BPLCKC_Msk   = 0x400 // Bit mask of BPLCKC field.
	SYSCTRL_DFLLCTRL_BPLCKC       = 0x400 // Bit BPLCKC.
	SYSCTRL_DFLLCTRL_WAITLOCK_Pos = 0xb   // Position of WAITLOCK field.
	SYSCTRL_DFLLCTRL_WAITLOCK_Msk = 0x800 // Bit mask of WAITLOCK field.
	SYSCTRL_DFLLCTRL_WAITLOCK     = 0x800 // Bit WAITLOCK.

	// DFLLVAL: DFLL48M Value
	SYSCTRL_DFLLVAL_FINE_Pos   = 0x0        // Position of FINE field.
	SYSCTRL_DFLLVAL_FINE_Msk   = 0x3ff      // Bit mask of FINE field.
	SYSCTRL_DFLLVAL_COARSE_Pos = 0xa        // Position of COARSE field.
	SYSCTRL_DFLLVAL_COARSE_Msk = 0xfc00     // Bit mask of COARSE field.
	SYSCTRL_DFLLVAL_DIFF_Pos   = 0x10       // Position of DIFF field.
	SYSCTRL_DFLLVAL_DIFF_Msk   = 0xffff0000 // Bit mask of DIFF field.

	// DFLLMUL: DFLL48M Multiplier
	SYSCTRL_DFLLMUL_MUL_Pos   = 0x0        // Position of MUL field.
	SYSCTRL_DFLLMUL_MUL_Msk   = 0xffff     // Bit mask of MUL field.
	SYSCTRL_DFLLMUL_FSTEP_Pos = 0x10       // Position of FSTEP field.
	SYSCTRL_DFLLMUL_FSTEP_Msk = 0x3ff0000  // Bit mask of FSTEP field.
	SYSCTRL_DFLLMUL_CSTEP_Pos = 0x1a       // Position of CSTEP field.
	SYSCTRL_DFLLMUL_CSTEP_Msk = 0xfc000000 // Bit mask of CSTEP field.

	// DFLLSYNC: DFLL48M Synchronization
	SYSCTRL_DFLLSYNC_READREQ_Pos = 0x7  // Position of READREQ field.
	SYSCTRL_DFLLSYNC_READREQ_Msk = 0x80 // Bit mask of READREQ field.
	SYSCTRL_DFLLSYNC_READREQ     = 0x80 // Bit READREQ.

	// BOD33: 3.3V Brown-Out Detector (BOD33) Control
	SYSCTRL_BOD33_ENABLE_Pos       = 0x1      // Position of ENABLE field.
	SYSCTRL_BOD33_ENABLE_Msk       = 0x2      // Bit mask of ENABLE field.
	SYSCTRL_BOD33_ENABLE           = 0x2      // Bit ENABLE.
	SYSCTRL_BOD33_HYST_Pos         = 0x2      // Position of HYST field.
	SYSCTRL_BOD33_HYST_Msk         = 0x4      // Bit mask of HYST field.
	SYSCTRL_BOD33_HYST             = 0x4      // Bit HYST.
	SYSCTRL_BOD33_ACTION_Pos       = 0x3      // Position of ACTION field.
	SYSCTRL_BOD33_ACTION_Msk       = 0x18     // Bit mask of ACTION field.
	SYSCTRL_BOD33_ACTION_NONE      = 0x0      // No action
	SYSCTRL_BOD33_ACTION_RESET     = 0x1      // The BOD33 generates a reset
	SYSCTRL_BOD33_ACTION_INTERRUPT = 0x2      // The BOD33 generates an interrupt
	SYSCTRL_BOD33_RUNSTDBY_Pos     = 0x6      // Position of RUNSTDBY field.
	SYSCTRL_BOD33_RUNSTDBY_Msk     = 0x40     // Bit mask of RUNSTDBY field.
	SYSCTRL_BOD33_RUNSTDBY         = 0x40     // Bit RUNSTDBY.
	SYSCTRL_BOD33_MODE_Pos         = 0x8      // Position of MODE field.
	SYSCTRL_BOD33_MODE_Msk         = 0x100    // Bit mask of MODE field.
	SYSCTRL_BOD33_MODE             = 0x100    // Bit MODE.
	SYSCTRL_BOD33_CEN_Pos          = 0x9      // Position of CEN field.
	SYSCTRL_BOD33_CEN_Msk          = 0x200    // Bit mask of CEN field.
	SYSCTRL_BOD33_CEN              = 0x200    // Bit CEN.
	SYSCTRL_BOD33_PSEL_Pos         = 0xc      // Position of PSEL field.
	SYSCTRL_BOD33_PSEL_Msk         = 0xf000   // Bit mask of PSEL field.
	SYSCTRL_BOD33_PSEL_DIV2        = 0x0      // Divide clock by 2
	SYSCTRL_BOD33_PSEL_DIV4        = 0x1      // Divide clock by 4
	SYSCTRL_BOD33_PSEL_DIV8        = 0x2      // Divide clock by 8
	SYSCTRL_BOD33_PSEL_DIV16       = 0x3      // Divide clock by 16
	SYSCTRL_BOD33_PSEL_DIV32       = 0x4      // Divide clock by 32
	SYSCTRL_BOD33_PSEL_DIV64       = 0x5      // Divide clock by 64
	SYSCTRL_BOD33_PSEL_DIV128      = 0x6      // Divide clock by 128
	SYSCTRL_BOD33_PSEL_DIV256      = 0x7      // Divide clock by 256
	SYSCTRL_BOD33_PSEL_DIV512      = 0x8      // Divide clock by 512
	SYSCTRL_BOD33_PSEL_DIV1K       = 0x9      // Divide clock by 1024
	SYSCTRL_BOD33_PSEL_DIV2K       = 0xa      // Divide clock by 2048
	SYSCTRL_BOD33_PSEL_DIV4K       = 0xb      // Divide clock by 4096
	SYSCTRL_BOD33_PSEL_DIV8K       = 0xc      // Divide clock by 8192
	SYSCTRL_BOD33_PSEL_DIV16K      = 0xd      // Divide clock by 16384
	SYSCTRL_BOD33_PSEL_DIV32K      = 0xe      // Divide clock by 32768
	SYSCTRL_BOD33_PSEL_DIV64K      = 0xf      // Divide clock by 65536
	SYSCTRL_BOD33_LEVEL_Pos        = 0x10     // Position of LEVEL field.
	SYSCTRL_BOD33_LEVEL_Msk        = 0x3f0000 // Bit mask of LEVEL field.

	// VREG: Voltage Regulator System (VREG) Control
	SYSCTRL_VREG_RUNSTDBY_Pos = 0x6    // Position of RUNSTDBY field.
	SYSCTRL_VREG_RUNSTDBY_Msk = 0x40   // Bit mask of RUNSTDBY field.
	SYSCTRL_VREG_RUNSTDBY     = 0x40   // Bit RUNSTDBY.
	SYSCTRL_VREG_FORCELDO_Pos = 0xd    // Position of FORCELDO field.
	SYSCTRL_VREG_FORCELDO_Msk = 0x2000 // Bit mask of FORCELDO field.
	SYSCTRL_VREG_FORCELDO     = 0x2000 // Bit FORCELDO.

	// VREF: Voltage References System (VREF) Control
	SYSCTRL_VREF_TSEN_Pos    = 0x1       // Position of TSEN field.
	SYSCTRL_VREF_TSEN_Msk    = 0x2       // Bit mask of TSEN field.
	SYSCTRL_VREF_TSEN        = 0x2       // Bit TSEN.
	SYSCTRL_VREF_BGOUTEN_Pos = 0x2       // Position of BGOUTEN field.
	SYSCTRL_VREF_BGOUTEN_Msk = 0x4       // Bit mask of BGOUTEN field.
	SYSCTRL_VREF_BGOUTEN     = 0x4       // Bit BGOUTEN.
	SYSCTRL_VREF_CALIB_Pos   = 0x10      // Position of CALIB field.
	SYSCTRL_VREF_CALIB_Msk   = 0x7ff0000 // Bit mask of CALIB field.

	// DPLLCTRLA: DPLL Control A
	SYSCTRL_DPLLCTRLA_ENABLE_Pos   = 0x1  // Position of ENABLE field.
	SYSCTRL_DPLLCTRLA_ENABLE_Msk   = 0x2  // Bit mask of ENABLE field.
	SYSCTRL_DPLLCTRLA_ENABLE       = 0x2  // Bit ENABLE.
	SYSCTRL_DPLLCTRLA_RUNSTDBY_Pos = 0x6  // Position of RUNSTDBY field.
	SYSCTRL_DPLLCTRLA_RUNSTDBY_Msk = 0x40 // Bit mask of RUNSTDBY field.
	SYSCTRL_DPLLCTRLA_RUNSTDBY     = 0x40 // Bit RUNSTDBY.
	SYSCTRL_DPLLCTRLA_ONDEMAND_Pos = 0x7  // Position of ONDEMAND field.
	SYSCTRL_DPLLCTRLA_ONDEMAND_Msk = 0x80 // Bit mask of ONDEMAND field.
	SYSCTRL_DPLLCTRLA_ONDEMAND     = 0x80 // Bit ONDEMAND.

	// DPLLRATIO: DPLL Ratio Control
	SYSCTRL_DPLLRATIO_LDR_Pos     = 0x0     // Position of LDR field.
	SYSCTRL_DPLLRATIO_LDR_Msk     = 0xfff   // Bit mask of LDR field.
	SYSCTRL_DPLLRATIO_LDRFRAC_Pos = 0x10    // Position of LDRFRAC field.
	SYSCTRL_DPLLRATIO_LDRFRAC_Msk = 0xf0000 // Bit mask of LDRFRAC field.

	// DPLLCTRLB: DPLL Control B
	SYSCTRL_DPLLCTRLB_FILTER_Pos     = 0x0       // Position of FILTER field.
	SYSCTRL_DPLLCTRLB_FILTER_Msk     = 0x3       // Bit mask of FILTER field.
	SYSCTRL_DPLLCTRLB_FILTER_DEFAULT = 0x0       // Default filter mode
	SYSCTRL_DPLLCTRLB_FILTER_LBFILT  = 0x1       // Low bandwidth filter
	SYSCTRL_DPLLCTRLB_FILTER_HBFILT  = 0x2       // High bandwidth filter
	SYSCTRL_DPLLCTRLB_FILTER_HDFILT  = 0x3       // High damping filter
	SYSCTRL_DPLLCTRLB_LPEN_Pos       = 0x2       // Position of LPEN field.
	SYSCTRL_DPLLCTRLB_LPEN_Msk       = 0x4       // Bit mask of LPEN field.
	SYSCTRL_DPLLCTRLB_LPEN           = 0x4       // Bit LPEN.
	SYSCTRL_DPLLCTRLB_WUF_Pos        = 0x3       // Position of WUF field.
	SYSCTRL_DPLLCTRLB_WUF_Msk        = 0x8       // Bit mask of WUF field.
	SYSCTRL_DPLLCTRLB_WUF            = 0x8       // Bit WUF.
	SYSCTRL_DPLLCTRLB_REFCLK_Pos     = 0x4       // Position of REFCLK field.
	SYSCTRL_DPLLCTRLB_REFCLK_Msk     = 0x30      // Bit mask of REFCLK field.
	SYSCTRL_DPLLCTRLB_REFCLK_REF0    = 0x0       // CLK_DPLL_REF0 clock reference
	SYSCTRL_DPLLCTRLB_REFCLK_REF1    = 0x1       // CLK_DPLL_REF1 clock reference
	SYSCTRL_DPLLCTRLB_REFCLK_GCLK    = 0x2       // GCLK_DPLL clock reference
	SYSCTRL_DPLLCTRLB_LTIME_Pos      = 0x8       // Position of LTIME field.
	SYSCTRL_DPLLCTRLB_LTIME_Msk      = 0x700     // Bit mask of LTIME field.
	SYSCTRL_DPLLCTRLB_LTIME_DEFAULT  = 0x0       // No time-out
	SYSCTRL_DPLLCTRLB_LTIME_8MS      = 0x4       // Time-out if no lock within 8 ms
	SYSCTRL_DPLLCTRLB_LTIME_9MS      = 0x5       // Time-out if no lock within 9 ms
	SYSCTRL_DPLLCTRLB_LTIME_10MS     = 0x6       // Time-out if no lock within 10 ms
	SYSCTRL_DPLLCTRLB_LTIME_11MS     = 0x7       // Time-out if no lock within 11 ms
	SYSCTRL_DPLLCTRLB_LBYPASS_Pos    = 0xc       // Position of LBYPASS field.
	SYSCTRL_DPLLCTRLB_LBYPASS_Msk    = 0x1000    // Bit mask of LBYPASS field.
	SYSCTRL_DPLLCTRLB_LBYPASS        = 0x1000    // Bit LBYPASS.
	SYSCTRL_DPLLCTRLB_DIV_Pos        = 0x10      // Position of DIV field.
	SYSCTRL_DPLLCTRLB_DIV_Msk        = 0x7ff0000 // Bit mask of DIV field.

	// DPLLSTATUS: DPLL Status
	SYSCTRL_DPLLSTATUS_LOCK_Pos   = 0x0 // Position of LOCK field.
	SYSCTRL_DPLLSTATUS_LOCK_Msk   = 0x1 // Bit mask of LOCK field.
	SYSCTRL_DPLLSTATUS_LOCK       = 0x1 // Bit LOCK.
	SYSCTRL_DPLLSTATUS_CLKRDY_Pos = 0x1 // Position of CLKRDY field.
	SYSCTRL_DPLLSTATUS_CLKRDY_Msk = 0x2 // Bit mask of CLKRDY field.
	SYSCTRL_DPLLSTATUS_CLKRDY     = 0x2 // Bit CLKRDY.
	SYSCTRL_DPLLSTATUS_ENABLE_Pos = 0x2 // Position of ENABLE field.
	SYSCTRL_DPLLSTATUS_ENABLE_Msk = 0x4 // Bit mask of ENABLE field.
	SYSCTRL_DPLLSTATUS_ENABLE     = 0x4 // Bit ENABLE.
	SYSCTRL_DPLLSTATUS_DIV_Pos    = 0x3 // Position of DIV field.
	SYSCTRL_DPLLSTATUS_DIV_Msk    = 0x8 // Bit mask of DIV field.
	SYSCTRL_DPLLSTATUS_DIV        = 0x8 // Bit DIV.
)

// Bitfields for TC3: Basic Timer Counter 3
const ()

// Bitfields for TC3_COUNT8: Basic Timer Counter 3 - COUNT8
const (
	// CTRLA: Control A
	TC_COUNT8_CTRLA_SWRST_Pos         = 0x0  // Position of SWRST field.
	TC_COUNT8_CTRLA_SWRST_Msk         = 0x1  // Bit mask of SWRST field.
	TC_COUNT8_CTRLA_SWRST             = 0x1  // Bit SWRST.
	TC_COUNT8_CTRLA_ENABLE_Pos        = 0x1  // Position of ENABLE field.
	TC_COUNT8_CTRLA_ENABLE_Msk        = 0x2  // Bit mask of ENABLE field.
	TC_COUNT8_CTRLA_ENABLE            = 0x2  // Bit ENABLE.
	TC_COUNT8_CTRLA_MODE_Pos          = 0x2  // Position of MODE field.
	TC_COUNT8_CTRLA_MODE_Msk          = 0xc  // Bit mask of MODE field.
	TC_COUNT8_CTRLA_MODE_COUNT16      = 0x0  // Counter in 16-bit mode
	TC_COUNT8_CTRLA_MODE_COUNT8       = 0x1  // Counter in 8-bit mode
	TC_COUNT8_CTRLA_MODE_COUNT32      = 0x2  // Counter in 32-bit mode
	TC_COUNT8_CTRLA_WAVEGEN_Pos       = 0x5  // Position of WAVEGEN field.
	TC_COUNT8_CTRLA_WAVEGEN_Msk       = 0x60 // Bit mask of WAVEGEN field.
	TC_COUNT8_CTRLA_WAVEGEN_NFRQ      = 0x0
	TC_COUNT8_CTRLA_WAVEGEN_MFRQ      = 0x1
	TC_COUNT8_CTRLA_WAVEGEN_NPWM      = 0x2
	TC_COUNT8_CTRLA_WAVEGEN_MPWM      = 0x3
	TC_COUNT8_CTRLA_PRESCALER_Pos     = 0x8    // Position of PRESCALER field.
	TC_COUNT8_CTRLA_PRESCALER_Msk     = 0x700  // Bit mask of PRESCALER field.
	TC_COUNT8_CTRLA_PRESCALER_DIV1    = 0x0    // Prescaler: GCLK_TC
	TC_COUNT8_CTRLA_PRESCALER_DIV2    = 0x1    // Prescaler: GCLK_TC/2
	TC_COUNT8_CTRLA_PRESCALER_DIV4    = 0x2    // Prescaler: GCLK_TC/4
	TC_COUNT8_CTRLA_PRESCALER_DIV8    = 0x3    // Prescaler: GCLK_TC/8
	TC_COUNT8_CTRLA_PRESCALER_DIV16   = 0x4    // Prescaler: GCLK_TC/16
	TC_COUNT8_CTRLA_PRESCALER_DIV64   = 0x5    // Prescaler: GCLK_TC/64
	TC_COUNT8_CTRLA_PRESCALER_DIV256  = 0x6    // Prescaler: GCLK_TC/256
	TC_COUNT8_CTRLA_PRESCALER_DIV1024 = 0x7    // Prescaler: GCLK_TC/1024
	TC_COUNT8_CTRLA_RUNSTDBY_Pos      = 0xb    // Position of RUNSTDBY field.
	TC_COUNT8_CTRLA_RUNSTDBY_Msk      = 0x800  // Bit mask of RUNSTDBY field.
	TC_COUNT8_CTRLA_RUNSTDBY          = 0x800  // Bit RUNSTDBY.
	TC_COUNT8_CTRLA_PRESCSYNC_Pos     = 0xc    // Position of PRESCSYNC field.
	TC_COUNT8_CTRLA_PRESCSYNC_Msk     = 0x3000 // Bit mask of PRESCSYNC field.
	TC_COUNT8_CTRLA_PRESCSYNC_GCLK    = 0x0    // Reload or reset the counter on next generic clock
	TC_COUNT8_CTRLA_PRESCSYNC_PRESC   = 0x1    // Reload or reset the counter on next prescaler clock
	TC_COUNT8_CTRLA_PRESCSYNC_RESYNC  = 0x2    // Reload or reset the counter on next generic clock. Reset the prescaler counter

	// READREQ: Read Request
	TC_COUNT8_READREQ_ADDR_Pos  = 0x0    // Position of ADDR field.
	TC_COUNT8_READREQ_ADDR_Msk  = 0x1f   // Bit mask of ADDR field.
	TC_COUNT8_READREQ_RCONT_Pos = 0xe    // Position of RCONT field.
	TC_COUNT8_READREQ_RCONT_Msk = 0x4000 // Bit mask of RCONT field.
	TC_COUNT8_READREQ_RCONT     = 0x4000 // Bit RCONT.
	TC_COUNT8_READREQ_RREQ_Pos  = 0xf    // Position of RREQ field.
	TC_COUNT8_READREQ_RREQ_Msk  = 0x8000 // Bit mask of RREQ field.
	TC_COUNT8_READREQ_RREQ      = 0x8000 // Bit RREQ.

	// CTRLBCLR: Control B Clear
	TC_COUNT8_CTRLBCLR_DIR_Pos       = 0x0  // Position of DIR field.
	TC_COUNT8_CTRLBCLR_DIR_Msk       = 0x1  // Bit mask of DIR field.
	TC_COUNT8_CTRLBCLR_DIR           = 0x1  // Bit DIR.
	TC_COUNT8_CTRLBCLR_ONESHOT_Pos   = 0x2  // Position of ONESHOT field.
	TC_COUNT8_CTRLBCLR_ONESHOT_Msk   = 0x4  // Bit mask of ONESHOT field.
	TC_COUNT8_CTRLBCLR_ONESHOT       = 0x4  // Bit ONESHOT.
	TC_COUNT8_CTRLBCLR_CMD_Pos       = 0x6  // Position of CMD field.
	TC_COUNT8_CTRLBCLR_CMD_Msk       = 0xc0 // Bit mask of CMD field.
	TC_COUNT8_CTRLBCLR_CMD_NONE      = 0x0  // No action
	TC_COUNT8_CTRLBCLR_CMD_RETRIGGER = 0x1  // Force a start, restart or retrigger
	TC_COUNT8_CTRLBCLR_CMD_STOP      = 0x2  // Force a stop

	// CTRLBSET: Control B Set
	TC_COUNT8_CTRLBSET_DIR_Pos       = 0x0  // Position of DIR field.
	TC_COUNT8_CTRLBSET_DIR_Msk       = 0x1  // Bit mask of DIR field.
	TC_COUNT8_CTRLBSET_DIR           = 0x1  // Bit DIR.
	TC_COUNT8_CTRLBSET_ONESHOT_Pos   = 0x2  // Position of ONESHOT field.
	TC_COUNT8_CTRLBSET_ONESHOT_Msk   = 0x4  // Bit mask of ONESHOT field.
	TC_COUNT8_CTRLBSET_ONESHOT       = 0x4  // Bit ONESHOT.
	TC_COUNT8_CTRLBSET_CMD_Pos       = 0x6  // Position of CMD field.
	TC_COUNT8_CTRLBSET_CMD_Msk       = 0xc0 // Bit mask of CMD field.
	TC_COUNT8_CTRLBSET_CMD_NONE      = 0x0  // No action
	TC_COUNT8_CTRLBSET_CMD_RETRIGGER = 0x1  // Force a start, restart or retrigger
	TC_COUNT8_CTRLBSET_CMD_STOP      = 0x2  // Force a stop

	// CTRLC: Control C
	TC_COUNT8_CTRLC_INVEN0_Pos = 0x0  // Position of INVEN0 field.
	TC_COUNT8_CTRLC_INVEN0_Msk = 0x1  // Bit mask of INVEN0 field.
	TC_COUNT8_CTRLC_INVEN0     = 0x1  // Bit INVEN0.
	TC_COUNT8_CTRLC_INVEN1_Pos = 0x1  // Position of INVEN1 field.
	TC_COUNT8_CTRLC_INVEN1_Msk = 0x2  // Bit mask of INVEN1 field.
	TC_COUNT8_CTRLC_INVEN1     = 0x2  // Bit INVEN1.
	TC_COUNT8_CTRLC_CPTEN0_Pos = 0x4  // Position of CPTEN0 field.
	TC_COUNT8_CTRLC_CPTEN0_Msk = 0x10 // Bit mask of CPTEN0 field.
	TC_COUNT8_CTRLC_CPTEN0     = 0x10 // Bit CPTEN0.
	TC_COUNT8_CTRLC_CPTEN1_Pos = 0x5  // Position of CPTEN1 field.
	TC_COUNT8_CTRLC_CPTEN1_Msk = 0x20 // Bit mask of CPTEN1 field.
	TC_COUNT8_CTRLC_CPTEN1     = 0x20 // Bit CPTEN1.

	// DBGCTRL: Debug Control
	TC_COUNT8_DBGCTRL_DBGRUN_Pos = 0x0 // Position of DBGRUN field.
	TC_COUNT8_DBGCTRL_DBGRUN_Msk = 0x1 // Bit mask of DBGRUN field.
	TC_COUNT8_DBGCTRL_DBGRUN     = 0x1 // Bit DBGRUN.

	// EVCTRL: Event Control
	TC_COUNT8_EVCTRL_EVACT_Pos       = 0x0    // Position of EVACT field.
	TC_COUNT8_EVCTRL_EVACT_Msk       = 0x7    // Bit mask of EVACT field.
	TC_COUNT8_EVCTRL_EVACT_OFF       = 0x0    // Event action disabled
	TC_COUNT8_EVCTRL_EVACT_RETRIGGER = 0x1    // Start, restart or retrigger TC on event
	TC_COUNT8_EVCTRL_EVACT_COUNT     = 0x2    // Count on event
	TC_COUNT8_EVCTRL_EVACT_START     = 0x3    // Start TC on event
	TC_COUNT8_EVCTRL_EVACT_PPW       = 0x5    // Period captured in CC0, pulse width in CC1
	TC_COUNT8_EVCTRL_EVACT_PWP       = 0x6    // Period captured in CC1, pulse width in CC0
	TC_COUNT8_EVCTRL_TCINV_Pos       = 0x4    // Position of TCINV field.
	TC_COUNT8_EVCTRL_TCINV_Msk       = 0x10   // Bit mask of TCINV field.
	TC_COUNT8_EVCTRL_TCINV           = 0x10   // Bit TCINV.
	TC_COUNT8_EVCTRL_TCEI_Pos        = 0x5    // Position of TCEI field.
	TC_COUNT8_EVCTRL_TCEI_Msk        = 0x20   // Bit mask of TCEI field.
	TC_COUNT8_EVCTRL_TCEI            = 0x20   // Bit TCEI.
	TC_COUNT8_EVCTRL_OVFEO_Pos       = 0x8    // Position of OVFEO field.
	TC_COUNT8_EVCTRL_OVFEO_Msk       = 0x100  // Bit mask of OVFEO field.
	TC_COUNT8_EVCTRL_OVFEO           = 0x100  // Bit OVFEO.
	TC_COUNT8_EVCTRL_MCEO0_Pos       = 0xc    // Position of MCEO0 field.
	TC_COUNT8_EVCTRL_MCEO0_Msk       = 0x1000 // Bit mask of MCEO0 field.
	TC_COUNT8_EVCTRL_MCEO0           = 0x1000 // Bit MCEO0.
	TC_COUNT8_EVCTRL_MCEO1_Pos       = 0xd    // Position of MCEO1 field.
	TC_COUNT8_EVCTRL_MCEO1_Msk       = 0x2000 // Bit mask of MCEO1 field.
	TC_COUNT8_EVCTRL_MCEO1           = 0x2000 // Bit MCEO1.

	// INTENCLR: Interrupt Enable Clear
	TC_COUNT8_INTENCLR_OVF_Pos     = 0x0  // Position of OVF field.
	TC_COUNT8_INTENCLR_OVF_Msk     = 0x1  // Bit mask of OVF field.
	TC_COUNT8_INTENCLR_OVF         = 0x1  // Bit OVF.
	TC_COUNT8_INTENCLR_ERR_Pos     = 0x1  // Position of ERR field.
	TC_COUNT8_INTENCLR_ERR_Msk     = 0x2  // Bit mask of ERR field.
	TC_COUNT8_INTENCLR_ERR         = 0x2  // Bit ERR.
	TC_COUNT8_INTENCLR_SYNCRDY_Pos = 0x3  // Position of SYNCRDY field.
	TC_COUNT8_INTENCLR_SYNCRDY_Msk = 0x8  // Bit mask of SYNCRDY field.
	TC_COUNT8_INTENCLR_SYNCRDY     = 0x8  // Bit SYNCRDY.
	TC_COUNT8_INTENCLR_MC0_Pos     = 0x4  // Position of MC0 field.
	TC_COUNT8_INTENCLR_MC0_Msk     = 0x10 // Bit mask of MC0 field.
	TC_COUNT8_INTENCLR_MC0         = 0x10 // Bit MC0.
	TC_COUNT8_INTENCLR_MC1_Pos     = 0x5  // Position of MC1 field.
	TC_COUNT8_INTENCLR_MC1_Msk     = 0x20 // Bit mask of MC1 field.
	TC_COUNT8_INTENCLR_MC1         = 0x20 // Bit MC1.

	// INTENSET: Interrupt Enable Set
	TC_COUNT8_INTENSET_OVF_Pos     = 0x0  // Position of OVF field.
	TC_COUNT8_INTENSET_OVF_Msk     = 0x1  // Bit mask of OVF field.
	TC_COUNT8_INTENSET_OVF         = 0x1  // Bit OVF.
	TC_COUNT8_INTENSET_ERR_Pos     = 0x1  // Position of ERR field.
	TC_COUNT8_INTENSET_ERR_Msk     = 0x2  // Bit mask of ERR field.
	TC_COUNT8_INTENSET_ERR         = 0x2  // Bit ERR.
	TC_COUNT8_INTENSET_SYNCRDY_Pos = 0x3  // Position of SYNCRDY field.
	TC_COUNT8_INTENSET_SYNCRDY_Msk = 0x8  // Bit mask of SYNCRDY field.
	TC_COUNT8_INTENSET_SYNCRDY     = 0x8  // Bit SYNCRDY.
	TC_COUNT8_INTENSET_MC0_Pos     = 0x4  // Position of MC0 field.
	TC_COUNT8_INTENSET_MC0_Msk     = 0x10 // Bit mask of MC0 field.
	TC_COUNT8_INTENSET_MC0         = 0x10 // Bit MC0.
	TC_COUNT8_INTENSET_MC1_Pos     = 0x5  // Position of MC1 field.
	TC_COUNT8_INTENSET_MC1_Msk     = 0x20 // Bit mask of MC1 field.
	TC_COUNT8_INTENSET_MC1         = 0x20 // Bit MC1.

	// INTFLAG: Interrupt Flag Status and Clear
	TC_COUNT8_INTFLAG_OVF_Pos     = 0x0  // Position of OVF field.
	TC_COUNT8_INTFLAG_OVF_Msk     = 0x1  // Bit mask of OVF field.
	TC_COUNT8_INTFLAG_OVF         = 0x1  // Bit OVF.
	TC_COUNT8_INTFLAG_ERR_Pos     = 0x1  // Position of ERR field.
	TC_COUNT8_INTFLAG_ERR_Msk     = 0x2  // Bit mask of ERR field.
	TC_COUNT8_INTFLAG_ERR         = 0x2  // Bit ERR.
	TC_COUNT8_INTFLAG_SYNCRDY_Pos = 0x3  // Position of SYNCRDY field.
	TC_COUNT8_INTFLAG_SYNCRDY_Msk = 0x8  // Bit mask of SYNCRDY field.
	TC_COUNT8_INTFLAG_SYNCRDY     = 0x8  // Bit SYNCRDY.
	TC_COUNT8_INTFLAG_MC0_Pos     = 0x4  // Position of MC0 field.
	TC_COUNT8_INTFLAG_MC0_Msk     = 0x10 // Bit mask of MC0 field.
	TC_COUNT8_INTFLAG_MC0         = 0x10 // Bit MC0.
	TC_COUNT8_INTFLAG_MC1_Pos     = 0x5  // Position of MC1 field.
	TC_COUNT8_INTFLAG_MC1_Msk     = 0x20 // Bit mask of MC1 field.
	TC_COUNT8_INTFLAG_MC1         = 0x20 // Bit MC1.

	// STATUS: Status
	TC_COUNT8_STATUS_STOP_Pos     = 0x3  // Position of STOP field.
	TC_COUNT8_STATUS_STOP_Msk     = 0x8  // Bit mask of STOP field.
	TC_COUNT8_STATUS_STOP         = 0x8  // Bit STOP.
	TC_COUNT8_STATUS_SLAVE_Pos    = 0x4  // Position of SLAVE field.
	TC_COUNT8_STATUS_SLAVE_Msk    = 0x10 // Bit mask of SLAVE field.
	TC_COUNT8_STATUS_SLAVE        = 0x10 // Bit SLAVE.
	TC_COUNT8_STATUS_SYNCBUSY_Pos = 0x7  // Position of SYNCBUSY field.
	TC_COUNT8_STATUS_SYNCBUSY_Msk = 0x80 // Bit mask of SYNCBUSY field.
	TC_COUNT8_STATUS_SYNCBUSY     = 0x80 // Bit SYNCBUSY.

	// COUNT: COUNT8 Counter Value
	TC_COUNT8_COUNT_COUNT_Pos = 0x0  // Position of COUNT field.
	TC_COUNT8_COUNT_COUNT_Msk = 0xff // Bit mask of COUNT field.

	// PER: COUNT8 Period Value
	TC_COUNT8_PER_PER_Pos = 0x0  // Position of PER field.
	TC_COUNT8_PER_PER_Msk = 0xff // Bit mask of PER field.

	// CC0: COUNT8 Compare/Capture
	TC_COUNT8_CC_CC_Pos = 0x0  // Position of CC field.
	TC_COUNT8_CC_CC_Msk = 0xff // Bit mask of CC field.
)

// Bitfields for TC3_COUNT16: Basic Timer Counter 3 - COUNT16
const (
	// CTRLA: Control A
	TC_COUNT16_CTRLA_SWRST_Pos         = 0x0  // Position of SWRST field.
	TC_COUNT16_CTRLA_SWRST_Msk         = 0x1  // Bit mask of SWRST field.
	TC_COUNT16_CTRLA_SWRST             = 0x1  // Bit SWRST.
	TC_COUNT16_CTRLA_ENABLE_Pos        = 0x1  // Position of ENABLE field.
	TC_COUNT16_CTRLA_ENABLE_Msk        = 0x2  // Bit mask of ENABLE field.
	TC_COUNT16_CTRLA_ENABLE            = 0x2  // Bit ENABLE.
	TC_COUNT16_CTRLA_MODE_Pos          = 0x2  // Position of MODE field.
	TC_COUNT16_CTRLA_MODE_Msk          = 0xc  // Bit mask of MODE field.
	TC_COUNT16_CTRLA_MODE_COUNT16      = 0x0  // Counter in 16-bit mode
	TC_COUNT16_CTRLA_MODE_COUNT8       = 0x1  // Counter in 8-bit mode
	TC_COUNT16_CTRLA_MODE_COUNT32      = 0x2  // Counter in 32-bit mode
	TC_COUNT16_CTRLA_WAVEGEN_Pos       = 0x5  // Position of WAVEGEN field.
	TC_COUNT16_CTRLA_WAVEGEN_Msk       = 0x60 // Bit mask of WAVEGEN field.
	TC_COUNT16_CTRLA_WAVEGEN_NFRQ      = 0x0
	TC_COUNT16_CTRLA_WAVEGEN_MFRQ      = 0x1
	TC_COUNT16_CTRLA_WAVEGEN_NPWM      = 0x2
	TC_COUNT16_CTRLA_WAVEGEN_MPWM      = 0x3
	TC_COUNT16_CTRLA_PRESCALER_Pos     = 0x8    // Position of PRESCALER field.
	TC_COUNT16_CTRLA_PRESCALER_Msk     = 0x700  // Bit mask of PRESCALER field.
	TC_COUNT16_CTRLA_PRESCALER_DIV1    = 0x0    // Prescaler: GCLK_TC
	TC_COUNT16_CTRLA_PRESCALER_DIV2    = 0x1    // Prescaler: GCLK_TC/2
	TC_COUNT16_CTRLA_PRESCALER_DIV4    = 0x2    // Prescaler: GCLK_TC/4
	TC_COUNT16_CTRLA_PRESCALER_DIV8    = 0x3    // Prescaler: GCLK_TC/8
	TC_COUNT16_CTRLA_PRESCALER_DIV16   = 0x4    // Prescaler: GCLK_TC/16
	TC_COUNT16_CTRLA_PRESCALER_DIV64   = 0x5    // Prescaler: GCLK_TC/64
	TC_COUNT16_CTRLA_PRESCALER_DIV256  = 0x6    // Prescaler: GCLK_TC/256
	TC_COUNT16_CTRLA_PRESCALER_DIV1024 = 0x7    // Prescaler: GCLK_TC/1024
	TC_COUNT16_CTRLA_RUNSTDBY_Pos      = 0xb    // Position of RUNSTDBY field.
	TC_COUNT16_CTRLA_RUNSTDBY_Msk      = 0x800  // Bit mask of RUNSTDBY field.
	TC_COUNT16_CTRLA_RUNSTDBY          = 0x800  // Bit RUNSTDBY.
	TC_COUNT16_CTRLA_PRESCSYNC_Pos     = 0xc    // Position of PRESCSYNC field.
	TC_COUNT16_CTRLA_PRESCSYNC_Msk     = 0x3000 // Bit mask of PRESCSYNC field.
	TC_COUNT16_CTRLA_PRESCSYNC_GCLK    = 0x0    // Reload or reset the counter on next generic clock
	TC_COUNT16_CTRLA_PRESCSYNC_PRESC   = 0x1    // Reload or reset the counter on next prescaler clock
	TC_COUNT16_CTRLA_PRESCSYNC_RESYNC  = 0x2    // Reload or reset the counter on next generic clock. Reset the prescaler counter

	// READREQ: Read Request
	TC_COUNT16_READREQ_ADDR_Pos  = 0x0    // Position of ADDR field.
	TC_COUNT16_READREQ_ADDR_Msk  = 0x1f   // Bit mask of ADDR field.
	TC_COUNT16_READREQ_RCONT_Pos = 0xe    // Position of RCONT field.
	TC_COUNT16_READREQ_RCONT_Msk = 0x4000 // Bit mask of RCONT field.
	TC_COUNT16_READREQ_RCONT     = 0x4000 // Bit RCONT.
	TC_COUNT16_READREQ_RREQ_Pos  = 0xf    // Position of RREQ field.
	TC_COUNT16_READREQ_RREQ_Msk  = 0x8000 // Bit mask of RREQ field.
	TC_COUNT16_READREQ_RREQ      = 0x8000 // Bit RREQ.

	// CTRLBCLR: Control B Clear
	TC_COUNT16_CTRLBCLR_DIR_Pos       = 0x0  // Position of DIR field.
	TC_COUNT16_CTRLBCLR_DIR_Msk       = 0x1  // Bit mask of DIR field.
	TC_COUNT16_CTRLBCLR_DIR           = 0x1  // Bit DIR.
	TC_COUNT16_CTRLBCLR_ONESHOT_Pos   = 0x2  // Position of ONESHOT field.
	TC_COUNT16_CTRLBCLR_ONESHOT_Msk   = 0x4  // Bit mask of ONESHOT field.
	TC_COUNT16_CTRLBCLR_ONESHOT       = 0x4  // Bit ONESHOT.
	TC_COUNT16_CTRLBCLR_CMD_Pos       = 0x6  // Position of CMD field.
	TC_COUNT16_CTRLBCLR_CMD_Msk       = 0xc0 // Bit mask of CMD field.
	TC_COUNT16_CTRLBCLR_CMD_NONE      = 0x0  // No action
	TC_COUNT16_CTRLBCLR_CMD_RETRIGGER = 0x1  // Force a start, restart or retrigger
	TC_COUNT16_CTRLBCLR_CMD_STOP      = 0x2  // Force a stop

	// CTRLBSET: Control B Set
	TC_COUNT16_CTRLBSET_DIR_Pos       = 0x0  // Position of DIR field.
	TC_COUNT16_CTRLBSET_DIR_Msk       = 0x1  // Bit mask of DIR field.
	TC_COUNT16_CTRLBSET_DIR           = 0x1  // Bit DIR.
	TC_COUNT16_CTRLBSET_ONESHOT_Pos   = 0x2  // Position of ONESHOT field.
	TC_COUNT16_CTRLBSET_ONESHOT_Msk   = 0x4  // Bit mask of ONESHOT field.
	TC_COUNT16_CTRLBSET_ONESHOT       = 0x4  // Bit ONESHOT.
	TC_COUNT16_CTRLBSET_CMD_Pos       = 0x6  // Position of CMD field.
	TC_COUNT16_CTRLBSET_CMD_Msk       = 0xc0 // Bit mask of CMD field.
	TC_COUNT16_CTRLBSET_CMD_NONE      = 0x0  // No action
	TC_COUNT16_CTRLBSET_CMD_RETRIGGER = 0x1  // Force a start, restart or retrigger
	TC_COUNT16_CTRLBSET_CMD_STOP      = 0x2  // Force a stop

	// CTRLC: Control C
	TC_COUNT16_CTRLC_INVEN0_Pos = 0x0  // Position of INVEN0 field.
	TC_COUNT16_CTRLC_INVEN0_Msk = 0x1  // Bit mask of INVEN0 field.
	TC_COUNT16_CTRLC_INVEN0     = 0x1  // Bit INVEN0.
	TC_COUNT16_CTRLC_INVEN1_Pos = 0x1  // Position of INVEN1 field.
	TC_COUNT16_CTRLC_INVEN1_Msk = 0x2  // Bit mask of INVEN1 field.
	TC_COUNT16_CTRLC_INVEN1     = 0x2  // Bit INVEN1.
	TC_COUNT16_CTRLC_CPTEN0_Pos = 0x4  // Position of CPTEN0 field.
	TC_COUNT16_CTRLC_CPTEN0_Msk = 0x10 // Bit mask of CPTEN0 field.
	TC_COUNT16_CTRLC_CPTEN0     = 0x10 // Bit CPTEN0.
	TC_COUNT16_CTRLC_CPTEN1_Pos = 0x5  // Position of CPTEN1 field.
	TC_COUNT16_CTRLC_CPTEN1_Msk = 0x20 // Bit mask of CPTEN1 field.
	TC_COUNT16_CTRLC_CPTEN1     = 0x20 // Bit CPTEN1.

	// DBGCTRL: Debug Control
	TC_COUNT16_DBGCTRL_DBGRUN_Pos = 0x0 // Position of DBGRUN field.
	TC_COUNT16_DBGCTRL_DBGRUN_Msk = 0x1 // Bit mask of DBGRUN field.
	TC_COUNT16_DBGCTRL_DBGRUN     = 0x1 // Bit DBGRUN.

	// EVCTRL: Event Control
	TC_COUNT16_EVCTRL_EVACT_Pos       = 0x0    // Position of EVACT field.
	TC_COUNT16_EVCTRL_EVACT_Msk       = 0x7    // Bit mask of EVACT field.
	TC_COUNT16_EVCTRL_EVACT_OFF       = 0x0    // Event action disabled
	TC_COUNT16_EVCTRL_EVACT_RETRIGGER = 0x1    // Start, restart or retrigger TC on event
	TC_COUNT16_EVCTRL_EVACT_COUNT     = 0x2    // Count on event
	TC_COUNT16_EVCTRL_EVACT_START     = 0x3    // Start TC on event
	TC_COUNT16_EVCTRL_EVACT_PPW       = 0x5    // Period captured in CC0, pulse width in CC1
	TC_COUNT16_EVCTRL_EVACT_PWP       = 0x6    // Period captured in CC1, pulse width in CC0
	TC_COUNT16_EVCTRL_TCINV_Pos       = 0x4    // Position of TCINV field.
	TC_COUNT16_EVCTRL_TCINV_Msk       = 0x10   // Bit mask of TCINV field.
	TC_COUNT16_EVCTRL_TCINV           = 0x10   // Bit TCINV.
	TC_COUNT16_EVCTRL_TCEI_Pos        = 0x5    // Position of TCEI field.
	TC_COUNT16_EVCTRL_TCEI_Msk        = 0x20   // Bit mask of TCEI field.
	TC_COUNT16_EVCTRL_TCEI            = 0x20   // Bit TCEI.
	TC_COUNT16_EVCTRL_OVFEO_Pos       = 0x8    // Position of OVFEO field.
	TC_COUNT16_EVCTRL_OVFEO_Msk       = 0x100  // Bit mask of OVFEO field.
	TC_COUNT16_EVCTRL_OVFEO           = 0x100  // Bit OVFEO.
	TC_COUNT16_EVCTRL_MCEO0_Pos       = 0xc    // Position of MCEO0 field.
	TC_COUNT16_EVCTRL_MCEO0_Msk       = 0x1000 // Bit mask of MCEO0 field.
	TC_COUNT16_EVCTRL_MCEO0           = 0x1000 // Bit MCEO0.
	TC_COUNT16_EVCTRL_MCEO1_Pos       = 0xd    // Position of MCEO1 field.
	TC_COUNT16_EVCTRL_MCEO1_Msk       = 0x2000 // Bit mask of MCEO1 field.
	TC_COUNT16_EVCTRL_MCEO1           = 0x2000 // Bit MCEO1.

	// INTENCLR: Interrupt Enable Clear
	TC_COUNT16_INTENCLR_OVF_Pos     = 0x0  // Position of OVF field.
	TC_COUNT16_INTENCLR_OVF_Msk     = 0x1  // Bit mask of OVF field.
	TC_COUNT16_INTENCLR_OVF         = 0x1  // Bit OVF.
	TC_COUNT16_INTENCLR_ERR_Pos     = 0x1  // Position of ERR field.
	TC_COUNT16_INTENCLR_ERR_Msk     = 0x2  // Bit mask of ERR field.
	TC_COUNT16_INTENCLR_ERR         = 0x2  // Bit ERR.
	TC_COUNT16_INTENCLR_SYNCRDY_Pos = 0x3  // Position of SYNCRDY field.
	TC_COUNT16_INTENCLR_SYNCRDY_Msk = 0x8  // Bit mask of SYNCRDY field.
	TC_COUNT16_INTENCLR_SYNCRDY     = 0x8  // Bit SYNCRDY.
	TC_COUNT16_INTENCLR_MC0_Pos     = 0x4  // Position of MC0 field.
	TC_COUNT16_INTENCLR_MC0_Msk     = 0x10 // Bit mask of MC0 field.
	TC_COUNT16_INTENCLR_MC0         = 0x10 // Bit MC0.
	TC_COUNT16_INTENCLR_MC1_Pos     = 0x5  // Position of MC1 field.
	TC_COUNT16_INTENCLR_MC1_Msk     = 0x20 // Bit mask of MC1 field.
	TC_COUNT16_INTENCLR_MC1         = 0x20 // Bit MC1.

	// INTENSET: Interrupt Enable Set
	TC_COUNT16_INTENSET_OVF_Pos     = 0x0  // Position of OVF field.
	TC_COUNT16_INTENSET_OVF_Msk     = 0x1  // Bit mask of OVF field.
	TC_COUNT16_INTENSET_OVF         = 0x1  // Bit OVF.
	TC_COUNT16_INTENSET_ERR_Pos     = 0x1  // Position of ERR field.
	TC_COUNT16_INTENSET_ERR_Msk     = 0x2  // Bit mask of ERR field.
	TC_COUNT16_INTENSET_ERR         = 0x2  // Bit ERR.
	TC_COUNT16_INTENSET_SYNCRDY_Pos = 0x3  // Position of SYNCRDY field.
	TC_COUNT16_INTENSET_SYNCRDY_Msk = 0x8  // Bit mask of SYNCRDY field.
	TC_COUNT16_INTENSET_SYNCRDY     = 0x8  // Bit SYNCRDY.
	TC_COUNT16_INTENSET_MC0_Pos     = 0x4  // Position of MC0 field.
	TC_COUNT16_INTENSET_MC0_Msk     = 0x10 // Bit mask of MC0 field.
	TC_COUNT16_INTENSET_MC0         = 0x10 // Bit MC0.
	TC_COUNT16_INTENSET_MC1_Pos     = 0x5  // Position of MC1 field.
	TC_COUNT16_INTENSET_MC1_Msk     = 0x20 // Bit mask of MC1 field.
	TC_COUNT16_INTENSET_MC1         = 0x20 // Bit MC1.

	// INTFLAG: Interrupt Flag Status and Clear
	TC_COUNT16_INTFLAG_OVF_Pos     = 0x0  // Position of OVF field.
	TC_COUNT16_INTFLAG_OVF_Msk     = 0x1  // Bit mask of OVF field.
	TC_COUNT16_INTFLAG_OVF         = 0x1  // Bit OVF.
	TC_COUNT16_INTFLAG_ERR_Pos     = 0x1  // Position of ERR field.
	TC_COUNT16_INTFLAG_ERR_Msk     = 0x2  // Bit mask of ERR field.
	TC_COUNT16_INTFLAG_ERR         = 0x2  // Bit ERR.
	TC_COUNT16_INTFLAG_SYNCRDY_Pos = 0x3  // Position of SYNCRDY field.
	TC_COUNT16_INTFLAG_SYNCRDY_Msk = 0x8  // Bit mask of SYNCRDY field.
	TC_COUNT16_INTFLAG_SYNCRDY     = 0x8  // Bit SYNCRDY.
	TC_COUNT16_INTFLAG_MC0_Pos     = 0x4  // Position of MC0 field.
	TC_COUNT16_INTFLAG_MC0_Msk     = 0x10 // Bit mask of MC0 field.
	TC_COUNT16_INTFLAG_MC0         = 0x10 // Bit MC0.
	TC_COUNT16_INTFLAG_MC1_Pos     = 0x5  // Position of MC1 field.
	TC_COUNT16_INTFLAG_MC1_Msk     = 0x20 // Bit mask of MC1 field.
	TC_COUNT16_INTFLAG_MC1         = 0x20 // Bit MC1.

	// STATUS: Status
	TC_COUNT16_STATUS_STOP_Pos     = 0x3  // Position of STOP field.
	TC_COUNT16_STATUS_STOP_Msk     = 0x8  // Bit mask of STOP field.
	TC_COUNT16_STATUS_STOP         = 0x8  // Bit STOP.
	TC_COUNT16_STATUS_SLAVE_Pos    = 0x4  // Position of SLAVE field.
	TC_COUNT16_STATUS_SLAVE_Msk    = 0x10 // Bit mask of SLAVE field.
	TC_COUNT16_STATUS_SLAVE        = 0x10 // Bit SLAVE.
	TC_COUNT16_STATUS_SYNCBUSY_Pos = 0x7  // Position of SYNCBUSY field.
	TC_COUNT16_STATUS_SYNCBUSY_Msk = 0x80 // Bit mask of SYNCBUSY field.
	TC_COUNT16_STATUS_SYNCBUSY     = 0x80 // Bit SYNCBUSY.

	// COUNT: COUNT16 Counter Value
	TC_COUNT16_COUNT_COUNT_Pos = 0x0    // Position of COUNT field.
	TC_COUNT16_COUNT_COUNT_Msk = 0xffff // Bit mask of COUNT field.

	// CC0: COUNT16 Compare/Capture
	TC_COUNT16_CC_CC_Pos = 0x0    // Position of CC field.
	TC_COUNT16_CC_CC_Msk = 0xffff // Bit mask of CC field.
)

// Bitfields for TC3_COUNT32: Basic Timer Counter 3 - COUNT32
const (
	// CTRLA: Control A
	TC_COUNT32_CTRLA_SWRST_Pos         = 0x0  // Position of SWRST field.
	TC_COUNT32_CTRLA_SWRST_Msk         = 0x1  // Bit mask of SWRST field.
	TC_COUNT32_CTRLA_SWRST             = 0x1  // Bit SWRST.
	TC_COUNT32_CTRLA_ENABLE_Pos        = 0x1  // Position of ENABLE field.
	TC_COUNT32_CTRLA_ENABLE_Msk        = 0x2  // Bit mask of ENABLE field.
	TC_COUNT32_CTRLA_ENABLE            = 0x2  // Bit ENABLE.
	TC_COUNT32_CTRLA_MODE_Pos          = 0x2  // Position of MODE field.
	TC_COUNT32_CTRLA_MODE_Msk          = 0xc  // Bit mask of MODE field.
	TC_COUNT32_CTRLA_MODE_COUNT16      = 0x0  // Counter in 16-bit mode
	TC_COUNT32_CTRLA_MODE_COUNT8       = 0x1  // Counter in 8-bit mode
	TC_COUNT32_CTRLA_MODE_COUNT32      = 0x2  // Counter in 32-bit mode
	TC_COUNT32_CTRLA_WAVEGEN_Pos       = 0x5  // Position of WAVEGEN field.
	TC_COUNT32_CTRLA_WAVEGEN_Msk       = 0x60 // Bit mask of WAVEGEN field.
	TC_COUNT32_CTRLA_WAVEGEN_NFRQ      = 0x0
	TC_COUNT32_CTRLA_WAVEGEN_MFRQ      = 0x1
	TC_COUNT32_CTRLA_WAVEGEN_NPWM      = 0x2
	TC_COUNT32_CTRLA_WAVEGEN_MPWM      = 0x3
	TC_COUNT32_CTRLA_PRESCALER_Pos     = 0x8    // Position of PRESCALER field.
	TC_COUNT32_CTRLA_PRESCALER_Msk     = 0x700  // Bit mask of PRESCALER field.
	TC_COUNT32_CTRLA_PRESCALER_DIV1    = 0x0    // Prescaler: GCLK_TC
	TC_COUNT32_CTRLA_PRESCALER_DIV2    = 0x1    // Prescaler: GCLK_TC/2
	TC_COUNT32_CTRLA_PRESCALER_DIV4    = 0x2    // Prescaler: GCLK_TC/4
	TC_COUNT32_CTRLA_PRESCALER_DIV8    = 0x3    // Prescaler: GCLK_TC/8
	TC_COUNT32_CTRLA_PRESCALER_DIV16   = 0x4    // Prescaler: GCLK_TC/16
	TC_COUNT32_CTRLA_PRESCALER_DIV64   = 0x5    // Prescaler: GCLK_TC/64
	TC_COUNT32_CTRLA_PRESCALER_DIV256  = 0x6    // Prescaler: GCLK_TC/256
	TC_COUNT32_CTRLA_PRESCALER_DIV1024 = 0x7    // Prescaler: GCLK_TC/1024
	TC_COUNT32_CTRLA_RUNSTDBY_Pos      = 0xb    // Position of RUNSTDBY field.
	TC_COUNT32_CTRLA_RUNSTDBY_Msk      = 0x800  // Bit mask of RUNSTDBY field.
	TC_COUNT32_CTRLA_RUNSTDBY          = 0x800  // Bit RUNSTDBY.
	TC_COUNT32_CTRLA_PRESCSYNC_Pos     = 0xc    // Position of PRESCSYNC field.
	TC_COUNT32_CTRLA_PRESCSYNC_Msk     = 0x3000 // Bit mask of PRESCSYNC field.
	TC_COUNT32_CTRLA_PRESCSYNC_GCLK    = 0x0    // Reload or reset the counter on next generic clock
	TC_COUNT32_CTRLA_PRESCSYNC_PRESC   = 0x1    // Reload or reset the counter on next prescaler clock
	TC_COUNT32_CTRLA_PRESCSYNC_RESYNC  = 0x2    // Reload or reset the counter on next generic clock. Reset the prescaler counter

	// READREQ: Read Request
	TC_COUNT32_READREQ_ADDR_Pos  = 0x0    // Position of ADDR field.
	TC_COUNT32_READREQ_ADDR_Msk  = 0x1f   // Bit mask of ADDR field.
	TC_COUNT32_READREQ_RCONT_Pos = 0xe    // Position of RCONT field.
	TC_COUNT32_READREQ_RCONT_Msk = 0x4000 // Bit mask of RCONT field.
	TC_COUNT32_READREQ_RCONT     = 0x4000 // Bit RCONT.
	TC_COUNT32_READREQ_RREQ_Pos  = 0xf    // Position of RREQ field.
	TC_COUNT32_READREQ_RREQ_Msk  = 0x8000 // Bit mask of RREQ field.
	TC_COUNT32_READREQ_RREQ      = 0x8000 // Bit RREQ.

	// CTRLBCLR: Control B Clear
	TC_COUNT32_CTRLBCLR_DIR_Pos       = 0x0  // Position of DIR field.
	TC_COUNT32_CTRLBCLR_DIR_Msk       = 0x1  // Bit mask of DIR field.
	TC_COUNT32_CTRLBCLR_DIR           = 0x1  // Bit DIR.
	TC_COUNT32_CTRLBCLR_ONESHOT_Pos   = 0x2  // Position of ONESHOT field.
	TC_COUNT32_CTRLBCLR_ONESHOT_Msk   = 0x4  // Bit mask of ONESHOT field.
	TC_COUNT32_CTRLBCLR_ONESHOT       = 0x4  // Bit ONESHOT.
	TC_COUNT32_CTRLBCLR_CMD_Pos       = 0x6  // Position of CMD field.
	TC_COUNT32_CTRLBCLR_CMD_Msk       = 0xc0 // Bit mask of CMD field.
	TC_COUNT32_CTRLBCLR_CMD_NONE      = 0x0  // No action
	TC_COUNT32_CTRLBCLR_CMD_RETRIGGER = 0x1  // Force a start, restart or retrigger
	TC_COUNT32_CTRLBCLR_CMD_STOP      = 0x2  // Force a stop

	// CTRLBSET: Control B Set
	TC_COUNT32_CTRLBSET_DIR_Pos       = 0x0  // Position of DIR field.
	TC_COUNT32_CTRLBSET_DIR_Msk       = 0x1  // Bit mask of DIR field.
	TC_COUNT32_CTRLBSET_DIR           = 0x1  // Bit DIR.
	TC_COUNT32_CTRLBSET_ONESHOT_Pos   = 0x2  // Position of ONESHOT field.
	TC_COUNT32_CTRLBSET_ONESHOT_Msk   = 0x4  // Bit mask of ONESHOT field.
	TC_COUNT32_CTRLBSET_ONESHOT       = 0x4  // Bit ONESHOT.
	TC_COUNT32_CTRLBSET_CMD_Pos       = 0x6  // Position of CMD field.
	TC_COUNT32_CTRLBSET_CMD_Msk       = 0xc0 // Bit mask of CMD field.
	TC_COUNT32_CTRLBSET_CMD_NONE      = 0x0  // No action
	TC_COUNT32_CTRLBSET_CMD_RETRIGGER = 0x1  // Force a start, restart or retrigger
	TC_COUNT32_CTRLBSET_CMD_STOP      = 0x2  // Force a stop

	// CTRLC: Control C
	TC_COUNT32_CTRLC_INVEN0_Pos = 0x0  // Position of INVEN0 field.
	TC_COUNT32_CTRLC_INVEN0_Msk = 0x1  // Bit mask of INVEN0 field.
	TC_COUNT32_CTRLC_INVEN0     = 0x1  // Bit INVEN0.
	TC_COUNT32_CTRLC_INVEN1_Pos = 0x1  // Position of INVEN1 field.
	TC_COUNT32_CTRLC_INVEN1_Msk = 0x2  // Bit mask of INVEN1 field.
	TC_COUNT32_CTRLC_INVEN1     = 0x2  // Bit INVEN1.
	TC_COUNT32_CTRLC_CPTEN0_Pos = 0x4  // Position of CPTEN0 field.
	TC_COUNT32_CTRLC_CPTEN0_Msk = 0x10 // Bit mask of CPTEN0 field.
	TC_COUNT32_CTRLC_CPTEN0     = 0x10 // Bit CPTEN0.
	TC_COUNT32_CTRLC_CPTEN1_Pos = 0x5  // Position of CPTEN1 field.
	TC_COUNT32_CTRLC_CPTEN1_Msk = 0x20 // Bit mask of CPTEN1 field.
	TC_COUNT32_CTRLC_CPTEN1     = 0x20 // Bit CPTEN1.

	// DBGCTRL: Debug Control
	TC_COUNT32_DBGCTRL_DBGRUN_Pos = 0x0 // Position of DBGRUN field.
	TC_COUNT32_DBGCTRL_DBGRUN_Msk = 0x1 // Bit mask of DBGRUN field.
	TC_COUNT32_DBGCTRL_DBGRUN     = 0x1 // Bit DBGRUN.

	// EVCTRL: Event Control
	TC_COUNT32_EVCTRL_EVACT_Pos       = 0x0    // Position of EVACT field.
	TC_COUNT32_EVCTRL_EVACT_Msk       = 0x7    // Bit mask of EVACT field.
	TC_COUNT32_EVCTRL_EVACT_OFF       = 0x0    // Event action disabled
	TC_COUNT32_EVCTRL_EVACT_RETRIGGER = 0x1    // Start, restart or retrigger TC on event
	TC_COUNT32_EVCTRL_EVACT_COUNT     = 0x2    // Count on event
	TC_COUNT32_EVCTRL_EVACT_START     = 0x3    // Start TC on event
	TC_COUNT32_EVCTRL_EVACT_PPW       = 0x5    // Period captured in CC0, pulse width in CC1
	TC_COUNT32_EVCTRL_EVACT_PWP       = 0x6    // Period captured in CC1, pulse width in CC0
	TC_COUNT32_EVCTRL_TCINV_Pos       = 0x4    // Position of TCINV field.
	TC_COUNT32_EVCTRL_TCINV_Msk       = 0x10   // Bit mask of TCINV field.
	TC_COUNT32_EVCTRL_TCINV           = 0x10   // Bit TCINV.
	TC_COUNT32_EVCTRL_TCEI_Pos        = 0x5    // Position of TCEI field.
	TC_COUNT32_EVCTRL_TCEI_Msk        = 0x20   // Bit mask of TCEI field.
	TC_COUNT32_EVCTRL_TCEI            = 0x20   // Bit TCEI.
	TC_COUNT32_EVCTRL_OVFEO_Pos       = 0x8    // Position of OVFEO field.
	TC_COUNT32_EVCTRL_OVFEO_Msk       = 0x100  // Bit mask of OVFEO field.
	TC_COUNT32_EVCTRL_OVFEO           = 0x100  // Bit OVFEO.
	TC_COUNT32_EVCTRL_MCEO0_Pos       = 0xc    // Position of MCEO0 field.
	TC_COUNT32_EVCTRL_MCEO0_Msk       = 0x1000 // Bit mask of MCEO0 field.
	TC_COUNT32_EVCTRL_MCEO0           = 0x1000 // Bit MCEO0.
	TC_COUNT32_EVCTRL_MCEO1_Pos       = 0xd    // Position of MCEO1 field.
	TC_COUNT32_EVCTRL_MCEO1_Msk       = 0x2000 // Bit mask of MCEO1 field.
	TC_COUNT32_EVCTRL_MCEO1           = 0x2000 // Bit MCEO1.

	// INTENCLR: Interrupt Enable Clear
	TC_COUNT32_INTENCLR_OVF_Pos     = 0x0  // Position of OVF field.
	TC_COUNT32_INTENCLR_OVF_Msk     = 0x1  // Bit mask of OVF field.
	TC_COUNT32_INTENCLR_OVF         = 0x1  // Bit OVF.
	TC_COUNT32_INTENCLR_ERR_Pos     = 0x1  // Position of ERR field.
	TC_COUNT32_INTENCLR_ERR_Msk     = 0x2  // Bit mask of ERR field.
	TC_COUNT32_INTENCLR_ERR         = 0x2  // Bit ERR.
	TC_COUNT32_INTENCLR_SYNCRDY_Pos = 0x3  // Position of SYNCRDY field.
	TC_COUNT32_INTENCLR_SYNCRDY_Msk = 0x8  // Bit mask of SYNCRDY field.
	TC_COUNT32_INTENCLR_SYNCRDY     = 0x8  // Bit SYNCRDY.
	TC_COUNT32_INTENCLR_MC0_Pos     = 0x4  // Position of MC0 field.
	TC_COUNT32_INTENCLR_MC0_Msk     = 0x10 // Bit mask of MC0 field.
	TC_COUNT32_INTENCLR_MC0         = 0x10 // Bit MC0.
	TC_COUNT32_INTENCLR_MC1_Pos     = 0x5  // Position of MC1 field.
	TC_COUNT32_INTENCLR_MC1_Msk     = 0x20 // Bit mask of MC1 field.
	TC_COUNT32_INTENCLR_MC1         = 0x20 // Bit MC1.

	// INTENSET: Interrupt Enable Set
	TC_COUNT32_INTENSET_OVF_Pos     = 0x0  // Position of OVF field.
	TC_COUNT32_INTENSET_OVF_Msk     = 0x1  // Bit mask of OVF field.
	TC_COUNT32_INTENSET_OVF         = 0x1  // Bit OVF.
	TC_COUNT32_INTENSET_ERR_Pos     = 0x1  // Position of ERR field.
	TC_COUNT32_INTENSET_ERR_Msk     = 0x2  // Bit mask of ERR field.
	TC_COUNT32_INTENSET_ERR         = 0x2  // Bit ERR.
	TC_COUNT32_INTENSET_SYNCRDY_Pos = 0x3  // Position of SYNCRDY field.
	TC_COUNT32_INTENSET_SYNCRDY_Msk = 0x8  // Bit mask of SYNCRDY field.
	TC_COUNT32_INTENSET_SYNCRDY     = 0x8  // Bit SYNCRDY.
	TC_COUNT32_INTENSET_MC0_Pos     = 0x4  // Position of MC0 field.
	TC_COUNT32_INTENSET_MC0_Msk     = 0x10 // Bit mask of MC0 field.
	TC_COUNT32_INTENSET_MC0         = 0x10 // Bit MC0.
	TC_COUNT32_INTENSET_MC1_Pos     = 0x5  // Position of MC1 field.
	TC_COUNT32_INTENSET_MC1_Msk     = 0x20 // Bit mask of MC1 field.
	TC_COUNT32_INTENSET_MC1         = 0x20 // Bit MC1.

	// INTFLAG: Interrupt Flag Status and Clear
	TC_COUNT32_INTFLAG_OVF_Pos     = 0x0  // Position of OVF field.
	TC_COUNT32_INTFLAG_OVF_Msk     = 0x1  // Bit mask of OVF field.
	TC_COUNT32_INTFLAG_OVF         = 0x1  // Bit OVF.
	TC_COUNT32_INTFLAG_ERR_Pos     = 0x1  // Position of ERR field.
	TC_COUNT32_INTFLAG_ERR_Msk     = 0x2  // Bit mask of ERR field.
	TC_COUNT32_INTFLAG_ERR         = 0x2  // Bit ERR.
	TC_COUNT32_INTFLAG_SYNCRDY_Pos = 0x3  // Position of SYNCRDY field.
	TC_COUNT32_INTFLAG_SYNCRDY_Msk = 0x8  // Bit mask of SYNCRDY field.
	TC_COUNT32_INTFLAG_SYNCRDY     = 0x8  // Bit SYNCRDY.
	TC_COUNT32_INTFLAG_MC0_Pos     = 0x4  // Position of MC0 field.
	TC_COUNT32_INTFLAG_MC0_Msk     = 0x10 // Bit mask of MC0 field.
	TC_COUNT32_INTFLAG_MC0         = 0x10 // Bit MC0.
	TC_COUNT32_INTFLAG_MC1_Pos     = 0x5  // Position of MC1 field.
	TC_COUNT32_INTFLAG_MC1_Msk     = 0x20 // Bit mask of MC1 field.
	TC_COUNT32_INTFLAG_MC1         = 0x20 // Bit MC1.

	// STATUS: Status
	TC_COUNT32_STATUS_STOP_Pos     = 0x3  // Position of STOP field.
	TC_COUNT32_STATUS_STOP_Msk     = 0x8  // Bit mask of STOP field.
	TC_COUNT32_STATUS_STOP         = 0x8  // Bit STOP.
	TC_COUNT32_STATUS_SLAVE_Pos    = 0x4  // Position of SLAVE field.
	TC_COUNT32_STATUS_SLAVE_Msk    = 0x10 // Bit mask of SLAVE field.
	TC_COUNT32_STATUS_SLAVE        = 0x10 // Bit SLAVE.
	TC_COUNT32_STATUS_SYNCBUSY_Pos = 0x7  // Position of SYNCBUSY field.
	TC_COUNT32_STATUS_SYNCBUSY_Msk = 0x80 // Bit mask of SYNCBUSY field.
	TC_COUNT32_STATUS_SYNCBUSY     = 0x80 // Bit SYNCBUSY.

	// COUNT: COUNT32 Counter Value
	TC_COUNT32_COUNT_COUNT_Pos = 0x0        // Position of COUNT field.
	TC_COUNT32_COUNT_COUNT_Msk = 0xffffffff // Bit mask of COUNT field.

	// CC0: COUNT32 Compare/Capture
	TC_COUNT32_CC_CC_Pos = 0x0        // Position of CC field.
	TC_COUNT32_CC_CC_Msk = 0xffffffff // Bit mask of CC field.
)

// Bitfields for TCC0: Timer Counter Control 0
const (
	// CTRLA: Control A
	TCC_CTRLA_SWRST_Pos         = 0x0       // Position of SWRST field.
	TCC_CTRLA_SWRST_Msk         = 0x1       // Bit mask of SWRST field.
	TCC_CTRLA_SWRST             = 0x1       // Bit SWRST.
	TCC_CTRLA_ENABLE_Pos        = 0x1       // Position of ENABLE field.
	TCC_CTRLA_ENABLE_Msk        = 0x2       // Bit mask of ENABLE field.
	TCC_CTRLA_ENABLE            = 0x2       // Bit ENABLE.
	TCC_CTRLA_RESOLUTION_Pos    = 0x5       // Position of RESOLUTION field.
	TCC_CTRLA_RESOLUTION_Msk    = 0x60      // Bit mask of RESOLUTION field.
	TCC_CTRLA_RESOLUTION_NONE   = 0x0       // Dithering is disabled
	TCC_CTRLA_RESOLUTION_DITH4  = 0x1       // Dithering is done every 16 PWM frames
	TCC_CTRLA_RESOLUTION_DITH5  = 0x2       // Dithering is done every 32 PWM frames
	TCC_CTRLA_RESOLUTION_DITH6  = 0x3       // Dithering is done every 64 PWM frames
	TCC_CTRLA_PRESCALER_Pos     = 0x8       // Position of PRESCALER field.
	TCC_CTRLA_PRESCALER_Msk     = 0x700     // Bit mask of PRESCALER field.
	TCC_CTRLA_PRESCALER_DIV1    = 0x0       // No division
	TCC_CTRLA_PRESCALER_DIV2    = 0x1       // Divide by 2
	TCC_CTRLA_PRESCALER_DIV4    = 0x2       // Divide by 4
	TCC_CTRLA_PRESCALER_DIV8    = 0x3       // Divide by 8
	TCC_CTRLA_PRESCALER_DIV16   = 0x4       // Divide by 16
	TCC_CTRLA_PRESCALER_DIV64   = 0x5       // Divide by 64
	TCC_CTRLA_PRESCALER_DIV256  = 0x6       // Divide by 256
	TCC_CTRLA_PRESCALER_DIV1024 = 0x7       // Divide by 1024
	TCC_CTRLA_RUNSTDBY_Pos      = 0xb       // Position of RUNSTDBY field.
	TCC_CTRLA_RUNSTDBY_Msk      = 0x800     // Bit mask of RUNSTDBY field.
	TCC_CTRLA_RUNSTDBY          = 0x800     // Bit RUNSTDBY.
	TCC_CTRLA_PRESCSYNC_Pos     = 0xc       // Position of PRESCSYNC field.
	TCC_CTRLA_PRESCSYNC_Msk     = 0x3000    // Bit mask of PRESCSYNC field.
	TCC_CTRLA_PRESCSYNC_GCLK    = 0x0       // Reload or reset counter on next GCLK
	TCC_CTRLA_PRESCSYNC_PRESC   = 0x1       // Reload or reset counter on next prescaler clock
	TCC_CTRLA_PRESCSYNC_RESYNC  = 0x2       // Reload or reset counter on next GCLK and reset prescaler counter
	TCC_CTRLA_ALOCK_Pos         = 0xe       // Position of ALOCK field.
	TCC_CTRLA_ALOCK_Msk         = 0x4000    // Bit mask of ALOCK field.
	TCC_CTRLA_ALOCK             = 0x4000    // Bit ALOCK.
	TCC_CTRLA_CPTEN0_Pos        = 0x18      // Position of CPTEN0 field.
	TCC_CTRLA_CPTEN0_Msk        = 0x1000000 // Bit mask of CPTEN0 field.
	TCC_CTRLA_CPTEN0            = 0x1000000 // Bit CPTEN0.
	TCC_CTRLA_CPTEN1_Pos        = 0x19      // Position of CPTEN1 field.
	TCC_CTRLA_CPTEN1_Msk        = 0x2000000 // Bit mask of CPTEN1 field.
	TCC_CTRLA_CPTEN1            = 0x2000000 // Bit CPTEN1.
	TCC_CTRLA_CPTEN2_Pos        = 0x1a      // Position of CPTEN2 field.
	TCC_CTRLA_CPTEN2_Msk        = 0x4000000 // Bit mask of CPTEN2 field.
	TCC_CTRLA_CPTEN2            = 0x4000000 // Bit CPTEN2.
	TCC_CTRLA_CPTEN3_Pos        = 0x1b      // Position of CPTEN3 field.
	TCC_CTRLA_CPTEN3_Msk        = 0x8000000 // Bit mask of CPTEN3 field.
	TCC_CTRLA_CPTEN3            = 0x8000000 // Bit CPTEN3.

	// CTRLBCLR: Control B Clear
	TCC_CTRLBCLR_DIR_Pos        = 0x0  // Position of DIR field.
	TCC_CTRLBCLR_DIR_Msk        = 0x1  // Bit mask of DIR field.
	TCC_CTRLBCLR_DIR            = 0x1  // Bit DIR.
	TCC_CTRLBCLR_LUPD_Pos       = 0x1  // Position of LUPD field.
	TCC_CTRLBCLR_LUPD_Msk       = 0x2  // Bit mask of LUPD field.
	TCC_CTRLBCLR_LUPD           = 0x2  // Bit LUPD.
	TCC_CTRLBCLR_ONESHOT_Pos    = 0x2  // Position of ONESHOT field.
	TCC_CTRLBCLR_ONESHOT_Msk    = 0x4  // Bit mask of ONESHOT field.
	TCC_CTRLBCLR_ONESHOT        = 0x4  // Bit ONESHOT.
	TCC_CTRLBCLR_IDXCMD_Pos     = 0x3  // Position of IDXCMD field.
	TCC_CTRLBCLR_IDXCMD_Msk     = 0x18 // Bit mask of IDXCMD field.
	TCC_CTRLBCLR_IDXCMD_DISABLE = 0x0  // Command disabled: Index toggles between cycles A and B
	TCC_CTRLBCLR_IDXCMD_SET     = 0x1  // Set index: cycle B will be forced in the next cycle
	TCC_CTRLBCLR_IDXCMD_CLEAR   = 0x2  // Clear index: cycle A will be forced in the next cycle
	TCC_CTRLBCLR_IDXCMD_HOLD    = 0x3  // Hold index: the next cycle will be the same as the current cycle
	TCC_CTRLBCLR_CMD_Pos        = 0x5  // Position of CMD field.
	TCC_CTRLBCLR_CMD_Msk        = 0xe0 // Bit mask of CMD field.
	TCC_CTRLBCLR_CMD_NONE       = 0x0  // No action
	TCC_CTRLBCLR_CMD_RETRIGGER  = 0x1  // Clear start, restart or retrigger
	TCC_CTRLBCLR_CMD_STOP       = 0x2  // Force stop
	TCC_CTRLBCLR_CMD_UPDATE     = 0x3  // Force update of double buffered registers
	TCC_CTRLBCLR_CMD_READSYNC   = 0x4  // Force COUNT read synchronization

	// CTRLBSET: Control B Set
	TCC_CTRLBSET_DIR_Pos        = 0x0  // Position of DIR field.
	TCC_CTRLBSET_DIR_Msk        = 0x1  // Bit mask of DIR field.
	TCC_CTRLBSET_DIR            = 0x1  // Bit DIR.
	TCC_CTRLBSET_LUPD_Pos       = 0x1  // Position of LUPD field.
	TCC_CTRLBSET_LUPD_Msk       = 0x2  // Bit mask of LUPD field.
	TCC_CTRLBSET_LUPD           = 0x2  // Bit LUPD.
	TCC_CTRLBSET_ONESHOT_Pos    = 0x2  // Position of ONESHOT field.
	TCC_CTRLBSET_ONESHOT_Msk    = 0x4  // Bit mask of ONESHOT field.
	TCC_CTRLBSET_ONESHOT        = 0x4  // Bit ONESHOT.
	TCC_CTRLBSET_IDXCMD_Pos     = 0x3  // Position of IDXCMD field.
	TCC_CTRLBSET_IDXCMD_Msk     = 0x18 // Bit mask of IDXCMD field.
	TCC_CTRLBSET_IDXCMD_DISABLE = 0x0  // Command disabled: Index toggles between cycles A and B
	TCC_CTRLBSET_IDXCMD_SET     = 0x1  // Set index: cycle B will be forced in the next cycle
	TCC_CTRLBSET_IDXCMD_CLEAR   = 0x2  // Clear index: cycle A will be forced in the next cycle
	TCC_CTRLBSET_IDXCMD_HOLD    = 0x3  // Hold index: the next cycle will be the same as the current cycle
	TCC_CTRLBSET_CMD_Pos        = 0x5  // Position of CMD field.
	TCC_CTRLBSET_CMD_Msk        = 0xe0 // Bit mask of CMD field.
	TCC_CTRLBSET_CMD_NONE       = 0x0  // No action
	TCC_CTRLBSET_CMD_RETRIGGER  = 0x1  // Clear start, restart or retrigger
	TCC_CTRLBSET_CMD_STOP       = 0x2  // Force stop
	TCC_CTRLBSET_CMD_UPDATE     = 0x3  // Force update of double buffered registers
	TCC_CTRLBSET_CMD_READSYNC   = 0x4  // Force COUNT read synchronization

	// SYNCBUSY: Synchronization Busy
	TCC_SYNCBUSY_SWRST_Pos  = 0x0      // Position of SWRST field.
	TCC_SYNCBUSY_SWRST_Msk  = 0x1      // Bit mask of SWRST field.
	TCC_SYNCBUSY_SWRST      = 0x1      // Bit SWRST.
	TCC_SYNCBUSY_ENABLE_Pos = 0x1      // Position of ENABLE field.
	TCC_SYNCBUSY_ENABLE_Msk = 0x2      // Bit mask of ENABLE field.
	TCC_SYNCBUSY_ENABLE     = 0x2      // Bit ENABLE.
	TCC_SYNCBUSY_CTRLB_Pos  = 0x2      // Position of CTRLB field.
	TCC_SYNCBUSY_CTRLB_Msk  = 0x4      // Bit mask of CTRLB field.
	TCC_SYNCBUSY_CTRLB      = 0x4      // Bit CTRLB.
	TCC_SYNCBUSY_STATUS_Pos = 0x3      // Position of STATUS field.
	TCC_SYNCBUSY_STATUS_Msk = 0x8      // Bit mask of STATUS field.
	TCC_SYNCBUSY_STATUS     = 0x8      // Bit STATUS.
	TCC_SYNCBUSY_COUNT_Pos  = 0x4      // Position of COUNT field.
	TCC_SYNCBUSY_COUNT_Msk  = 0x10     // Bit mask of COUNT field.
	TCC_SYNCBUSY_COUNT      = 0x10     // Bit COUNT.
	TCC_SYNCBUSY_PATT_Pos   = 0x5      // Position of PATT field.
	TCC_SYNCBUSY_PATT_Msk   = 0x20     // Bit mask of PATT field.
	TCC_SYNCBUSY_PATT       = 0x20     // Bit PATT.
	TCC_SYNCBUSY_WAVE_Pos   = 0x6      // Position of WAVE field.
	TCC_SYNCBUSY_WAVE_Msk   = 0x40     // Bit mask of WAVE field.
	TCC_SYNCBUSY_WAVE       = 0x40     // Bit WAVE.
	TCC_SYNCBUSY_PER_Pos    = 0x7      // Position of PER field.
	TCC_SYNCBUSY_PER_Msk    = 0x80     // Bit mask of PER field.
	TCC_SYNCBUSY_PER        = 0x80     // Bit PER.
	TCC_SYNCBUSY_CC0_Pos    = 0x8      // Position of CC0 field.
	TCC_SYNCBUSY_CC0_Msk    = 0x100    // Bit mask of CC0 field.
	TCC_SYNCBUSY_CC0        = 0x100    // Bit CC0.
	TCC_SYNCBUSY_CC1_Pos    = 0x9      // Position of CC1 field.
	TCC_SYNCBUSY_CC1_Msk    = 0x200    // Bit mask of CC1 field.
	TCC_SYNCBUSY_CC1        = 0x200    // Bit CC1.
	TCC_SYNCBUSY_CC2_Pos    = 0xa      // Position of CC2 field.
	TCC_SYNCBUSY_CC2_Msk    = 0x400    // Bit mask of CC2 field.
	TCC_SYNCBUSY_CC2        = 0x400    // Bit CC2.
	TCC_SYNCBUSY_CC3_Pos    = 0xb      // Position of CC3 field.
	TCC_SYNCBUSY_CC3_Msk    = 0x800    // Bit mask of CC3 field.
	TCC_SYNCBUSY_CC3        = 0x800    // Bit CC3.
	TCC_SYNCBUSY_PATTB_Pos  = 0x10     // Position of PATTB field.
	TCC_SYNCBUSY_PATTB_Msk  = 0x10000  // Bit mask of PATTB field.
	TCC_SYNCBUSY_PATTB      = 0x10000  // Bit PATTB.
	TCC_SYNCBUSY_WAVEB_Pos  = 0x11     // Position of WAVEB field.
	TCC_SYNCBUSY_WAVEB_Msk  = 0x20000  // Bit mask of WAVEB field.
	TCC_SYNCBUSY_WAVEB      = 0x20000  // Bit WAVEB.
	TCC_SYNCBUSY_PERB_Pos   = 0x12     // Position of PERB field.
	TCC_SYNCBUSY_PERB_Msk   = 0x40000  // Bit mask of PERB field.
	TCC_SYNCBUSY_PERB       = 0x40000  // Bit PERB.
	TCC_SYNCBUSY_CCB0_Pos   = 0x13     // Position of CCB0 field.
	TCC_SYNCBUSY_CCB0_Msk   = 0x80000  // Bit mask of CCB0 field.
	TCC_SYNCBUSY_CCB0       = 0x80000  // Bit CCB0.
	TCC_SYNCBUSY_CCB1_Pos   = 0x14     // Position of CCB1 field.
	TCC_SYNCBUSY_CCB1_Msk   = 0x100000 // Bit mask of CCB1 field.
	TCC_SYNCBUSY_CCB1       = 0x100000 // Bit CCB1.
	TCC_SYNCBUSY_CCB2_Pos   = 0x15     // Position of CCB2 field.
	TCC_SYNCBUSY_CCB2_Msk   = 0x200000 // Bit mask of CCB2 field.
	TCC_SYNCBUSY_CCB2       = 0x200000 // Bit CCB2.
	TCC_SYNCBUSY_CCB3_Pos   = 0x16     // Position of CCB3 field.
	TCC_SYNCBUSY_CCB3_Msk   = 0x400000 // Bit mask of CCB3 field.
	TCC_SYNCBUSY_CCB3       = 0x400000 // Bit CCB3.

	// FCTRLA: Recoverable Fault A Configuration
	TCC_FCTRLA_SRC_Pos         = 0x0       // Position of SRC field.
	TCC_FCTRLA_SRC_Msk         = 0x3       // Bit mask of SRC field.
	TCC_FCTRLA_SRC_DISABLE     = 0x0       // Fault input disabled
	TCC_FCTRLA_SRC_ENABLE      = 0x1       // MCEx (x=0,1) event input
	TCC_FCTRLA_SRC_INVERT      = 0x2       // Inverted MCEx (x=0,1) event input
	TCC_FCTRLA_SRC_ALTFAULT    = 0x3       // Alternate fault (A or B) state at the end of the previous period
	TCC_FCTRLA_KEEP_Pos        = 0x3       // Position of KEEP field.
	TCC_FCTRLA_KEEP_Msk        = 0x8       // Bit mask of KEEP field.
	TCC_FCTRLA_KEEP            = 0x8       // Bit KEEP.
	TCC_FCTRLA_QUAL_Pos        = 0x4       // Position of QUAL field.
	TCC_FCTRLA_QUAL_Msk        = 0x10      // Bit mask of QUAL field.
	TCC_FCTRLA_QUAL            = 0x10      // Bit QUAL.
	TCC_FCTRLA_BLANK_Pos       = 0x5       // Position of BLANK field.
	TCC_FCTRLA_BLANK_Msk       = 0x60      // Bit mask of BLANK field.
	TCC_FCTRLA_BLANK_NONE      = 0x0       // No blanking applied
	TCC_FCTRLA_BLANK_RISE      = 0x1       // Blanking applied from rising edge of the output waveform
	TCC_FCTRLA_BLANK_FALL      = 0x2       // Blanking applied from falling edge of the output waveform
	TCC_FCTRLA_BLANK_BOTH      = 0x3       // Blanking applied from each toggle of the output waveform
	TCC_FCTRLA_RESTART_Pos     = 0x7       // Position of RESTART field.
	TCC_FCTRLA_RESTART_Msk     = 0x80      // Bit mask of RESTART field.
	TCC_FCTRLA_RESTART         = 0x80      // Bit RESTART.
	TCC_FCTRLA_HALT_Pos        = 0x8       // Position of HALT field.
	TCC_FCTRLA_HALT_Msk        = 0x300     // Bit mask of HALT field.
	TCC_FCTRLA_HALT_DISABLE    = 0x0       // Halt action disabled
	TCC_FCTRLA_HALT_HW         = 0x1       // Hardware halt action
	TCC_FCTRLA_HALT_SW         = 0x2       // Software halt action
	TCC_FCTRLA_HALT_NR         = 0x3       // Non-recoverable fault
	TCC_FCTRLA_CHSEL_Pos       = 0xa       // Position of CHSEL field.
	TCC_FCTRLA_CHSEL_Msk       = 0xc00     // Bit mask of CHSEL field.
	TCC_FCTRLA_CHSEL_CC0       = 0x0       // Capture value stored in channel 0
	TCC_FCTRLA_CHSEL_CC1       = 0x1       // Capture value stored in channel 1
	TCC_FCTRLA_CHSEL_CC2       = 0x2       // Capture value stored in channel 2
	TCC_FCTRLA_CHSEL_CC3       = 0x3       // Capture value stored in channel 3
	TCC_FCTRLA_CAPTURE_Pos     = 0xc       // Position of CAPTURE field.
	TCC_FCTRLA_CAPTURE_Msk     = 0x7000    // Bit mask of CAPTURE field.
	TCC_FCTRLA_CAPTURE_DISABLE = 0x0       // No capture
	TCC_FCTRLA_CAPTURE_CAPT    = 0x1       // Capture on fault
	TCC_FCTRLA_CAPTURE_CAPTMIN = 0x2       // Minimum capture
	TCC_FCTRLA_CAPTURE_CAPTMAX = 0x3       // Maximum capture
	TCC_FCTRLA_CAPTURE_LOCMIN  = 0x4       // Minimum local detection
	TCC_FCTRLA_CAPTURE_LOCMAX  = 0x5       // Maximum local detection
	TCC_FCTRLA_CAPTURE_DERIV0  = 0x6       // Minimum and maximum local detection
	TCC_FCTRLA_BLANKVAL_Pos    = 0x10      // Position of BLANKVAL field.
	TCC_FCTRLA_BLANKVAL_Msk    = 0xff0000  // Bit mask of BLANKVAL field.
	TCC_FCTRLA_FILTERVAL_Pos   = 0x18      // Position of FILTERVAL field.
	TCC_FCTRLA_FILTERVAL_Msk   = 0xf000000 // Bit mask of FILTERVAL field.

	// FCTRLB: Recoverable Fault B Configuration
	TCC_FCTRLB_SRC_Pos         = 0x0       // Position of SRC field.
	TCC_FCTRLB_SRC_Msk         = 0x3       // Bit mask of SRC field.
	TCC_FCTRLB_SRC_DISABLE     = 0x0       // Fault input disabled
	TCC_FCTRLB_SRC_ENABLE      = 0x1       // MCEx (x=0,1) event input
	TCC_FCTRLB_SRC_INVERT      = 0x2       // Inverted MCEx (x=0,1) event input
	TCC_FCTRLB_SRC_ALTFAULT    = 0x3       // Alternate fault (A or B) state at the end of the previous period
	TCC_FCTRLB_KEEP_Pos        = 0x3       // Position of KEEP field.
	TCC_FCTRLB_KEEP_Msk        = 0x8       // Bit mask of KEEP field.
	TCC_FCTRLB_KEEP            = 0x8       // Bit KEEP.
	TCC_FCTRLB_QUAL_Pos        = 0x4       // Position of QUAL field.
	TCC_FCTRLB_QUAL_Msk        = 0x10      // Bit mask of QUAL field.
	TCC_FCTRLB_QUAL            = 0x10      // Bit QUAL.
	TCC_FCTRLB_BLANK_Pos       = 0x5       // Position of BLANK field.
	TCC_FCTRLB_BLANK_Msk       = 0x60      // Bit mask of BLANK field.
	TCC_FCTRLB_BLANK_NONE      = 0x0       // No blanking applied
	TCC_FCTRLB_BLANK_RISE      = 0x1       // Blanking applied from rising edge of the output waveform
	TCC_FCTRLB_BLANK_FALL      = 0x2       // Blanking applied from falling edge of the output waveform
	TCC_FCTRLB_BLANK_BOTH      = 0x3       // Blanking applied from each toggle of the output waveform
	TCC_FCTRLB_RESTART_Pos     = 0x7       // Position of RESTART field.
	TCC_FCTRLB_RESTART_Msk     = 0x80      // Bit mask of RESTART field.
	TCC_FCTRLB_RESTART         = 0x80      // Bit RESTART.
	TCC_FCTRLB_HALT_Pos        = 0x8       // Position of HALT field.
	TCC_FCTRLB_HALT_Msk        = 0x300     // Bit mask of HALT field.
	TCC_FCTRLB_HALT_DISABLE    = 0x0       // Halt action disabled
	TCC_FCTRLB_HALT_HW         = 0x1       // Hardware halt action
	TCC_FCTRLB_HALT_SW         = 0x2       // Software halt action
	TCC_FCTRLB_HALT_NR         = 0x3       // Non-recoverable fault
	TCC_FCTRLB_CHSEL_Pos       = 0xa       // Position of CHSEL field.
	TCC_FCTRLB_CHSEL_Msk       = 0xc00     // Bit mask of CHSEL field.
	TCC_FCTRLB_CHSEL_CC0       = 0x0       // Capture value stored in channel 0
	TCC_FCTRLB_CHSEL_CC1       = 0x1       // Capture value stored in channel 1
	TCC_FCTRLB_CHSEL_CC2       = 0x2       // Capture value stored in channel 2
	TCC_FCTRLB_CHSEL_CC3       = 0x3       // Capture value stored in channel 3
	TCC_FCTRLB_CAPTURE_Pos     = 0xc       // Position of CAPTURE field.
	TCC_FCTRLB_CAPTURE_Msk     = 0x7000    // Bit mask of CAPTURE field.
	TCC_FCTRLB_CAPTURE_DISABLE = 0x0       // No capture
	TCC_FCTRLB_CAPTURE_CAPT    = 0x1       // Capture on fault
	TCC_FCTRLB_CAPTURE_CAPTMIN = 0x2       // Minimum capture
	TCC_FCTRLB_CAPTURE_CAPTMAX = 0x3       // Maximum capture
	TCC_FCTRLB_CAPTURE_LOCMIN  = 0x4       // Minimum local detection
	TCC_FCTRLB_CAPTURE_LOCMAX  = 0x5       // Maximum local detection
	TCC_FCTRLB_CAPTURE_DERIV0  = 0x6       // Minimum and maximum local detection
	TCC_FCTRLB_BLANKVAL_Pos    = 0x10      // Position of BLANKVAL field.
	TCC_FCTRLB_BLANKVAL_Msk    = 0xff0000  // Bit mask of BLANKVAL field.
	TCC_FCTRLB_FILTERVAL_Pos   = 0x18      // Position of FILTERVAL field.
	TCC_FCTRLB_FILTERVAL_Msk   = 0xf000000 // Bit mask of FILTERVAL field.

	// WEXCTRL: Waveform Extension Configuration
	TCC_WEXCTRL_OTMX_Pos   = 0x0        // Position of OTMX field.
	TCC_WEXCTRL_OTMX_Msk   = 0x3        // Bit mask of OTMX field.
	TCC_WEXCTRL_DTIEN0_Pos = 0x8        // Position of DTIEN0 field.
	TCC_WEXCTRL_DTIEN0_Msk = 0x100      // Bit mask of DTIEN0 field.
	TCC_WEXCTRL_DTIEN0     = 0x100      // Bit DTIEN0.
	TCC_WEXCTRL_DTIEN1_Pos = 0x9        // Position of DTIEN1 field.
	TCC_WEXCTRL_DTIEN1_Msk = 0x200      // Bit mask of DTIEN1 field.
	TCC_WEXCTRL_DTIEN1     = 0x200      // Bit DTIEN1.
	TCC_WEXCTRL_DTIEN2_Pos = 0xa        // Position of DTIEN2 field.
	TCC_WEXCTRL_DTIEN2_Msk = 0x400      // Bit mask of DTIEN2 field.
	TCC_WEXCTRL_DTIEN2     = 0x400      // Bit DTIEN2.
	TCC_WEXCTRL_DTIEN3_Pos = 0xb        // Position of DTIEN3 field.
	TCC_WEXCTRL_DTIEN3_Msk = 0x800      // Bit mask of DTIEN3 field.
	TCC_WEXCTRL_DTIEN3     = 0x800      // Bit DTIEN3.
	TCC_WEXCTRL_DTLS_Pos   = 0x10       // Position of DTLS field.
	TCC_WEXCTRL_DTLS_Msk   = 0xff0000   // Bit mask of DTLS field.
	TCC_WEXCTRL_DTHS_Pos   = 0x18       // Position of DTHS field.
	TCC_WEXCTRL_DTHS_Msk   = 0xff000000 // Bit mask of DTHS field.

	// DRVCTRL: Driver Control
	TCC_DRVCTRL_NRE0_Pos       = 0x0        // Position of NRE0 field.
	TCC_DRVCTRL_NRE0_Msk       = 0x1        // Bit mask of NRE0 field.
	TCC_DRVCTRL_NRE0           = 0x1        // Bit NRE0.
	TCC_DRVCTRL_NRE1_Pos       = 0x1        // Position of NRE1 field.
	TCC_DRVCTRL_NRE1_Msk       = 0x2        // Bit mask of NRE1 field.
	TCC_DRVCTRL_NRE1           = 0x2        // Bit NRE1.
	TCC_DRVCTRL_NRE2_Pos       = 0x2        // Position of NRE2 field.
	TCC_DRVCTRL_NRE2_Msk       = 0x4        // Bit mask of NRE2 field.
	TCC_DRVCTRL_NRE2           = 0x4        // Bit NRE2.
	TCC_DRVCTRL_NRE3_Pos       = 0x3        // Position of NRE3 field.
	TCC_DRVCTRL_NRE3_Msk       = 0x8        // Bit mask of NRE3 field.
	TCC_DRVCTRL_NRE3           = 0x8        // Bit NRE3.
	TCC_DRVCTRL_NRE4_Pos       = 0x4        // Position of NRE4 field.
	TCC_DRVCTRL_NRE4_Msk       = 0x10       // Bit mask of NRE4 field.
	TCC_DRVCTRL_NRE4           = 0x10       // Bit NRE4.
	TCC_DRVCTRL_NRE5_Pos       = 0x5        // Position of NRE5 field.
	TCC_DRVCTRL_NRE5_Msk       = 0x20       // Bit mask of NRE5 field.
	TCC_DRVCTRL_NRE5           = 0x20       // Bit NRE5.
	TCC_DRVCTRL_NRE6_Pos       = 0x6        // Position of NRE6 field.
	TCC_DRVCTRL_NRE6_Msk       = 0x40       // Bit mask of NRE6 field.
	TCC_DRVCTRL_NRE6           = 0x40       // Bit NRE6.
	TCC_DRVCTRL_NRE7_Pos       = 0x7        // Position of NRE7 field.
	TCC_DRVCTRL_NRE7_Msk       = 0x80       // Bit mask of NRE7 field.
	TCC_DRVCTRL_NRE7           = 0x80       // Bit NRE7.
	TCC_DRVCTRL_NRV0_Pos       = 0x8        // Position of NRV0 field.
	TCC_DRVCTRL_NRV0_Msk       = 0x100      // Bit mask of NRV0 field.
	TCC_DRVCTRL_NRV0           = 0x100      // Bit NRV0.
	TCC_DRVCTRL_NRV1_Pos       = 0x9        // Position of NRV1 field.
	TCC_DRVCTRL_NRV1_Msk       = 0x200      // Bit mask of NRV1 field.
	TCC_DRVCTRL_NRV1           = 0x200      // Bit NRV1.
	TCC_DRVCTRL_NRV2_Pos       = 0xa        // Position of NRV2 field.
	TCC_DRVCTRL_NRV2_Msk       = 0x400      // Bit mask of NRV2 field.
	TCC_DRVCTRL_NRV2           = 0x400      // Bit NRV2.
	TCC_DRVCTRL_NRV3_Pos       = 0xb        // Position of NRV3 field.
	TCC_DRVCTRL_NRV3_Msk       = 0x800      // Bit mask of NRV3 field.
	TCC_DRVCTRL_NRV3           = 0x800      // Bit NRV3.
	TCC_DRVCTRL_NRV4_Pos       = 0xc        // Position of NRV4 field.
	TCC_DRVCTRL_NRV4_Msk       = 0x1000     // Bit mask of NRV4 field.
	TCC_DRVCTRL_NRV4           = 0x1000     // Bit NRV4.
	TCC_DRVCTRL_NRV5_Pos       = 0xd        // Position of NRV5 field.
	TCC_DRVCTRL_NRV5_Msk       = 0x2000     // Bit mask of NRV5 field.
	TCC_DRVCTRL_NRV5           = 0x2000     // Bit NRV5.
	TCC_DRVCTRL_NRV6_Pos       = 0xe        // Position of NRV6 field.
	TCC_DRVCTRL_NRV6_Msk       = 0x4000     // Bit mask of NRV6 field.
	TCC_DRVCTRL_NRV6           = 0x4000     // Bit NRV6.
	TCC_DRVCTRL_NRV7_Pos       = 0xf        // Position of NRV7 field.
	TCC_DRVCTRL_NRV7_Msk       = 0x8000     // Bit mask of NRV7 field.
	TCC_DRVCTRL_NRV7           = 0x8000     // Bit NRV7.
	TCC_DRVCTRL_INVEN0_Pos     = 0x10       // Position of INVEN0 field.
	TCC_DRVCTRL_INVEN0_Msk     = 0x10000    // Bit mask of INVEN0 field.
	TCC_DRVCTRL_INVEN0         = 0x10000    // Bit INVEN0.
	TCC_DRVCTRL_INVEN1_Pos     = 0x11       // Position of INVEN1 field.
	TCC_DRVCTRL_INVEN1_Msk     = 0x20000    // Bit mask of INVEN1 field.
	TCC_DRVCTRL_INVEN1         = 0x20000    // Bit INVEN1.
	TCC_DRVCTRL_INVEN2_Pos     = 0x12       // Position of INVEN2 field.
	TCC_DRVCTRL_INVEN2_Msk     = 0x40000    // Bit mask of INVEN2 field.
	TCC_DRVCTRL_INVEN2         = 0x40000    // Bit INVEN2.
	TCC_DRVCTRL_INVEN3_Pos     = 0x13       // Position of INVEN3 field.
	TCC_DRVCTRL_INVEN3_Msk     = 0x80000    // Bit mask of INVEN3 field.
	TCC_DRVCTRL_INVEN3         = 0x80000    // Bit INVEN3.
	TCC_DRVCTRL_INVEN4_Pos     = 0x14       // Position of INVEN4 field.
	TCC_DRVCTRL_INVEN4_Msk     = 0x100000   // Bit mask of INVEN4 field.
	TCC_DRVCTRL_INVEN4         = 0x100000   // Bit INVEN4.
	TCC_DRVCTRL_INVEN5_Pos     = 0x15       // Position of INVEN5 field.
	TCC_DRVCTRL_INVEN5_Msk     = 0x200000   // Bit mask of INVEN5 field.
	TCC_DRVCTRL_INVEN5         = 0x200000   // Bit INVEN5.
	TCC_DRVCTRL_INVEN6_Pos     = 0x16       // Position of INVEN6 field.
	TCC_DRVCTRL_INVEN6_Msk     = 0x400000   // Bit mask of INVEN6 field.
	TCC_DRVCTRL_INVEN6         = 0x400000   // Bit INVEN6.
	TCC_DRVCTRL_INVEN7_Pos     = 0x17       // Position of INVEN7 field.
	TCC_DRVCTRL_INVEN7_Msk     = 0x800000   // Bit mask of INVEN7 field.
	TCC_DRVCTRL_INVEN7         = 0x800000   // Bit INVEN7.
	TCC_DRVCTRL_FILTERVAL0_Pos = 0x18       // Position of FILTERVAL0 field.
	TCC_DRVCTRL_FILTERVAL0_Msk = 0xf000000  // Bit mask of FILTERVAL0 field.
	TCC_DRVCTRL_FILTERVAL1_Pos = 0x1c       // Position of FILTERVAL1 field.
	TCC_DRVCTRL_FILTERVAL1_Msk = 0xf0000000 // Bit mask of FILTERVAL1 field.

	// DBGCTRL: Debug Control
	TCC_DBGCTRL_DBGRUN_Pos = 0x0 // Position of DBGRUN field.
	TCC_DBGCTRL_DBGRUN_Msk = 0x1 // Bit mask of DBGRUN field.
	TCC_DBGCTRL_DBGRUN     = 0x1 // Bit DBGRUN.
	TCC_DBGCTRL_FDDBD_Pos  = 0x2 // Position of FDDBD field.
	TCC_DBGCTRL_FDDBD_Msk  = 0x4 // Bit mask of FDDBD field.
	TCC_DBGCTRL_FDDBD      = 0x4 // Bit FDDBD.

	// EVCTRL: Event Control
	TCC_EVCTRL_EVACT0_Pos       = 0x0       // Position of EVACT0 field.
	TCC_EVCTRL_EVACT0_Msk       = 0x7       // Bit mask of EVACT0 field.
	TCC_EVCTRL_EVACT0_OFF       = 0x0       // Event action disabled
	TCC_EVCTRL_EVACT0_RETRIGGER = 0x1       // Start, restart or re-trigger counter on event
	TCC_EVCTRL_EVACT0_COUNTEV   = 0x2       // Count on event
	TCC_EVCTRL_EVACT0_START     = 0x3       // Start counter on event
	TCC_EVCTRL_EVACT0_INC       = 0x4       // Increment counter on event
	TCC_EVCTRL_EVACT0_COUNT     = 0x5       // Count on active state of asynchronous event
	TCC_EVCTRL_EVACT0_FAULT     = 0x7       // Non-recoverable fault
	TCC_EVCTRL_EVACT1_Pos       = 0x3       // Position of EVACT1 field.
	TCC_EVCTRL_EVACT1_Msk       = 0x38      // Bit mask of EVACT1 field.
	TCC_EVCTRL_EVACT1_OFF       = 0x0       // Event action disabled
	TCC_EVCTRL_EVACT1_RETRIGGER = 0x1       // Re-trigger counter on event
	TCC_EVCTRL_EVACT1_DIR       = 0x2       // Direction control
	TCC_EVCTRL_EVACT1_STOP      = 0x3       // Stop counter on event
	TCC_EVCTRL_EVACT1_DEC       = 0x4       // Decrement counter on event
	TCC_EVCTRL_EVACT1_PPW       = 0x5       // Period capture value in CC0 register, pulse width capture value in CC1 register
	TCC_EVCTRL_EVACT1_PWP       = 0x6       // Period capture value in CC1 register, pulse width capture value in CC0 register
	TCC_EVCTRL_EVACT1_FAULT     = 0x7       // Non-recoverable fault
	TCC_EVCTRL_CNTSEL_Pos       = 0x6       // Position of CNTSEL field.
	TCC_EVCTRL_CNTSEL_Msk       = 0xc0      // Bit mask of CNTSEL field.
	TCC_EVCTRL_CNTSEL_START     = 0x0       // An interrupt/event is generated when a new counter cycle starts
	TCC_EVCTRL_CNTSEL_END       = 0x1       // An interrupt/event is generated when a counter cycle ends
	TCC_EVCTRL_CNTSEL_BETWEEN   = 0x2       // An interrupt/event is generated when a counter cycle ends, except for the first and last cycles
	TCC_EVCTRL_CNTSEL_BOUNDARY  = 0x3       // An interrupt/event is generated when a new counter cycle starts or a counter cycle ends
	TCC_EVCTRL_OVFEO_Pos        = 0x8       // Position of OVFEO field.
	TCC_EVCTRL_OVFEO_Msk        = 0x100     // Bit mask of OVFEO field.
	TCC_EVCTRL_OVFEO            = 0x100     // Bit OVFEO.
	TCC_EVCTRL_TRGEO_Pos        = 0x9       // Position of TRGEO field.
	TCC_EVCTRL_TRGEO_Msk        = 0x200     // Bit mask of TRGEO field.
	TCC_EVCTRL_TRGEO            = 0x200     // Bit TRGEO.
	TCC_EVCTRL_CNTEO_Pos        = 0xa       // Position of CNTEO field.
	TCC_EVCTRL_CNTEO_Msk        = 0x400     // Bit mask of CNTEO field.
	TCC_EVCTRL_CNTEO            = 0x400     // Bit CNTEO.
	TCC_EVCTRL_TCINV0_Pos       = 0xc       // Position of TCINV0 field.
	TCC_EVCTRL_TCINV0_Msk       = 0x1000    // Bit mask of TCINV0 field.
	TCC_EVCTRL_TCINV0           = 0x1000    // Bit TCINV0.
	TCC_EVCTRL_TCINV1_Pos       = 0xd       // Position of TCINV1 field.
	TCC_EVCTRL_TCINV1_Msk       = 0x2000    // Bit mask of TCINV1 field.
	TCC_EVCTRL_TCINV1           = 0x2000    // Bit TCINV1.
	TCC_EVCTRL_TCEI0_Pos        = 0xe       // Position of TCEI0 field.
	TCC_EVCTRL_TCEI0_Msk        = 0x4000    // Bit mask of TCEI0 field.
	TCC_EVCTRL_TCEI0            = 0x4000    // Bit TCEI0.
	TCC_EVCTRL_TCEI1_Pos        = 0xf       // Position of TCEI1 field.
	TCC_EVCTRL_TCEI1_Msk        = 0x8000    // Bit mask of TCEI1 field.
	TCC_EVCTRL_TCEI1            = 0x8000    // Bit TCEI1.
	TCC_EVCTRL_MCEI0_Pos        = 0x10      // Position of MCEI0 field.
	TCC_EVCTRL_MCEI0_Msk        = 0x10000   // Bit mask of MCEI0 field.
	TCC_EVCTRL_MCEI0            = 0x10000   // Bit MCEI0.
	TCC_EVCTRL_MCEI1_Pos        = 0x11      // Position of MCEI1 field.
	TCC_EVCTRL_MCEI1_Msk        = 0x20000   // Bit mask of MCEI1 field.
	TCC_EVCTRL_MCEI1            = 0x20000   // Bit MCEI1.
	TCC_EVCTRL_MCEI2_Pos        = 0x12      // Position of MCEI2 field.
	TCC_EVCTRL_MCEI2_Msk        = 0x40000   // Bit mask of MCEI2 field.
	TCC_EVCTRL_MCEI2            = 0x40000   // Bit MCEI2.
	TCC_EVCTRL_MCEI3_Pos        = 0x13      // Position of MCEI3 field.
	TCC_EVCTRL_MCEI3_Msk        = 0x80000   // Bit mask of MCEI3 field.
	TCC_EVCTRL_MCEI3            = 0x80000   // Bit MCEI3.
	TCC_EVCTRL_MCEO0_Pos        = 0x18      // Position of MCEO0 field.
	TCC_EVCTRL_MCEO0_Msk        = 0x1000000 // Bit mask of MCEO0 field.
	TCC_EVCTRL_MCEO0            = 0x1000000 // Bit MCEO0.
	TCC_EVCTRL_MCEO1_Pos        = 0x19      // Position of MCEO1 field.
	TCC_EVCTRL_MCEO1_Msk        = 0x2000000 // Bit mask of MCEO1 field.
	TCC_EVCTRL_MCEO1            = 0x2000000 // Bit MCEO1.
	TCC_EVCTRL_MCEO2_Pos        = 0x1a      // Position of MCEO2 field.
	TCC_EVCTRL_MCEO2_Msk        = 0x4000000 // Bit mask of MCEO2 field.
	TCC_EVCTRL_MCEO2            = 0x4000000 // Bit MCEO2.
	TCC_EVCTRL_MCEO3_Pos        = 0x1b      // Position of MCEO3 field.
	TCC_EVCTRL_MCEO3_Msk        = 0x8000000 // Bit mask of MCEO3 field.
	TCC_EVCTRL_MCEO3            = 0x8000000 // Bit MCEO3.

	// INTENCLR: Interrupt Enable Clear
	TCC_INTENCLR_OVF_Pos    = 0x0     // Position of OVF field.
	TCC_INTENCLR_OVF_Msk    = 0x1     // Bit mask of OVF field.
	TCC_INTENCLR_OVF        = 0x1     // Bit OVF.
	TCC_INTENCLR_TRG_Pos    = 0x1     // Position of TRG field.
	TCC_INTENCLR_TRG_Msk    = 0x2     // Bit mask of TRG field.
	TCC_INTENCLR_TRG        = 0x2     // Bit TRG.
	TCC_INTENCLR_CNT_Pos    = 0x2     // Position of CNT field.
	TCC_INTENCLR_CNT_Msk    = 0x4     // Bit mask of CNT field.
	TCC_INTENCLR_CNT        = 0x4     // Bit CNT.
	TCC_INTENCLR_ERR_Pos    = 0x3     // Position of ERR field.
	TCC_INTENCLR_ERR_Msk    = 0x8     // Bit mask of ERR field.
	TCC_INTENCLR_ERR        = 0x8     // Bit ERR.
	TCC_INTENCLR_DFS_Pos    = 0xb     // Position of DFS field.
	TCC_INTENCLR_DFS_Msk    = 0x800   // Bit mask of DFS field.
	TCC_INTENCLR_DFS        = 0x800   // Bit DFS.
	TCC_INTENCLR_FAULTA_Pos = 0xc     // Position of FAULTA field.
	TCC_INTENCLR_FAULTA_Msk = 0x1000  // Bit mask of FAULTA field.
	TCC_INTENCLR_FAULTA     = 0x1000  // Bit FAULTA.
	TCC_INTENCLR_FAULTB_Pos = 0xd     // Position of FAULTB field.
	TCC_INTENCLR_FAULTB_Msk = 0x2000  // Bit mask of FAULTB field.
	TCC_INTENCLR_FAULTB     = 0x2000  // Bit FAULTB.
	TCC_INTENCLR_FAULT0_Pos = 0xe     // Position of FAULT0 field.
	TCC_INTENCLR_FAULT0_Msk = 0x4000  // Bit mask of FAULT0 field.
	TCC_INTENCLR_FAULT0     = 0x4000  // Bit FAULT0.
	TCC_INTENCLR_FAULT1_Pos = 0xf     // Position of FAULT1 field.
	TCC_INTENCLR_FAULT1_Msk = 0x8000  // Bit mask of FAULT1 field.
	TCC_INTENCLR_FAULT1     = 0x8000  // Bit FAULT1.
	TCC_INTENCLR_MC0_Pos    = 0x10    // Position of MC0 field.
	TCC_INTENCLR_MC0_Msk    = 0x10000 // Bit mask of MC0 field.
	TCC_INTENCLR_MC0        = 0x10000 // Bit MC0.
	TCC_INTENCLR_MC1_Pos    = 0x11    // Position of MC1 field.
	TCC_INTENCLR_MC1_Msk    = 0x20000 // Bit mask of MC1 field.
	TCC_INTENCLR_MC1        = 0x20000 // Bit MC1.
	TCC_INTENCLR_MC2_Pos    = 0x12    // Position of MC2 field.
	TCC_INTENCLR_MC2_Msk    = 0x40000 // Bit mask of MC2 field.
	TCC_INTENCLR_MC2        = 0x40000 // Bit MC2.
	TCC_INTENCLR_MC3_Pos    = 0x13    // Position of MC3 field.
	TCC_INTENCLR_MC3_Msk    = 0x80000 // Bit mask of MC3 field.
	TCC_INTENCLR_MC3        = 0x80000 // Bit MC3.

	// INTENSET: Interrupt Enable Set
	TCC_INTENSET_OVF_Pos    = 0x0     // Position of OVF field.
	TCC_INTENSET_OVF_Msk    = 0x1     // Bit mask of OVF field.
	TCC_INTENSET_OVF        = 0x1     // Bit OVF.
	TCC_INTENSET_TRG_Pos    = 0x1     // Position of TRG field.
	TCC_INTENSET_TRG_Msk    = 0x2     // Bit mask of TRG field.
	TCC_INTENSET_TRG        = 0x2     // Bit TRG.
	TCC_INTENSET_CNT_Pos    = 0x2     // Position of CNT field.
	TCC_INTENSET_CNT_Msk    = 0x4     // Bit mask of CNT field.
	TCC_INTENSET_CNT        = 0x4     // Bit CNT.
	TCC_INTENSET_ERR_Pos    = 0x3     // Position of ERR field.
	TCC_INTENSET_ERR_Msk    = 0x8     // Bit mask of ERR field.
	TCC_INTENSET_ERR        = 0x8     // Bit ERR.
	TCC_INTENSET_DFS_Pos    = 0xb     // Position of DFS field.
	TCC_INTENSET_DFS_Msk    = 0x800   // Bit mask of DFS field.
	TCC_INTENSET_DFS        = 0x800   // Bit DFS.
	TCC_INTENSET_FAULTA_Pos = 0xc     // Position of FAULTA field.
	TCC_INTENSET_FAULTA_Msk = 0x1000  // Bit mask of FAULTA field.
	TCC_INTENSET_FAULTA     = 0x1000  // Bit FAULTA.
	TCC_INTENSET_FAULTB_Pos = 0xd     // Position of FAULTB field.
	TCC_INTENSET_FAULTB_Msk = 0x2000  // Bit mask of FAULTB field.
	TCC_INTENSET_FAULTB     = 0x2000  // Bit FAULTB.
	TCC_INTENSET_FAULT0_Pos = 0xe     // Position of FAULT0 field.
	TCC_INTENSET_FAULT0_Msk = 0x4000  // Bit mask of FAULT0 field.
	TCC_INTENSET_FAULT0     = 0x4000  // Bit FAULT0.
	TCC_INTENSET_FAULT1_Pos = 0xf     // Position of FAULT1 field.
	TCC_INTENSET_FAULT1_Msk = 0x8000  // Bit mask of FAULT1 field.
	TCC_INTENSET_FAULT1     = 0x8000  // Bit FAULT1.
	TCC_INTENSET_MC0_Pos    = 0x10    // Position of MC0 field.
	TCC_INTENSET_MC0_Msk    = 0x10000 // Bit mask of MC0 field.
	TCC_INTENSET_MC0        = 0x10000 // Bit MC0.
	TCC_INTENSET_MC1_Pos    = 0x11    // Position of MC1 field.
	TCC_INTENSET_MC1_Msk    = 0x20000 // Bit mask of MC1 field.
	TCC_INTENSET_MC1        = 0x20000 // Bit MC1.
	TCC_INTENSET_MC2_Pos    = 0x12    // Position of MC2 field.
	TCC_INTENSET_MC2_Msk    = 0x40000 // Bit mask of MC2 field.
	TCC_INTENSET_MC2        = 0x40000 // Bit MC2.
	TCC_INTENSET_MC3_Pos    = 0x13    // Position of MC3 field.
	TCC_INTENSET_MC3_Msk    = 0x80000 // Bit mask of MC3 field.
	TCC_INTENSET_MC3        = 0x80000 // Bit MC3.

	// INTFLAG: Interrupt Flag Status and Clear
	TCC_INTFLAG_OVF_Pos    = 0x0     // Position of OVF field.
	TCC_INTFLAG_OVF_Msk    = 0x1     // Bit mask of OVF field.
	TCC_INTFLAG_OVF        = 0x1     // Bit OVF.
	TCC_INTFLAG_TRG_Pos    = 0x1     // Position of TRG field.
	TCC_INTFLAG_TRG_Msk    = 0x2     // Bit mask of TRG field.
	TCC_INTFLAG_TRG        = 0x2     // Bit TRG.
	TCC_INTFLAG_CNT_Pos    = 0x2     // Position of CNT field.
	TCC_INTFLAG_CNT_Msk    = 0x4     // Bit mask of CNT field.
	TCC_INTFLAG_CNT        = 0x4     // Bit CNT.
	TCC_INTFLAG_ERR_Pos    = 0x3     // Position of ERR field.
	TCC_INTFLAG_ERR_Msk    = 0x8     // Bit mask of ERR field.
	TCC_INTFLAG_ERR        = 0x8     // Bit ERR.
	TCC_INTFLAG_DFS_Pos    = 0xb     // Position of DFS field.
	TCC_INTFLAG_DFS_Msk    = 0x800   // Bit mask of DFS field.
	TCC_INTFLAG_DFS        = 0x800   // Bit DFS.
	TCC_INTFLAG_FAULTA_Pos = 0xc     // Position of FAULTA field.
	TCC_INTFLAG_FAULTA_Msk = 0x1000  // Bit mask of FAULTA field.
	TCC_INTFLAG_FAULTA     = 0x1000  // Bit FAULTA.
	TCC_INTFLAG_FAULTB_Pos = 0xd     // Position of FAULTB field.
	TCC_INTFLAG_FAULTB_Msk = 0x2000  // Bit mask of FAULTB field.
	TCC_INTFLAG_FAULTB     = 0x2000  // Bit FAULTB.
	TCC_INTFLAG_FAULT0_Pos = 0xe     // Position of FAULT0 field.
	TCC_INTFLAG_FAULT0_Msk = 0x4000  // Bit mask of FAULT0 field.
	TCC_INTFLAG_FAULT0     = 0x4000  // Bit FAULT0.
	TCC_INTFLAG_FAULT1_Pos = 0xf     // Position of FAULT1 field.
	TCC_INTFLAG_FAULT1_Msk = 0x8000  // Bit mask of FAULT1 field.
	TCC_INTFLAG_FAULT1     = 0x8000  // Bit FAULT1.
	TCC_INTFLAG_MC0_Pos    = 0x10    // Position of MC0 field.
	TCC_INTFLAG_MC0_Msk    = 0x10000 // Bit mask of MC0 field.
	TCC_INTFLAG_MC0        = 0x10000 // Bit MC0.
	TCC_INTFLAG_MC1_Pos    = 0x11    // Position of MC1 field.
	TCC_INTFLAG_MC1_Msk    = 0x20000 // Bit mask of MC1 field.
	TCC_INTFLAG_MC1        = 0x20000 // Bit MC1.
	TCC_INTFLAG_MC2_Pos    = 0x12    // Position of MC2 field.
	TCC_INTFLAG_MC2_Msk    = 0x40000 // Bit mask of MC2 field.
	TCC_INTFLAG_MC2        = 0x40000 // Bit MC2.
	TCC_INTFLAG_MC3_Pos    = 0x13    // Position of MC3 field.
	TCC_INTFLAG_MC3_Msk    = 0x80000 // Bit mask of MC3 field.
	TCC_INTFLAG_MC3        = 0x80000 // Bit MC3.

	// STATUS: Status
	TCC_STATUS_STOP_Pos     = 0x0       // Position of STOP field.
	TCC_STATUS_STOP_Msk     = 0x1       // Bit mask of STOP field.
	TCC_STATUS_STOP         = 0x1       // Bit STOP.
	TCC_STATUS_IDX_Pos      = 0x1       // Position of IDX field.
	TCC_STATUS_IDX_Msk      = 0x2       // Bit mask of IDX field.
	TCC_STATUS_IDX          = 0x2       // Bit IDX.
	TCC_STATUS_DFS_Pos      = 0x3       // Position of DFS field.
	TCC_STATUS_DFS_Msk      = 0x8       // Bit mask of DFS field.
	TCC_STATUS_DFS          = 0x8       // Bit DFS.
	TCC_STATUS_SLAVE_Pos    = 0x4       // Position of SLAVE field.
	TCC_STATUS_SLAVE_Msk    = 0x10      // Bit mask of SLAVE field.
	TCC_STATUS_SLAVE        = 0x10      // Bit SLAVE.
	TCC_STATUS_PATTBV_Pos   = 0x5       // Position of PATTBV field.
	TCC_STATUS_PATTBV_Msk   = 0x20      // Bit mask of PATTBV field.
	TCC_STATUS_PATTBV       = 0x20      // Bit PATTBV.
	TCC_STATUS_WAVEBV_Pos   = 0x6       // Position of WAVEBV field.
	TCC_STATUS_WAVEBV_Msk   = 0x40      // Bit mask of WAVEBV field.
	TCC_STATUS_WAVEBV       = 0x40      // Bit WAVEBV.
	TCC_STATUS_PERBV_Pos    = 0x7       // Position of PERBV field.
	TCC_STATUS_PERBV_Msk    = 0x80      // Bit mask of PERBV field.
	TCC_STATUS_PERBV        = 0x80      // Bit PERBV.
	TCC_STATUS_FAULTAIN_Pos = 0x8       // Position of FAULTAIN field.
	TCC_STATUS_FAULTAIN_Msk = 0x100     // Bit mask of FAULTAIN field.
	TCC_STATUS_FAULTAIN     = 0x100     // Bit FAULTAIN.
	TCC_STATUS_FAULTBIN_Pos = 0x9       // Position of FAULTBIN field.
	TCC_STATUS_FAULTBIN_Msk = 0x200     // Bit mask of FAULTBIN field.
	TCC_STATUS_FAULTBIN     = 0x200     // Bit FAULTBIN.
	TCC_STATUS_FAULT0IN_Pos = 0xa       // Position of FAULT0IN field.
	TCC_STATUS_FAULT0IN_Msk = 0x400     // Bit mask of FAULT0IN field.
	TCC_STATUS_FAULT0IN     = 0x400     // Bit FAULT0IN.
	TCC_STATUS_FAULT1IN_Pos = 0xb       // Position of FAULT1IN field.
	TCC_STATUS_FAULT1IN_Msk = 0x800     // Bit mask of FAULT1IN field.
	TCC_STATUS_FAULT1IN     = 0x800     // Bit FAULT1IN.
	TCC_STATUS_FAULTA_Pos   = 0xc       // Position of FAULTA field.
	TCC_STATUS_FAULTA_Msk   = 0x1000    // Bit mask of FAULTA field.
	TCC_STATUS_FAULTA       = 0x1000    // Bit FAULTA.
	TCC_STATUS_FAULTB_Pos   = 0xd       // Position of FAULTB field.
	TCC_STATUS_FAULTB_Msk   = 0x2000    // Bit mask of FAULTB field.
	TCC_STATUS_FAULTB       = 0x2000    // Bit FAULTB.
	TCC_STATUS_FAULT0_Pos   = 0xe       // Position of FAULT0 field.
	TCC_STATUS_FAULT0_Msk   = 0x4000    // Bit mask of FAULT0 field.
	TCC_STATUS_FAULT0       = 0x4000    // Bit FAULT0.
	TCC_STATUS_FAULT1_Pos   = 0xf       // Position of FAULT1 field.
	TCC_STATUS_FAULT1_Msk   = 0x8000    // Bit mask of FAULT1 field.
	TCC_STATUS_FAULT1       = 0x8000    // Bit FAULT1.
	TCC_STATUS_CCBV0_Pos    = 0x10      // Position of CCBV0 field.
	TCC_STATUS_CCBV0_Msk    = 0x10000   // Bit mask of CCBV0 field.
	TCC_STATUS_CCBV0        = 0x10000   // Bit CCBV0.
	TCC_STATUS_CCBV1_Pos    = 0x11      // Position of CCBV1 field.
	TCC_STATUS_CCBV1_Msk    = 0x20000   // Bit mask of CCBV1 field.
	TCC_STATUS_CCBV1        = 0x20000   // Bit CCBV1.
	TCC_STATUS_CCBV2_Pos    = 0x12      // Position of CCBV2 field.
	TCC_STATUS_CCBV2_Msk    = 0x40000   // Bit mask of CCBV2 field.
	TCC_STATUS_CCBV2        = 0x40000   // Bit CCBV2.
	TCC_STATUS_CCBV3_Pos    = 0x13      // Position of CCBV3 field.
	TCC_STATUS_CCBV3_Msk    = 0x80000   // Bit mask of CCBV3 field.
	TCC_STATUS_CCBV3        = 0x80000   // Bit CCBV3.
	TCC_STATUS_CMP0_Pos     = 0x18      // Position of CMP0 field.
	TCC_STATUS_CMP0_Msk     = 0x1000000 // Bit mask of CMP0 field.
	TCC_STATUS_CMP0         = 0x1000000 // Bit CMP0.
	TCC_STATUS_CMP1_Pos     = 0x19      // Position of CMP1 field.
	TCC_STATUS_CMP1_Msk     = 0x2000000 // Bit mask of CMP1 field.
	TCC_STATUS_CMP1         = 0x2000000 // Bit CMP1.
	TCC_STATUS_CMP2_Pos     = 0x1a      // Position of CMP2 field.
	TCC_STATUS_CMP2_Msk     = 0x4000000 // Bit mask of CMP2 field.
	TCC_STATUS_CMP2         = 0x4000000 // Bit CMP2.
	TCC_STATUS_CMP3_Pos     = 0x1b      // Position of CMP3 field.
	TCC_STATUS_CMP3_Msk     = 0x8000000 // Bit mask of CMP3 field.
	TCC_STATUS_CMP3         = 0x8000000 // Bit CMP3.

	// COUNT: Count
	TCC_COUNT_COUNT_Pos = 0x0      // Position of COUNT field.
	TCC_COUNT_COUNT_Msk = 0xffffff // Bit mask of COUNT field.

	// COUNT_DITH4: Count
	TCC_COUNT_DITH4_COUNT_Pos = 0x4      // Position of COUNT field.
	TCC_COUNT_DITH4_COUNT_Msk = 0xfffff0 // Bit mask of COUNT field.

	// COUNT_DITH5: Count
	TCC_COUNT_DITH5_COUNT_Pos = 0x5      // Position of COUNT field.
	TCC_COUNT_DITH5_COUNT_Msk = 0xffffe0 // Bit mask of COUNT field.

	// COUNT_DITH6: Count
	TCC_COUNT_DITH6_COUNT_Pos = 0x6      // Position of COUNT field.
	TCC_COUNT_DITH6_COUNT_Msk = 0xffffc0 // Bit mask of COUNT field.

	// PATT: Pattern
	TCC_PATT_PGE0_Pos = 0x0    // Position of PGE0 field.
	TCC_PATT_PGE0_Msk = 0x1    // Bit mask of PGE0 field.
	TCC_PATT_PGE0     = 0x1    // Bit PGE0.
	TCC_PATT_PGE1_Pos = 0x1    // Position of PGE1 field.
	TCC_PATT_PGE1_Msk = 0x2    // Bit mask of PGE1 field.
	TCC_PATT_PGE1     = 0x2    // Bit PGE1.
	TCC_PATT_PGE2_Pos = 0x2    // Position of PGE2 field.
	TCC_PATT_PGE2_Msk = 0x4    // Bit mask of PGE2 field.
	TCC_PATT_PGE2     = 0x4    // Bit PGE2.
	TCC_PATT_PGE3_Pos = 0x3    // Position of PGE3 field.
	TCC_PATT_PGE3_Msk = 0x8    // Bit mask of PGE3 field.
	TCC_PATT_PGE3     = 0x8    // Bit PGE3.
	TCC_PATT_PGE4_Pos = 0x4    // Position of PGE4 field.
	TCC_PATT_PGE4_Msk = 0x10   // Bit mask of PGE4 field.
	TCC_PATT_PGE4     = 0x10   // Bit PGE4.
	TCC_PATT_PGE5_Pos = 0x5    // Position of PGE5 field.
	TCC_PATT_PGE5_Msk = 0x20   // Bit mask of PGE5 field.
	TCC_PATT_PGE5     = 0x20   // Bit PGE5.
	TCC_PATT_PGE6_Pos = 0x6    // Position of PGE6 field.
	TCC_PATT_PGE6_Msk = 0x40   // Bit mask of PGE6 field.
	TCC_PATT_PGE6     = 0x40   // Bit PGE6.
	TCC_PATT_PGE7_Pos = 0x7    // Position of PGE7 field.
	TCC_PATT_PGE7_Msk = 0x80   // Bit mask of PGE7 field.
	TCC_PATT_PGE7     = 0x80   // Bit PGE7.
	TCC_PATT_PGV0_Pos = 0x8    // Position of PGV0 field.
	TCC_PATT_PGV0_Msk = 0x100  // Bit mask of PGV0 field.
	TCC_PATT_PGV0     = 0x100  // Bit PGV0.
	TCC_PATT_PGV1_Pos = 0x9    // Position of PGV1 field.
	TCC_PATT_PGV1_Msk = 0x200  // Bit mask of PGV1 field.
	TCC_PATT_PGV1     = 0x200  // Bit PGV1.
	TCC_PATT_PGV2_Pos = 0xa    // Position of PGV2 field.
	TCC_PATT_PGV2_Msk = 0x400  // Bit mask of PGV2 field.
	TCC_PATT_PGV2     = 0x400  // Bit PGV2.
	TCC_PATT_PGV3_Pos = 0xb    // Position of PGV3 field.
	TCC_PATT_PGV3_Msk = 0x800  // Bit mask of PGV3 field.
	TCC_PATT_PGV3     = 0x800  // Bit PGV3.
	TCC_PATT_PGV4_Pos = 0xc    // Position of PGV4 field.
	TCC_PATT_PGV4_Msk = 0x1000 // Bit mask of PGV4 field.
	TCC_PATT_PGV4     = 0x1000 // Bit PGV4.
	TCC_PATT_PGV5_Pos = 0xd    // Position of PGV5 field.
	TCC_PATT_PGV5_Msk = 0x2000 // Bit mask of PGV5 field.
	TCC_PATT_PGV5     = 0x2000 // Bit PGV5.
	TCC_PATT_PGV6_Pos = 0xe    // Position of PGV6 field.
	TCC_PATT_PGV6_Msk = 0x4000 // Bit mask of PGV6 field.
	TCC_PATT_PGV6     = 0x4000 // Bit PGV6.
	TCC_PATT_PGV7_Pos = 0xf    // Position of PGV7 field.
	TCC_PATT_PGV7_Msk = 0x8000 // Bit mask of PGV7 field.
	TCC_PATT_PGV7     = 0x8000 // Bit PGV7.

	// WAVE: Waveform Control
	TCC_WAVE_WAVEGEN_Pos        = 0x0       // Position of WAVEGEN field.
	TCC_WAVE_WAVEGEN_Msk        = 0x7       // Bit mask of WAVEGEN field.
	TCC_WAVE_WAVEGEN_NFRQ       = 0x0       // Normal frequency
	TCC_WAVE_WAVEGEN_MFRQ       = 0x1       // Match frequency
	TCC_WAVE_WAVEGEN_NPWM       = 0x2       // Normal PWM
	TCC_WAVE_WAVEGEN_DSCRITICAL = 0x4       // Dual-slope critical
	TCC_WAVE_WAVEGEN_DSBOTTOM   = 0x5       // Dual-slope with interrupt/event condition when COUNT reaches ZERO
	TCC_WAVE_WAVEGEN_DSBOTH     = 0x6       // Dual-slope with interrupt/event condition when COUNT reaches ZERO or TOP
	TCC_WAVE_WAVEGEN_DSTOP      = 0x7       // Dual-slope with interrupt/event condition when COUNT reaches TOP
	TCC_WAVE_RAMP_Pos           = 0x4       // Position of RAMP field.
	TCC_WAVE_RAMP_Msk           = 0x30      // Bit mask of RAMP field.
	TCC_WAVE_RAMP_RAMP1         = 0x0       // RAMP1 operation
	TCC_WAVE_RAMP_RAMP2A        = 0x1       // Alternative RAMP2 operation
	TCC_WAVE_RAMP_RAMP2         = 0x2       // RAMP2 operation
	TCC_WAVE_CIPEREN_Pos        = 0x7       // Position of CIPEREN field.
	TCC_WAVE_CIPEREN_Msk        = 0x80      // Bit mask of CIPEREN field.
	TCC_WAVE_CIPEREN            = 0x80      // Bit CIPEREN.
	TCC_WAVE_CICCEN0_Pos        = 0x8       // Position of CICCEN0 field.
	TCC_WAVE_CICCEN0_Msk        = 0x100     // Bit mask of CICCEN0 field.
	TCC_WAVE_CICCEN0            = 0x100     // Bit CICCEN0.
	TCC_WAVE_CICCEN1_Pos        = 0x9       // Position of CICCEN1 field.
	TCC_WAVE_CICCEN1_Msk        = 0x200     // Bit mask of CICCEN1 field.
	TCC_WAVE_CICCEN1            = 0x200     // Bit CICCEN1.
	TCC_WAVE_CICCEN2_Pos        = 0xa       // Position of CICCEN2 field.
	TCC_WAVE_CICCEN2_Msk        = 0x400     // Bit mask of CICCEN2 field.
	TCC_WAVE_CICCEN2            = 0x400     // Bit CICCEN2.
	TCC_WAVE_CICCEN3_Pos        = 0xb       // Position of CICCEN3 field.
	TCC_WAVE_CICCEN3_Msk        = 0x800     // Bit mask of CICCEN3 field.
	TCC_WAVE_CICCEN3            = 0x800     // Bit CICCEN3.
	TCC_WAVE_POL0_Pos           = 0x10      // Position of POL0 field.
	TCC_WAVE_POL0_Msk           = 0x10000   // Bit mask of POL0 field.
	TCC_WAVE_POL0               = 0x10000   // Bit POL0.
	TCC_WAVE_POL1_Pos           = 0x11      // Position of POL1 field.
	TCC_WAVE_POL1_Msk           = 0x20000   // Bit mask of POL1 field.
	TCC_WAVE_POL1               = 0x20000   // Bit POL1.
	TCC_WAVE_POL2_Pos           = 0x12      // Position of POL2 field.
	TCC_WAVE_POL2_Msk           = 0x40000   // Bit mask of POL2 field.
	TCC_WAVE_POL2               = 0x40000   // Bit POL2.
	TCC_WAVE_POL3_Pos           = 0x13      // Position of POL3 field.
	TCC_WAVE_POL3_Msk           = 0x80000   // Bit mask of POL3 field.
	TCC_WAVE_POL3               = 0x80000   // Bit POL3.
	TCC_WAVE_SWAP0_Pos          = 0x18      // Position of SWAP0 field.
	TCC_WAVE_SWAP0_Msk          = 0x1000000 // Bit mask of SWAP0 field.
	TCC_WAVE_SWAP0              = 0x1000000 // Bit SWAP0.
	TCC_WAVE_SWAP1_Pos          = 0x19      // Position of SWAP1 field.
	TCC_WAVE_SWAP1_Msk          = 0x2000000 // Bit mask of SWAP1 field.
	TCC_WAVE_SWAP1              = 0x2000000 // Bit SWAP1.
	TCC_WAVE_SWAP2_Pos          = 0x1a      // Position of SWAP2 field.
	TCC_WAVE_SWAP2_Msk          = 0x4000000 // Bit mask of SWAP2 field.
	TCC_WAVE_SWAP2              = 0x4000000 // Bit SWAP2.
	TCC_WAVE_SWAP3_Pos          = 0x1b      // Position of SWAP3 field.
	TCC_WAVE_SWAP3_Msk          = 0x8000000 // Bit mask of SWAP3 field.
	TCC_WAVE_SWAP3              = 0x8000000 // Bit SWAP3.

	// PER: Period
	TCC_PER_PER_Pos = 0x0      // Position of PER field.
	TCC_PER_PER_Msk = 0xffffff // Bit mask of PER field.

	// PER_DITH4: Period
	TCC_PER_DITH4_DITHERCY_Pos = 0x0      // Position of DITHERCY field.
	TCC_PER_DITH4_DITHERCY_Msk = 0xf      // Bit mask of DITHERCY field.
	TCC_PER_DITH4_PER_Pos      = 0x4      // Position of PER field.
	TCC_PER_DITH4_PER_Msk      = 0xfffff0 // Bit mask of PER field.

	// PER_DITH5: Period
	TCC_PER_DITH5_DITHERCY_Pos = 0x0      // Position of DITHERCY field.
	TCC_PER_DITH5_DITHERCY_Msk = 0x1f     // Bit mask of DITHERCY field.
	TCC_PER_DITH5_PER_Pos      = 0x5      // Position of PER field.
	TCC_PER_DITH5_PER_Msk      = 0xffffe0 // Bit mask of PER field.

	// PER_DITH6: Period
	TCC_PER_DITH6_DITHERCY_Pos = 0x0      // Position of DITHERCY field.
	TCC_PER_DITH6_DITHERCY_Msk = 0x3f     // Bit mask of DITHERCY field.
	TCC_PER_DITH6_PER_Pos      = 0x6      // Position of PER field.
	TCC_PER_DITH6_PER_Msk      = 0xffffc0 // Bit mask of PER field.

	// CC0: Compare and Capture
	TCC_CC_CC_Pos = 0x0      // Position of CC field.
	TCC_CC_CC_Msk = 0xffffff // Bit mask of CC field.

	// CC0_DITH4: Compare and Capture
	TCC_CC_DITH4_DITHERCY_Pos = 0x0      // Position of DITHERCY field.
	TCC_CC_DITH4_DITHERCY_Msk = 0xf      // Bit mask of DITHERCY field.
	TCC_CC_DITH4_CC_Pos       = 0x4      // Position of CC field.
	TCC_CC_DITH4_CC_Msk       = 0xfffff0 // Bit mask of CC field.

	// CC0_DITH5: Compare and Capture
	TCC_CC_DITH5_DITHERCY_Pos = 0x0      // Position of DITHERCY field.
	TCC_CC_DITH5_DITHERCY_Msk = 0x1f     // Bit mask of DITHERCY field.
	TCC_CC_DITH5_CC_Pos       = 0x5      // Position of CC field.
	TCC_CC_DITH5_CC_Msk       = 0xffffe0 // Bit mask of CC field.

	// CC0_DITH6: Compare and Capture
	TCC_CC_DITH6_DITHERCY_Pos = 0x0      // Position of DITHERCY field.
	TCC_CC_DITH6_DITHERCY_Msk = 0x3f     // Bit mask of DITHERCY field.
	TCC_CC_DITH6_CC_Pos       = 0x6      // Position of CC field.
	TCC_CC_DITH6_CC_Msk       = 0xffffc0 // Bit mask of CC field.

	// PATTB: Pattern Buffer
	TCC_PATTB_PGEB0_Pos = 0x0    // Position of PGEB0 field.
	TCC_PATTB_PGEB0_Msk = 0x1    // Bit mask of PGEB0 field.
	TCC_PATTB_PGEB0     = 0x1    // Bit PGEB0.
	TCC_PATTB_PGEB1_Pos = 0x1    // Position of PGEB1 field.
	TCC_PATTB_PGEB1_Msk = 0x2    // Bit mask of PGEB1 field.
	TCC_PATTB_PGEB1     = 0x2    // Bit PGEB1.
	TCC_PATTB_PGEB2_Pos = 0x2    // Position of PGEB2 field.
	TCC_PATTB_PGEB2_Msk = 0x4    // Bit mask of PGEB2 field.
	TCC_PATTB_PGEB2     = 0x4    // Bit PGEB2.
	TCC_PATTB_PGEB3_Pos = 0x3    // Position of PGEB3 field.
	TCC_PATTB_PGEB3_Msk = 0x8    // Bit mask of PGEB3 field.
	TCC_PATTB_PGEB3     = 0x8    // Bit PGEB3.
	TCC_PATTB_PGEB4_Pos = 0x4    // Position of PGEB4 field.
	TCC_PATTB_PGEB4_Msk = 0x10   // Bit mask of PGEB4 field.
	TCC_PATTB_PGEB4     = 0x10   // Bit PGEB4.
	TCC_PATTB_PGEB5_Pos = 0x5    // Position of PGEB5 field.
	TCC_PATTB_PGEB5_Msk = 0x20   // Bit mask of PGEB5 field.
	TCC_PATTB_PGEB5     = 0x20   // Bit PGEB5.
	TCC_PATTB_PGEB6_Pos = 0x6    // Position of PGEB6 field.
	TCC_PATTB_PGEB6_Msk = 0x40   // Bit mask of PGEB6 field.
	TCC_PATTB_PGEB6     = 0x40   // Bit PGEB6.
	TCC_PATTB_PGEB7_Pos = 0x7    // Position of PGEB7 field.
	TCC_PATTB_PGEB7_Msk = 0x80   // Bit mask of PGEB7 field.
	TCC_PATTB_PGEB7     = 0x80   // Bit PGEB7.
	TCC_PATTB_PGVB0_Pos = 0x8    // Position of PGVB0 field.
	TCC_PATTB_PGVB0_Msk = 0x100  // Bit mask of PGVB0 field.
	TCC_PATTB_PGVB0     = 0x100  // Bit PGVB0.
	TCC_PATTB_PGVB1_Pos = 0x9    // Position of PGVB1 field.
	TCC_PATTB_PGVB1_Msk = 0x200  // Bit mask of PGVB1 field.
	TCC_PATTB_PGVB1     = 0x200  // Bit PGVB1.
	TCC_PATTB_PGVB2_Pos = 0xa    // Position of PGVB2 field.
	TCC_PATTB_PGVB2_Msk = 0x400  // Bit mask of PGVB2 field.
	TCC_PATTB_PGVB2     = 0x400  // Bit PGVB2.
	TCC_PATTB_PGVB3_Pos = 0xb    // Position of PGVB3 field.
	TCC_PATTB_PGVB3_Msk = 0x800  // Bit mask of PGVB3 field.
	TCC_PATTB_PGVB3     = 0x800  // Bit PGVB3.
	TCC_PATTB_PGVB4_Pos = 0xc    // Position of PGVB4 field.
	TCC_PATTB_PGVB4_Msk = 0x1000 // Bit mask of PGVB4 field.
	TCC_PATTB_PGVB4     = 0x1000 // Bit PGVB4.
	TCC_PATTB_PGVB5_Pos = 0xd    // Position of PGVB5 field.
	TCC_PATTB_PGVB5_Msk = 0x2000 // Bit mask of PGVB5 field.
	TCC_PATTB_PGVB5     = 0x2000 // Bit PGVB5.
	TCC_PATTB_PGVB6_Pos = 0xe    // Position of PGVB6 field.
	TCC_PATTB_PGVB6_Msk = 0x4000 // Bit mask of PGVB6 field.
	TCC_PATTB_PGVB6     = 0x4000 // Bit PGVB6.
	TCC_PATTB_PGVB7_Pos = 0xf    // Position of PGVB7 field.
	TCC_PATTB_PGVB7_Msk = 0x8000 // Bit mask of PGVB7 field.
	TCC_PATTB_PGVB7     = 0x8000 // Bit PGVB7.

	// WAVEB: Waveform Control Buffer
	TCC_WAVEB_WAVEGENB_Pos        = 0x0       // Position of WAVEGENB field.
	TCC_WAVEB_WAVEGENB_Msk        = 0x7       // Bit mask of WAVEGENB field.
	TCC_WAVEB_WAVEGENB_NFRQ       = 0x0       // Normal frequency
	TCC_WAVEB_WAVEGENB_MFRQ       = 0x1       // Match frequency
	TCC_WAVEB_WAVEGENB_NPWM       = 0x2       // Normal PWM
	TCC_WAVEB_WAVEGENB_DSCRITICAL = 0x4       // Dual-slope critical
	TCC_WAVEB_WAVEGENB_DSBOTTOM   = 0x5       // Dual-slope with interrupt/event condition when COUNT reaches ZERO
	TCC_WAVEB_WAVEGENB_DSBOTH     = 0x6       // Dual-slope with interrupt/event condition when COUNT reaches ZERO or TOP
	TCC_WAVEB_WAVEGENB_DSTOP      = 0x7       // Dual-slope with interrupt/event condition when COUNT reaches TOP
	TCC_WAVEB_RAMPB_Pos           = 0x4       // Position of RAMPB field.
	TCC_WAVEB_RAMPB_Msk           = 0x30      // Bit mask of RAMPB field.
	TCC_WAVEB_RAMPB_RAMP1         = 0x0       // RAMP1 operation
	TCC_WAVEB_RAMPB_RAMP2A        = 0x1       // Alternative RAMP2 operation
	TCC_WAVEB_RAMPB_RAMP2         = 0x2       // RAMP2 operation
	TCC_WAVEB_CIPERENB_Pos        = 0x7       // Position of CIPERENB field.
	TCC_WAVEB_CIPERENB_Msk        = 0x80      // Bit mask of CIPERENB field.
	TCC_WAVEB_CIPERENB            = 0x80      // Bit CIPERENB.
	TCC_WAVEB_CICCENB0_Pos        = 0x8       // Position of CICCENB0 field.
	TCC_WAVEB_CICCENB0_Msk        = 0x100     // Bit mask of CICCENB0 field.
	TCC_WAVEB_CICCENB0            = 0x100     // Bit CICCENB0.
	TCC_WAVEB_CICCENB1_Pos        = 0x9       // Position of CICCENB1 field.
	TCC_WAVEB_CICCENB1_Msk        = 0x200     // Bit mask of CICCENB1 field.
	TCC_WAVEB_CICCENB1            = 0x200     // Bit CICCENB1.
	TCC_WAVEB_CICCENB2_Pos        = 0xa       // Position of CICCENB2 field.
	TCC_WAVEB_CICCENB2_Msk        = 0x400     // Bit mask of CICCENB2 field.
	TCC_WAVEB_CICCENB2            = 0x400     // Bit CICCENB2.
	TCC_WAVEB_CICCENB3_Pos        = 0xb       // Position of CICCENB3 field.
	TCC_WAVEB_CICCENB3_Msk        = 0x800     // Bit mask of CICCENB3 field.
	TCC_WAVEB_CICCENB3            = 0x800     // Bit CICCENB3.
	TCC_WAVEB_POLB0_Pos           = 0x10      // Position of POLB0 field.
	TCC_WAVEB_POLB0_Msk           = 0x10000   // Bit mask of POLB0 field.
	TCC_WAVEB_POLB0               = 0x10000   // Bit POLB0.
	TCC_WAVEB_POLB1_Pos           = 0x11      // Position of POLB1 field.
	TCC_WAVEB_POLB1_Msk           = 0x20000   // Bit mask of POLB1 field.
	TCC_WAVEB_POLB1               = 0x20000   // Bit POLB1.
	TCC_WAVEB_POLB2_Pos           = 0x12      // Position of POLB2 field.
	TCC_WAVEB_POLB2_Msk           = 0x40000   // Bit mask of POLB2 field.
	TCC_WAVEB_POLB2               = 0x40000   // Bit POLB2.
	TCC_WAVEB_POLB3_Pos           = 0x13      // Position of POLB3 field.
	TCC_WAVEB_POLB3_Msk           = 0x80000   // Bit mask of POLB3 field.
	TCC_WAVEB_POLB3               = 0x80000   // Bit POLB3.
	TCC_WAVEB_SWAPB0_Pos          = 0x18      // Position of SWAPB0 field.
	TCC_WAVEB_SWAPB0_Msk          = 0x1000000 // Bit mask of SWAPB0 field.
	TCC_WAVEB_SWAPB0              = 0x1000000 // Bit SWAPB0.
	TCC_WAVEB_SWAPB1_Pos          = 0x19      // Position of SWAPB1 field.
	TCC_WAVEB_SWAPB1_Msk          = 0x2000000 // Bit mask of SWAPB1 field.
	TCC_WAVEB_SWAPB1              = 0x2000000 // Bit SWAPB1.
	TCC_WAVEB_SWAPB2_Pos          = 0x1a      // Position of SWAPB2 field.
	TCC_WAVEB_SWAPB2_Msk          = 0x4000000 // Bit mask of SWAPB2 field.
	TCC_WAVEB_SWAPB2              = 0x4000000 // Bit SWAPB2.
	TCC_WAVEB_SWAPB3_Pos          = 0x1b      // Position of SWAPB3 field.
	TCC_WAVEB_SWAPB3_Msk          = 0x8000000 // Bit mask of SWAPB3 field.
	TCC_WAVEB_SWAPB3              = 0x8000000 // Bit SWAPB3.

	// PERB: Period Buffer
	TCC_PERB_PERB_Pos = 0x0      // Position of PERB field.
	TCC_PERB_PERB_Msk = 0xffffff // Bit mask of PERB field.

	// PERB_DITH4: Period Buffer
	TCC_PERB_DITH4_DITHERCYB_Pos = 0x0      // Position of DITHERCYB field.
	TCC_PERB_DITH4_DITHERCYB_Msk = 0xf      // Bit mask of DITHERCYB field.
	TCC_PERB_DITH4_PERB_Pos      = 0x4      // Position of PERB field.
	TCC_PERB_DITH4_PERB_Msk      = 0xfffff0 // Bit mask of PERB field.

	// PERB_DITH5: Period Buffer
	TCC_PERB_DITH5_DITHERCYB_Pos = 0x0      // Position of DITHERCYB field.
	TCC_PERB_DITH5_DITHERCYB_Msk = 0x1f     // Bit mask of DITHERCYB field.
	TCC_PERB_DITH5_PERB_Pos      = 0x5      // Position of PERB field.
	TCC_PERB_DITH5_PERB_Msk      = 0xffffe0 // Bit mask of PERB field.

	// PERB_DITH6: Period Buffer
	TCC_PERB_DITH6_DITHERCYB_Pos = 0x0      // Position of DITHERCYB field.
	TCC_PERB_DITH6_DITHERCYB_Msk = 0x3f     // Bit mask of DITHERCYB field.
	TCC_PERB_DITH6_PERB_Pos      = 0x6      // Position of PERB field.
	TCC_PERB_DITH6_PERB_Msk      = 0xffffc0 // Bit mask of PERB field.

	// CCB0: Compare and Capture Buffer
	TCC_CCB_CCB_Pos = 0x0      // Position of CCB field.
	TCC_CCB_CCB_Msk = 0xffffff // Bit mask of CCB field.

	// CCB0_DITH4: Compare and Capture Buffer
	TCC_CCB_DITH4_DITHERCYB_Pos = 0x0      // Position of DITHERCYB field.
	TCC_CCB_DITH4_DITHERCYB_Msk = 0xf      // Bit mask of DITHERCYB field.
	TCC_CCB_DITH4_CCB_Pos       = 0x4      // Position of CCB field.
	TCC_CCB_DITH4_CCB_Msk       = 0xfffff0 // Bit mask of CCB field.

	// CCB0_DITH5: Compare and Capture Buffer
	TCC_CCB_DITH5_DITHERCYB_Pos = 0x0      // Position of DITHERCYB field.
	TCC_CCB_DITH5_DITHERCYB_Msk = 0x1f     // Bit mask of DITHERCYB field.
	TCC_CCB_DITH5_CCB_Pos       = 0x5      // Position of CCB field.
	TCC_CCB_DITH5_CCB_Msk       = 0xffffe0 // Bit mask of CCB field.

	// CCB0_DITH6: Compare and Capture Buffer
	TCC_CCB_DITH6_DITHERCYB_Pos = 0x0      // Position of DITHERCYB field.
	TCC_CCB_DITH6_DITHERCYB_Msk = 0x3f     // Bit mask of DITHERCYB field.
	TCC_CCB_DITH6_CCB_Pos       = 0x6      // Position of CCB field.
	TCC_CCB_DITH6_CCB_Msk       = 0xffffc0 // Bit mask of CCB field.
)

// Bitfields for USB: Universal Serial Bus
const ()

// Bitfields for USB_DEVICE: Universal Serial Bus - DEVICE
const (
	// CTRLA: Control A
	USB_DEVICE_CTRLA_SWRST_Pos    = 0x0  // Position of SWRST field.
	USB_DEVICE_CTRLA_SWRST_Msk    = 0x1  // Bit mask of SWRST field.
	USB_DEVICE_CTRLA_SWRST        = 0x1  // Bit SWRST.
	USB_DEVICE_CTRLA_ENABLE_Pos   = 0x1  // Position of ENABLE field.
	USB_DEVICE_CTRLA_ENABLE_Msk   = 0x2  // Bit mask of ENABLE field.
	USB_DEVICE_CTRLA_ENABLE       = 0x2  // Bit ENABLE.
	USB_DEVICE_CTRLA_RUNSTDBY_Pos = 0x2  // Position of RUNSTDBY field.
	USB_DEVICE_CTRLA_RUNSTDBY_Msk = 0x4  // Bit mask of RUNSTDBY field.
	USB_DEVICE_CTRLA_RUNSTDBY     = 0x4  // Bit RUNSTDBY.
	USB_DEVICE_CTRLA_MODE_Pos     = 0x7  // Position of MODE field.
	USB_DEVICE_CTRLA_MODE_Msk     = 0x80 // Bit mask of MODE field.
	USB_DEVICE_CTRLA_MODE         = 0x80 // Bit MODE.
	USB_DEVICE_CTRLA_MODE_DEVICE  = 0x0  // Device Mode
	USB_DEVICE_CTRLA_MODE_HOST    = 0x1  // Host Mode

	// SYNCBUSY: Synchronization Busy
	USB_DEVICE_SYNCBUSY_SWRST_Pos  = 0x0 // Position of SWRST field.
	USB_DEVICE_SYNCBUSY_SWRST_Msk  = 0x1 // Bit mask of SWRST field.
	USB_DEVICE_SYNCBUSY_SWRST      = 0x1 // Bit SWRST.
	USB_DEVICE_SYNCBUSY_ENABLE_Pos = 0x1 // Position of ENABLE field.
	USB_DEVICE_SYNCBUSY_ENABLE_Msk = 0x2 // Bit mask of ENABLE field.
	USB_DEVICE_SYNCBUSY_ENABLE     = 0x2 // Bit ENABLE.

	// QOSCTRL: USB Quality Of Service
	USB_DEVICE_QOSCTRL_CQOS_Pos     = 0x0 // Position of CQOS field.
	USB_DEVICE_QOSCTRL_CQOS_Msk     = 0x3 // Bit mask of CQOS field.
	USB_DEVICE_QOSCTRL_CQOS_DISABLE = 0x0 // Background (no sensitive operation)
	USB_DEVICE_QOSCTRL_CQOS_LOW     = 0x1 // Sensitive Bandwidth
	USB_DEVICE_QOSCTRL_CQOS_MEDIUM  = 0x2 // Sensitive Latency
	USB_DEVICE_QOSCTRL_CQOS_HIGH    = 0x3 // Critical Latency
	USB_DEVICE_QOSCTRL_DQOS_Pos     = 0x2 // Position of DQOS field.
	USB_DEVICE_QOSCTRL_DQOS_Msk     = 0xc // Bit mask of DQOS field.
	USB_DEVICE_QOSCTRL_DQOS_DISABLE = 0x0 // Background (no sensitive operation)
	USB_DEVICE_QOSCTRL_DQOS_LOW     = 0x1 // Sensitive Bandwidth
	USB_DEVICE_QOSCTRL_DQOS_MEDIUM  = 0x2 // Sensitive Latency
	USB_DEVICE_QOSCTRL_DQOS_HIGH    = 0x3 // Critical Latency

	// CTRLB: DEVICE Control B
	USB_DEVICE_CTRLB_DETACH_Pos    = 0x0   // Position of DETACH field.
	USB_DEVICE_CTRLB_DETACH_Msk    = 0x1   // Bit mask of DETACH field.
	USB_DEVICE_CTRLB_DETACH        = 0x1   // Bit DETACH.
	USB_DEVICE_CTRLB_UPRSM_Pos     = 0x1   // Position of UPRSM field.
	USB_DEVICE_CTRLB_UPRSM_Msk     = 0x2   // Bit mask of UPRSM field.
	USB_DEVICE_CTRLB_UPRSM         = 0x2   // Bit UPRSM.
	USB_DEVICE_CTRLB_SPDCONF_Pos   = 0x2   // Position of SPDCONF field.
	USB_DEVICE_CTRLB_SPDCONF_Msk   = 0xc   // Bit mask of SPDCONF field.
	USB_DEVICE_CTRLB_SPDCONF_FS    = 0x0   // FS : Full Speed
	USB_DEVICE_CTRLB_SPDCONF_LS    = 0x1   // LS : Low Speed
	USB_DEVICE_CTRLB_SPDCONF_HS    = 0x2   // HS : High Speed capable
	USB_DEVICE_CTRLB_SPDCONF_HSTM  = 0x3   // HSTM: High Speed Test Mode (force high-speed mode for test mode)
	USB_DEVICE_CTRLB_NREPLY_Pos    = 0x4   // Position of NREPLY field.
	USB_DEVICE_CTRLB_NREPLY_Msk    = 0x10  // Bit mask of NREPLY field.
	USB_DEVICE_CTRLB_NREPLY        = 0x10  // Bit NREPLY.
	USB_DEVICE_CTRLB_TSTJ_Pos      = 0x5   // Position of TSTJ field.
	USB_DEVICE_CTRLB_TSTJ_Msk      = 0x20  // Bit mask of TSTJ field.
	USB_DEVICE_CTRLB_TSTJ          = 0x20  // Bit TSTJ.
	USB_DEVICE_CTRLB_TSTK_Pos      = 0x6   // Position of TSTK field.
	USB_DEVICE_CTRLB_TSTK_Msk      = 0x40  // Bit mask of TSTK field.
	USB_DEVICE_CTRLB_TSTK          = 0x40  // Bit TSTK.
	USB_DEVICE_CTRLB_TSTPCKT_Pos   = 0x7   // Position of TSTPCKT field.
	USB_DEVICE_CTRLB_TSTPCKT_Msk   = 0x80  // Bit mask of TSTPCKT field.
	USB_DEVICE_CTRLB_TSTPCKT       = 0x80  // Bit TSTPCKT.
	USB_DEVICE_CTRLB_OPMODE2_Pos   = 0x8   // Position of OPMODE2 field.
	USB_DEVICE_CTRLB_OPMODE2_Msk   = 0x100 // Bit mask of OPMODE2 field.
	USB_DEVICE_CTRLB_OPMODE2       = 0x100 // Bit OPMODE2.
	USB_DEVICE_CTRLB_GNAK_Pos      = 0x9   // Position of GNAK field.
	USB_DEVICE_CTRLB_GNAK_Msk      = 0x200 // Bit mask of GNAK field.
	USB_DEVICE_CTRLB_GNAK          = 0x200 // Bit GNAK.
	USB_DEVICE_CTRLB_LPMHDSK_Pos   = 0xa   // Position of LPMHDSK field.
	USB_DEVICE_CTRLB_LPMHDSK_Msk   = 0xc00 // Bit mask of LPMHDSK field.
	USB_DEVICE_CTRLB_LPMHDSK_NO    = 0x0   // No handshake. LPM is not supported
	USB_DEVICE_CTRLB_LPMHDSK_ACK   = 0x1   // ACK
	USB_DEVICE_CTRLB_LPMHDSK_NYET  = 0x2   // NYET
	USB_DEVICE_CTRLB_LPMHDSK_STALL = 0x3   // STALL

	// DADD: DEVICE Device Address
	USB_DEVICE_DADD_DADD_Pos  = 0x0  // Position of DADD field.
	USB_DEVICE_DADD_DADD_Msk  = 0x7f // Bit mask of DADD field.
	USB_DEVICE_DADD_ADDEN_Pos = 0x7  // Position of ADDEN field.
	USB_DEVICE_DADD_ADDEN_Msk = 0x80 // Bit mask of ADDEN field.
	USB_DEVICE_DADD_ADDEN     = 0x80 // Bit ADDEN.

	// STATUS: DEVICE Status
	USB_DEVICE_STATUS_SPEED_Pos     = 0x2  // Position of SPEED field.
	USB_DEVICE_STATUS_SPEED_Msk     = 0xc  // Bit mask of SPEED field.
	USB_DEVICE_STATUS_SPEED_FS      = 0x0  // Full-speed mode
	USB_DEVICE_STATUS_SPEED_HS      = 0x1  // High-speed mode
	USB_DEVICE_STATUS_SPEED_LS      = 0x2  // Low-speed mode
	USB_DEVICE_STATUS_LINESTATE_Pos = 0x6  // Position of LINESTATE field.
	USB_DEVICE_STATUS_LINESTATE_Msk = 0xc0 // Bit mask of LINESTATE field.
	USB_DEVICE_STATUS_LINESTATE_0   = 0x0  // SE0/RESET
	USB_DEVICE_STATUS_LINESTATE_1   = 0x1  // FS-J or LS-K State
	USB_DEVICE_STATUS_LINESTATE_2   = 0x2  // FS-K or LS-J State

	// FSMSTATUS: Finite State Machine Status
	USB_DEVICE_FSMSTATUS_FSMSTATE_Pos      = 0x0  // Position of FSMSTATE field.
	USB_DEVICE_FSMSTATUS_FSMSTATE_Msk      = 0x7f // Bit mask of FSMSTATE field.
	USB_DEVICE_FSMSTATUS_FSMSTATE_OFF      = 0x1  // OFF (L3). It corresponds to the powered-off, disconnected, and disabled state
	USB_DEVICE_FSMSTATUS_FSMSTATE_ON       = 0x2  // ON (L0). It corresponds to the Idle and Active states
	USB_DEVICE_FSMSTATUS_FSMSTATE_SUSPEND  = 0x4  // SUSPEND (L2)
	USB_DEVICE_FSMSTATUS_FSMSTATE_SLEEP    = 0x8  // SLEEP (L1)
	USB_DEVICE_FSMSTATUS_FSMSTATE_DNRESUME = 0x10 // DNRESUME. Down Stream Resume.
	USB_DEVICE_FSMSTATUS_FSMSTATE_UPRESUME = 0x20 // UPRESUME. Up Stream Resume.
	USB_DEVICE_FSMSTATUS_FSMSTATE_RESET    = 0x40 // RESET. USB lines Reset.

	// FNUM: DEVICE Device Frame Number
	USB_DEVICE_FNUM_MFNUM_Pos  = 0x0    // Position of MFNUM field.
	USB_DEVICE_FNUM_MFNUM_Msk  = 0x7    // Bit mask of MFNUM field.
	USB_DEVICE_FNUM_FNUM_Pos   = 0x3    // Position of FNUM field.
	USB_DEVICE_FNUM_FNUM_Msk   = 0x3ff8 // Bit mask of FNUM field.
	USB_DEVICE_FNUM_FNCERR_Pos = 0xf    // Position of FNCERR field.
	USB_DEVICE_FNUM_FNCERR_Msk = 0x8000 // Bit mask of FNCERR field.
	USB_DEVICE_FNUM_FNCERR     = 0x8000 // Bit FNCERR.

	// INTENCLR: DEVICE Device Interrupt Enable Clear
	USB_DEVICE_INTENCLR_SUSPEND_Pos = 0x0   // Position of SUSPEND field.
	USB_DEVICE_INTENCLR_SUSPEND_Msk = 0x1   // Bit mask of SUSPEND field.
	USB_DEVICE_INTENCLR_SUSPEND     = 0x1   // Bit SUSPEND.
	USB_DEVICE_INTENCLR_MSOF_Pos    = 0x1   // Position of MSOF field.
	USB_DEVICE_INTENCLR_MSOF_Msk    = 0x2   // Bit mask of MSOF field.
	USB_DEVICE_INTENCLR_MSOF        = 0x2   // Bit MSOF.
	USB_DEVICE_INTENCLR_SOF_Pos     = 0x2   // Position of SOF field.
	USB_DEVICE_INTENCLR_SOF_Msk     = 0x4   // Bit mask of SOF field.
	USB_DEVICE_INTENCLR_SOF         = 0x4   // Bit SOF.
	USB_DEVICE_INTENCLR_EORST_Pos   = 0x3   // Position of EORST field.
	USB_DEVICE_INTENCLR_EORST_Msk   = 0x8   // Bit mask of EORST field.
	USB_DEVICE_INTENCLR_EORST       = 0x8   // Bit EORST.
	USB_DEVICE_INTENCLR_WAKEUP_Pos  = 0x4   // Position of WAKEUP field.
	USB_DEVICE_INTENCLR_WAKEUP_Msk  = 0x10  // Bit mask of WAKEUP field.
	USB_DEVICE_INTENCLR_WAKEUP      = 0x10  // Bit WAKEUP.
	USB_DEVICE_INTENCLR_EORSM_Pos   = 0x5   // Position of EORSM field.
	USB_DEVICE_INTENCLR_EORSM_Msk   = 0x20  // Bit mask of EORSM field.
	USB_DEVICE_INTENCLR_EORSM       = 0x20  // Bit EORSM.
	USB_DEVICE_INTENCLR_UPRSM_Pos   = 0x6   // Position of UPRSM field.
	USB_DEVICE_INTENCLR_UPRSM_Msk   = 0x40  // Bit mask of UPRSM field.
	USB_DEVICE_INTENCLR_UPRSM       = 0x40  // Bit UPRSM.
	USB_DEVICE_INTENCLR_RAMACER_Pos = 0x7   // Position of RAMACER field.
	USB_DEVICE_INTENCLR_RAMACER_Msk = 0x80  // Bit mask of RAMACER field.
	USB_DEVICE_INTENCLR_RAMACER     = 0x80  // Bit RAMACER.
	USB_DEVICE_INTENCLR_LPMNYET_Pos = 0x8   // Position of LPMNYET field.
	USB_DEVICE_INTENCLR_LPMNYET_Msk = 0x100 // Bit mask of LPMNYET field.
	USB_DEVICE_INTENCLR_LPMNYET     = 0x100 // Bit LPMNYET.
	USB_DEVICE_INTENCLR_LPMSUSP_Pos = 0x9   // Position of LPMSUSP field.
	USB_DEVICE_INTENCLR_LPMSUSP_Msk = 0x200 // Bit mask of LPMSUSP field.
	USB_DEVICE_INTENCLR_LPMSUSP     = 0x200 // Bit LPMSUSP.

	// INTENSET: DEVICE Device Interrupt Enable Set
	USB_DEVICE_INTENSET_SUSPEND_Pos = 0x0   // Position of SUSPEND field.
	USB_DEVICE_INTENSET_SUSPEND_Msk = 0x1   // Bit mask of SUSPEND field.
	USB_DEVICE_INTENSET_SUSPEND     = 0x1   // Bit SUSPEND.
	USB_DEVICE_INTENSET_MSOF_Pos    = 0x1   // Position of MSOF field.
	USB_DEVICE_INTENSET_MSOF_Msk    = 0x2   // Bit mask of MSOF field.
	USB_DEVICE_INTENSET_MSOF        = 0x2   // Bit MSOF.
	USB_DEVICE_INTENSET_SOF_Pos     = 0x2   // Position of SOF field.
	USB_DEVICE_INTENSET_SOF_Msk     = 0x4   // Bit mask of SOF field.
	USB_DEVICE_INTENSET_SOF         = 0x4   // Bit SOF.
	USB_DEVICE_INTENSET_EORST_Pos   = 0x3   // Position of EORST field.
	USB_DEVICE_INTENSET_EORST_Msk   = 0x8   // Bit mask of EORST field.
	USB_DEVICE_INTENSET_EORST       = 0x8   // Bit EORST.
	USB_DEVICE_INTENSET_WAKEUP_Pos  = 0x4   // Position of WAKEUP field.
	USB_DEVICE_INTENSET_WAKEUP_Msk  = 0x10  // Bit mask of WAKEUP field.
	USB_DEVICE_INTENSET_WAKEUP      = 0x10  // Bit WAKEUP.
	USB_DEVICE_INTENSET_EORSM_Pos   = 0x5   // Position of EORSM field.
	USB_DEVICE_INTENSET_EORSM_Msk   = 0x20  // Bit mask of EORSM field.
	USB_DEVICE_INTENSET_EORSM       = 0x20  // Bit EORSM.
	USB_DEVICE_INTENSET_UPRSM_Pos   = 0x6   // Position of UPRSM field.
	USB_DEVICE_INTENSET_UPRSM_Msk   = 0x40  // Bit mask of UPRSM field.
	USB_DEVICE_INTENSET_UPRSM       = 0x40  // Bit UPRSM.
	USB_DEVICE_INTENSET_RAMACER_Pos = 0x7   // Position of RAMACER field.
	USB_DEVICE_INTENSET_RAMACER_Msk = 0x80  // Bit mask of RAMACER field.
	USB_DEVICE_INTENSET_RAMACER     = 0x80  // Bit RAMACER.
	USB_DEVICE_INTENSET_LPMNYET_Pos = 0x8   // Position of LPMNYET field.
	USB_DEVICE_INTENSET_LPMNYET_Msk = 0x100 // Bit mask of LPMNYET field.
	USB_DEVICE_INTENSET_LPMNYET     = 0x100 // Bit LPMNYET.
	USB_DEVICE_INTENSET_LPMSUSP_Pos = 0x9   // Position of LPMSUSP field.
	USB_DEVICE_INTENSET_LPMSUSP_Msk = 0x200 // Bit mask of LPMSUSP field.
	USB_DEVICE_INTENSET_LPMSUSP     = 0x200 // Bit LPMSUSP.

	// INTFLAG: DEVICE Device Interrupt Flag
	USB_DEVICE_INTFLAG_SUSPEND_Pos = 0x0   // Position of SUSPEND field.
	USB_DEVICE_INTFLAG_SUSPEND_Msk = 0x1   // Bit mask of SUSPEND field.
	USB_DEVICE_INTFLAG_SUSPEND     = 0x1   // Bit SUSPEND.
	USB_DEVICE_INTFLAG_MSOF_Pos    = 0x1   // Position of MSOF field.
	USB_DEVICE_INTFLAG_MSOF_Msk    = 0x2   // Bit mask of MSOF field.
	USB_DEVICE_INTFLAG_MSOF        = 0x2   // Bit MSOF.
	USB_DEVICE_INTFLAG_SOF_Pos     = 0x2   // Position of SOF field.
	USB_DEVICE_INTFLAG_SOF_Msk     = 0x4   // Bit mask of SOF field.
	USB_DEVICE_INTFLAG_SOF         = 0x4   // Bit SOF.
	USB_DEVICE_INTFLAG_EORST_Pos   = 0x3   // Position of EORST field.
	USB_DEVICE_INTFLAG_EORST_Msk   = 0x8   // Bit mask of EORST field.
	USB_DEVICE_INTFLAG_EORST       = 0x8   // Bit EORST.
	USB_DEVICE_INTFLAG_WAKEUP_Pos  = 0x4   // Position of WAKEUP field.
	USB_DEVICE_INTFLAG_WAKEUP_Msk  = 0x10  // Bit mask of WAKEUP field.
	USB_DEVICE_INTFLAG_WAKEUP      = 0x10  // Bit WAKEUP.
	USB_DEVICE_INTFLAG_EORSM_Pos   = 0x5   // Position of EORSM field.
	USB_DEVICE_INTFLAG_EORSM_Msk   = 0x20  // Bit mask of EORSM field.
	USB_DEVICE_INTFLAG_EORSM       = 0x20  // Bit EORSM.
	USB_DEVICE_INTFLAG_UPRSM_Pos   = 0x6   // Position of UPRSM field.
	USB_DEVICE_INTFLAG_UPRSM_Msk   = 0x40  // Bit mask of UPRSM field.
	USB_DEVICE_INTFLAG_UPRSM       = 0x40  // Bit UPRSM.
	USB_DEVICE_INTFLAG_RAMACER_Pos = 0x7   // Position of RAMACER field.
	USB_DEVICE_INTFLAG_RAMACER_Msk = 0x80  // Bit mask of RAMACER field.
	USB_DEVICE_INTFLAG_RAMACER     = 0x80  // Bit RAMACER.
	USB_DEVICE_INTFLAG_LPMNYET_Pos = 0x8   // Position of LPMNYET field.
	USB_DEVICE_INTFLAG_LPMNYET_Msk = 0x100 // Bit mask of LPMNYET field.
	USB_DEVICE_INTFLAG_LPMNYET     = 0x100 // Bit LPMNYET.
	USB_DEVICE_INTFLAG_LPMSUSP_Pos = 0x9   // Position of LPMSUSP field.
	USB_DEVICE_INTFLAG_LPMSUSP_Msk = 0x200 // Bit mask of LPMSUSP field.
	USB_DEVICE_INTFLAG_LPMSUSP     = 0x200 // Bit LPMSUSP.

	// EPINTSMRY: DEVICE End Point Interrupt Summary
	USB_DEVICE_EPINTSMRY_EPINT0_Pos = 0x0  // Position of EPINT0 field.
	USB_DEVICE_EPINTSMRY_EPINT0_Msk = 0x1  // Bit mask of EPINT0 field.
	USB_DEVICE_EPINTSMRY_EPINT0     = 0x1  // Bit EPINT0.
	USB_DEVICE_EPINTSMRY_EPINT1_Pos = 0x1  // Position of EPINT1 field.
	USB_DEVICE_EPINTSMRY_EPINT1_Msk = 0x2  // Bit mask of EPINT1 field.
	USB_DEVICE_EPINTSMRY_EPINT1     = 0x2  // Bit EPINT1.
	USB_DEVICE_EPINTSMRY_EPINT2_Pos = 0x2  // Position of EPINT2 field.
	USB_DEVICE_EPINTSMRY_EPINT2_Msk = 0x4  // Bit mask of EPINT2 field.
	USB_DEVICE_EPINTSMRY_EPINT2     = 0x4  // Bit EPINT2.
	USB_DEVICE_EPINTSMRY_EPINT3_Pos = 0x3  // Position of EPINT3 field.
	USB_DEVICE_EPINTSMRY_EPINT3_Msk = 0x8  // Bit mask of EPINT3 field.
	USB_DEVICE_EPINTSMRY_EPINT3     = 0x8  // Bit EPINT3.
	USB_DEVICE_EPINTSMRY_EPINT4_Pos = 0x4  // Position of EPINT4 field.
	USB_DEVICE_EPINTSMRY_EPINT4_Msk = 0x10 // Bit mask of EPINT4 field.
	USB_DEVICE_EPINTSMRY_EPINT4     = 0x10 // Bit EPINT4.
	USB_DEVICE_EPINTSMRY_EPINT5_Pos = 0x5  // Position of EPINT5 field.
	USB_DEVICE_EPINTSMRY_EPINT5_Msk = 0x20 // Bit mask of EPINT5 field.
	USB_DEVICE_EPINTSMRY_EPINT5     = 0x20 // Bit EPINT5.
	USB_DEVICE_EPINTSMRY_EPINT6_Pos = 0x6  // Position of EPINT6 field.
	USB_DEVICE_EPINTSMRY_EPINT6_Msk = 0x40 // Bit mask of EPINT6 field.
	USB_DEVICE_EPINTSMRY_EPINT6     = 0x40 // Bit EPINT6.
	USB_DEVICE_EPINTSMRY_EPINT7_Pos = 0x7  // Position of EPINT7 field.
	USB_DEVICE_EPINTSMRY_EPINT7_Msk = 0x80 // Bit mask of EPINT7 field.
	USB_DEVICE_EPINTSMRY_EPINT7     = 0x80 // Bit EPINT7.

	// DESCADD: Descriptor Address
	USB_DEVICE_DESCADD_DESCADD_Pos = 0x0        // Position of DESCADD field.
	USB_DEVICE_DESCADD_DESCADD_Msk = 0xffffffff // Bit mask of DESCADD field.

	// PADCAL: USB PAD Calibration
	USB_DEVICE_PADCAL_TRANSP_Pos = 0x0    // Position of TRANSP field.
	USB_DEVICE_PADCAL_TRANSP_Msk = 0x1f   // Bit mask of TRANSP field.
	USB_DEVICE_PADCAL_TRANSN_Pos = 0x6    // Position of TRANSN field.
	USB_DEVICE_PADCAL_TRANSN_Msk = 0x7c0  // Bit mask of TRANSN field.
	USB_DEVICE_PADCAL_TRIM_Pos   = 0xc    // Position of TRIM field.
	USB_DEVICE_PADCAL_TRIM_Msk   = 0x7000 // Bit mask of TRIM field.

	// EPCFG0: DEVICE End Point Configuration
	USB_DEVICE_EPCFG_EPTYPE0_Pos = 0x0  // Position of EPTYPE0 field.
	USB_DEVICE_EPCFG_EPTYPE0_Msk = 0x7  // Bit mask of EPTYPE0 field.
	USB_DEVICE_EPCFG_EPTYPE1_Pos = 0x4  // Position of EPTYPE1 field.
	USB_DEVICE_EPCFG_EPTYPE1_Msk = 0x70 // Bit mask of EPTYPE1 field.
	USB_DEVICE_EPCFG_NYETDIS_Pos = 0x7  // Position of NYETDIS field.
	USB_DEVICE_EPCFG_NYETDIS_Msk = 0x80 // Bit mask of NYETDIS field.
	USB_DEVICE_EPCFG_NYETDIS     = 0x80 // Bit NYETDIS.

	// EPSTATUSCLR0: DEVICE End Point Pipe Status Clear
	USB_DEVICE_EPSTATUSCLR_DTGLOUT_Pos  = 0x0  // Position of DTGLOUT field.
	USB_DEVICE_EPSTATUSCLR_DTGLOUT_Msk  = 0x1  // Bit mask of DTGLOUT field.
	USB_DEVICE_EPSTATUSCLR_DTGLOUT      = 0x1  // Bit DTGLOUT.
	USB_DEVICE_EPSTATUSCLR_DTGLIN_Pos   = 0x1  // Position of DTGLIN field.
	USB_DEVICE_EPSTATUSCLR_DTGLIN_Msk   = 0x2  // Bit mask of DTGLIN field.
	USB_DEVICE_EPSTATUSCLR_DTGLIN       = 0x2  // Bit DTGLIN.
	USB_DEVICE_EPSTATUSCLR_CURBK_Pos    = 0x2  // Position of CURBK field.
	USB_DEVICE_EPSTATUSCLR_CURBK_Msk    = 0x4  // Bit mask of CURBK field.
	USB_DEVICE_EPSTATUSCLR_CURBK        = 0x4  // Bit CURBK.
	USB_DEVICE_EPSTATUSCLR_STALLRQ0_Pos = 0x4  // Position of STALLRQ0 field.
	USB_DEVICE_EPSTATUSCLR_STALLRQ0_Msk = 0x10 // Bit mask of STALLRQ0 field.
	USB_DEVICE_EPSTATUSCLR_STALLRQ0     = 0x10 // Bit STALLRQ0.
	USB_DEVICE_EPSTATUSCLR_STALLRQ1_Pos = 0x5  // Position of STALLRQ1 field.
	USB_DEVICE_EPSTATUSCLR_STALLRQ1_Msk = 0x20 // Bit mask of STALLRQ1 field.
	USB_DEVICE_EPSTATUSCLR_STALLRQ1     = 0x20 // Bit STALLRQ1.
	USB_DEVICE_EPSTATUSCLR_BK0RDY_Pos   = 0x6  // Position of BK0RDY field.
	USB_DEVICE_EPSTATUSCLR_BK0RDY_Msk   = 0x40 // Bit mask of BK0RDY field.
	USB_DEVICE_EPSTATUSCLR_BK0RDY       = 0x40 // Bit BK0RDY.
	USB_DEVICE_EPSTATUSCLR_BK1RDY_Pos   = 0x7  // Position of BK1RDY field.
	USB_DEVICE_EPSTATUSCLR_BK1RDY_Msk   = 0x80 // Bit mask of BK1RDY field.
	USB_DEVICE_EPSTATUSCLR_BK1RDY       = 0x80 // Bit BK1RDY.

	// EPSTATUSSET0: DEVICE End Point Pipe Status Set
	USB_DEVICE_EPSTATUSSET_DTGLOUT_Pos  = 0x0  // Position of DTGLOUT field.
	USB_DEVICE_EPSTATUSSET_DTGLOUT_Msk  = 0x1  // Bit mask of DTGLOUT field.
	USB_DEVICE_EPSTATUSSET_DTGLOUT      = 0x1  // Bit DTGLOUT.
	USB_DEVICE_EPSTATUSSET_DTGLIN_Pos   = 0x1  // Position of DTGLIN field.
	USB_DEVICE_EPSTATUSSET_DTGLIN_Msk   = 0x2  // Bit mask of DTGLIN field.
	USB_DEVICE_EPSTATUSSET_DTGLIN       = 0x2  // Bit DTGLIN.
	USB_DEVICE_EPSTATUSSET_CURBK_Pos    = 0x2  // Position of CURBK field.
	USB_DEVICE_EPSTATUSSET_CURBK_Msk    = 0x4  // Bit mask of CURBK field.
	USB_DEVICE_EPSTATUSSET_CURBK        = 0x4  // Bit CURBK.
	USB_DEVICE_EPSTATUSSET_STALLRQ0_Pos = 0x4  // Position of STALLRQ0 field.
	USB_DEVICE_EPSTATUSSET_STALLRQ0_Msk = 0x10 // Bit mask of STALLRQ0 field.
	USB_DEVICE_EPSTATUSSET_STALLRQ0     = 0x10 // Bit STALLRQ0.
	USB_DEVICE_EPSTATUSSET_STALLRQ1_Pos = 0x5  // Position of STALLRQ1 field.
	USB_DEVICE_EPSTATUSSET_STALLRQ1_Msk = 0x20 // Bit mask of STALLRQ1 field.
	USB_DEVICE_EPSTATUSSET_STALLRQ1     = 0x20 // Bit STALLRQ1.
	USB_DEVICE_EPSTATUSSET_BK0RDY_Pos   = 0x6  // Position of BK0RDY field.
	USB_DEVICE_EPSTATUSSET_BK0RDY_Msk   = 0x40 // Bit mask of BK0RDY field.
	USB_DEVICE_EPSTATUSSET_BK0RDY       = 0x40 // Bit BK0RDY.
	USB_DEVICE_EPSTATUSSET_BK1RDY_Pos   = 0x7  // Position of BK1RDY field.
	USB_DEVICE_EPSTATUSSET_BK1RDY_Msk   = 0x80 // Bit mask of BK1RDY field.
	USB_DEVICE_EPSTATUSSET_BK1RDY       = 0x80 // Bit BK1RDY.

	// EPSTATUS0: DEVICE End Point Pipe Status
	USB_DEVICE_EPSTATUS_DTGLOUT_Pos  = 0x0  // Position of DTGLOUT field.
	USB_DEVICE_EPSTATUS_DTGLOUT_Msk  = 0x1  // Bit mask of DTGLOUT field.
	USB_DEVICE_EPSTATUS_DTGLOUT      = 0x1  // Bit DTGLOUT.
	USB_DEVICE_EPSTATUS_DTGLIN_Pos   = 0x1  // Position of DTGLIN field.
	USB_DEVICE_EPSTATUS_DTGLIN_Msk   = 0x2  // Bit mask of DTGLIN field.
	USB_DEVICE_EPSTATUS_DTGLIN       = 0x2  // Bit DTGLIN.
	USB_DEVICE_EPSTATUS_CURBK_Pos    = 0x2  // Position of CURBK field.
	USB_DEVICE_EPSTATUS_CURBK_Msk    = 0x4  // Bit mask of CURBK field.
	USB_DEVICE_EPSTATUS_CURBK        = 0x4  // Bit CURBK.
	USB_DEVICE_EPSTATUS_STALLRQ0_Pos = 0x4  // Position of STALLRQ0 field.
	USB_DEVICE_EPSTATUS_STALLRQ0_Msk = 0x10 // Bit mask of STALLRQ0 field.
	USB_DEVICE_EPSTATUS_STALLRQ0     = 0x10 // Bit STALLRQ0.
	USB_DEVICE_EPSTATUS_STALLRQ1_Pos = 0x5  // Position of STALLRQ1 field.
	USB_DEVICE_EPSTATUS_STALLRQ1_Msk = 0x20 // Bit mask of STALLRQ1 field.
	USB_DEVICE_EPSTATUS_STALLRQ1     = 0x20 // Bit STALLRQ1.
	USB_DEVICE_EPSTATUS_BK0RDY_Pos   = 0x6  // Position of BK0RDY field.
	USB_DEVICE_EPSTATUS_BK0RDY_Msk   = 0x40 // Bit mask of BK0RDY field.
	USB_DEVICE_EPSTATUS_BK0RDY       = 0x40 // Bit BK0RDY.
	USB_DEVICE_EPSTATUS_BK1RDY_Pos   = 0x7  // Position of BK1RDY field.
	USB_DEVICE_EPSTATUS_BK1RDY_Msk   = 0x80 // Bit mask of BK1RDY field.
	USB_DEVICE_EPSTATUS_BK1RDY       = 0x80 // Bit BK1RDY.

	// EPINTFLAG0: DEVICE End Point Interrupt Flag
	USB_DEVICE_EPINTFLAG_TRCPT0_Pos  = 0x0  // Position of TRCPT0 field.
	USB_DEVICE_EPINTFLAG_TRCPT0_Msk  = 0x1  // Bit mask of TRCPT0 field.
	USB_DEVICE_EPINTFLAG_TRCPT0      = 0x1  // Bit TRCPT0.
	USB_DEVICE_EPINTFLAG_TRCPT1_Pos  = 0x1  // Position of TRCPT1 field.
	USB_DEVICE_EPINTFLAG_TRCPT1_Msk  = 0x2  // Bit mask of TRCPT1 field.
	USB_DEVICE_EPINTFLAG_TRCPT1      = 0x2  // Bit TRCPT1.
	USB_DEVICE_EPINTFLAG_TRFAIL0_Pos = 0x2  // Position of TRFAIL0 field.
	USB_DEVICE_EPINTFLAG_TRFAIL0_Msk = 0x4  // Bit mask of TRFAIL0 field.
	USB_DEVICE_EPINTFLAG_TRFAIL0     = 0x4  // Bit TRFAIL0.
	USB_DEVICE_EPINTFLAG_TRFAIL1_Pos = 0x3  // Position of TRFAIL1 field.
	USB_DEVICE_EPINTFLAG_TRFAIL1_Msk = 0x8  // Bit mask of TRFAIL1 field.
	USB_DEVICE_EPINTFLAG_TRFAIL1     = 0x8  // Bit TRFAIL1.
	USB_DEVICE_EPINTFLAG_RXSTP_Pos   = 0x4  // Position of RXSTP field.
	USB_DEVICE_EPINTFLAG_RXSTP_Msk   = 0x10 // Bit mask of RXSTP field.
	USB_DEVICE_EPINTFLAG_RXSTP       = 0x10 // Bit RXSTP.
	USB_DEVICE_EPINTFLAG_STALL0_Pos  = 0x5  // Position of STALL0 field.
	USB_DEVICE_EPINTFLAG_STALL0_Msk  = 0x20 // Bit mask of STALL0 field.
	USB_DEVICE_EPINTFLAG_STALL0      = 0x20 // Bit STALL0.
	USB_DEVICE_EPINTFLAG_STALL1_Pos  = 0x6  // Position of STALL1 field.
	USB_DEVICE_EPINTFLAG_STALL1_Msk  = 0x40 // Bit mask of STALL1 field.
	USB_DEVICE_EPINTFLAG_STALL1      = 0x40 // Bit STALL1.

	// EPINTENCLR0: DEVICE End Point Interrupt Clear Flag
	USB_DEVICE_EPINTENCLR_TRCPT0_Pos  = 0x0  // Position of TRCPT0 field.
	USB_DEVICE_EPINTENCLR_TRCPT0_Msk  = 0x1  // Bit mask of TRCPT0 field.
	USB_DEVICE_EPINTENCLR_TRCPT0      = 0x1  // Bit TRCPT0.
	USB_DEVICE_EPINTENCLR_TRCPT1_Pos  = 0x1  // Position of TRCPT1 field.
	USB_DEVICE_EPINTENCLR_TRCPT1_Msk  = 0x2  // Bit mask of TRCPT1 field.
	USB_DEVICE_EPINTENCLR_TRCPT1      = 0x2  // Bit TRCPT1.
	USB_DEVICE_EPINTENCLR_TRFAIL0_Pos = 0x2  // Position of TRFAIL0 field.
	USB_DEVICE_EPINTENCLR_TRFAIL0_Msk = 0x4  // Bit mask of TRFAIL0 field.
	USB_DEVICE_EPINTENCLR_TRFAIL0     = 0x4  // Bit TRFAIL0.
	USB_DEVICE_EPINTENCLR_TRFAIL1_Pos = 0x3  // Position of TRFAIL1 field.
	USB_DEVICE_EPINTENCLR_TRFAIL1_Msk = 0x8  // Bit mask of TRFAIL1 field.
	USB_DEVICE_EPINTENCLR_TRFAIL1     = 0x8  // Bit TRFAIL1.
	USB_DEVICE_EPINTENCLR_RXSTP_Pos   = 0x4  // Position of RXSTP field.
	USB_DEVICE_EPINTENCLR_RXSTP_Msk   = 0x10 // Bit mask of RXSTP field.
	USB_DEVICE_EPINTENCLR_RXSTP       = 0x10 // Bit RXSTP.
	USB_DEVICE_EPINTENCLR_STALL0_Pos  = 0x5  // Position of STALL0 field.
	USB_DEVICE_EPINTENCLR_STALL0_Msk  = 0x20 // Bit mask of STALL0 field.
	USB_DEVICE_EPINTENCLR_STALL0      = 0x20 // Bit STALL0.
	USB_DEVICE_EPINTENCLR_STALL1_Pos  = 0x6  // Position of STALL1 field.
	USB_DEVICE_EPINTENCLR_STALL1_Msk  = 0x40 // Bit mask of STALL1 field.
	USB_DEVICE_EPINTENCLR_STALL1      = 0x40 // Bit STALL1.

	// EPINTENSET0: DEVICE End Point Interrupt Set Flag
	USB_DEVICE_EPINTENSET_TRCPT0_Pos  = 0x0  // Position of TRCPT0 field.
	USB_DEVICE_EPINTENSET_TRCPT0_Msk  = 0x1  // Bit mask of TRCPT0 field.
	USB_DEVICE_EPINTENSET_TRCPT0      = 0x1  // Bit TRCPT0.
	USB_DEVICE_EPINTENSET_TRCPT1_Pos  = 0x1  // Position of TRCPT1 field.
	USB_DEVICE_EPINTENSET_TRCPT1_Msk  = 0x2  // Bit mask of TRCPT1 field.
	USB_DEVICE_EPINTENSET_TRCPT1      = 0x2  // Bit TRCPT1.
	USB_DEVICE_EPINTENSET_TRFAIL0_Pos = 0x2  // Position of TRFAIL0 field.
	USB_DEVICE_EPINTENSET_TRFAIL0_Msk = 0x4  // Bit mask of TRFAIL0 field.
	USB_DEVICE_EPINTENSET_TRFAIL0     = 0x4  // Bit TRFAIL0.
	USB_DEVICE_EPINTENSET_TRFAIL1_Pos = 0x3  // Position of TRFAIL1 field.
	USB_DEVICE_EPINTENSET_TRFAIL1_Msk = 0x8  // Bit mask of TRFAIL1 field.
	USB_DEVICE_EPINTENSET_TRFAIL1     = 0x8  // Bit TRFAIL1.
	USB_DEVICE_EPINTENSET_RXSTP_Pos   = 0x4  // Position of RXSTP field.
	USB_DEVICE_EPINTENSET_RXSTP_Msk   = 0x10 // Bit mask of RXSTP field.
	USB_DEVICE_EPINTENSET_RXSTP       = 0x10 // Bit RXSTP.
	USB_DEVICE_EPINTENSET_STALL0_Pos  = 0x5  // Position of STALL0 field.
	USB_DEVICE_EPINTENSET_STALL0_Msk  = 0x20 // Bit mask of STALL0 field.
	USB_DEVICE_EPINTENSET_STALL0      = 0x20 // Bit STALL0.
	USB_DEVICE_EPINTENSET_STALL1_Pos  = 0x6  // Position of STALL1 field.
	USB_DEVICE_EPINTENSET_STALL1_Msk  = 0x40 // Bit mask of STALL1 field.
	USB_DEVICE_EPINTENSET_STALL1      = 0x40 // Bit STALL1.
)

// Bitfields for USB_HOST: Universal Serial Bus - HOST
const (
	// CTRLA: Control A
	USB_HOST_CTRLA_SWRST_Pos    = 0x0  // Position of SWRST field.
	USB_HOST_CTRLA_SWRST_Msk    = 0x1  // Bit mask of SWRST field.
	USB_HOST_CTRLA_SWRST        = 0x1  // Bit SWRST.
	USB_HOST_CTRLA_ENABLE_Pos   = 0x1  // Position of ENABLE field.
	USB_HOST_CTRLA_ENABLE_Msk   = 0x2  // Bit mask of ENABLE field.
	USB_HOST_CTRLA_ENABLE       = 0x2  // Bit ENABLE.
	USB_HOST_CTRLA_RUNSTDBY_Pos = 0x2  // Position of RUNSTDBY field.
	USB_HOST_CTRLA_RUNSTDBY_Msk = 0x4  // Bit mask of RUNSTDBY field.
	USB_HOST_CTRLA_RUNSTDBY     = 0x4  // Bit RUNSTDBY.
	USB_HOST_CTRLA_MODE_Pos     = 0x7  // Position of MODE field.
	USB_HOST_CTRLA_MODE_Msk     = 0x80 // Bit mask of MODE field.
	USB_HOST_CTRLA_MODE         = 0x80 // Bit MODE.
	USB_HOST_CTRLA_MODE_DEVICE  = 0x0  // Device Mode
	USB_HOST_CTRLA_MODE_HOST    = 0x1  // Host Mode

	// SYNCBUSY: Synchronization Busy
	USB_HOST_SYNCBUSY_SWRST_Pos  = 0x0 // Position of SWRST field.
	USB_HOST_SYNCBUSY_SWRST_Msk  = 0x1 // Bit mask of SWRST field.
	USB_HOST_SYNCBUSY_SWRST      = 0x1 // Bit SWRST.
	USB_HOST_SYNCBUSY_ENABLE_Pos = 0x1 // Position of ENABLE field.
	USB_HOST_SYNCBUSY_ENABLE_Msk = 0x2 // Bit mask of ENABLE field.
	USB_HOST_SYNCBUSY_ENABLE     = 0x2 // Bit ENABLE.

	// QOSCTRL: USB Quality Of Service
	USB_HOST_QOSCTRL_CQOS_Pos     = 0x0 // Position of CQOS field.
	USB_HOST_QOSCTRL_CQOS_Msk     = 0x3 // Bit mask of CQOS field.
	USB_HOST_QOSCTRL_CQOS_DISABLE = 0x0 // Background (no sensitive operation)
	USB_HOST_QOSCTRL_CQOS_LOW     = 0x1 // Sensitive Bandwidth
	USB_HOST_QOSCTRL_CQOS_MEDIUM  = 0x2 // Sensitive Latency
	USB_HOST_QOSCTRL_CQOS_HIGH    = 0x3 // Critical Latency
	USB_HOST_QOSCTRL_DQOS_Pos     = 0x2 // Position of DQOS field.
	USB_HOST_QOSCTRL_DQOS_Msk     = 0xc // Bit mask of DQOS field.
	USB_HOST_QOSCTRL_DQOS_DISABLE = 0x0 // Background (no sensitive operation)
	USB_HOST_QOSCTRL_DQOS_LOW     = 0x1 // Sensitive Bandwidth
	USB_HOST_QOSCTRL_DQOS_MEDIUM  = 0x2 // Sensitive Latency
	USB_HOST_QOSCTRL_DQOS_HIGH    = 0x3 // Critical Latency

	// CTRLB: HOST Control B
	USB_HOST_CTRLB_RESUME_Pos     = 0x1   // Position of RESUME field.
	USB_HOST_CTRLB_RESUME_Msk     = 0x2   // Bit mask of RESUME field.
	USB_HOST_CTRLB_RESUME         = 0x2   // Bit RESUME.
	USB_HOST_CTRLB_SPDCONF_Pos    = 0x2   // Position of SPDCONF field.
	USB_HOST_CTRLB_SPDCONF_Msk    = 0xc   // Bit mask of SPDCONF field.
	USB_HOST_CTRLB_SPDCONF_NORMAL = 0x0   // Normal mode: the host starts in full-speed mode and performs a high-speed reset to switch to the high speed mode if the downstream peripheral is high-speed capable.
	USB_HOST_CTRLB_SPDCONF_FS     = 0x3   // Full-speed: the host remains in full-speed mode whatever is the peripheral speed capability. Relevant in UTMI mode only.
	USB_HOST_CTRLB_TSTJ_Pos       = 0x5   // Position of TSTJ field.
	USB_HOST_CTRLB_TSTJ_Msk       = 0x20  // Bit mask of TSTJ field.
	USB_HOST_CTRLB_TSTJ           = 0x20  // Bit TSTJ.
	USB_HOST_CTRLB_TSTK_Pos       = 0x6   // Position of TSTK field.
	USB_HOST_CTRLB_TSTK_Msk       = 0x40  // Bit mask of TSTK field.
	USB_HOST_CTRLB_TSTK           = 0x40  // Bit TSTK.
	USB_HOST_CTRLB_SOFE_Pos       = 0x8   // Position of SOFE field.
	USB_HOST_CTRLB_SOFE_Msk       = 0x100 // Bit mask of SOFE field.
	USB_HOST_CTRLB_SOFE           = 0x100 // Bit SOFE.
	USB_HOST_CTRLB_BUSRESET_Pos   = 0x9   // Position of BUSRESET field.
	USB_HOST_CTRLB_BUSRESET_Msk   = 0x200 // Bit mask of BUSRESET field.
	USB_HOST_CTRLB_BUSRESET       = 0x200 // Bit BUSRESET.
	USB_HOST_CTRLB_VBUSOK_Pos     = 0xa   // Position of VBUSOK field.
	USB_HOST_CTRLB_VBUSOK_Msk     = 0x400 // Bit mask of VBUSOK field.
	USB_HOST_CTRLB_VBUSOK         = 0x400 // Bit VBUSOK.
	USB_HOST_CTRLB_L1RESUME_Pos   = 0xb   // Position of L1RESUME field.
	USB_HOST_CTRLB_L1RESUME_Msk   = 0x800 // Bit mask of L1RESUME field.
	USB_HOST_CTRLB_L1RESUME       = 0x800 // Bit L1RESUME.

	// HSOFC: HOST Host Start Of Frame Control
	USB_HOST_HSOFC_FLENC_Pos  = 0x0  // Position of FLENC field.
	USB_HOST_HSOFC_FLENC_Msk  = 0xf  // Bit mask of FLENC field.
	USB_HOST_HSOFC_FLENCE_Pos = 0x7  // Position of FLENCE field.
	USB_HOST_HSOFC_FLENCE_Msk = 0x80 // Bit mask of FLENCE field.
	USB_HOST_HSOFC_FLENCE     = 0x80 // Bit FLENCE.

	// STATUS: HOST Status
	USB_HOST_STATUS_SPEED_Pos     = 0x2  // Position of SPEED field.
	USB_HOST_STATUS_SPEED_Msk     = 0xc  // Bit mask of SPEED field.
	USB_HOST_STATUS_LINESTATE_Pos = 0x6  // Position of LINESTATE field.
	USB_HOST_STATUS_LINESTATE_Msk = 0xc0 // Bit mask of LINESTATE field.

	// FSMSTATUS: Finite State Machine Status
	USB_HOST_FSMSTATUS_FSMSTATE_Pos      = 0x0  // Position of FSMSTATE field.
	USB_HOST_FSMSTATUS_FSMSTATE_Msk      = 0x7f // Bit mask of FSMSTATE field.
	USB_HOST_FSMSTATUS_FSMSTATE_OFF      = 0x1  // OFF (L3). It corresponds to the powered-off, disconnected, and disabled state
	USB_HOST_FSMSTATUS_FSMSTATE_ON       = 0x2  // ON (L0). It corresponds to the Idle and Active states
	USB_HOST_FSMSTATUS_FSMSTATE_SUSPEND  = 0x4  // SUSPEND (L2)
	USB_HOST_FSMSTATUS_FSMSTATE_SLEEP    = 0x8  // SLEEP (L1)
	USB_HOST_FSMSTATUS_FSMSTATE_DNRESUME = 0x10 // DNRESUME. Down Stream Resume.
	USB_HOST_FSMSTATUS_FSMSTATE_UPRESUME = 0x20 // UPRESUME. Up Stream Resume.
	USB_HOST_FSMSTATUS_FSMSTATE_RESET    = 0x40 // RESET. USB lines Reset.

	// FNUM: HOST Host Frame Number
	USB_HOST_FNUM_MFNUM_Pos = 0x0    // Position of MFNUM field.
	USB_HOST_FNUM_MFNUM_Msk = 0x7    // Bit mask of MFNUM field.
	USB_HOST_FNUM_FNUM_Pos  = 0x3    // Position of FNUM field.
	USB_HOST_FNUM_FNUM_Msk  = 0x3ff8 // Bit mask of FNUM field.

	// FLENHIGH: HOST Host Frame Length
	USB_HOST_FLENHIGH_FLENHIGH_Pos = 0x0  // Position of FLENHIGH field.
	USB_HOST_FLENHIGH_FLENHIGH_Msk = 0xff // Bit mask of FLENHIGH field.

	// INTENCLR: HOST Host Interrupt Enable Clear
	USB_HOST_INTENCLR_HSOF_Pos    = 0x2   // Position of HSOF field.
	USB_HOST_INTENCLR_HSOF_Msk    = 0x4   // Bit mask of HSOF field.
	USB_HOST_INTENCLR_HSOF        = 0x4   // Bit HSOF.
	USB_HOST_INTENCLR_RST_Pos     = 0x3   // Position of RST field.
	USB_HOST_INTENCLR_RST_Msk     = 0x8   // Bit mask of RST field.
	USB_HOST_INTENCLR_RST         = 0x8   // Bit RST.
	USB_HOST_INTENCLR_WAKEUP_Pos  = 0x4   // Position of WAKEUP field.
	USB_HOST_INTENCLR_WAKEUP_Msk  = 0x10  // Bit mask of WAKEUP field.
	USB_HOST_INTENCLR_WAKEUP      = 0x10  // Bit WAKEUP.
	USB_HOST_INTENCLR_DNRSM_Pos   = 0x5   // Position of DNRSM field.
	USB_HOST_INTENCLR_DNRSM_Msk   = 0x20  // Bit mask of DNRSM field.
	USB_HOST_INTENCLR_DNRSM       = 0x20  // Bit DNRSM.
	USB_HOST_INTENCLR_UPRSM_Pos   = 0x6   // Position of UPRSM field.
	USB_HOST_INTENCLR_UPRSM_Msk   = 0x40  // Bit mask of UPRSM field.
	USB_HOST_INTENCLR_UPRSM       = 0x40  // Bit UPRSM.
	USB_HOST_INTENCLR_RAMACER_Pos = 0x7   // Position of RAMACER field.
	USB_HOST_INTENCLR_RAMACER_Msk = 0x80  // Bit mask of RAMACER field.
	USB_HOST_INTENCLR_RAMACER     = 0x80  // Bit RAMACER.
	USB_HOST_INTENCLR_DCONN_Pos   = 0x8   // Position of DCONN field.
	USB_HOST_INTENCLR_DCONN_Msk   = 0x100 // Bit mask of DCONN field.
	USB_HOST_INTENCLR_DCONN       = 0x100 // Bit DCONN.
	USB_HOST_INTENCLR_DDISC_Pos   = 0x9   // Position of DDISC field.
	USB_HOST_INTENCLR_DDISC_Msk   = 0x200 // Bit mask of DDISC field.
	USB_HOST_INTENCLR_DDISC       = 0x200 // Bit DDISC.

	// INTENSET: HOST Host Interrupt Enable Set
	USB_HOST_INTENSET_HSOF_Pos    = 0x2   // Position of HSOF field.
	USB_HOST_INTENSET_HSOF_Msk    = 0x4   // Bit mask of HSOF field.
	USB_HOST_INTENSET_HSOF        = 0x4   // Bit HSOF.
	USB_HOST_INTENSET_RST_Pos     = 0x3   // Position of RST field.
	USB_HOST_INTENSET_RST_Msk     = 0x8   // Bit mask of RST field.
	USB_HOST_INTENSET_RST         = 0x8   // Bit RST.
	USB_HOST_INTENSET_WAKEUP_Pos  = 0x4   // Position of WAKEUP field.
	USB_HOST_INTENSET_WAKEUP_Msk  = 0x10  // Bit mask of WAKEUP field.
	USB_HOST_INTENSET_WAKEUP      = 0x10  // Bit WAKEUP.
	USB_HOST_INTENSET_DNRSM_Pos   = 0x5   // Position of DNRSM field.
	USB_HOST_INTENSET_DNRSM_Msk   = 0x20  // Bit mask of DNRSM field.
	USB_HOST_INTENSET_DNRSM       = 0x20  // Bit DNRSM.
	USB_HOST_INTENSET_UPRSM_Pos   = 0x6   // Position of UPRSM field.
	USB_HOST_INTENSET_UPRSM_Msk   = 0x40  // Bit mask of UPRSM field.
	USB_HOST_INTENSET_UPRSM       = 0x40  // Bit UPRSM.
	USB_HOST_INTENSET_RAMACER_Pos = 0x7   // Position of RAMACER field.
	USB_HOST_INTENSET_RAMACER_Msk = 0x80  // Bit mask of RAMACER field.
	USB_HOST_INTENSET_RAMACER     = 0x80  // Bit RAMACER.
	USB_HOST_INTENSET_DCONN_Pos   = 0x8   // Position of DCONN field.
	USB_HOST_INTENSET_DCONN_Msk   = 0x100 // Bit mask of DCONN field.
	USB_HOST_INTENSET_DCONN       = 0x100 // Bit DCONN.
	USB_HOST_INTENSET_DDISC_Pos   = 0x9   // Position of DDISC field.
	USB_HOST_INTENSET_DDISC_Msk   = 0x200 // Bit mask of DDISC field.
	USB_HOST_INTENSET_DDISC       = 0x200 // Bit DDISC.

	// INTFLAG: HOST Host Interrupt Flag
	USB_HOST_INTFLAG_HSOF_Pos    = 0x2   // Position of HSOF field.
	USB_HOST_INTFLAG_HSOF_Msk    = 0x4   // Bit mask of HSOF field.
	USB_HOST_INTFLAG_HSOF        = 0x4   // Bit HSOF.
	USB_HOST_INTFLAG_RST_Pos     = 0x3   // Position of RST field.
	USB_HOST_INTFLAG_RST_Msk     = 0x8   // Bit mask of RST field.
	USB_HOST_INTFLAG_RST         = 0x8   // Bit RST.
	USB_HOST_INTFLAG_WAKEUP_Pos  = 0x4   // Position of WAKEUP field.
	USB_HOST_INTFLAG_WAKEUP_Msk  = 0x10  // Bit mask of WAKEUP field.
	USB_HOST_INTFLAG_WAKEUP      = 0x10  // Bit WAKEUP.
	USB_HOST_INTFLAG_DNRSM_Pos   = 0x5   // Position of DNRSM field.
	USB_HOST_INTFLAG_DNRSM_Msk   = 0x20  // Bit mask of DNRSM field.
	USB_HOST_INTFLAG_DNRSM       = 0x20  // Bit DNRSM.
	USB_HOST_INTFLAG_UPRSM_Pos   = 0x6   // Position of UPRSM field.
	USB_HOST_INTFLAG_UPRSM_Msk   = 0x40  // Bit mask of UPRSM field.
	USB_HOST_INTFLAG_UPRSM       = 0x40  // Bit UPRSM.
	USB_HOST_INTFLAG_RAMACER_Pos = 0x7   // Position of RAMACER field.
	USB_HOST_INTFLAG_RAMACER_Msk = 0x80  // Bit mask of RAMACER field.
	USB_HOST_INTFLAG_RAMACER     = 0x80  // Bit RAMACER.
	USB_HOST_INTFLAG_DCONN_Pos   = 0x8   // Position of DCONN field.
	USB_HOST_INTFLAG_DCONN_Msk   = 0x100 // Bit mask of DCONN field.
	USB_HOST_INTFLAG_DCONN       = 0x100 // Bit DCONN.
	USB_HOST_INTFLAG_DDISC_Pos   = 0x9   // Position of DDISC field.
	USB_HOST_INTFLAG_DDISC_Msk   = 0x200 // Bit mask of DDISC field.
	USB_HOST_INTFLAG_DDISC       = 0x200 // Bit DDISC.

	// PINTSMRY: HOST Pipe Interrupt Summary
	USB_HOST_PINTSMRY_EPINT0_Pos = 0x0  // Position of EPINT0 field.
	USB_HOST_PINTSMRY_EPINT0_Msk = 0x1  // Bit mask of EPINT0 field.
	USB_HOST_PINTSMRY_EPINT0     = 0x1  // Bit EPINT0.
	USB_HOST_PINTSMRY_EPINT1_Pos = 0x1  // Position of EPINT1 field.
	USB_HOST_PINTSMRY_EPINT1_Msk = 0x2  // Bit mask of EPINT1 field.
	USB_HOST_PINTSMRY_EPINT1     = 0x2  // Bit EPINT1.
	USB_HOST_PINTSMRY_EPINT2_Pos = 0x2  // Position of EPINT2 field.
	USB_HOST_PINTSMRY_EPINT2_Msk = 0x4  // Bit mask of EPINT2 field.
	USB_HOST_PINTSMRY_EPINT2     = 0x4  // Bit EPINT2.
	USB_HOST_PINTSMRY_EPINT3_Pos = 0x3  // Position of EPINT3 field.
	USB_HOST_PINTSMRY_EPINT3_Msk = 0x8  // Bit mask of EPINT3 field.
	USB_HOST_PINTSMRY_EPINT3     = 0x8  // Bit EPINT3.
	USB_HOST_PINTSMRY_EPINT4_Pos = 0x4  // Position of EPINT4 field.
	USB_HOST_PINTSMRY_EPINT4_Msk = 0x10 // Bit mask of EPINT4 field.
	USB_HOST_PINTSMRY_EPINT4     = 0x10 // Bit EPINT4.
	USB_HOST_PINTSMRY_EPINT5_Pos = 0x5  // Position of EPINT5 field.
	USB_HOST_PINTSMRY_EPINT5_Msk = 0x20 // Bit mask of EPINT5 field.
	USB_HOST_PINTSMRY_EPINT5     = 0x20 // Bit EPINT5.
	USB_HOST_PINTSMRY_EPINT6_Pos = 0x6  // Position of EPINT6 field.
	USB_HOST_PINTSMRY_EPINT6_Msk = 0x40 // Bit mask of EPINT6 field.
	USB_HOST_PINTSMRY_EPINT6     = 0x40 // Bit EPINT6.
	USB_HOST_PINTSMRY_EPINT7_Pos = 0x7  // Position of EPINT7 field.
	USB_HOST_PINTSMRY_EPINT7_Msk = 0x80 // Bit mask of EPINT7 field.
	USB_HOST_PINTSMRY_EPINT7     = 0x80 // Bit EPINT7.

	// DESCADD: Descriptor Address
	USB_HOST_DESCADD_DESCADD_Pos = 0x0        // Position of DESCADD field.
	USB_HOST_DESCADD_DESCADD_Msk = 0xffffffff // Bit mask of DESCADD field.

	// PADCAL: USB PAD Calibration
	USB_HOST_PADCAL_TRANSP_Pos = 0x0    // Position of TRANSP field.
	USB_HOST_PADCAL_TRANSP_Msk = 0x1f   // Bit mask of TRANSP field.
	USB_HOST_PADCAL_TRANSN_Pos = 0x6    // Position of TRANSN field.
	USB_HOST_PADCAL_TRANSN_Msk = 0x7c0  // Bit mask of TRANSN field.
	USB_HOST_PADCAL_TRIM_Pos   = 0xc    // Position of TRIM field.
	USB_HOST_PADCAL_TRIM_Msk   = 0x7000 // Bit mask of TRIM field.

	// PCFG0: HOST End Point Configuration
	USB_HOST_PCFG_PTOKEN_Pos = 0x0  // Position of PTOKEN field.
	USB_HOST_PCFG_PTOKEN_Msk = 0x3  // Bit mask of PTOKEN field.
	USB_HOST_PCFG_BK_Pos     = 0x2  // Position of BK field.
	USB_HOST_PCFG_BK_Msk     = 0x4  // Bit mask of BK field.
	USB_HOST_PCFG_BK         = 0x4  // Bit BK.
	USB_HOST_PCFG_PTYPE_Pos  = 0x3  // Position of PTYPE field.
	USB_HOST_PCFG_PTYPE_Msk  = 0x38 // Bit mask of PTYPE field.

	// BINTERVAL0: HOST Bus Access Period of Pipe
	USB_HOST_BINTERVAL_BITINTERVAL_Pos = 0x0  // Position of BITINTERVAL field.
	USB_HOST_BINTERVAL_BITINTERVAL_Msk = 0xff // Bit mask of BITINTERVAL field.

	// PSTATUSCLR0: HOST End Point Pipe Status Clear
	USB_HOST_PSTATUSCLR_DTGL_Pos    = 0x0  // Position of DTGL field.
	USB_HOST_PSTATUSCLR_DTGL_Msk    = 0x1  // Bit mask of DTGL field.
	USB_HOST_PSTATUSCLR_DTGL        = 0x1  // Bit DTGL.
	USB_HOST_PSTATUSCLR_CURBK_Pos   = 0x2  // Position of CURBK field.
	USB_HOST_PSTATUSCLR_CURBK_Msk   = 0x4  // Bit mask of CURBK field.
	USB_HOST_PSTATUSCLR_CURBK       = 0x4  // Bit CURBK.
	USB_HOST_PSTATUSCLR_PFREEZE_Pos = 0x4  // Position of PFREEZE field.
	USB_HOST_PSTATUSCLR_PFREEZE_Msk = 0x10 // Bit mask of PFREEZE field.
	USB_HOST_PSTATUSCLR_PFREEZE     = 0x10 // Bit PFREEZE.
	USB_HOST_PSTATUSCLR_BK0RDY_Pos  = 0x6  // Position of BK0RDY field.
	USB_HOST_PSTATUSCLR_BK0RDY_Msk  = 0x40 // Bit mask of BK0RDY field.
	USB_HOST_PSTATUSCLR_BK0RDY      = 0x40 // Bit BK0RDY.
	USB_HOST_PSTATUSCLR_BK1RDY_Pos  = 0x7  // Position of BK1RDY field.
	USB_HOST_PSTATUSCLR_BK1RDY_Msk  = 0x80 // Bit mask of BK1RDY field.
	USB_HOST_PSTATUSCLR_BK1RDY      = 0x80 // Bit BK1RDY.

	// PSTATUSSET0: HOST End Point Pipe Status Set
	USB_HOST_PSTATUSSET_DTGL_Pos    = 0x0  // Position of DTGL field.
	USB_HOST_PSTATUSSET_DTGL_Msk    = 0x1  // Bit mask of DTGL field.
	USB_HOST_PSTATUSSET_DTGL        = 0x1  // Bit DTGL.
	USB_HOST_PSTATUSSET_CURBK_Pos   = 0x2  // Position of CURBK field.
	USB_HOST_PSTATUSSET_CURBK_Msk   = 0x4  // Bit mask of CURBK field.
	USB_HOST_PSTATUSSET_CURBK       = 0x4  // Bit CURBK.
	USB_HOST_PSTATUSSET_PFREEZE_Pos = 0x4  // Position of PFREEZE field.
	USB_HOST_PSTATUSSET_PFREEZE_Msk = 0x10 // Bit mask of PFREEZE field.
	USB_HOST_PSTATUSSET_PFREEZE     = 0x10 // Bit PFREEZE.
	USB_HOST_PSTATUSSET_BK0RDY_Pos  = 0x6  // Position of BK0RDY field.
	USB_HOST_PSTATUSSET_BK0RDY_Msk  = 0x40 // Bit mask of BK0RDY field.
	USB_HOST_PSTATUSSET_BK0RDY      = 0x40 // Bit BK0RDY.
	USB_HOST_PSTATUSSET_BK1RDY_Pos  = 0x7  // Position of BK1RDY field.
	USB_HOST_PSTATUSSET_BK1RDY_Msk  = 0x80 // Bit mask of BK1RDY field.
	USB_HOST_PSTATUSSET_BK1RDY      = 0x80 // Bit BK1RDY.

	// PSTATUS0: HOST End Point Pipe Status
	USB_HOST_PSTATUS_DTGL_Pos    = 0x0  // Position of DTGL field.
	USB_HOST_PSTATUS_DTGL_Msk    = 0x1  // Bit mask of DTGL field.
	USB_HOST_PSTATUS_DTGL        = 0x1  // Bit DTGL.
	USB_HOST_PSTATUS_CURBK_Pos   = 0x2  // Position of CURBK field.
	USB_HOST_PSTATUS_CURBK_Msk   = 0x4  // Bit mask of CURBK field.
	USB_HOST_PSTATUS_CURBK       = 0x4  // Bit CURBK.
	USB_HOST_PSTATUS_PFREEZE_Pos = 0x4  // Position of PFREEZE field.
	USB_HOST_PSTATUS_PFREEZE_Msk = 0x10 // Bit mask of PFREEZE field.
	USB_HOST_PSTATUS_PFREEZE     = 0x10 // Bit PFREEZE.
	USB_HOST_PSTATUS_BK0RDY_Pos  = 0x6  // Position of BK0RDY field.
	USB_HOST_PSTATUS_BK0RDY_Msk  = 0x40 // Bit mask of BK0RDY field.
	USB_HOST_PSTATUS_BK0RDY      = 0x40 // Bit BK0RDY.
	USB_HOST_PSTATUS_BK1RDY_Pos  = 0x7  // Position of BK1RDY field.
	USB_HOST_PSTATUS_BK1RDY_Msk  = 0x80 // Bit mask of BK1RDY field.
	USB_HOST_PSTATUS_BK1RDY      = 0x80 // Bit BK1RDY.

	// PINTFLAG0: HOST Pipe Interrupt Flag
	USB_HOST_PINTFLAG_TRCPT0_Pos = 0x0  // Position of TRCPT0 field.
	USB_HOST_PINTFLAG_TRCPT0_Msk = 0x1  // Bit mask of TRCPT0 field.
	USB_HOST_PINTFLAG_TRCPT0     = 0x1  // Bit TRCPT0.
	USB_HOST_PINTFLAG_TRCPT1_Pos = 0x1  // Position of TRCPT1 field.
	USB_HOST_PINTFLAG_TRCPT1_Msk = 0x2  // Bit mask of TRCPT1 field.
	USB_HOST_PINTFLAG_TRCPT1     = 0x2  // Bit TRCPT1.
	USB_HOST_PINTFLAG_TRFAIL_Pos = 0x2  // Position of TRFAIL field.
	USB_HOST_PINTFLAG_TRFAIL_Msk = 0x4  // Bit mask of TRFAIL field.
	USB_HOST_PINTFLAG_TRFAIL     = 0x4  // Bit TRFAIL.
	USB_HOST_PINTFLAG_PERR_Pos   = 0x3  // Position of PERR field.
	USB_HOST_PINTFLAG_PERR_Msk   = 0x8  // Bit mask of PERR field.
	USB_HOST_PINTFLAG_PERR       = 0x8  // Bit PERR.
	USB_HOST_PINTFLAG_TXSTP_Pos  = 0x4  // Position of TXSTP field.
	USB_HOST_PINTFLAG_TXSTP_Msk  = 0x10 // Bit mask of TXSTP field.
	USB_HOST_PINTFLAG_TXSTP      = 0x10 // Bit TXSTP.
	USB_HOST_PINTFLAG_STALL_Pos  = 0x5  // Position of STALL field.
	USB_HOST_PINTFLAG_STALL_Msk  = 0x20 // Bit mask of STALL field.
	USB_HOST_PINTFLAG_STALL      = 0x20 // Bit STALL.

	// PINTENCLR0: HOST Pipe Interrupt Flag Clear
	USB_HOST_PINTENCLR_TRCPT0_Pos = 0x0  // Position of TRCPT0 field.
	USB_HOST_PINTENCLR_TRCPT0_Msk = 0x1  // Bit mask of TRCPT0 field.
	USB_HOST_PINTENCLR_TRCPT0     = 0x1  // Bit TRCPT0.
	USB_HOST_PINTENCLR_TRCPT1_Pos = 0x1  // Position of TRCPT1 field.
	USB_HOST_PINTENCLR_TRCPT1_Msk = 0x2  // Bit mask of TRCPT1 field.
	USB_HOST_PINTENCLR_TRCPT1     = 0x2  // Bit TRCPT1.
	USB_HOST_PINTENCLR_TRFAIL_Pos = 0x2  // Position of TRFAIL field.
	USB_HOST_PINTENCLR_TRFAIL_Msk = 0x4  // Bit mask of TRFAIL field.
	USB_HOST_PINTENCLR_TRFAIL     = 0x4  // Bit TRFAIL.
	USB_HOST_PINTENCLR_PERR_Pos   = 0x3  // Position of PERR field.
	USB_HOST_PINTENCLR_PERR_Msk   = 0x8  // Bit mask of PERR field.
	USB_HOST_PINTENCLR_PERR       = 0x8  // Bit PERR.
	USB_HOST_PINTENCLR_TXSTP_Pos  = 0x4  // Position of TXSTP field.
	USB_HOST_PINTENCLR_TXSTP_Msk  = 0x10 // Bit mask of TXSTP field.
	USB_HOST_PINTENCLR_TXSTP      = 0x10 // Bit TXSTP.
	USB_HOST_PINTENCLR_STALL_Pos  = 0x5  // Position of STALL field.
	USB_HOST_PINTENCLR_STALL_Msk  = 0x20 // Bit mask of STALL field.
	USB_HOST_PINTENCLR_STALL      = 0x20 // Bit STALL.

	// PINTENSET0: HOST Pipe Interrupt Flag Set
	USB_HOST_PINTENSET_TRCPT0_Pos = 0x0  // Position of TRCPT0 field.
	USB_HOST_PINTENSET_TRCPT0_Msk = 0x1  // Bit mask of TRCPT0 field.
	USB_HOST_PINTENSET_TRCPT0     = 0x1  // Bit TRCPT0.
	USB_HOST_PINTENSET_TRCPT1_Pos = 0x1  // Position of TRCPT1 field.
	USB_HOST_PINTENSET_TRCPT1_Msk = 0x2  // Bit mask of TRCPT1 field.
	USB_HOST_PINTENSET_TRCPT1     = 0x2  // Bit TRCPT1.
	USB_HOST_PINTENSET_TRFAIL_Pos = 0x2  // Position of TRFAIL field.
	USB_HOST_PINTENSET_TRFAIL_Msk = 0x4  // Bit mask of TRFAIL field.
	USB_HOST_PINTENSET_TRFAIL     = 0x4  // Bit TRFAIL.
	USB_HOST_PINTENSET_PERR_Pos   = 0x3  // Position of PERR field.
	USB_HOST_PINTENSET_PERR_Msk   = 0x8  // Bit mask of PERR field.
	USB_HOST_PINTENSET_PERR       = 0x8  // Bit PERR.
	USB_HOST_PINTENSET_TXSTP_Pos  = 0x4  // Position of TXSTP field.
	USB_HOST_PINTENSET_TXSTP_Msk  = 0x10 // Bit mask of TXSTP field.
	USB_HOST_PINTENSET_TXSTP      = 0x10 // Bit TXSTP.
	USB_HOST_PINTENSET_STALL_Pos  = 0x5  // Position of STALL field.
	USB_HOST_PINTENSET_STALL_Msk  = 0x20 // Bit mask of STALL field.
	USB_HOST_PINTENSET_STALL      = 0x20 // Bit STALL.
)

// Bitfields for WDT: Watchdog Timer
const (
	// CTRL: Control
	WDT_CTRL_ENABLE_Pos   = 0x1  // Position of ENABLE field.
	WDT_CTRL_ENABLE_Msk   = 0x2  // Bit mask of ENABLE field.
	WDT_CTRL_ENABLE       = 0x2  // Bit ENABLE.
	WDT_CTRL_WEN_Pos      = 0x2  // Position of WEN field.
	WDT_CTRL_WEN_Msk      = 0x4  // Bit mask of WEN field.
	WDT_CTRL_WEN          = 0x4  // Bit WEN.
	WDT_CTRL_ALWAYSON_Pos = 0x7  // Position of ALWAYSON field.
	WDT_CTRL_ALWAYSON_Msk = 0x80 // Bit mask of ALWAYSON field.
	WDT_CTRL_ALWAYSON     = 0x80 // Bit ALWAYSON.

	// CONFIG: Configuration
	WDT_CONFIG_PER_Pos    = 0x0  // Position of PER field.
	WDT_CONFIG_PER_Msk    = 0xf  // Bit mask of PER field.
	WDT_CONFIG_PER_8      = 0x0  // 8 clock cycles
	WDT_CONFIG_PER_16     = 0x1  // 16 clock cycles
	WDT_CONFIG_PER_32     = 0x2  // 32 clock cycles
	WDT_CONFIG_PER_64     = 0x3  // 64 clock cycles
	WDT_CONFIG_PER_128    = 0x4  // 128 clock cycles
	WDT_CONFIG_PER_256    = 0x5  // 256 clock cycles
	WDT_CONFIG_PER_512    = 0x6  // 512 clock cycles
	WDT_CONFIG_PER_1K     = 0x7  // 1024 clock cycles
	WDT_CONFIG_PER_2K     = 0x8  // 2048 clock cycles
	WDT_CONFIG_PER_4K     = 0x9  // 4096 clock cycles
	WDT_CONFIG_PER_8K     = 0xa  // 8192 clock cycles
	WDT_CONFIG_PER_16K    = 0xb  // 16384 clock cycles
	WDT_CONFIG_WINDOW_Pos = 0x4  // Position of WINDOW field.
	WDT_CONFIG_WINDOW_Msk = 0xf0 // Bit mask of WINDOW field.
	WDT_CONFIG_WINDOW_8   = 0x0  // 8 clock cycles
	WDT_CONFIG_WINDOW_16  = 0x1  // 16 clock cycles
	WDT_CONFIG_WINDOW_32  = 0x2  // 32 clock cycles
	WDT_CONFIG_WINDOW_64  = 0x3  // 64 clock cycles
	WDT_CONFIG_WINDOW_128 = 0x4  // 128 clock cycles
	WDT_CONFIG_WINDOW_256 = 0x5  // 256 clock cycles
	WDT_CONFIG_WINDOW_512 = 0x6  // 512 clock cycles
	WDT_CONFIG_WINDOW_1K  = 0x7  // 1024 clock cycles
	WDT_CONFIG_WINDOW_2K  = 0x8  // 2048 clock cycles
	WDT_CONFIG_WINDOW_4K  = 0x9  // 4096 clock cycles
	WDT_CONFIG_WINDOW_8K  = 0xa  // 8192 clock cycles
	WDT_CONFIG_WINDOW_16K = 0xb  // 16384 clock cycles

	// EWCTRL: Early Warning Interrupt Control
	WDT_EWCTRL_EWOFFSET_Pos = 0x0 // Position of EWOFFSET field.
	WDT_EWCTRL_EWOFFSET_Msk = 0xf // Bit mask of EWOFFSET field.
	WDT_EWCTRL_EWOFFSET_8   = 0x0 // 8 clock cycles
	WDT_EWCTRL_EWOFFSET_16  = 0x1 // 16 clock cycles
	WDT_EWCTRL_EWOFFSET_32  = 0x2 // 32 clock cycles
	WDT_EWCTRL_EWOFFSET_64  = 0x3 // 64 clock cycles
	WDT_EWCTRL_EWOFFSET_128 = 0x4 // 128 clock cycles
	WDT_EWCTRL_EWOFFSET_256 = 0x5 // 256 clock cycles
	WDT_EWCTRL_EWOFFSET_512 = 0x6 // 512 clock cycles
	WDT_EWCTRL_EWOFFSET_1K  = 0x7 // 1024 clock cycles
	WDT_EWCTRL_EWOFFSET_2K  = 0x8 // 2048 clock cycles
	WDT_EWCTRL_EWOFFSET_4K  = 0x9 // 4096 clock cycles
	WDT_EWCTRL_EWOFFSET_8K  = 0xa // 8192 clock cycles
	WDT_EWCTRL_EWOFFSET_16K = 0xb // 16384 clock cycles

	// INTENCLR: Interrupt Enable Clear
	WDT_INTENCLR_EW_Pos = 0x0 // Position of EW field.
	WDT_INTENCLR_EW_Msk = 0x1 // Bit mask of EW field.
	WDT_INTENCLR_EW     = 0x1 // Bit EW.

	// INTENSET: Interrupt Enable Set
	WDT_INTENSET_EW_Pos = 0x0 // Position of EW field.
	WDT_INTENSET_EW_Msk = 0x1 // Bit mask of EW field.
	WDT_INTENSET_EW     = 0x1 // Bit EW.

	// INTFLAG: Interrupt Flag Status and Clear
	WDT_INTFLAG_EW_Pos = 0x0 // Position of EW field.
	WDT_INTFLAG_EW_Msk = 0x1 // Bit mask of EW field.
	WDT_INTFLAG_EW     = 0x1 // Bit EW.

	// STATUS: Status
	WDT_STATUS_SYNCBUSY_Pos = 0x7  // Position of SYNCBUSY field.
	WDT_STATUS_SYNCBUSY_Msk = 0x80 // Bit mask of SYNCBUSY field.
	WDT_STATUS_SYNCBUSY     = 0x80 // Bit SYNCBUSY.

	// CLEAR: Clear
	WDT_CLEAR_CLEAR_Pos = 0x0  // Position of CLEAR field.
	WDT_CLEAR_CLEAR_Msk = 0xff // Bit mask of CLEAR field.
	WDT_CLEAR_CLEAR_KEY = 0xa5 // Clear Key
)
