/*
 * Decompiled with CFR 0.152.
 */
package com.concurrent_ruby.ext;

import java.io.IOException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaSemaphoreLibrary {
    private static final ObjectAllocator JRUBYREFERENCE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new JavaSemaphore(ruby, rubyClass);
        }
    };

    public void load(Ruby ruby, boolean bl) throws IOException {
        RubyModule rubyModule = ruby.defineModule("Concurrent");
        RubyClass rubyClass = rubyModule.defineClassUnder("JavaSemaphore", ruby.getObject(), JRUBYREFERENCE_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(JavaSemaphore.class);
    }

    @JRubyClass(name={"JavaSemaphore"}, parent="Object")
    public static class JavaSemaphore
    extends RubyObject {
        private JRubySemaphore semaphore;

        public JavaSemaphore(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        @JRubyMethod
        public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject) {
            this.semaphore = new JRubySemaphore(this.rubyFixnumInt(iRubyObject, "count"));
            return threadContext.nil;
        }

        @JRubyMethod
        public IRubyObject acquire(ThreadContext threadContext, IRubyObject iRubyObject) throws InterruptedException {
            this.semaphore.acquire(this.rubyFixnumToPositiveInt(iRubyObject, "permits"));
            return threadContext.nil;
        }

        @JRubyMethod(name={"available_permits"})
        public IRubyObject availablePermits(ThreadContext threadContext) {
            return this.getRuntime().newFixnum(this.semaphore.availablePermits());
        }

        @JRubyMethod(name={"drain_permits"})
        public IRubyObject drainPermits(ThreadContext threadContext) {
            return this.getRuntime().newFixnum(this.semaphore.drainPermits());
        }

        @JRubyMethod
        public IRubyObject acquire(ThreadContext threadContext) throws InterruptedException {
            this.semaphore.acquire(1);
            return threadContext.nil;
        }

        @JRubyMethod(name={"try_acquire"})
        public IRubyObject tryAcquire(ThreadContext threadContext) throws InterruptedException {
            return this.getRuntime().newBoolean(this.semaphore.tryAcquire(1));
        }

        @JRubyMethod(name={"try_acquire"})
        public IRubyObject tryAcquire(ThreadContext threadContext, IRubyObject iRubyObject) throws InterruptedException {
            return this.getRuntime().newBoolean(this.semaphore.tryAcquire(this.rubyFixnumToPositiveInt(iRubyObject, "permits")));
        }

        @JRubyMethod(name={"try_acquire"})
        public IRubyObject tryAcquire(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) throws InterruptedException {
            return this.getRuntime().newBoolean(this.semaphore.tryAcquire(this.rubyFixnumToPositiveInt(iRubyObject, "permits"), this.rubyNumericToLong(iRubyObject2, "timeout"), TimeUnit.SECONDS));
        }

        @JRubyMethod
        public IRubyObject release(ThreadContext threadContext) {
            this.semaphore.release(1);
            return this.getRuntime().newBoolean(true);
        }

        @JRubyMethod
        public IRubyObject release(ThreadContext threadContext, IRubyObject iRubyObject) {
            this.semaphore.release(this.rubyFixnumToPositiveInt(iRubyObject, "permits"));
            return this.getRuntime().newBoolean(true);
        }

        @JRubyMethod(name={"reduce_permits"})
        public IRubyObject reducePermits(ThreadContext threadContext, IRubyObject iRubyObject) throws InterruptedException {
            this.semaphore.publicReducePermits(this.rubyFixnumToNonNegativeInt(iRubyObject, "reduction"));
            return threadContext.nil;
        }

        private int rubyFixnumInt(IRubyObject iRubyObject, String string) {
            if (iRubyObject instanceof RubyFixnum) {
                RubyFixnum rubyFixnum = (RubyFixnum)iRubyObject;
                return (int)rubyFixnum.getLongValue();
            }
            throw this.getRuntime().newArgumentError(string + " must be integer");
        }

        private int rubyFixnumToNonNegativeInt(IRubyObject iRubyObject, String string) {
            if (iRubyObject instanceof RubyFixnum && ((RubyFixnum)iRubyObject).getLongValue() >= 0L) {
                RubyFixnum rubyFixnum = (RubyFixnum)iRubyObject;
                return (int)rubyFixnum.getLongValue();
            }
            throw this.getRuntime().newArgumentError(string + " must be a non-negative integer");
        }

        private int rubyFixnumToPositiveInt(IRubyObject iRubyObject, String string) {
            if (iRubyObject instanceof RubyFixnum && ((RubyFixnum)iRubyObject).getLongValue() > 0L) {
                RubyFixnum rubyFixnum = (RubyFixnum)iRubyObject;
                return (int)rubyFixnum.getLongValue();
            }
            throw this.getRuntime().newArgumentError(string + " must be an integer greater than zero");
        }

        private long rubyNumericToLong(IRubyObject iRubyObject, String string) {
            if (iRubyObject instanceof RubyNumeric && ((RubyNumeric)iRubyObject).getDoubleValue() > 0.0) {
                RubyNumeric rubyNumeric = (RubyNumeric)iRubyObject;
                return rubyNumeric.getLongValue();
            }
            throw this.getRuntime().newArgumentError(string + " must be a float greater than zero");
        }

        class JRubySemaphore
        extends Semaphore {
            public JRubySemaphore(int n) {
                super(n);
            }

            public JRubySemaphore(int n, boolean bl) {
                super(n, bl);
            }

            public void publicReducePermits(int n) {
                this.reducePermits(n);
            }
        }
    }
}

