/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

public class LongMap<V> {
    private static final float LOAD_FACTOR = 0.75f;
    private Node<V>[] table = LongMap.createArray(64);
    private int size;
    private int growAt = (int)((float)this.table.length * 0.75f);

    public boolean containsKey(long key2) {
        return this.get(key2) != null;
    }

    public V get(long key2) {
        Node<V> n = this.table[this.index(key2)];
        while (n != null) {
            if (n.key == key2) {
                return n.value;
            }
            n = n.next;
        }
        return null;
    }

    public V remove(long key2) {
        Node<V> n = this.table[this.index(key2)];
        Node<V> prior = null;
        while (n != null) {
            if (n.key == key2) {
                if (prior == null) {
                    this.table[this.index((long)key2)] = n.next;
                } else {
                    prior.next = n.next;
                }
                --this.size;
                return n.value;
            }
            prior = n;
            n = n.next;
        }
        return null;
    }

    public V put(long key2, V value) {
        Node<V> n = this.table[this.index(key2)];
        while (n != null) {
            if (n.key == key2) {
                Object o = n.value;
                n.value = value;
                return o;
            }
            n = n.next;
        }
        if (++this.size == this.growAt) {
            this.grow();
        }
        this.insert(new Node<V>(key2, value));
        return null;
    }

    private void insert(Node<V> n) {
        int idx = this.index(n.key);
        n.next = this.table[idx];
        this.table[idx] = n;
    }

    private void grow() {
        Node<V>[] oldTable = this.table;
        int oldSize = this.table.length;
        this.table = LongMap.createArray(oldSize << 1);
        this.growAt = (int)((float)this.table.length * 0.75f);
        for (int i = 0; i < oldSize; ++i) {
            Node<V> e2 = oldTable[i];
            while (e2 != null) {
                Node n = e2.next;
                this.insert(e2);
                e2 = n;
            }
        }
    }

    private final int index(long key2) {
        int h2 = (int)key2 >>> 1;
        h2 ^= h2 >>> 20 ^ h2 >>> 12;
        return h2 & this.table.length - 1;
    }

    private static final <V> Node<V>[] createArray(int sz) {
        return new Node[sz];
    }

    private static class Node<V> {
        final long key;
        V value;
        Node<V> next;

        Node(long k, V v) {
            this.key = k;
            this.value = v;
        }
    }
}

