/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.RuntimeCryptoException;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.agreement.srp.SRP6Client;
import org.bouncycastle.crypto.agreement.srp.SRP6Server;
import org.bouncycastle.crypto.agreement.srp.SRP6VerifierGenerator;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.NullDigest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.ARIAEngine;
import org.bouncycastle.crypto.engines.CamelliaEngine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.engines.SEEDEngine;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CCMBlockCipher;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.SRP6GroupParameters;
import org.bouncycastle.crypto.prng.DigestRandomGenerator;
import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsDHDomain;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsECDomain;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.tls.crypto.TlsNonceGenerator;
import org.bouncycastle.tls.crypto.TlsSRP6Client;
import org.bouncycastle.tls.crypto.TlsSRP6Server;
import org.bouncycastle.tls.crypto.TlsSRP6VerifierGenerator;
import org.bouncycastle.tls.crypto.TlsSRPConfig;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipher;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipher;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsEncryptor;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsNullCipher;
import org.bouncycastle.tls.crypto.impl.bc.BcChaCha20Poly1305;
import org.bouncycastle.tls.crypto.impl.bc.BcSSL3HMAC;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsDHDomain;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsECDomain;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.BcX25519Domain;
import org.bouncycastle.tls.crypto.impl.bc.BcX448Domain;
import org.bouncycastle.util.Arrays;

public class BcTlsCrypto
extends AbstractTlsCrypto {
    private final SecureRandom entropySource;

    public BcTlsCrypto(SecureRandom secureRandom) {
        this.entropySource = secureRandom;
    }

    BcTlsSecret adoptLocalSecret(byte[] byArray) {
        return new BcTlsSecret(this, byArray);
    }

    public SecureRandom getSecureRandom() {
        return this.entropySource;
    }

    public TlsCertificate createCertificate(byte[] byArray) throws IOException {
        return new BcTlsCertificate(this, byArray);
    }

    protected TlsCipher createCipher(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException {
        switch (n) {
            case 7: {
                return this.createDESedeCipher(tlsCryptoParameters, n2);
            }
            case 8: {
                return this.createAESCipher(tlsCryptoParameters, 16, n2);
            }
            case 15: {
                return this.createCipher_AES_CCM(tlsCryptoParameters, 16, 16);
            }
            case 16: {
                return this.createCipher_AES_CCM(tlsCryptoParameters, 16, 8);
            }
            case 10: {
                return this.createCipher_AES_GCM(tlsCryptoParameters, 16, 16);
            }
            case 9: {
                return this.createAESCipher(tlsCryptoParameters, 32, n2);
            }
            case 17: {
                return this.createCipher_AES_CCM(tlsCryptoParameters, 32, 16);
            }
            case 18: {
                return this.createCipher_AES_CCM(tlsCryptoParameters, 32, 8);
            }
            case 11: {
                return this.createCipher_AES_GCM(tlsCryptoParameters, 32, 16);
            }
            case 22: {
                return this.createARIACipher(tlsCryptoParameters, 16, n2);
            }
            case 24: {
                return this.createCipher_ARIA_GCM(tlsCryptoParameters, 16, 16);
            }
            case 23: {
                return this.createARIACipher(tlsCryptoParameters, 32, n2);
            }
            case 25: {
                return this.createCipher_ARIA_GCM(tlsCryptoParameters, 32, 16);
            }
            case 12: {
                return this.createCamelliaCipher(tlsCryptoParameters, 16, n2);
            }
            case 19: {
                return this.createCipher_Camellia_GCM(tlsCryptoParameters, 16, 16);
            }
            case 13: {
                return this.createCamelliaCipher(tlsCryptoParameters, 32, n2);
            }
            case 20: {
                return this.createCipher_Camellia_GCM(tlsCryptoParameters, 32, 16);
            }
            case 21: {
                return this.createChaCha20Poly1305(tlsCryptoParameters);
            }
            case 0: {
                return this.createNullCipher(tlsCryptoParameters, n2);
            }
            case 14: {
                return this.createSEEDCipher(tlsCryptoParameters, n2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsDHDomain createDHDomain(TlsDHConfig tlsDHConfig) {
        return new BcTlsDHDomain(this, tlsDHConfig);
    }

    public TlsECDomain createECDomain(TlsECConfig tlsECConfig) {
        switch (tlsECConfig.getNamedGroup()) {
            case 29: {
                return new BcX25519Domain(this);
            }
            case 30: {
                return new BcX448Domain(this);
            }
        }
        return new BcTlsECDomain(this, tlsECConfig);
    }

    protected TlsEncryptor createEncryptor(TlsCertificate tlsCertificate) throws IOException {
        BcTlsCertificate bcTlsCertificate = BcTlsCertificate.convert(this, tlsCertificate);
        bcTlsCertificate.validateKeyUsage(32);
        final RSAKeyParameters rSAKeyParameters = bcTlsCertificate.getPubKeyRSA();
        return new TlsEncryptor(){

            public byte[] encrypt(byte[] byArray, int n, int n2) throws IOException {
                try {
                    PKCS1Encoding pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine());
                    pKCS1Encoding.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)rSAKeyParameters, BcTlsCrypto.this.getSecureRandom()));
                    return pKCS1Encoding.processBlock(byArray, n, n2);
                }
                catch (InvalidCipherTextException invalidCipherTextException) {
                    throw new TlsFatalAlert(80, (Throwable)invalidCipherTextException);
                }
            }
        };
    }

    public TlsNonceGenerator createNonceGenerator(byte[] byArray) {
        final DigestRandomGenerator digestRandomGenerator = new DigestRandomGenerator(this.createDigest((short)4));
        if (byArray != null && byArray.length > 0) {
            digestRandomGenerator.addSeedMaterial(byArray);
        }
        byte[] byArray2 = new byte[this.createDigest((short)4).getDigestSize()];
        this.entropySource.nextBytes(byArray2);
        digestRandomGenerator.addSeedMaterial(byArray2);
        return new TlsNonceGenerator(){

            public byte[] generateNonce(int n) {
                byte[] byArray = new byte[n];
                digestRandomGenerator.nextBytes(byArray);
                return byArray;
            }
        };
    }

    public boolean hasAllRawSignatureAlgorithms() {
        return !this.hasSignatureAlgorithm((short)7) && !this.hasSignatureAlgorithm((short)8);
    }

    public boolean hasDHAgreement() {
        return true;
    }

    public boolean hasECDHAgreement() {
        return true;
    }

    public boolean hasEncryptionAlgorithm(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return false;
            }
        }
        return true;
    }

    public boolean hasHashAlgorithm(short s) {
        return true;
    }

    public boolean hasMacAlgorithm(int n) {
        return true;
    }

    public boolean hasNamedGroup(int n) {
        return NamedGroup.refersToASpecificGroup(n);
    }

    public boolean hasRSAEncryption() {
        return true;
    }

    public boolean hasSignatureAlgorithm(short s) {
        switch (s) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        return this.hasSignatureAlgorithm(signatureAndHashAlgorithm.getSignature());
    }

    public boolean hasSignatureScheme(int n) {
        return this.hasSignatureAlgorithm((short)(n & 0xFF));
    }

    public boolean hasSRPAuthentication() {
        return true;
    }

    public TlsSecret createSecret(byte[] byArray) {
        return this.adoptLocalSecret(Arrays.clone((byte[])byArray));
    }

    public TlsSecret generateRSAPreMasterSecret(ProtocolVersion protocolVersion) {
        byte[] byArray = new byte[48];
        this.entropySource.nextBytes(byArray);
        TlsUtils.writeVersion(protocolVersion, byArray, 0);
        return this.adoptLocalSecret(byArray);
    }

    public Digest createDigest(short s) {
        switch (s) {
            case 0: {
                return new NullDigest();
            }
            case 1: {
                return new MD5Digest();
            }
            case 2: {
                return new SHA1Digest();
            }
            case 3: {
                return new SHA224Digest();
            }
            case 4: {
                return new SHA256Digest();
            }
            case 5: {
                return new SHA384Digest();
            }
            case 6: {
                return new SHA512Digest();
            }
        }
        throw new IllegalArgumentException("invalid HashAlgorithm: " + HashAlgorithm.getText(s));
    }

    public TlsHash createHash(short s) {
        return new BcTlsHash(s, this.createDigest(s));
    }

    public static Digest cloneDigest(short s, Digest digest) {
        switch (s) {
            case 1: {
                return new MD5Digest((MD5Digest)digest);
            }
            case 2: {
                return new SHA1Digest((SHA1Digest)digest);
            }
            case 3: {
                return new SHA224Digest((SHA224Digest)digest);
            }
            case 4: {
                return new SHA256Digest((SHA256Digest)digest);
            }
            case 5: {
                return new SHA384Digest((SHA384Digest)digest);
            }
            case 6: {
                return new SHA512Digest((SHA512Digest)digest);
            }
        }
        throw new IllegalArgumentException("invalid HashAlgorithm: " + HashAlgorithm.getText(s));
    }

    protected TlsCipher createAESCipher(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException {
        return new TlsBlockCipher(this, tlsCryptoParameters, new BlockOperator(this.createAESBlockCipher(), true), new BlockOperator(this.createAESBlockCipher(), false), this.createMAC(tlsCryptoParameters, n2), this.createMAC(tlsCryptoParameters, n2), n);
    }

    protected TlsCipher createARIACipher(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException {
        return new TlsBlockCipher(this, tlsCryptoParameters, new BlockOperator(this.createARIABlockCipher(), true), new BlockOperator(this.createARIABlockCipher(), false), this.createMAC(tlsCryptoParameters, n2), this.createMAC(tlsCryptoParameters, n2), n);
    }

    protected TlsCipher createCamelliaCipher(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException {
        return new TlsBlockCipher(this, tlsCryptoParameters, new BlockOperator(this.createCamelliaBlockCipher(), true), new BlockOperator(this.createCamelliaBlockCipher(), false), this.createMAC(tlsCryptoParameters, n2), this.createMAC(tlsCryptoParameters, n2), n);
    }

    protected TlsCipher createChaCha20Poly1305(TlsCryptoParameters tlsCryptoParameters) throws IOException {
        return new TlsAEADCipher(tlsCryptoParameters, new BcChaCha20Poly1305(true), new BcChaCha20Poly1305(false), 32, 16, 2);
    }

    protected TlsAEADCipher createCipher_AES_CCM(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException {
        return new TlsAEADCipher(tlsCryptoParameters, new AeadOperator(this.createAEADBlockCipher_AES_CCM(), true), new AeadOperator(this.createAEADBlockCipher_AES_CCM(), false), n, n2, 1);
    }

    protected TlsAEADCipher createCipher_AES_GCM(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException {
        return new TlsAEADCipher(tlsCryptoParameters, new AeadOperator(this.createAEADBlockCipher_AES_GCM(), true), new AeadOperator(this.createAEADBlockCipher_AES_GCM(), false), n, n2, 3);
    }

    protected TlsAEADCipher createCipher_ARIA_GCM(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException {
        return new TlsAEADCipher(tlsCryptoParameters, new AeadOperator(this.createAEADBlockCipher_ARIA_GCM(), true), new AeadOperator(this.createAEADBlockCipher_ARIA_GCM(), false), n, n2, 3);
    }

    protected TlsAEADCipher createCipher_Camellia_GCM(TlsCryptoParameters tlsCryptoParameters, int n, int n2) throws IOException {
        return new TlsAEADCipher(tlsCryptoParameters, new AeadOperator(this.createAEADBlockCipher_Camellia_GCM(), true), new AeadOperator(this.createAEADBlockCipher_Camellia_GCM(), false), n, n2, 3);
    }

    protected TlsBlockCipher createDESedeCipher(TlsCryptoParameters tlsCryptoParameters, int n) throws IOException {
        return new TlsBlockCipher(this, tlsCryptoParameters, new BlockOperator(this.createDESedeBlockCipher(), true), new BlockOperator(this.createDESedeBlockCipher(), false), this.createMAC(tlsCryptoParameters, n), this.createMAC(tlsCryptoParameters, n), 24);
    }

    protected TlsNullCipher createNullCipher(TlsCryptoParameters tlsCryptoParameters, int n) throws IOException {
        return new TlsNullCipher(tlsCryptoParameters, this.createMAC(tlsCryptoParameters, n), this.createMAC(tlsCryptoParameters, n));
    }

    protected TlsBlockCipher createSEEDCipher(TlsCryptoParameters tlsCryptoParameters, int n) throws IOException {
        return new TlsBlockCipher(this, tlsCryptoParameters, new BlockOperator(this.createSEEDBlockCipher(), true), new BlockOperator(this.createSEEDBlockCipher(), false), this.createMAC(tlsCryptoParameters, n), this.createMAC(tlsCryptoParameters, n), 16);
    }

    protected BlockCipher createAESEngine() {
        return new AESEngine();
    }

    protected BlockCipher createARIAEngine() {
        return new ARIAEngine();
    }

    protected BlockCipher createCamelliaEngine() {
        return new CamelliaEngine();
    }

    protected BlockCipher createAESBlockCipher() {
        return new CBCBlockCipher(this.createAESEngine());
    }

    protected BlockCipher createARIABlockCipher() {
        return new CBCBlockCipher(this.createARIAEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_CCM() {
        return new CCMBlockCipher(this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_GCM() {
        return new GCMBlockCipher(this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_ARIA_GCM() {
        return new GCMBlockCipher(this.createARIAEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_Camellia_GCM() {
        return new GCMBlockCipher(this.createCamelliaEngine());
    }

    protected BlockCipher createCamelliaBlockCipher() {
        return new CBCBlockCipher(this.createCamelliaEngine());
    }

    protected BlockCipher createDESedeBlockCipher() {
        return new CBCBlockCipher((BlockCipher)new DESedeEngine());
    }

    protected StreamCipher createRC4StreamCipher() {
        return new RC4Engine();
    }

    protected BlockCipher createSEEDBlockCipher() {
        return new CBCBlockCipher((BlockCipher)new SEEDEngine());
    }

    public TlsHMAC createHMAC(short s) {
        return new HMacOperator(this.createDigest(s));
    }

    public TlsHMAC createHMAC(int n) {
        return this.createHMAC(TlsUtils.getHashAlgorithmForHMACAlgorithm(n));
    }

    protected TlsHMAC createHMAC_SSL(int n) throws IOException {
        switch (n) {
            case 1: {
                return new BcSSL3HMAC(this.createDigest((short)1));
            }
            case 2: {
                return new BcSSL3HMAC(this.createDigest((short)2));
            }
            case 3: {
                return new BcSSL3HMAC(this.createDigest((short)4));
            }
            case 4: {
                return new BcSSL3HMAC(this.createDigest((short)5));
            }
            case 5: {
                return new BcSSL3HMAC(this.createDigest((short)6));
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsHMAC createMAC(TlsCryptoParameters tlsCryptoParameters, int n) throws IOException {
        if (TlsImplUtils.isSSL(tlsCryptoParameters)) {
            return this.createHMAC_SSL(n);
        }
        return this.createHMAC(n);
    }

    public TlsSRP6Client createSRP6Client(TlsSRPConfig tlsSRPConfig) {
        final SRP6Client sRP6Client = new SRP6Client();
        BigInteger[] bigIntegerArray = tlsSRPConfig.getExplicitNG();
        SRP6GroupParameters sRP6GroupParameters = new SRP6GroupParameters(bigIntegerArray[0], bigIntegerArray[1]);
        sRP6Client.init(sRP6GroupParameters, (Digest)new SHA1Digest(), this.getSecureRandom());
        return new TlsSRP6Client(){

            public BigInteger calculateSecret(BigInteger bigInteger) throws TlsFatalAlert {
                try {
                    return sRP6Client.calculateSecret(bigInteger);
                }
                catch (CryptoException cryptoException) {
                    throw new TlsFatalAlert(47, (Throwable)cryptoException);
                }
            }

            public BigInteger generateClientCredentials(byte[] byArray, byte[] byArray2, byte[] byArray3) {
                return sRP6Client.generateClientCredentials(byArray, byArray2, byArray3);
            }
        };
    }

    public TlsSRP6Server createSRP6Server(TlsSRPConfig tlsSRPConfig, BigInteger bigInteger) {
        final SRP6Server sRP6Server = new SRP6Server();
        BigInteger[] bigIntegerArray = tlsSRPConfig.getExplicitNG();
        SRP6GroupParameters sRP6GroupParameters = new SRP6GroupParameters(bigIntegerArray[0], bigIntegerArray[1]);
        sRP6Server.init(sRP6GroupParameters, bigInteger, (Digest)new SHA1Digest(), this.getSecureRandom());
        return new TlsSRP6Server(){

            public BigInteger generateServerCredentials() {
                return sRP6Server.generateServerCredentials();
            }

            public BigInteger calculateSecret(BigInteger bigInteger) throws IOException {
                try {
                    return sRP6Server.calculateSecret(bigInteger);
                }
                catch (CryptoException cryptoException) {
                    throw new TlsFatalAlert(47, (Throwable)cryptoException);
                }
            }
        };
    }

    public TlsSRP6VerifierGenerator createSRP6VerifierGenerator(TlsSRPConfig tlsSRPConfig) {
        BigInteger[] bigIntegerArray = tlsSRPConfig.getExplicitNG();
        final SRP6VerifierGenerator sRP6VerifierGenerator = new SRP6VerifierGenerator();
        sRP6VerifierGenerator.init(bigIntegerArray[0], bigIntegerArray[1], (Digest)new SHA1Digest());
        return new TlsSRP6VerifierGenerator(){

            public BigInteger generateVerifier(byte[] byArray, byte[] byArray2, byte[] byArray3) {
                return sRP6VerifierGenerator.generateVerifier(byArray, byArray2, byArray3);
            }
        };
    }

    public TlsSecret hkdfInit(short s) {
        return this.adoptLocalSecret(new byte[HashAlgorithm.getOutputSize(s)]);
    }

    public class AeadOperator
    implements TlsAEADCipherImpl {
        private final boolean isEncrypting;
        private final AEADBlockCipher cipher;
        private KeyParameter key;

        public AeadOperator(AEADBlockCipher aEADBlockCipher, boolean bl) {
            this.cipher = aEADBlockCipher;
            this.isEncrypting = bl;
        }

        public void setKey(byte[] byArray, int n, int n2) {
            this.key = new KeyParameter(byArray, n, n2);
        }

        public void init(byte[] byArray, int n, byte[] byArray2) {
            this.cipher.init(this.isEncrypting, (CipherParameters)new AEADParameters(this.key, n * 8, byArray, byArray2));
        }

        public int getOutputSize(int n) {
            return this.cipher.getOutputSize(n);
        }

        public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, byte[] byArray3, int n3) throws IOException {
            int n4 = this.cipher.processBytes(byArray, n, n2, byArray3, n3);
            int n5 = byArray2.length;
            if (n5 > 0) {
                if (!this.isEncrypting) {
                    throw new TlsFatalAlert(80);
                }
                n4 += this.cipher.processBytes(byArray2, 0, n5, byArray3, n3 + n4);
            }
            try {
                n4 += this.cipher.doFinal(byArray3, n3 + n4);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw new RuntimeCryptoException(invalidCipherTextException.toString());
            }
            return n4;
        }
    }

    private static class BcTlsHash
    implements TlsHash {
        private final short hashAlgorithm;
        private final Digest digest;

        BcTlsHash(short s, Digest digest) {
            this.hashAlgorithm = s;
            this.digest = digest;
        }

        public void update(byte[] byArray, int n, int n2) {
            this.digest.update(byArray, n, n2);
        }

        public byte[] calculateHash() {
            byte[] byArray = new byte[this.digest.getDigestSize()];
            this.digest.doFinal(byArray, 0);
            return byArray;
        }

        public Object clone() {
            return new BcTlsHash(this.hashAlgorithm, BcTlsCrypto.cloneDigest(this.hashAlgorithm, this.digest));
        }

        public void reset() {
            this.digest.reset();
        }
    }

    private class BlockOperator
    implements TlsBlockCipherImpl {
        private final boolean isEncrypting;
        private final BlockCipher cipher;
        private KeyParameter key;

        BlockOperator(BlockCipher blockCipher, boolean bl) {
            this.cipher = blockCipher;
            this.isEncrypting = bl;
        }

        public void setKey(byte[] byArray, int n, int n2) {
            this.key = new KeyParameter(byArray, n, n2);
            this.cipher.init(this.isEncrypting, (CipherParameters)new ParametersWithIV((CipherParameters)this.key, new byte[this.cipher.getBlockSize()]));
        }

        public void init(byte[] byArray, int n, int n2) {
            this.cipher.init(this.isEncrypting, (CipherParameters)new ParametersWithIV(null, byArray, n, n2));
        }

        public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
            int n4 = this.cipher.getBlockSize();
            for (int i = 0; i < n2; i += n4) {
                this.cipher.processBlock(byArray, n + i, byArray2, n3 + i);
            }
            return n2;
        }

        public int getBlockSize() {
            return this.cipher.getBlockSize();
        }
    }

    private class HMacOperator
    implements TlsHMAC {
        private final HMac hmac;

        HMacOperator(Digest digest) {
            this.hmac = new HMac(digest);
        }

        public void setKey(byte[] byArray, int n, int n2) {
            this.hmac.init((CipherParameters)new KeyParameter(byArray, n, n2));
        }

        public void update(byte[] byArray, int n, int n2) {
            this.hmac.update(byArray, n, n2);
        }

        public byte[] calculateMAC() {
            byte[] byArray = new byte[this.hmac.getMacSize()];
            this.hmac.doFinal(byArray, 0);
            return byArray;
        }

        public void calculateMAC(byte[] byArray, int n) {
            this.hmac.doFinal(byArray, n);
        }

        public int getInternalBlockSize() {
            return ((ExtendedDigest)this.hmac.getUnderlyingDigest()).getByteLength();
        }

        public int getMacLength() {
            return this.hmac.getMacSize();
        }

        public void reset() {
            this.hmac.reset();
        }
    }
}

