/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.tools;

import eu.hansolo.tilesfx.events.TreeNodeEvent;
import eu.hansolo.tilesfx.events.TreeNodeEventListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public class TreeNode<T> {
    private final TreeNodeEvent PARENT_CHANGED = new TreeNodeEvent(this, TreeNodeEvent.EventType.PARENT_CHANGED);
    private final TreeNodeEvent CHILDREN_CHANGED = new TreeNodeEvent(this, TreeNodeEvent.EventType.CHILDREN_CHANGED);
    private final TreeNodeEvent CHILD_ADDED = new TreeNodeEvent(this, TreeNodeEvent.EventType.CHILD_ADDED);
    private final TreeNodeEvent CHILD_REMOVED = new TreeNodeEvent(this, TreeNodeEvent.EventType.CHILD_REMOVED);
    private T item;
    private TreeNode parent;
    private TreeNode myRoot;
    private TreeNode treeRoot;
    private int depth;
    private ObservableList<TreeNode<T>> children;
    private List<TreeNodeEventListener> listeners;
    private ListChangeListener<TreeNode> childNodeListener;

    public TreeNode(T ITEM) {
        this(ITEM, null);
    }

    public TreeNode(T ITEM, TreeNode<T> PARENT) {
        this.item = ITEM;
        this.parent = PARENT;
        this.depth = -1;
        this.children = FXCollections.observableArrayList();
        this.listeners = new CopyOnWriteArrayList<TreeNodeEventListener>();
        this.childNodeListener = c -> {
            TreeNode<T> treeRoot = this.getTreeRoot();
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(addedNode -> addedNode.getNodes().forEach(node -> {
                        if (null != treeRoot) {
                            treeRoot.fireTreeNodeEvent(this.CHILD_ADDED);
                        }
                    }));
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(removedNode -> removedNode.getNodes().forEach(node -> {
                    if (null != treeRoot) {
                        treeRoot.fireTreeNodeEvent(this.CHILD_REMOVED);
                    }
                }));
            }
            if (null != treeRoot) {
                treeRoot.fireTreeNodeEvent(this.CHILDREN_CHANGED);
            }
        };
        this.init();
    }

    private void init() {
        if (null != this.parent && !this.parent.getChildren().contains(this)) {
            this.parent.getChildren().add(this);
        }
        this.children.addListener(this.childNodeListener);
    }

    public boolean isRoot() {
        return null == this.parent;
    }

    public boolean isLeaf() {
        return null == this.children || this.children.isEmpty();
    }

    public boolean hasParent() {
        return null != this.parent;
    }

    public void removeParent() {
        this.parent = null;
        this.myRoot = null;
        this.treeRoot = null;
        this.depth = -1;
        this.getTreeRoot().fireTreeNodeEvent(this.PARENT_CHANGED);
    }

    public TreeNode<T> getParent() {
        return this.parent;
    }

    public void setParent(TreeNode<T> PARENT) {
        if (null == PARENT || PARENT.getChildren().contains(this)) {
            return;
        }
        PARENT.getChildren().add(this);
        this.parent = PARENT;
        this.myRoot = null;
        this.treeRoot = null;
        this.depth = -1;
        this.getTreeRoot().fireTreeNodeEvent(this.PARENT_CHANGED);
    }

    public T getItem() {
        return this.item;
    }

    public void setItem(T ITEM) {
        this.item = ITEM;
    }

    public List<TreeNode<T>> getChildrenUnmodifiable() {
        return Collections.unmodifiableList(this.children);
    }

    public List<TreeNode<T>> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeNode<T>> CHILDREN) {
        this.children.setAll((Collection<TreeNode<T>>)new LinkedHashSet<TreeNode<T>>(CHILDREN));
    }

    public void addNode(T ITEM) {
        TreeNode<T> child = new TreeNode<T>(ITEM);
        child.setParent(this);
        this.children.add(child);
    }

    public void addNode(TreeNode<T> NODE) {
        if (this.children.contains(NODE)) {
            return;
        }
        NODE.setParent(this);
    }

    public void removeNode(TreeNode<T> NODE) {
        if (this.children.contains(NODE)) {
            this.children.removeListener(this.childNodeListener);
            this.children.remove(NODE);
            this.children.addListener(this.childNodeListener);
            return;
        }
        this.children.removeListener(this.childNodeListener);
        int size = this.children.size();
        for (int i = 0; i < size; ++i) {
            TreeNode n = (TreeNode)this.children.get(i);
            if (!n.getChildren().contains(NODE)) continue;
            n.getChildren().remove(NODE);
            this.children.addListener(this.childNodeListener);
            return;
        }
        this.children.addListener(this.childNodeListener);
    }

    public void addNodes(TreeNode<T> ... NODES) {
        this.addNodes(Arrays.asList(NODES));
    }

    public void addNodes(List<TreeNode<T>> NODES) {
        NODES.forEach(node -> this.addNode((TreeNode<T>)node));
    }

    public void removeNodes(TreeNode<T> ... NODES) {
        this.removeNodes(Arrays.asList(NODES));
    }

    public void removeNodes(List<TreeNode<T>> NODES) {
        NODES.forEach(node -> this.removeNode((TreeNode<T>)node));
    }

    public void removeAllNodes() {
        this.children.clear();
    }

    public Stream<TreeNode<T>> stream() {
        if (this.isLeaf()) {
            return Stream.of(this);
        }
        return this.getChildren().stream().map(child -> child.stream()).reduce(Stream.of(this), (s1, s2) -> Stream.concat(s1, s2));
    }

    public Stream<TreeNode<T>> lazyStream() {
        if (this.isLeaf()) {
            return Stream.of(this);
        }
        return Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(TreeNode::stream));
    }

    public Stream<TreeNode<T>> flattened() {
        return Stream.concat(Stream.of(this), this.children.stream().flatMap(TreeNode::flattened));
    }

    public List<TreeNode<T>> getAll() {
        return this.flattened().collect(Collectors.toList());
    }

    public List<T> getAllItems() {
        return this.flattened().map(TreeNode::getItem).collect(Collectors.toList());
    }

    public List<TreeNode<T>> getNodes() {
        return this.flattened().collect(Collectors.toList());
    }

    public int getNoOfNodes() {
        return this.flattened().map(TreeNode::getItem).collect(Collectors.toList()).size();
    }

    public int getNoOfLeafNodes() {
        return this.flattened().filter(node -> node.isLeaf()).map(TreeNode::getItem).collect(Collectors.toList()).size();
    }

    public boolean contains(TreeNode<T> NODE) {
        return this.flattened().anyMatch(n -> n.equals(NODE));
    }

    public boolean containsData(T ITEM) {
        return this.flattened().anyMatch(n -> n.item.equals(ITEM));
    }

    public TreeNode<T> getMyRoot() {
        if (null == this.myRoot) {
            this.myRoot = null != this.getParent() && this.getParent().isRoot() ? this : this.getMyRoot(this.getParent());
        }
        return this.myRoot;
    }

    private TreeNode<T> getMyRoot(TreeNode<T> NODE) {
        if (NODE.getParent().isRoot()) {
            return NODE;
        }
        return this.getMyRoot(NODE.getParent());
    }

    public TreeNode<T> getTreeRoot() {
        if (null == this.treeRoot) {
            this.treeRoot = this.isRoot() ? this : this.getTreeRoot(this.getParent());
        }
        return this.treeRoot;
    }

    private TreeNode<T> getTreeRoot(TreeNode<T> NODE) {
        if (NODE.isRoot()) {
            return NODE;
        }
        return this.getTreeRoot(NODE.getParent());
    }

    public int getDepth() {
        if (this.depth == -1) {
            this.depth = this.isRoot() ? 0 : this.getDepth(this.getParent(), 0);
        }
        return this.depth;
    }

    private int getDepth(TreeNode<T> NODE, int depth) {
        ++depth;
        if (NODE.isRoot()) {
            return depth;
        }
        return this.getDepth(NODE.getParent(), depth);
    }

    public int getMaxLevel() {
        return this.getTreeRoot().stream().map(TreeNode::getDepth).max(Comparator.naturalOrder()).orElse(0);
    }

    public List<TreeNode<T>> getSiblings() {
        return null == this.getParent() ? new ArrayList() : this.getParent().getChildren();
    }

    public List<TreeNode<T>> nodesAtSameLevel() {
        int LEVEL = this.getDepth();
        return this.getTreeRoot().stream().filter(node -> node.getDepth() == LEVEL).collect(Collectors.toList());
    }

    public void setOnTreeNodeEvent(TreeNodeEventListener LISTENER) {
        this.addTreeNodeEventListener(LISTENER);
    }

    public void addTreeNodeEventListener(TreeNodeEventListener LISTENER) {
        if (!this.listeners.contains(LISTENER)) {
            this.listeners.add(LISTENER);
        }
    }

    public void removeTreeNodeEventListener(TreeNodeEventListener LISTENER) {
        if (this.listeners.contains(LISTENER)) {
            this.listeners.remove(LISTENER);
        }
    }

    public void removeAllTreeNodeEventListeners() {
        this.listeners.clear();
    }

    public void fireTreeNodeEvent(TreeNodeEvent EVENT) {
        for (TreeNodeEventListener listener : this.listeners) {
            listener.onTreeNodeEvent(EVENT);
        }
    }
}

