/*
 * Decompiled with CFR 0.152.
 */
package oshi.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@ThreadSafe
public final class LsofUtil {
    private LsofUtil() {
    }

    public static Map<Integer, String> getCwdMap(int pid) {
        List<String> lsof = ExecutingCommand.runNative("lsof -Fn -d cwd" + (pid < 0 ? "" : " -p " + pid));
        HashMap<Integer, String> cwdMap = new HashMap<Integer, String>();
        Integer key = -1;
        for (String line : lsof) {
            if (line.isEmpty()) continue;
            switch (line.charAt(0)) {
                case 'p': {
                    key = ParseUtil.parseIntOrDefault(line.substring(1), -1);
                    break;
                }
                case 'n': {
                    cwdMap.put(key, line.substring(1));
                    break;
                }
            }
        }
        return cwdMap;
    }
}

