/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.java.impl;

import com.sun.tools.visualvm.heapviewer.HeapContext;
import com.sun.tools.visualvm.heapviewer.java.ClassNode;
import com.sun.tools.visualvm.heapviewer.java.JavaHeapFragment;
import com.sun.tools.visualvm.heapviewer.java.impl.Bundle;
import com.sun.tools.visualvm.heapviewer.model.DataType;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNode;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNodeFilter;
import com.sun.tools.visualvm.heapviewer.model.Progress;
import com.sun.tools.visualvm.heapviewer.model.RootNode;
import com.sun.tools.visualvm.heapviewer.model.TextNode;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewPlugin;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerActions;
import com.sun.tools.visualvm.heapviewer.ui.TreeTableView;
import com.sun.tools.visualvm.heapviewer.ui.TreeTableViewColumn;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SortOrder;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.api.icons.Icons;

public class ClassHierarchyPlugin
extends HeapViewPlugin {
    private final Heap heap;
    private JavaClass selected;
    private final TreeTableView objectsView;

    public ClassHierarchyPlugin(HeapContext context, HeapViewerActions actions) {
        super(Bundle.ClassHierarchyPlugin_Name(), Bundle.ClassHierarchyPlugin_Description(), Icons.getIcon((String)"HeapWalkerIcons.Classes"));
        this.heap = context.getFragment().getHeap();
        this.objectsView = new TreeTableView("java_objects_hierarchy", context, actions, TreeTableViewColumn.classesPlain(this.heap)){

            @Override
            protected HeapViewerNode[] computeData(RootNode root, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) {
                if (ClassHierarchyPlugin.this.selected != null) {
                    String className;
                    JavaClass plainClass;
                    JavaClass javaClass = ClassHierarchyPlugin.this.selected;
                    if (javaClass.isArray() && (plainClass = heap.getJavaClassByName(className = javaClass.getName().replace("[]", ""))) != null) {
                        javaClass = plainClass;
                    }
                    SuperClassNode node = null;
                    SuperClassNode firstNode = null;
                    SuperClassNode previousNode = null;
                    while (javaClass != null) {
                        node = new SuperClassNode(javaClass);
                        if (firstNode == null) {
                            firstNode = node;
                        } else {
                            previousNode.setChildren(new HeapViewerNode[]{node});
                        }
                        javaClass = javaClass.getSuperClass();
                        previousNode = node;
                    }
                    node.setChildren(HeapViewerNode.NO_NODES);
                    return new HeapViewerNode[]{firstNode};
                }
                return new HeapViewerNode[]{new TextNode(Bundle.ClassHierarchyPlugin_NoSelection())};
            }

            @Override
            protected void childrenChanged() {
                RootNode root = this.getRoot();
                while (root != null) {
                    this.expandNode(root);
                    root = root.getNChildren() > 0 ? root.getChild(0) : null;
                }
            }
        };
    }

    @Override
    protected JComponent createComponent() {
        return this.objectsView.getComponent();
    }

    @Override
    protected void nodeSelected(HeapViewerNode node, boolean adjusting) {
        this.selected = node == null ? null : HeapViewerNode.getValue(node, DataType.CLASS, this.heap);
        this.objectsView.reloadView();
    }

    public static class Provider
    extends HeapViewPlugin.Provider {
        @Override
        public HeapViewPlugin createPlugin(HeapContext context, HeapViewerActions actions, String viewID) {
            if (JavaHeapFragment.isJavaHeap(context)) {
                return new ClassHierarchyPlugin(context, actions);
            }
            return null;
        }
    }

    private static class SuperClassNode
    extends ClassNode {
        SuperClassNode(JavaClass javaClass) {
            super(javaClass);
        }

        @Override
        protected void setChildren(HeapViewerNode[] ch) {
            super.setChildren(ch);
        }

        @Override
        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }
    }
}

