/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.force;

import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.force.Displacement;
import org.gephi.layout.plugin.force.ForceVector;

public class ProportionalDisplacement
implements Displacement {
    private float step;

    public ProportionalDisplacement(float step) {
        this.step = step;
    }

    @Override
    public void setStep(float step) {
        this.step = step;
    }

    private boolean assertValue(float value) {
        boolean ret = !Float.isInfinite(value) && !Float.isNaN(value);
        return ret;
    }

    @Override
    public void moveNode(Node node, ForceVector forceData) {
        ForceVector displacement = new ForceVector(forceData);
        displacement.multiply(this.step);
        float x = node.x() + displacement.x();
        float y = node.y() + displacement.y();
        if (this.assertValue(x)) {
            node.setX(x);
        }
        if (this.assertValue(y)) {
            node.setY(y);
        }
    }
}

