/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;

public class BitmapInfoHeader
implements EMFConstants {
    public static final int size = 40;
    private int width;
    private int height;
    private int planes;
    private int bitCount;
    private int compression;
    private int sizeImage;
    private int xPelsPerMeter;
    private int yPelsPerMeter;
    private int clrUsed;
    private int clrImportant;

    public BitmapInfoHeader(int width, int height, int bitCount, int compression, int sizeImage, int xPelsPerMeter, int yPelsPerMeter, int clrUsed, int clrImportant) {
        this.width = width;
        this.height = height;
        this.planes = 1;
        this.bitCount = bitCount;
        this.compression = compression;
        this.sizeImage = sizeImage;
        this.xPelsPerMeter = xPelsPerMeter;
        this.yPelsPerMeter = yPelsPerMeter;
        this.clrUsed = clrUsed;
        this.clrImportant = clrImportant;
    }

    public BitmapInfoHeader(EMFInputStream emf) throws IOException {
        emf.readDWORD();
        this.width = emf.readLONG();
        this.height = emf.readLONG();
        this.planes = emf.readWORD();
        this.bitCount = emf.readWORD();
        this.compression = emf.readDWORD();
        this.sizeImage = emf.readDWORD();
        this.xPelsPerMeter = emf.readLONG();
        this.yPelsPerMeter = emf.readLONG();
        this.clrUsed = emf.readDWORD();
        this.clrImportant = emf.readDWORD();
    }

    public void write(EMFOutputStream emf) throws IOException {
        emf.writeDWORD(40);
        emf.writeLONG(this.width);
        emf.writeLONG(this.height);
        emf.writeWORD(this.planes);
        emf.writeWORD(this.bitCount);
        emf.writeDWORD(this.compression);
        emf.writeDWORD(this.sizeImage);
        emf.writeLONG(this.xPelsPerMeter);
        emf.writeLONG(this.yPelsPerMeter);
        emf.writeDWORD(this.clrUsed);
        emf.writeDWORD(this.clrImportant);
    }

    public String toString() {
        return "    size: 40\n    width: " + this.width + "\n    height: " + this.height + "\n    planes: " + this.planes + "\n    bitCount: " + this.bitCount + "\n    compression: " + this.compression + "\n    sizeImage: " + this.sizeImage + "\n    xPelsPerMeter: " + this.xPelsPerMeter + "\n    yPelsPerMeter: " + this.yPelsPerMeter + "\n    clrUsed: " + this.clrUsed + "\n    clrImportant: " + this.clrImportant;
    }

    public int getBitCount() {
        return this.bitCount;
    }

    public int getCompression() {
        return this.compression;
    }

    public int getClrUsed() {
        return this.clrUsed;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

