/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.popup;

import java.util.Properties;
import org.jmol.api.PlatformViewer;
import org.jmol.api.SC;
import org.jmol.i18n.GT;
import org.jmol.popup.GenericPopup;
import org.jmol.popup.PopupResource;
import org.jmol.viewer.Viewer;

public abstract class JmolGenericPopup
extends GenericPopup {
    protected SC frankPopup;
    protected int nFrankList = 0;
    protected Viewer vwr;
    protected Properties menuText = new Properties();

    @Override
    public void jpiInitialize(PlatformViewer vwr, String menu) {
        boolean doTranslate = GT.setDoTranslate(true);
        PopupResource bundle = this.getBundle(menu);
        this.initialize((Viewer)vwr, bundle, bundle.getMenuName());
        GT.setDoTranslate(doTranslate);
    }

    protected abstract PopupResource getBundle(String var1);

    protected void initialize(Viewer vwr, PopupResource bundle, String title) {
        this.vwr = vwr;
        this.initSwing(title, bundle, vwr.html5Applet, Viewer.isJSNoAWT, vwr.getBooleanProperty("_signedApplet"), Viewer.isWebGL);
    }

    @Override
    public void jpiShow(int x, int y) {
        if (!this.vwr.haveDisplay) {
            return;
        }
        this.thisx = x;
        this.thisy = y;
        this.show(x, y, false);
        if (x < 0 && this.showFrankMenu()) {
            return;
        }
        this.appRestorePopupMenu();
        this.menuShowPopup(this.popupMenu, this.thisx, this.thisy);
    }

    protected boolean showFrankMenu() {
        return true;
    }

    @Override
    public void jpiDispose() {
        this.helper.menuClearListeners(this.popupMenu);
        this.thisPopup = null;
        this.popupMenu = null;
    }

    @Override
    public SC jpiGetMenuAsObject() {
        return this.popupMenu;
    }

    @Override
    protected String appFixLabel(String label) {
        return label;
    }

    @Override
    protected boolean appGetBooleanProperty(String name) {
        return this.vwr.getBooleanProperty(name);
    }

    @Override
    protected boolean appRunSpecialCheckBox(SC item, String basename, String script, boolean TF) {
        if (this.appGetBooleanProperty(basename) == TF) {
            return true;
        }
        if (basename.indexOf("mk") < 0 && !basename.endsWith("P!")) {
            return false;
        }
        if (basename.indexOf("mk") >= 0 || basename.indexOf("??") >= 0) {
            script = this.getUnknownCheckBoxScriptToRun(item, basename, script, TF);
        } else {
            if (!TF) {
                return true;
            }
            script = "set picking " + basename.substring(0, basename.length() - 2);
        }
        if (script != null) {
            this.appRunScript(script);
        }
        return true;
    }

    @Override
    protected void appRestorePopupMenu() {
        this.thisPopup = this.popupMenu;
    }

    @Override
    protected void appRunScript(String script) {
        this.vwr.evalStringQuiet(script);
    }
}

