/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.ContextAccessController;
import org.apache.naming.NameParserImpl;
import org.apache.naming.NamingContextBindingsEnumeration;
import org.apache.naming.NamingContextEnumeration;
import org.apache.naming.NamingEntry;
import org.apache.naming.ResourceRef;
import org.apache.naming.StringManager;

public class NamingContext
implements Context {
    protected static final NameParser nameParser = new NameParserImpl();
    private static final Log log = LogFactory.getLog(NamingContext.class);
    protected final Hashtable<String, Object> env = new Hashtable();
    protected static final StringManager sm = StringManager.getManager(NamingContext.class);
    protected final HashMap<String, NamingEntry> bindings;
    protected final String name;
    private boolean exceptionOnFailedWrite = true;
    private static final boolean GRAAL;

    public NamingContext(Hashtable<String, Object> hashtable, String string) {
        this(hashtable, string, new HashMap<String, NamingEntry>());
    }

    public NamingContext(Hashtable<String, Object> hashtable, String string, HashMap<String, NamingEntry> hashMap) {
        this.name = string;
        if (hashtable != null) {
            Enumeration<String> enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                this.addToEnvironment(string2, hashtable.get(string2));
            }
        }
        this.bindings = hashMap;
    }

    public boolean getExceptionOnFailedWrite() {
        return this.exceptionOnFailedWrite;
    }

    public void setExceptionOnFailedWrite(boolean bl) {
        this.exceptionOnFailedWrite = bl;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name, true);
    }

    @Override
    public Object lookup(String string) throws NamingException {
        return this.lookup(new CompositeName(string), true);
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        this.bind(name, object, false);
    }

    @Override
    public void bind(String string, Object object) throws NamingException {
        this.bind(new CompositeName(string), object);
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        this.bind(name, object, true);
    }

    @Override
    public void rebind(String string, Object object) throws NamingException {
        this.rebind(new CompositeName(string), object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void unbind(Name name) throws NamingException {
        if (!this.checkWritable()) {
            return;
        }
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            throw new NamingException(sm.getString("namingContext.invalidName"));
        }
        NamingEntry namingEntry = this.bindings.get(name.get(0));
        if (namingEntry == null) {
            throw new NameNotFoundException(sm.getString("namingContext.nameNotBound", name, name.get(0)));
        }
        if (name.size() > 1) {
            if (namingEntry.type != 10) throw new NamingException(sm.getString("namingContext.contextExpected"));
            ((Context)namingEntry.value).unbind(name.getSuffix(1));
            return;
        } else {
            this.bindings.remove(name.get(0));
        }
    }

    @Override
    public void unbind(String string) throws NamingException {
        this.unbind(new CompositeName(string));
    }

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        Object object = this.lookup(name);
        this.bind(name2, object);
        this.unbind(name);
    }

    @Override
    public void rename(String string, String string2) throws NamingException {
        this.rename(new CompositeName(string), new CompositeName(string2));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return new NamingContextEnumeration(this.bindings.values().iterator());
        }
        NamingEntry namingEntry = this.bindings.get(name.get(0));
        if (namingEntry == null) {
            throw new NameNotFoundException(sm.getString("namingContext.nameNotBound", name, name.get(0)));
        }
        if (namingEntry.type != 10) {
            throw new NamingException(sm.getString("namingContext.contextExpected"));
        }
        return ((Context)namingEntry.value).list(name.getSuffix(1));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String string) throws NamingException {
        return this.list(new CompositeName(string));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return new NamingContextBindingsEnumeration(this.bindings.values().iterator(), this);
        }
        NamingEntry namingEntry = this.bindings.get(name.get(0));
        if (namingEntry == null) {
            throw new NameNotFoundException(sm.getString("namingContext.nameNotBound", name, name.get(0)));
        }
        if (namingEntry.type != 10) {
            throw new NamingException(sm.getString("namingContext.contextExpected"));
        }
        return ((Context)namingEntry.value).listBindings(name.getSuffix(1));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String string) throws NamingException {
        return this.listBindings(new CompositeName(string));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void destroySubcontext(Name name) throws NamingException {
        if (!this.checkWritable()) {
            return;
        }
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            throw new NamingException(sm.getString("namingContext.invalidName"));
        }
        NamingEntry namingEntry = this.bindings.get(name.get(0));
        if (namingEntry == null) {
            throw new NameNotFoundException(sm.getString("namingContext.nameNotBound", name, name.get(0)));
        }
        if (name.size() > 1) {
            if (namingEntry.type != 10) throw new NamingException(sm.getString("namingContext.contextExpected"));
            ((Context)namingEntry.value).destroySubcontext(name.getSuffix(1));
            return;
        } else {
            if (namingEntry.type != 10) throw new NotContextException(sm.getString("namingContext.contextExpected"));
            ((Context)namingEntry.value).close();
            this.bindings.remove(name.get(0));
        }
    }

    @Override
    public void destroySubcontext(String string) throws NamingException {
        this.destroySubcontext(new CompositeName(string));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        if (!this.checkWritable()) {
            return null;
        }
        NamingContext namingContext = new NamingContext(this.env, this.name);
        this.bind(name, (Object)namingContext);
        namingContext.setExceptionOnFailedWrite(this.getExceptionOnFailedWrite());
        return namingContext;
    }

    @Override
    public Context createSubcontext(String string) throws NamingException {
        return this.createSubcontext(new CompositeName(string));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name, false);
    }

    @Override
    public Object lookupLink(String string) throws NamingException {
        return this.lookup(new CompositeName(string), false);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return nameParser;
        }
        if (name.size() > 1) {
            NamingEntry namingEntry = this.bindings.get(name.get(0));
            if (namingEntry instanceof Context) {
                return ((Context)((Object)namingEntry)).getNameParser(name.getSuffix(1));
            }
            throw new NotContextException(sm.getString("namingContext.contextExpected"));
        }
        return nameParser;
    }

    @Override
    public NameParser getNameParser(String string) throws NamingException {
        return this.getNameParser(new CompositeName(string));
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        name2 = (Name)name2.clone();
        return name2.addAll(name);
    }

    @Override
    public String composeName(String string, String string2) {
        return string2 + "/" + string;
    }

    @Override
    public Object addToEnvironment(String string, Object object) {
        return this.env.put(string, object);
    }

    @Override
    public Object removeFromEnvironment(String string) {
        return this.env.remove(string);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() {
        return this.env;
    }

    @Override
    public void close() throws NamingException {
        if (!this.checkWritable()) {
            return;
        }
        this.env.clear();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException(sm.getString("namingContext.noAbsoluteName"));
    }

    protected Object lookup(Name name, boolean bl) throws NamingException {
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return new NamingContext(this.env, this.name, this.bindings);
        }
        NamingEntry namingEntry = this.bindings.get(name.get(0));
        if (namingEntry == null) {
            throw new NameNotFoundException(sm.getString("namingContext.nameNotBound", name, name.get(0)));
        }
        if (name.size() > 1) {
            if (namingEntry.type != 10) {
                throw new NamingException(sm.getString("namingContext.contextExpected"));
            }
            return ((Context)namingEntry.value).lookup(name.getSuffix(1));
        }
        if (bl && namingEntry.type == 1) {
            String string = ((LinkRef)namingEntry.value).getLinkName();
            if (string.startsWith(".")) {
                return this.lookup(string.substring(1));
            }
            return new InitialContext(this.env).lookup(string);
        }
        if (namingEntry.type == 2) {
            try {
                boolean bl2;
                Object object = null;
                if (!GRAAL) {
                    object = NamingManager.getObjectInstance(namingEntry.value, name, this, this.env);
                } else {
                    Reference reference = (Reference)namingEntry.value;
                    Class<?> clazz = this.getClass().getClassLoader().loadClass(reference.getFactoryClassName());
                    ObjectFactory objectFactory = (ObjectFactory)clazz.newInstance();
                    object = objectFactory.getObjectInstance(namingEntry.value, name, this, this.env);
                }
                if (namingEntry.value instanceof ResourceRef && (bl2 = Boolean.parseBoolean((String)((ResourceRef)namingEntry.value).get("singleton").getContent()))) {
                    namingEntry.type = 0;
                    namingEntry.value = object;
                }
                return object;
            }
            catch (NamingException namingException) {
                throw namingException;
            }
            catch (Exception exception) {
                String string = sm.getString("namingContext.failResolvingReference");
                log.warn((Object)string, (Throwable)exception);
                NamingException namingException = new NamingException(string);
                namingException.initCause(exception);
                throw namingException;
            }
        }
        return namingEntry.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void bind(Name name, Object object, boolean bl) throws NamingException {
        if (!this.checkWritable()) {
            return;
        }
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            throw new NamingException(sm.getString("namingContext.invalidName"));
        }
        NamingEntry namingEntry = this.bindings.get(name.get(0));
        if (name.size() > 1) {
            if (namingEntry == null) {
                throw new NameNotFoundException(sm.getString("namingContext.nameNotBound", name, name.get(0)));
            }
            if (namingEntry.type != 10) throw new NamingException(sm.getString("namingContext.contextExpected"));
            if (bl) {
                ((Context)namingEntry.value).rebind(name.getSuffix(1), object);
                return;
            } else {
                ((Context)namingEntry.value).bind(name.getSuffix(1), object);
            }
            return;
        } else {
            if (!bl && namingEntry != null) {
                throw new NameAlreadyBoundException(sm.getString("namingContext.alreadyBound", name.get(0)));
            }
            Object object2 = NamingManager.getStateToBind(object, name, this, this.env);
            if (object2 instanceof Context) {
                namingEntry = new NamingEntry(name.get(0), object2, 10);
            } else if (object2 instanceof LinkRef) {
                namingEntry = new NamingEntry(name.get(0), object2, 1);
            } else if (object2 instanceof Reference) {
                namingEntry = new NamingEntry(name.get(0), object2, 2);
            } else if (object2 instanceof Referenceable) {
                object2 = ((Referenceable)object2).getReference();
                namingEntry = new NamingEntry(name.get(0), object2, 2);
            } else {
                namingEntry = new NamingEntry(name.get(0), object2, 0);
            }
            this.bindings.put(name.get(0), namingEntry);
        }
    }

    protected boolean isWritable() {
        return ContextAccessController.isWritable(this.name);
    }

    protected boolean checkWritable() throws NamingException {
        if (this.isWritable()) {
            return true;
        }
        if (this.exceptionOnFailedWrite) {
            throw new OperationNotSupportedException(sm.getString("namingContext.readOnly"));
        }
        return false;
    }

    static {
        boolean bl = false;
        try {
            Class<?> clazz = Class.forName("org.graalvm.nativeimage.ImageInfo");
            bl = Boolean.TRUE.equals(clazz.getMethod("inImageCode", new Class[0]).invoke(null, new Object[0]));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            // empty catch block
        }
        GRAAL = bl || System.getProperty("org.graalvm.nativeimage.imagecode") != null;
    }
}

