/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.dssx;

import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import org.jmol.dssx.AnnotationParser;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.HBond;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.BasePair;
import org.jmol.modelsetbio.BioModel;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class DSSR1
extends AnnotationParser {
    private static final String DSSR_PATHS = "..bulges.nts_long..coaxstacks.stems.pairs.nt*..hairpins.nts_long..hbonds.atom1_id;atom2_id..helices.pairs.nt*..iloops.nts_long..isocanonpairs.nt*..junctions.nts_long..kissingloops.hairpins.nts_long..multiplets.nts_long..nonstack.nts_long..nts.nt_id..pairs.nt*..sssegments.nts_long..stacks.nts_long..stems.pairs.nt*..";

    @Override
    public String calculateDSSRStructure(Viewer vwr, BS bsAtoms) {
        BS bs = vwr.ms.getModelBS(bsAtoms == null ? vwr.bsA() : bsAtoms, true);
        String s = "";
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            s = s + this.getDSSRForModel(vwr, i) + "\n";
            i = bs.nextSetBit(i + 1);
        }
        return s;
    }

    private String getDSSRForModel(Viewer vwr, int modelIndex) {
        Map<String, Object> info = null;
        String out = null;
        if (vwr.ms.am[modelIndex].isBioModel && !(info = vwr.ms.getModelAuxiliaryInfo(modelIndex)).containsKey("dssr")) {
            BS bs = vwr.getModelUndeletedAtomsBitSet(modelIndex);
            bs.and(vwr.ms.getAtoms(0x20000E, null));
            if (bs.nextClearBit(0) < 0) {
                info = null;
            } else {
                try {
                    String name = (String)vwr.setLoadFormat("=dssrModel/", '=', false);
                    name = PT.rep(name, "%20", " ");
                    Logger.info("fetching " + name + "[pdb data]");
                    String data = vwr.getPdbAtomData(bs, null, false, false);
                    int modelNumber = vwr.getModelNumber(vwr.ms.getModelBS(bs, false).nextSetBit(0));
                    String s = "          " + modelNumber;
                    data = "MODEL" + s.substring(s.length() - 9) + "\n" + data + "ENDMDL\n";
                    data = vwr.getFileAsString3(name + data, false, null);
                    Map<String, Object> x = vwr.parseJSONMap(data);
                    if (x != null) {
                        info.put("dssr", x);
                        this.setGroup1(vwr.ms, modelIndex);
                        this.fixDSSRJSONMap(x);
                        this.setBioPolymers((BioModel)vwr.ms.am[modelIndex], false);
                    }
                }
                catch (Throwable e) {
                    info = null;
                    out = "" + e;
                }
            }
        }
        return info != null ? PT.rep(Escape.escapeMap((Map)((Map)info.get("dssr")).get("counts")), ",", ",\n") : (out == null ? "model has no nucleotides" : out);
    }

    @Override
    public String fixDSSRJSONMap(Map<String, Object> map) {
        String s = "";
        try {
            this.fixIndices(map, "kissingLoops", "hairpin");
            this.fixIndices(map, "coaxStacks", "stem");
            if (map.containsKey("counts")) {
                s = s + "_M.dssr.counts = " + map.get("counts").toString() + "\n";
            }
            if (map.containsKey("dbn")) {
                s = s + "_M.dssr.dbn = " + map.get("dbn").toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return s;
    }

    private void fixIndices(Map<String, Object> map, String key, String root) {
        String indices = root + "_indices";
        String original = root + "s";
        Lst lst = (Lst)map.get(key);
        if (lst != null) {
            Lst hpins = (Lst)map.get(original);
            int i = lst.size();
            while (--i >= 0) {
                Map kmap = (Map)lst.get(i);
                Lst khlist = (Lst)kmap.get(indices);
                int n = khlist.size();
                if (n <= 0) continue;
                Lst khpins = new Lst();
                kmap.put(original, khpins);
                int j = n;
                while (--j >= 0) {
                    khpins.addLast(hpins.get((Integer)khlist.get(j) - 1));
                }
            }
        }
    }

    @Override
    public void getBasePairs(Viewer vwr, int modelIndex) {
        Lst singles;
        ModelSet ms = vwr.ms;
        Map info = (Map)ms.getInfo(modelIndex, "dssr");
        Lst pairs = info == null ? null : (Lst)info.get("pairs");
        Lst lst = singles = info == null ? null : (Lst)info.get("ssSegments");
        if (pairs == null && singles == null) {
            this.setBioPolymers((BioModel)vwr.ms.am[modelIndex], true);
            return;
        }
        BS bsAtoms = ms.am[modelIndex].bsAtoms;
        try {
            Map map;
            int i;
            BS bs = new BS();
            Atom[] atoms = ms.at;
            if (pairs != null) {
                i = pairs.size();
                while (--i >= 0) {
                    map = (Map)pairs.get(i);
                    String unit1 = (String)map.get("nt1");
                    String unit2 = (String)map.get("nt2");
                    int a1 = ms.getSequenceBits(unit1, bsAtoms, bs).nextSetBit(0);
                    bs.clearAll();
                    int a2 = ms.getSequenceBits(unit2, bsAtoms, bs).nextSetBit(0);
                    bs.clearAll();
                    BasePair.add(map, this.setRes(atoms[a1]), this.setRes(atoms[a2]));
                }
            }
            if (singles != null) {
                i = singles.size();
                while (--i >= 0) {
                    map = (Map)singles.get(i);
                    String units = (String)map.get("nts_long");
                    ms.getSequenceBits(units, bsAtoms, bs);
                    int j = bs.nextSetBit(0);
                    while (j >= 0) {
                        this.setRes(atoms[j]);
                        j = bs.nextSetBit(j + 1);
                    }
                }
            }
        }
        catch (Throwable e) {
            Logger.error("Exception " + e + " in DSSRParser.getBasePairs");
        }
    }

    private void setBioPolymers(BioModel m, boolean b) {
        int n;
        int i = n = m.getBioPolymerCount();
        while (--i >= 0) {
            BioPolymer bp = m.bioPolymers[i];
            if (!bp.isNucleic()) continue;
            ((NucleicPolymer)bp).isDssrSet = b;
        }
    }

    private NucleicMonomer setRes(Atom atom) {
        if (atom.group.getBioPolymerLength() == 0) {
            return null;
        }
        NucleicMonomer m = (NucleicMonomer)atom.group;
        ((NucleicPolymer)m.bioPolymer).isDssrSet = true;
        return m;
    }

    @Override
    public BS getAtomBits(Viewer vwr, String key, Object dbObj, Map<String, Object> annotationCache, int type, int modelIndex, BS bsModel) {
        boolean doCache;
        if (dbObj == null) {
            return new BS();
        }
        boolean bl = doCache = !key.contains("NOCACHE");
        if (!doCache) {
            key = PT.rep(key, "NOCACHE", "").trim();
        }
        BS bs = null;
        bs = new BS();
        if (doCache) {
            annotationCache.put(key, bs);
        }
        try {
            key = PT.rep(key, "[where", "[select * where");
            key = PT.rep(key, "[WHERE", "[select * where");
            String ext = "";
            int n = Integer.MIN_VALUE;
            int pt = key.toLowerCase().indexOf("[select");
            if (pt >= 0) {
                ext = key.substring(pt);
                key = key.substring(0, pt);
                pt = ext.lastIndexOf("]..");
                if (pt >= 0 && (n = PT.parseInt(ext.substring(pt + 3))) != Integer.MIN_VALUE) {
                    ext = ext.substring(0, pt + 1);
                }
            }
            if ((pt = key.toLowerCase().indexOf(" where ")) < 0) {
                int ptLast;
                key = key.toLowerCase();
                pt = n == Integer.MIN_VALUE ? key.lastIndexOf(46) : -1;
                boolean haveIndex = false;
                if (pt >= 0 && (haveIndex = (n = PT.parseInt(key.substring(pt + 1))) != Integer.MIN_VALUE)) {
                    key = key.substring(0, pt);
                }
                pt = DSSR_PATHS.indexOf(".." + key) + 2;
                int len = key.length();
                if (pt < 2) {
                    return bs;
                }
                int n2 = ptLast = haveIndex ? pt + len : Integer.MAX_VALUE;
                while (pt >= 2 && pt < ptLast && len > 0) {
                    if (key.indexOf(".") < 0 && DSSR_PATHS.substring(pt + len, pt + len + 2).equals("..")) {
                        key = "[select (" + key + ")]";
                    }
                    dbObj = vwr.extractProperty(dbObj, key, -1);
                    pt += len + 1;
                    if (ext.length() > 0) {
                        dbObj = vwr.extractProperty(dbObj, ext, -1);
                        ext = "";
                    }
                    int pt1 = DSSR_PATHS.indexOf(".", pt);
                    key = DSSR_PATHS.substring(pt, pt1);
                    len = key.length();
                }
            } else {
                key = key.substring(0, pt).trim() + "[select * " + key.substring(pt + 1) + "]" + ext;
                dbObj = vwr.extractProperty(dbObj, key, -1);
            }
            if (n != Integer.MIN_VALUE && dbObj instanceof Lst) {
                if (n <= 0) {
                    n += ((Lst)dbObj).size();
                }
                dbObj = ((Lst)dbObj).get(n - 1);
            }
            bs.or(vwr.ms.getAtoms(1086324744, dbObj.toString()));
            bs.and(bsModel);
        }
        catch (Throwable e) {
            System.out.println(e.toString() + " in AnnotationParser");
            bs.clearAll();
        }
        return bs;
    }

    @Override
    public String getHBonds(ModelSet ms, int modelIndex, Lst<Bond> vHBonds, boolean doReport) {
        Lst list;
        Map info = (Map)ms.getInfo(modelIndex, "dssr");
        if (info == null || (list = (Lst)info.get("hbonds")) == null) {
            return "no DSSR hydrogen-bond data";
        }
        BS bsAtoms = ms.am[modelIndex].bsAtoms;
        String unit1 = null;
        String unit2 = null;
        int a1 = 0;
        int a2 = 0;
        try {
            BS bs = new BS();
            int i = list.size();
            while (--i >= 0) {
                Map map = (Map)list.get(i);
                unit1 = (String)map.get("atom1_id");
                a1 = ms.getSequenceBits(unit1, bsAtoms, bs).nextSetBit(0);
                if (a1 < 0) {
                    Logger.error("Atom " + unit1 + " was not found");
                    continue;
                }
                unit2 = (String)map.get("atom2_id");
                bs.clearAll();
                a2 = ms.getSequenceBits(unit2, bsAtoms, bs).nextSetBit(0);
                if (a2 < 0) {
                    Logger.error("Atom " + unit2 + " was not found");
                    continue;
                }
                bs.clearAll();
                float energy = 0.0f;
                vHBonds.addLast(new HBond(ms.at[a1], ms.at[a2], 2048, 1, 0, energy));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "DSSR reports " + list.size() + " hydrogen bonds";
    }

    @Override
    public void setGroup1(ModelSet ms, int modelIndex) {
        Lst list;
        Map info = (Map)ms.getInfo(modelIndex, "dssr");
        if (info == null || (list = (Lst)info.get("nts")) == null) {
            return;
        }
        Model m = ms.am[modelIndex];
        BS bsAtoms = m.bsAtoms;
        Atom[] atoms = ms.at;
        BS bs = new BS();
        int i = list.size();
        while (--i >= 0) {
            Map map = (Map)list.get(i);
            char ch = ((String)map.get("nt_code")).charAt(0);
            String unit1 = (String)map.get("nt_id");
            ms.bioModelset.getAllSequenceBits(unit1, bsAtoms, bs);
            int pt = bs.nextSetBit(0);
            if (pt < 0) continue;
            if ("ACGTU".indexOf(ch) < 0) {
                atoms[pt].group.group1 = ch;
            }
            atoms[pt].group.dssrNT = map;
            bs.clearAll();
        }
    }

    @Override
    public void getAtomicDSSRData(ModelSet ms, int modelIndex, float[] dssrData, String dataType) {
        Lst list;
        Map info = (Map)ms.getInfo(modelIndex, "dssr");
        if (info == null || (list = (Lst)info.get(dataType)) == null) {
            return;
        }
        BS bsAtoms = ms.am[modelIndex].bsAtoms;
        try {
            BS bs = new BS();
            int i = list.size();
            while (--i >= 0) {
                Map map = (Map)list.get(i);
                bs.clearAll();
                ms.getSequenceBits(map.toString(), bsAtoms, bs);
                int j = bs.nextSetBit(0);
                while (j >= 0) {
                    dssrData[j] = i;
                    j = bs.nextSetBit(j + 1);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public P3[] getDSSRFrame(Map<String, Object> nt) {
        Map frame = (Map)nt.get("frame");
        if (frame == null) {
            return null;
        }
        P3[] oxyz = new P3[4];
        int i = 4;
        while (--i >= 0) {
            oxyz[i] = new P3();
        }
        this.getPoint(frame, "origin", oxyz[0]);
        this.getPoint(frame, "x_axis", oxyz[1]);
        this.getPoint(frame, "y_axis", oxyz[2]);
        this.getPoint(frame, "z_axis", oxyz[3]);
        return oxyz;
    }

    private void getPoint(Map<String, Object> frame, String item, P3 pt) {
        Lst xyz = (Lst)frame.get(item);
        pt.x = ((Float)xyz.get(0)).floatValue();
        pt.y = ((Float)xyz.get(1)).floatValue();
        pt.z = ((Float)xyz.get(2)).floatValue();
    }
}

