/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.inchi;

import javajs.util.BS;
import net.sf.jniinchi.INCHI_BOND_TYPE;
import net.sf.jniinchi.JniInchiAtom;
import net.sf.jniinchi.JniInchiBond;
import net.sf.jniinchi.JniInchiException;
import net.sf.jniinchi.JniInchiInput;
import net.sf.jniinchi.JniInchiInputInchi;
import net.sf.jniinchi.JniInchiStructure;
import net.sf.jniinchi.JniInchiWrapper;
import org.jmol.api.JmolInChI;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.viewer.Viewer;

public class InChIJNI
implements JmolInChI {
    @Override
    public String getInchi(Viewer vwr, BS atoms, String options) {
        try {
            boolean haveKey;
            if (atoms == null || atoms.cardinality() == 0) {
                return "";
            }
            if (options == null) {
                options = "";
            }
            if (options.startsWith("structure/")) {
                String inchi = options.substring(10);
                JniInchiInputInchi in = new JniInchiInputInchi(inchi);
                return this.getStructure((JniInchiStructure)JniInchiWrapper.getStructureFromInchi((JniInchiInputInchi)in));
            }
            boolean bl = haveKey = (options = options.toLowerCase()).indexOf("key") >= 0;
            if (haveKey) {
                options = options.replace("inchikey", "");
                options = options.replace("key", "");
            }
            JniInchiInput in = new JniInchiInput(options);
            in.setStructure(InChIJNI.newJniInchiStructure(vwr, atoms));
            String s = JniInchiWrapper.getInchi((JniInchiInput)in).getInchi();
            return haveKey ? JniInchiWrapper.getInchiKey((String)s).getKey() : s;
        }
        catch (JniInchiException e) {
            if (e.getMessage().indexOf("ption") >= 0) {
                System.out.println(e.getMessage() + ": " + options.toLowerCase() + "\n See https://www.inchi-trust.org/download/104/inchi-faq.pdf for valid options");
            } else {
                e.printStackTrace();
            }
            return "";
        }
    }

    private String getStructure(JniInchiStructure mol) {
        return InChIJNI.toString(mol);
    }

    private static JniInchiStructure newJniInchiStructure(Viewer vwr, BS bsAtoms) {
        JniInchiStructure mol = new JniInchiStructure();
        JniInchiAtom[] atoms = new JniInchiAtom[bsAtoms.cardinality()];
        int[] map = new int[bsAtoms.length()];
        BS bsBonds = vwr.ms.getBondsForSelectedAtoms(bsAtoms, false);
        int pt = 0;
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            Atom a = vwr.ms.at[i];
            atoms[pt] = new JniInchiAtom((double)a.x, (double)a.y, (double)a.z, a.getElementSymbol());
            mol.addAtom(atoms[pt]);
            map[i] = pt++;
            i = bsAtoms.nextSetBit(i + 1);
        }
        Bond[] bonds = vwr.ms.bo;
        i = bsBonds.nextSetBit(0);
        while (i >= 0) {
            block7: {
                INCHI_BOND_TYPE order;
                Bond bond = bonds[i];
                switch (bond.order) {
                    case 1: 
                    case 513: {
                        order = INCHI_BOND_TYPE.SINGLE;
                        break;
                    }
                    case 2: 
                    case 514: {
                        order = INCHI_BOND_TYPE.DOUBLE;
                        break;
                    }
                    case 3: {
                        order = INCHI_BOND_TYPE.TRIPLE;
                        break;
                    }
                    default: {
                        break block7;
                    }
                }
                mol.addBond(new JniInchiBond(atoms[map[bond.getAtomIndex1()]], atoms[map[bond.getAtomIndex2()]], order));
            }
            i = bsBonds.nextSetBit(i + 1);
        }
        return mol;
    }

    private static String toString(JniInchiStructure mol) {
        int i;
        int na = mol.getNumAtoms();
        int nb = mol.getNumBonds();
        String s = "";
        for (i = 0; i < na; ++i) {
            s = s + mol.getAtom(i).getDebugString() + "\n";
        }
        for (i = 0; i < nb; ++i) {
            s = s + mol.getBond(i).getDebugString() + "\n";
        }
        return s;
    }
}

