/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.VolatileNullableLazyValue;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiVariableEx;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsMemberImpl;
import com.intellij.psi.impl.compiled.ClsModifierListOwner;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import gnu.trove.THashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsFieldImpl
extends ClsMemberImpl<PsiFieldStub>
implements PsiField,
PsiVariableEx,
ClsModifierListOwner {
    private final NotNullLazyValue<PsiTypeElement> myTypeElement;
    private final NullableLazyValue<PsiExpression> myInitializer;

    public ClsFieldImpl(@NotNull PsiFieldStub stub) {
        if (stub == null) {
            ClsFieldImpl.$$$reportNull$$$0(0);
        }
        super(stub);
        this.myTypeElement = new AtomicNotNullLazyValue<PsiTypeElement>(){

            @Override
            @NotNull
            protected PsiTypeElement compute() {
                PsiFieldStub stub = (PsiFieldStub)ClsFieldImpl.this.getStub();
                String typeText = TypeInfo.createTypeText(stub.getType(false));
                assert (typeText != null) : stub;
                return new ClsTypeElementImpl(ClsFieldImpl.this, typeText, '\u0000');
            }
        };
        this.myInitializer = new VolatileNullableLazyValue<PsiExpression>(){

            @Override
            @Nullable
            protected PsiExpression compute() {
                String initializerText = ((PsiFieldStub)ClsFieldImpl.this.getStub()).getInitializerText();
                return initializerText != null && !Comparing.equal(";INITIALIZER_TOO_LONG;", initializerText) ? ClsParsingUtil.createExpressionFromText(initializerText, ClsFieldImpl.this.getManager(), ClsFieldImpl.this) : null;
            }
        };
    }

    @Override
    public PsiElement @NotNull [] getChildren() {
        PsiElement[] psiElementArray = this.getChildren(this.getDocComment(), this.getModifierList(), this.getTypeElement(), this.getNameIdentifier());
        if (psiElementArray == null) {
            ClsFieldImpl.$$$reportNull$$$0(1);
        }
        return psiElementArray;
    }

    @Override
    public PsiClass getContainingClass() {
        return (PsiClass)this.getParent();
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType2 = Objects.requireNonNull(this.getTypeElement()).getType();
        if (psiType2 == null) {
            ClsFieldImpl.$$$reportNull$$$0(2);
        }
        return psiType2;
    }

    @Override
    public PsiTypeElement getTypeElement() {
        return this.myTypeElement.getValue();
    }

    @Override
    public PsiModifierList getModifierList() {
        return (PsiModifierList)Objects.requireNonNull(((PsiFieldStub)this.getStub()).findChildStubByType(JavaStubElementTypes.MODIFIER_LIST)).getPsi();
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            ClsFieldImpl.$$$reportNull$$$0(3);
        }
        return Objects.requireNonNull(this.getModifierList()).hasModifierProperty(name);
    }

    @Override
    public PsiExpression getInitializer() {
        return this.myInitializer.getValue();
    }

    @Override
    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    @Override
    public Object computeConstantValue() {
        return this.computeConstantValue((Set<PsiVariable>)new THashSet());
    }

    @Override
    public Object computeConstantValue(Set<PsiVariable> visitedVars) {
        if (!this.hasModifierProperty("final")) {
            return null;
        }
        PsiExpression initializer2 = this.getInitializer();
        if (initializer2 == null) {
            return null;
        }
        PsiClass containingClass = this.getContainingClass();
        if (containingClass != null) {
            String qName = containingClass.getQualifiedName();
            if ("java.lang.Float".equals(qName)) {
                String name = this.getName();
                if ("POSITIVE_INFINITY".equals(name)) {
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                if ("NEGATIVE_INFINITY".equals(name)) {
                    return Float.valueOf(Float.NEGATIVE_INFINITY);
                }
                if ("NaN".equals(name)) {
                    return Float.valueOf(Float.NaN);
                }
            } else if ("java.lang.Double".equals(qName)) {
                String name = this.getName();
                if ("POSITIVE_INFINITY".equals(name)) {
                    return Double.POSITIVE_INFINITY;
                }
                if ("NEGATIVE_INFINITY".equals(name)) {
                    return Double.NEGATIVE_INFINITY;
                }
                if ("NaN".equals(name)) {
                    return Double.NaN;
                }
            }
        }
        return PsiConstantEvaluationHelperImpl.computeCastTo(initializer2, this.getType(), visitedVars);
    }

    @Override
    public boolean isDeprecated() {
        return ((PsiFieldStub)this.getStub()).isDeprecated() || PsiImplUtil.isDeprecatedByAnnotation(this);
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            ClsFieldImpl.$$$reportNull$$$0(4);
        }
        ClsFieldImpl.appendText(this.getDocComment(), indentLevel, buffer, "go_to_next_line_and_indent");
        ClsFieldImpl.appendText(this.getModifierList(), indentLevel, buffer, "");
        ClsFieldImpl.appendText(this.getTypeElement(), indentLevel, buffer, " ");
        ClsFieldImpl.appendText(this.getNameIdentifier(), indentLevel, buffer);
        PsiExpression initializer2 = this.getInitializer();
        if (initializer2 != null) {
            buffer.append(" = ");
            buffer.append(initializer2.getText());
        }
        buffer.append(';');
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            ClsFieldImpl.$$$reportNull$$$0(5);
        }
        this.setMirrorCheckingType(element, null);
        PsiField mirror = (PsiField)SourceTreeToPsiMap.treeToPsiNotNull(element);
        ClsFieldImpl.setMirrorIfPresent(this.getDocComment(), mirror.getDocComment());
        ClsFieldImpl.setMirror(this.getModifierList(), mirror.getModifierList());
        ClsFieldImpl.setMirror(this.getTypeElement(), mirror.getTypeElement());
        ClsFieldImpl.setMirror(this.getNameIdentifier(), mirror.getNameIdentifier());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            ClsFieldImpl.$$$reportNull$$$0(6);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitField(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        block8: {
            PsiElement psiElement;
            for (ClsCustomNavigationPolicy navigationPolicy : ClsCustomNavigationPolicy.EP_NAME.getExtensionList()) {
                PsiElement psiElement2;
                try {
                    PsiElement navigationElement = navigationPolicy.getNavigationElement(this);
                    if (navigationElement == null) continue;
                    psiElement2 = navigationElement;
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    continue;
                }
                if (psiElement2 == null) {
                    ClsFieldImpl.$$$reportNull$$$0(7);
                }
                return psiElement2;
            }
            try {
                PsiField field;
                PsiClass mirrorClass = ((ClsClassImpl)this.getParent()).getSourceMirrorClass();
                if (mirrorClass == null || (field = mirrorClass.findFieldByName(this.getName(), false)) == null) break block8;
                psiElement = field.getNavigationElement();
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (psiElement == null) {
                ClsFieldImpl.$$$reportNull$$$0(8);
            }
            return psiElement;
        }
        ClsFieldImpl clsFieldImpl = this;
        if (clsFieldImpl == null) {
            ClsFieldImpl.$$$reportNull$$$0(9);
        }
        return clsFieldImpl;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public void setInitializer(PsiExpression initializer2) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = IconManager.getInstance().createLayeredIcon(this, PlatformIcons.FIELD_ICON, ElementPresentationUtil.getFlags(this, false));
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isFieldEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope(this);
        if (searchScope == null) {
            ClsFieldImpl.$$$reportNull$$$0(10);
        }
        return searchScope;
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Override
    public String toString() {
        return "PsiField:" + this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/compiled/ClsFieldImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/compiled/ClsFieldImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendMirrorText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setMirror";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

