/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiConcatenationUtil {
    public static String buildUnescapedFormatString(PsiExpression concatenation, boolean printfFormat, List<? super PsiExpression> formatParameters) {
        StringBuilder result2 = new StringBuilder();
        PsiConcatenationUtil.buildFormatString(concatenation, result2, formatParameters, printfFormat, false);
        return result2.toString();
    }

    @Deprecated
    public static void buildFormatString(PsiExpression expression2, StringBuilder formatString, List<? super PsiExpression> formatParameters, boolean printfFormat) {
        PsiConcatenationUtil.buildFormatString(expression2, formatString, formatParameters, printfFormat, true);
    }

    private static void buildFormatString(PsiExpression expression2, StringBuilder formatString, List<? super PsiExpression> formatParameters, boolean printfFormat, boolean escape) {
        if (expression2 instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression2;
            String value2 = String.valueOf(literalExpression.getValue());
            String text2 = escape ? StringUtil.escapeStringCharacters(value2) : value2;
            String formatText = printfFormat ? text2.replace("%", "%%").replace("\\'", "'") : text2.replace("'", "''").replaceAll("([{}]+)", "'$1'");
            formatString.append(formatText);
        } else if (expression2 instanceof PsiPolyadicExpression) {
            PsiType type2 = expression2.getType();
            if (type2 != null && type2.equalsToText("java.lang.String")) {
                boolean stringStarted;
                PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)expression2;
                PsiExpression[] operands = binaryExpression.getOperands();
                PsiType first = operands[0].getType();
                PsiType second = operands[1].getType();
                boolean bl = stringStarted = first != null && first.equalsToText("java.lang.String") || second != null && second.equalsToText("java.lang.String");
                if (stringStarted) {
                    PsiConcatenationUtil.buildFormatString(operands[0], formatString, formatParameters, printfFormat, escape);
                }
                for (int i = 1; i < operands.length; ++i) {
                    PsiExpression op = operands[i];
                    PsiType optype = op.getType();
                    PsiType r = TypeConversionUtil.calcTypeForBinaryExpression(first, optype, binaryExpression.getOperationTokenType(), true);
                    if (r != null && r.equalsToText("java.lang.String") && !stringStarted) {
                        stringStarted = true;
                        PsiElement element = binaryExpression.getTokenBeforeOperand(op);
                        assert (element != null);
                        if (element.getPrevSibling() instanceof PsiWhiteSpace) {
                            element = element.getPrevSibling();
                        }
                        String text3 = binaryExpression.getText().substring(0, element.getStartOffsetInParent());
                        PsiExpression subExpression = JavaPsiFacade.getElementFactory(binaryExpression.getProject()).createExpressionFromText(text3, binaryExpression);
                        PsiConcatenationUtil.addFormatParameter(subExpression, formatString, formatParameters, printfFormat);
                    }
                    if (stringStarted) {
                        if (optype != null && (optype.equalsToText("java.lang.String") || PsiType.CHAR.equals(optype))) {
                            PsiConcatenationUtil.buildFormatString(op, formatString, formatParameters, printfFormat, escape);
                        } else {
                            PsiConcatenationUtil.addFormatParameter(op, formatString, formatParameters, printfFormat);
                        }
                    }
                    first = r;
                }
            } else {
                PsiConcatenationUtil.addFormatParameter(expression2, formatString, formatParameters, printfFormat);
            }
        } else {
            PsiConcatenationUtil.addFormatParameter(expression2, formatString, formatParameters, printfFormat);
        }
    }

    private static void addFormatParameter(@NotNull PsiExpression expression2, StringBuilder formatString, List<? super PsiExpression> formatParameters, boolean printfFormat) {
        if (expression2 == null) {
            PsiConcatenationUtil.$$$reportNull$$$0(0);
        }
        PsiType type2 = expression2.getType();
        if (!printfFormat) {
            formatString.append("{").append(formatParameters.size()).append("}");
        } else if (type2 != null && (type2.equalsToText("long") || type2.equalsToText("int") || type2.equalsToText("java.lang.Long") || type2.equalsToText("java.lang.Integer"))) {
            formatString.append("%d");
        } else {
            formatString.append("%s");
        }
        formatParameters.add(PsiConcatenationUtil.getBoxedArgument(expression2));
    }

    private static PsiExpression getBoxedArgument(@NotNull PsiExpression arg) {
        if (arg == null) {
            PsiConcatenationUtil.$$$reportNull$$$0(1);
        }
        if (PsiUtil.isLanguageLevel5OrHigher(arg = ObjectUtils.coalesce(PsiConcatenationUtil.unwrapExpression(arg), arg))) {
            return arg;
        }
        PsiType type2 = arg.getType();
        if (!(type2 instanceof PsiPrimitiveType) || type2.equals(PsiType.NULL)) {
            return arg;
        }
        PsiPrimitiveType primitiveType = (PsiPrimitiveType)type2;
        String boxedQName = primitiveType.getBoxedTypeName();
        if (boxedQName == null) {
            return arg;
        }
        GlobalSearchScope resolveScope = arg.getResolveScope();
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(arg.getProject());
        PsiJavaCodeReferenceElement ref = factory2.createReferenceElementByFQClassName(boxedQName, resolveScope);
        PsiNewExpression newExpr = (PsiNewExpression)factory2.createExpressionFromText("new A(b)", null);
        PsiJavaCodeReferenceElement classRef = newExpr.getClassReference();
        assert (classRef != null);
        classRef.replace(ref);
        PsiExpressionList argumentList2 = newExpr.getArgumentList();
        assert (argumentList2 != null);
        argumentList2.getExpressions()[0].replace(arg);
        return newExpr;
    }

    @Nullable
    private static PsiExpression unwrapExpression(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            PsiConcatenationUtil.$$$reportNull$$$0(2);
        }
        while (true) {
            if (expression2 instanceof PsiParenthesizedExpression) {
                expression2 = ((PsiParenthesizedExpression)expression2).getExpression();
                continue;
            }
            if (!(expression2 instanceof PsiTypeCastExpression)) break;
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression2;
            PsiType castType = typeCastExpression.getType();
            PsiExpression operand = typeCastExpression.getOperand();
            if (operand == null) {
                return expression2;
            }
            if (TypeConversionUtil.isNumericType(castType)) {
                int operandRank;
                PsiType operandType = operand.getType();
                if (operandType == null) {
                    return expression2;
                }
                int castRank = TypeConversionUtil.getTypeRank(castType);
                if (castRank < (operandRank = TypeConversionUtil.getTypeRank(operandType)) || castRank == 3 && operandRank != castRank) {
                    return expression2;
                }
            }
            expression2 = operand;
        }
        return expression2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/util/PsiConcatenationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addFormatParameter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getBoxedArgument";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "unwrapExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

