/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSealedClassInheritorsTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSealedClassInheritorsTransformerKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.CompositeTransformResult;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0002\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J/\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u0002H\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "", "()V", "transformElement", "Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "InheritorsCollector", "InheritorsTransformer", "resolve"})
public final class FirSealedClassInheritorsTransformer
extends FirTransformer {
    @NotNull
    public <E extends FirElement> CompositeTransformResult<E> transformElement(@NotNull E element, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(element, "element");
        throw (Throwable)new IllegalStateException("Should not be there");
    }

    @NotNull
    public CompositeTransformResult<FirDeclaration> transformFile(@NotNull FirFile file2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(file2, "file");
        boolean bl = false;
        Map sealedClassInheritorsMap = new LinkedHashMap();
        file2.accept(InheritorsCollector.INSTANCE, sealedClassInheritorsMap);
        if (sealedClassInheritorsMap.isEmpty()) {
            FirElement $this$compose$iv = file2;
            boolean $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv);
        }
        return file2.transform(new InheritorsTransformer(sealedClassInheritorsMap), null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u001f\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004\u00a2\u0006\u0002\u0010\bJ/\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\r\u001a\u0002H\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016J \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\n2\u0006\u0010\u0016\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsTransformer$InheritorsTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "", "inheritorsMap", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "", "Lorg/jetbrains/kotlin/name/ClassId;", "(Ljava/util/Map;)V", "transformElement", "Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "transformFile", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "transformRegularClass", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "regularClass", "resolve"})
    private static final class InheritorsTransformer
    extends FirTransformer {
        private final Map<FirRegularClass, List<ClassId>> inheritorsMap;

        @NotNull
        public <E extends FirElement> CompositeTransformResult<E> transformElement(@NotNull E element, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(element, "element");
            E $this$compose$iv = element;
            boolean $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv);
        }

        @NotNull
        public CompositeTransformResult<FirDeclaration> transformFile(@NotNull FirFile file2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(file2, "file");
            FirElement firElement = file2.transformChildren(this, data);
            if (firElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirFile");
            }
            FirElement $this$compose$iv = (FirFile)firElement;
            boolean $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv);
        }

        @NotNull
        public CompositeTransformResult<FirStatement> transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Void data) {
            boolean $i$f$compose;
            FirElement $this$compose$iv;
            List<ClassId> inheritors2;
            Intrinsics.checkNotNullParameter(regularClass, "regularClass");
            FirMemberDeclaration $this$modality$iv = regularClass;
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getStatus().getModality() == Modality.SEALED && (inheritors2 = this.inheritorsMap.remove(regularClass)) != null) {
                FirSealedClassInheritorsTransformerKt.setSealedInheritors(regularClass, inheritors2);
            }
            if (this.inheritorsMap.isEmpty()) {
                $this$compose$iv = regularClass;
                $i$f$compose = false;
                return CompositeTransformResult.Companion.single($this$compose$iv);
            }
            FirElement firElement = regularClass.transformChildren(this, data);
            if (firElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirRegularClass");
            }
            $this$compose$iv = (FirRegularClass)firElement;
            $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv);
        }

        public InheritorsTransformer(@NotNull Map<FirRegularClass, List<ClassId>> inheritorsMap) {
            Intrinsics.checkNotNullParameter(inheritorsMap, "inheritorsMap");
            this.inheritorsMap = inheritorsMap;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J*\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u0016J*\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u0016J*\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00042\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsTransformer$InheritorsCollector;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "", "Lorg/jetbrains/kotlin/name/ClassId;", "()V", "extractClassFromTypeRef", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitFile", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "visitRegularClass", "regularClass", "resolve"})
    private static final class InheritorsCollector
    extends FirDefaultVisitor<Unit, Map<FirRegularClass, List<ClassId>>> {
        @NotNull
        public static final InheritorsCollector INSTANCE;

        @Override
        public void visitElement(@NotNull FirElement element, @NotNull Map<FirRegularClass, List<ClassId>> data) {
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(data, "data");
        }

        @Override
        public void visitFile(@NotNull FirFile file2, @NotNull Map<FirRegularClass, List<ClassId>> data) {
            Intrinsics.checkNotNullParameter(file2, "file");
            Intrinsics.checkNotNullParameter(data, "data");
            Iterable $this$forEach$iv = file2.getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirDeclaration it = (FirDeclaration)element$iv;
                boolean bl = false;
                it.accept(INSTANCE, data);
            }
        }

        @Override
        public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull Map<FirRegularClass, List<ClassId>> data) {
            FirDeclaration it;
            Intrinsics.checkNotNullParameter(regularClass, "regularClass");
            Intrinsics.checkNotNullParameter(data, "data");
            Iterable $this$forEach$iv = regularClass.getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirDeclaration)element$iv;
                boolean bl = false;
                it.accept(INSTANCE, data);
            }
            FirMemberDeclaration $this$modality$iv = regularClass;
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getStatus().getModality() == Modality.SEALED) {
                data.computeIfAbsent(regularClass, visitRegularClass.2.INSTANCE);
            }
            FirSymbolProvider symbolProvider2 = MainSessionComponentsKt.getFirSymbolProvider(regularClass.getSession());
            for (FirTypeRef typeRef : regularClass.getSuperTypeRefs()) {
                List<ClassId> inheritors2;
                FirDeclaration parent2;
                Modality modality;
                it = this.extractClassFromTypeRef(symbolProvider2, typeRef);
                boolean bl = false;
                boolean bl2 = false;
                FirDeclaration it2 = it;
                boolean bl3 = false;
                FirDeclaration firDeclaration = it2;
                if (firDeclaration != null) {
                    FirMemberDeclaration $this$modality$iv2 = (FirMemberDeclaration)firDeclaration;
                    boolean $i$f$getModality2 = false;
                    modality = $this$modality$iv2.getStatus().getModality();
                } else {
                    modality = null;
                }
                if ((modality == Modality.SEALED ? it : null) == null) {
                    continue;
                }
                parent2 = parent2;
                Intrinsics.checkNotNullExpressionValue(data.computeIfAbsent((FirRegularClass)parent2, visitRegularClass.inheritors.1.INSTANCE), "data.computeIfAbsent(parent) { mutableListOf() }");
                Collection collection = inheritors2;
                ClassId classId = regularClass.getSymbol().getClassId();
                boolean bl4 = false;
                collection.add(classId);
            }
        }

        private final FirRegularClass extractClassFromTypeRef(FirSymbolProvider symbolProvider2, FirTypeRef typeRef) {
            FirClassifierSymbol<?> classLikeSymbol;
            Object object;
            FirTypeRef $this$coneType$iv = typeRef;
            boolean $i$f$getConeType = false;
            FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            boolean $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            ConeKotlinType coneKotlinType2 = coneKotlinType;
            if (!(coneKotlinType instanceof ConeLookupTagBasedType)) {
                coneKotlinType2 = null;
            }
            if ((object = (ConeLookupTagBasedType)coneKotlinType2) == null || (object = ((ConeLookupTagBasedType)object).getLookupTag()) == null) {
                return null;
            }
            Object lookupTag = object;
            FirClassifierSymbol<?> firClassifierSymbol = LookupTagUtilsKt.getSymbolByLookupTag(symbolProvider2, (ConeClassifierLookupTag)lookupTag);
            if (firClassifierSymbol == null) {
                return null;
            }
            FirClassifierSymbol<?> firClassifierSymbol2 = classLikeSymbol = firClassifierSymbol;
            return firClassifierSymbol2 instanceof FirRegularClassSymbol ? (FirRegularClass)((FirRegularClassSymbol)classLikeSymbol).getFir() : (firClassifierSymbol2 instanceof FirTypeAliasSymbol ? this.extractClassFromTypeRef(symbolProvider2, ((FirTypeAlias)((FirTypeAliasSymbol)classLikeSymbol).getFir()).getExpandedTypeRef()) : null);
        }

        private InheritorsCollector() {
        }

        static {
            InheritorsCollector inheritorsCollector;
            INSTANCE = inheritorsCollector = new InheritorsCollector();
        }
    }
}

