/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import net.osmand.data.LatLon;
import net.osmand.plus.GPXUtilities;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.actions.OffRoadAction;
import net.sourceforge.offroad.data.ElevationHelper;
import net.sourceforge.offroad.ui.GraphPanel;

public class ShowTrackDetailsAction
extends OffRoadAction
implements ElevationHelper.LatLonGeneralization {
    private GPXUtilities.GPXFile mGpxFile;
    private GraphPanel mGraphPanel;
    private JTextPane mContentDisplay;
    private boolean mAdjustmentCancelled;
    private ElevationHelper mElevationHelper;

    public ShowTrackDetailsAction(OsmWindow pContext, GPXUtilities.GPXFile pGpxFile) {
        super(pContext, pContext.getOffRoadString("offroad.track_details", pGpxFile.getName()), null);
        this.mGpxFile = pGpxFile;
        this.mElevationHelper = new ElevationHelper();
    }

    @Override
    public void actionPerformed(ActionEvent pE) {
        this.createDialog();
        String title = (String)this.getValue("Name");
        this.mDialog.setTitle(title);
        Container contentPane = this.mDialog.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        gbl.columnWeights = new double[]{1.0};
        gbl.rowWeights = new double[]{1.0};
        contentPane.setLayout(gbl);
        int y = 0;
        final String path = "file://" + this.mGpxFile.path;
        String htmlContent = "<html><body><a href=''>" + path + "</a></body></html>";
        this.mContentDisplay = new JTextPane();
        this.mContentDisplay.setContentType("text/html");
        this.updateAnalysis();
        this.mContentDisplay.setEditable(false);
        this.mContentDisplay.setBackground(null);
        this.mContentDisplay.setBorder(null);
        JLabel articleLabel = new JLabel(htmlContent);
        articleLabel.setCursor(new Cursor(12));
        articleLabel.setToolTipText(title);
        articleLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI(path));
                }
                catch (IOException | URISyntaxException ex) {
                    ex.printStackTrace();
                }
            }
        });
        contentPane.add((Component)new JScrollPane(this.mContentDisplay), new GridBagConstraints(0, y++, 4, 1, 4.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mGraphPanel = new GraphPanel(new TreeMap<Long, Double>());
        this.updateGraphPanel();
        contentPane.add((Component)this.mGraphPanel, new GridBagConstraints(0, y++, 4, 1, 4.0, 10.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        contentPane.add((Component)articleLabel, new GridBagConstraints(0, y++, 4, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        final JButton adjustElevationButton = new JButton(this.mContext.getOffRoadString("offroad.adjust_elevation"));
        final JButton cancelElevationButton = new JButton(this.mContext.getOffRoadString("offroad.cancel_elevation"));
        cancelElevationButton.setEnabled(false);
        adjustElevationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ShowTrackDetailsAction.this.mContext.setWaitingCursor(true);
                        ShowTrackDetailsAction.this.mGraphPanel.setBackgroundColor(Color.LIGHT_GRAY);
                        ShowTrackDetailsAction.this.mGraphPanel.setDrawText(ShowTrackDetailsAction.this.mContext.getOffRoadString("offroad.Calculating"));
                        ShowTrackDetailsAction.this.mAdjustmentCancelled = false;
                        adjustElevationButton.setEnabled(false);
                        cancelElevationButton.setEnabled(true);
                        try {
                            ShowTrackDetailsAction.this.mElevationHelper.adjustElevations(ShowTrackDetailsAction.this, ShowTrackDetailsAction.this.mContext.getRenderer().getMetaInfoFiles());
                        }
                        finally {
                            adjustElevationButton.setEnabled(true);
                            cancelElevationButton.setEnabled(false);
                            ShowTrackDetailsAction.this.mContext.setWaitingCursor(false);
                            ShowTrackDetailsAction.this.updateAnalysis();
                            ShowTrackDetailsAction.this.updateGraphPanel();
                            ShowTrackDetailsAction.this.mGraphPanel.setDrawText(null);
                            ShowTrackDetailsAction.this.mGraphPanel.setBackgroundColor(Color.WHITE);
                        }
                    }
                }).start();
            }
        });
        cancelElevationButton.addActionListener(l -> {
            this.mAdjustmentCancelled = true;
        });
        contentPane.add((Component)adjustElevationButton, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        contentPane.add((Component)cancelElevationButton, new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JButton okButton = new JButton(this.mContext.getString(720));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                ShowTrackDetailsAction.this.disposeDialog();
            }
        });
        contentPane.add((Component)okButton, new GridBagConstraints(3, y++, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mDialog.getRootPane().setDefaultButton(okButton);
        this.mDialog.pack();
        this.decorateDialog();
        this.mDialog.setVisible(true);
    }

    public void updateAnalysis() {
        String content = "<table border='2'><thead><th>Key</th><th>Value</th></thead><tbody>";
        GPXUtilities.GPXTrackAnalysis analysis = this.mGpxFile.getAnalysis(System.currentTimeMillis());
        String inBrk = "</td><td align='right'>";
        if (analysis.isTimeSpecified()) {
            content = content + "<tr><td>" + this.mContext.getOffRoadString("startTime") + inBrk + this.toString(analysis.startTime) + "</td></tr>";
            content = content + "<tr><td>" + this.mContext.getOffRoadString("endTime") + inBrk + this.toString(analysis.endTime) + "</td></tr>";
            content = content + "<tr><td>" + this.mContext.getOffRoadString("timeSpan") + inBrk + this.toTimeString(analysis.timeSpan) + "</td></tr>";
        }
        if (analysis.isTimeMoving()) {
            content = content + "<tr><td>" + this.mContext.getOffRoadString("timeMoving") + inBrk + this.toTimeString(analysis.timeMoving) + "</td></tr>";
        }
        content = content + "<tr><td>" + this.mContext.getOffRoadString("totalDistance") + inBrk + this.toDist(analysis.totalDistance) + "</td></tr>";
        if (analysis.isTimeMoving()) {
            content = content + "<tr><td>" + this.mContext.getOffRoadString("totalDistanceMoving") + inBrk + this.toDist(analysis.totalDistanceMoving) + "</td></tr>";
        }
        content = content + "<tr><td>" + this.mContext.getOffRoadString("points") + inBrk + analysis.points + "</td></tr>";
        if (analysis.isSpeedSpecified()) {
            content = content + "<tr><td>" + this.mContext.getOffRoadString("avgSpeed") + inBrk + this.toVelocity(analysis.avgSpeed) + "</td></tr>";
            content = content + "<tr><td>" + this.mContext.getOffRoadString("maxSpeed") + inBrk + this.toVelocity(analysis.maxSpeed) + "</td></tr>";
        }
        if (analysis.isElevationSpecified()) {
            content = content + "<tr><td>" + this.mContext.getOffRoadString("minElevation") + inBrk + this.toDist(analysis.minElevation) + "</td></tr>";
            content = content + "<tr><td>" + this.mContext.getOffRoadString("maxElevation") + inBrk + this.toDist(analysis.maxElevation) + "</td></tr>";
            content = content + "<tr><td>" + this.mContext.getOffRoadString("diffElevation") + inBrk + this.toDist(analysis.maxElevation - analysis.minElevation) + "</td></tr>";
            content = content + "<tr><td>" + this.mContext.getOffRoadString("diffElevationUp") + inBrk + this.toDist(analysis.diffElevationUp) + "</td></tr>";
            content = content + "<tr><td>" + this.mContext.getOffRoadString("diffElevationDown") + inBrk + this.toDist(analysis.diffElevationDown) + "</td></tr>";
            content = content + "<tr><td>" + this.mContext.getOffRoadString("avgElevation") + inBrk + this.toDist(analysis.avgElevation) + "</td></tr>";
        }
        content = content + "</tbody></table";
        this.mContentDisplay.setText(content);
    }

    @Override
    public void updateGraphPanel() {
        TreeMap<Long, Double> elevation = new TreeMap<Long, Double>();
        List<GPXUtilities.TrkSegment> pts = this.mGpxFile.proccessPoints();
        for (GPXUtilities.TrkSegment n : pts) {
            for (GPXUtilities.WptPt pt : n.points) {
                elevation.put(pt.time, pt.ele);
            }
        }
        this.mGraphPanel.setScores(elevation);
    }

    private String toVelocity(float pValue) {
        return MessageFormat.format("{0,number,#.##} km/h", Float.valueOf(pValue));
    }

    private String toDist(double pValue) {
        return MessageFormat.format("{0,number,#} m", pValue);
    }

    private String toString(long pStartTime) {
        return DateFormat.getDateTimeInstance().format(pStartTime);
    }

    private String toTimeString(long pStartTime) {
        return DateFormat.getTimeInstance().format(pStartTime);
    }

    @Override
    public List<ElevationHelper.LatLonHolder> getPoints() {
        ArrayList<ElevationHelper.LatLonHolder> res = new ArrayList<ElevationHelper.LatLonHolder>();
        List<GPXUtilities.TrkSegment> pts = this.mGpxFile.proccessPoints();
        for (GPXUtilities.TrkSegment n : pts) {
            for (GPXUtilities.WptPt pt : n.points) {
                res.add(new WptHolder(pt));
            }
        }
        return res;
    }

    @Override
    public boolean isCancelled() {
        return this.mAdjustmentCancelled;
    }

    private static class WptHolder
    implements ElevationHelper.LatLonHolder {
        public GPXUtilities.WptPt mPt;

        public WptHolder(GPXUtilities.WptPt pPt) {
            this.mPt = pPt;
        }

        @Override
        public LatLon getLatLon() {
            return this.mPt.getLatLon();
        }

        @Override
        public double getLatitude() {
            return this.mPt.getLatitude();
        }

        @Override
        public double getLongitude() {
            return this.mPt.getLongitude();
        }

        @Override
        public void setElevation(double pEle1) {
            this.mPt.ele = pEle1;
        }

        @Override
        public double getElevation() {
            return this.mPt.ele;
        }
    }
}

