/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.SignatureUtils;

public class SvgString {
    private final String svg;
    private final double scale;

    public SvgString(String svg, double scale) {
        if (svg == null) {
            throw new IllegalArgumentException();
        }
        this.svg = svg;
        this.scale = scale;
    }

    public String getMD5Hex() {
        return SignatureUtils.getMD5Hex(this.svg);
    }

    public String getSvg(boolean raw) {
        String background;
        String style;
        int idx;
        String result = this.svg;
        if (raw) {
            return result;
        }
        if (result.startsWith("<?xml")) {
            idx = result.indexOf("<svg");
            result = result.substring(idx);
        }
        if (result.startsWith("<svg")) {
            idx = result.indexOf(">");
            result = "<svg>" + result.substring(idx + 1);
        }
        if ((style = this.extractSvgStyle()) != null && (background = this.extractBackground(style)) != null) {
            result = result.replaceFirst("<g>", "<g><rect fill=\"" + background + "\" style=\"" + style + "\" /> ");
        }
        if (!result.startsWith("<svg>")) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    private String extractBackground(String style) {
        Pattern p = Pattern.compile("background:([^;]+)");
        Matcher m = p.matcher(style);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private String extractSvgStyle() {
        Pattern p = Pattern.compile("(?i)\\<svg[^>]+style=\"([^\">]+)\"");
        Matcher m = p.matcher(this.svg);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public int getData(String name) {
        Pattern p = Pattern.compile("(?i)" + name + "\\W+(\\d+)");
        Matcher m = p.matcher(this.svg);
        if (m.find()) {
            String s = m.group(1);
            return Integer.parseInt(s);
        }
        throw new IllegalStateException("Cannot find " + name);
    }

    public double getScale() {
        return this.scale;
    }
}

