/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.list;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.protege.editor.core.ui.list.MList;
import org.protege.editor.core.ui.list.MListItem;

public class RemovableObjectList<O>
extends MList {
    private ListCellRenderer rendererDelegate;

    public RemovableObjectList() {
        super.setModel(new MutableObjectListModel());
        MList.MListCellRenderer ren = (MList.MListCellRenderer)this.getCellRenderer();
        ren.setContentRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = -4512962926323639137L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (RemovableObjectList.this.rendererDelegate != null) {
                    Object val = ((RemovableObjectListItem)value).getObject();
                    return RemovableObjectList.this.rendererDelegate.getListCellRendererComponent(list, val, index, isSelected, cellHasFocus);
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
    }

    public List<O> getListItems() {
        ArrayList result = new ArrayList();
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            result.add(((RemovableObjectListItem)this.getModel().getElementAt(i)).getObject());
        }
        return result;
    }

    @Override
    public void setCellRenderer(ListCellRenderer cellRenderer) {
        if (!(this.getCellRenderer() instanceof MList.MListCellRenderer)) {
            super.setCellRenderer(cellRenderer);
        } else {
            this.rendererDelegate = cellRenderer;
        }
    }

    public void setModel(ListModel model) {
        throw new RuntimeException("Cannot change model in MutableObjectList");
    }

    public void addObject(Collection<O> objects) {
        for (O o : objects) {
            ((MutableObjectListModel)this.getModel()).addElement(o);
        }
    }

    public void setListData(Object[] listData) {
        MutableObjectListModel model = (MutableObjectListModel)this.getModel();
        model.clear();
        for (Object o : listData) {
            model.addElement(o);
        }
    }

    public void setObjects(Collection<O> objects) {
        MutableObjectListModel model = (MutableObjectListModel)this.getModel();
        model.clear();
        for (O o : objects) {
            model.addElement(o);
        }
    }

    public O getSelectedValue() {
        RemovableObjectListItem item = (RemovableObjectListItem)super.getSelectedValue();
        if (item == null) {
            return null;
        }
        return item.getObject();
    }

    public O getSelectedObject() {
        return this.getSelectedValue();
    }

    public Collection<O> getSelectedObjects() {
        ArrayList objects = new ArrayList();
        for (Object o : this.getSelectedValues()) {
            Object sel = ((RemovableObjectListItem)o).getObject();
            objects.add(sel);
        }
        return objects;
    }

    @Override
    protected void handleDelete() {
        MListItem item = (MListItem)super.getSelectedValue();
        item.handleDelete();
    }

    private class MutableObjectListModel
    extends DefaultListModel {
        public void setElementAt(Object obj, int index) {
            super.setElementAt(new RemovableObjectListItem(obj), index);
        }

        public Object set(int index, Object element) {
            return super.set(index, new RemovableObjectListItem(element));
        }

        public void addElement(Object obj) {
            super.addElement(new RemovableObjectListItem(obj));
        }

        public void add(int index, Object element) {
            super.add(index, new RemovableObjectListItem(element));
        }
    }

    public class RemovableObjectListItem
    implements MListItem {
        private O object;

        public RemovableObjectListItem(O object) {
            this.object = object;
        }

        @Override
        public boolean isEditable() {
            return false;
        }

        @Override
        public void handleEdit() {
        }

        @Override
        public boolean isDeleteable() {
            return true;
        }

        public String toString() {
            return "LI: " + this.object.toString();
        }

        @Override
        public boolean handleDelete() {
            int index;
            MutableObjectListModel model = (MutableObjectListModel)RemovableObjectList.this.getModel();
            return model.remove(index = model.indexOf(this)) != null;
        }

        @Override
        public String getTooltip() {
            return this.object.toString();
        }

        public O getObject() {
            return this.object;
        }
    }
}

