/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.util.TableModelAdapter;

public class BeanListTableModel
extends TableModelAdapter
implements TableModelAdapter.RowExpansion,
TableModelAdapter.RowEditor {
    private ArrayList<PropertyDescriptor> properties;

    private static String[] getBeanColumns(List<Bean<?>> beans) {
        if (beans.isEmpty()) {
            return new String[0];
        }
        Collection<PropertyDescriptor> properties = beans.get(0).getProperties();
        String[] columns = new String[properties.size()];
        int i = 0;
        for (PropertyDescriptor prop : properties) {
            columns[i++] = prop.getName();
        }
        return columns;
    }

    private static Class<?>[] getBeanColumnClasses(List<Bean<?>> beans) {
        if (beans.isEmpty()) {
            return new Class[0];
        }
        Collection<PropertyDescriptor> properties = beans.get(0).getProperties();
        Class[] columns = new Class[properties.size()];
        int i = 0;
        for (PropertyDescriptor prop : properties) {
            columns[i++] = prop.getPropertyType();
        }
        return columns;
    }

    public BeanListTableModel(List<Bean<?>> beans) {
        super(BeanListTableModel.getBeanColumns(beans), BeanListTableModel.getBeanColumnClasses(beans));
        this.setRowExpansion(this);
        this.setRowEditor(this);
        this.properties = new ArrayList();
        if (!beans.isEmpty()) {
            this.properties.addAll(beans.get(0).getProperties());
        }
        this.setData(beans);
    }

    @Override
    public Object[] expand(Object row) {
        Bean bean = (Bean)Bean.class.cast(row);
        Object[] values = new Object[this.properties.size()];
        for (int i = 0; i < this.properties.size(); ++i) {
            values[i] = bean.getValue(this.properties.get(i).getName());
        }
        return values;
    }

    @Override
    public boolean isEditable(Object row, int index) {
        return false;
    }

    @Override
    public void setValue(Object row, int index, Object value) {
    }
}

