/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.util;

import com.jogamp.nativewindow.util.RectangleImmutable;
import java.util.List;

public class Rectangle
implements Cloneable,
RectangleImmutable {
    int x;
    int y;
    int width;
    int height;

    public Rectangle() {
        this(0, 0, 0, 0);
    }

    public Rectangle(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public Rectangle(RectangleImmutable rectangleImmutable) {
        this.set(rectangleImmutable);
    }

    public Object cloneMutable() {
        return this.clone();
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public final int getX() {
        return this.x;
    }

    @Override
    public final int getY() {
        return this.y;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    public final void set(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public final void set(Rectangle rectangle) {
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
    }

    public final void set(RectangleImmutable rectangleImmutable) {
        this.x = rectangleImmutable.getX();
        this.y = rectangleImmutable.getY();
        this.width = rectangleImmutable.getWidth();
        this.height = rectangleImmutable.getHeight();
    }

    public final void setX(int n) {
        this.x = n;
    }

    public final void setY(int n) {
        this.y = n;
    }

    public final void setWidth(int n) {
        this.width = n;
    }

    public final void setHeight(int n) {
        this.height = n;
    }

    @Override
    public final RectangleImmutable union(RectangleImmutable rectangleImmutable) {
        return this.union(rectangleImmutable.getX(), rectangleImmutable.getY(), rectangleImmutable.getX() + rectangleImmutable.getWidth(), rectangleImmutable.getY() + rectangleImmutable.getHeight());
    }

    @Override
    public final RectangleImmutable union(int n, int n2, int n3, int n4) {
        int n5 = Math.min(this.x, n);
        int n6 = Math.min(this.y, n2);
        int n7 = Math.max(this.x + this.width, n3);
        int n8 = Math.max(this.y + this.height, n4);
        return new Rectangle(n5, n6, n7 - n5, n8 - n6);
    }

    public final Rectangle union(List<RectangleImmutable> list) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (int i = list.size() - 1; i >= 0; --i) {
            RectangleImmutable rectangleImmutable = list.get(i);
            n = Math.min(n, rectangleImmutable.getX());
            n3 = Math.max(n3, rectangleImmutable.getX() + rectangleImmutable.getWidth());
            n2 = Math.min(n2, rectangleImmutable.getY());
            n4 = Math.max(n4, rectangleImmutable.getY() + rectangleImmutable.getHeight());
        }
        this.set(n, n2, n3 - n, n4 - n2);
        return this;
    }

    @Override
    public final RectangleImmutable intersection(RectangleImmutable rectangleImmutable) {
        return this.intersection(rectangleImmutable.getX(), rectangleImmutable.getY(), rectangleImmutable.getX() + rectangleImmutable.getWidth(), rectangleImmutable.getY() + rectangleImmutable.getHeight());
    }

    @Override
    public final RectangleImmutable intersection(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = Math.max(this.x, n);
        int n10 = Math.max(this.y, n2);
        int n11 = Math.min(this.x + this.width, n3);
        int n12 = Math.min(this.y + this.height, n4);
        if (n11 < n9) {
            n8 = 0;
            n7 = 0;
        } else {
            n8 = n9;
            n7 = n11 - n9;
        }
        if (n12 < n10) {
            n6 = 0;
            n5 = 0;
        } else {
            n6 = n10;
            n5 = n12 - n10;
        }
        return new Rectangle(n8, n6, n7, n5);
    }

    @Override
    public final float coverage(RectangleImmutable rectangleImmutable) {
        RectangleImmutable rectangleImmutable2 = this.intersection(rectangleImmutable);
        float f = rectangleImmutable2.getWidth() * rectangleImmutable2.getHeight();
        float f2 = this.width * this.height;
        return f / f2;
    }

    public final Rectangle scale(int n, int n2) {
        this.x *= n;
        this.y *= n2;
        this.width *= n;
        this.height *= n2;
        return this;
    }

    public final Rectangle scaleInv(int n, int n2) {
        this.x /= n;
        this.y /= n2;
        this.width /= n;
        this.height /= n2;
        return this;
    }

    @Override
    public int compareTo(RectangleImmutable rectangleImmutable) {
        int n = this.width * this.height;
        int n2 = rectangleImmutable.getWidth() * rectangleImmutable.getHeight();
        if (n > n2) {
            return 1;
        }
        if (n < n2) {
            return -1;
        }
        n = this.x * this.y;
        n2 = rectangleImmutable.getX() * rectangleImmutable.getY();
        if (n > n2) {
            return 1;
        }
        if (n < n2) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)object;
            return this.y == rectangle.y && this.x == rectangle.x && this.height == rectangle.height && this.width == rectangle.width;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = this.x + this.height;
        int n2 = this.width + this.y;
        int n3 = n * (n + 1) / 2 + this.x;
        int n4 = n2 * (n2 + 1) / 2 + this.y;
        int n5 = n3 + n4;
        return n5 * (n5 + 1) / 2 + n4;
    }

    public String toString() {
        return "[ " + this.x + " / " + this.y + "  " + this.width + " x " + this.height + " ]";
    }
}

