/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.option;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.option.OptionsParamView;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.WorkbenchPanel;
import org.zaproxy.zap.extension.brk.BreakpointsParam;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.TimeStampUtils;
import org.zaproxy.zap.utils.ZapNumberSpinner;
import org.zaproxy.zap.view.LayoutHelper;

public class OptionsViewPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private static final String TIME_STAMP_FORMAT_COMBOBOX_TOOL_TIP = Constant.messages.getString("options.display.timestamp.format.combobox.tooltip");
    private static final String TIME_STAMP_FORMAT_DATETIME = Constant.messages.getString("timestamp.format.datetime");
    private static final String TIME_STAMP_FORMAT_TIMEONLY = Constant.messages.getString("timestamp.format.timeonly");
    private static final String TIME_STAMP_FORMAT_ISO8601 = "yyyy-MM-dd'T'HH:mm:ssZ";
    private JPanel panelMisc = null;
    private JScrollPane mainScrollPane;
    private JCheckBox chkShowTabNames = null;
    private JCheckBox chkProcessImages = null;
    private JCheckBox chkShowMainToolbar = null;
    private JCheckBox chkAdvancedView = null;
    private JCheckBox chkAskOnExit = null;
    private JCheckBox chkWmUiHandling = null;
    private JCheckBox chkOutputTabTimeStamping = null;
    private JCheckBox chkShowSplashScreen = null;
    private JCheckBox scaleImages = null;
    private JCheckBox showLocalConnectRequestsCheckbox;
    private JComboBox<String> brkPanelViewSelect = null;
    private JComboBox<String> displaySelect = null;
    private JComboBox<ResponsePanelPositionUI> responsePanelPositionComboBox;
    private JComboBox<String> timeStampsFormatSelect = null;
    private JComboBox<LookAndFeelInfoUi> lookAndFeel = null;
    private ZapNumberSpinner largeRequestSize = null;
    private ZapNumberSpinner largeResponseSize = null;
    private JLabel brkPanelViewLabel = null;
    private JLabel advancedViewLabel = null;
    private JLabel wmUiHandlingLabel = null;
    private JLabel askOnExitLabel = null;
    private JLabel displayLabel = null;
    private JLabel showMainToolbarLabel = null;
    private JLabel processImagesLabel = null;
    private JLabel showTabNamesLabel = null;
    private JLabel outputTabTimeStampLabel = null;
    private JLabel outputTabTimeStampExampleLabel = null;
    private JLabel showSplashScreenLabel = null;
    private JLabel largeRequestLabel = null;
    private JLabel largeResponseLabel = null;
    private JLabel lookAndFeelLabel = null;
    private Map<FontUtils.FontType, JLabel> fontLabels = new EnumMap<FontUtils.FontType, JLabel>(FontUtils.FontType.class);
    private Map<FontUtils.FontType, ZapNumberSpinner> fontSizes = new EnumMap<FontUtils.FontType, ZapNumberSpinner>(FontUtils.FontType.class);
    private Map<FontUtils.FontType, JComboBox<String>> fontNames = new EnumMap<FontUtils.FontType, JComboBox<String>>(FontUtils.FontType.class);
    private Map<FontUtils.FontType, String> fontTypeLabels = new EnumMap<FontUtils.FontType, String>(FontUtils.FontType.class);

    public OptionsViewPanel() {
        this.fontTypeLabels.put(FontUtils.FontType.general, Constant.messages.getString("view.options.label.generalFont"));
        this.fontTypeLabels.put(FontUtils.FontType.workPanels, Constant.messages.getString("view.options.label.workPanelsFont"));
        for (FontUtils.FontType fontType : FontUtils.FontType.values()) {
            this.fontLabels.put(fontType, null);
            this.fontNames.put(fontType, null);
            this.fontSizes.put(fontType, null);
        }
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setName(Constant.messages.getString("view.options.title"));
        this.add(this.getMainScrollPane());
    }

    private JScrollPane getMainScrollPane() {
        if (this.mainScrollPane == null) {
            this.mainScrollPane = new JScrollPane();
            this.mainScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.mainScrollPane.setViewportView(this.getPanelMisc());
        }
        return this.mainScrollPane;
    }

    private JPanel getPanelMisc() {
        if (this.panelMisc == null) {
            this.panelMisc = new JPanel();
            this.panelMisc.setLayout(new GridBagLayout());
            if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
                this.panelMisc.setSize(114, 132);
            }
            this.displayLabel = new JLabel(Constant.messages.getString("view.options.label.display"));
            this.brkPanelViewLabel = new JLabel(Constant.messages.getString("view.options.label.brkPanelView"));
            this.advancedViewLabel = new JLabel(Constant.messages.getString("view.options.label.advancedview"));
            this.wmUiHandlingLabel = new JLabel(Constant.messages.getString("view.options.label.wmuihandler"));
            this.askOnExitLabel = new JLabel(Constant.messages.getString("view.options.label.askonexit"));
            this.showMainToolbarLabel = new JLabel(Constant.messages.getString("view.options.label.showMainToolbar"));
            this.processImagesLabel = new JLabel(Constant.messages.getString("view.options.label.processImages"));
            this.showTabNamesLabel = new JLabel(Constant.messages.getString("view.options.label.showTabNames"));
            this.outputTabTimeStampLabel = new JLabel(Constant.messages.getString("options.display.timestamp.format.outputtabtimestamps.label"));
            this.largeRequestLabel = new JLabel(Constant.messages.getString("view.options.label.largeRequestSize"));
            this.largeResponseLabel = new JLabel(Constant.messages.getString("view.options.label.largeResponseSize"));
            this.lookAndFeelLabel = new JLabel(Constant.messages.getString("view.options.label.lookandfeel"));
            this.outputTabTimeStampExampleLabel = new JLabel(TimeStampUtils.currentDefaultFormattedTimeStamp());
            this.showSplashScreenLabel = new JLabel(Constant.messages.getString("view.options.label.showSplashScreen"));
            int row = 0;
            this.displayLabel.setLabelFor(this.getDisplaySelect());
            this.panelMisc.add((Component)this.displayLabel, LayoutHelper.getGBC(0, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add(this.getDisplaySelect(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            JLabel responsePanelPositionLabel = new JLabel(Constant.messages.getString("view.options.label.responsepanelpos"));
            this.panelMisc.add((Component)responsePanelPositionLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add(this.getResponsePanelPositionComboBox(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.brkPanelViewLabel.setLabelFor(this.getBrkPanelViewSelect());
            this.panelMisc.add((Component)this.brkPanelViewLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add(this.getBrkPanelViewSelect(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.largeRequestLabel.setLabelFor(this.getLargeRequestSize());
            this.panelMisc.add((Component)this.largeRequestLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getLargeRequestSize(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.largeResponseLabel.setLabelFor(this.getLargeResponseSize());
            this.panelMisc.add((Component)this.largeResponseLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getLargeResponseSize(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.advancedViewLabel.setLabelFor(this.getChkAdvancedView());
            this.panelMisc.add((Component)this.advancedViewLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getChkAdvancedView(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.wmUiHandlingLabel.setLabelFor(this.getChkWmUiHandling());
            this.panelMisc.add((Component)this.wmUiHandlingLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getChkWmUiHandling(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.askOnExitLabel.setLabelFor(this.getChkAskOnExit());
            this.panelMisc.add((Component)this.askOnExitLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getChkAskOnExit(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.showMainToolbarLabel.setLabelFor(this.getChkShowMainToolbar());
            this.panelMisc.add((Component)this.showMainToolbarLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getChkShowMainToolbar(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.processImagesLabel.setLabelFor(this.getChkProcessImages());
            this.panelMisc.add((Component)this.processImagesLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getChkProcessImages(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            Insets insets = new Insets(2, 2, 2, 2);
            String labelText = Constant.messages.getString("view.options.label.showlocalconnectrequests");
            JLabel showConnectRequestLabel = new JLabel(labelText);
            showConnectRequestLabel.setLabelFor(this.getShowLocalConnectRequestsCheckbox());
            this.panelMisc.add((Component)showConnectRequestLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, insets));
            this.panelMisc.add((Component)this.getShowLocalConnectRequestsCheckbox(), LayoutHelper.getGBC(1, row, 1, 1.0, insets));
            this.showTabNamesLabel.setLabelFor(this.getShowTabNames());
            this.panelMisc.add((Component)this.showTabNamesLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getShowTabNames(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.showSplashScreenLabel.setLabelFor(this.getShowSplashScreen());
            this.panelMisc.add((Component)this.showSplashScreenLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getShowSplashScreen(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.outputTabTimeStampLabel.setLabelFor(this.getChkOutputTabTimeStamps());
            this.panelMisc.add((Component)this.outputTabTimeStampLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getChkOutputTabTimeStamps(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.outputTabTimeStampExampleLabel.setLabelFor(this.getTimeStampsFormatSelect());
            this.panelMisc.add(this.getTimeStampsFormatSelect(), LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.outputTabTimeStampExampleLabel, LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            for (FontUtils.FontType fontType : FontUtils.FontType.values()) {
                JPanel fontsPanel = new JPanel();
                fontsPanel.setLayout(new GridBagLayout());
                fontsPanel.setBorder(BorderFactory.createTitledBorder(null, this.fontTypeLabels.get((Object)fontType), 0, 0, FontUtils.getFont(FontUtils.Size.standard)));
                this.panelMisc.add((Component)fontsPanel, LayoutHelper.getGBC(0, ++row, 2, 1.0, new Insets(2, 2, 2, 2)));
                JLabel fontNameLabel = new JLabel(Constant.messages.getString("view.options.label.fontName"));
                fontNameLabel.setLabelFor(this.getFontName(fontType));
                fontsPanel.add((Component)fontNameLabel, LayoutHelper.getGBC(0, 1, 1, 1.0, new Insets(2, 2, 2, 2)));
                fontsPanel.add(this.getFontName(fontType), LayoutHelper.getGBC(1, 1, 1, 1.0, new Insets(2, 2, 2, 2)));
                JLabel fontSizeLabel = new JLabel(Constant.messages.getString("view.options.label.fontSize"));
                fontSizeLabel.setLabelFor(this.getFontSize(fontType));
                fontsPanel.add((Component)fontSizeLabel, LayoutHelper.getGBC(0, 2, 1, 1.0, new Insets(2, 2, 2, 2)));
                fontsPanel.add((Component)this.getFontSize(fontType), LayoutHelper.getGBC(1, 2, 1, 1.0, new Insets(2, 2, 2, 2)));
                JLabel fontExampleLabel = new JLabel(Constant.messages.getString("view.options.label.fontExample"));
                fontExampleLabel.setLabelFor(this.getFontExampleLabel(fontType));
                fontsPanel.add((Component)fontExampleLabel, LayoutHelper.getGBC(0, 3, 1, 1.0, new Insets(2, 2, 2, 2)));
                fontsPanel.add((Component)this.getFontExampleLabel(fontType), LayoutHelper.getGBC(1, 3, 1, 1.0, new Insets(2, 2, 2, 2)));
            }
            JLabel scaleImagesLabel = new JLabel(Constant.messages.getString("view.options.label.scaleImages"));
            scaleImagesLabel.setLabelFor(this.getScaleImages());
            this.panelMisc.add((Component)scaleImagesLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getScaleImages(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.lookAndFeelLabel.setLabelFor(this.getLookAndFeelSelect());
            this.panelMisc.add((Component)this.lookAndFeelLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add(this.getLookAndFeelSelect(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)new JLabel(""), LayoutHelper.getGBC(0, ++row, 1, 1.0, 1.0));
        }
        return this.panelMisc;
    }

    private JCheckBox getShowTabNames() {
        if (this.chkShowTabNames == null) {
            this.chkShowTabNames = new JCheckBox();
            this.chkShowTabNames.setVerticalAlignment(1);
            this.chkShowTabNames.setVerticalTextPosition(1);
        }
        return this.chkShowTabNames;
    }

    private JCheckBox getShowSplashScreen() {
        if (this.chkShowSplashScreen == null) {
            this.chkShowSplashScreen = new JCheckBox();
            this.chkShowSplashScreen.setVerticalAlignment(1);
            this.chkShowSplashScreen.setVerticalTextPosition(1);
        }
        return this.chkShowSplashScreen;
    }

    private JCheckBox getChkProcessImages() {
        if (this.chkProcessImages == null) {
            this.chkProcessImages = new JCheckBox();
            this.chkProcessImages.setVerticalAlignment(1);
            this.chkProcessImages.setVerticalTextPosition(1);
        }
        return this.chkProcessImages;
    }

    private JCheckBox getChkShowMainToolbar() {
        if (this.chkShowMainToolbar == null) {
            this.chkShowMainToolbar = new JCheckBox();
            this.chkShowMainToolbar.setVerticalAlignment(1);
            this.chkShowMainToolbar.setVerticalTextPosition(1);
        }
        return this.chkShowMainToolbar;
    }

    private JCheckBox getChkWmUiHandling() {
        if (this.chkWmUiHandling == null) {
            this.chkWmUiHandling = new JCheckBox();
            this.chkWmUiHandling.setVerticalAlignment(1);
            this.chkWmUiHandling.setVerticalTextPosition(1);
        }
        return this.chkWmUiHandling;
    }

    private JCheckBox getChkAskOnExit() {
        if (this.chkAskOnExit == null) {
            this.chkAskOnExit = new JCheckBox();
            this.chkAskOnExit.setVerticalAlignment(1);
            this.chkAskOnExit.setVerticalTextPosition(1);
        }
        return this.chkAskOnExit;
    }

    private JComboBox<String> getDisplaySelect() {
        if (this.displaySelect == null) {
            this.displaySelect = new JComboBox();
            this.displaySelect.addItem(Constant.messages.getString("view.options.label.display.left"));
            this.displaySelect.addItem(Constant.messages.getString("view.options.label.display.bottom"));
            this.displaySelect.addItem(Constant.messages.getString("view.options.label.display.full"));
        }
        return this.displaySelect;
    }

    private JComboBox<ResponsePanelPositionUI> getResponsePanelPositionComboBox() {
        if (this.responsePanelPositionComboBox == null) {
            this.responsePanelPositionComboBox = new JComboBox();
            this.responsePanelPositionComboBox.addItem(new ResponsePanelPositionUI(Constant.messages.getString("view.options.label.responsepanelpos.tabs"), WorkbenchPanel.ResponsePanelPosition.TABS_SIDE_BY_SIDE));
            this.responsePanelPositionComboBox.addItem(new ResponsePanelPositionUI(Constant.messages.getString("view.options.label.responsepanelpos.tabSideBySide"), WorkbenchPanel.ResponsePanelPosition.TAB_SIDE_BY_SIDE));
            this.responsePanelPositionComboBox.addItem(new ResponsePanelPositionUI(Constant.messages.getString("view.options.label.responsepanelpos.sideBySide"), WorkbenchPanel.ResponsePanelPosition.PANELS_SIDE_BY_SIDE));
            this.responsePanelPositionComboBox.addItem(new ResponsePanelPositionUI(Constant.messages.getString("view.options.label.responsepanelpos.above"), WorkbenchPanel.ResponsePanelPosition.PANEL_ABOVE));
        }
        return this.responsePanelPositionComboBox;
    }

    private JComboBox<String> getBrkPanelViewSelect() {
        if (this.brkPanelViewSelect == null) {
            this.brkPanelViewSelect = new JComboBox();
            this.brkPanelViewSelect.addItem(Constant.messages.getString("view.options.label.brkPanelView.toolbaronly"));
            this.brkPanelViewSelect.addItem(Constant.messages.getString("view.options.label.brkPanelView.breakonly"));
            this.brkPanelViewSelect.addItem(Constant.messages.getString("view.options.label.brkPanelView.both"));
        }
        return this.brkPanelViewSelect;
    }

    private JCheckBox getChkAdvancedView() {
        if (this.chkAdvancedView == null) {
            this.chkAdvancedView = new JCheckBox();
            this.chkAdvancedView.setVerticalAlignment(1);
            this.chkAdvancedView.setVerticalTextPosition(1);
        }
        return this.chkAdvancedView;
    }

    private JCheckBox getChkOutputTabTimeStamps() {
        if (this.chkOutputTabTimeStamping == null) {
            this.chkOutputTabTimeStamping = new JCheckBox();
            this.chkOutputTabTimeStamping.setVerticalAlignment(1);
            this.chkOutputTabTimeStamping.setVerticalTextPosition(1);
            this.chkOutputTabTimeStamping.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    OptionsViewPanel.this.timeStampsFormatSelect.setEnabled(e.getStateChange() == 1);
                }
            });
        }
        return this.chkOutputTabTimeStamping;
    }

    private JComboBox<String> getTimeStampsFormatSelect() {
        if (this.timeStampsFormatSelect == null) {
            String[] timeStampFormatStrings = new String[]{TIME_STAMP_FORMAT_DATETIME, TIME_STAMP_FORMAT_ISO8601, TIME_STAMP_FORMAT_TIMEONLY};
            this.timeStampsFormatSelect = new JComboBox<String>(timeStampFormatStrings);
            this.timeStampsFormatSelect.setToolTipText(TIME_STAMP_FORMAT_COMBOBOX_TOOL_TIP);
            this.timeStampsFormatSelect.setSelectedItem(this.getTimeStampsFormatSelect().getSelectedItem());
            this.timeStampsFormatSelect.setEditable(true);
            if (this.chkOutputTabTimeStamping.isSelected()) {
                this.timeStampsFormatSelect.setEnabled(true);
            } else {
                this.timeStampsFormatSelect.setEnabled(false);
            }
            this.timeStampsFormatSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String selectedDateFormat = (String)OptionsViewPanel.this.getTimeStampsFormatSelect().getSelectedItem();
                    OptionsViewPanel.this.outputTabTimeStampExampleLabel.setText(TimeStampUtils.currentFormattedTimeStamp(selectedDateFormat));
                }
            });
        }
        return this.timeStampsFormatSelect;
    }

    private JCheckBox getShowLocalConnectRequestsCheckbox() {
        if (this.showLocalConnectRequestsCheckbox == null) {
            this.showLocalConnectRequestsCheckbox = new JCheckBox();
        }
        return this.showLocalConnectRequestsCheckbox;
    }

    private ZapNumberSpinner getLargeRequestSize() {
        if (this.largeRequestSize == null) {
            this.largeRequestSize = new ZapNumberSpinner(-1, 100000, Integer.MAX_VALUE);
        }
        return this.largeRequestSize;
    }

    private ZapNumberSpinner getLargeResponseSize() {
        if (this.largeResponseSize == null) {
            this.largeResponseSize = new ZapNumberSpinner(-1, 100000, Integer.MAX_VALUE);
        }
        return this.largeResponseSize;
    }

    private ZapNumberSpinner initFontSize(final FontUtils.FontType fontType) {
        ZapNumberSpinner fontSize = new ZapNumberSpinner(-1, 8, 100);
        if (!FontUtils.canChangeSize()) {
            fontSize.setEnabled(false);
        }
        fontSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                OptionsViewPanel.this.setExampleFont(fontType);
            }
        });
        return fontSize;
    }

    private ZapNumberSpinner getFontSize(FontUtils.FontType fontType) {
        if (this.fontSizes.get((Object)fontType) == null) {
            this.fontSizes.put(fontType, this.initFontSize(fontType));
        }
        return this.fontSizes.get((Object)fontType);
    }

    private void setExampleFont(FontUtils.FontType fontType) {
        String name = this.getFontName(fontType).getSelectedItem() == null ? "" : (String)this.getFontName(fontType).getSelectedItem();
        Font font = FontUtils.getFont(name);
        int size = this.getFontSize(fontType).getValue();
        if (size == -1) {
            size = FontUtils.getSystemDefaultFont().getSize();
        }
        this.getFontExampleLabel(fontType).setFont(font.deriveFont((float)size));
    }

    private JComboBox<String> initFontName(final FontUtils.FontType fontType) {
        JComboBox<String> fontName = new JComboBox<String>();
        fontName.setRenderer(new JComboBoxFontRenderer());
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        fontName.addItem(" ");
        for (String font : fonts) {
            fontName.addItem(font);
        }
        if (!FontUtils.canChangeSize()) {
            fontName.setEnabled(false);
        }
        fontName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsViewPanel.this.setExampleFont(fontType);
            }
        });
        return fontName;
    }

    private JComboBox<String> getFontName(FontUtils.FontType fontType) {
        if (this.fontNames.get((Object)fontType) == null) {
            this.fontNames.put(fontType, this.initFontName(fontType));
        }
        return this.fontNames.get((Object)fontType);
    }

    private JLabel getFontExampleLabel(FontUtils.FontType fontType) {
        if (this.fontLabels.get((Object)fontType) == null) {
            this.fontLabels.put(fontType, new JLabel(Constant.messages.getString("view.options.label.exampleText")));
            this.fontLabels.get((Object)fontType).setBorder(BorderFactory.createLineBorder(Color.BLACK));
        }
        return this.fontLabels.get((Object)fontType);
    }

    private JCheckBox getScaleImages() {
        if (this.scaleImages == null) {
            this.scaleImages = new JCheckBox();
            if (!FontUtils.canChangeSize()) {
                this.scaleImages.setEnabled(false);
            }
        }
        return this.scaleImages;
    }

    private JComboBox<LookAndFeelInfoUi> getLookAndFeelSelect() {
        if (this.lookAndFeel == null) {
            this.lookAndFeel = new JComboBox();
            this.lookAndFeel.setMaximumRowCount(5);
            UIManager.LookAndFeelInfo[] looks = UIManager.getInstalledLookAndFeels();
            this.lookAndFeel.addItem(new LookAndFeelInfoUi(OptionsParamView.DEFAULT_LOOK_AND_FEEL));
            for (UIManager.LookAndFeelInfo look : looks) {
                this.lookAndFeel.addItem(new LookAndFeelInfoUi(look));
            }
        }
        return this.lookAndFeel;
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam options = (OptionsParam)obj;
        this.getShowTabNames().setSelected(options.getViewParam().getShowTabNames());
        this.getShowSplashScreen().setSelected(options.getViewParam().isShowSplashScreen());
        this.getChkProcessImages().setSelected(options.getViewParam().getProcessImages() > 0);
        this.displaySelect.setSelectedIndex(options.getViewParam().getDisplayOption());
        String panelPosition = options.getViewParam().getResponsePanelPosition();
        OptionsViewPanel.selectItem(this.getResponsePanelPositionComboBox(), item -> item.getPosition().name().equals(panelPosition));
        this.brkPanelViewSelect.setSelectedIndex(options.getViewParam().getBrkPanelViewOption());
        this.getChkShowMainToolbar().setSelected(options.getViewParam().isShowMainToolbar());
        this.chkAdvancedView.setSelected(options.getViewParam().getAdvancedViewOption() > 0);
        this.chkAskOnExit.setSelected(options.getViewParam().getAskOnExitOption() > 0);
        this.chkWmUiHandling.setSelected(options.getViewParam().getWmUiHandlingOption() > 0);
        this.getChkOutputTabTimeStamps().setSelected(options.getViewParam().isOutputTabTimeStampingEnabled());
        this.timeStampsFormatSelect.setSelectedItem(options.getViewParam().getOutputTabTimeStampsFormat());
        this.getShowLocalConnectRequestsCheckbox().setSelected(options.getViewParam().isShowLocalConnectRequests());
        this.largeRequestSize.setValue(options.getViewParam().getLargeRequestSize());
        this.largeResponseSize.setValue(options.getViewParam().getLargeResponseSize());
        for (FontUtils.FontType fontType : FontUtils.FontType.values()) {
            this.getFontSize(fontType).setValue(options.getViewParam().getFontSize(fontType));
            this.getFontName(fontType).setSelectedItem(options.getViewParam().getFontName(fontType));
        }
        this.getScaleImages().setSelected(options.getViewParam().isScaleImages());
        String nameLaf = options.getViewParam().getLookAndFeelInfo().getName();
        OptionsViewPanel.selectItem(this.getLookAndFeelSelect(), item -> item.getLookAndFeelInfo().getName().equals(nameLaf));
    }

    private static <T> void selectItem(JComboBox<T> comboBox, Predicate<T> predicate) {
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            T item = comboBox.getItemAt(i);
            if (!predicate.test(item)) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
        if (comboBox.getSelectedIndex() == -1) {
            comboBox.setSelectedIndex(0);
        }
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam options = (OptionsParam)obj;
        options.getViewParam().setShowTabNames(this.getShowTabNames().isSelected());
        options.getViewParam().setShowSplashScreen(this.getShowSplashScreen().isSelected());
        options.getViewParam().setProcessImages(this.getChkProcessImages().isSelected() ? 1 : 0);
        options.getViewParam().setDisplayOption(this.displaySelect.getSelectedIndex());
        ResponsePanelPositionUI selectedItem = (ResponsePanelPositionUI)this.getResponsePanelPositionComboBox().getSelectedItem();
        options.getViewParam().setResponsePanelPosition(selectedItem.getPosition().name());
        options.getViewParam().setBrkPanelViewOption(this.brkPanelViewSelect.getSelectedIndex());
        if (this.brkPanelViewSelect.getSelectedIndex() == BreakLocation.TOOL_BAR_ONLY.getValue()) {
            options.getParamSet(BreakpointsParam.class).setShowIgnoreFilesButtons(false);
        }
        options.getViewParam().setShowMainToolbar(this.getChkShowMainToolbar().isSelected());
        options.getViewParam().setAdvancedViewOption(this.getChkAdvancedView().isSelected() ? 1 : 0);
        options.getViewParam().setAskOnExitOption(this.getChkAskOnExit().isSelected() ? 1 : 0);
        options.getViewParam().setWmUiHandlingOption(this.getChkWmUiHandling().isSelected() ? 1 : 0);
        options.getViewParam().setOutputTabTimeStampingEnabled(this.getChkOutputTabTimeStamps().isSelected());
        options.getViewParam().setOutputTabTimeStampsFormat((String)this.getTimeStampsFormatSelect().getSelectedItem());
        options.getViewParam().setShowLocalConnectRequests(this.getShowLocalConnectRequestsCheckbox().isSelected());
        options.getViewParam().setLargeRequestSize(this.getLargeRequestSize().getValue());
        options.getViewParam().setLargeResponseSize(this.getLargeResponseSize().getValue());
        for (FontUtils.FontType fontType : FontUtils.FontType.values()) {
            options.getViewParam().setFontSize(fontType, this.getFontSize(fontType).getValue());
            options.getViewParam().setFontName(fontType, (String)this.getFontName(fontType).getSelectedItem());
        }
        options.getViewParam().setScaleImages(this.getScaleImages().isSelected());
        options.getViewParam().setLookAndFeelInfo(((LookAndFeelInfoUi)this.getLookAndFeelSelect().getSelectedItem()).getLookAndFeelInfo());
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.view";
    }

    private static class LookAndFeelInfoUi {
        private final UIManager.LookAndFeelInfo lookAndFeelInfo;

        LookAndFeelInfoUi(UIManager.LookAndFeelInfo lookAndFeelInfo) {
            this.lookAndFeelInfo = lookAndFeelInfo;
        }

        UIManager.LookAndFeelInfo getLookAndFeelInfo() {
            return this.lookAndFeelInfo;
        }

        public String toString() {
            return this.lookAndFeelInfo.getName();
        }
    }

    private static class ResponsePanelPositionUI {
        private final String name;
        private final WorkbenchPanel.ResponsePanelPosition position;

        public ResponsePanelPositionUI(String name, WorkbenchPanel.ResponsePanelPosition position) {
            this.name = name;
            this.position = position;
        }

        public WorkbenchPanel.ResponsePanelPosition getPosition() {
            return this.position;
        }

        public String toString() {
            return this.name;
        }
    }

    private class JComboBoxFontRenderer
    extends BasicComboBoxRenderer {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        private JComboBoxFontRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Font font = FontUtils.getFont((String)value);
            if (font != null) {
                renderer.setFont(FontUtils.getFont((String)value));
            } else {
                renderer.setFont(FontUtils.getFont(FontUtils.Size.standard));
            }
            return renderer;
        }
    }

    public static enum BreakLocation {
        TOOL_BAR_ONLY(0),
        BREAK_ONLY(1),
        BREAK_PANEL_AND_TOOL_BAR(2);

        private final int value;

        private BreakLocation(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

