/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u001a'\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000b\u00a2\u0006\u0002\u0010\f\u001a\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b\u001a$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b\u001a\u001d\u0010\u0012\u001a\u0004\u0018\u0001H\b\"\u0004\b\u0000\u0010\b*\b\u0012\u0004\u0012\u0002H\b0\u0013\u00a2\u0006\u0002\u0010\u0014\u001a\u0012\u0010\u0015\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001\u001a\u0012\u0010\u0017\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001\u001a\u0012\u0010\u0018\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0001\u001a\u0012\u0010\u001a\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0001\u00a8\u0006\u001b"}, d2={"nTabs", "", "amount", "", "parseSpaceSeparatedArgs", "", "argsString", "printMillisec", "T", "message", "body", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "profile", "", "profileIf", "condition", "", "getValueOrNull", "Lkotlin/Lazy;", "(Lkotlin/Lazy;)Ljava/lang/Object;", "prefixBaseNameIfNot", "prefix", "prefixIfNot", "removeSuffixIfPresent", "suffix", "suffixIfNot", "kotlin-util-io"})
public final class UtilKt {
    public static final <T> T printMillisec(@NotNull String message2, @NotNull Function0<? extends T> body2) {
        Intrinsics.checkNotNullParameter(message2, "message");
        Intrinsics.checkNotNullParameter(body2, "body");
        T result2 = null;
        boolean $i$f$measureTimeMillis = false;
        boolean bl = false;
        long start$iv = System.currentTimeMillis();
        boolean bl2 = false;
        result2 = body2.invoke();
        long msec = System.currentTimeMillis() - start$iv;
        String string2 = message2 + ": " + msec + " msec";
        bl = false;
        System.out.println((Object)string2);
        return result2;
    }

    public static final void profile(@NotNull String message2, @NotNull Function0<Unit> body2) {
        Intrinsics.checkNotNullParameter(message2, "message");
        Intrinsics.checkNotNullParameter(body2, "body");
        String string2 = System.getProperty("konan.profile");
        UtilKt.profileIf(string2 != null ? string2.equals("true") : false, message2, body2);
    }

    public static final void profileIf(boolean condition, @NotNull String message2, @NotNull Function0<Unit> body2) {
        Intrinsics.checkNotNullParameter(message2, "message");
        Intrinsics.checkNotNullParameter(body2, "body");
        if (condition) {
            UtilKt.printMillisec(message2, body2);
        } else {
            body2.invoke();
        }
    }

    @NotNull
    public static final String nTabs(int amount) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "%1$-" + (amount + 1) * 4 + 's';
        Object[] objectArray = new Object[]{""};
        boolean bl = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "java.lang.String.format(format, *args)");
        return string3;
    }

    @NotNull
    public static final String prefixIfNot(@NotNull String $this$prefixIfNot, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter($this$prefixIfNot, "$this$prefixIfNot");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        return StringsKt.startsWith$default($this$prefixIfNot, prefix, false, 2, null) ? $this$prefixIfNot : prefix + $this$prefixIfNot;
    }

    @NotNull
    public static final String prefixBaseNameIfNot(@NotNull String $this$prefixBaseNameIfNot, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter($this$prefixBaseNameIfNot, "$this$prefixBaseNameIfNot");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        File file2 = new File($this$prefixBaseNameIfNot).getAbsoluteFile();
        String name = file2.getName();
        String directory = file2.getParent();
        return directory + '/' + UtilKt.prefixIfNot(name, prefix);
    }

    @NotNull
    public static final String suffixIfNot(@NotNull String $this$suffixIfNot, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter($this$suffixIfNot, "$this$suffixIfNot");
        Intrinsics.checkNotNullParameter(suffix, "suffix");
        return StringsKt.endsWith$default($this$suffixIfNot, suffix, false, 2, null) ? $this$suffixIfNot : $this$suffixIfNot + suffix;
    }

    @NotNull
    public static final String removeSuffixIfPresent(@NotNull String $this$removeSuffixIfPresent, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter($this$removeSuffixIfPresent, "$this$removeSuffixIfPresent");
        Intrinsics.checkNotNullParameter(suffix, "suffix");
        return StringsKt.endsWith$default($this$removeSuffixIfPresent, suffix, false, 2, null) ? StringsKt.dropLast($this$removeSuffixIfPresent, suffix.length()) : $this$removeSuffixIfPresent;
    }

    @Nullable
    public static final <T> T getValueOrNull(@NotNull Lazy<? extends T> $this$getValueOrNull) {
        Intrinsics.checkNotNullParameter($this$getValueOrNull, "$this$getValueOrNull");
        return $this$getValueOrNull.isInitialized() ? (T)$this$getValueOrNull.getValue() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> parseSpaceSeparatedArgs(@NotNull String argsString) {
        void currentCharSequence;
        Intrinsics.checkNotNullParameter(argsString, "argsString");
        boolean bl = false;
        List parsedArgs = new ArrayList();
        boolean inQuotes = false;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = new StringBuilder();
        Function1<Boolean, Unit> $fun$saveArg$1 = new Function1<Boolean, Unit>((Ref.ObjectRef)currentCharSequence, parsedArgs){
            final /* synthetic */ Ref.ObjectRef $currentCharSequence;
            final /* synthetic */ List $parsedArgs;

            public final void invoke(boolean wasInQuotes) {
                block3: {
                    block2: {
                        if (wasInQuotes) break block2;
                        CharSequence charSequence = (StringBuilder)this.$currentCharSequence.element;
                        boolean bl = false;
                        if (!(!StringsKt.isBlank(charSequence))) break block3;
                    }
                    String string2 = ((StringBuilder)this.$currentCharSequence.element).toString();
                    Intrinsics.checkNotNullExpressionValue(string2, "currentCharSequence.toString()");
                    this.$parsedArgs.add(string2);
                    this.$currentCharSequence.element = new StringBuilder();
                }
            }
            {
                this.$currentCharSequence = objectRef;
                this.$parsedArgs = list2;
                super(1);
            }
        };
        CharSequence $this$forEach$iv = argsString;
        boolean $i$f$forEach = false;
        CharSequence charSequence = $this$forEach$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            char element$iv;
            char c = element$iv = charSequence.charAt(i);
            boolean bl2 = false;
            if (c == '\"') {
                boolean bl3 = inQuotes = !inQuotes;
                if (inQuotes) continue;
                $fun$saveArg$1.invoke(true);
                continue;
            }
            if (CharsKt.isWhitespace(c) && !inQuotes) {
                $fun$saveArg$1.invoke(false);
                continue;
            }
            ((StringBuilder)currentCharSequence.element).append(c);
        }
        if (inQuotes) {
            String string2 = "No close-quote was found in " + (StringBuilder)currentCharSequence.element + '.';
            boolean bl4 = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        $fun$saveArg$1.invoke(false);
        return parsedArgs;
    }
}

