/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEGImageReader;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

class JPEGBuffer {
    private boolean debug = false;
    final int BUFFER_SIZE = 4096;
    byte[] buf = new byte[4096];
    int bufAvail = 0;
    int bufPtr = 0;
    ImageInputStream iis;

    JPEGBuffer(ImageInputStream iis) {
        this.iis = iis;
    }

    void loadBuf(int count) throws IOException {
        if (this.debug) {
            System.out.print("loadbuf called with ");
            System.out.print("count " + count + ", ");
            System.out.println("bufAvail " + this.bufAvail + ", ");
        }
        if (count != 0 ? this.bufAvail >= count : this.bufAvail == 4096) {
            return;
        }
        if (this.bufAvail > 0 && this.bufAvail < 4096) {
            System.arraycopy(this.buf, this.bufPtr, this.buf, 0, this.bufAvail);
        }
        int ret = this.iis.read(this.buf, this.bufAvail, this.buf.length - this.bufAvail);
        if (this.debug) {
            System.out.println("iis.read returned " + ret);
        }
        if (ret != -1) {
            this.bufAvail += ret;
        }
        this.bufPtr = 0;
        int minimum = Math.min(4096, count);
        if (this.bufAvail < minimum) {
            throw new IIOException("Image Format Error");
        }
    }

    void readData(byte[] data) throws IOException {
        int count = data.length;
        if (this.bufAvail >= count) {
            System.arraycopy(this.buf, this.bufPtr, data, 0, count);
            this.bufAvail -= count;
            this.bufPtr += count;
            return;
        }
        int offset = 0;
        if (this.bufAvail > 0) {
            System.arraycopy(this.buf, this.bufPtr, data, 0, this.bufAvail);
            offset = this.bufAvail;
            count -= this.bufAvail;
            this.bufAvail = 0;
            this.bufPtr = 0;
        }
        if (this.iis.read(data, offset, count) != count) {
            throw new IIOException("Image format Error");
        }
    }

    void skipData(int count) throws IOException {
        if (this.bufAvail >= count) {
            this.bufAvail -= count;
            this.bufPtr += count;
            return;
        }
        if (this.bufAvail > 0) {
            count -= this.bufAvail;
            this.bufAvail = 0;
            this.bufPtr = 0;
        }
        if (this.iis.skipBytes(count) != count) {
            throw new IIOException("Image format Error");
        }
    }

    void pushBack() throws IOException {
        this.iis.seek(this.iis.getStreamPosition() - (long)this.bufAvail);
        this.bufAvail = 0;
        this.bufPtr = 0;
    }

    long getStreamPosition() throws IOException {
        return this.iis.getStreamPosition() - (long)this.bufAvail;
    }

    boolean scanForFF(JPEGImageReader reader) throws IOException {
        boolean retval = false;
        boolean foundFF = false;
        while (!foundFF) {
            while (this.bufAvail > 0) {
                if ((this.buf[this.bufPtr++] & 0xFF) == 255) {
                    --this.bufAvail;
                    foundFF = true;
                    break;
                }
                --this.bufAvail;
            }
            this.loadBuf(0);
            if (foundFF) {
                while (this.bufAvail > 0 && (this.buf[this.bufPtr] & 0xFF) == 255) {
                    ++this.bufPtr;
                    --this.bufAvail;
                }
            }
            if (this.bufAvail != 0) continue;
            retval = true;
            this.buf[0] = -39;
            this.bufAvail = 1;
            this.bufPtr = 0;
            foundFF = true;
        }
        return retval;
    }

    void print(int count) {
        System.out.print("buffer has ");
        System.out.print(this.bufAvail);
        System.out.println(" bytes available");
        if (this.bufAvail < count) {
            count = this.bufAvail;
        }
        int ptr = this.bufPtr;
        while (count > 0) {
            int val = this.buf[ptr++] & 0xFF;
            System.out.print(" " + Integer.toHexString(val));
            --count;
        }
        System.out.println();
    }
}

