/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Arrays;

class WhitespaceBasedBreakIterator
extends BreakIterator {
    private char[] text = new char[0];
    private int[] breaks = new int[]{0};
    private int pos = 0;

    WhitespaceBasedBreakIterator() {
    }

    @Override
    public void setText(CharacterIterator ci) {
        int begin = ci.getBeginIndex();
        this.text = new char[ci.getEndIndex() - begin];
        int[] breaks0 = new int[this.text.length + 1];
        int brIx = 0;
        breaks0[brIx++] = begin;
        int charIx = 0;
        boolean inWs = false;
        char c = ci.first();
        while (c != '\uffff') {
            this.text[charIx] = c;
            boolean ws = Character.isWhitespace(c);
            if (inWs && !ws) {
                breaks0[brIx++] = charIx + begin;
            }
            inWs = ws;
            ++charIx;
            c = ci.next();
        }
        if (this.text.length > 0) {
            breaks0[brIx++] = this.text.length + begin;
        }
        this.breaks = new int[brIx];
        System.arraycopy(breaks0, 0, this.breaks, 0, brIx);
    }

    @Override
    public CharacterIterator getText() {
        return new StringCharacterIterator(new String(this.text));
    }

    @Override
    public int first() {
        this.pos = 0;
        return this.breaks[0];
    }

    @Override
    public int last() {
        this.pos = this.breaks.length - 1;
        return this.breaks[this.pos];
    }

    @Override
    public int current() {
        return this.breaks[this.pos];
    }

    @Override
    public int next() {
        return this.pos == this.breaks.length - 1 ? -1 : this.breaks[++this.pos];
    }

    @Override
    public int previous() {
        return this.pos == 0 ? -1 : this.breaks[--this.pos];
    }

    @Override
    public int next(int n) {
        return this.checkhit(this.pos + n);
    }

    @Override
    public int following(int n) {
        return this.adjacent(n, 1);
    }

    @Override
    public int preceding(int n) {
        return this.adjacent(n, -1);
    }

    private int checkhit(int hit) {
        if (hit < 0 || hit >= this.breaks.length) {
            return -1;
        }
        this.pos = hit;
        return this.breaks[this.pos];
    }

    private int adjacent(int n, int bias) {
        int hit = Arrays.binarySearch(this.breaks, n);
        int offset = hit < 0 ? (bias < 0 ? -1 : -2) : 0;
        return this.checkhit(Math.abs(hit) + bias + offset);
    }
}

