/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.cert.X509Certificate;
import sun.security.provider.certpath.Vertex;

public class BuildStep {
    private Vertex vertex;
    private X509Certificate cert;
    private Throwable throwable;
    private int result;
    public static final int POSSIBLE = 1;
    public static final int BACK = 2;
    public static final int FOLLOW = 3;
    public static final int FAIL = 4;
    public static final int SUCCEED = 5;

    public BuildStep(Vertex vtx, int res) {
        this.vertex = vtx;
        if (this.vertex != null) {
            this.cert = this.vertex.getCertificate();
            this.throwable = this.vertex.getThrowable();
        }
        this.result = res;
    }

    public Vertex getVertex() {
        return this.vertex;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public String getIssuerName() {
        return this.getIssuerName(null);
    }

    public String getIssuerName(String defaultName) {
        return this.cert == null ? defaultName : this.cert.getIssuerX500Principal().toString();
    }

    public String getSubjectName() {
        return this.getSubjectName(null);
    }

    public String getSubjectName(String defaultName) {
        return this.cert == null ? defaultName : this.cert.getSubjectX500Principal().toString();
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public int getResult() {
        return this.result;
    }

    public String resultToString(int res) {
        String resultString = "";
        switch (res) {
            case 1: {
                resultString = "Certificate to be tried.\n";
                break;
            }
            case 2: {
                resultString = "Certificate backed out since path does not satisfy build requirements.\n";
                break;
            }
            case 3: {
                resultString = "Certificate satisfies conditions.\n";
                break;
            }
            case 4: {
                resultString = "Certificate backed out since path does not satisfy conditions.\n";
                break;
            }
            case 5: {
                resultString = "Certificate satisfies conditions.\n";
                break;
            }
            default: {
                resultString = "Internal error: Invalid step result value.\n";
            }
        }
        return resultString;
    }

    public String toString() {
        String out = "Internal Error\n";
        switch (this.result) {
            case 2: 
            case 4: {
                out = this.resultToString(this.result);
                out = out + this.vertex.throwableToString();
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                out = this.resultToString(this.result);
                break;
            }
            default: {
                out = "Internal Error: Invalid step result\n";
            }
        }
        return out;
    }

    public String verboseToString() {
        String out = this.resultToString(this.getResult());
        switch (this.result) {
            case 2: 
            case 4: {
                out = out + this.vertex.throwableToString();
                break;
            }
            case 3: 
            case 5: {
                out = out + this.vertex.moreToString();
                break;
            }
            case 1: {
                break;
            }
        }
        out = out + "Certificate contains:\n" + this.vertex.certToString();
        return out;
    }

    public String fullToString() {
        return this.resultToString(this.getResult()) + this.vertex.toString();
    }
}

