/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.GeneralNameInterface;

public class X400Address
implements GeneralNameInterface {
    byte[] nameValue = null;

    public X400Address(byte[] value) {
        this.nameValue = value;
    }

    public X400Address(DerValue derValue) throws IOException {
        this.nameValue = derValue.toByteArray();
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public void encode(DerOutputStream out) throws IOException {
        DerValue derValue = new DerValue(this.nameValue);
        out.putDerValue(derValue);
    }

    public String toString() {
        return "X400Address: <DER-encoded value>";
    }

    @Override
    public int constrains(GeneralNameInterface inputName) throws UnsupportedOperationException {
        int constraintType;
        if (inputName == null) {
            constraintType = -1;
        } else if (inputName.getType() != 3) {
            constraintType = -1;
        } else {
            throw new UnsupportedOperationException("Narrowing, widening, and match are not supported for X400Address.");
        }
        return constraintType;
    }

    @Override
    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth not supported for X400Address");
    }
}

