/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eggs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.ImageParameter;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class PSystemEgg
extends AbstractPSystem {
    private final List<String> strings = new ArrayList<String>();

    PSystemEgg(String sentence) {
        StringTokenizer st = new StringTokenizer(sentence, "|");
        while (st.hasMoreTokens()) {
            this.strings.add(st.nextToken());
        }
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        TextBlockBackcolored result = this.getGraphicStrings();
        HColor backcolor = result.getBackcolor();
        ImageParameter imageParameter = new ImageParameter(new ColorMapperIdentity(), false, null, 1.0, this.getMetadata(), null, ClockwiseTopRightBottomLeft.none(), backcolor);
        ImageBuilder imageBuilder = ImageBuilder.build(imageParameter);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    private TextBlockBackcolored getGraphicStrings() throws IOException {
        return GraphicStrings.createBlackOnWhite(this.strings);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Easter Eggs)");
    }
}

