/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jdot;

import h.ST_Agedge_s;
import h.ST_Agedgeinfo_t;
import h.ST_Agnode_s;
import h.ST_Agnodeinfo_t;
import h.ST_bezier;
import h.ST_pointf;
import h.ST_splines;
import h.ST_textlabel_t;
import smetana.core.Macro;

public class DebugUtils {
    public static void printDebugEdge(ST_Agedge_s e) {
        ST_Agedgeinfo_t data = (ST_Agedgeinfo_t)Macro.AGDATA(e).castTo(ST_Agedgeinfo_t.class);
        ST_splines splines = data.spl;
        System.err.println("splines.size=" + splines.size);
        DebugUtils.printDebugBezier(splines.list.get__(0));
        ST_textlabel_t label = data.label;
        if (label != null) {
            System.err.println("LABEL dimen=" + DebugUtils.pointftoString(label.dimen));
            System.err.println("LABEL space=" + DebugUtils.pointftoString(label.space));
            System.err.println("LABEL pos=" + DebugUtils.pointftoString(label.pos));
        }
    }

    public static void printDebugBezier(ST_bezier bezier) {
        System.err.println("bezier.size=" + bezier.size);
        System.err.println("bezier.sflag=" + bezier.sflag);
        System.err.println("splines.eflag=" + bezier.eflag);
        System.err.println("bezier.sp=" + DebugUtils.pointftoString(bezier.sp));
        System.err.println("bezier.ep=" + DebugUtils.pointftoString(bezier.ep));
        for (int i = 0; i < bezier.size; ++i) {
            ST_pointf pt = bezier.list.get__(i);
            System.err.println("pt=" + DebugUtils.pointftoString(pt));
        }
    }

    public static void printDebugNode(ST_Agnode_s n) {
        System.err.println("*********** PRINT NODE ********** ");
        ST_Agnodeinfo_t data = (ST_Agnodeinfo_t)Macro.AGDATA(n).castTo(ST_Agnodeinfo_t.class);
        System.err.println("width=" + data.width);
        System.err.println("height=" + data.height);
        System.err.println("ht=" + data.ht);
        System.err.println("lw=" + data.lw);
        System.err.println("rw=" + data.rw);
        System.err.println("coord=" + DebugUtils.pointftoString(data.coord));
    }

    public static String pointftoString(ST_pointf point) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(point.x);
        sb.append(" ; ");
        sb.append(point.y);
        sb.append(")");
        return sb.toString();
    }
}

