/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jsondiagram;

import java.util.ArrayList;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.command.PSystemAbstractFactory;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.json.Json;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.json.ParseException;
import net.sourceforge.plantuml.jsondiagram.JsonDiagram;
import net.sourceforge.plantuml.version.IteratorCounter2;

public class JsonDiagramFactory
extends PSystemAbstractFactory {
    public JsonDiagramFactory() {
        super(DiagramType.JSON);
    }

    @Override
    public Diagram createSystem(UmlSource source) {
        JsonValue json;
        ArrayList<String> highlighted = new ArrayList<String>();
        try {
            StringBuilder sb = new StringBuilder();
            IteratorCounter2 it = source.iterator2();
            it.next();
            while (true) {
                String line = ((StringLocated)it.next()).getString();
                if (!it.hasNext()) break;
                if (line.startsWith("#")) {
                    if (!line.startsWith("#highlight ")) continue;
                    highlighted.add(line.substring("#highlight ".length()).trim());
                    continue;
                }
                sb.append(line);
                sb.append('\n');
            }
            json = Json.parse(sb.toString());
        }
        catch (ParseException e) {
            json = null;
        }
        return new JsonDiagram(json, highlighted);
    }
}

