/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.tim.Eater;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterExceptionLocated;
import net.sourceforge.plantuml.tim.StringEater;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.tim.expression.TokenStack;

public class EaterFunctionCall
extends Eater {
    private final List<TValue> values = new ArrayList<TValue>();
    private final Map<String, TValue> namedArguments = new HashMap<String, TValue>();
    private final boolean isLegacyDefine;
    private final boolean unquoted;

    public EaterFunctionCall(StringLocated s, boolean isLegacyDefine, boolean unquoted) {
        super(s);
        this.isLegacyDefine = isLegacyDefine;
        this.unquoted = unquoted;
    }

    @Override
    public void analyze(TContext context, TMemory memory) throws EaterException, EaterExceptionLocated {
        char ch;
        this.skipUntilChar('(');
        this.checkAndEatChar('(');
        this.skipSpaces();
        if (this.peekChar() == ')') {
            this.checkAndEatChar(')');
            return;
        }
        do {
            TValue result;
            String value;
            String read;
            this.skipSpaces();
            if (this.isLegacyDefine) {
                read = this.eatAndGetOptionalQuotedString();
                value = context.applyFunctionsAndVariables(memory, this.getLineLocation(), read);
                result = TValue.fromString(value);
                this.values.add(result);
            } else if (this.unquoted) {
                read = this.eatAndGetOptionalQuotedString();
                if (TokenStack.isSpecialAffectationWhenFunctionCall(read)) {
                    this.updateNamedArguments(read, context, memory);
                } else {
                    value = context.applyFunctionsAndVariables(memory, this.getLineLocation(), read);
                    result = TValue.fromString(value);
                    this.values.add(result);
                }
            } else {
                TokenStack tokens = TokenStack.eatUntilCloseParenthesisOrComma(this).withoutSpace();
                if (tokens.isSpecialAffectationWhenFunctionCall()) {
                    String special = tokens.tokenIterator().nextToken().getSurface();
                    this.updateNamedArguments(special, context, memory);
                } else {
                    tokens.guessFunctions();
                    TValue result2 = tokens.getResult(this.getLineLocation(), context, memory);
                    this.values.add(result2);
                }
            }
            this.skipSpaces();
        } while ((ch = this.eatOneChar()) == ',');
        if (ch != ')') {
            if (this.unquoted) {
                throw EaterException.located("unquoted function/procedure cannot use expression.");
            }
            throw EaterException.located("call001");
        }
    }

    private void updateNamedArguments(String special, TContext context, TMemory memory) throws EaterException, EaterExceptionLocated {
        assert (special.contains("="));
        StringEater stringEater = new StringEater(special);
        String varname = stringEater.eatAndGetVarname();
        stringEater.checkAndEatChar('=');
        TValue expr = stringEater.eatExpression(context, memory);
        this.namedArguments.put(varname, expr);
    }

    public final List<TValue> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public final Map<String, TValue> getNamedArguments() {
        return Collections.unmodifiableMap(this.namedArguments);
    }

    public final String getEndOfLine() throws EaterException {
        return this.eatAllToEnd();
    }
}

