/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import com.sun.jmx.defaults.JmxProperties;
import java.util.logging.Level;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.monitor.CounterMonitorMBean;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;

public class CounterMonitor
extends Monitor
implements CounterMonitorMBean {
    private Number modulus = INTEGER_ZERO;
    private Number offset = INTEGER_ZERO;
    private boolean notify = false;
    private boolean differenceMode = false;
    private Number initThreshold = INTEGER_ZERO;
    private static final String[] types = new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.error.threshold", "jmx.monitor.counter.threshold"};
    private static final MBeanNotificationInfo[] notifsInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, "javax.management.monitor.MonitorNotification", "Notifications sent by the CounterMonitor MBean")};

    @Override
    public synchronized void start() {
        if (this.isActive()) {
            JmxProperties.MONITOR_LOGGER.logp(Level.FINER, CounterMonitor.class.getName(), "start", "the monitor is already active");
            return;
        }
        for (Monitor.ObservedObject o : this.observedObjects) {
            CounterMonitorObservedObject cmo = (CounterMonitorObservedObject)o;
            cmo.setThreshold(this.initThreshold);
            cmo.setModulusExceeded(false);
            cmo.setEventAlreadyNotified(false);
            cmo.setPreviousScanCounter(null);
        }
        this.doStart();
    }

    @Override
    public synchronized void stop() {
        this.doStop();
    }

    @Override
    public synchronized Number getDerivedGauge(ObjectName object) {
        return (Number)super.getDerivedGauge(object);
    }

    @Override
    public synchronized long getDerivedGaugeTimeStamp(ObjectName object) {
        return super.getDerivedGaugeTimeStamp(object);
    }

    @Override
    public synchronized Number getThreshold(ObjectName object) {
        CounterMonitorObservedObject o = (CounterMonitorObservedObject)this.getObservedObject(object);
        if (o == null) {
            return null;
        }
        if (this.offset.longValue() > 0L && this.modulus.longValue() > 0L && o.getThreshold().longValue() > this.modulus.longValue()) {
            return this.initThreshold;
        }
        return o.getThreshold();
    }

    @Override
    public synchronized Number getInitThreshold() {
        return this.initThreshold;
    }

    @Override
    public synchronized void setInitThreshold(Number value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Null threshold");
        }
        if (value.longValue() < 0L) {
            throw new IllegalArgumentException("Negative threshold");
        }
        if (this.initThreshold.equals(value)) {
            return;
        }
        this.initThreshold = value;
        int index = 0;
        for (Monitor.ObservedObject o : this.observedObjects) {
            this.resetAlreadyNotified(o, index++, 16);
            CounterMonitorObservedObject cmo = (CounterMonitorObservedObject)o;
            cmo.setThreshold(value);
            cmo.setModulusExceeded(false);
            cmo.setEventAlreadyNotified(false);
        }
    }

    @Override
    @Deprecated
    public synchronized Number getDerivedGauge() {
        if (this.observedObjects.isEmpty()) {
            return null;
        }
        return (Number)((Monitor.ObservedObject)this.observedObjects.get(0)).getDerivedGauge();
    }

    @Override
    @Deprecated
    public synchronized long getDerivedGaugeTimeStamp() {
        if (this.observedObjects.isEmpty()) {
            return 0L;
        }
        return ((Monitor.ObservedObject)this.observedObjects.get(0)).getDerivedGaugeTimeStamp();
    }

    @Override
    @Deprecated
    public synchronized Number getThreshold() {
        return this.getThreshold(this.getObservedObject());
    }

    @Override
    @Deprecated
    public synchronized void setThreshold(Number value) throws IllegalArgumentException {
        this.setInitThreshold(value);
    }

    @Override
    public synchronized Number getOffset() {
        return this.offset;
    }

    @Override
    public synchronized void setOffset(Number value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Null offset");
        }
        if (value.longValue() < 0L) {
            throw new IllegalArgumentException("Negative offset");
        }
        if (this.offset.equals(value)) {
            return;
        }
        this.offset = value;
        int index = 0;
        for (Monitor.ObservedObject o : this.observedObjects) {
            this.resetAlreadyNotified(o, index++, 16);
        }
    }

    @Override
    public synchronized Number getModulus() {
        return this.modulus;
    }

    @Override
    public synchronized void setModulus(Number value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Null modulus");
        }
        if (value.longValue() < 0L) {
            throw new IllegalArgumentException("Negative modulus");
        }
        if (this.modulus.equals(value)) {
            return;
        }
        this.modulus = value;
        int index = 0;
        for (Monitor.ObservedObject o : this.observedObjects) {
            this.resetAlreadyNotified(o, index++, 16);
            CounterMonitorObservedObject cmo = (CounterMonitorObservedObject)o;
            cmo.setModulusExceeded(false);
        }
    }

    @Override
    public synchronized boolean getNotify() {
        return this.notify;
    }

    @Override
    public synchronized void setNotify(boolean value) {
        if (this.notify == value) {
            return;
        }
        this.notify = value;
    }

    @Override
    public synchronized boolean getDifferenceMode() {
        return this.differenceMode;
    }

    @Override
    public synchronized void setDifferenceMode(boolean value) {
        if (this.differenceMode == value) {
            return;
        }
        this.differenceMode = value;
        for (Monitor.ObservedObject o : this.observedObjects) {
            CounterMonitorObservedObject cmo = (CounterMonitorObservedObject)o;
            cmo.setThreshold(this.initThreshold);
            cmo.setModulusExceeded(false);
            cmo.setEventAlreadyNotified(false);
            cmo.setPreviousScanCounter(null);
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return (MBeanNotificationInfo[])notifsInfo.clone();
    }

    private synchronized boolean updateDerivedGauge(Object scanCounter, CounterMonitorObservedObject o) {
        boolean is_derived_gauge_valid;
        if (this.differenceMode) {
            if (o.getPreviousScanCounter() != null) {
                this.setDerivedGaugeWithDifference((Number)scanCounter, null, o);
                if (((Number)o.getDerivedGauge()).longValue() < 0L) {
                    if (this.modulus.longValue() > 0L) {
                        this.setDerivedGaugeWithDifference((Number)scanCounter, this.modulus, o);
                    }
                    o.setThreshold(this.initThreshold);
                    o.setEventAlreadyNotified(false);
                }
                is_derived_gauge_valid = true;
            } else {
                is_derived_gauge_valid = false;
            }
            o.setPreviousScanCounter((Number)scanCounter);
        } else {
            o.setDerivedGauge((Number)scanCounter);
            is_derived_gauge_valid = true;
        }
        return is_derived_gauge_valid;
    }

    private synchronized MonitorNotification updateNotifications(CounterMonitorObservedObject o) {
        MonitorNotification n = null;
        if (!o.getEventAlreadyNotified()) {
            if (((Number)o.getDerivedGauge()).longValue() >= o.getThreshold().longValue()) {
                if (this.notify) {
                    n = new MonitorNotification("jmx.monitor.counter.threshold", this, 0L, 0L, "", null, null, null, o.getThreshold());
                }
                if (!this.differenceMode) {
                    o.setEventAlreadyNotified(true);
                }
            }
        } else if (JmxProperties.MONITOR_LOGGER.isLoggable(Level.FINER)) {
            StringBuilder strb = new StringBuilder().append("The notification:").append("\n\tNotification observed object = ").append(o.getObservedObject()).append("\n\tNotification observed attribute = ").append(this.getObservedAttribute()).append("\n\tNotification threshold level = ").append(o.getThreshold()).append("\n\tNotification derived gauge = ").append(o.getDerivedGauge()).append("\nhas already been sent");
            JmxProperties.MONITOR_LOGGER.logp(Level.FINER, CounterMonitor.class.getName(), "updateNotifications", strb.toString());
        }
        return n;
    }

    private synchronized void updateThreshold(CounterMonitorObservedObject o) {
        if (((Number)o.getDerivedGauge()).longValue() >= o.getThreshold().longValue()) {
            if (this.offset.longValue() > 0L) {
                long threshold_value;
                for (threshold_value = o.getThreshold().longValue(); ((Number)o.getDerivedGauge()).longValue() >= threshold_value; threshold_value += this.offset.longValue()) {
                }
                switch (o.getType()) {
                    case INTEGER: {
                        o.setThreshold((int)threshold_value);
                        break;
                    }
                    case BYTE: {
                        o.setThreshold((byte)threshold_value);
                        break;
                    }
                    case SHORT: {
                        o.setThreshold((short)threshold_value);
                        break;
                    }
                    case LONG: {
                        o.setThreshold(threshold_value);
                        break;
                    }
                    default: {
                        JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, CounterMonitor.class.getName(), "updateThreshold", "the threshold type is invalid");
                    }
                }
                if (!this.differenceMode && this.modulus.longValue() > 0L && o.getThreshold().longValue() > this.modulus.longValue()) {
                    o.setModulusExceeded(true);
                    o.setDerivedGaugeExceeded((Number)o.getDerivedGauge());
                }
                o.setEventAlreadyNotified(false);
            } else {
                o.setModulusExceeded(true);
                o.setDerivedGaugeExceeded((Number)o.getDerivedGauge());
            }
        }
    }

    private synchronized void setDerivedGaugeWithDifference(Number scanCounter, Number mod, CounterMonitorObservedObject o) {
        long derived = scanCounter.longValue() - o.getPreviousScanCounter().longValue();
        if (mod != null) {
            derived += this.modulus.longValue();
        }
        switch (o.getType()) {
            case INTEGER: {
                o.setDerivedGauge((int)derived);
                break;
            }
            case BYTE: {
                o.setDerivedGauge((byte)derived);
                break;
            }
            case SHORT: {
                o.setDerivedGauge((short)derived);
                break;
            }
            case LONG: {
                o.setDerivedGauge(derived);
                break;
            }
            default: {
                JmxProperties.MONITOR_LOGGER.logp(Level.FINEST, CounterMonitor.class.getName(), "setDerivedGaugeWithDifference", "the threshold type is invalid");
            }
        }
    }

    @Override
    Monitor.ObservedObject createObservedObject(ObjectName object) {
        CounterMonitorObservedObject cmo = new CounterMonitorObservedObject(object);
        cmo.setThreshold(this.initThreshold);
        cmo.setModulusExceeded(false);
        cmo.setEventAlreadyNotified(false);
        cmo.setPreviousScanCounter(null);
        return cmo;
    }

    @Override
    synchronized boolean isComparableTypeValid(ObjectName object, String attribute, Comparable<?> value) {
        CounterMonitorObservedObject o = (CounterMonitorObservedObject)this.getObservedObject(object);
        if (o == null) {
            return false;
        }
        if (value instanceof Integer) {
            o.setType(Monitor.NumericalType.INTEGER);
        } else if (value instanceof Byte) {
            o.setType(Monitor.NumericalType.BYTE);
        } else if (value instanceof Short) {
            o.setType(Monitor.NumericalType.SHORT);
        } else if (value instanceof Long) {
            o.setType(Monitor.NumericalType.LONG);
        } else {
            return false;
        }
        return true;
    }

    @Override
    synchronized Comparable<?> getDerivedGaugeFromComparable(ObjectName object, String attribute, Comparable<?> value) {
        CounterMonitorObservedObject o = (CounterMonitorObservedObject)this.getObservedObject(object);
        if (o == null) {
            return null;
        }
        if (o.getModulusExceeded() && ((Number)o.getDerivedGauge()).longValue() < o.getDerivedGaugeExceeded().longValue()) {
            o.setThreshold(this.initThreshold);
            o.setModulusExceeded(false);
            o.setEventAlreadyNotified(false);
        }
        o.setDerivedGaugeValid(this.updateDerivedGauge(value, o));
        return (Comparable)o.getDerivedGauge();
    }

    @Override
    synchronized void onErrorNotification(MonitorNotification notification) {
        CounterMonitorObservedObject o = (CounterMonitorObservedObject)this.getObservedObject(notification.getObservedObject());
        if (o == null) {
            return;
        }
        o.setModulusExceeded(false);
        o.setEventAlreadyNotified(false);
        o.setPreviousScanCounter(null);
    }

    @Override
    synchronized MonitorNotification buildAlarmNotification(ObjectName object, String attribute, Comparable<?> value) {
        MonitorNotification alarm;
        CounterMonitorObservedObject o = (CounterMonitorObservedObject)this.getObservedObject(object);
        if (o == null) {
            return null;
        }
        if (o.getDerivedGaugeValid()) {
            alarm = this.updateNotifications(o);
            this.updateThreshold(o);
        } else {
            alarm = null;
        }
        return alarm;
    }

    @Override
    synchronized boolean isThresholdTypeValid(ObjectName object, String attribute, Comparable<?> value) {
        CounterMonitorObservedObject o = (CounterMonitorObservedObject)this.getObservedObject(object);
        if (o == null) {
            return false;
        }
        Class<? extends Number> c = CounterMonitor.classForType(o.getType());
        return c.isInstance(o.getThreshold()) && CounterMonitor.isValidForType(this.offset, c) && CounterMonitor.isValidForType(this.modulus, c);
    }

    static class CounterMonitorObservedObject
    extends Monitor.ObservedObject {
        private Number threshold;
        private Number previousScanCounter;
        private boolean modulusExceeded;
        private Number derivedGaugeExceeded;
        private boolean derivedGaugeValid;
        private boolean eventAlreadyNotified;
        private Monitor.NumericalType type;

        public CounterMonitorObservedObject(ObjectName observedObject) {
            super(observedObject);
        }

        public final synchronized Number getThreshold() {
            return this.threshold;
        }

        public final synchronized void setThreshold(Number threshold) {
            this.threshold = threshold;
        }

        public final synchronized Number getPreviousScanCounter() {
            return this.previousScanCounter;
        }

        public final synchronized void setPreviousScanCounter(Number previousScanCounter) {
            this.previousScanCounter = previousScanCounter;
        }

        public final synchronized boolean getModulusExceeded() {
            return this.modulusExceeded;
        }

        public final synchronized void setModulusExceeded(boolean modulusExceeded) {
            this.modulusExceeded = modulusExceeded;
        }

        public final synchronized Number getDerivedGaugeExceeded() {
            return this.derivedGaugeExceeded;
        }

        public final synchronized void setDerivedGaugeExceeded(Number derivedGaugeExceeded) {
            this.derivedGaugeExceeded = derivedGaugeExceeded;
        }

        public final synchronized boolean getDerivedGaugeValid() {
            return this.derivedGaugeValid;
        }

        public final synchronized void setDerivedGaugeValid(boolean derivedGaugeValid) {
            this.derivedGaugeValid = derivedGaugeValid;
        }

        public final synchronized boolean getEventAlreadyNotified() {
            return this.eventAlreadyNotified;
        }

        public final synchronized void setEventAlreadyNotified(boolean eventAlreadyNotified) {
            this.eventAlreadyNotified = eventAlreadyNotified;
        }

        public final synchronized Monitor.NumericalType getType() {
            return this.type;
        }

        public final synchronized void setType(Monitor.NumericalType type) {
            this.type = type;
        }
    }
}

